/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.time;

import java.text.ParsePosition;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.opensearch.common.Strings;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateFormatters;
import org.opensearch.common.time.DateMathParser;
import org.opensearch.common.time.JavaDateMathParser;

class JavaDateFormatter
implements DateFormatter {
    private static final Map<TemporalField, Long> ROUND_UP_GENERIC_BASE_FIELDS = new HashMap<TemporalField, Long>(4);
    private final String format;
    private final DateTimeFormatter printer;
    private final List<DateTimeFormatter> parsers;
    private final JavaDateFormatter roundupParser;
    private static final BiConsumer<DateTimeFormatterBuilder, DateTimeFormatter> ROUND_UP_BASE_FIELDS = (builder, parser) -> {
        String parserString = parser.toString();
        if (parserString.contains(ChronoField.DAY_OF_YEAR.toString())) {
            builder.parseDefaulting(ChronoField.DAY_OF_YEAR, 1L);
        } else {
            builder.parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L);
            builder.parseDefaulting(ChronoField.DAY_OF_MONTH, 1L);
        }
        ROUND_UP_GENERIC_BASE_FIELDS.forEach(builder::parseDefaulting);
    };

    JavaDateFormatter(String format, DateTimeFormatter printer, DateTimeFormatter ... parsers) {
        this(format, printer, ROUND_UP_BASE_FIELDS, parsers);
    }

    JavaDateFormatter(String format, DateTimeFormatter printer, BiConsumer<DateTimeFormatterBuilder, DateTimeFormatter> roundupParserConsumer, DateTimeFormatter ... parsers) {
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.HOUR_OF_DAY, 23L);
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.MINUTE_OF_HOUR, 59L);
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.SECOND_OF_MINUTE, 59L);
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.NANO_OF_SECOND, 999999999L);
        if (printer == null) {
            throw new IllegalArgumentException("printer may not be null");
        }
        long distinctZones = Arrays.stream(parsers).map(DateTimeFormatter::getZone).distinct().count();
        if (distinctZones > 1L) {
            throw new IllegalArgumentException("formatters must have the same time zone");
        }
        long distinctLocales = Arrays.stream(parsers).map(DateTimeFormatter::getLocale).distinct().count();
        if (distinctLocales > 1L) {
            throw new IllegalArgumentException("formatters must have the same locale");
        }
        this.printer = printer;
        this.format = format;
        this.parsers = parsers.length == 0 ? Collections.singletonList(printer) : Arrays.asList(parsers);
        List<DateTimeFormatter> roundUp = this.createRoundUpParser(format, roundupParserConsumer);
        this.roundupParser = new RoundUpFormatter(format, roundUp);
    }

    private List<DateTimeFormatter> createRoundUpParser(String format, BiConsumer<DateTimeFormatterBuilder, DateTimeFormatter> roundupParserConsumer) {
        if (!format.contains("||")) {
            ArrayList<DateTimeFormatter> roundUpParsers = new ArrayList<DateTimeFormatter>();
            for (DateTimeFormatter parser : this.parsers) {
                DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
                builder.append(parser);
                roundupParserConsumer.accept(builder, parser);
                roundUpParsers.add(builder.toFormatter(this.locale()));
            }
            return roundUpParsers;
        }
        return null;
    }

    public static DateFormatter combined(String input, List<DateFormatter> formatters) {
        assert (formatters.size() > 0);
        ArrayList<DateTimeFormatter> parsers = new ArrayList<DateTimeFormatter>(formatters.size());
        ArrayList<DateTimeFormatter> roundUpParsers = new ArrayList<DateTimeFormatter>(formatters.size());
        DateTimeFormatter printer = null;
        for (DateFormatter formatter : formatters) {
            assert (formatter instanceof JavaDateFormatter);
            JavaDateFormatter javaDateFormatter = (JavaDateFormatter)formatter;
            if (printer == null) {
                printer = javaDateFormatter.getPrinter();
            }
            parsers.addAll(javaDateFormatter.getParsers());
            roundUpParsers.addAll(javaDateFormatter.getRoundupParser().getParsers());
        }
        return new JavaDateFormatter(input, printer, roundUpParsers, parsers);
    }

    private JavaDateFormatter(String format, DateTimeFormatter printer, List<DateTimeFormatter> roundUpParsers, List<DateTimeFormatter> parsers) {
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.HOUR_OF_DAY, 23L);
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.MINUTE_OF_HOUR, 59L);
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.SECOND_OF_MINUTE, 59L);
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.NANO_OF_SECOND, 999999999L);
        this.format = format;
        this.printer = printer;
        this.roundupParser = roundUpParsers != null ? new RoundUpFormatter(format, roundUpParsers) : null;
        this.parsers = parsers;
    }

    JavaDateFormatter getRoundupParser() {
        return this.roundupParser;
    }

    DateTimeFormatter getPrinter() {
        return this.printer;
    }

    @Override
    public TemporalAccessor parse(String input) {
        if (Strings.isNullOrEmpty(input)) {
            throw new IllegalArgumentException("cannot parse empty date");
        }
        try {
            return this.doParse(input);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("failed to parse date field [" + input + "] with format [" + this.format + "]", e);
        }
    }

    private TemporalAccessor doParse(String input) {
        if (this.parsers.size() > 1) {
            for (DateTimeFormatter formatter : this.parsers) {
                ParsePosition pos = new ParsePosition(0);
                Object object = formatter.toFormat().parseObject(input, pos);
                if (!this.parsingSucceeded(object, input, pos)) continue;
                return (TemporalAccessor)object;
            }
            throw new DateTimeParseException("Failed to parse with all enclosed parsers", input, 0);
        }
        return this.parsers.get(0).parse(input);
    }

    private boolean parsingSucceeded(Object object, String input, ParsePosition pos) {
        return object != null && pos.getIndex() == input.length();
    }

    @Override
    public DateFormatter withZone(ZoneId zoneId) {
        if (zoneId.equals(this.zone())) {
            return this;
        }
        List<DateTimeFormatter> parsers = this.parsers.stream().map(p -> p.withZone(zoneId)).collect(Collectors.toList());
        List<DateTimeFormatter> roundUpParsers = this.roundupParser.getParsers().stream().map(p -> p.withZone(zoneId)).collect(Collectors.toList());
        return new JavaDateFormatter(this.format, this.printer.withZone(zoneId), roundUpParsers, parsers);
    }

    @Override
    public DateFormatter withLocale(Locale locale) {
        if (locale.equals(this.locale())) {
            return this;
        }
        List<DateTimeFormatter> parsers = this.parsers.stream().map(p -> p.withLocale(locale)).collect(Collectors.toList());
        List<DateTimeFormatter> roundUpParsers = this.roundupParser.getParsers().stream().map(p -> p.withLocale(locale)).collect(Collectors.toList());
        return new JavaDateFormatter(this.format, this.printer.withLocale(locale), roundUpParsers, parsers);
    }

    @Override
    public String format(TemporalAccessor accessor) {
        return this.printer.format(DateFormatters.from(accessor));
    }

    @Override
    public String pattern() {
        return this.format;
    }

    @Override
    public Locale locale() {
        return this.printer.getLocale();
    }

    @Override
    public ZoneId zone() {
        return this.printer.getZone();
    }

    @Override
    public DateMathParser toDateMathParser() {
        return new JavaDateMathParser(this.format, this, this.getRoundupParser());
    }

    public int hashCode() {
        return Objects.hash(this.locale(), this.printer.getZone(), this.format);
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        JavaDateFormatter other = (JavaDateFormatter)obj;
        return Objects.equals(this.format, other.format) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.printer.getZone(), other.printer.getZone());
    }

    public String toString() {
        return String.format(Locale.ROOT, "format[%s] locale[%s]", this.format, this.locale());
    }

    Collection<DateTimeFormatter> getParsers() {
        return this.parsers;
    }

    static class RoundUpFormatter
    extends JavaDateFormatter {
        RoundUpFormatter(String format, List<DateTimeFormatter> roundUpParsers) {
            super(format, RoundUpFormatter.firstFrom(roundUpParsers), null, roundUpParsers);
        }

        private static DateTimeFormatter firstFrom(List<DateTimeFormatter> roundUpParsers) {
            return roundUpParsers.get(0);
        }

        @Override
        JavaDateFormatter getRoundupParser() {
            throw new UnsupportedOperationException("RoundUpFormatter does not have another roundUpFormatter");
        }
    }
}

