/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.opensearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.opensearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.InternalMultiTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.support.AggregationPath;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.internal.SearchContext;

public class MultiTermsAggregator
extends DeferableBucketAggregator {
    private final BytesKeyedBucketOrds bucketOrds;
    private final MultiTermsValuesSource multiTermsValue;
    private final boolean showTermDocCountError;
    private final List<DocValueFormat> formats;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final BucketOrder order;
    private final Comparator<InternalMultiTerms.Bucket> partiallyBuiltBucketComparator;
    private final Aggregator.SubAggCollectionMode collectMode;
    private final Set<Aggregator> aggsUsedForSorting = new HashSet<Aggregator>();

    public MultiTermsAggregator(String name, AggregatorFactories factories, boolean showTermDocCountError, List<InternalValuesSource> internalValuesSources, List<DocValueFormat> formats, BucketOrder order, Aggregator.SubAggCollectionMode collectMode, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, metadata);
        this.bucketOrds = BytesKeyedBucketOrds.build(context.bigArrays(), cardinality);
        this.multiTermsValue = new MultiTermsValuesSource(internalValuesSources);
        this.showTermDocCountError = showTermDocCountError;
        this.formats = formats;
        this.bucketCountThresholds = bucketCountThresholds;
        this.order = order;
        this.partiallyBuiltBucketComparator = order == null ? null : order.partiallyBuiltBucketComparator(b -> b.bucketOrd, this);
        this.collectMode = this.subAggsNeedScore() && TermsAggregator.descendsFromNestedAggregator(parent) ? Aggregator.SubAggCollectionMode.DEPTH_FIRST : collectMode;
        if (order instanceof InternalOrder.Aggregation) {
            AggregationPath path = ((InternalOrder.Aggregation)order).path();
            this.aggsUsedForSorting.add(path.resolveTopmostAggregator(this));
        } else if (order instanceof InternalOrder.CompoundOrder) {
            InternalOrder.CompoundOrder compoundOrder = (InternalOrder.CompoundOrder)order;
            for (BucketOrder orderElement : compoundOrder.orderElements()) {
                if (!(orderElement instanceof InternalOrder.Aggregation)) continue;
                AggregationPath path = ((InternalOrder.Aggregation)orderElement).path();
                this.aggsUsedForSorting.add(path.resolveTopmostAggregator(this));
            }
        }
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        InternalMultiTerms.Bucket[][] topBucketsPerOrd = new InternalMultiTerms.Bucket[owningBucketOrds.length][];
        long[] otherDocCounts = new long[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            this.collectZeroDocEntriesIfNeeded(owningBucketOrds[ordIdx]);
            long bucketsInOrd = this.bucketOrds.bucketsInOrd(owningBucketOrds[ordIdx]);
            int size = (int)Math.min(bucketsInOrd, (long)this.bucketCountThresholds.getShardSize());
            BucketPriorityQueue<InternalMultiTerms.Bucket> ordered = new BucketPriorityQueue<InternalMultiTerms.Bucket>(size, this.partiallyBuiltBucketComparator);
            InternalMultiTerms.Bucket spare = null;
            BytesRef dest = null;
            BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
            CheckedSupplier emptyBucketBuilder = () -> InternalMultiTerms.Bucket.EMPTY(this.showTermDocCountError, this.formats);
            while (ordsEnum.next()) {
                long docCount = this.bucketDocCount(ordsEnum.ord());
                int n = ordIdx;
                otherDocCounts[n] = otherDocCounts[n] + docCount;
                if (docCount < this.bucketCountThresholds.getShardMinDocCount()) continue;
                if (spare == null) {
                    spare = emptyBucketBuilder.get();
                    dest = new BytesRef();
                }
                ordsEnum.readValue(dest);
                spare.termValues = MultiTermsAggregator.decode(dest);
                spare.docCount = docCount;
                spare.bucketOrd = ordsEnum.ord();
                spare = (InternalMultiTerms.Bucket)ordered.insertWithOverflow(spare);
            }
            InternalMultiTerms.Bucket[] bucketsForOrd = new InternalMultiTerms.Bucket[ordered.size()];
            topBucketsPerOrd[ordIdx] = bucketsForOrd;
            for (int b2 = ordered.size() - 1; b2 >= 0; --b2) {
                topBucketsPerOrd[ordIdx][b2] = (InternalMultiTerms.Bucket)ordered.pop();
                int n = ordIdx;
                otherDocCounts[n] = otherDocCounts[n] - topBucketsPerOrd[ordIdx][b2].getDocCount();
            }
        }
        this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, aggs) -> {
            b.aggregations = aggs;
        });
        InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            result[ordIdx] = this.buildResult(owningBucketOrds[ordIdx], otherDocCounts[ordIdx], topBucketsPerOrd[ordIdx]);
        }
        return result;
    }

    InternalMultiTerms buildResult(long owningBucketOrd, long otherDocCount, InternalMultiTerms.Bucket[] topBuckets) {
        BucketOrder reduceOrder;
        if (!InternalOrder.isKeyOrder(this.order)) {
            reduceOrder = InternalOrder.key(true);
            Arrays.sort(topBuckets, reduceOrder.comparator());
        } else {
            reduceOrder = this.order;
        }
        return new InternalMultiTerms(this.name, reduceOrder, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.metadata(), this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, 0L, this.formats, org.opensearch.common.collect.List.of((Object[])topBuckets));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return null;
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final MultiTermsValuesSourceCollector collector = this.multiTermsValue.getValues(ctx);
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                for (List<Object> value : collector.apply(doc)) {
                    long bucketOrd = MultiTermsAggregator.this.bucketOrds.add(owningBucketOrd, MultiTermsAggregator.encode(value));
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                        MultiTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                        continue;
                    }
                    MultiTermsAggregator.this.collectBucket(sub, doc, bucketOrd);
                }
            }
        };
    }

    @Override
    protected void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    private static BytesRef encode(List<Object> values) {
        BytesStreamOutput output = new BytesStreamOutput();
        try {
            output.writeCollection(values, StreamOutput::writeGenericValue);
            BytesRef bytesRef = output.bytes().toBytesRef();
            output.close();
            return bytesRef;
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToRuntime(e);
            }
        }
    }

    private static List<Object> decode(BytesRef bytesRef) {
        List<Object> list;
        block8: {
            StreamInput input = new BytesArray(bytesRef).streamInput();
            try {
                list = input.readList(StreamInput::readGenericValue);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ExceptionsHelper.convertToRuntime(e);
                }
            }
            input.close();
        }
        return list;
    }

    private boolean subAggsNeedScore() {
        for (Aggregator subAgg : this.subAggregators) {
            if (!subAgg.scoreMode().needsScores()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return this.collectMode == Aggregator.SubAggCollectionMode.BREADTH_FIRST && !this.aggsUsedForSorting.contains(aggregator);
    }

    private void collectZeroDocEntriesIfNeeded(long owningBucketOrd) throws IOException {
        if (this.bucketCountThresholds.getMinDocCount() != 0L) {
            return;
        }
        if (InternalOrder.isCountDesc(this.order) && this.bucketOrds.bucketsInOrd(owningBucketOrd) >= (long)this.bucketCountThresholds.getRequiredSize()) {
            return;
        }
        for (LeafReaderContext ctx : this.context.searcher().getTopReaderContext().leaves()) {
            MultiTermsValuesSourceCollector collector = this.multiTermsValue.getValues(ctx);
            for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                for (List<Object> value : collector.apply(docId)) {
                    this.bucketOrds.add(owningBucketOrd, MultiTermsAggregator.encode(value));
                }
            }
        }
    }

    static class InternalValuesSourceFactory {
        InternalValuesSourceFactory() {
        }

        static InternalValuesSource bytesValuesSource(ValuesSource valuesSource, IncludeExclude.StringFilter includeExclude) {
            return ctx -> {
                SortedBinaryDocValues values = valuesSource.bytesValues(ctx);
                return doc -> {
                    BytesRefBuilder previous = new BytesRefBuilder();
                    if (!values.advanceExact(doc)) {
                        return Collections.emptyList();
                    }
                    int valuesCount = values.docValueCount();
                    ArrayList<BytesRef> termValues = new ArrayList<BytesRef>(valuesCount);
                    previous.clear();
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef bytes = values.nextValue();
                        if (includeExclude != null && !includeExclude.accept(bytes) || i > 0 && previous.get().equals((Object)bytes)) continue;
                        previous.copyBytes(bytes);
                        termValues.add(BytesRef.deepCopyOf((BytesRef)bytes));
                    }
                    return termValues;
                };
            };
        }

        static InternalValuesSource longValuesSource(ValuesSource.Numeric valuesSource, IncludeExclude.LongFilter longFilter) {
            return ctx -> {
                SortedNumericDocValues values = valuesSource.longValues(ctx);
                return doc -> {
                    if (values.advanceExact(doc)) {
                        int valuesCount = values.docValueCount();
                        long previous = Long.MAX_VALUE;
                        ArrayList<Long> termValues = new ArrayList<Long>(valuesCount);
                        for (int i = 0; i < valuesCount; ++i) {
                            long val = values.nextValue();
                            if (previous == val && i != 0) continue;
                            if (longFilter == null || longFilter.accept(val)) {
                                termValues.add(val);
                            }
                            previous = val;
                        }
                        return termValues;
                    }
                    return Collections.emptyList();
                };
            };
        }

        static InternalValuesSource doubleValueSource(ValuesSource.Numeric valuesSource, IncludeExclude.LongFilter longFilter) {
            return ctx -> {
                SortedNumericDoubleValues values = valuesSource.doubleValues(ctx);
                return doc -> {
                    if (values.advanceExact(doc)) {
                        int valuesCount = values.docValueCount();
                        double previous = Double.MAX_VALUE;
                        ArrayList<Double> termValues = new ArrayList<Double>(valuesCount);
                        for (int i = 0; i < valuesCount; ++i) {
                            double val = values.nextValue();
                            if (previous == val && i != 0) continue;
                            if (longFilter == null || longFilter.accept(NumericUtils.doubleToSortableLong((double)val))) {
                                termValues.add(val);
                            }
                            previous = val;
                        }
                        return termValues;
                    }
                    return Collections.emptyList();
                };
            };
        }
    }

    static class MultiTermsValuesSource {
        private final List<InternalValuesSource> valuesSources;

        public MultiTermsValuesSource(List<InternalValuesSource> valuesSources) {
            this.valuesSources = valuesSources;
        }

        public MultiTermsValuesSourceCollector getValues(LeafReaderContext ctx) throws IOException {
            final ArrayList<InternalValuesSourceCollector> collectors = new ArrayList<InternalValuesSourceCollector>();
            for (InternalValuesSource valuesSource : this.valuesSources) {
                collectors.add(valuesSource.apply(ctx));
            }
            return new MultiTermsValuesSourceCollector(){

                @Override
                public List<List<Object>> apply(int doc) throws IOException {
                    ArrayList<CheckedSupplier<List<Object>, IOException>> collectedValues = new ArrayList<CheckedSupplier<List<Object>, IOException>>();
                    for (InternalValuesSourceCollector collector : collectors) {
                        collectedValues.add(() -> collector.apply(doc));
                    }
                    ArrayList<List<Object>> result = new ArrayList<List<Object>>();
                    this.apply(0, collectedValues, new ArrayList<Object>(), result);
                    return result;
                }

                private void apply(int index, List<CheckedSupplier<List<Object>, IOException>> collectedValues, List<Object> current, List<List<Object>> results) throws IOException {
                    if (index == collectedValues.size()) {
                        results.add(org.opensearch.common.collect.List.copyOf(current));
                    } else if (null != collectedValues.get(index)) {
                        for (Object value : collectedValues.get(index).get()) {
                            current.add(value);
                            this.apply(index + 1, collectedValues, current, results);
                            current.remove(current.size() - 1);
                        }
                    }
                }
            };
        }
    }

    @FunctionalInterface
    static interface InternalValuesSourceCollector {
        public List<Object> apply(int var1) throws IOException;
    }

    @FunctionalInterface
    static interface InternalValuesSource {
        public InternalValuesSourceCollector apply(LeafReaderContext var1) throws IOException;
    }

    @FunctionalInterface
    static interface MultiTermsValuesSourceCollector {
        public List<List<Object>> apply(int var1) throws IOException;
    }
}

