/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tasks;

import org.opensearch.tasks.ResourceStatsType;
import org.opensearch.tasks.ResourceUsageInfo;
import org.opensearch.tasks.ResourceUsageMetric;

public class ThreadResourceInfo {
    private final long threadId;
    private volatile boolean isActive = true;
    private final ResourceStatsType statsType;
    private final ResourceUsageInfo resourceUsageInfo;

    public ThreadResourceInfo(long threadId, ResourceStatsType statsType, ResourceUsageMetric ... resourceUsageMetrics) {
        this.threadId = threadId;
        this.statsType = statsType;
        this.resourceUsageInfo = new ResourceUsageInfo(resourceUsageMetrics);
    }

    public void recordResourceUsageMetrics(ResourceUsageMetric ... resourceUsageMetrics) {
        this.resourceUsageInfo.recordResourceUsageMetrics(resourceUsageMetrics);
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public ResourceStatsType getStatsType() {
        return this.statsType;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public ResourceUsageInfo getResourceUsageInfo() {
        return this.resourceUsageInfo;
    }

    public String toString() {
        return this.resourceUsageInfo + ", stats_type=" + this.statsType + ", is_active=" + this.isActive + ", threadId=" + this.threadId;
    }
}

