/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RawCollationKey;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;

public final class ICUCollationDocValuesField
extends Field {
    private final String name;
    private final Collator collator;
    private final BytesRef bytes = new BytesRef();
    private final RawCollationKey key = new RawCollationKey();

    public ICUCollationDocValuesField(String name, Collator collator) {
        super(name, (IndexableFieldType)SortedDocValuesField.TYPE);
        this.name = name;
        try {
            this.collator = (Collator)collator.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        this.fieldsData = this.bytes;
    }

    public String name() {
        return this.name;
    }

    public void setStringValue(String value) {
        this.collator.getRawCollationKey(value, this.key);
        this.bytes.bytes = this.key.bytes;
        this.bytes.offset = 0;
        this.bytes.length = this.key.size;
    }
}

