/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.bytes.CompositeBytesReference;
import org.opensearch.common.bytes.ReleasableBytesReference;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.nio.BytesWriteHandler;
import org.opensearch.nio.InboundChannelBuffer;
import org.opensearch.nio.Page;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.InboundPipeline;
import org.opensearch.transport.TcpChannel;
import org.opensearch.transport.TcpTransport;
import org.opensearch.transport.Transport;
import org.opensearch.transport.nio.NioTcpChannel;

public class TcpReadWriteHandler
extends BytesWriteHandler {
    private final NioTcpChannel channel;
    private final InboundPipeline pipeline;

    public TcpReadWriteHandler(NioTcpChannel channel, PageCacheRecycler recycler, TcpTransport transport) {
        this.channel = channel;
        ThreadPool threadPool = transport.getThreadPool();
        Supplier breaker = transport.getInflightBreaker();
        Transport.RequestHandlers requestHandlers = transport.getRequestHandlers();
        this.pipeline = new InboundPipeline(transport.getVersion(), transport.getStatsTracker(), recycler, () -> ((ThreadPool)threadPool).relativeTimeInMillis(), breaker, arg_0 -> ((Transport.RequestHandlers)requestHandlers).getHandler(arg_0), (arg_0, arg_1) -> ((TcpTransport)transport).inboundMessage(arg_0, arg_1));
    }

    public int consumeReads(InboundChannelBuffer channelBuffer) throws IOException {
        Page[] pages = channelBuffer.sliceAndRetainPagesTo(channelBuffer.getIndex());
        BytesReference[] references = new BytesReference[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            references[i] = BytesReference.fromByteBuffer((ByteBuffer)pages[i].byteBuffer());
        }
        Releasable releasable = () -> IOUtils.closeWhileHandlingException((Closeable[])pages);
        try (ReleasableBytesReference reference = new ReleasableBytesReference(CompositeBytesReference.of((BytesReference[])references), releasable);){
            this.pipeline.handleBytes((TcpChannel)this.channel, reference);
            int n = reference.length();
            return n;
        }
    }

    public void close() {
        Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.pipeline});
        super.close();
    }
}

