/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.awt.Component;
import javax.swing.FocusManager;
import javax.swing.JPanel;
import org.coode.mdock.ComponentNode;
import org.coode.mdock.Node;
import org.coode.mdock.NodeLayout;
import org.coode.mdock.Splitter;
import org.coode.mdock.SplitterNode;

public class NodePanel
extends JPanel {
    private Node rootNode;

    public NodePanel(Node rootNode) {
        this.rootNode = rootNode;
        this.setLayout(new NodeLayout(rootNode));
        this.rebuild();
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void rebuild() {
        Component focusedComponent = FocusManager.getCurrentManager().getFocusOwner();
        this.removeAll();
        this.addNode(this.rootNode);
        this.revalidate();
        if (focusedComponent != null) {
            focusedComponent.requestFocus();
        }
    }

    private void addNode(Node node) {
        if (node instanceof ComponentNode) {
            this.add(((ComponentNode)node).getComponent());
        } else {
            for (Splitter splitter : ((SplitterNode)node).getSplitters()) {
                this.add(splitter);
            }
            for (Node curChildNode : ((SplitterNode)node).getVisibleChildren()) {
                this.addNode(curChildNode);
            }
        }
    }
}

