# The PEP 484 type hints stub file for the _server module.
#
# Generated by SIP 6.7.5
#
# 


import typing

import PyQt5.sip

from qgis import _core
from PyQt5 import QtXml
from PyQt5 import QtGui
from PyQt5 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class QgsCapabilitiesCache(QtCore.QObject):

    def __init__(self) -> None: ...

    def removeCapabilitiesDocument(self, path: str) -> None: ...
    def insertCapabilitiesDocument(self, configFilePath: str, key: str, doc: QtXml.QDomDocument) -> None: ...
    def searchCapabilitiesDocument(self, configFilePath: str, key: str) -> QtXml.QDomDocument: ...


class QgsConfigCache(QtCore.QObject):

    def __init__(self, settings: 'QgsServerSettings') -> None: ...

    def removeChangedEntries(self) -> None: ...
    def removeChangedEntry(self, path: str) -> None: ...
    def strategyName(self) -> str: ...
    def project(self, path: str, settings: typing.Optional['QgsServerSettings'] = ...) -> _core.QgsProject: ...
    def removeEntry(self, path: str) -> None: ...
    @staticmethod
    def instance() -> 'QgsConfigCache': ...
    @staticmethod
    def initialize(settings: 'QgsServerSettings') -> None: ...


class QgsServerApi(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, serverIface: 'QgsServerInterface') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerApi') -> None: ...

    def serverIface(self) -> 'QgsServerInterface': ...
    def executeRequest(self, context: 'QgsServerApiContext') -> None: ...
    def accept(self, url: QtCore.QUrl) -> bool: ...
    def rootPath(self) -> str: ...
    def version(self) -> str: ...
    def description(self) -> str: ...
    def name(self) -> str: ...


class QgsServerApiContext(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, apiRootPath: str, request: 'QgsServerRequest', response: 'QgsServerResponse', project: _core.QgsProject, serverInterface: 'QgsServerInterface') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerApiContext') -> None: ...

    def handlerPath(self) -> str: ...
    def setRequest(self, request: 'QgsServerRequest') -> None: ...
    def apiRootPath(self) -> str: ...
    def matchedPath(self) -> str: ...
    def serverInterface(self) -> 'QgsServerInterface': ...
    def setProject(self, project: _core.QgsProject) -> None: ...
    def project(self) -> _core.QgsProject: ...
    def response(self) -> 'QgsServerResponse': ...
    def request(self) -> 'QgsServerRequest': ...


class QgsServerLogger(_core.QgsMessageLogConsole):

    def __init__(self) -> None: ...

    def logMessage(self, message: str, tag: str, level: _core.Qgis.MessageLevel) -> None: ...
    def setLogStderr(self) -> None: ...
    def setLogFile(self, filename: str = ...) -> None: ...
    def setLogLevel(self, level: _core.Qgis.MessageLevel) -> None: ...
    def logLevel(self) -> _core.Qgis.MessageLevel: ...
    @staticmethod
    def instance() -> 'QgsServerLogger': ...


class QgsServerOgcApi(QgsServerApi):

    class ContentType(int):
        GEOJSON = ... # type: QgsServerOgcApi.ContentType
        OPENAPI3 = ... # type: QgsServerOgcApi.ContentType
        JSON = ... # type: QgsServerOgcApi.ContentType
        HTML = ... # type: QgsServerOgcApi.ContentType
        XML = ... # type: QgsServerOgcApi.ContentType

    class Rel(int):
        alternate = ... # type: QgsServerOgcApi.Rel
        describedBy = ... # type: QgsServerOgcApi.Rel
        collection = ... # type: QgsServerOgcApi.Rel
        item = ... # type: QgsServerOgcApi.Rel
        self = ... # type: QgsServerOgcApi.Rel
        service_desc = ... # type: QgsServerOgcApi.Rel
        service_doc = ... # type: QgsServerOgcApi.Rel
        prev = ... # type: QgsServerOgcApi.Rel
        next = ... # type: QgsServerOgcApi.Rel
        license = ... # type: QgsServerOgcApi.Rel
        items = ... # type: QgsServerOgcApi.Rel
        conformance = ... # type: QgsServerOgcApi.Rel
        data = ... # type: QgsServerOgcApi.Rel

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, serverIface: 'QgsServerInterface', rootPath: str, name: str, description: str = ..., version: str = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerOgcApi') -> None: ...

    @staticmethod
    def mimeType(contentType: 'QgsServerOgcApi.ContentType') -> typing.Any: ...
    @staticmethod
    def contenTypeFromExtension(extension: typing.Any) -> 'QgsServerOgcApi.ContentType': ...
    @staticmethod
    def contentTypeToExtension(ct: 'QgsServerOgcApi.ContentType') -> str: ...
    @staticmethod
    def contentTypeToStdString(ct: 'QgsServerOgcApi.ContentType') -> typing.Any: ...
    @staticmethod
    def contentTypeToString(ct: 'QgsServerOgcApi.ContentType') -> str: ...
    @staticmethod
    def relToString(rel: 'QgsServerOgcApi.Rel') -> typing.Any: ...
    @staticmethod
    def sanitizeUrl(url: QtCore.QUrl) -> QtCore.QUrl: ...
    def registerHandler(self, handler: 'QgsServerOgcApiHandler') -> None: ...
    def executeRequest(self, context: QgsServerApiContext) -> None: ...
    def rootPath(self) -> str: ...
    def version(self) -> str: ...
    def description(self) -> str: ...
    def name(self) -> str: ...


class QgsServerOgcApiHandler(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerOgcApiHandler') -> None: ...

    def setContentTypes(self, contentTypes: typing.Iterable[int]) -> None: ...
    @staticmethod
    def layerFromCollectionId(context: QgsServerApiContext, collectionId: str) -> _core.QgsVectorLayer: ...
    @staticmethod
    def parentLink(url: QtCore.QUrl, levels: int = ...) -> str: ...
    def contentTypeFromRequest(self, request: 'QgsServerRequest') -> QgsServerOgcApi.ContentType: ...
    def staticPath(self, context: QgsServerApiContext) -> str: ...
    def templatePath(self, context: QgsServerApiContext) -> str: ...
    def href(self, context: QgsServerApiContext, extraPath: str = ..., extension: str = ...) -> typing.Any: ...
    def write(self, data: typing.Any, context: QgsServerApiContext, htmlMetadata: typing.Dict[str, typing.Any] = ...) -> None: ...
    def contentTypeForAccept(self, accept: str) -> str: ...
    def values(self, context: QgsServerApiContext) -> typing.Dict[str, typing.Any]: ...
    def handleRequest(self, context: QgsServerApiContext) -> None: ...
    def defaultContentType(self) -> QgsServerOgcApi.ContentType: ...
    def tags(self) -> typing.List[str]: ...
    def linkType(self) -> QgsServerOgcApi.Rel: ...
    def linkTitle(self) -> typing.Any: ...
    def description(self) -> typing.Any: ...
    def summary(self) -> typing.Any: ...
    def parameters(self, context: QgsServerApiContext) -> typing.List['QgsServerQueryStringParameter']: ...
    def operationId(self) -> typing.Any: ...
    def path(self) -> QtCore.QRegularExpression: ...


class QgsServerStaticHandler(QgsServerOgcApiHandler):

    @typing.overload
    def __init__(self, pathRegExp: str = ..., staticPathSuffix: str = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerStaticHandler') -> None: ...

    def linkType(self) -> QgsServerOgcApi.Rel: ...
    def linkTitle(self) -> typing.Any: ...
    def description(self) -> typing.Any: ...
    def summary(self) -> typing.Any: ...
    def operationId(self) -> typing.Any: ...
    def path(self) -> QtCore.QRegularExpression: ...
    def handleRequest(self, context: QgsServerApiContext) -> None: ...


class QgsServerParameterDefinition(PyQt5.sip.wrapper):

    mDefaultValue = ... # type: typing.Any
    mType = ... # type: QtCore.QVariant.Type
    mValue = ... # type: typing.Any

    @typing.overload
    def __init__(self, type: QtCore.QVariant.Type = ..., defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerParameterDefinition') -> None: ...

    @staticmethod
    def raiseError(msg: str) -> None: ...
    def loadUrl(self) -> typing.Tuple[str, bool]: ...
    def toUrl(self) -> typing.Tuple[QtCore.QUrl, bool]: ...
    def toColor(self) -> typing.Tuple[QtGui.QColor, bool]: ...
    def toBool(self) -> bool: ...
    def toDouble(self) -> typing.Tuple[float, bool]: ...
    def toInt(self) -> typing.Tuple[int, bool]: ...
    def toRectangle(self) -> typing.Tuple[_core.QgsRectangle, bool]: ...
    def toExpressionList(self) -> typing.List[str]: ...
    def toOgcFilterList(self) -> typing.List[str]: ...
    def toGeomList(self, delimiter: str = ...) -> typing.Tuple[typing.List[_core.QgsGeometry], bool]: ...
    def toColorList(self, delimiter: str = ...) -> typing.Tuple[typing.List[QtGui.QColor], bool]: ...
    def toDoubleList(self, delimiter: str = ...) -> typing.Tuple[typing.List[float], bool]: ...
    def toIntList(self, delimiter: str = ...) -> typing.Tuple[typing.List[int], bool]: ...
    def toStringList(self, delimiter: str = ..., skipEmptyParts: bool = ...) -> typing.List[str]: ...
    def toString(self, defaultValue: bool = ...) -> str: ...
    def isValid(self) -> bool: ...
    def typeName(self) -> str: ...


class QgsServerParameter(QgsServerParameterDefinition):

    class Name(int):
        UNKNOWN = ... # type: QgsServerParameter.Name
        SERVICE = ... # type: QgsServerParameter.Name
        VERSION_SERVICE = ... # type: QgsServerParameter.Name
        REQUEST = ... # type: QgsServerParameter.Name
        MAP = ... # type: QgsServerParameter.Name
        FILE_NAME = ... # type: QgsServerParameter.Name

    mName = ... # type: 'QgsServerParameter.Name'
    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, name: 'QgsServerParameter.Name' = ..., type: QtCore.QVariant.Type = ..., defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerParameter') -> None: ...

    @typing.overload
    @staticmethod
    def name(name: 'QgsServerParameter.Name') -> str: ...
    @typing.overload
    @staticmethod
    def name(name: str) -> 'QgsServerParameter.Name': ...
    def raiseError(self) -> None: ...


class QgsServerParameters(PyQt5.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, query: QtCore.QUrlQuery) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerParameters') -> None: ...

    def loadParameter(self, name: str, value: str) -> bool: ...
    def version(self) -> str: ...
    def fileName(self) -> str: ...
    def map(self) -> str: ...
    def request(self) -> str: ...
    def service(self) -> str: ...
    def toMap(self) -> typing.Dict[str, str]: ...
    def urlQuery(self) -> QtCore.QUrlQuery: ...
    def value(self, key: str) -> str: ...
    @typing.overload
    def remove(self, key: str) -> None: ...
    @typing.overload
    def remove(self, name: QgsServerParameter.Name) -> None: ...
    def add(self, key: str, value: str) -> None: ...
    def clear(self) -> None: ...
    def load(self, query: QtCore.QUrlQuery) -> None: ...


class QgsServerFeatureId(PyQt5.sip.simplewrapper):

    def pkSeparator(self) -> str: ...
    def getExpressionFromServerFid(self, serverFid: str, provider: _core.QgsVectorDataProvider) -> str: ...
    def updateFeatureRequestFromServerFids(self, featureRequest: _core.QgsFeatureRequest, serverFids: typing.Iterable[str], provider: _core.QgsVectorDataProvider) -> _core.QgsFeatureRequest: ...
    def getServerFid(self, feature: _core.QgsFeature, pkAttributes: typing.Iterable[int]) -> str: ...


class QgsServerQueryStringParameter(PyQt5.sip.wrapper):

    class Type(int):
        String = ... # type: QgsServerQueryStringParameter.Type
        Integer = ... # type: QgsServerQueryStringParameter.Type
        Double = ... # type: QgsServerQueryStringParameter.Type
        Boolean = ... # type: QgsServerQueryStringParameter.Type
        List = ... # type: QgsServerQueryStringParameter.Type

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, name: str, required: bool = ..., type: 'QgsServerQueryStringParameter.Type' = ..., description: str = ..., defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerQueryStringParameter') -> None: ...

    def setHidden(self, hidden: bool) -> None: ...
    def hidden(self) -> bool: ...
    def setDescription(self, description: str) -> None: ...
    def name(self) -> str: ...
    @staticmethod
    def typeName(type: 'QgsServerQueryStringParameter.Type') -> str: ...
    def description(self) -> str: ...
    def value(self, context: QgsServerApiContext) -> typing.Any: ...


class QgsServerSettingsEnv(QtCore.QObject):

    class EnvVar(int):
        QGIS_OPTIONS_PATH = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_PARALLEL_RENDERING = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_MAX_THREADS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LOG_LEVEL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LOG_FILE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LOG_STDERR = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_PROJECT_FILE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_IGNORE_BAD_LAYERS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_CACHE_DIRECTORY = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_CACHE_SIZE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_SHOW_GROUP_SEPARATOR = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_OVERRIDE_SYSTEM_LOCALE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WMS_MAX_HEIGHT = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WMS_MAX_WIDTH = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_API_RESOURCES_DIRECTORY = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_API_WFS3_MAX_LIMIT = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_TRUST_LAYER_METADATA = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_FORCE_READONLY_LAYERS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_DISABLE_GETPRINT = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LANDING_PAGE_PROJECTS_DIRECTORIES = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LANDING_PAGE_PROJECTS_PG_CONNECTIONS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LOG_PROFILE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WMS_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WFS_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WCS_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WMTS_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LANDING_PAGE_PREFIX = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_PROJECT_CACHE_CHECK_INTERVAL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_PROJECT_CACHE_STRATEGY = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_ALLOWED_EXTRA_SQL_TOKENS = ... # type: QgsServerSettingsEnv.EnvVar

    class Source(int):
        DEFAULT_VALUE = ... # type: QgsServerSettingsEnv.Source
        ENVIRONMENT_VARIABLE = ... # type: QgsServerSettingsEnv.Source
        INI_FILE = ... # type: QgsServerSettingsEnv.Source

    def __init__(self) -> None: ...


class QgsServerSettings(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerSettings') -> None: ...

    @staticmethod
    def name(env: QgsServerSettingsEnv.EnvVar) -> str: ...
    def allowedExtraSqlTokens(self) -> typing.List[str]: ...
    def projectCacheStrategy(self) -> str: ...
    def projectCacheCheckInterval(self) -> int: ...
    def serviceUrl(self, service: str) -> str: ...
    def getPrintDisabled(self) -> bool: ...
    def forceReadOnlyLayers(self) -> bool: ...
    def trustLayerMetadata(self) -> bool: ...
    def ignoreBadLayers(self) -> bool: ...
    def apiWfs3MaxLimit(self) -> int: ...
    def apiResourcesDirectory(self) -> str: ...
    def landingPageBaseUrlPrefix(self) -> str: ...
    def landingPageProjectsPgConnections(self) -> str: ...
    def landingPageProjectsDirectories(self) -> str: ...
    def wmsMaxWidth(self) -> int: ...
    def wmsMaxHeight(self) -> int: ...
    def showGroupSeparator(self) -> bool: ...
    def overrideSystemLocale(self) -> str: ...
    def cacheDirectory(self) -> str: ...
    def cacheSize(self) -> int: ...
    def logStderr(self) -> bool: ...
    def logFile(self) -> str: ...
    def projectFile(self) -> str: ...
    def logProfile(self) -> bool: ...
    def logLevel(self) -> _core.Qgis.MessageLevel: ...
    def maxThreads(self) -> int: ...
    def parallelRendering(self) -> bool: ...
    def iniFile(self) -> str: ...
    def logSummary(self) -> None: ...
    @typing.overload
    def load(self) -> None: ...
    @typing.overload
    def load(self, envVarName: str) -> bool: ...


class QgsServiceModule(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServiceModule') -> None: ...

    def registerSelf(self, registry: 'QgsServiceRegistry', serverIface: typing.Optional['QgsServerInterface'] = ...) -> None: ...


class QgsServerRequest(PyQt5.sip.wrapper):

    class RequestHeader(int):
        HOST = ... # type: QgsServerRequest.RequestHeader
        FORWARDED = ... # type: QgsServerRequest.RequestHeader
        X_FORWARDED_FOR = ... # type: QgsServerRequest.RequestHeader
        X_FORWARDED_HOST = ... # type: QgsServerRequest.RequestHeader
        X_FORWARDED_PROTO = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_WMS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_WFS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_WCS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_WMTS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        ACCEPT = ... # type: QgsServerRequest.RequestHeader
        USER_AGENT = ... # type: QgsServerRequest.RequestHeader
        AUTHORIZATION = ... # type: QgsServerRequest.RequestHeader

    class Method(int):
        HeadMethod = ... # type: QgsServerRequest.Method
        PutMethod = ... # type: QgsServerRequest.Method
        GetMethod = ... # type: QgsServerRequest.Method
        PostMethod = ... # type: QgsServerRequest.Method
        DeleteMethod = ... # type: QgsServerRequest.Method
        PatchMethod = ... # type: QgsServerRequest.Method

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, url: str, method: 'QgsServerRequest.Method' = ..., headers: typing.Dict[str, str] = ...) -> None: ...
    @typing.overload
    def __init__(self, url: QtCore.QUrl, method: 'QgsServerRequest.Method' = ..., headers: typing.Dict[str, str] = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsServerRequest') -> None: ...

    def setBaseUrl(self, url: QtCore.QUrl) -> None: ...
    def setOriginalUrl(self, url: QtCore.QUrl) -> None: ...
    def queryParameter(self, name: str, defaultValue: str = ...) -> str: ...
    def setMethod(self, method: 'QgsServerRequest.Method') -> None: ...
    def baseUrl(self) -> QtCore.QUrl: ...
    def originalUrl(self) -> QtCore.QUrl: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def removeHeader(self, name: str) -> None: ...
    def headers(self) -> typing.Dict[str, str]: ...
    def setHeader(self, name: str, value: str) -> None: ...
    @typing.overload
    def header(self, name: str) -> str: ...
    @typing.overload
    def header(self, headerEnum: 'QgsServerRequest.RequestHeader') -> str: ...
    def removeParameter(self, key: str) -> None: ...
    def parameter(self, key: str, defaultValue: str = ...) -> str: ...
    def setParameter(self, key: str, value: str) -> None: ...
    def serverParameters(self) -> QgsServerParameters: ...
    def parameters(self) -> typing.Dict[str, str]: ...
    def method(self) -> 'QgsServerRequest.Method': ...
    def url(self) -> QtCore.QUrl: ...
    @staticmethod
    def methodToString(method: 'QgsServerRequest.Method') -> str: ...


class QgsBufferServerRequest(QgsServerRequest):

    @typing.overload
    def __init__(self, url: str, method: QgsServerRequest.Method = ..., headers: typing.Dict[str, str] = ..., data: typing.Optional[typing.Union[QtCore.QByteArray, bytes, bytearray]] = ...) -> None: ...
    @typing.overload
    def __init__(self, url: QtCore.QUrl, method: QgsServerRequest.Method = ..., headers: typing.Dict[str, str] = ..., data: typing.Optional[typing.Union[QtCore.QByteArray, bytes, bytearray]] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsBufferServerRequest') -> None: ...

    def data(self) -> QtCore.QByteArray: ...


class QgsServerResponse(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerResponse') -> None: ...

    def truncate(self) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def clear(self) -> None: ...
    def flush(self) -> None: ...
    def finish(self) -> None: ...
    def io(self) -> QtCore.QIODevice: ...
    @typing.overload
    def write(self, data: str) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> int: ...
    @typing.overload
    def write(self, ex: 'QgsServerException') -> None: ...
    def sendError(self, code: int, message: str) -> None: ...
    def statusCode(self) -> int: ...
    def setStatusCode(self, code: int) -> None: ...
    def headersSent(self) -> bool: ...
    def headers(self) -> typing.Dict[str, str]: ...
    def header(self, key: str) -> str: ...
    def removeHeader(self, key: str) -> None: ...
    def setHeader(self, key: str, value: str) -> None: ...


class QgsBufferServerResponse(QgsServerResponse):

    def __init__(self) -> None: ...

    def body(self) -> QtCore.QByteArray: ...
    def truncate(self) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def clear(self) -> None: ...
    def flush(self) -> None: ...
    def finish(self) -> None: ...
    def io(self) -> QtCore.QIODevice: ...
    def sendError(self, code: int, message: str) -> None: ...
    def statusCode(self) -> int: ...
    def setStatusCode(self, code: int) -> None: ...
    def headersSent(self) -> bool: ...
    def headers(self) -> typing.Dict[str, str]: ...
    def header(self, key: str) -> str: ...
    def removeHeader(self, key: str) -> None: ...
    def setHeader(self, key: str, value: str) -> None: ...


class QgsFcgiServerRequest(QgsServerRequest):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFcgiServerRequest') -> None: ...

    def header(self, name: str) -> str: ...
    def hasError(self) -> bool: ...
    def data(self) -> QtCore.QByteArray: ...


class QgsRequestHandler(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, request: QgsServerRequest, response: QgsServerResponse) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRequestHandler') -> None: ...

    def headersSent(self) -> bool: ...
    def format(self) -> str: ...
    def removeParameter(self, key: str) -> None: ...
    def parameter(self, key: str) -> str: ...
    def setParameter(self, key: str, value: str) -> None: ...
    def parameterMap(self) -> typing.Dict[str, str]: ...
    def statusCode(self) -> int: ...
    def setStatusCode(self, code: int) -> None: ...
    def path(self) -> str: ...
    def url(self) -> str: ...
    def data(self) -> QtCore.QByteArray: ...
    def body(self) -> QtCore.QByteArray: ...
    def clearBody(self) -> None: ...
    def exceptionRaised(self) -> bool: ...
    def appendBody(self, body: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def clear(self) -> None: ...
    def requestHeaders(self) -> typing.Dict[str, str]: ...
    def requestHeader(self, name: str) -> str: ...
    def removeRequestHeader(self, name: str) -> None: ...
    def setRequestHeader(self, name: str, value: str) -> None: ...
    def responseHeaders(self) -> typing.Dict[str, str]: ...
    def responseHeader(self, name: str) -> str: ...
    def removeResponseHeader(self, name: str) -> None: ...
    def setResponseHeader(self, name: str, value: str) -> None: ...
    def sendResponse(self) -> None: ...
    def setServiceException(self, ex: 'QgsServerException') -> None: ...


class QgsServer(PyQt5.sip.wrapper):

    def __init__(self) -> None: ...

    def initPython(self) -> None: ...
    def serverInterface(self) -> 'QgsServerInterface': ...
    def handleRequest(self, request: QgsServerRequest, response: QgsServerResponse, project: typing.Optional[_core.QgsProject] = ...) -> None: ...
    def putenv(self, var: str, val: str) -> None: ...


class QgsServerApiUtils(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerApiUtils') -> None: ...

    @staticmethod
    def appendMapParameter(path: str, requestUrl: QtCore.QUrl) -> str: ...
    @staticmethod
    def crsToOgcUri(crs: _core.QgsCoordinateReferenceSystem) -> str: ...
    @staticmethod
    def publishedCrsList(project: _core.QgsProject) -> typing.List[str]: ...
    @staticmethod
    def sanitizedFieldValue(value: str) -> str: ...
    @staticmethod
    def publishedWfsLayers(context: QgsServerApiContext) -> typing.List[_core.QgsVectorLayer]: ...
    @staticmethod
    def parseCrs(bboxCrs: str) -> _core.QgsCoordinateReferenceSystem: ...
    @staticmethod
    def temporalExtent(layer: _core.QgsVectorLayer) -> typing.List[typing.Any]: ...
    @staticmethod
    def temporalFilterExpression(layer: _core.QgsVectorLayer, interval: str) -> _core.QgsExpression: ...
    @staticmethod
    def fieldName(name: str, layer: _core.QgsVectorLayer) -> str: ...
    @staticmethod
    def parseTemporalDateTimeInterval(interval: str) -> _core.QgsDateTimeRange: ...
    @staticmethod
    def parseTemporalDateInterval(interval: str) -> _core.QgsDateRange: ...
    @staticmethod
    def temporalDimensions(layer: _core.QgsVectorLayer) -> typing.List[_core.QgsServerWmsDimensionProperties.WmsDimensionInfo]: ...
    @staticmethod
    def parseBbox(bbox: str) -> _core.QgsRectangle: ...


class QgsServerException(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, message: str, responseCode: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerException') -> None: ...

    def formatResponse(self) -> typing.Tuple[QtCore.QByteArray, str]: ...
    def responseCode(self) -> int: ...


class QgsOgcServiceException(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, code: str, message: str, locator: str = ..., responseCode: int = ..., version: str = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsOgcServiceException') -> None: ...

    def formatResponse(self) -> typing.Tuple[QtCore.QByteArray, str]: ...
    def version(self) -> str: ...
    def locator(self) -> str: ...
    def code(self) -> str: ...
    def message(self) -> str: ...


class QgsServerFilter(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, serverInterface: 'QgsServerInterface') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerFilter') -> None: ...

    def onSendResponse(self) -> bool: ...
    def onResponseComplete(self) -> bool: ...
    def onRequestReady(self) -> bool: ...
    def sendResponse(self) -> None: ...
    def responseComplete(self) -> None: ...
    def requestReady(self) -> None: ...
    def serverInterface(self) -> 'QgsServerInterface': ...


class QgsServerInterface(PyQt5.sip.wrapper):

    def __init__(self, a0: 'QgsServerInterface') -> None: ...

    def reloadSettings(self) -> None: ...
    def serviceRegistry(self) -> 'QgsServiceRegistry': ...
    def removeConfigCacheEntry(self, path: str) -> None: ...
    def setConfigFilePath(self, configFilePath: str) -> None: ...
    def configFilePath(self) -> str: ...
    def getEnv(self, name: str) -> str: ...
    def cacheManager(self) -> 'QgsServerCacheManager': ...
    def registerServerCache(self, serverCache: 'QgsServerCacheFilter', priority: int = ...) -> None: ...
    def accessControls(self) -> 'QgsAccessControl': ...
    def registerAccessControl(self, accessControl: 'QgsAccessControlFilter', priority: int = ...) -> None: ...
    def filters(self) -> typing.Any: ...
    def setFilters(self, filters: typing.Any) -> None: ...
    def registerFilter(self, filter: QgsServerFilter, priority: int = ...) -> None: ...
    def requestHandler(self) -> QgsRequestHandler: ...
    def capabilitiesCache(self) -> QgsCapabilitiesCache: ...


class QgsServerProjectUtils(PyQt5.sip.simplewrapper):

    def serviceUrl(self, service: str, request: QgsServerRequest, settings: QgsServerSettings) -> str: ...
    def wmtsServiceUrl(self, project: _core.QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    def wcsLayerIds(self, project: _core.QgsProject) -> typing.List[str]: ...
    def wcsServiceUrl(self, project: _core.QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    def wfstDeleteLayerIds(self, project: _core.QgsProject) -> typing.List[str]: ...
    def wfstInsertLayerIds(self, project: _core.QgsProject) -> typing.List[str]: ...
    def wfstUpdateLayerIds(self, project: _core.QgsProject) -> typing.List[str]: ...
    def wfsLayerPrecision(self, project: _core.QgsProject, layerId: str) -> int: ...
    def wfsLayerIds(self, project: _core.QgsProject) -> typing.List[str]: ...
    def wfsServiceUrl(self, project: _core.QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    def wmsExtent(self, project: _core.QgsProject) -> _core.QgsRectangle: ...
    def wmsOutputCrsList(self, project: _core.QgsProject) -> typing.List[str]: ...
    def wmsRestrictedLayers(self, project: _core.QgsProject) -> typing.List[str]: ...
    def wmsRootName(self, project: _core.QgsProject) -> str: ...
    def wmsServiceUrl(self, project: _core.QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    def wmsRestrictedComposers(self, project: _core.QgsProject) -> typing.List[str]: ...
    def wmsInspireMetadataDate(self, project: _core.QgsProject) -> str: ...
    def wmsInspireTemporalReference(self, project: _core.QgsProject) -> str: ...
    def wmsInspireMetadataUrlType(self, project: _core.QgsProject) -> str: ...
    def wmsInspireMetadataUrl(self, project: _core.QgsProject) -> str: ...
    def wmsInspireLanguage(self, project: _core.QgsProject) -> str: ...
    def wmsInspireActivate(self, project: _core.QgsProject) -> bool: ...
    def wmsFeatureInfoLayerAliasMap(self, project: _core.QgsProject) -> typing.Dict[str, str]: ...
    def wmsFeatureInfoSchema(self, project: _core.QgsProject) -> str: ...
    def wmsFeatureInfoDocumentElementNs(self, project: _core.QgsProject) -> str: ...
    def wmsFeatureInfoDocumentElement(self, project: _core.QgsProject) -> str: ...
    def wmsFeatureInfoPrecision(self, project: _core.QgsProject) -> int: ...
    def wmsFeatureInfoSegmentizeWktGeometry(self, project: _core.QgsProject) -> bool: ...
    def wmsFeatureInfoUseAttributeFormSettings(self, project: _core.QgsProject) -> bool: ...
    def wmsFeatureInfoAddWktGeometry(self, project: _core.QgsProject) -> bool: ...
    def wmsInfoFormatSia2045(self, project: _core.QgsProject) -> bool: ...
    def wmsUseLayerIds(self, project: _core.QgsProject) -> bool: ...
    def wmsDefaultMapUnitsPerMm(self, project: _core.QgsProject) -> float: ...
    def wmsMaxAtlasFeatures(self, project: _core.QgsProject) -> int: ...
    def wmsRenderMapTiles(self, project: _core.QgsProject) -> bool: ...
    def wmsTileBuffer(self, project: _core.QgsProject) -> int: ...
    def wmsImageQuality(self, project: _core.QgsProject) -> int: ...
    def wmsMaxHeight(self, project: _core.QgsProject) -> int: ...
    def wmsMaxWidth(self, project: _core.QgsProject) -> int: ...
    def owsServiceAccessConstraints(self, project: _core.QgsProject) -> str: ...
    def owsServiceFees(self, project: _core.QgsProject) -> str: ...
    def owsServiceContactPhone(self, project: _core.QgsProject) -> str: ...
    def owsServiceContactMail(self, project: _core.QgsProject) -> str: ...
    def owsServiceContactPerson(self, project: _core.QgsProject) -> str: ...
    def owsServiceContactPosition(self, project: _core.QgsProject) -> str: ...
    def owsServiceContactOrganization(self, project: _core.QgsProject) -> str: ...
    def owsServiceOnlineResource(self, project: _core.QgsProject) -> str: ...
    def owsServiceKeywords(self, project: _core.QgsProject) -> typing.List[str]: ...
    def owsServiceAbstract(self, project: _core.QgsProject) -> str: ...
    def owsServiceTitle(self, project: _core.QgsProject) -> str: ...
    def owsServiceCapabilities(self, project: _core.QgsProject) -> bool: ...


class QgsService(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsService') -> None: ...

    def executeRequest(self, request: QgsServerRequest, response: QgsServerResponse, project: _core.QgsProject) -> None: ...
    def version(self) -> str: ...
    def name(self) -> str: ...


class QgsServiceRegistry(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServiceRegistry') -> None: ...

    def cleanUp(self) -> None: ...
    def init(self, nativeModulepath: str, serverIface: typing.Optional[QgsServerInterface] = ...) -> None: ...
    def unregisterService(self, name: str, version: str = ...) -> int: ...
    def getApi(self, name: str, version: str = ...) -> QgsServerApi: ...
    def unregisterApi(self, name: str, version: str = ...) -> int: ...
    def registerApi(self, api: QgsServerApi) -> bool: ...
    def registerService(self, service: QgsService) -> None: ...
    def getService(self, name: str, version: str = ...) -> QgsService: ...


class QgsFeatureFilterProviderGroup(_core.QgsFeatureFilterProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFeatureFilterProviderGroup') -> None: ...

    def addProvider(self, provider: _core.QgsFeatureFilterProvider) -> 'QgsFeatureFilterProviderGroup': ...
    def clone(self) -> _core.QgsFeatureFilterProvider: ...
    def layerAttributes(self, layer: _core.QgsVectorLayer, attributes: typing.Iterable[str]) -> typing.List[str]: ...
    def filterFeatures(self, layer: _core.QgsVectorLayer, filterFeatures: _core.QgsFeatureRequest) -> None: ...


class QgsFeatureFilter(_core.QgsFeatureFilterProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFeatureFilter') -> None: ...

    def setFilter(self, layer: _core.QgsVectorLayer, expression: _core.QgsExpression) -> None: ...
    def clone(self) -> _core.QgsFeatureFilterProvider: ...
    def layerAttributes(self, layer: _core.QgsVectorLayer, attributes: typing.Iterable[str]) -> typing.List[str]: ...
    def filterFeatures(self, layer: _core.QgsVectorLayer, filterFeatures: _core.QgsFeatureRequest) -> None: ...


class QgsStoreBadLayerInfo(_core.QgsProjectBadLayerHandler):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsStoreBadLayerInfo') -> None: ...

    def badLayerNames(self) -> typing.Dict[str, str]: ...
    def badLayers(self) -> typing.List[str]: ...
    def handleBadLayers(self, layers: typing.Iterable[QtXml.QDomNode]) -> None: ...


class QgsAccessControlFilter(PyQt5.sip.wrapper):

    class LayerPermissions(PyQt5.sip.wrapper):

        canDelete = ... # type: bool
        canInsert = ... # type: bool
        canRead = ... # type: bool
        canUpdate = ... # type: bool

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAccessControlFilter.LayerPermissions') -> None: ...

    @typing.overload
    def __init__(self, serverInterface: QgsServerInterface) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAccessControlFilter') -> None: ...

    def cacheKey(self) -> str: ...
    def allowToEdit(self, layer: _core.QgsVectorLayer, feature: _core.QgsFeature) -> bool: ...
    def authorizedLayerAttributes(self, layer: _core.QgsVectorLayer, attributes: typing.Iterable[str]) -> typing.List[str]: ...
    def layerPermissions(self, layer: _core.QgsMapLayer) -> 'QgsAccessControlFilter.LayerPermissions': ...
    def layerFilterSubsetString(self, layer: _core.QgsVectorLayer) -> str: ...
    def layerFilterExpression(self, layer: _core.QgsVectorLayer) -> str: ...
    def serverInterface(self) -> QgsServerInterface: ...


class QgsAccessControl(_core.QgsFeatureFilterProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, copy: 'QgsAccessControl') -> None: ...

    def registerAccessControl(self, accessControl: QgsAccessControlFilter, priority: int = ...) -> None: ...
    def fillCacheKey(self, cacheKey: typing.Iterable[str]) -> bool: ...
    def allowToEdit(self, layer: _core.QgsVectorLayer, feature: _core.QgsFeature) -> bool: ...
    def layerAttributes(self, layer: _core.QgsVectorLayer, attributes: typing.Iterable[str]) -> typing.List[str]: ...
    def layerDeletePermission(self, layer: _core.QgsVectorLayer) -> bool: ...
    def layerUpdatePermission(self, layer: _core.QgsVectorLayer) -> bool: ...
    def layerInsertPermission(self, layer: _core.QgsVectorLayer) -> bool: ...
    def layerReadPermission(self, layer: _core.QgsMapLayer) -> bool: ...
    def extraSubsetString(self, layer: _core.QgsVectorLayer) -> str: ...
    def clone(self) -> _core.QgsFeatureFilterProvider: ...
    def filterFeatures(self, layer: _core.QgsVectorLayer, filterFeatures: _core.QgsFeatureRequest) -> None: ...
    def unresolveFilterFeatures(self) -> None: ...
    def resolveFilterFeatures(self, layers: typing.Iterable[_core.QgsMapLayer]) -> None: ...


class QgsServerCacheFilter(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, serverInterface: QgsServerInterface) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerCacheFilter') -> None: ...

    def deleteCachedImages(self, project: _core.QgsProject) -> bool: ...
    def deleteCachedImage(self, project: _core.QgsProject, request: QgsServerRequest, key: str) -> bool: ...
    def setCachedImage(self, img: typing.Union[QtCore.QByteArray, bytes, bytearray], project: _core.QgsProject, request: QgsServerRequest, key: str) -> bool: ...
    def getCachedImage(self, project: _core.QgsProject, request: QgsServerRequest, key: str) -> QtCore.QByteArray: ...
    def deleteCachedDocuments(self, project: _core.QgsProject) -> bool: ...
    def deleteCachedDocument(self, project: _core.QgsProject, request: QgsServerRequest, key: str) -> bool: ...
    def setCachedDocument(self, doc: QtXml.QDomDocument, project: _core.QgsProject, request: QgsServerRequest, key: str) -> bool: ...
    def getCachedDocument(self, project: _core.QgsProject, request: QgsServerRequest, key: str) -> QtCore.QByteArray: ...


class QgsServerCacheManager(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, settings: QgsServerSettings = ...) -> None: ...
    @typing.overload
    def __init__(self, copy: 'QgsServerCacheManager') -> None: ...

    def registerServerCache(self, serverCache: QgsServerCacheFilter, priority: int = ...) -> None: ...
    def deleteCachedImages(self, project: _core.QgsProject) -> bool: ...
    def deleteCachedImage(self, project: _core.QgsProject, request: QgsServerRequest, accessControl: QgsAccessControl) -> bool: ...
    def setCachedImage(self, img: typing.Union[QtCore.QByteArray, bytes, bytearray], project: _core.QgsProject, request: QgsServerRequest, accessControl: QgsAccessControl) -> bool: ...
    def getCachedImage(self, project: _core.QgsProject, request: QgsServerRequest, accessControl: QgsAccessControl) -> QtCore.QByteArray: ...
    def deleteCachedDocuments(self, project: _core.QgsProject) -> bool: ...
    def deleteCachedDocument(self, project: _core.QgsProject, request: QgsServerRequest, accessControl: QgsAccessControl) -> bool: ...
    def setCachedDocument(self, doc: QtXml.QDomDocument, project: _core.QgsProject, request: QgsServerRequest, accessControl: QgsAccessControl) -> bool: ...
    def getCachedDocument(self, doc: QtXml.QDomDocument, project: _core.QgsProject, request: QgsServerRequest, accessControl: QgsAccessControl) -> bool: ...
