/* command-signals.c generated by valac 0.56.3, the Vala compiler
 * generated from command-signals.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <readline/readline.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS (folks_inspect_commands_signals_get_type ())
#define FOLKS_INSPECT_COMMANDS_SIGNALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignals))
#define FOLKS_INSPECT_COMMANDS_SIGNALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignalsClass))
#define FOLKS_INSPECT_COMMANDS_IS_SIGNALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS))
#define FOLKS_INSPECT_COMMANDS_IS_SIGNALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS))
#define FOLKS_INSPECT_COMMANDS_SIGNALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignalsClass))

typedef struct _FolksInspectCommandsSignals FolksInspectCommandsSignals;
typedef struct _FolksInspectCommandsSignalsClass FolksInspectCommandsSignalsClass;
typedef struct _FolksInspectCommandsSignalsPrivate FolksInspectCommandsSignalsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _folks_inspect_command_unref0(var) ((var == NULL) ? NULL : (var = (folks_inspect_command_unref (var), NULL)))

#define FOLKS_INSPECT_TYPE_SIGNAL_MANAGER (folks_inspect_signal_manager_get_type ())
#define FOLKS_INSPECT_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManager))
#define FOLKS_INSPECT_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_SIGNAL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))

typedef struct _FolksInspectSignalManager FolksInspectSignalManager;
typedef struct _FolksInspectSignalManagerClass FolksInspectSignalManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksInspectCommandsSignalsRunData FolksInspectCommandsSignalsRunData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gint (*run_finish) (FolksInspectCommand* self, GAsyncResult* _res_);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand, gint* result_length1);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectCommandsSignals {
	FolksInspectCommand parent_instance;
	FolksInspectCommandsSignalsPrivate * priv;
};

struct _FolksInspectCommandsSignalsClass {
	FolksInspectCommandClass parent_class;
};

struct _FolksInspectCommandsSignalsRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksInspectCommandsSignals* self;
	gchar* command_string;
	gint result;
	FolksInspectClient* _tmp0_;
	FolksInspectSignalManager* _tmp1_;
	FolksInspectSignalManager* _tmp2_;
	gchar** parts;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint parts_length1;
	gint _parts_size_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	GType class_type;
	GObject* class_instance;
	gchar* signal_name;
	gchar* detail_string;
	gboolean _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GType _tmp27_;
	GObject* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	const gchar* _tmp34_;
	guint signal_count;
	FolksInspectClient* _tmp35_;
	FolksInspectSignalManager* _tmp36_;
	FolksInspectSignalManager* _tmp37_;
	GObject* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	guint _vala1_signal_count;
	FolksInspectClient* _tmp41_;
	FolksInspectSignalManager* _tmp42_;
	FolksInspectSignalManager* _tmp43_;
	GObject* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length1;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GType _tmp51_;
	GObject* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gboolean _tmp55_;
	gboolean _tmp56_;
	const gchar* _tmp57_;
	FolksInspectClient* _tmp58_;
	FolksInspectSignalManager* _tmp59_;
	FolksInspectSignalManager* _tmp60_;
	GObject* _tmp61_;
	GObject* _tmp62_;
	FolksInspectClient* _tmp63_;
	FolksInspectSignalManager* _tmp64_;
	FolksInspectSignalManager* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
};

static gpointer folks_inspect_commands_signals_parent_class = NULL;

VALA_EXTERN gpointer folks_inspect_command_ref (gpointer instance);
VALA_EXTERN void folks_inspect_command_unref (gpointer instance);
VALA_EXTERN GParamSpec* folks_inspect_param_spec_command (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void folks_inspect_value_set_command (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void folks_inspect_value_take_command (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer folks_inspect_value_get_command (const GValue* value);
VALA_EXTERN GType folks_inspect_command_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommand, folks_inspect_command_unref)
VALA_EXTERN GType folks_inspect_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectClient, g_object_unref)
VALA_EXTERN GType folks_inspect_commands_signals_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsSignals, folks_inspect_command_unref)
VALA_EXTERN void folks_inspect_command_run (FolksInspectCommand* self,
                                const gchar* command_string,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN gint folks_inspect_command_run_finish (FolksInspectCommand* self,
                                       GAsyncResult* _res_);
VALA_EXTERN gchar** folks_inspect_command_complete_subcommand (FolksInspectCommand* self,
                                                   const gchar* subcommand,
                                                   gint* result_length1);
VALA_EXTERN const gchar* folks_inspect_command_get_name (FolksInspectCommand* self);
VALA_EXTERN const gchar* folks_inspect_command_get_description (FolksInspectCommand* self);
VALA_EXTERN const gchar* folks_inspect_command_get_help (FolksInspectCommand* self);
VALA_EXTERN FolksInspectCommandsSignals* folks_inspect_commands_signals_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsSignals* folks_inspect_commands_signals_construct (GType object_type,
                                                                       FolksInspectClient* client);
VALA_EXTERN FolksInspectCommand* folks_inspect_command_construct (GType object_type,
                                                      FolksInspectClient* client);
static void folks_inspect_commands_signals_real_run_data_free (gpointer _data);
static void folks_inspect_commands_signals_real_run (FolksInspectCommand* base,
                                              const gchar* command_string,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean folks_inspect_commands_signals_real_run_co (FolksInspectCommandsSignalsRunData* _data_);
VALA_EXTERN GType folks_inspect_signal_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectSignalManager, g_object_unref)
VALA_EXTERN FolksInspectSignalManager* folks_inspect_client_get_signal_manager (FolksInspectClient* self);
VALA_EXTERN void folks_inspect_signal_manager_list_signals (FolksInspectSignalManager* self,
                                                GType class_type,
                                                GObject* class_instance);
VALA_EXTERN gboolean folks_inspect_utils_validate_subcommand (const gchar* command,
                                                  const gchar* command_string,
                                                  const gchar* subcommand,
                                                  gchar** valid_subcommands,
                                                  gint valid_subcommands_length1);
VALA_EXTERN void folks_inspect_utils_print_line (const gchar* format,
                                     ...)  G_GNUC_PRINTF(1,2) ;
static gboolean folks_inspect_commands_signals_parse_signal_id (FolksInspectCommandsSignals* self,
                                                         const gchar* input,
                                                         GType* class_type,
                                                         GObject** class_instance,
                                                         gchar** signal_name,
                                                         gchar** detail_string);
VALA_EXTERN guint folks_inspect_signal_manager_connect_to_signal (FolksInspectSignalManager* self,
                                                      GType class_type,
                                                      GObject* class_instance,
                                                      const gchar* signal_name,
                                                      const gchar* detail_string);
VALA_EXTERN guint folks_inspect_signal_manager_disconnect_from_signal (FolksInspectSignalManager* self,
                                                           GType class_type,
                                                           GObject* class_instance,
                                                           const gchar* signal_name,
                                                           const gchar* detail_string);
VALA_EXTERN void folks_inspect_signal_manager_show_signal_details (FolksInspectSignalManager* self,
                                                       GType class_type,
                                                       const gchar* signal_name,
                                                       const gchar* detail_string);
static gchar** folks_inspect_commands_signals_real_complete_subcommand (FolksInspectCommand* base,
                                                                 const gchar* subcommand,
                                                                 gint* result_length1);
VALA_EXTERN gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word,
                                                       gint state);
static gchar* _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                            gint a);
static gchar** _vala_array_dup14 (gchar** self,
                           gssize length);
static GType folks_inspect_commands_signals_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const gchar* FOLKS_INSPECT_COMMANDS_SIGNALS__valid_subcommands[2] = {"connect", "disconnect"};

FolksInspectCommandsSignals*
folks_inspect_commands_signals_construct (GType object_type,
                                          FolksInspectClient* client)
{
	FolksInspectCommandsSignals* self = NULL;
	g_return_val_if_fail (client != NULL, NULL);
	self = (FolksInspectCommandsSignals*) folks_inspect_command_construct (object_type, client);
	return self;
}

FolksInspectCommandsSignals*
folks_inspect_commands_signals_new (FolksInspectClient* client)
{
	return folks_inspect_commands_signals_construct (FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, client);
}

static void
folks_inspect_commands_signals_real_run_data_free (gpointer _data)
{
	FolksInspectCommandsSignalsRunData* _data_;
	_data_ = _data;
	_g_free0 (_data_->command_string);
	_folks_inspect_command_unref0 (_data_->self);
	g_slice_free (FolksInspectCommandsSignalsRunData, _data_);
}

static gpointer
_folks_inspect_command_ref0 (gpointer self)
{
	return self ? folks_inspect_command_ref (self) : NULL;
}

static void
folks_inspect_commands_signals_real_run (FolksInspectCommand* base,
                                         const gchar* command_string,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	FolksInspectCommandsSignals * self;
	FolksInspectCommandsSignalsRunData* _data_;
	FolksInspectCommandsSignals* _tmp0_;
	gchar* _tmp1_;
	self = (FolksInspectCommandsSignals*) base;
	_data_ = g_slice_new0 (FolksInspectCommandsSignalsRunData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_inspect_commands_signals_real_run_data_free);
	_tmp0_ = _folks_inspect_command_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (command_string);
	_g_free0 (_data_->command_string);
	_data_->command_string = _tmp1_;
	folks_inspect_commands_signals_real_run_co (_data_);
}

static gint
folks_inspect_commands_signals_run_finish (FolksInspectCommand* base,
                                           GAsyncResult* _res_)
{
	gint result;
	FolksInspectCommandsSignalsRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
folks_inspect_commands_signals_real_run_co (FolksInspectCommandsSignalsRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->command_string == NULL) {
		_data_->_tmp0_ = ((FolksInspectCommand*) _data_->self)->client;
		_data_->_tmp1_ = folks_inspect_client_get_signal_manager (_data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		folks_inspect_signal_manager_list_signals (_data_->_tmp2_, G_TYPE_INVALID, NULL);
	} else {
		_data_->_tmp4_ = _data_->_tmp3_ = g_strsplit (_data_->command_string, " ", 2);
		_data_->parts = _data_->_tmp4_;
		_data_->parts_length1 = _vala_array_length (_data_->_tmp3_);
		_data_->_parts_size_ = _data_->parts_length1;
		_data_->_tmp5_ = folks_inspect_command_get_name ((FolksInspectCommand*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->parts;
		_data_->_tmp7__length1 = _data_->parts_length1;
		_data_->_tmp8_ = _data_->_tmp7_[0];
		if (!folks_inspect_utils_validate_subcommand (_data_->_tmp6_, _data_->command_string, _data_->_tmp8_, FOLKS_INSPECT_COMMANDS_SIGNALS__valid_subcommands, (gint) G_N_ELEMENTS (FOLKS_INSPECT_COMMANDS_SIGNALS__valid_subcommands))) {
			_data_->result = 1;
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp10_ = _data_->parts;
		_data_->_tmp10__length1 = _data_->parts_length1;
		_data_->_tmp11_ = _data_->_tmp10_[0];
		if (g_strcmp0 (_data_->_tmp11_, "connect") == 0) {
			_data_->_tmp9_ = TRUE;
		} else {
			_data_->_tmp12_ = _data_->parts;
			_data_->_tmp12__length1 = _data_->parts_length1;
			_data_->_tmp13_ = _data_->_tmp12_[0];
			_data_->_tmp9_ = g_strcmp0 (_data_->_tmp13_, "disconnect") == 0;
		}
		if (_data_->_tmp9_) {
			_data_->_tmp15_ = _data_->parts;
			_data_->_tmp15__length1 = _data_->parts_length1;
			_data_->_tmp16_ = _data_->_tmp15_[1];
			if (_data_->_tmp16_ == NULL) {
				_data_->_tmp14_ = TRUE;
			} else {
				_data_->_tmp17_ = _data_->parts;
				_data_->_tmp17__length1 = _data_->parts_length1;
				_data_->_tmp18_ = _data_->_tmp17_[1];
				_data_->_tmp19_ = string_strip (_data_->_tmp18_);
				_data_->_tmp20_ = _data_->_tmp19_;
				_data_->_tmp14_ = g_strcmp0 (_data_->_tmp20_, "") == 0;
				_g_free0 (_data_->_tmp20_);
			}
			if (_data_->_tmp14_) {
				_data_->_tmp21_ = _data_->parts;
				_data_->_tmp21__length1 = _data_->parts_length1;
				_data_->_tmp22_ = _data_->_tmp21_[1];
				folks_inspect_utils_print_line ("Unrecognised signal identifier '%s'.", _data_->_tmp22_);
				_data_->result = 1;
				_g_free0 (_data_->detail_string);
				_g_free0 (_data_->signal_name);
				_g_object_unref0 (_data_->class_instance);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp23_ = _data_->parts;
			_data_->_tmp23__length1 = _data_->parts_length1;
			_data_->_tmp24_ = _data_->_tmp23_[1];
			_data_->_tmp25_ = string_strip (_data_->_tmp24_);
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp27_ = 0UL;
			_data_->_tmp28_ = NULL;
			_data_->_tmp29_ = NULL;
			_data_->_tmp30_ = NULL;
			_data_->_tmp31_ = folks_inspect_commands_signals_parse_signal_id (_data_->self, _data_->_tmp26_, &_data_->_tmp27_, &_data_->_tmp28_, &_data_->_tmp29_, &_data_->_tmp30_);
			_data_->class_type = _data_->_tmp27_;
			_g_object_unref0 (_data_->class_instance);
			_data_->class_instance = _data_->_tmp28_;
			_g_free0 (_data_->signal_name);
			_data_->signal_name = _data_->_tmp29_;
			_g_free0 (_data_->detail_string);
			_data_->detail_string = _data_->_tmp30_;
			_data_->_tmp32_ = _data_->_tmp31_ == FALSE;
			_g_free0 (_data_->_tmp26_);
			if (_data_->_tmp32_) {
				_data_->result = 1;
				_g_free0 (_data_->detail_string);
				_g_free0 (_data_->signal_name);
				_g_object_unref0 (_data_->class_instance);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp33_ = _data_->parts;
			_data_->_tmp33__length1 = _data_->parts_length1;
			_data_->_tmp34_ = _data_->_tmp33_[0];
			if (g_strcmp0 (_data_->_tmp34_, "connect") == 0) {
				_data_->_tmp35_ = ((FolksInspectCommand*) _data_->self)->client;
				_data_->_tmp36_ = folks_inspect_client_get_signal_manager (_data_->_tmp35_);
				_data_->_tmp37_ = _data_->_tmp36_;
				_data_->_tmp38_ = _data_->class_instance;
				_data_->_tmp39_ = _data_->signal_name;
				_data_->_tmp40_ = _data_->detail_string;
				_data_->signal_count = folks_inspect_signal_manager_connect_to_signal (_data_->_tmp37_, _data_->class_type, _data_->_tmp38_, _data_->_tmp39_, _data_->_tmp40_);
				folks_inspect_utils_print_line ("Connected to %u signals.", _data_->signal_count);
			} else {
				_data_->_tmp41_ = ((FolksInspectCommand*) _data_->self)->client;
				_data_->_tmp42_ = folks_inspect_client_get_signal_manager (_data_->_tmp41_);
				_data_->_tmp43_ = _data_->_tmp42_;
				_data_->_tmp44_ = _data_->class_instance;
				_data_->_tmp45_ = _data_->signal_name;
				_data_->_tmp46_ = _data_->detail_string;
				_data_->_vala1_signal_count = folks_inspect_signal_manager_disconnect_from_signal (_data_->_tmp43_, _data_->class_type, _data_->_tmp44_, _data_->_tmp45_, _data_->_tmp46_);
				folks_inspect_utils_print_line ("Disconnected from %u signals.", _data_->_vala1_signal_count);
			}
		} else {
			_data_->_tmp47_ = _data_->parts;
			_data_->_tmp47__length1 = _data_->parts_length1;
			_data_->_tmp48_ = _data_->_tmp47_[0];
			_data_->_tmp49_ = string_strip (_data_->_tmp48_);
			_data_->_tmp50_ = _data_->_tmp49_;
			_data_->_tmp51_ = 0UL;
			_data_->_tmp52_ = NULL;
			_data_->_tmp53_ = NULL;
			_data_->_tmp54_ = NULL;
			_data_->_tmp55_ = folks_inspect_commands_signals_parse_signal_id (_data_->self, _data_->_tmp50_, &_data_->_tmp51_, &_data_->_tmp52_, &_data_->_tmp53_, &_data_->_tmp54_);
			_data_->class_type = _data_->_tmp51_;
			_g_object_unref0 (_data_->class_instance);
			_data_->class_instance = _data_->_tmp52_;
			_g_free0 (_data_->signal_name);
			_data_->signal_name = _data_->_tmp53_;
			_g_free0 (_data_->detail_string);
			_data_->detail_string = _data_->_tmp54_;
			_data_->_tmp56_ = _data_->_tmp55_ == FALSE;
			_g_free0 (_data_->_tmp50_);
			if (_data_->_tmp56_) {
				_data_->result = 1;
				_g_free0 (_data_->detail_string);
				_g_free0 (_data_->signal_name);
				_g_object_unref0 (_data_->class_instance);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp57_ = _data_->signal_name;
			if (_data_->_tmp57_ == NULL) {
				_data_->_tmp58_ = ((FolksInspectCommand*) _data_->self)->client;
				_data_->_tmp59_ = folks_inspect_client_get_signal_manager (_data_->_tmp58_);
				_data_->_tmp60_ = _data_->_tmp59_;
				_data_->_tmp61_ = _data_->class_instance;
				folks_inspect_signal_manager_list_signals (_data_->_tmp60_, _data_->class_type, _data_->_tmp61_);
			} else {
				if (_data_->class_type == G_TYPE_INVALID) {
					_data_->_tmp62_ = _data_->class_instance;
					_data_->class_type = G_TYPE_FROM_INSTANCE (_data_->_tmp62_);
				}
				_data_->_tmp63_ = ((FolksInspectCommand*) _data_->self)->client;
				_data_->_tmp64_ = folks_inspect_client_get_signal_manager (_data_->_tmp63_);
				_data_->_tmp65_ = _data_->_tmp64_;
				_data_->_tmp66_ = _data_->signal_name;
				_data_->_tmp67_ = _data_->detail_string;
				folks_inspect_signal_manager_show_signal_details (_data_->_tmp65_, _data_->class_type, _data_->_tmp66_, _data_->_tmp67_);
			}
		}
		_g_free0 (_data_->detail_string);
		_g_free0 (_data_->signal_name);
		_g_object_unref0 (_data_->class_instance);
		_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
	}
	_data_->result = 0;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
_folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                     gint a)
{
	gchar* result;
	result = folks_inspect_utils_backend_name_completion_cb (str, a);
	return result;
}

static gchar**
_vala_array_dup14 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
folks_inspect_commands_signals_real_complete_subcommand (FolksInspectCommand* base,
                                                         const gchar* subcommand,
                                                         gint* result_length1)
{
	FolksInspectCommandsSignals * self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	self = (FolksInspectCommandsSignals*) base;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp1_ = _tmp0_ = rl_completion_matches (subcommand, _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t);
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup14 (_tmp1_, _vala_array_length (_tmp0_)) : _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
folks_inspect_commands_signals_parse_signal_id (FolksInspectCommandsSignals* self,
                                                const gchar* input,
                                                GType* class_type,
                                                GObject** class_instance,
                                                gchar** signal_name,
                                                gchar** detail_string)
{
	GType _vala_class_type = 0UL;
	GObject* _vala_class_instance = NULL;
	gchar* _vala_signal_name = NULL;
	gchar* _vala_detail_string = NULL;
	gboolean _tmp0_ = FALSE;
	gchar** parts = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint parts_length1;
	gint _parts_size_;
	gchar* class_name_or_instance = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* signal_name_inner = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* detail_string_inner = NULL;
	gchar* _tmp15_;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (input != NULL, FALSE);
	if (input != NULL) {
		_tmp0_ = g_strcmp0 (input, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "input != null && input != \"\"");
	_vala_class_type = G_TYPE_INVALID;
	_g_object_unref0 (_vala_class_instance);
	_vala_class_instance = NULL;
	_g_free0 (_vala_signal_name);
	_vala_signal_name = NULL;
	_g_free0 (_vala_detail_string);
	_vala_detail_string = NULL;
	_tmp2_ = _tmp1_ = g_strsplit (input, "::", 3);
	parts = _tmp2_;
	parts_length1 = _vala_array_length (_tmp1_);
	_parts_size_ = parts_length1;
	_tmp3_ = parts;
	_tmp3__length1 = parts_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = g_strdup (_tmp4_);
	class_name_or_instance = _tmp5_;
	_tmp7_ = parts;
	_tmp7__length1 = parts_length1;
	if (_tmp7__length1 > 1) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		_tmp8_ = parts;
		_tmp8__length1 = parts_length1;
		_tmp9_ = _tmp8_[1];
		_tmp6_ = _tmp9_;
	} else {
		_tmp6_ = NULL;
	}
	_tmp10_ = g_strdup (_tmp6_);
	signal_name_inner = _tmp10_;
	_tmp12_ = parts;
	_tmp12__length1 = parts_length1;
	if (_tmp12__length1 > 2) {
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		_tmp13_ = parts;
		_tmp13__length1 = parts_length1;
		_tmp14_ = _tmp13_[2];
		_tmp11_ = _tmp14_;
	} else {
		_tmp11_ = NULL;
	}
	_tmp15_ = g_strdup (_tmp11_);
	detail_string_inner = _tmp15_;
	_tmp17_ = signal_name_inner;
	if (g_strcmp0 (_tmp17_, "") == 0) {
		_tmp16_ = TRUE;
	} else {
		const gchar* _tmp18_;
		_tmp18_ = detail_string_inner;
		_tmp16_ = g_strcmp0 (_tmp18_, "") == 0;
	}
	if (_tmp16_) {
		folks_inspect_utils_print_line ("Invalid signal identifier '%s'.", input);
		result = FALSE;
		_g_free0 (detail_string_inner);
		_g_free0 (signal_name_inner);
		_g_free0 (class_name_or_instance);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		if (class_type) {
			*class_type = _vala_class_type;
		}
		if (class_instance) {
			*class_instance = _vala_class_instance;
		} else {
			_g_object_unref0 (_vala_class_instance);
		}
		if (signal_name) {
			*signal_name = _vala_signal_name;
		} else {
			_g_free0 (_vala_signal_name);
		}
		if (detail_string) {
			*detail_string = _vala_detail_string;
		} else {
			_g_free0 (_vala_detail_string);
		}
		return result;
	}
	_tmp21_ = class_name_or_instance;
	_tmp22_ = strlen (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ > 2) {
		const gchar* _tmp24_;
		_tmp24_ = class_name_or_instance;
		_tmp20_ = string_get (_tmp24_, (glong) 0) == '0';
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		const gchar* _tmp25_;
		_tmp25_ = class_name_or_instance;
		_tmp19_ = string_get (_tmp25_, (glong) 1) == 'x';
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		guint64 address = 0ULL;
		const gchar* _tmp26_;
		GObject* _tmp27_;
		GObject* _tmp28_;
		_tmp26_ = class_name_or_instance;
		address = uint64_parse (_tmp26_, (guint) 0);
		_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (address, G_TYPE_OBJECT, GObject));
		_g_object_unref0 (_vala_class_instance);
		_vala_class_instance = _tmp27_;
		_tmp28_ = _vala_class_instance;
		_vala_assert (G_TYPE_IS_OBJECT (G_TYPE_FROM_INSTANCE (_tmp28_)), "class_instance.get_type ().is_object ()");
	} else {
		const gchar* _tmp29_;
		gboolean _tmp30_ = FALSE;
		_tmp29_ = class_name_or_instance;
		_vala_class_type = g_type_from_name (_tmp29_);
		if (_vala_class_type == G_TYPE_INVALID) {
			_tmp30_ = TRUE;
		} else {
			gboolean _tmp31_ = FALSE;
			if (G_TYPE_IS_INSTANTIATABLE (_vala_class_type) == FALSE) {
				_tmp31_ = G_TYPE_IS_INTERFACE (_vala_class_type) == FALSE;
			} else {
				_tmp31_ = FALSE;
			}
			_tmp30_ = _tmp31_;
		}
		if (_tmp30_) {
			const gchar* _tmp32_;
			_tmp32_ = class_name_or_instance;
			folks_inspect_utils_print_line ("Unrecognised class name '%s'.", _tmp32_);
			result = FALSE;
			_g_free0 (detail_string_inner);
			_g_free0 (signal_name_inner);
			_g_free0 (class_name_or_instance);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			if (class_type) {
				*class_type = _vala_class_type;
			}
			if (class_instance) {
				*class_instance = _vala_class_instance;
			} else {
				_g_object_unref0 (_vala_class_instance);
			}
			if (signal_name) {
				*signal_name = _vala_signal_name;
			} else {
				_g_free0 (_vala_signal_name);
			}
			if (detail_string) {
				*detail_string = _vala_detail_string;
			} else {
				_g_free0 (_vala_detail_string);
			}
			return result;
		}
	}
	_tmp33_ = signal_name_inner;
	_tmp34_ = g_strdup (_tmp33_);
	_g_free0 (_vala_signal_name);
	_vala_signal_name = _tmp34_;
	_tmp35_ = detail_string_inner;
	_tmp36_ = g_strdup (_tmp35_);
	_g_free0 (_vala_detail_string);
	_vala_detail_string = _tmp36_;
	result = TRUE;
	_g_free0 (detail_string_inner);
	_g_free0 (signal_name_inner);
	_g_free0 (class_name_or_instance);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	if (class_type) {
		*class_type = _vala_class_type;
	}
	if (class_instance) {
		*class_instance = _vala_class_instance;
	} else {
		_g_object_unref0 (_vala_class_instance);
	}
	if (signal_name) {
		*signal_name = _vala_signal_name;
	} else {
		_g_free0 (_vala_signal_name);
	}
	if (detail_string) {
		*detail_string = _vala_detail_string;
	} else {
		_g_free0 (_vala_detail_string);
	}
	return result;
}

static const gchar*
folks_inspect_commands_signals_real_get_name (FolksInspectCommand* base)
{
	const gchar* result;
	FolksInspectCommandsSignals* self;
	self = (FolksInspectCommandsSignals*) base;
	result = "signals";
	return result;
}

static const gchar*
folks_inspect_commands_signals_real_get_description (FolksInspectCommand* base)
{
	const gchar* result;
	FolksInspectCommandsSignals* self;
	self = (FolksInspectCommandsSignals*) base;
	result = "Allow connection to and display of signals emitted by " "libfolks.";
	return result;
}

static const gchar*
folks_inspect_commands_signals_real_get_help (FolksInspectCommand* base)
{
	const gchar* result;
	FolksInspectCommandsSignals* self;
	self = (FolksInspectCommandsSignals*) base;
	result = "signals                                            " "List signals we're currently connected to.\n" "signals connect [class name]                       " "Connect to all the signals on all the instances of that " "class.\n" "signals connect [class name]::[signal name]        " "Connect to the given signal on all the instances of that " "class.\n" "signals connect [object pointer]                   " "Connect to all the signals on a particular class instance.\n" "signals connect [object pointer]::[signal name]    " "Connect to the given signal on a particular class instance.\n" "signals disconnect                                 " "(As for 'connect'.)\n" "signals [class name]                               " "List all the signals on all the instances of that class, " "highlighting the ones we're currently connected to.\n" "signals [object pointer]                           " "List all the signals on a particular class instance, " "highlighting the ones we're currently connected to.\n" "signals [class name]::[signal name]                " "Show the details of this signal.\n" "signals [object pointer]::[signal name]            " "Show the details of this signal.";
	return result;
}

static void
folks_inspect_commands_signals_class_init (FolksInspectCommandsSignalsClass * klass,
                                           gpointer klass_data)
{
	folks_inspect_commands_signals_parent_class = g_type_class_peek_parent (klass);
	((FolksInspectCommandClass *) klass)->run = (void (*) (FolksInspectCommand*, const gchar*, GAsyncReadyCallback, gpointer)) folks_inspect_commands_signals_real_run;
	((FolksInspectCommandClass *) klass)->run_finish = (gint (*) (FolksInspectCommand*, GAsyncResult*)) folks_inspect_commands_signals_run_finish;
	((FolksInspectCommandClass *) klass)->complete_subcommand = (gchar** (*) (FolksInspectCommand*, const gchar*, gint*)) folks_inspect_commands_signals_real_complete_subcommand;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_name = folks_inspect_commands_signals_real_get_name;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_description = folks_inspect_commands_signals_real_get_description;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_help = folks_inspect_commands_signals_real_get_help;
}

static void
folks_inspect_commands_signals_instance_init (FolksInspectCommandsSignals * self,
                                              gpointer klass)
{
}

static GType
folks_inspect_commands_signals_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandsSignalsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_commands_signals_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommandsSignals), 0, (GInstanceInitFunc) folks_inspect_commands_signals_instance_init, NULL };
	GType folks_inspect_commands_signals_type_id;
	folks_inspect_commands_signals_type_id = g_type_register_static (FOLKS_INSPECT_TYPE_COMMAND, "FolksInspectCommandsSignals", &g_define_type_info, 0);
	return folks_inspect_commands_signals_type_id;
}

GType
folks_inspect_commands_signals_get_type (void)
{
	static volatile gsize folks_inspect_commands_signals_type_id__once = 0;
	if (g_once_init_enter (&folks_inspect_commands_signals_type_id__once)) {
		GType folks_inspect_commands_signals_type_id;
		folks_inspect_commands_signals_type_id = folks_inspect_commands_signals_get_type_once ();
		g_once_init_leave (&folks_inspect_commands_signals_type_id__once, folks_inspect_commands_signals_type_id);
	}
	return folks_inspect_commands_signals_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

