/* contacts-birthday-chunk.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-birthday-chunk.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "contactscore.h"
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <folks/folks.h>

enum  {
	CONTACTS_BIRTHDAY_CHUNK_0_PROPERTY,
	CONTACTS_BIRTHDAY_CHUNK_BIRTHDAY_PROPERTY,
	CONTACTS_BIRTHDAY_CHUNK_PROPERTY_NAME_PROPERTY,
	CONTACTS_BIRTHDAY_CHUNK_IS_EMPTY_PROPERTY,
	CONTACTS_BIRTHDAY_CHUNK_NUM_PROPERTIES
};
static GParamSpec* contacts_birthday_chunk_properties[CONTACTS_BIRTHDAY_CHUNK_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsBirthdayChunkSaveToPersonaData ContactsBirthdayChunkSaveToPersonaData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsBirthdayChunkPrivate {
	GDateTime* _birthday;
};

struct _ContactsBirthdayChunkSaveToPersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsBirthdayChunk* self;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	FolksPersona* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GError* _inner_error0_;
};

static gint ContactsBirthdayChunk_private_offset;
static gpointer contacts_birthday_chunk_parent_class = NULL;

static GValue* contacts_birthday_chunk_real_to_value (ContactsChunk* base);
static void contacts_birthday_chunk_real_save_to_persona_data_free (gpointer _data);
static void contacts_birthday_chunk_real_save_to_persona (ContactsChunk* base,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean contacts_birthday_chunk_real_save_to_persona_co (ContactsBirthdayChunkSaveToPersonaData* _data_);
static void contacts_birthday_chunk_save_to_persona_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static GObject * contacts_birthday_chunk_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void contacts_birthday_chunk_finalize (GObject * obj);
static GType contacts_birthday_chunk_get_type_once (void);
static void _vala_contacts_birthday_chunk_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_contacts_birthday_chunk_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
contacts_birthday_chunk_get_instance_private (ContactsBirthdayChunk* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsBirthdayChunk_private_offset);
}

static GValue*
contacts_birthday_chunk_real_to_value (ContactsChunk* base)
{
	ContactsBirthdayChunk * self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GValue* _tmp2_ = NULL;
	GValue* result;
	self = (ContactsBirthdayChunk*) base;
	_tmp0_ = contacts_birthday_chunk_get_birthday (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (GValue, 1);
	g_value_init (_tmp2_, G_TYPE_DATE_TIME);
	g_value_set_boxed (_tmp2_, _tmp1_);
	result = _tmp2_;
	return result;
}

static void
contacts_birthday_chunk_real_save_to_persona_data_free (gpointer _data)
{
	ContactsBirthdayChunkSaveToPersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsBirthdayChunkSaveToPersonaData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
contacts_birthday_chunk_real_save_to_persona (ContactsChunk* base,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	ContactsBirthdayChunk * self;
	ContactsBirthdayChunkSaveToPersonaData* _data_;
	ContactsBirthdayChunk* _tmp0_;
	self = (ContactsBirthdayChunk*) base;
	_data_ = g_slice_new0 (ContactsBirthdayChunkSaveToPersonaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_birthday_chunk_real_save_to_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_birthday_chunk_real_save_to_persona_co (_data_);
}

static void
contacts_birthday_chunk_save_to_persona_finish (ContactsChunk* base,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	ContactsBirthdayChunkSaveToPersonaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
contacts_birthday_chunk_save_to_persona_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	ContactsBirthdayChunkSaveToPersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_birthday_chunk_real_save_to_persona_co (_data_);
}

static gboolean
contacts_birthday_chunk_real_save_to_persona_co (ContactsBirthdayChunkSaveToPersonaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = contacts_chunk_get_persona ((ContactsChunk*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, FOLKS_TYPE_BIRTHDAY_DETAILS), "this.persona is BirthdayDetails", FALSE);
	_data_->_tmp2_ = contacts_chunk_get_persona ((ContactsChunk*) _data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = contacts_birthday_chunk_get_birthday (_data_->self);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_state_ = 1;
	folks_birthday_details_change_birthday (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, FOLKS_TYPE_BIRTHDAY_DETAILS, FolksBirthdayDetails), _data_->_tmp5_, contacts_birthday_chunk_save_to_persona_ready, _data_);
	return FALSE;
	_state_1:
	folks_birthday_details_change_birthday_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, FOLKS_TYPE_BIRTHDAY_DETAILS, FolksBirthdayDetails), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ContactsBirthdayChunk*
contacts_birthday_chunk_construct (GType object_type)
{
	ContactsBirthdayChunk * self = NULL;
	self = (ContactsBirthdayChunk*) contacts_chunk_construct (object_type);
	return self;
}

ContactsBirthdayChunk*
contacts_birthday_chunk_new (void)
{
	return contacts_birthday_chunk_construct (CONTACTS_TYPE_BIRTHDAY_CHUNK);
}

GDateTime*
contacts_birthday_chunk_get_birthday (ContactsBirthdayChunk* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_birthday;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
contacts_birthday_chunk_set_birthday (ContactsBirthdayChunk* self,
                                      GDateTime* value)
{
	gboolean _tmp0_ = FALSE;
	GDateTime* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GDateTime* _tmp4_;
	GDateTime* _tmp8_ = NULL;
	GDateTime* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_birthday;
	if (_tmp1_ == NULL) {
		_tmp0_ = value == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->_birthday;
	if (_tmp4_ != NULL) {
		_tmp3_ = value != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GDateTime* _tmp5_;
		GDateTime* _tmp6_;
		GDateTime* _tmp7_;
		_tmp5_ = self->priv->_birthday;
		_tmp6_ = g_date_time_to_utc (value);
		_tmp7_ = _tmp6_;
		_tmp2_ = g_date_time_equal (_tmp5_, _tmp7_);
		_g_date_time_unref0 (_tmp7_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return;
	}
	if (value != NULL) {
		GDateTime* _tmp9_;
		_tmp9_ = g_date_time_to_utc (value);
		_g_date_time_unref0 (_tmp8_);
		_tmp8_ = _tmp9_;
	} else {
		_g_date_time_unref0 (_tmp8_);
		_tmp8_ = NULL;
	}
	_tmp10_ = _g_date_time_ref0 (_tmp8_);
	_g_date_time_unref0 (self->priv->_birthday);
	self->priv->_birthday = _tmp10_;
	g_object_notify ((GObject*) self, "birthday");
	g_object_notify ((GObject*) self, "is-empty");
	_g_date_time_unref0 (_tmp8_);
	g_object_notify_by_pspec ((GObject *) self, contacts_birthday_chunk_properties[CONTACTS_BIRTHDAY_CHUNK_BIRTHDAY_PROPERTY]);
}

static const gchar*
contacts_birthday_chunk_real_get_property_name (ContactsChunk* base)
{
	const gchar* result;
	ContactsBirthdayChunk* self;
	self = (ContactsBirthdayChunk*) base;
	result = "birthday";
	return result;
}

static gboolean
contacts_birthday_chunk_real_get_is_empty (ContactsChunk* base)
{
	gboolean result;
	ContactsBirthdayChunk* self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	self = (ContactsBirthdayChunk*) base;
	_tmp0_ = contacts_birthday_chunk_get_birthday (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == NULL;
	return result;
}

static GObject *
contacts_birthday_chunk_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsBirthdayChunk * self;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	parent_class = G_OBJECT_CLASS (contacts_birthday_chunk_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_BIRTHDAY_CHUNK, ContactsBirthdayChunk);
	_tmp0_ = contacts_chunk_get_persona ((ContactsChunk*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		FolksPersona* _tmp2_;
		FolksPersona* _tmp3_;
		FolksPersona* _tmp4_;
		FolksPersona* _tmp5_;
		_tmp2_ = contacts_chunk_get_persona ((ContactsChunk*) self);
		_tmp3_ = _tmp2_;
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, FOLKS_TYPE_BIRTHDAY_DETAILS));
		_tmp4_ = contacts_chunk_get_persona ((ContactsChunk*) self);
		_tmp5_ = _tmp4_;
		g_object_bind_property_with_closures ((GObject*) _tmp5_, "birthday", (GObject*) self, "birthday", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	}
	return obj;
}

static void
contacts_birthday_chunk_class_init (ContactsBirthdayChunkClass * klass,
                                    gpointer klass_data)
{
	contacts_birthday_chunk_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsBirthdayChunk_private_offset);
	((ContactsChunkClass *) klass)->to_value = (GValue* (*) (ContactsChunk*)) contacts_birthday_chunk_real_to_value;
	((ContactsChunkClass *) klass)->save_to_persona = (void (*) (ContactsChunk*, GAsyncReadyCallback, gpointer)) contacts_birthday_chunk_real_save_to_persona;
	((ContactsChunkClass *) klass)->save_to_persona_finish = (void (*) (ContactsChunk*, GAsyncResult*, GError**)) contacts_birthday_chunk_save_to_persona_finish;
	CONTACTS_CHUNK_CLASS (klass)->get_property_name = contacts_birthday_chunk_real_get_property_name;
	CONTACTS_CHUNK_CLASS (klass)->get_is_empty = contacts_birthday_chunk_real_get_is_empty;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_birthday_chunk_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_birthday_chunk_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_birthday_chunk_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_birthday_chunk_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIRTHDAY_CHUNK_BIRTHDAY_PROPERTY, contacts_birthday_chunk_properties[CONTACTS_BIRTHDAY_CHUNK_BIRTHDAY_PROPERTY] = g_param_spec_boxed ("birthday", "birthday", "birthday", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIRTHDAY_CHUNK_PROPERTY_NAME_PROPERTY, contacts_birthday_chunk_properties[CONTACTS_BIRTHDAY_CHUNK_PROPERTY_NAME_PROPERTY] = g_param_spec_string ("property-name", "property-name", "property-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIRTHDAY_CHUNK_IS_EMPTY_PROPERTY, contacts_birthday_chunk_properties[CONTACTS_BIRTHDAY_CHUNK_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_birthday_chunk_instance_init (ContactsBirthdayChunk * self,
                                       gpointer klass)
{
	self->priv = contacts_birthday_chunk_get_instance_private (self);
	self->priv->_birthday = NULL;
}

static void
contacts_birthday_chunk_finalize (GObject * obj)
{
	ContactsBirthdayChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_BIRTHDAY_CHUNK, ContactsBirthdayChunk);
	_g_date_time_unref0 (self->priv->_birthday);
	G_OBJECT_CLASS (contacts_birthday_chunk_parent_class)->finalize (obj);
}

/**
 * A {@link Chunk} that represents the birthday of a contact (similar to
 * {@link Folks.BirthdayDetails}}.
 */
 G_GNUC_NO_INLINE static GType
contacts_birthday_chunk_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsBirthdayChunkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_birthday_chunk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsBirthdayChunk), 0, (GInstanceInitFunc) contacts_birthday_chunk_instance_init, NULL };
	GType contacts_birthday_chunk_type_id;
	contacts_birthday_chunk_type_id = g_type_register_static (CONTACTS_TYPE_CHUNK, "ContactsBirthdayChunk", &g_define_type_info, 0);
	ContactsBirthdayChunk_private_offset = g_type_add_instance_private (contacts_birthday_chunk_type_id, sizeof (ContactsBirthdayChunkPrivate));
	return contacts_birthday_chunk_type_id;
}

GType
contacts_birthday_chunk_get_type (void)
{
	static volatile gsize contacts_birthday_chunk_type_id__once = 0;
	if (g_once_init_enter (&contacts_birthday_chunk_type_id__once)) {
		GType contacts_birthday_chunk_type_id;
		contacts_birthday_chunk_type_id = contacts_birthday_chunk_get_type_once ();
		g_once_init_leave (&contacts_birthday_chunk_type_id__once, contacts_birthday_chunk_type_id);
	}
	return contacts_birthday_chunk_type_id__once;
}

static void
_vala_contacts_birthday_chunk_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ContactsBirthdayChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_BIRTHDAY_CHUNK, ContactsBirthdayChunk);
	switch (property_id) {
		case CONTACTS_BIRTHDAY_CHUNK_BIRTHDAY_PROPERTY:
		g_value_set_boxed (value, contacts_birthday_chunk_get_birthday (self));
		break;
		case CONTACTS_BIRTHDAY_CHUNK_PROPERTY_NAME_PROPERTY:
		g_value_set_string (value, contacts_chunk_get_property_name ((ContactsChunk*) self));
		break;
		case CONTACTS_BIRTHDAY_CHUNK_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, contacts_chunk_get_is_empty ((ContactsChunk*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_birthday_chunk_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	ContactsBirthdayChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_BIRTHDAY_CHUNK, ContactsBirthdayChunk);
	switch (property_id) {
		case CONTACTS_BIRTHDAY_CHUNK_BIRTHDAY_PROPERTY:
		contacts_birthday_chunk_set_birthday (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

