/* contacts-bin-chunk.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-bin-chunk.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "contactscore.h"
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>

enum  {
	CONTACTS_BIN_CHUNK_0_PROPERTY,
	CONTACTS_BIN_CHUNK_IS_EMPTY_PROPERTY,
	CONTACTS_BIN_CHUNK_N_ITEMS_PROPERTY,
	CONTACTS_BIN_CHUNK_ITEM_TYPE_PROPERTY,
	CONTACTS_BIN_CHUNK_NUM_PROPERTIES
};
static GParamSpec* contacts_bin_chunk_properties[CONTACTS_BIN_CHUNK_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	CONTACTS_BIN_CHUNK_CHILD_0_PROPERTY,
	CONTACTS_BIN_CHUNK_CHILD_PARAMETERS_PROPERTY,
	CONTACTS_BIN_CHUNK_CHILD_IS_EMPTY_PROPERTY,
	CONTACTS_BIN_CHUNK_CHILD_ICON_NAME_PROPERTY,
	CONTACTS_BIN_CHUNK_CHILD_NUM_PROPERTIES
};
static GParamSpec* contacts_bin_chunk_child_properties[CONTACTS_BIN_CHUNK_CHILD_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsBinChunkPrivate {
	GPtrArray* elements;
};

struct _ContactsBinChunkChildPrivate {
	GeeMultiMap* _parameters;
};

static gint ContactsBinChunk_private_offset;
static gpointer contacts_bin_chunk_parent_class = NULL;
static GListModelInterface * contacts_bin_chunk_g_list_model_parent_iface = NULL;
static gint ContactsBinChunkChild_private_offset;
static gpointer contacts_bin_chunk_child_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static gboolean contacts_bin_chunk_has_empty_child (ContactsBinChunk* self);
static void __lambda4_ (ContactsBinChunk* self,
                 GObject* obj,
                 GParamSpec* pspec);
static void ___lambda4__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static ContactsBinChunkChild* contacts_bin_chunk_real_create_empty_child (ContactsBinChunk* self);
static GValue* contacts_bin_chunk_real_to_value (ContactsChunk* base);
static GObject* contacts_bin_chunk_real_get_item (GListModel* base,
                                           guint i);
static guint contacts_bin_chunk_real_get_n_items (GListModel* base);
static GType contacts_bin_chunk_real_get_item_type (GListModel* base);
static void contacts_bin_chunk_finalize (GObject * obj);
static GType contacts_bin_chunk_get_type_once (void);
static void _vala_contacts_bin_chunk_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static FolksAbstractFieldDetails* contacts_bin_chunk_child_real_create_afd (ContactsBinChunkChild* self);
static void contacts_bin_chunk_child_finalize (GObject * obj);
static GType contacts_bin_chunk_child_get_type_once (void);
static void _vala_contacts_bin_chunk_child_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_contacts_bin_chunk_child_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
contacts_bin_chunk_get_instance_private (ContactsBinChunk* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsBinChunk_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

/**
   * Should be called by subclasses when they add a child.
   *
   * It will make sure to add the child in the appropriate position and that
   * the emptines check is appropriately applied.
   */
static void
__lambda4_ (ContactsBinChunk* self,
            GObject* obj,
            GParamSpec* pspec)
{
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	g_debug ("contacts-bin-chunk.vala:57: Child 'is-empty' changed, doing emptiness " \
"check");
	contacts_bin_chunk_emptiness_check (self);
}

static void
___lambda4__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda4_ ((ContactsBinChunk*) self, _sender, pspec);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
contacts_bin_chunk_add_child (ContactsBinChunk* self,
                              ContactsBinChunkChild* child)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint i = 0;
	GPtrArray* _tmp9_;
	ContactsBinChunkChild* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp1_ = contacts_bin_chunk_child_get_is_empty (child);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = contacts_bin_chunk_has_empty_child (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	g_signal_connect_object ((GObject*) child, "notify::is-empty", (GCallback) ___lambda4__g_object_notify, self, 0);
	i = 0;
	while (TRUE) {
		GPtrArray* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		GPtrArray* _tmp6_;
		gconstpointer _tmp7_;
		gint _tmp8_;
		_tmp3_ = self->priv->elements;
		_tmp4_ = vala_g_ptr_array_get_length (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!(i < _tmp5_)) {
			break;
		}
		_tmp6_ = self->priv->elements;
		_tmp7_ = g_ptr_array_index (_tmp6_, (guint) i);
		if (contacts_bin_chunk_child_compare (child, (ContactsBinChunkChild*) _tmp7_) < 0) {
			break;
		}
		_tmp8_ = i;
		i = _tmp8_ + 1;
	}
	_tmp9_ = self->priv->elements;
	_tmp10_ = _g_object_ref0 (child);
	g_ptr_array_insert (_tmp9_, i, _tmp10_);
	g_list_model_items_changed ((GListModel*) self, (guint) i, (guint) 0, (guint) 1);
}

/**
   * Subclasses should implement this to create an empty child (which will be
   * used for the emptiness check).
   */
static ContactsBinChunkChild*
contacts_bin_chunk_real_create_empty_child (ContactsBinChunk* self)
{
	g_critical ("Type `%s' does not implement abstract method `contacts_bin_chunk_create_empty_child'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

ContactsBinChunkChild*
contacts_bin_chunk_create_empty_child (ContactsBinChunk* self)
{
	ContactsBinChunkClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONTACTS_BIN_CHUNK_GET_CLASS (self);
	if (_klass_->create_empty_child) {
		return _klass_->create_empty_child (self);
	}
	return NULL;
}

void
contacts_bin_chunk_emptiness_check (ContactsBinChunk* self)
{
	ContactsBinChunkChild* child = NULL;
	ContactsBinChunkChild* _tmp0_;
	ContactsBinChunkChild* _tmp1_;
	g_return_if_fail (self != NULL);
	if (contacts_bin_chunk_has_empty_child (self)) {
		return;
	}
	_tmp0_ = contacts_bin_chunk_create_empty_child (self);
	child = _tmp0_;
	_tmp1_ = child;
	contacts_bin_chunk_add_child (self, _tmp1_);
	_g_object_unref0 (child);
}

static gboolean
contacts_bin_chunk_has_empty_child (ContactsBinChunk* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->elements;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < ((guint) _tmp4_))) {
					break;
				}
				_tmp5_ = self->priv->elements;
				_tmp6_ = g_ptr_array_index (_tmp5_, i);
				_tmp7_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static GValue*
contacts_bin_chunk_real_to_value (ContactsChunk* base)
{
	ContactsBinChunk * self;
	GeeHashSet* afds = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp12_ = NULL;
	GeeHashSet* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GValue* _tmp17_ = NULL;
	GValue* result;
	self = (ContactsBinChunk*) base;
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	afds = _tmp0_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				FolksAbstractFieldDetails* afd = NULL;
				GPtrArray* _tmp6_;
				gconstpointer _tmp7_;
				FolksAbstractFieldDetails* _tmp8_;
				FolksAbstractFieldDetails* _tmp9_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->elements;
				_tmp4_ = vala_g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < ((guint) _tmp5_))) {
					break;
				}
				_tmp6_ = self->priv->elements;
				_tmp7_ = g_ptr_array_index (_tmp6_, i);
				_tmp8_ = contacts_bin_chunk_child_create_afd ((ContactsBinChunkChild*) _tmp7_);
				afd = _tmp8_;
				_tmp9_ = afd;
				if (_tmp9_ != NULL) {
					GeeHashSet* _tmp10_;
					FolksAbstractFieldDetails* _tmp11_;
					_tmp10_ = afds;
					_tmp11_ = afd;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
				}
				_g_object_unref0 (afd);
			}
		}
	}
	_tmp13_ = afds;
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != 0) {
		GeeHashSet* _tmp16_;
		_tmp16_ = afds;
		_tmp12_ = _tmp16_;
	} else {
		_tmp12_ = NULL;
	}
	_tmp17_ = g_new0 (GValue, 1);
	g_value_init (_tmp17_, GEE_TYPE_HASH_SET);
	g_value_set_object (_tmp17_, _tmp12_);
	result = _tmp17_;
	_g_object_unref0 (afds);
	return result;
}

/** A helper function to collect the AbstractFieldDetails of the children */
GeeSet*
contacts_bin_chunk_get_abstract_field_details (ContactsBinChunk* self)
{
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	GeeHashSet* afds = NULL;
	GeeHashSet* _tmp2_;
	GeeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_chunk_get_persona ((ContactsChunk*) self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "this.persona != null", NULL);
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	afds = _tmp2_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				FolksAbstractFieldDetails* afd = NULL;
				GPtrArray* _tmp8_;
				gconstpointer _tmp9_;
				FolksAbstractFieldDetails* _tmp10_;
				FolksAbstractFieldDetails* _tmp11_;
				if (!_tmp3_) {
					guint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->elements;
				_tmp6_ = vala_g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < ((guint) _tmp7_))) {
					break;
				}
				_tmp8_ = self->priv->elements;
				_tmp9_ = g_ptr_array_index (_tmp8_, i);
				_tmp10_ = contacts_bin_chunk_child_create_afd ((ContactsBinChunkChild*) _tmp9_);
				afd = _tmp10_;
				_tmp11_ = afd;
				if (_tmp11_ != NULL) {
					GeeHashSet* _tmp12_;
					FolksAbstractFieldDetails* _tmp13_;
					_tmp12_ = afds;
					_tmp13_ = afd;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				}
				_g_object_unref0 (afd);
			}
		}
	}
	result = (GeeSet*) afds;
	return result;
}

static GObject*
contacts_bin_chunk_real_get_item (GListModel* base,
                                  guint i)
{
	ContactsBinChunk * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	gconstpointer _tmp4_;
	GObject* _tmp5_;
	GObject* result;
	self = (ContactsBinChunk*) base;
	_tmp0_ = self->priv->elements;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (i > ((guint) _tmp2_)) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->elements;
	_tmp4_ = g_ptr_array_index (_tmp3_, i);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ContactsBinChunkChild*) _tmp4_, G_TYPE_OBJECT, GObject));
	result = _tmp5_;
	return result;
}

static guint
contacts_bin_chunk_real_get_n_items (GListModel* base)
{
	ContactsBinChunk * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
	self = (ContactsBinChunk*) base;
	_tmp0_ = self->priv->elements;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

static GType
contacts_bin_chunk_real_get_item_type (GListModel* base)
{
	ContactsBinChunk * self;
	GType result;
	self = (ContactsBinChunk*) base;
	result = CONTACTS_TYPE_BIN_CHUNK_CHILD;
	return result;
}

ContactsBinChunk*
contacts_bin_chunk_construct (GType object_type)
{
	ContactsBinChunk * self = NULL;
	self = (ContactsBinChunk*) contacts_chunk_construct (object_type);
	return self;
}

static gboolean
contacts_bin_chunk_real_get_is_empty (ContactsChunk* base)
{
	gboolean result;
	ContactsBinChunk* self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	self = (ContactsBinChunk*) base;
	_tmp0_ = self->priv->elements;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = TRUE;
		return result;
	}
	_tmp3_ = self->priv->elements;
	{
		GPtrArray* chunk_element_collection = NULL;
		guint chunk_element_index = 0U;
		chunk_element_collection = _tmp3_;
		for (chunk_element_index = 0; chunk_element_index < chunk_element_collection->len; chunk_element_index = chunk_element_index + 1) {
			ContactsBinChunkChild* _tmp4_;
			ContactsBinChunkChild* chunk_element = NULL;
			_tmp4_ = _g_object_ref0 (g_ptr_array_index (chunk_element_collection, chunk_element_index));
			chunk_element = _tmp4_;
			{
				ContactsBinChunkChild* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
				_tmp5_ = chunk_element;
				_tmp6_ = contacts_bin_chunk_child_get_is_empty (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					result = FALSE;
					_g_object_unref0 (chunk_element);
					return result;
				}
				_g_object_unref0 (chunk_element);
			}
		}
	}
	result = TRUE;
	return result;
}

guint
contacts_bin_chunk_get_n_items (ContactsBinChunk* self)
{
	guint result;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->elements;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

GType
contacts_bin_chunk_get_item_type (ContactsBinChunk* self)
{
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = CONTACTS_TYPE_BIN_CHUNK_CHILD;
	return result;
}

static void
contacts_bin_chunk_class_init (ContactsBinChunkClass * klass,
                               gpointer klass_data)
{
	contacts_bin_chunk_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsBinChunk_private_offset);
	((ContactsBinChunkClass *) klass)->create_empty_child = (ContactsBinChunkChild* (*) (ContactsBinChunk*)) contacts_bin_chunk_real_create_empty_child;
	((ContactsChunkClass *) klass)->to_value = (GValue* (*) (ContactsChunk*)) contacts_bin_chunk_real_to_value;
	CONTACTS_CHUNK_CLASS (klass)->get_is_empty = contacts_bin_chunk_real_get_is_empty;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_bin_chunk_get_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_bin_chunk_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_IS_EMPTY_PROPERTY, contacts_bin_chunk_properties[CONTACTS_BIN_CHUNK_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_N_ITEMS_PROPERTY, contacts_bin_chunk_properties[CONTACTS_BIN_CHUNK_N_ITEMS_PROPERTY] = g_param_spec_uint ("n-items", "n-items", "n-items", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_ITEM_TYPE_PROPERTY, contacts_bin_chunk_properties[CONTACTS_BIN_CHUNK_ITEM_TYPE_PROPERTY] = g_param_spec_gtype ("item-type", "item-type", "item-type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_bin_chunk_g_list_model_interface_init (GListModelInterface * iface,
                                                gpointer iface_data)
{
	contacts_bin_chunk_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item = (GObject* (*) (GListModel*, guint)) contacts_bin_chunk_real_get_item;
	iface->get_n_items = (guint (*) (GListModel*)) contacts_bin_chunk_real_get_n_items;
	iface->get_item_type = (GType (*) (GListModel*)) contacts_bin_chunk_real_get_item_type;
}

static void
contacts_bin_chunk_instance_init (ContactsBinChunk * self,
                                  gpointer klass)
{
	GPtrArray* _tmp0_;
	self->priv = contacts_bin_chunk_get_instance_private (self);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->elements = _tmp0_;
}

static void
contacts_bin_chunk_finalize (GObject * obj)
{
	ContactsBinChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_BIN_CHUNK, ContactsBinChunk);
	_g_ptr_array_unref0 (self->priv->elements);
	G_OBJECT_CLASS (contacts_bin_chunk_parent_class)->finalize (obj);
}

/**
 * A {@link Chunk} that aggregates multiple values associated to a property
 * (for example, a chunk for phone numbers, or email addresses). These values
 * are represented as {@link BinChunkChild}ren, which BinChunk exposes through
 * the {@link GLib.ListModel} interface.
 *
 * One important property of BinkChunk is that it makes sure at least one empty
 * child exists. This allows us to expose an immutable interface, while being
 * able to synchronize with our UI (which expects this kind of behavior)
 */
 G_GNUC_NO_INLINE static GType
contacts_bin_chunk_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsBinChunkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_bin_chunk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsBinChunk), 0, (GInstanceInitFunc) contacts_bin_chunk_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) contacts_bin_chunk_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType contacts_bin_chunk_type_id;
	contacts_bin_chunk_type_id = g_type_register_static (CONTACTS_TYPE_CHUNK, "ContactsBinChunk", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (contacts_bin_chunk_type_id, g_list_model_get_type (), &g_list_model_info);
	ContactsBinChunk_private_offset = g_type_add_instance_private (contacts_bin_chunk_type_id, sizeof (ContactsBinChunkPrivate));
	return contacts_bin_chunk_type_id;
}

GType
contacts_bin_chunk_get_type (void)
{
	static volatile gsize contacts_bin_chunk_type_id__once = 0;
	if (g_once_init_enter (&contacts_bin_chunk_type_id__once)) {
		GType contacts_bin_chunk_type_id;
		contacts_bin_chunk_type_id = contacts_bin_chunk_get_type_once ();
		g_once_init_leave (&contacts_bin_chunk_type_id__once, contacts_bin_chunk_type_id);
	}
	return contacts_bin_chunk_type_id__once;
}

static void
_vala_contacts_bin_chunk_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	ContactsBinChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_BIN_CHUNK, ContactsBinChunk);
	switch (property_id) {
		case CONTACTS_BIN_CHUNK_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, contacts_chunk_get_is_empty ((ContactsChunk*) self));
		break;
		case CONTACTS_BIN_CHUNK_N_ITEMS_PROPERTY:
		g_value_set_uint (value, contacts_bin_chunk_get_n_items (self));
		break;
		case CONTACTS_BIN_CHUNK_ITEM_TYPE_PROPERTY:
		g_value_set_gtype (value, contacts_bin_chunk_get_item_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_bin_chunk_child_get_instance_private (ContactsBinChunkChild* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsBinChunkChild_private_offset);
}

/**
   * Creates an AbstractFieldDetails from the contents of this child
   *
   * If the contents are invalid (or empty), it returns null.
   */
static FolksAbstractFieldDetails*
contacts_bin_chunk_child_real_create_afd (ContactsBinChunkChild* self)
{
	g_critical ("Type `%s' does not implement abstract method `contacts_bin_chunk_child_create_afd'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

FolksAbstractFieldDetails*
contacts_bin_chunk_child_create_afd (ContactsBinChunkChild* self)
{
	ContactsBinChunkChildClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONTACTS_BIN_CHUNK_CHILD_GET_CLASS (self);
	if (_klass_->create_afd) {
		return _klass_->create_afd (self);
	}
	return NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
contacts_bin_chunk_child_change_string_prop (ContactsBinChunkChild* self,
                                             const gchar* prop_name,
                                             gchar** old_value,
                                             const gchar* new_value)
{
	gboolean notify_empty = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop_name != NULL);
	g_return_if_fail (*old_value != NULL);
	g_return_if_fail (new_value != NULL);
	if (g_strcmp0 (new_value, *old_value) == 0) {
		return;
	}
	_tmp0_ = string_strip (new_value);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (*old_value);
	_tmp3_ = _tmp2_;
	_tmp4_ = (g_strcmp0 (_tmp1_, "") == 0) != (g_strcmp0 (_tmp3_, "") == 0);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	notify_empty = _tmp4_;
	_tmp5_ = g_strdup (new_value);
	_g_free0 (*old_value);
	*old_value = _tmp5_;
	g_object_notify ((GObject*) self, prop_name);
	if (notify_empty) {
		g_object_notify ((GObject*) self, "is-empty");
	}
}

/**
   * Compares 2 children in an intuitive manner, so that preferred children go
   * first and empty children are last
   */
gint
contacts_bin_chunk_child_compare (ContactsBinChunkChild* self,
                                  ContactsBinChunkChild* other)
{
	gboolean has_pref = FALSE;
	gboolean empty = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	has_pref = contacts_bin_chunk_child_has_pref_marker (self);
	if (has_pref != contacts_bin_chunk_child_has_pref_marker (other)) {
		gint _tmp0_ = 0;
		if (has_pref) {
			_tmp0_ = -1;
		} else {
			_tmp0_ = 1;
		}
		result = _tmp0_;
		return result;
	}
	_tmp1_ = contacts_bin_chunk_child_get_is_empty (self);
	_tmp2_ = _tmp1_;
	empty = _tmp2_;
	_tmp3_ = contacts_bin_chunk_child_get_is_empty (other);
	_tmp4_ = _tmp3_;
	if (empty != _tmp4_) {
		gint _tmp5_ = 0;
		if (empty) {
			_tmp5_ = 1;
		} else {
			_tmp5_ = -1;
		}
		result = _tmp5_;
		return result;
	}
	result = 0;
	return result;
}

/**
   * Returns whether this child is marked as the "preferred" child, similar to
   * the vCard PREF attribute
   */
gboolean
contacts_bin_chunk_child_has_pref_marker (ContactsBinChunkChild* self)
{
	GeeCollection* evolution_pref = NULL;
	GeeMultiMap* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeCollection* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_parameters;
	_tmp1_ = gee_multi_map_get (_tmp0_, "x-evolution-ui-slot");
	evolution_pref = _tmp1_;
	_tmp3_ = evolution_pref;
	if (_tmp3_ != NULL) {
		GeeCollection* _tmp4_;
		_tmp4_ = evolution_pref;
		_tmp2_ = gee_collection_contains (_tmp4_, "1");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		_g_object_unref0 (evolution_pref);
		return result;
	}
	{
		GeeIterator* _param_it = NULL;
		GeeMultiMap* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp5_ = self->priv->_parameters;
		_tmp6_ = gee_multi_map_get (_tmp5_, "type");
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_param_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			gchar* param = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			const gchar* _tmp13_;
			_tmp10_ = _param_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _param_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			param = (gchar*) _tmp12_;
			_tmp13_ = param;
			if (g_ascii_strcasecmp (_tmp13_, "PREF") == 0) {
				result = TRUE;
				_g_free0 (param);
				_g_object_unref0 (_param_it);
				_g_object_unref0 (evolution_pref);
				return result;
			}
			_g_free0 (param);
		}
		_g_object_unref0 (_param_it);
	}
	result = FALSE;
	_g_object_unref0 (evolution_pref);
	return result;
}

ContactsBinChunkChild*
contacts_bin_chunk_child_construct (GType object_type)
{
	ContactsBinChunkChild * self = NULL;
	self = (ContactsBinChunkChild*) g_object_new (object_type, NULL);
	return self;
}

GeeMultiMap*
contacts_bin_chunk_child_get_parameters (ContactsBinChunkChild* self)
{
	GeeMultiMap* result;
	GeeMultiMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parameters;
	result = _tmp0_;
	return result;
}

void
contacts_bin_chunk_child_set_parameters (ContactsBinChunkChild* self,
                                         GeeMultiMap* value)
{
	GeeMultiMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_bin_chunk_child_get_parameters (self);
	if (old_value != value) {
		GeeMultiMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_parameters);
		self->priv->_parameters = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_bin_chunk_child_properties[CONTACTS_BIN_CHUNK_CHILD_PARAMETERS_PROPERTY]);
	}
}

gboolean
contacts_bin_chunk_child_get_is_empty (ContactsBinChunkChild* self)
{
	ContactsBinChunkChildClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = CONTACTS_BIN_CHUNK_CHILD_GET_CLASS (self);
	if (_klass_->get_is_empty) {
		return _klass_->get_is_empty (self);
	}
	return FALSE;
}

const gchar*
contacts_bin_chunk_child_get_icon_name (ContactsBinChunkChild* self)
{
	ContactsBinChunkChildClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONTACTS_BIN_CHUNK_CHILD_GET_CLASS (self);
	if (_klass_->get_icon_name) {
		return _klass_->get_icon_name (self);
	}
	return NULL;
}

static void
contacts_bin_chunk_child_class_init (ContactsBinChunkChildClass * klass,
                                     gpointer klass_data)
{
	contacts_bin_chunk_child_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsBinChunkChild_private_offset);
	((ContactsBinChunkChildClass *) klass)->create_afd = (FolksAbstractFieldDetails* (*) (ContactsBinChunkChild*)) contacts_bin_chunk_child_real_create_afd;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_bin_chunk_child_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_bin_chunk_child_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_bin_chunk_child_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_CHILD_PARAMETERS_PROPERTY, contacts_bin_chunk_child_properties[CONTACTS_BIN_CHUNK_CHILD_PARAMETERS_PROPERTY] = g_param_spec_object ("parameters", "parameters", "parameters", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Whether this BinChunkChild is empty. You can use the notify signal to
	   * listen for changes.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_CHILD_IS_EMPTY_PROPERTY, contacts_bin_chunk_child_properties[CONTACTS_BIN_CHUNK_CHILD_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * The icon name that best represents this BinChunkChild
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIN_CHUNK_CHILD_ICON_NAME_PROPERTY, contacts_bin_chunk_child_properties[CONTACTS_BIN_CHUNK_CHILD_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_bin_chunk_child_instance_init (ContactsBinChunkChild * self,
                                        gpointer klass)
{
	self->priv = contacts_bin_chunk_child_get_instance_private (self);
}

static void
contacts_bin_chunk_child_finalize (GObject * obj)
{
	ContactsBinChunkChild * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_BIN_CHUNK_CHILD, ContactsBinChunkChild);
	_g_object_unref0 (self->priv->_parameters);
	G_OBJECT_CLASS (contacts_bin_chunk_child_parent_class)->finalize (obj);
}

/**
 * A child of a {@link BinChunk}
 */
 G_GNUC_NO_INLINE static GType
contacts_bin_chunk_child_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsBinChunkChildClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_bin_chunk_child_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsBinChunkChild), 0, (GInstanceInitFunc) contacts_bin_chunk_child_instance_init, NULL };
	GType contacts_bin_chunk_child_type_id;
	contacts_bin_chunk_child_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsBinChunkChild", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ContactsBinChunkChild_private_offset = g_type_add_instance_private (contacts_bin_chunk_child_type_id, sizeof (ContactsBinChunkChildPrivate));
	return contacts_bin_chunk_child_type_id;
}

GType
contacts_bin_chunk_child_get_type (void)
{
	static volatile gsize contacts_bin_chunk_child_type_id__once = 0;
	if (g_once_init_enter (&contacts_bin_chunk_child_type_id__once)) {
		GType contacts_bin_chunk_child_type_id;
		contacts_bin_chunk_child_type_id = contacts_bin_chunk_child_get_type_once ();
		g_once_init_leave (&contacts_bin_chunk_child_type_id__once, contacts_bin_chunk_child_type_id);
	}
	return contacts_bin_chunk_child_type_id__once;
}

static void
_vala_contacts_bin_chunk_child_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ContactsBinChunkChild * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_BIN_CHUNK_CHILD, ContactsBinChunkChild);
	switch (property_id) {
		case CONTACTS_BIN_CHUNK_CHILD_PARAMETERS_PROPERTY:
		g_value_set_object (value, contacts_bin_chunk_child_get_parameters (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_bin_chunk_child_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	ContactsBinChunkChild * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_BIN_CHUNK_CHILD, ContactsBinChunkChild);
	switch (property_id) {
		case CONTACTS_BIN_CHUNK_CHILD_PARAMETERS_PROPERTY:
		contacts_bin_chunk_child_set_parameters (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

