/* contacts-type-set.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-type-set.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "contactscore.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gee.h>

#define CONTACTS_TYPE_VCARD_TYPE_MAPPING (contacts_vcard_type_mapping_get_type ())
typedef struct _ContactsVcardTypeMapping ContactsVcardTypeMapping;
enum  {
	CONTACTS_TYPESET_0_PROPERTY,
	CONTACTS_TYPESET_CATEGORY_PROPERTY,
	CONTACTS_TYPESET_NUM_PROPERTIES
};
static GParamSpec* contacts_typeset_properties[CONTACTS_TYPESET_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _ContactsVcardTypeMapping {
	const gchar* name;
	const gchar* types[3];
};

struct _ContactsTypeSetPrivate {
	gchar* _category;
	ContactsTypeDescriptor* other_dummy;
	GPtrArray* vcard_type_mappings;
	GPtrArray* descriptors;
};

static gint ContactsTypeSet_private_offset;
static gpointer contacts_typeset_parent_class = NULL;
static ContactsTypeSet* contacts_typeset__general;
static ContactsTypeSet* contacts_typeset__general = NULL;
static ContactsTypeSet* contacts_typeset__email;
static ContactsTypeSet* contacts_typeset__email = NULL;
static ContactsTypeSet* contacts_typeset__phone;
static ContactsTypeSet* contacts_typeset__phone = NULL;
static GListModelInterface * contacts_typeset_g_list_model_parent_iface = NULL;

VALA_EXTERN GType contacts_vcard_type_mapping_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ContactsVcardTypeMapping* contacts_vcard_type_mapping_dup (const ContactsVcardTypeMapping* self);
VALA_EXTERN void contacts_vcard_type_mapping_free (ContactsVcardTypeMapping* self);
static void _contacts_vcard_type_mapping_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static ContactsTypeSet* contacts_typeset_new (const gchar* category);
static ContactsTypeSet* contacts_typeset_construct (GType object_type,
                                             const gchar* category);
static void contacts_typeset_add_descriptor (ContactsTypeSet* self,
                                      ContactsTypeDescriptor* descriptor);
static void contacts_typeset_add_vcard_mapping (ContactsTypeSet* self,
                                         ContactsVcardTypeMapping* vcard_mapping);
static ContactsTypeDescriptor* contacts_typeset_create_descriptor_for_custom_label (ContactsTypeSet* self,
                                                                             const gchar* label);
VALA_EXTERN gboolean contacts_vcard_type_mapping_contains (ContactsVcardTypeMapping *self,
                                               const gchar* type);
VALA_EXTERN gboolean contacts_vcard_type_mapping_matches (ContactsVcardTypeMapping *self,
                                              GeeCollection* types);
static GType contacts_typeset_real_get_item_type (GListModel* base);
static guint contacts_typeset_real_get_n_items (GListModel* base);
static GObject* contacts_typeset_real_get_item (GListModel* base,
                                         guint i);
static void contacts_typeset_finalize (GObject * obj);
static GType contacts_typeset_get_type_once (void);
static void _vala_contacts_typeset_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_contacts_typeset_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const ContactsVcardTypeMapping CONTACTS_TYPESET_general_data[2] = {{N_ ("Home"), {"HOME"}}, {N_ ("Work"), {"WORK"}}};
static const ContactsVcardTypeMapping CONTACTS_TYPESET_email_data[3] = {{N_ ("Personal"), {"PERSONAL"}}, {N_ ("Home"), {"HOME"}}, {N_ ("Work"), {"WORK"}}};
static const ContactsVcardTypeMapping CONTACTS_TYPESET_phone_data[18] = {{N_ ("Assistant"), {"X-EVOLUTION-ASSISTANT"}}, {N_ ("Work"), {"WORK", "VOICE"}}, {N_ ("Work Fax"), {"WORK", "FAX"}}, {N_ ("Work"), {"WORK"}}, {N_ ("Callback"), {"X-EVOLUTION-CALLBACK"}}, {N_ ("Car"), {"CAR"}}, {N_ ("Company"), {"X-EVOLUTION-COMPANY"}}, {N_ ("Home"), {"HOME", "VOICE"}}, {N_ ("Home Fax"), {"HOME", "FAX"}}, {N_ ("Home"), {"HOME"}}, {N_ ("ISDN"), {"ISDN"}}, {N_ ("Mobile"), {"CELL"}}, {N_ ("Other"), {"VOICE"}}, {N_ ("Fax"), {"FAX"}}, {N_ ("Pager"), {"PAGER"}}, {N_ ("Radio"), {"X-EVOLUTION-RADIO"}}, {N_ ("Telex"), {"X-EVOLUTION-TELEX"}}, {N_ ("TTY"), {"X-EVOLUTION-TTYTDD"}}};

static inline gpointer
contacts_typeset_get_instance_private (ContactsTypeSet* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsTypeSet_private_offset);
}

static void
_contacts_vcard_type_mapping_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (contacts_vcard_type_mapping_free (var), NULL));
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

/**
   * Creates a TypeSet for the given category, e.g. "phones" (used for debugging)
   */
static ContactsTypeSet*
contacts_typeset_construct (GType object_type,
                            const gchar* category)
{
	ContactsTypeSet * self = NULL;
	self = (ContactsTypeSet*) g_object_new (object_type, "category", category, NULL);
	return self;
}

static ContactsTypeSet*
contacts_typeset_new (const gchar* category)
{
	return contacts_typeset_construct (CONTACTS_TYPE_TYPESET, category);
}

/**
   * Adds the TypeDescriptor to the {@link TypeSet}'s store.
   * @param descriptor The TypeDescription to be added
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
contacts_typeset_add_descriptor (ContactsTypeSet* self,
                                 ContactsTypeDescriptor* descriptor)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GPtrArray* _tmp3_;
	ContactsTypeDescriptor* _tmp4_;
	GPtrArray* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (descriptor != NULL);
	_tmp0_ = self->priv->_category;
	_tmp1_ = contacts_typedescriptor_to_string (descriptor);
	_tmp2_ = _tmp1_;
	g_debug ("contacts-type-set.vala:51: %s: Adding type %s to store", _tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->descriptors;
	_tmp4_ = _g_object_ref0 (descriptor);
	g_ptr_array_add (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->descriptors;
	_tmp6_ = vala_g_ptr_array_get_length (_tmp5_);
	_tmp7_ = _tmp6_;
	g_list_model_items_changed ((GListModel*) self, (guint) (_tmp7_ - 1), (guint) 0, (guint) 1);
}

/**
   * Returns the TypeDescriptor for the given display name in the
   * {@link TypeSet}'s store, if any.
   *
   * @param display_name The translated display name
   * @return The appropriate TypeDescriptor or null if no match was found.
   */
ContactsTypeDescriptor*
contacts_typeset_lookup_by_display_name (ContactsTypeSet* self,
                                         const gchar* display_name,
                                         guint* position)
{
	guint _vala_position = 0U;
	ContactsTypeDescriptor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ContactsTypeDescriptor* type_descr = NULL;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				ContactsTypeDescriptor* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				ContactsTypeDescriptor* _tmp10_;
				const gchar* _tmp11_;
				ContactsTypeDescriptor* _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->descriptors;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->descriptors;
				_tmp6_ = g_ptr_array_index (_tmp5_, (guint) i);
				type_descr = (ContactsTypeDescriptor*) _tmp6_;
				_tmp7_ = type_descr;
				_tmp8_ = contacts_typedescriptor_get_display_name (_tmp7_);
				_tmp9_ = _tmp8_;
				if (g_ascii_strcasecmp (display_name, _tmp9_) != 0) {
					continue;
				}
				_tmp10_ = type_descr;
				_tmp11_ = _tmp10_->name;
				if (g_ascii_strcasecmp (display_name, _tmp11_) != 0) {
					continue;
				}
				_vala_position = (guint) i;
				_tmp12_ = type_descr;
				result = _tmp12_;
				if (position) {
					*position = _vala_position;
				}
				return result;
			}
		}
	}
	_vala_position = (guint) 0;
	result = NULL;
	if (position) {
		*position = _vala_position;
	}
	return result;
}

static gpointer
_contacts_vcard_type_mapping_dup0 (gpointer self)
{
	return self ? contacts_vcard_type_mapping_dup (self) : NULL;
}

static void
contacts_typeset_add_vcard_mapping (ContactsTypeSet* self,
                                    ContactsVcardTypeMapping* vcard_mapping)
{
	guint position = 0U;
	ContactsTypeDescriptor* descriptor = NULL;
	ContactsVcardTypeMapping _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_ = 0U;
	ContactsTypeDescriptor* _tmp3_;
	ContactsTypeDescriptor* _tmp4_;
	ContactsTypeDescriptor* _tmp5_;
	GPtrArray* _tmp15_;
	ContactsVcardTypeMapping _tmp16_;
	ContactsVcardTypeMapping* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard_mapping != NULL);
	_tmp0_ = *vcard_mapping;
	_tmp1_ = _tmp0_.name;
	_tmp3_ = contacts_typeset_lookup_by_display_name (self, _tmp1_, &_tmp2_);
	position = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	descriptor = _tmp4_;
	_tmp5_ = descriptor;
	if (_tmp5_ == NULL) {
		ContactsVcardTypeMapping _tmp6_;
		const gchar* _tmp7_;
		ContactsVcardTypeMapping _tmp8_;
		ContactsTypeDescriptor* _tmp9_;
		const gchar* _tmp10_;
		ContactsTypeDescriptor* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		ContactsTypeDescriptor* _tmp14_;
		_tmp6_ = *vcard_mapping;
		_tmp7_ = _tmp6_.name;
		_tmp8_ = *vcard_mapping;
		_tmp9_ = contacts_typedescriptor_new_vcard (_tmp7_, _tmp8_.types, 3);
		_g_object_unref0 (descriptor);
		descriptor = _tmp9_;
		_tmp10_ = self->priv->_category;
		_tmp11_ = descriptor;
		_tmp12_ = contacts_typedescriptor_to_string (_tmp11_);
		_tmp13_ = _tmp12_;
		g_debug ("contacts-type-set.vala:87: %s: Adding VCard type %s to store", _tmp10_, _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = descriptor;
		contacts_typeset_add_descriptor (self, _tmp14_);
	}
	_tmp15_ = self->priv->vcard_type_mappings;
	_tmp16_ = *vcard_mapping;
	_tmp17_ = _contacts_vcard_type_mapping_dup0 (&_tmp16_);
	g_ptr_array_add (_tmp15_, _tmp17_);
	_g_object_unref0 (descriptor);
}

/**
   * Tries to find the TypeDescriptor matching the given custom label, or null if none.
   */
ContactsTypeDescriptor*
contacts_typeset_lookup_by_custom_label (ContactsTypeSet* self,
                                         const gchar* label,
                                         guint* position)
{
	guint _vala_position = 0U;
	ContactsTypeDescriptor* descriptor = NULL;
	guint _tmp0_ = 0U;
	ContactsTypeDescriptor* _tmp1_;
	ContactsTypeDescriptor* _tmp2_;
	guint _tmp5_ = 0U;
	ContactsTypeDescriptor* _tmp6_;
	ContactsTypeDescriptor* _tmp7_;
	ContactsTypeDescriptor* _tmp8_;
	ContactsTypeDescriptor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_tmp1_ = contacts_typeset_lookup_by_display_name (self, label, &_tmp0_);
	_vala_position = _tmp0_;
	descriptor = _tmp1_;
	_tmp2_ = descriptor;
	if (_tmp2_ != NULL) {
		ContactsTypeDescriptor* _tmp3_;
		ContactsTypeDescriptor* _tmp4_;
		_tmp3_ = descriptor;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		if (position) {
			*position = _vala_position;
		}
		return result;
	}
	_tmp6_ = contacts_typeset_lookup_by_vcard_type (self, label, &_tmp5_);
	_vala_position = _tmp5_;
	descriptor = _tmp6_;
	_tmp7_ = descriptor;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	result = _tmp8_;
	if (position) {
		*position = _vala_position;
	}
	return result;
}

static ContactsTypeDescriptor*
contacts_typeset_create_descriptor_for_custom_label (ContactsTypeSet* self,
                                                     const gchar* label)
{
	ContactsTypeDescriptor* new_descriptor = NULL;
	ContactsTypeDescriptor* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ContactsTypeDescriptor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = contacts_typedescriptor_new_custom (label);
	new_descriptor = _tmp0_;
	_tmp1_ = self->priv->_category;
	_tmp2_ = contacts_typedescriptor_to_string (new_descriptor);
	_tmp3_ = _tmp2_;
	g_debug ("contacts-type-set.vala:111: %s: Adding custom type %s to store", _tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	contacts_typeset_add_descriptor (self, new_descriptor);
	result = new_descriptor;
	return result;
}

/**
   * Returns the TypeDescriptor which corresponds the best to the given vcard type.
   * @param str A VCard-like type, such as "HOME" or "CELL".
   */
ContactsTypeDescriptor*
contacts_typeset_lookup_by_vcard_type (ContactsTypeSet* self,
                                       const gchar* str,
                                       guint* position)
{
	guint _vala_position = 0U;
	GPtrArray* _tmp0_;
	ContactsTypeDescriptor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = self->priv->vcard_type_mappings;
	{
		GPtrArray* mapping_collection = NULL;
		guint mapping_index = 0U;
		mapping_collection = _tmp0_;
		for (mapping_index = 0; mapping_index < mapping_collection->len; mapping_index = mapping_index + 1) {
			ContactsVcardTypeMapping* mapping = NULL;
			mapping = g_ptr_array_index (mapping_collection, mapping_index);
			{
				ContactsVcardTypeMapping* _tmp1_;
				_tmp1_ = mapping;
				if (contacts_vcard_type_mapping_contains (_tmp1_, str)) {
					ContactsVcardTypeMapping* _tmp2_;
					const gchar* _tmp3_;
					guint _tmp4_ = 0U;
					ContactsTypeDescriptor* _tmp5_;
					_tmp2_ = mapping;
					_tmp3_ = (*_tmp2_).name;
					_tmp5_ = contacts_typeset_lookup_by_display_name (self, _tmp3_, &_tmp4_);
					_vala_position = _tmp4_;
					result = _tmp5_;
					if (position) {
						*position = _vala_position;
					}
					return result;
				}
			}
		}
	}
	_vala_position = (guint) 0;
	result = NULL;
	if (position) {
		*position = _vala_position;
	}
	return result;
}

/**
   * Looks up the TypeDescriptor for the given parameters. If the descriptor
   * is not found, it will be created and returned, so this never returns null.
   */
ContactsTypeDescriptor*
contacts_typeset_lookup_by_parameters (ContactsTypeSet* self,
                                       GeeMultiMap* parameters,
                                       guint* position)
{
	guint _vala_position = 0U;
	GeeCollection* google_label = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeCollection* types = NULL;
	GeeCollection* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GeeCollection* _tmp19_;
	GPtrArray* _tmp25_;
	ContactsTypeDescriptor* _tmp33_;
	ContactsTypeDescriptor* _tmp34_;
	ContactsTypeDescriptor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parameters != NULL, NULL);
	_tmp0_ = gee_multi_map_get (parameters, CONTACTS_TYPEDESCRIPTOR_X_GOOGLE_LABEL);
	google_label = _tmp0_;
	_tmp1_ = google_label;
	_tmp2_ = gee_collection_get_is_empty (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		gchar* label = NULL;
		GeeCollection* _tmp4_;
		gint _tmp5_ = 0;
		gpointer* _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		ContactsTypeDescriptor* descriptor = NULL;
		const gchar* _tmp11_;
		guint _tmp12_ = 0U;
		ContactsTypeDescriptor* _tmp13_;
		ContactsTypeDescriptor* _tmp14_;
		_tmp4_ = google_label;
		_tmp6_ = gee_collection_to_array (_tmp4_, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp7__length1 = _tmp5_;
		_tmp8_ = _tmp7_[0];
		_tmp9_ = g_strdup (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
		label = _tmp10_;
		_tmp11_ = label;
		_tmp13_ = contacts_typeset_lookup_by_custom_label (self, _tmp11_, &_tmp12_);
		_vala_position = _tmp12_;
		descriptor = _tmp13_;
		_tmp14_ = descriptor;
		if (_tmp14_ == NULL) {
			const gchar* _tmp15_;
			ContactsTypeDescriptor* _tmp16_;
			_tmp15_ = label;
			_tmp16_ = contacts_typeset_create_descriptor_for_custom_label (self, _tmp15_);
			_g_object_unref0 (descriptor);
			descriptor = _tmp16_;
		}
		result = descriptor;
		_g_free0 (label);
		_g_object_unref0 (google_label);
		if (position) {
			*position = _vala_position;
		}
		return result;
	}
	_tmp17_ = gee_multi_map_get (parameters, "type");
	types = _tmp17_;
	_tmp19_ = types;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		GeeCollection* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = types;
		_tmp21_ = gee_collection_get_is_empty (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp18_ = _tmp22_;
	}
	if (_tmp18_) {
		ContactsTypeDescriptor* _tmp23_;
		ContactsTypeDescriptor* _tmp24_;
		g_debug ("contacts-type-set.vala:150: No types given in the AbstractFieldDetails");
		_tmp23_ = self->priv->other_dummy;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		result = _tmp24_;
		_g_object_unref0 (types);
		_g_object_unref0 (google_label);
		if (position) {
			*position = _vala_position;
		}
		return result;
	}
	_tmp25_ = self->priv->vcard_type_mappings;
	{
		GPtrArray* mapping_collection = NULL;
		guint mapping_index = 0U;
		mapping_collection = _tmp25_;
		for (mapping_index = 0; mapping_index < mapping_collection->len; mapping_index = mapping_index + 1) {
			ContactsVcardTypeMapping* mapping = NULL;
			mapping = g_ptr_array_index (mapping_collection, mapping_index);
			{
				ContactsVcardTypeMapping* _tmp26_;
				GeeCollection* _tmp27_;
				_tmp26_ = mapping;
				_tmp27_ = types;
				if (contacts_vcard_type_mapping_matches (_tmp26_, _tmp27_)) {
					ContactsVcardTypeMapping* _tmp28_;
					const gchar* _tmp29_;
					guint _tmp30_ = 0U;
					ContactsTypeDescriptor* _tmp31_;
					ContactsTypeDescriptor* _tmp32_;
					_tmp28_ = mapping;
					_tmp29_ = (*_tmp28_).name;
					_tmp31_ = contacts_typeset_lookup_by_display_name (self, _tmp29_, &_tmp30_);
					_vala_position = _tmp30_;
					_tmp32_ = _g_object_ref0 (_tmp31_);
					result = _tmp32_;
					_g_object_unref0 (types);
					_g_object_unref0 (google_label);
					if (position) {
						*position = _vala_position;
					}
					return result;
				}
			}
		}
	}
	_tmp33_ = self->priv->other_dummy;
	_tmp34_ = _g_object_ref0 (_tmp33_);
	result = _tmp34_;
	_g_object_unref0 (types);
	_g_object_unref0 (google_label);
	if (position) {
		*position = _vala_position;
	}
	return result;
}

static GType
contacts_typeset_real_get_item_type (GListModel* base)
{
	ContactsTypeSet * self;
	GType result;
	self = (ContactsTypeSet*) base;
	result = CONTACTS_TYPE_TYPEDESCRIPTOR;
	return result;
}

static guint
contacts_typeset_real_get_n_items (GListModel* base)
{
	ContactsTypeSet * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
	self = (ContactsTypeSet*) base;
	_tmp0_ = self->priv->descriptors;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

static GObject*
contacts_typeset_real_get_item (GListModel* base,
                                guint i)
{
	ContactsTypeSet * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	gconstpointer _tmp4_;
	GObject* _tmp5_;
	GObject* result;
	self = (ContactsTypeSet*) base;
	_tmp0_ = self->priv->descriptors;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (i > ((guint) _tmp2_)) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->descriptors;
	_tmp4_ = g_ptr_array_index (_tmp3_, i);
	_tmp5_ = _g_object_ref0 ((GObject*) ((ContactsTypeDescriptor*) _tmp4_));
	result = _tmp5_;
	return result;
}

const gchar*
contacts_typeset_get_category (ContactsTypeSet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_category;
	result = _tmp0_;
	return result;
}

void
contacts_typeset_set_category (ContactsTypeSet* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_typeset_get_category (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_category);
		self->priv->_category = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_typeset_properties[CONTACTS_TYPESET_CATEGORY_PROPERTY]);
	}
}

ContactsTypeSet*
contacts_typeset_get_general (void)
{
	ContactsTypeSet* result;
	ContactsTypeSet* _tmp0_;
	ContactsTypeSet* _tmp10_;
	_tmp0_ = contacts_typeset__general;
	if (_tmp0_ == NULL) {
		ContactsTypeSet* _tmp1_;
		ContactsTypeSet* _tmp6_;
		ContactsTypeSet* _tmp7_;
		ContactsTypeSet* _tmp8_;
		ContactsTypeDescriptor* _tmp9_;
		_tmp1_ = contacts_typeset_new ("General");
		_g_object_unref0 (contacts_typeset__general);
		contacts_typeset__general = _tmp1_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					ContactsTypeSet* _tmp4_;
					ContactsVcardTypeMapping _tmp5_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					if (!(i < G_N_ELEMENTS (CONTACTS_TYPESET_general_data))) {
						break;
					}
					_tmp4_ = contacts_typeset__general;
					_tmp5_ = CONTACTS_TYPESET_general_data[i];
					contacts_typeset_add_vcard_mapping (_tmp4_, &_tmp5_);
				}
			}
		}
		_tmp6_ = contacts_typeset__general;
		_tmp7_ = contacts_typeset_get_general ();
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->priv->other_dummy;
		contacts_typeset_add_descriptor (_tmp6_, _tmp9_);
	}
	_tmp10_ = contacts_typeset__general;
	result = _tmp10_;
	return result;
}

ContactsTypeSet*
contacts_typeset_get_email (void)
{
	ContactsTypeSet* result;
	ContactsTypeSet* _tmp0_;
	ContactsTypeSet* _tmp9_;
	_tmp0_ = contacts_typeset__email;
	if (_tmp0_ == NULL) {
		ContactsTypeSet* _tmp1_;
		ContactsTypeSet* _tmp6_;
		ContactsTypeSet* _tmp7_;
		ContactsTypeDescriptor* _tmp8_;
		_tmp1_ = contacts_typeset_new ("Emails");
		_g_object_unref0 (contacts_typeset__email);
		contacts_typeset__email = _tmp1_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					ContactsTypeSet* _tmp4_;
					ContactsVcardTypeMapping _tmp5_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					if (!(i < G_N_ELEMENTS (CONTACTS_TYPESET_email_data))) {
						break;
					}
					_tmp4_ = contacts_typeset__email;
					_tmp5_ = CONTACTS_TYPESET_email_data[i];
					contacts_typeset_add_vcard_mapping (_tmp4_, &_tmp5_);
				}
			}
		}
		_tmp6_ = contacts_typeset__email;
		_tmp7_ = contacts_typeset__email;
		_tmp8_ = _tmp7_->priv->other_dummy;
		contacts_typeset_add_descriptor (_tmp6_, _tmp8_);
	}
	_tmp9_ = contacts_typeset__email;
	result = _tmp9_;
	return result;
}

ContactsTypeSet*
contacts_typeset_get_phone (void)
{
	ContactsTypeSet* result;
	ContactsTypeSet* _tmp0_;
	ContactsTypeSet* _tmp9_;
	_tmp0_ = contacts_typeset__phone;
	if (_tmp0_ == NULL) {
		ContactsTypeSet* _tmp1_;
		ContactsTypeSet* _tmp6_;
		ContactsTypeSet* _tmp7_;
		ContactsTypeDescriptor* _tmp8_;
		_tmp1_ = contacts_typeset_new ("Phones");
		_g_object_unref0 (contacts_typeset__phone);
		contacts_typeset__phone = _tmp1_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					ContactsTypeSet* _tmp4_;
					ContactsVcardTypeMapping _tmp5_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					if (!(i < G_N_ELEMENTS (CONTACTS_TYPESET_phone_data))) {
						break;
					}
					_tmp4_ = contacts_typeset__phone;
					_tmp5_ = CONTACTS_TYPESET_phone_data[i];
					contacts_typeset_add_vcard_mapping (_tmp4_, &_tmp5_);
				}
			}
		}
		_tmp6_ = contacts_typeset__phone;
		_tmp7_ = contacts_typeset__phone;
		_tmp8_ = _tmp7_->priv->other_dummy;
		contacts_typeset_add_descriptor (_tmp6_, _tmp8_);
	}
	_tmp9_ = contacts_typeset__phone;
	result = _tmp9_;
	return result;
}

static void
contacts_typeset_class_init (ContactsTypeSetClass * klass,
                             gpointer klass_data)
{
	contacts_typeset_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsTypeSet_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_typeset_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_typeset_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_typeset_finalize;
	/** Returns the category of typeset (mostly used for debugging). */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_TYPESET_CATEGORY_PROPERTY, contacts_typeset_properties[CONTACTS_TYPESET_CATEGORY_PROPERTY] = g_param_spec_string ("category", "category", "category", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
contacts_typeset_g_list_model_interface_init (GListModelInterface * iface,
                                              gpointer iface_data)
{
	contacts_typeset_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item_type = (GType (*) (GListModel*)) contacts_typeset_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) contacts_typeset_real_get_n_items;
	iface->get_item = (GObject* (*) (GListModel*, guint)) contacts_typeset_real_get_item;
}

static void
contacts_typeset_instance_init (ContactsTypeSet * self,
                                gpointer klass)
{
	ContactsTypeDescriptor* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	self->priv = contacts_typeset_get_instance_private (self);
	_tmp0_ = contacts_typedescriptor_new_other ();
	self->priv->other_dummy = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _contacts_vcard_type_mapping_free0_);
	self->priv->vcard_type_mappings = _tmp1_;
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->descriptors = _tmp2_;
}

static void
contacts_typeset_finalize (GObject * obj)
{
	ContactsTypeSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_TYPESET, ContactsTypeSet);
	_g_free0 (self->priv->_category);
	_g_object_unref0 (self->priv->other_dummy);
	_g_ptr_array_unref0 (self->priv->vcard_type_mappings);
	_g_ptr_array_unref0 (self->priv->descriptors);
	G_OBJECT_CLASS (contacts_typeset_parent_class)->finalize (obj);
}

/**
 * A TypeSet contains all the possible types of a property. For example, a
 * phone number can be both for a personal phone, a work phone or even a fax
 * machine.
 */
 G_GNUC_NO_INLINE static GType
contacts_typeset_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsTypeSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_typeset_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsTypeSet), 0, (GInstanceInitFunc) contacts_typeset_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) contacts_typeset_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType contacts_typeset_type_id;
	contacts_typeset_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsTypeSet", &g_define_type_info, 0);
	g_type_add_interface_static (contacts_typeset_type_id, g_list_model_get_type (), &g_list_model_info);
	ContactsTypeSet_private_offset = g_type_add_instance_private (contacts_typeset_type_id, sizeof (ContactsTypeSetPrivate));
	return contacts_typeset_type_id;
}

GType
contacts_typeset_get_type (void)
{
	static volatile gsize contacts_typeset_type_id__once = 0;
	if (g_once_init_enter (&contacts_typeset_type_id__once)) {
		GType contacts_typeset_type_id;
		contacts_typeset_type_id = contacts_typeset_get_type_once ();
		g_once_init_leave (&contacts_typeset_type_id__once, contacts_typeset_type_id);
	}
	return contacts_typeset_type_id__once;
}

static void
_vala_contacts_typeset_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	ContactsTypeSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_TYPESET, ContactsTypeSet);
	switch (property_id) {
		case CONTACTS_TYPESET_CATEGORY_PROPERTY:
		g_value_set_string (value, contacts_typeset_get_category (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_typeset_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	ContactsTypeSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_TYPESET, ContactsTypeSet);
	switch (property_id) {
		case CONTACTS_TYPESET_CATEGORY_PROPERTY:
		contacts_typeset_set_category (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

