/* contacts-app.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-app.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "contacts.h"
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <folks/folks.h>
#include <folks/folks-eds.h>

#define CONTACTS_APP_LOADING_TIMEOUT 1
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_SETTINGS (contacts_settings_get_type ())
#define CONTACTS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettings))
#define CONTACTS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))
#define CONTACTS_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))

typedef struct _ContactsSettings ContactsSettings;
typedef struct _ContactsSettingsClass ContactsSettingsClass;

#define CONTACTS_TYPE_MAIN_WINDOW (contacts_main_window_get_type ())
#define CONTACTS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow))
#define CONTACTS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))
#define CONTACTS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))

typedef struct _ContactsMainWindow ContactsMainWindow;
typedef struct _ContactsMainWindowClass ContactsMainWindowClass;
enum  {
	CONTACTS_APP_0_PROPERTY,
	CONTACTS_APP_OPERATIONS_PROPERTY,
	CONTACTS_APP_NUM_PROPERTIES
};
static GParamSpec* contacts_app_properties[CONTACTS_APP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ContactsAppShowIndividualForIdData ContactsAppShowIndividualForIdData;

#define CONTACTS_TYPE_PREFERENCES_WINDOW (contacts_preferences_window_get_type ())
#define CONTACTS_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_PREFERENCES_WINDOW, ContactsPreferencesWindow))
#define CONTACTS_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_PREFERENCES_WINDOW, ContactsPreferencesWindowClass))
#define CONTACTS_IS_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_PREFERENCES_WINDOW))
#define CONTACTS_IS_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_PREFERENCES_WINDOW))
#define CONTACTS_PREFERENCES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_PREFERENCES_WINDOW, ContactsPreferencesWindowClass))

typedef struct _ContactsPreferencesWindow ContactsPreferencesWindow;
typedef struct _ContactsPreferencesWindowClass ContactsPreferencesWindowClass;
typedef struct _ContactsAppShowByEmailData ContactsAppShowByEmailData;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define CONTACTS_TYPE_SETUP_WINDOW (contacts_setup_window_get_type ())
#define CONTACTS_SETUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindow))
#define CONTACTS_SETUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindowClass))
#define CONTACTS_IS_SETUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETUP_WINDOW))
#define CONTACTS_IS_SETUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETUP_WINDOW))
#define CONTACTS_SETUP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindowClass))

typedef struct _ContactsSetupWindow ContactsSetupWindow;
typedef struct _ContactsSetupWindowClass ContactsSetupWindowClass;
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _ContactsAppImportFileData ContactsAppImportFileData;

struct _ContactsApp {
	AdwApplication parent_instance;
	ContactsAppPrivate * priv;
};

struct _ContactsAppClass {
	AdwApplicationClass parent_class;
};

struct _ContactsAppPrivate {
	ContactsSettings* settings;
	ContactsStore* contacts_store;
	ContactsMainWindow* window;
	ContactsOperationList* _operations;
};

struct _ContactsAppShowIndividualForIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsApp* self;
	gchar* id;
	guint pos;
	ContactsStore* _tmp0_;
	ContactsStore* _tmp1_;
	GtkSingleSelection* _tmp2_;
	GtkSingleSelection* _tmp3_;
	AdwMessageDialog* dialog;
	ContactsMainWindow* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	AdwMessageDialog* _tmp7_;
	AdwMessageDialog* _tmp8_;
	AdwMessageDialog* _tmp9_;
	AdwMessageDialog* _tmp10_;
	AdwMessageDialog* _tmp11_;
};

struct _ContactsAppShowByEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsApp* self;
	gchar* email_address;
	FolksSimpleQuery* query;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	FolksSimpleQuery* _tmp3_;
	FolksSimpleQuery* _tmp4_;
	guint pos;
	ContactsStore* _tmp5_;
	FolksSimpleQuery* _tmp6_;
	ContactsStore* _tmp7_;
	GtkSingleSelection* _tmp8_;
	GtkSingleSelection* _tmp9_;
	AdwMessageDialog* dialog;
	ContactsMainWindow* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	AdwMessageDialog* _tmp13_;
	AdwMessageDialog* _tmp14_;
	AdwMessageDialog* _tmp15_;
	AdwMessageDialog* _tmp16_;
	AdwMessageDialog* _tmp17_;
};

struct _Block1Data {
	int _ref_count_;
	ContactsApp* self;
	gchar* query;
};

struct _Block2Data {
	int _ref_count_;
	ContactsApp* self;
	guint timeout_id;
	gulong quiescence_id;
};

struct _Block3Data {
	int _ref_count_;
	ContactsApp* self;
	AdwMessageDialog* dialog;
};

struct _Block4Data {
	int _ref_count_;
	ContactsApp* self;
	ContactsSetupWindow* setup_window;
};

struct _Block5Data {
	int _ref_count_;
	ContactsApp* self;
	GtkFileChooserNative* chooser;
};

struct _Block6Data {
	int _ref_count_;
	ContactsApp* self;
	GHashTable** parse_result;
	gint parse_result_length1;
	gint _parse_result_size_;
	gpointer _async_data_;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	ContactsImportOperation* import_op;
};

struct _ContactsAppImportFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsApp* self;
	GFile* file;
	Block6Data* _data6_;
	ContactsIoParseOperation* parse_op;
	ContactsIoParseOperation* _tmp0_;
	ContactsIoParseOperation* _tmp1_;
	ContactsIoParseOperation* _tmp2_;
	gint _tmp3_;
	GHashTable** _tmp4_;
	GError* err;
	GError* _tmp5_;
	const gchar* _tmp6_;
	AdwMessageDialog* dialog;
	ContactsMainWindow* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	AdwMessageDialog* _tmp12_;
	AdwMessageDialog* _tmp13_;
	AdwMessageDialog* _tmp14_;
	AdwMessageDialog* _tmp15_;
	AdwMessageDialog* _tmp16_;
	GHashTable** _tmp17_;
	gint _tmp17__length1;
	AdwMessageDialog* _vala1_dialog;
	ContactsMainWindow* _tmp18_;
	AdwMessageDialog* _tmp19_;
	AdwMessageDialog* _tmp20_;
	AdwMessageDialog* _tmp21_;
	AdwMessageDialog* _tmp22_;
	gchar* body;
	GHashTable** _tmp23_;
	gint _tmp23__length1;
	GHashTable** _tmp24_;
	gint _tmp24__length1;
	gchar* _tmp25_;
	AdwMessageDialog* _vala2_dialog;
	ContactsMainWindow* _tmp26_;
	const gchar* _tmp27_;
	AdwMessageDialog* _tmp28_;
	AdwMessageDialog* _tmp29_;
	AdwMessageDialog* _tmp30_;
	AdwMessageDialog* _tmp31_;
	AdwMessageDialog* _tmp32_;
	AdwMessageDialog* _tmp33_;
	AdwMessageDialog* _tmp34_;
	AdwMessageDialog* _tmp35_;
	GError* _inner_error0_;
};

static gint ContactsApp_private_offset;
static gpointer contacts_app_parent_class = NULL;

VALA_EXTERN GType contacts_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsApp, g_object_unref)
VALA_EXTERN GType contacts_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsSettings, g_object_unref)
VALA_EXTERN GType contacts_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsMainWindow, g_object_unref)
static void contacts_app_quit_action (ContactsApp* self,
                               GSimpleAction* action,
                               GVariant* param);
static void _contacts_app_quit_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
VALA_EXTERN void contacts_app_show_help (ContactsApp* self);
static void _contacts_app_show_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
VALA_EXTERN void contacts_app_show_about (ContactsApp* self);
static void _contacts_app_show_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
VALA_EXTERN void contacts_app_show_preferences (ContactsApp* self);
static void _contacts_app_show_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void contacts_app_on_show_contact (ContactsApp* self,
                                   GSimpleAction* action,
                                   GVariant* param);
static void _contacts_app_on_show_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void contacts_app_on_import (ContactsApp* self,
                             GSimpleAction* action,
                             GVariant* param);
static void _contacts_app_on_import_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
VALA_EXTERN ContactsApp* contacts_app_new (void);
VALA_EXTERN ContactsApp* contacts_app_construct (GType object_type);
static gint contacts_app_real_command_line (GApplication* base,
                                     GApplicationCommandLine* command_line);
VALA_EXTERN void contacts_app_show_individual_for_id (ContactsApp* self,
                                          const gchar* id,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void contacts_app_show_individual_for_id_finish (ContactsApp* self,
                                                 GAsyncResult* _res_);
VALA_EXTERN void contacts_app_show_by_email (ContactsApp* self,
                                 const gchar* email_address,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void contacts_app_show_by_email_finish (ContactsApp* self,
                                        GAsyncResult* _res_);
VALA_EXTERN void contacts_app_show_search (ContactsApp* self,
                               const gchar* query);
static gint contacts_app_real_handle_local_options (GApplication* base,
                                             GVariantDict* options);
static void contacts_app_show_individual_for_id_data_free (gpointer _data);
static gboolean contacts_app_show_individual_for_id_co (ContactsAppShowIndividualForIdData* _data_);
static void contacts_app_show_individual_for_id_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
VALA_EXTERN GType contacts_preferences_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsPreferencesWindow, g_object_unref)
VALA_EXTERN ContactsPreferencesWindow* contacts_preferences_window_new (ContactsStore* contacts_store,
                                                            GtkWindow* transient_for);
VALA_EXTERN ContactsPreferencesWindow* contacts_preferences_window_construct (GType object_type,
                                                                  ContactsStore* contacts_store,
                                                                  GtkWindow* transient_for);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void contacts_app_show_by_email_data_free (gpointer _data);
static gboolean contacts_app_show_by_email_co (ContactsAppShowByEmailData* _data_);
static void contacts_app_show_by_email_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN void contacts_main_window_show_search (ContactsMainWindow* self,
                                       const gchar* query);
static void ___lambda54_ (Block1Data* _data1_);
static void ____lambda54__contacts_store_quiescent (ContactsStore* _sender,
                                             gpointer self);
static void contacts_app_create_window (ContactsApp* self);
VALA_EXTERN ContactsOperationList* contacts_app_get_operations (ContactsApp* self);
VALA_EXTERN ContactsMainWindow* contacts_main_window_new (ContactsSettings* settings,
                                              ContactsOperationList* operations,
                                              ContactsApp* app,
                                              ContactsStore* contacts_store);
VALA_EXTERN ContactsMainWindow* contacts_main_window_construct (GType object_type,
                                                    ContactsSettings* settings,
                                                    ContactsOperationList* operations,
                                                    ContactsApp* app,
                                                    ContactsStore* contacts_store);
static gboolean __lambda43_ (ContactsApp* self,
                      GtkWindow* win);
static gboolean ___lambda43__gtk_window_close_request (GtkWindow* _sender,
                                                gpointer self);
static void contacts_app_show_contact_list (ContactsApp* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda44_ (Block2Data* _data2_);
VALA_EXTERN void contacts_main_window_show_contact_list (ContactsMainWindow* self);
static void contacts_app_check_primary_address_book (ContactsApp* self);
static void ___lambda44__contacts_store_quiescent (ContactsStore* _sender,
                                            gpointer self);
static gboolean __lambda46_ (Block2Data* _data2_);
static gboolean ___lambda46__gsource_func (gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda45_ (Block3Data* _data3_,
                  const gchar* response);
static void ___lambda45__adw_message_dialog_response (AdwMessageDialog* _sender,
                                               const gchar* response,
                                               gpointer self);
static void contacts_app_real_startup (GApplication* base);
VALA_EXTERN void contacts_app_load_styling (ContactsApp* self);
static void contacts_app_create_actions (ContactsApp* self);
static void contacts_app_real_activate (GApplication* base);
VALA_EXTERN gboolean contacts_settings_get_did_initial_setup (ContactsSettings* self);
static void contacts_app_run_setup (ContactsApp* self);
VALA_EXTERN GType contacts_setup_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsSetupWindow, g_object_unref)
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN ContactsSetupWindow* contacts_setup_window_new (ContactsApp* app,
                                                ContactsStore* store);
VALA_EXTERN ContactsSetupWindow* contacts_setup_window_construct (GType object_type,
                                                      ContactsApp* app,
                                                      ContactsStore* store);
static void __lambda50_ (Block4Data* _data4_,
                  EdsfPersonaStore* selected_store);
VALA_EXTERN void contacts_settings_set_did_initial_setup (ContactsSettings* self,
                                              gboolean value);
static void ___lambda50__contacts_setup_window_setup_done (ContactsSetupWindow* _sender,
                                                    EdsfPersonaStore* selected_address_book,
                                                    gpointer self);
static gchar* _variant_get1 (GVariant* value);
static gboolean __lambda40_ (ContactsApp* self);
static gboolean ___lambda40__gsource_func (gpointer self);
static void __lambda41_ (ContactsApp* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda41__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda51_ (Block5Data* _data5_,
                  gint response);
static void contacts_app_import_file (ContactsApp* self,
                               GFile* file,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static void contacts_app_import_file_finish (ContactsApp* self,
                                      GAsyncResult* _res_);
static void ___lambda51__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void contacts_app_import_file_data_free (gpointer _data);
static gboolean contacts_app_import_file_co (ContactsAppImportFileData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void contacts_app_import_file_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static void __lambda52_ (Block6Data* _data6_,
                  const gchar* response);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda53_ (Block7Data* _data7_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda53__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ___lambda52__adw_message_dialog_response (AdwMessageDialog* _sender,
                                               const gchar* response,
                                               gpointer self);
static void contacts_app_set_operations (ContactsApp* self,
                                  ContactsOperationList* value);
static GObject * contacts_app_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
VALA_EXTERN ContactsSettings* contacts_settings_new (ContactsApp* app);
VALA_EXTERN ContactsSettings* contacts_settings_construct (GType object_type,
                                               ContactsApp* app);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void contacts_app_finalize (GObject * obj);
static GType contacts_app_get_type_once (void);
static void _vala_contacts_app_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_contacts_app_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry CONTACTS_APP_action_entries[6] = {{"quit", _contacts_app_quit_action_gsimple_action_activate_callback}, {"help", _contacts_app_show_help_gsimple_action_activate_callback}, {"about", _contacts_app_show_about_gsimple_action_activate_callback}, {"show-preferences", _contacts_app_show_preferences_gsimple_action_activate_callback}, {"show-contact", _contacts_app_on_show_contact_gsimple_action_activate_callback, "s"}, {"import", _contacts_app_on_import_gsimple_action_activate_callback}};
static const GOptionEntry CONTACTS_APP_options[5] = {{"email", 'e', (gint) 0, G_OPTION_ARG_STRING, NULL, N_ ("Show contact with this email address")}, {"individual", 'i', (gint) 0, G_OPTION_ARG_STRING, NULL, N_ ("Show contact with this individual id")}, {"search", 's', (gint) 0, G_OPTION_ARG_STRING, NULL, N_ ("Show contacts with the given filter")}, {"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Show the current version of Contacts")}, {0}};

static inline gpointer
contacts_app_get_instance_private (ContactsApp* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsApp_private_offset);
}

static void
_contacts_app_quit_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	contacts_app_quit_action ((ContactsApp*) self, action, parameter);
}

static void
_contacts_app_show_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	contacts_app_show_help ((ContactsApp*) self);
}

static void
_contacts_app_show_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	contacts_app_show_about ((ContactsApp*) self);
}

static void
_contacts_app_show_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	contacts_app_show_preferences ((ContactsApp*) self);
}

static void
_contacts_app_on_show_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	contacts_app_on_show_contact ((ContactsApp*) self, action, parameter);
}

static void
_contacts_app_on_import_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	contacts_app_on_import ((ContactsApp*) self, action, parameter);
}

ContactsApp*
contacts_app_construct (GType object_type)
{
	ContactsApp * self = NULL;
	self = (ContactsApp*) g_object_new (object_type, "application-id", APP_ID, "resource-base-path", "/org/gnome/Contacts", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	return self;
}

ContactsApp*
contacts_app_new (void)
{
	return contacts_app_construct (CONTACTS_TYPE_APP);
}

static gpointer
_g_variant_dict_ref0 (gpointer self)
{
	return self ? g_variant_dict_ref (self) : NULL;
}

static gint
contacts_app_real_command_line (GApplication* base,
                                GApplicationCommandLine* command_line)
{
	ContactsApp * self;
	GVariantDict* options = NULL;
	GVariantDict* _tmp0_;
	GVariantDict* _tmp1_;
	GVariantDict* _tmp2_;
	gint result;
	self = (ContactsApp*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = g_application_command_line_get_options_dict (command_line);
	_tmp1_ = _g_variant_dict_ref0 (_tmp0_);
	options = _tmp1_;
	g_application_activate ((GApplication*) self);
	_tmp2_ = options;
	if (g_variant_dict_contains (_tmp2_, "individual")) {
		GVariant* individual = NULL;
		GVariantDict* _tmp3_;
		const GVariantType* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		_tmp3_ = options;
		_tmp4_ = G_VARIANT_TYPE_STRING;
		_tmp5_ = g_variant_dict_lookup_value (_tmp3_, "individual", _tmp4_);
		individual = _tmp5_;
		_tmp6_ = individual;
		if (_tmp6_ != NULL) {
			GVariant* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = individual;
			_tmp8_ = g_variant_get_string (_tmp7_, NULL);
			contacts_app_show_individual_for_id (self, _tmp8_, NULL, NULL);
		}
		_g_variant_unref0 (individual);
	} else {
		GVariantDict* _tmp9_;
		_tmp9_ = options;
		if (g_variant_dict_contains (_tmp9_, "email")) {
			GVariant* email = NULL;
			GVariantDict* _tmp10_;
			const GVariantType* _tmp11_;
			GVariant* _tmp12_;
			GVariant* _tmp13_;
			_tmp10_ = options;
			_tmp11_ = G_VARIANT_TYPE_STRING;
			_tmp12_ = g_variant_dict_lookup_value (_tmp10_, "email", _tmp11_);
			email = _tmp12_;
			_tmp13_ = email;
			if (_tmp13_ != NULL) {
				GVariant* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = email;
				_tmp15_ = g_variant_get_string (_tmp14_, NULL);
				contacts_app_show_by_email (self, _tmp15_, NULL, NULL);
			}
			_g_variant_unref0 (email);
		} else {
			GVariantDict* _tmp16_;
			_tmp16_ = options;
			if (g_variant_dict_contains (_tmp16_, "search")) {
				GVariant* search_term = NULL;
				GVariantDict* _tmp17_;
				const GVariantType* _tmp18_;
				GVariant* _tmp19_;
				GVariant* _tmp20_;
				_tmp17_ = options;
				_tmp18_ = G_VARIANT_TYPE_STRING;
				_tmp19_ = g_variant_dict_lookup_value (_tmp17_, "search", _tmp18_);
				search_term = _tmp19_;
				_tmp20_ = search_term;
				if (_tmp20_ != NULL) {
					GVariant* _tmp21_;
					const gchar* _tmp22_;
					_tmp21_ = search_term;
					_tmp22_ = g_variant_get_string (_tmp21_, NULL);
					contacts_app_show_search (self, _tmp22_);
				}
				_g_variant_unref0 (search_term);
			}
		}
	}
	result = 0;
	_g_variant_dict_unref0 (options);
	return result;
}

static gint
contacts_app_real_handle_local_options (GApplication* base,
                                        GVariantDict* options)
{
	ContactsApp * self;
	gint result;
	self = (ContactsApp*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%s %s\n", PACKAGE_NAME, PACKAGE_VERSION);
		result = 0;
		return result;
	}
	result = -1;
	return result;
}

static void
contacts_app_show_individual_for_id_data_free (gpointer _data)
{
	ContactsAppShowIndividualForIdData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowIndividualForIdData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
contacts_app_show_individual_for_id (ContactsApp* self,
                                     const gchar* id,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ContactsAppShowIndividualForIdData* _data_;
	ContactsApp* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_data_ = g_slice_new0 (ContactsAppShowIndividualForIdData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_app_show_individual_for_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	contacts_app_show_individual_for_id_co (_data_);
}

void
contacts_app_show_individual_for_id_finish (ContactsApp* self,
                                            GAsyncResult* _res_)
{
	ContactsAppShowIndividualForIdData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
contacts_app_show_individual_for_id_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	ContactsAppShowIndividualForIdData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_show_individual_for_id_co (_data_);
}

static gboolean
contacts_app_show_individual_for_id_co (ContactsAppShowIndividualForIdData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->contacts_store;
	_data_->_state_ = 1;
	contacts_store_find_individual_for_id (_data_->_tmp0_, _data_->id, contacts_app_show_individual_for_id_ready, _data_);
	return FALSE;
	_state_1:
	_data_->pos = contacts_store_find_individual_for_id_finish (_data_->_tmp0_, _data_->_res_);
	if (_data_->pos != GTK_INVALID_LIST_POSITION) {
		_data_->_tmp1_ = _data_->self->priv->contacts_store;
		_data_->_tmp2_ = contacts_store_get_selection (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		gtk_single_selection_set_selected (_data_->_tmp3_, _data_->pos);
	} else {
		_data_->_tmp4_ = _data_->self->priv->window;
		_data_->_tmp5_ = g_strdup_printf (_ ("No contact with id %s found"), _data_->id);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = (AdwMessageDialog*) adw_message_dialog_new ((GtkWindow*) _data_->_tmp4_, _ ("Contact not found"), _data_->_tmp6_);
		g_object_ref_sink (_data_->_tmp7_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_g_free0 (_data_->_tmp6_);
		_data_->dialog = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->dialog;
		adw_message_dialog_add_response (_data_->_tmp9_, "close", _ ("_Close"));
		_data_->_tmp10_ = _data_->dialog;
		adw_message_dialog_set_default_response (_data_->_tmp10_, "close");
		_data_->_tmp11_ = _data_->dialog;
		gtk_widget_show ((GtkWidget*) _data_->_tmp11_);
		_g_object_unref0 (_data_->dialog);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
contacts_app_show_preferences (ContactsApp* self)
{
	ContactsPreferencesWindow* prefs_window = NULL;
	ContactsStore* _tmp0_;
	ContactsMainWindow* _tmp1_;
	ContactsPreferencesWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contacts_store;
	_tmp1_ = self->priv->window;
	_tmp2_ = contacts_preferences_window_new (_tmp0_, (GtkWindow*) _tmp1_);
	g_object_ref_sink (_tmp2_);
	prefs_window = _tmp2_;
	gtk_widget_show ((GtkWidget*) prefs_window);
	_g_object_unref0 (prefs_window);
}

void
contacts_app_show_help (ContactsApp* self)
{
	ContactsMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_show_uri ((GtkWindow*) _tmp0_, "help:gnome-help/contacts", (guint32) GDK_CURRENT_TIME);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
contacts_app_show_about (ContactsApp* self)
{
	gchar** developers = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint developers_length1;
	gint _developers_size_;
	gchar** designers = NULL;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint designers_length1;
	gint _designers_size_;
	AdwAboutWindow* about = NULL;
	ContactsMainWindow* _tmp7_;
	GtkWindow* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	AdwAboutWindow* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Alexander Larsson <alexl@redhat.com>");
	_tmp1_ = g_strdup ("Erick Pérez Castellanos <erick.red@gmail.com>");
	_tmp2_ = g_strdup ("Niels De Graef <nielsdegraef@gmail.com>");
	_tmp3_ = g_strdup ("Julian Sparber <jsparber@gnome.org>");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	developers = _tmp4_;
	developers_length1 = 4;
	_developers_size_ = developers_length1;
	_tmp5_ = g_strdup ("Allan Day <allanpday@gmail.com>");
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	designers = _tmp6_;
	designers_length1 = 1;
	_designers_size_ = designers_length1;
	_tmp7_ = self->priv->window;
	_tmp8_ = _g_object_ref0 ((GtkWindow*) _tmp7_);
	_tmp9_ = g_get_application_name ();
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = g_strdup (APP_ID);
	_tmp12_ = g_strdup (_ ("The GNOME Project"));
	_tmp13_ = g_strdup (PACKAGE_VERSION);
	_tmp14_ = g_strdup ("https://wiki.gnome.org/Apps/Contacts");
	_tmp15_ = g_strdup ("https://gitlab.gnome.org/GNOME/gnome-contacts/-/issues/new");
	_tmp16_ = (developers != NULL) ? _vala_array_dup1 (developers, developers_length1) : developers;
	_tmp16__length1 = developers_length1;
	_tmp17_ = (designers != NULL) ? _vala_array_dup2 (designers, designers_length1) : designers;
	_tmp17__length1 = designers_length1;
	_tmp18_ = g_strdup (_ ("© 2011 Red Hat, Inc.\n© 2011-2020 The Contacts Developers"));
	_tmp19_ = (AdwAboutWindow*) adw_about_window_new ();
	gtk_window_set_transient_for ((GtkWindow*) _tmp19_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	adw_about_window_set_application_name (_tmp19_, _tmp10_);
	_g_free0 (_tmp10_);
	adw_about_window_set_application_icon (_tmp19_, _tmp11_);
	_g_free0 (_tmp11_);
	adw_about_window_set_developer_name (_tmp19_, _tmp12_);
	_g_free0 (_tmp12_);
	adw_about_window_set_version (_tmp19_, _tmp13_);
	_g_free0 (_tmp13_);
	adw_about_window_set_website (_tmp19_, _tmp14_);
	_g_free0 (_tmp14_);
	adw_about_window_set_issue_url (_tmp19_, _tmp15_);
	_g_free0 (_tmp15_);
	adw_about_window_set_developers (_tmp19_, _tmp16_);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	adw_about_window_set_designers (_tmp19_, _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	adw_about_window_set_copyright (_tmp19_, _tmp18_);
	_g_free0 (_tmp18_);
	adw_about_window_set_license_type (_tmp19_, GTK_LICENSE_GPL_2_0);
	g_object_ref_sink (_tmp19_);
	about = _tmp19_;
	gtk_window_present ((GtkWindow*) about);
	_g_object_unref0 (about);
	designers = (_vala_array_free (designers, designers_length1, (GDestroyNotify) g_free), NULL);
	developers = (_vala_array_free (developers, developers_length1, (GDestroyNotify) g_free), NULL);
}

static void
contacts_app_show_by_email_data_free (gpointer _data)
{
	ContactsAppShowByEmailData* _data_;
	_data_ = _data;
	_g_free0 (_data_->email_address);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowByEmailData, _data_);
}

void
contacts_app_show_by_email (ContactsApp* self,
                            const gchar* email_address,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	ContactsAppShowByEmailData* _data_;
	ContactsApp* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (email_address != NULL);
	_data_ = g_slice_new0 (ContactsAppShowByEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_app_show_by_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (email_address);
	_g_free0 (_data_->email_address);
	_data_->email_address = _tmp1_;
	contacts_app_show_by_email_co (_data_);
}

void
contacts_app_show_by_email_finish (ContactsApp* self,
                                   GAsyncResult* _res_)
{
	ContactsAppShowByEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
contacts_app_show_by_email_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	ContactsAppShowByEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_show_by_email_co (_data_);
}

static gboolean
contacts_app_show_by_email_co (ContactsAppShowByEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("email-addresses");
	_data_->_tmp1_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp1_[0] = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp2__length1 = 1;
	_data_->_tmp3_ = folks_simple_query_new (_data_->email_address, _data_->_tmp2_, 1);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp2_ = (_vala_array_free (_data_->_tmp2_, _data_->_tmp2__length1, (GDestroyNotify) g_free), NULL);
	_data_->query = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->contacts_store;
	_data_->_tmp6_ = _data_->query;
	_data_->_state_ = 1;
	contacts_store_find_individual_for_query (_data_->_tmp5_, (FolksQuery*) _data_->_tmp6_, contacts_app_show_by_email_ready, _data_);
	return FALSE;
	_state_1:
	_data_->pos = contacts_store_find_individual_for_query_finish (_data_->_tmp5_, _data_->_res_);
	if (_data_->pos != GTK_INVALID_LIST_POSITION) {
		_data_->_tmp7_ = _data_->self->priv->contacts_store;
		_data_->_tmp8_ = contacts_store_get_selection (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		gtk_single_selection_set_selected (_data_->_tmp9_, _data_->pos);
	} else {
		_data_->_tmp10_ = _data_->self->priv->window;
		_data_->_tmp11_ = g_strdup_printf (_ ("No contact with email address %s found"), _data_->email_address);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = (AdwMessageDialog*) adw_message_dialog_new ((GtkWindow*) _data_->_tmp10_, _ ("Contact not found"), _data_->_tmp12_);
		g_object_ref_sink (_data_->_tmp13_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_g_free0 (_data_->_tmp12_);
		_data_->dialog = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->dialog;
		adw_message_dialog_add_response (_data_->_tmp15_, "close", _ ("_Close"));
		_data_->_tmp16_ = _data_->dialog;
		adw_message_dialog_set_default_response (_data_->_tmp16_, "close");
		_data_->_tmp17_ = _data_->dialog;
		gtk_widget_show ((GtkWidget*) _data_->_tmp17_);
		_g_object_unref0 (_data_->dialog);
	}
	_g_object_unref0 (_data_->query);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ContactsApp* self;
		self = _data1_->self;
		_g_free0 (_data1_->query);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda54_ (Block1Data* _data1_)
{
	ContactsApp* self;
	ContactsMainWindow* _tmp0_;
	self = _data1_->self;
	_tmp0_ = self->priv->window;
	contacts_main_window_show_search (_tmp0_, _data1_->query);
}

static void
____lambda54__contacts_store_quiescent (ContactsStore* _sender,
                                        gpointer self)
{
	___lambda54_ (self);
}

void
contacts_app_show_search (ContactsApp* self,
                          const gchar* query)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
	ContactsStore* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	FolksIndividualAggregator* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (query);
	_g_free0 (_data1_->query);
	_data1_->query = _tmp0_;
	_tmp1_ = self->priv->contacts_store;
	_tmp2_ = contacts_store_get_aggregator (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_individual_aggregator_get_is_quiescent (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		ContactsMainWindow* _tmp6_;
		_tmp6_ = self->priv->window;
		contacts_main_window_show_search (_tmp6_, _data1_->query);
	} else {
		ContactsStore* _tmp7_;
		_tmp7_ = self->priv->contacts_store;
		g_signal_connect_data (_tmp7_, "quiescent", (GCallback) ____lambda54__contacts_store_quiescent, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, G_CONNECT_AFTER);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static gboolean
__lambda43_ (ContactsApp* self,
             GtkWindow* win)
{
	gboolean result;
	g_return_val_if_fail (win != NULL, FALSE);
	g_action_group_activate_action ((GActionGroup*) self, "quit", NULL);
	result = FALSE;
	return result;
}

static gboolean
___lambda43__gtk_window_close_request (GtkWindow* _sender,
                                       gpointer self)
{
	gboolean result;
	result = __lambda43_ ((ContactsApp*) self, _sender);
	return result;
}

static void
contacts_app_create_window (ContactsApp* self)
{
	ContactsMainWindow* win = NULL;
	ContactsSettings* _tmp0_;
	ContactsOperationList* _tmp1_;
	ContactsStore* _tmp2_;
	ContactsMainWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->_operations;
	_tmp2_ = self->priv->contacts_store;
	_tmp3_ = contacts_main_window_new (_tmp0_, _tmp1_, self, _tmp2_);
	g_object_ref_sink (_tmp3_);
	win = _tmp3_;
	g_signal_connect_object ((GtkWindow*) win, "close-request", (GCallback) ___lambda43__gtk_window_close_request, self, G_CONNECT_AFTER);
	self->priv->window = win;
	gtk_window_present ((GtkWindow*) win);
	contacts_app_show_contact_list (self);
	_g_object_unref0 (win);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ContactsApp* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda44_ (Block2Data* _data2_)
{
	ContactsApp* self;
	ContactsMainWindow* _tmp0_;
	self = _data2_->self;
	g_source_remove (_data2_->timeout_id);
	g_debug ("contacts-app.vala:204: Got quiescent in time. Showing contact list");
	_tmp0_ = self->priv->window;
	contacts_main_window_show_contact_list (_tmp0_);
	contacts_app_check_primary_address_book (self);
}

static void
___lambda44__contacts_store_quiescent (ContactsStore* _sender,
                                       gpointer self)
{
	__lambda44_ (self);
}

static gboolean
__lambda46_ (Block2Data* _data2_)
{
	ContactsApp* self;
	ContactsStore* _tmp0_;
	ContactsMainWindow* _tmp1_;
	gboolean result;
	self = _data2_->self;
	_tmp0_ = self->priv->contacts_store;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data2_->quiescence_id);
	g_debug ("contacts-app.vala:213: Didn't achieve quiescence in time! Showing cont" \
"act list anyway");
	_tmp1_ = self->priv->window;
	contacts_main_window_show_contact_list (_tmp1_);
	contacts_app_check_primary_address_book (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda46__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda46_ (self);
	return result;
}

static void
contacts_app_show_contact_list (ContactsApp* self)
{
	Block2Data* _data2_;
	ContactsStore* _tmp0_;
	gulong _tmp1_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->timeout_id = (guint) 0;
	_tmp0_ = self->priv->contacts_store;
	_tmp1_ = g_signal_connect_data (_tmp0_, "quiescent", (GCallback) ___lambda44__contacts_store_quiescent, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_data2_->quiescence_id = _tmp1_;
	_data2_->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) CONTACTS_APP_LOADING_TIMEOUT, ___lambda46__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ContactsApp* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda45_ (Block3Data* _data3_,
             const gchar* response)
{
	ContactsApp* self;
	AdwMessageDialog* _tmp0_;
	self = _data3_->self;
	g_return_if_fail (response != NULL);
	if (g_strcmp0 (response, "preferences") == 0) {
		contacts_app_show_preferences (self);
	}
	_tmp0_ = _data3_->dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
___lambda45__adw_message_dialog_response (AdwMessageDialog* _sender,
                                          const gchar* response,
                                          gpointer self)
{
	__lambda45_ (self, response);
}

static void
contacts_app_check_primary_address_book (ContactsApp* self)
{
	Block3Data* _data3_;
	ContactsStore* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	ContactsMainWindow* _tmp5_;
	AdwMessageDialog* _tmp6_;
	AdwMessageDialog* _tmp7_;
	AdwMessageDialog* _tmp8_;
	AdwMessageDialog* _tmp9_;
	AdwMessageDialog* _tmp10_;
	AdwMessageDialog* _tmp11_;
	AdwMessageDialog* _tmp12_;
	AdwMessageDialog* _tmp13_;
	AdwMessageDialog* _tmp14_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->contacts_store;
	_tmp1_ = contacts_store_get_aggregator (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_individual_aggregator_get_primary_store (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp5_ = self->priv->window;
	_tmp6_ = (AdwMessageDialog*) adw_message_dialog_new ((GtkWindow*) _tmp5_, _ ("Primary address book not found"), NULL);
	g_object_ref_sink (_tmp6_);
	_data3_->dialog = _tmp6_;
	_tmp7_ = _data3_->dialog;
	adw_message_dialog_set_body (_tmp7_, _ ("Contacts can't find the configured primary address book. You might exp" \
"erience issues creating or editing contacts"));
	_tmp8_ = _data3_->dialog;
	adw_message_dialog_add_response (_tmp8_, "preferences", _ ("Go To _Preferences"));
	_tmp9_ = _data3_->dialog;
	adw_message_dialog_set_default_response (_tmp9_, "preferences");
	_tmp10_ = _data3_->dialog;
	adw_message_dialog_set_response_appearance (_tmp10_, "preferences", ADW_RESPONSE_SUGGESTED);
	_tmp11_ = _data3_->dialog;
	adw_message_dialog_add_response (_tmp11_, "cancel", _ ("_Cancel"));
	_tmp12_ = _data3_->dialog;
	adw_message_dialog_set_close_response (_tmp12_, "cancel");
	_tmp13_ = _data3_->dialog;
	g_signal_connect_data (_tmp13_, "response", (GCallback) ___lambda45__adw_message_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp14_ = _data3_->dialog;
	gtk_window_present ((GtkWindow*) _tmp14_);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
contacts_app_real_startup (GApplication* base)
{
	ContactsApp * self;
	self = (ContactsApp*) base;
	if (!contacts_ensure_eds_accounts (TRUE)) {
		g_application_quit ((GApplication*) self);
	}
	G_APPLICATION_CLASS (contacts_app_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	contacts_app_load_styling (self);
	contacts_app_create_actions (self);
}

static void
contacts_app_create_actions (ContactsApp* self)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	g_action_map_add_action_entries ((GActionMap*) self, CONTACTS_APP_action_entries, (gint) G_N_ELEMENTS (CONTACTS_APP_action_entries), self);
	_tmp0_ = g_strdup ("F1");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp2_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = g_strdup ("<Control>q");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
}

void
contacts_app_load_styling (ContactsApp* self)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GdkDisplay* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	gtk_css_provider_load_from_resource (provider, "/org/gnome/Contacts/ui/style.css");
	_tmp1_ = gdk_display_get_default ();
	gtk_style_context_add_provider_for_display (_tmp1_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (provider);
}

static void
contacts_app_real_activate (GApplication* base)
{
	ContactsApp * self;
	ContactsSettings* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (ContactsApp*) base;
	_tmp0_ = self->priv->settings;
	_tmp1_ = contacts_settings_get_did_initial_setup (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		contacts_app_create_window (self);
	} else {
		contacts_app_run_setup (self);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ContactsApp* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->setup_window);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda50_ (Block4Data* _data4_,
             EdsfPersonaStore* selected_store)
{
	ContactsApp* self;
	EdsfPersonaStore* edsf_store = NULL;
	ContactsStore* _tmp0_;
	ContactsSettings* _tmp1_;
	self = _data4_->self;
	g_return_if_fail (selected_store != NULL);
	gtk_window_destroy ((GtkWindow*) _data4_->setup_window);
	edsf_store = G_TYPE_CHECK_INSTANCE_CAST (selected_store, EDSF_TYPE_PERSONA_STORE, EdsfPersonaStore);
	_tmp0_ = self->priv->contacts_store;
	contacts_store_set_primary_address_book (_tmp0_, edsf_store);
	_tmp1_ = self->priv->settings;
	contacts_settings_set_did_initial_setup (_tmp1_, TRUE);
	contacts_app_create_window (self);
}

static void
___lambda50__contacts_setup_window_setup_done (ContactsSetupWindow* _sender,
                                               EdsfPersonaStore* selected_address_book,
                                               gpointer self)
{
	__lambda50_ (self, selected_address_book);
}

static void
contacts_app_run_setup (ContactsApp* self)
{
	Block4Data* _data4_;
	ContactsStore* _tmp0_;
	ContactsSetupWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	g_debug ("contacts-app.vala:277: Running initial setup");
	_tmp0_ = self->priv->contacts_store;
	_tmp1_ = contacts_setup_window_new (self, _tmp0_);
	g_object_ref_sink (_tmp1_);
	_data4_->setup_window = _tmp1_;
	g_signal_connect_data (_data4_->setup_window, "setup-done", (GCallback) ___lambda50__contacts_setup_window_setup_done, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data4_->setup_window);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static gchar*
_variant_get1 (GVariant* value)
{
	if (value && g_variant_is_of_type (value, G_VARIANT_TYPE_STRING)) {
		return g_variant_dup_string (value, NULL);
	} else {
		return NULL;
	}
}

static void
contacts_app_on_show_contact (ContactsApp* self,
                              GSimpleAction* action,
                              GVariant* param)
{
	gchar* individual_id = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_application_activate ((GApplication*) self);
	_tmp0_ = _variant_get1 (param);
	individual_id = _tmp0_;
	_tmp1_ = individual_id;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = individual_id;
		contacts_app_show_individual_for_id (self, _tmp2_, NULL, NULL);
	}
	_g_free0 (individual_id);
}

static gboolean
__lambda40_ (ContactsApp* self)
{
	gboolean result;
	g_warning ("contacts-app.vala:315: Some operations have not finished yet!");
	g_application_quit ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda40__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda40_ ((ContactsApp*) self);
	return result;
}

static void
__lambda41_ (ContactsApp* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_flush_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_debug ("contacts-app.vala:323: Succesfully flushed operations before quitting");
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-app.vala:325: Error flushing operations: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_application_quit ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
}

static void
___lambda41__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda41_ ((ContactsApp*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_app_quit_action (ContactsApp* self,
                          GSimpleAction* action,
                          GVariant* param)
{
	ContactsOperationList* _tmp0_;
	ContactsMainWindow* _tmp1_;
	ContactsOperationList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_operations;
	if (!contacts_operation_list_has_pending_operations (_tmp0_)) {
		g_debug ("contacts-app.vala:303: No more operations pending. Quitting immediatel" \
"y");
		g_application_quit ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	}
	g_debug ("contacts-app.vala:307: Some operations still pending, delaying shutdow" \
"n");
	_tmp1_ = self->priv->window;
	if (_tmp1_ != NULL) {
		ContactsMainWindow* _tmp2_;
		_tmp2_ = self->priv->window;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
	}
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda40__gsource_func, g_object_ref (self), g_object_unref);
	_tmp3_ = self->priv->_operations;
	contacts_operation_list_flush (_tmp3_, ___lambda41__gasync_ready_callback, g_object_ref (self));
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ContactsApp* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->chooser);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda51_ (Block5Data* _data5_,
             gint response)
{
	ContactsApp* self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	self = _data5_->self;
	if (response != ((gint) GTK_RESPONSE_ACCEPT)) {
		gtk_native_dialog_destroy ((GtkNativeDialog*) _data5_->chooser);
		return;
	}
	_tmp0_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data5_->chooser);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		g_debug ("contacts-app.vala:354: No file selected, or no path available");
		gtk_native_dialog_destroy ((GtkNativeDialog*) _data5_->chooser);
	}
	_tmp3_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data5_->chooser);
	_tmp4_ = _tmp3_;
	contacts_app_import_file (self, _tmp4_, NULL, NULL);
	_g_object_unref0 (_tmp4_);
	gtk_native_dialog_destroy ((GtkNativeDialog*) _data5_->chooser);
}

static void
___lambda51__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	__lambda51_ (self, response_id);
}

static void
contacts_app_on_import (ContactsApp* self,
                        GSimpleAction* action,
                        GVariant* param)
{
	Block5Data* _data5_;
	ContactsMainWindow* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->priv->window;
	_tmp1_ = gtk_file_chooser_native_new (_ ("Select contact file"), (GtkWindow*) _tmp0_, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Import"), _ ("Cancel"));
	_data5_->chooser = _tmp1_;
	gtk_native_dialog_set_modal ((GtkNativeDialog*) _data5_->chooser, TRUE);
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _data5_->chooser, FALSE);
	_tmp2_ = gtk_file_filter_new ();
	filter = _tmp2_;
	gtk_file_filter_set_name (filter, _ ("vCard files"));
	gtk_file_filter_add_pattern (filter, "*.vcf");
	gtk_file_filter_add_pattern (filter, "*.vcard");
	gtk_file_chooser_add_filter ((GtkFileChooser*) _data5_->chooser, filter);
	g_signal_connect_data ((GtkNativeDialog*) _data5_->chooser, "response", (GCallback) ___lambda51__gtk_native_dialog_response, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	gtk_native_dialog_show ((GtkNativeDialog*) _data5_->chooser);
	_g_object_unref0 (filter);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
contacts_app_import_file_data_free (gpointer _data)
{
	ContactsAppImportFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppImportFileData, _data_);
}

static void
contacts_app_import_file (ContactsApp* self,
                          GFile* file,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	ContactsAppImportFileData* _data_;
	ContactsApp* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (ContactsAppImportFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_app_import_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	contacts_app_import_file_co (_data_);
}

static void
contacts_app_import_file_finish (ContactsApp* self,
                                 GAsyncResult* _res_)
{
	ContactsAppImportFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ContactsApp* self;
		self = _data6_->self;
		_data6_->parse_result = (_vala_array_free (_data6_->parse_result, _data6_->parse_result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
contacts_app_import_file_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	ContactsAppImportFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_import_file_co (_data_);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ContactsApp* self;
		self = _data7_->_data6_->self;
		_g_object_unref0 (_data7_->import_op);
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda53_ (Block7Data* _data7_,
             GObject* obj,
             GAsyncResult* res)
{
	Block6Data* _data6_;
	ContactsApp* self;
	GError* _inner_error0_ = NULL;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	{
		ContactsImportOperation* _tmp0_;
		_tmp0_ = _data7_->import_op;
		contacts_operation_execute_finish ((ContactsOperation*) _tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_debug ("contacts-app.vala:414: Successfully imported a contact");
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-app.vala:416: Couldn't import contacts: %s", _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda53__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda53_ (self, source_object, res);
	block7_data_unref (self);
}

static void
__lambda52_ (Block6Data* _data6_,
             const gchar* response)
{
	ContactsApp* self;
	Block7Data* _data7_;
	ContactsStore* _tmp0_;
	GHashTable** _tmp1_;
	gint _tmp1__length1;
	ContactsImportOperation* _tmp2_;
	ContactsImportOperation* _tmp3_;
	self = _data6_->self;
	g_return_if_fail (response != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->_data6_ = block6_data_ref (_data6_);
	if (g_strcmp0 (response, "continue") != 0) {
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp0_ = self->priv->contacts_store;
	_tmp1_ = _data6_->parse_result;
	_tmp1__length1 = _data6_->parse_result_length1;
	_tmp2_ = contacts_import_operation_new (_tmp0_, _tmp1_, _tmp1__length1);
	_data7_->import_op = _tmp2_;
	_tmp3_ = _data7_->import_op;
	contacts_operation_execute ((ContactsOperation*) _tmp3_, ___lambda53__gasync_ready_callback, block7_data_ref (_data7_));
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
___lambda52__adw_message_dialog_response (AdwMessageDialog* _sender,
                                          const gchar* response,
                                          gpointer self)
{
	__lambda52_ (self, response);
}

static gboolean
contacts_app_import_file_co (ContactsAppImportFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_data_->_data6_->_async_data_ = _data_;
	_data_->_tmp0_ = contacts_io_parse_operation_new (_data_->file);
	_data_->parse_op = _data_->_tmp0_;
	_data_->_data6_->parse_result = NULL;
	_data_->_data6_->parse_result_length1 = 0;
	_data_->_data6_->_parse_result_size_ = _data_->_data6_->parse_result_length1;
	{
		_data_->_tmp1_ = _data_->parse_op;
		_data_->_state_ = 1;
		contacts_operation_execute ((ContactsOperation*) _data_->_tmp1_, contacts_app_import_file_ready, _data_);
		return FALSE;
		_state_1:
		contacts_operation_execute_finish ((ContactsOperation*) _data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_debug ("contacts-app.vala:370: Successfully parsed a contact");
		_data_->_tmp2_ = _data_->parse_op;
		_data_->_tmp3_ = 0;
		_data_->_tmp4_ = contacts_io_parse_operation_steal_parsed_result (_data_->_tmp2_, &_data_->_tmp3_);
		_data_->_data6_->parse_result = (_vala_array_free (_data_->_data6_->parse_result, _data_->_data6_->parse_result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
		_data_->_data6_->parse_result = _data_->_tmp4_;
		_data_->_data6_->parse_result_length1 = _data_->_tmp3_;
		_data_->_data6_->_parse_result_size_ = _data_->_data6_->parse_result_length1;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->err;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_warning ("contacts-app.vala:373: Couldn't parse file: %s", _data_->_tmp6_);
		_data_->_tmp7_ = _data_->self->priv->window;
		_data_->_tmp8_ = g_file_get_basename (_data_->file);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = g_strdup_printf ("An error occurred reading the file '%s'", _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = (AdwMessageDialog*) adw_message_dialog_new ((GtkWindow*) _data_->_tmp7_, _ ("Error reading file"), _ (_data_->_tmp11_));
		g_object_ref_sink (_data_->_tmp12_);
		_data_->_tmp13_ = _data_->_tmp12_;
		_g_free0 (_data_->_tmp11_);
		_g_free0 (_data_->_tmp9_);
		_data_->dialog = _data_->_tmp13_;
		_data_->_tmp14_ = _data_->dialog;
		adw_message_dialog_add_response (_data_->_tmp14_, "ok", _ ("_OK"));
		_data_->_tmp15_ = _data_->dialog;
		adw_message_dialog_set_default_response (_data_->_tmp15_, "ok");
		_data_->_tmp16_ = _data_->dialog;
		gtk_window_present ((GtkWindow*) _data_->_tmp16_);
		_g_object_unref0 (_data_->dialog);
		_g_error_free0 (_data_->err);
		_g_object_unref0 (_data_->parse_op);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->parse_op);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->_data6_->parse_result;
	_data_->_tmp17__length1 = _data_->_data6_->parse_result_length1;
	if (_data_->_tmp17__length1 == 0) {
		_data_->_tmp18_ = _data_->self->priv->window;
		_data_->_tmp19_ = (AdwMessageDialog*) adw_message_dialog_new ((GtkWindow*) _data_->_tmp18_, _ ("No contacts found"), _ ("The imported file does not seem to contain any contacts"));
		g_object_ref_sink (_data_->_tmp19_);
		_data_->_vala1_dialog = _data_->_tmp19_;
		_data_->_tmp20_ = _data_->_vala1_dialog;
		adw_message_dialog_add_response (_data_->_tmp20_, "ok", _ ("_OK"));
		_data_->_tmp21_ = _data_->_vala1_dialog;
		adw_message_dialog_set_default_response (_data_->_tmp21_, "ok");
		_data_->_tmp22_ = _data_->_vala1_dialog;
		gtk_window_present ((GtkWindow*) _data_->_tmp22_);
		_g_object_unref0 (_data_->_vala1_dialog);
		_g_object_unref0 (_data_->parse_op);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = _data_->_data6_->parse_result;
	_data_->_tmp23__length1 = _data_->_data6_->parse_result_length1;
	_data_->_tmp24_ = _data_->_data6_->parse_result;
	_data_->_tmp24__length1 = _data_->_data6_->parse_result_length1;
	_data_->_tmp25_ = g_strdup_printf (ngettext ("By continuing, you will import %u contact", "By continuing, you will import %u contacts", (gulong) _data_->_tmp23__length1), (guint) _data_->_tmp24__length1);
	_data_->body = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->self->priv->window;
	_data_->_tmp27_ = _data_->body;
	_data_->_tmp28_ = (AdwMessageDialog*) adw_message_dialog_new ((GtkWindow*) _data_->_tmp26_, _ ("Continue Import?"), _data_->_tmp27_);
	g_object_ref_sink (_data_->_tmp28_);
	_data_->_vala2_dialog = _data_->_tmp28_;
	_data_->_tmp29_ = _data_->_vala2_dialog;
	adw_message_dialog_add_response (_data_->_tmp29_, "continue", _ ("C_ontinue"));
	_data_->_tmp30_ = _data_->_vala2_dialog;
	adw_message_dialog_set_default_response (_data_->_tmp30_, "continue");
	_data_->_tmp31_ = _data_->_vala2_dialog;
	adw_message_dialog_set_response_appearance (_data_->_tmp31_, "continue", ADW_RESPONSE_SUGGESTED);
	_data_->_tmp32_ = _data_->_vala2_dialog;
	adw_message_dialog_add_response (_data_->_tmp32_, "cancel", _ ("_Cancel"));
	_data_->_tmp33_ = _data_->_vala2_dialog;
	adw_message_dialog_set_close_response (_data_->_tmp33_, "cancel");
	_data_->_tmp34_ = _data_->_vala2_dialog;
	g_signal_connect_data (_data_->_tmp34_, "response", (GCallback) ___lambda52__adw_message_dialog_response, block6_data_ref (_data_->_data6_), (GClosureNotify) block6_data_unref, 0);
	_data_->_tmp35_ = _data_->_vala2_dialog;
	gtk_window_present ((GtkWindow*) _data_->_tmp35_);
	_g_object_unref0 (_data_->_vala2_dialog);
	_g_free0 (_data_->body);
	_g_object_unref0 (_data_->parse_op);
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ContactsOperationList*
contacts_app_get_operations (ContactsApp* self)
{
	ContactsOperationList* result;
	ContactsOperationList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operations;
	result = _tmp0_;
	return result;
}

static void
contacts_app_set_operations (ContactsApp* self,
                             ContactsOperationList* value)
{
	ContactsOperationList* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_app_get_operations (self);
	if (old_value != value) {
		ContactsOperationList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_operations);
		self->priv->_operations = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_app_properties[CONTACTS_APP_OPERATIONS_PROPERTY]);
	}
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GObject *
contacts_app_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsApp * self;
	ContactsSettings* _tmp0_;
	gchar** filtered_fields = NULL;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint filtered_fields_length1;
	gint _filtered_fields_size_;
	FolksSimpleQuery* query = NULL;
	gchar** _tmp4_;
	gint _tmp4__length1;
	FolksSimpleQuery* _tmp5_;
	ContactsSettings* _tmp6_;
	FolksSimpleQuery* _tmp7_;
	ContactsStore* _tmp8_;
	parent_class = G_OBJECT_CLASS (contacts_app_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_APP, ContactsApp);
	_tmp0_ = contacts_settings_new (self);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = _vala_array_dup3 (FOLKS_QUERY_MATCH_FIELDS_NAMES, G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES));
	_tmp1__length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_NAMES);
	filtered_fields = _tmp1_;
	filtered_fields_length1 = _tmp1__length1;
	_filtered_fields_size_ = filtered_fields_length1;
	{
		const gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = FOLKS_QUERY_MATCH_FIELDS_ADDRESSES;
		field_collection_length1 = G_N_ELEMENTS (FOLKS_QUERY_MATCH_FIELDS_ADDRESSES);
		for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
			const gchar* field = NULL;
			field = field_collection[field_it];
			{
				const gchar* _tmp2_;
				gchar* _tmp3_;
				_tmp2_ = field;
				_tmp3_ = g_strdup (_tmp2_);
				_vala_array_add1 (&filtered_fields, &filtered_fields_length1, &_filtered_fields_size_, _tmp3_);
			}
		}
	}
	_tmp4_ = filtered_fields;
	_tmp4__length1 = filtered_fields_length1;
	_tmp5_ = folks_simple_query_new ("", _tmp4_, _tmp4__length1);
	query = _tmp5_;
	_tmp6_ = self->priv->settings;
	_tmp7_ = query;
	_tmp8_ = contacts_store_new ((GSettings*) _tmp6_, (FolksQuery*) _tmp7_);
	_g_object_unref0 (self->priv->contacts_store);
	self->priv->contacts_store = _tmp8_;
	g_application_add_main_option_entries ((GApplication*) self, CONTACTS_APP_options);
	_g_object_unref0 (query);
	filtered_fields = (_vala_array_free (filtered_fields, filtered_fields_length1, (GDestroyNotify) g_free), NULL);
	return obj;
}

static void
contacts_app_class_init (ContactsAppClass * klass,
                         gpointer klass_data)
{
	contacts_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsApp_private_offset);
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) contacts_app_real_command_line;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) contacts_app_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) contacts_app_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) contacts_app_real_activate;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_app_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_app_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_app_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_app_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_APP_OPERATIONS_PROPERTY, contacts_app_properties[CONTACTS_APP_OPERATIONS_PROPERTY] = g_param_spec_object ("operations", "operations", "operations", CONTACTS_TYPE_OPERATION_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_app_instance_init (ContactsApp * self,
                            gpointer klass)
{
	ContactsOperationList* _tmp0_;
	self->priv = contacts_app_get_instance_private (self);
	_tmp0_ = contacts_operation_list_new ();
	self->priv->_operations = _tmp0_;
}

static void
contacts_app_finalize (GObject * obj)
{
	ContactsApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_APP, ContactsApp);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->contacts_store);
	_g_object_unref0 (self->priv->_operations);
	G_OBJECT_CLASS (contacts_app_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsApp), 0, (GInstanceInitFunc) contacts_app_instance_init, NULL };
	GType contacts_app_type_id;
	contacts_app_type_id = g_type_register_static (adw_application_get_type (), "ContactsApp", &g_define_type_info, 0);
	ContactsApp_private_offset = g_type_add_instance_private (contacts_app_type_id, sizeof (ContactsAppPrivate));
	return contacts_app_type_id;
}

GType
contacts_app_get_type (void)
{
	static volatile gsize contacts_app_type_id__once = 0;
	if (g_once_init_enter (&contacts_app_type_id__once)) {
		GType contacts_app_type_id;
		contacts_app_type_id = contacts_app_get_type_once ();
		g_once_init_leave (&contacts_app_type_id__once, contacts_app_type_id);
	}
	return contacts_app_type_id__once;
}

static void
_vala_contacts_app_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	ContactsApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_APP, ContactsApp);
	switch (property_id) {
		case CONTACTS_APP_OPERATIONS_PROPERTY:
		g_value_set_object (value, contacts_app_get_operations (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_app_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	ContactsApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_APP, ContactsApp);
	switch (property_id) {
		case CONTACTS_APP_OPERATIONS_PROPERTY:
		contacts_app_set_operations (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

