/* contacts-avatar-selector.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-avatar-selector.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <adwaita.h>
#include <folks/folks.h>
#include "contactscore.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libportal/portal.h>
#include <glib/gi18n-lib.h>
#include <math.h>
#include <float.h>
#include "contacts.h"

#define MAIN_SIZE 128
#define ICONS_SIZE 64
#define CONTACTS_AVATAR_SELECTOR_AVATAR_BUTTON_CSS_NAME "avatar-button"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_THUMBNAIL (contacts_thumbnail_get_type ())
#define CONTACTS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail))
#define CONTACTS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_THUMBNAIL, ContactsThumbnailClass))
#define CONTACTS_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_THUMBNAIL))
#define CONTACTS_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_THUMBNAIL))
#define CONTACTS_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_THUMBNAIL, ContactsThumbnailClass))

typedef struct _ContactsThumbnail ContactsThumbnail;
typedef struct _ContactsThumbnailClass ContactsThumbnailClass;
typedef struct _ContactsThumbnailPrivate ContactsThumbnailPrivate;
enum  {
	CONTACTS_THUMBNAIL_0_PROPERTY,
	CONTACTS_THUMBNAIL_SOURCE_PIXBUF_PROPERTY,
	CONTACTS_THUMBNAIL_NUM_PROPERTIES
};
static GParamSpec* contacts_thumbnail_properties[CONTACTS_THUMBNAIL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_AVATAR (contacts_avatar_get_type ())
#define CONTACTS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatar))
#define CONTACTS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))
#define CONTACTS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR))
#define CONTACTS_IS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR))
#define CONTACTS_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))

typedef struct _ContactsAvatar ContactsAvatar;
typedef struct _ContactsAvatarClass ContactsAvatarClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CONTACTS_TYPE_AVATAR_SELECTOR (contacts_avatar_selector_get_type ())
#define CONTACTS_AVATAR_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelector))
#define CONTACTS_AVATAR_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelectorClass))
#define CONTACTS_IS_AVATAR_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR_SELECTOR))
#define CONTACTS_IS_AVATAR_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR_SELECTOR))
#define CONTACTS_AVATAR_SELECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelectorClass))

typedef struct _ContactsAvatarSelector ContactsAvatarSelector;
typedef struct _ContactsAvatarSelectorClass ContactsAvatarSelectorClass;
typedef struct _ContactsAvatarSelectorPrivate ContactsAvatarSelectorPrivate;
enum  {
	CONTACTS_AVATAR_SELECTOR_0_PROPERTY,
	CONTACTS_AVATAR_SELECTOR_CONTACT_PROPERTY,
	CONTACTS_AVATAR_SELECTOR_SELECTED_AVATAR_PROPERTY,
	CONTACTS_AVATAR_SELECTOR_NUM_PROPERTIES
};
static GParamSpec* contacts_avatar_selector_properties[CONTACTS_AVATAR_SELECTOR_NUM_PROPERTIES];
typedef struct _ContactsAvatarSelectorSetupCameraPortalData ContactsAvatarSelectorSetupCameraPortalData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block9Data Block9Data;

#define CONTACTS_TYPE_CROP_DIALOG (contacts_crop_dialog_get_type ())
#define CONTACTS_CROP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CROP_DIALOG, ContactsCropDialog))
#define CONTACTS_CROP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CROP_DIALOG, ContactsCropDialogClass))
#define CONTACTS_IS_CROP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CROP_DIALOG))
#define CONTACTS_IS_CROP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CROP_DIALOG))
#define CONTACTS_CROP_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CROP_DIALOG, ContactsCropDialogClass))

typedef struct _ContactsCropDialog ContactsCropDialog;
typedef struct _ContactsCropDialogClass ContactsCropDialogClass;
typedef struct _Block10Data Block10Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsThumbnail {
	GtkFlowBoxChild parent_instance;
	ContactsThumbnailPrivate * priv;
};

struct _ContactsThumbnailClass {
	GtkFlowBoxChildClass parent_class;
};

struct _ContactsThumbnailPrivate {
	GdkPixbuf* _source_pixbuf;
};

struct _ContactsAvatarSelector {
	GtkDialog parent_instance;
	ContactsAvatarSelectorPrivate * priv;
};

struct _ContactsAvatarSelectorClass {
	GtkDialogClass parent_class;
};

struct _ContactsAvatarSelectorPrivate {
	ContactsContact* _contact;
	GtkFlowBox* thumbnail_grid;
	GtkButton* camera_button;
	XdpPortal* portal;
	GdkPixbuf* _selected_avatar;
};

struct _ContactsAvatarSelectorSetupCameraPortalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsAvatarSelector* self;
	XdpPortal* _tmp0_;
	XdpPortal* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
};

struct _Block9Data {
	int _ref_count_;
	ContactsAvatarSelector* self;
	GtkFileChooserNative* chooser;
};

struct _Block10Data {
	int _ref_count_;
	Block9Data * _data9_;
	ContactsCropDialog* dialog;
};

static gint ContactsThumbnail_private_offset;
static gpointer contacts_thumbnail_parent_class = NULL;
static gint ContactsAvatarSelector_private_offset;
static gpointer contacts_avatar_selector_parent_class = NULL;

VALA_EXTERN GType contacts_thumbnail_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsThumbnail, g_object_unref)
static ContactsThumbnail* contacts_thumbnail_new (GdkPixbuf* source_pixbuf);
static ContactsThumbnail* contacts_thumbnail_construct (GType object_type,
                                                 GdkPixbuf* source_pixbuf);
VALA_EXTERN GType contacts_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatar, g_object_unref)
VALA_EXTERN ContactsAvatar* contacts_avatar_new (gint size,
                                     FolksIndividual* individual);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct (GType object_type,
                                           gint size,
                                           FolksIndividual* individual);
VALA_EXTERN void contacts_avatar_set_pixbuf (ContactsAvatar* self,
                                 GdkPixbuf* a_pixbuf);
VALA_EXTERN ContactsThumbnail* contacts_thumbnail_new_for_chunk (ContactsAvatarChunk* chunk);
VALA_EXTERN ContactsThumbnail* contacts_thumbnail_construct_for_chunk (GType object_type,
                                                           ContactsAvatarChunk* chunk);
VALA_EXTERN ContactsThumbnail* contacts_thumbnail_new_for_filename (const gchar* filename);
VALA_EXTERN ContactsThumbnail* contacts_thumbnail_construct_for_filename (GType object_type,
                                                              const gchar* filename);
VALA_EXTERN GdkPixbuf* contacts_thumbnail_get_source_pixbuf (ContactsThumbnail* self);
VALA_EXTERN void contacts_thumbnail_set_source_pixbuf (ContactsThumbnail* self,
                                           GdkPixbuf* value);
static void contacts_thumbnail_finalize (GObject * obj);
static GType contacts_thumbnail_get_type_once (void);
static void _vala_contacts_thumbnail_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_contacts_thumbnail_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
VALA_EXTERN GType contacts_avatar_selector_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatarSelector, g_object_unref)
VALA_EXTERN ContactsAvatarSelector* contacts_avatar_selector_new (ContactsContact* contact,
                                                      GtkWindow* window);
VALA_EXTERN ContactsAvatarSelector* contacts_avatar_selector_construct (GType object_type,
                                                            ContactsContact* contact,
                                                            GtkWindow* window);
static void contacts_avatar_selector_on_thumbnails_selected (ContactsAvatarSelector* self,
                                                      GtkFlowBox* thumbnail_grid);
static void _contacts_avatar_selector_on_thumbnails_selected_gtk_flow_box_selected_children_changed (GtkFlowBox* _sender,
                                                                                              gpointer self);
static void contacts_avatar_selector_on_thumbnail_activated (ContactsAvatarSelector* self,
                                                      GtkFlowBox* thumbnail_grid,
                                                      GtkFlowBoxChild* child);
static void _contacts_avatar_selector_on_thumbnail_activated_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                                    GtkFlowBoxChild* child,
                                                                                    gpointer self);
static void contacts_avatar_selector_update_thumbnail_grid (ContactsAvatarSelector* self);
static void contacts_avatar_selector_setup_camera_portal (ContactsAvatarSelector* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void contacts_avatar_selector_setup_camera_portal_finish (ContactsAvatarSelector* self,
                                                          GAsyncResult* _res_);
static void contacts_avatar_selector_set_selected_avatar (ContactsAvatarSelector* self,
                                                   GdkPixbuf* value);
static void contacts_avatar_selector_setup_camera_portal_data_free (gpointer _data);
static gboolean contacts_avatar_selector_setup_camera_portal_co (ContactsAvatarSelectorSetupCameraPortalData* _data_);
static GdkPixbuf* contacts_avatar_selector_scale_pixbuf_for_avatar_use (ContactsAvatarSelector* self,
                                                                 GdkPixbuf* pixbuf);
VALA_EXTERN void contacts_avatar_selector_set_avatar_on_contact (ContactsAvatarSelector* self,
                                                     GError** error);
VALA_EXTERN GdkPixbuf* contacts_avatar_selector_get_selected_avatar (ContactsAvatarSelector* self);
VALA_EXTERN ContactsContact* contacts_avatar_selector_get_contact (ContactsAvatarSelector* self);
static void contacts_avatar_selector_on_camera_button_clicked (ContactsAvatarSelector* self,
                                                        GtkButton* button);
static void _contacts_avatar_selector_on_camera_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
static void contacts_avatar_selector_on_file_clicked (ContactsAvatarSelector* self,
                                               GtkButton* button);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda14_ (Block9Data* _data9_,
                  gint response);
VALA_EXTERN GType contacts_crop_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsCropDialog, g_object_unref)
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
VALA_EXTERN ContactsCropDialog* contacts_crop_dialog_new_for_pixbuf (GdkPixbuf* pixbuf,
                                                         GtkWindow* parent);
VALA_EXTERN ContactsCropDialog* contacts_crop_dialog_construct_for_pixbuf (GType object_type,
                                                               GdkPixbuf* pixbuf,
                                                               GtkWindow* parent);
static void ____lambda15_ (Block10Data* _data10_,
                    gint response);
VALA_EXTERN GdkPixbuf* contacts_crop_dialog_create_pixbuf (ContactsCropDialog* self);
static void _____lambda15__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
static void ___lambda14__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void _contacts_avatar_selector_on_file_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
VALA_EXTERN void contacts_avatar_selector_set_contact (ContactsAvatarSelector* self,
                                           ContactsContact* value);
static void contacts_avatar_selector_finalize (GObject * obj);
static GType contacts_avatar_selector_get_type_once (void);
static void _vala_contacts_avatar_selector_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_contacts_avatar_selector_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
contacts_thumbnail_get_instance_private (ContactsThumbnail* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsThumbnail_private_offset);
}

static ContactsThumbnail*
contacts_thumbnail_construct (GType object_type,
                              GdkPixbuf* source_pixbuf)
{
	ContactsThumbnail * self = NULL;
	ContactsAvatar* avatar = NULL;
	ContactsAvatar* _tmp0_;
	self = (ContactsThumbnail*) g_object_new (object_type, "visible", TRUE, "halign", GTK_ALIGN_CENTER, "source-pixbuf", source_pixbuf, NULL);
	gtk_widget_add_css_class ((GtkWidget*) self, "circular");
	_tmp0_ = contacts_avatar_new (ICONS_SIZE, NULL);
	g_object_ref_sink (_tmp0_);
	avatar = _tmp0_;
	contacts_avatar_set_pixbuf (avatar, source_pixbuf);
	gtk_flow_box_child_set_child ((GtkFlowBoxChild*) self, (GtkWidget*) avatar);
	_g_object_unref0 (avatar);
	return self;
}

static ContactsThumbnail*
contacts_thumbnail_new (GdkPixbuf* source_pixbuf)
{
	return contacts_thumbnail_construct (CONTACTS_TYPE_THUMBNAIL, source_pixbuf);
}

ContactsThumbnail*
contacts_thumbnail_construct_for_chunk (GType object_type,
                                        ContactsAvatarChunk* chunk)
{
	ContactsThumbnail * self = NULL;
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (chunk != NULL, NULL);
	_tmp0_ = contacts_avatar_chunk_get_avatar (chunk);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "chunk.avatar != null", NULL);
	pixbuf = NULL;
	{
		GInputStream* stream = NULL;
		GLoadableIcon* _tmp2_;
		GLoadableIcon* _tmp3_;
		GInputStream* _tmp4_;
		GdkPixbuf* _tmp5_ = NULL;
		GInputStream* _tmp6_;
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		_tmp2_ = contacts_avatar_chunk_get_avatar (chunk);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_loadable_icon_load (_tmp3_, MAIN_SIZE, NULL, NULL, &_inner_error0_);
		stream = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = stream;
		_tmp7_ = gdk_pixbuf_new_from_stream (_tmp6_, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp8_;
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_debug ("contacts-avatar-selector.vala:47: Couldn't create thumbnail for chunk:" \
" %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp11_ = pixbuf;
	self = (ContactsThumbnail*) contacts_thumbnail_construct (object_type, _tmp11_);
	_g_object_unref0 (pixbuf);
	return self;
}

ContactsThumbnail*
contacts_thumbnail_new_for_chunk (ContactsAvatarChunk* chunk)
{
	return contacts_thumbnail_construct_for_chunk (CONTACTS_TYPE_THUMBNAIL, chunk);
}

ContactsThumbnail*
contacts_thumbnail_construct_for_filename (GType object_type,
                                           const gchar* filename)
{
	ContactsThumbnail * self = NULL;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	pixbuf = NULL;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp1_ = gdk_pixbuf_new_from_file (filename, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("contacts-avatar-selector.vala:57: Couldn't create frame for file '%s':" \
" %s", filename, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp5_ = pixbuf;
	self = (ContactsThumbnail*) contacts_thumbnail_construct (object_type, _tmp5_);
	_g_object_unref0 (pixbuf);
	return self;
}

ContactsThumbnail*
contacts_thumbnail_new_for_filename (const gchar* filename)
{
	return contacts_thumbnail_construct_for_filename (CONTACTS_TYPE_THUMBNAIL, filename);
}

GdkPixbuf*
contacts_thumbnail_get_source_pixbuf (ContactsThumbnail* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_pixbuf;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
contacts_thumbnail_set_source_pixbuf (ContactsThumbnail* self,
                                      GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_thumbnail_get_source_pixbuf (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source_pixbuf);
		self->priv->_source_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_thumbnail_properties[CONTACTS_THUMBNAIL_SOURCE_PIXBUF_PROPERTY]);
	}
}

static void
contacts_thumbnail_class_init (ContactsThumbnailClass * klass,
                               gpointer klass_data)
{
	contacts_thumbnail_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsThumbnail_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_thumbnail_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_thumbnail_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_thumbnail_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_THUMBNAIL_SOURCE_PIXBUF_PROPERTY, contacts_thumbnail_properties[CONTACTS_THUMBNAIL_SOURCE_PIXBUF_PROPERTY] = g_param_spec_object ("source-pixbuf", "source-pixbuf", "source-pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
contacts_thumbnail_instance_init (ContactsThumbnail * self,
                                  gpointer klass)
{
	self->priv = contacts_thumbnail_get_instance_private (self);
}

static void
contacts_thumbnail_finalize (GObject * obj)
{
	ContactsThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail);
	_g_object_unref0 (self->priv->_source_pixbuf);
	G_OBJECT_CLASS (contacts_thumbnail_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_thumbnail_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsThumbnail), 0, (GInstanceInitFunc) contacts_thumbnail_instance_init, NULL };
	GType contacts_thumbnail_type_id;
	contacts_thumbnail_type_id = g_type_register_static (gtk_flow_box_child_get_type (), "ContactsThumbnail", &g_define_type_info, 0);
	ContactsThumbnail_private_offset = g_type_add_instance_private (contacts_thumbnail_type_id, sizeof (ContactsThumbnailPrivate));
	return contacts_thumbnail_type_id;
}

GType
contacts_thumbnail_get_type (void)
{
	static volatile gsize contacts_thumbnail_type_id__once = 0;
	if (g_once_init_enter (&contacts_thumbnail_type_id__once)) {
		GType contacts_thumbnail_type_id;
		contacts_thumbnail_type_id = contacts_thumbnail_get_type_once ();
		g_once_init_leave (&contacts_thumbnail_type_id__once, contacts_thumbnail_type_id);
	}
	return contacts_thumbnail_type_id__once;
}

static void
_vala_contacts_thumbnail_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	ContactsThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail);
	switch (property_id) {
		case CONTACTS_THUMBNAIL_SOURCE_PIXBUF_PROPERTY:
		g_value_set_object (value, contacts_thumbnail_get_source_pixbuf (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_thumbnail_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	ContactsThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail);
	switch (property_id) {
		case CONTACTS_THUMBNAIL_SOURCE_PIXBUF_PROPERTY:
		contacts_thumbnail_set_source_pixbuf (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_avatar_selector_get_instance_private (ContactsAvatarSelector* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsAvatarSelector_private_offset);
}

static void
_contacts_avatar_selector_on_thumbnails_selected_gtk_flow_box_selected_children_changed (GtkFlowBox* _sender,
                                                                                         gpointer self)
{
	contacts_avatar_selector_on_thumbnails_selected ((ContactsAvatarSelector*) self, _sender);
}

static void
_contacts_avatar_selector_on_thumbnail_activated_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                               GtkFlowBoxChild* child,
                                                                               gpointer self)
{
	contacts_avatar_selector_on_thumbnail_activated ((ContactsAvatarSelector*) self, _sender, child);
}

ContactsAvatarSelector*
contacts_avatar_selector_construct (GType object_type,
                                    ContactsContact* contact,
                                    GtkWindow* window)
{
	ContactsAvatarSelector * self = NULL;
	GtkFlowBox* _tmp0_;
	GtkFlowBox* _tmp1_;
	g_return_val_if_fail (contact != NULL, NULL);
	self = (ContactsAvatarSelector*) g_object_new (object_type, "contact", contact, "transient-for", window, "use-header-bar", 1, NULL);
	_tmp0_ = self->priv->thumbnail_grid;
	g_signal_connect_object (_tmp0_, "selected-children-changed", (GCallback) _contacts_avatar_selector_on_thumbnails_selected_gtk_flow_box_selected_children_changed, self, 0);
	_tmp1_ = self->priv->thumbnail_grid;
	g_signal_connect_object (_tmp1_, "child-activated", (GCallback) _contacts_avatar_selector_on_thumbnail_activated_gtk_flow_box_child_activated, self, 0);
	contacts_avatar_selector_update_thumbnail_grid (self);
	contacts_avatar_selector_setup_camera_portal (self, NULL, NULL);
	return self;
}

ContactsAvatarSelector*
contacts_avatar_selector_new (ContactsContact* contact,
                              GtkWindow* window)
{
	return contacts_avatar_selector_construct (CONTACTS_TYPE_AVATAR_SELECTOR, contact, window);
}

static void
contacts_avatar_selector_on_thumbnails_selected (ContactsAvatarSelector* self,
                                                 GtkFlowBox* thumbnail_grid)
{
	GList* selected = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (thumbnail_grid != NULL);
	_tmp0_ = gtk_flow_box_get_selected_children (thumbnail_grid);
	selected = _tmp0_;
	_tmp1_ = selected;
	if (_tmp1_ != NULL) {
		ContactsThumbnail* thumbnail = NULL;
		GList* _tmp2_;
		gconstpointer _tmp3_;
		ContactsThumbnail* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		_tmp2_ = selected;
		_tmp3_ = _tmp2_->data;
		thumbnail = G_TYPE_CHECK_INSTANCE_CAST ((GtkFlowBoxChild*) _tmp3_, CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail);
		_tmp4_ = thumbnail;
		_tmp5_ = contacts_thumbnail_get_source_pixbuf (_tmp4_);
		_tmp6_ = _tmp5_;
		contacts_avatar_selector_set_selected_avatar (self, _tmp6_);
	} else {
		contacts_avatar_selector_set_selected_avatar (self, NULL);
	}
	(selected == NULL) ? NULL : (selected = (g_list_free (selected), NULL));
}

static void
contacts_avatar_selector_on_thumbnail_activated (ContactsAvatarSelector* self,
                                                 GtkFlowBox* thumbnail_grid,
                                                 GtkFlowBoxChild* child)
{
	ContactsThumbnail* thumbnail = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (thumbnail_grid != NULL);
	g_return_if_fail (child != NULL);
	thumbnail = G_TYPE_CHECK_INSTANCE_CAST (child, CONTACTS_TYPE_THUMBNAIL, ContactsThumbnail);
	_tmp0_ = contacts_thumbnail_get_source_pixbuf (thumbnail);
	_tmp1_ = _tmp0_;
	contacts_avatar_selector_set_selected_avatar (self, _tmp1_);
	gtk_dialog_response ((GtkDialog*) self, (gint) GTK_RESPONSE_ACCEPT);
}

static void
contacts_avatar_selector_setup_camera_portal_data_free (gpointer _data)
{
	ContactsAvatarSelectorSetupCameraPortalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAvatarSelectorSetupCameraPortalData, _data_);
}

static void
contacts_avatar_selector_setup_camera_portal (ContactsAvatarSelector* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	ContactsAvatarSelectorSetupCameraPortalData* _data_;
	ContactsAvatarSelector* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ContactsAvatarSelectorSetupCameraPortalData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_avatar_selector_setup_camera_portal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_avatar_selector_setup_camera_portal_co (_data_);
}

static void
contacts_avatar_selector_setup_camera_portal_finish (ContactsAvatarSelector* self,
                                                     GAsyncResult* _res_)
{
	ContactsAvatarSelectorSetupCameraPortalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
contacts_avatar_selector_setup_camera_portal_co (ContactsAvatarSelectorSetupCameraPortalData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = xdp_portal_new ();
	_g_object_unref0 (_data_->self->priv->portal);
	_data_->self->priv->portal = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->portal;
	if (xdp_portal_is_camera_present (_data_->_tmp1_)) {
		_data_->_tmp2_ = _data_->self->priv->camera_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp2_, TRUE);
	} else {
		_data_->_tmp3_ = _data_->self->priv->camera_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _data_->_tmp3_, _ ("No Camera Detected"));
		_data_->_tmp4_ = _data_->self->priv->camera_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp4_, FALSE);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GdkPixbuf*
contacts_avatar_selector_scale_pixbuf_for_avatar_use (ContactsAvatarSelector* self,
                                                      GdkPixbuf* pixbuf)
{
	gint w = 0;
	gint h = 0;
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (pixbuf == NULL) {
		result = NULL;
		return result;
	}
	w = gdk_pixbuf_get_width (pixbuf);
	h = gdk_pixbuf_get_height (pixbuf);
	if (w <= MAIN_SIZE) {
		_tmp0_ = h <= MAIN_SIZE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkPixbuf* _tmp1_;
		_tmp1_ = _g_object_ref0 (pixbuf);
		result = _tmp1_;
		return result;
	}
	if (w > h) {
		h = (gint) round ((gdouble) ((h * ((gfloat) MAIN_SIZE)) / w));
		w = MAIN_SIZE;
	} else {
		w = (gint) round ((gdouble) ((w * ((gfloat) MAIN_SIZE)) / h));
		h = MAIN_SIZE;
	}
	_tmp2_ = gdk_pixbuf_scale_simple (pixbuf, w, h, GDK_INTERP_HYPER);
	result = _tmp2_;
	return result;
}

/** Sets the selected avatar on the contact (it does _not_ save it) */
void
contacts_avatar_selector_set_avatar_on_contact (ContactsAvatarSelector* self,
                                                GError** error)
{
	guint8* buffer = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	guint8* _tmp3_ = NULL;
	gsize _tmp4_ = 0;
	GBytesIcon* icon = NULL;
	GBytes* _tmp5_;
	GBytes* _tmp6_;
	GBytesIcon* _tmp7_;
	GBytesIcon* _tmp8_;
	ContactsChunk* avatar_chunk = NULL;
	ContactsContact* _tmp9_;
	ContactsChunk* _tmp10_;
	ContactsChunk* _tmp11_;
	ContactsChunk* _tmp12_;
	ContactsChunk* _tmp16_;
	GBytesIcon* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = contacts_avatar_selector_get_selected_avatar (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	gdk_pixbuf_save_to_buffer (_tmp2_, &_tmp3_, &_tmp4_, "png", &_inner_error0_, NULL, NULL);
	buffer = (g_free (buffer), NULL);
	buffer = _tmp3_;
	buffer_length1 = _tmp4_;
	_buffer_size_ = buffer_length1;
	_g_object_unref0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		buffer = (g_free (buffer), NULL);
		return;
	}
	_tmp5_ = g_bytes_new (buffer, buffer_length1);
	_tmp6_ = _tmp5_;
	_tmp7_ = (GBytesIcon*) g_bytes_icon_new (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_bytes_unref0 (_tmp6_);
	icon = _tmp8_;
	_tmp9_ = self->priv->_contact;
	_tmp10_ = contacts_contact_get_most_relevant_chunk (_tmp9_, "avatar", TRUE);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	avatar_chunk = _tmp11_;
	_tmp12_ = avatar_chunk;
	if (_tmp12_ == NULL) {
		ContactsContact* _tmp13_;
		ContactsChunk* _tmp14_;
		ContactsChunk* _tmp15_;
		_tmp13_ = self->priv->_contact;
		_tmp14_ = contacts_contact_create_chunk (_tmp13_, "avatar", NULL);
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_g_object_unref0 (avatar_chunk);
		avatar_chunk = _tmp15_;
	}
	_tmp16_ = avatar_chunk;
	_tmp17_ = icon;
	contacts_avatar_chunk_set_avatar (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, CONTACTS_TYPE_AVATAR_CHUNK, ContactsAvatarChunk), (GLoadableIcon*) _tmp17_);
	_g_object_unref0 (avatar_chunk);
	_g_object_unref0 (icon);
	buffer = (g_free (buffer), NULL);
}

static void
contacts_avatar_selector_update_thumbnail_grid (ContactsAvatarSelector* self)
{
	ContactsChunkFilter* filter = NULL;
	ContactsChunkFilter* _tmp0_;
	GtkFilterListModel* chunks = NULL;
	ContactsContact* _tmp1_;
	GListModel* _tmp2_;
	ContactsChunkFilter* _tmp3_;
	GtkFilterListModel* _tmp4_;
	gchar** stock_files = NULL;
	gint _tmp17_ = 0;
	gchar** _tmp18_;
	gint stock_files_length1;
	gint _stock_files_size_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = contacts_chunk_filter_new_for_property ("avatar", FALSE);
	filter = _tmp0_;
	_tmp1_ = self->priv->_contact;
	_tmp2_ = _g_object_ref0 ((GListModel*) _tmp1_);
	_tmp3_ = filter;
	filter = NULL;
	_tmp4_ = gtk_filter_list_model_new (_tmp2_, (GtkFilter*) _tmp3_);
	chunks = _tmp4_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GtkFilterListModel* _tmp7_;
				ContactsAvatarChunk* chunk = NULL;
				GtkFilterListModel* _tmp8_;
				GObject* _tmp9_;
				ContactsThumbnail* thumbnail = NULL;
				ContactsAvatarChunk* _tmp10_;
				ContactsThumbnail* _tmp11_;
				ContactsThumbnail* _tmp12_;
				GdkPixbuf* _tmp13_;
				GdkPixbuf* _tmp14_;
				if (!_tmp5_) {
					guint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = chunks;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp7_))) {
					break;
				}
				_tmp8_ = chunks;
				_tmp9_ = g_list_model_get_item ((GListModel*) _tmp8_, i);
				chunk = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CONTACTS_TYPE_AVATAR_CHUNK, ContactsAvatarChunk);
				_tmp10_ = chunk;
				_tmp11_ = contacts_thumbnail_new_for_chunk (_tmp10_);
				g_object_ref_sink (_tmp11_);
				thumbnail = _tmp11_;
				_tmp12_ = thumbnail;
				_tmp13_ = contacts_thumbnail_get_source_pixbuf (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ != NULL) {
					GtkFlowBox* _tmp15_;
					ContactsThumbnail* _tmp16_;
					_tmp15_ = self->priv->thumbnail_grid;
					_tmp16_ = thumbnail;
					gtk_flow_box_insert (_tmp15_, (GtkWidget*) _tmp16_, -1);
				}
				_g_object_unref0 (thumbnail);
				_g_object_unref0 (chunk);
			}
		}
	}
	_tmp18_ = contacts_utils_get_stock_avatars (&_tmp17_);
	stock_files = _tmp18_;
	stock_files_length1 = _tmp17_;
	_stock_files_size_ = stock_files_length1;
	_tmp19_ = stock_files;
	_tmp19__length1 = stock_files_length1;
	{
		gchar** file_name_collection = NULL;
		gint file_name_collection_length1 = 0;
		gint _file_name_collection_size_ = 0;
		gint file_name_it = 0;
		file_name_collection = _tmp19_;
		file_name_collection_length1 = _tmp19__length1;
		for (file_name_it = 0; file_name_it < file_name_collection_length1; file_name_it = file_name_it + 1) {
			gchar* _tmp20_;
			gchar* file_name = NULL;
			_tmp20_ = g_strdup (file_name_collection[file_name_it]);
			file_name = _tmp20_;
			{
				ContactsThumbnail* thumbnail = NULL;
				const gchar* _tmp21_;
				ContactsThumbnail* _tmp22_;
				ContactsThumbnail* _tmp23_;
				GdkPixbuf* _tmp24_;
				GdkPixbuf* _tmp25_;
				_tmp21_ = file_name;
				_tmp22_ = contacts_thumbnail_new_for_filename (_tmp21_);
				g_object_ref_sink (_tmp22_);
				thumbnail = _tmp22_;
				_tmp23_ = thumbnail;
				_tmp24_ = contacts_thumbnail_get_source_pixbuf (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_ != NULL) {
					GtkFlowBox* _tmp26_;
					ContactsThumbnail* _tmp27_;
					_tmp26_ = self->priv->thumbnail_grid;
					_tmp27_ = thumbnail;
					gtk_flow_box_insert (_tmp26_, (GtkWidget*) _tmp27_, -1);
				}
				_g_object_unref0 (thumbnail);
				_g_free0 (file_name);
			}
		}
	}
	stock_files = (_vala_array_free (stock_files, stock_files_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (chunks);
	_g_object_unref0 (filter);
}

static void
contacts_avatar_selector_on_camera_button_clicked (ContactsAvatarSelector* self,
                                                   GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
}

static void
_contacts_avatar_selector_on_camera_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	contacts_avatar_selector_on_camera_button_clicked ((ContactsAvatarSelector*) self, _sender);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		ContactsAvatarSelector* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->chooser);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		ContactsAvatarSelector* self;
		self = _data10_->_data9_->self;
		_g_object_unref0 (_data10_->dialog);
		block9_data_unref (_data10_->_data9_);
		_data10_->_data9_ = NULL;
		g_slice_free (Block10Data, _data10_);
	}
}

static void
____lambda15_ (Block10Data* _data10_,
               gint response)
{
	Block9Data* _data9_;
	ContactsAvatarSelector* self;
	ContactsCropDialog* _tmp3_;
	_data9_ = _data10_->_data9_;
	self = _data9_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		ContactsCropDialog* _tmp0_;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp0_ = _data10_->dialog;
		_tmp1_ = contacts_crop_dialog_create_pixbuf (_tmp0_);
		_tmp2_ = _tmp1_;
		contacts_avatar_selector_set_selected_avatar (self, _tmp2_);
		_g_object_unref0 (_tmp2_);
		gtk_dialog_response ((GtkDialog*) self, (gint) GTK_RESPONSE_ACCEPT);
	}
	_tmp3_ = _data10_->dialog;
	gtk_window_destroy ((GtkWindow*) _tmp3_);
}

static void
_____lambda15__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	____lambda15_ (self, response_id);
}

static void
__lambda14_ (Block9Data* _data9_,
             gint response)
{
	ContactsAvatarSelector* self;
	GError* _inner_error0_ = NULL;
	self = _data9_->self;
	if (response != ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp0_;
		_tmp0_ = _data9_->chooser;
		gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp0_);
		return;
	}
	{
		GFile* file = NULL;
		GtkFileChooserNative* _tmp1_;
		GFile* _tmp2_;
		GFileInputStream* in_stream = NULL;
		GFile* _tmp3_;
		GFileInputStream* _tmp4_;
		GdkPixbuf* pixbuf = NULL;
		GFileInputStream* _tmp5_;
		GdkPixbuf* _tmp6_;
		GFileInputStream* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GdkPixbuf* _tmp9_;
		_tmp1_ = _data9_->chooser;
		_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
		file = _tmp2_;
		_tmp3_ = file;
		_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error0_);
		in_stream = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp5_ = in_stream;
		_tmp6_ = gdk_pixbuf_new_from_stream ((GInputStream*) _tmp5_, NULL, &_inner_error0_);
		pixbuf = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (in_stream);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp7_ = in_stream;
		g_input_stream_close ((GInputStream*) _tmp7_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (in_stream);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp9_ = pixbuf;
		if (gdk_pixbuf_get_width (_tmp9_) > MAIN_SIZE) {
			_tmp8_ = TRUE;
		} else {
			GdkPixbuf* _tmp10_;
			_tmp10_ = pixbuf;
			_tmp8_ = gdk_pixbuf_get_height (_tmp10_) > MAIN_SIZE;
		}
		if (_tmp8_) {
			Block10Data* _data10_;
			GdkPixbuf* _tmp11_;
			GtkRoot* _tmp12_;
			ContactsCropDialog* _tmp13_;
			ContactsCropDialog* _tmp14_;
			ContactsCropDialog* _tmp15_;
			_data10_ = g_slice_new0 (Block10Data);
			_data10_->_ref_count_ = 1;
			_data10_->_data9_ = block9_data_ref (_data9_);
			_tmp11_ = pixbuf;
			_tmp12_ = gtk_widget_get_root ((GtkWidget*) self);
			_tmp13_ = contacts_crop_dialog_new_for_pixbuf (_tmp11_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp12_) : NULL);
			g_object_ref_sink (_tmp13_);
			_data10_->dialog = _tmp13_;
			_tmp14_ = _data10_->dialog;
			g_signal_connect_data ((GtkDialog*) _tmp14_, "response", (GCallback) _____lambda15__gtk_dialog_response, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
			_tmp15_ = _data10_->dialog;
			gtk_widget_show ((GtkWidget*) _tmp15_);
			block10_data_unref (_data10_);
			_data10_ = NULL;
		} else {
			GdkPixbuf* _tmp16_;
			_tmp16_ = pixbuf;
			contacts_avatar_selector_set_selected_avatar (self, _tmp16_);
			gtk_dialog_response ((GtkDialog*) self, (gint) GTK_RESPONSE_ACCEPT);
		}
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (in_stream);
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		AdwMessageDialog* dialog = NULL;
		GtkRoot* _tmp19_;
		AdwMessageDialog* _tmp20_;
		AdwMessageDialog* _tmp21_;
		AdwMessageDialog* _tmp22_;
		AdwMessageDialog* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("contacts-avatar-selector.vala:234: Failed to set avatar: %s", _tmp18_);
		_tmp19_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp20_ = (AdwMessageDialog*) adw_message_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp19_) : NULL, NULL, _ ("Failed to set avatar."));
		g_object_ref_sink (_tmp20_);
		dialog = _tmp20_;
		_tmp21_ = dialog;
		adw_message_dialog_add_response (_tmp21_, "close", _ ("_Close"));
		_tmp22_ = dialog;
		adw_message_dialog_set_default_response (_tmp22_, "close");
		_tmp23_ = dialog;
		gtk_widget_show ((GtkWidget*) _tmp23_);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		GtkFileChooserNative* _tmp24_;
		_tmp24_ = _data9_->chooser;
		gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp24_);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda14__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	__lambda14_ (self, response_id);
}

static void
contacts_avatar_selector_on_file_clicked (ContactsAvatarSelector* self,
                                          GtkButton* button)
{
	Block9Data* _data9_;
	GtkRoot* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	GtkFileChooserNative* _tmp11_;
	GtkFileChooserNative* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp1_ = gtk_file_chooser_native_new (_ ("Browse for more pictures"), G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Open"), _ ("_Cancel"));
	_data9_->chooser = _tmp1_;
	_tmp2_ = _data9_->chooser;
	gtk_native_dialog_set_modal ((GtkNativeDialog*) _tmp2_, TRUE);
	{
		const gchar* pictures_folder = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
		pictures_folder = _tmp3_;
		_tmp4_ = pictures_folder;
		if (_tmp4_ != NULL) {
			GtkFileChooserNative* _tmp5_;
			const gchar* _tmp6_;
			GFile* _tmp7_;
			GFile* _tmp8_;
			_tmp5_ = _data9_->chooser;
			_tmp6_ = pictures_folder;
			_tmp7_ = g_file_new_for_path (_tmp6_);
			_tmp8_ = _tmp7_;
			gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp5_, _tmp8_, &_inner_error0_);
			_g_object_unref0 (_tmp8_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("contacts-avatar-selector.vala:204: Couldn't set avatar selector to Pic" \
"tures folder: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block9_data_unref (_data9_);
		_data9_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp11_ = _data9_->chooser;
	g_signal_connect_data ((GtkNativeDialog*) _tmp11_, "response", (GCallback) ___lambda14__gtk_native_dialog_response, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp12_ = _data9_->chooser;
	gtk_native_dialog_show ((GtkNativeDialog*) _tmp12_);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static void
_contacts_avatar_selector_on_file_clicked_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	contacts_avatar_selector_on_file_clicked ((ContactsAvatarSelector*) self, _sender);
}

ContactsContact*
contacts_avatar_selector_get_contact (ContactsAvatarSelector* self)
{
	ContactsContact* result;
	ContactsContact* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_contact;
	result = _tmp0_;
	return result;
}

void
contacts_avatar_selector_set_contact (ContactsAvatarSelector* self,
                                      ContactsContact* value)
{
	ContactsContact* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_avatar_selector_get_contact (self);
	if (old_value != value) {
		self->priv->_contact = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_avatar_selector_properties[CONTACTS_AVATAR_SELECTOR_CONTACT_PROPERTY]);
	}
}

GdkPixbuf*
contacts_avatar_selector_get_selected_avatar (ContactsAvatarSelector* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_avatar;
	_tmp1_ = contacts_avatar_selector_scale_pixbuf_for_avatar_use (self, _tmp0_);
	result = _tmp1_;
	return result;
}

static void
contacts_avatar_selector_set_selected_avatar (ContactsAvatarSelector* self,
                                              GdkPixbuf* value)
{
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_selected_avatar);
	self->priv->_selected_avatar = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, contacts_avatar_selector_properties[CONTACTS_AVATAR_SELECTOR_SELECTED_AVATAR_PROPERTY]);
}

static void
contacts_avatar_selector_class_init (ContactsAvatarSelectorClass * klass,
                                     gpointer klass_data)
{
	contacts_avatar_selector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsAvatarSelector_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_avatar_selector_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_avatar_selector_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_avatar_selector_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_AVATAR_SELECTOR_CONTACT_PROPERTY, contacts_avatar_selector_properties[CONTACTS_AVATAR_SELECTOR_CONTACT_PROPERTY] = g_param_spec_object ("contact", "contact", "contact", CONTACTS_TYPE_CONTACT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_AVATAR_SELECTOR_SELECTED_AVATAR_PROPERTY, contacts_avatar_selector_properties[CONTACTS_AVATAR_SELECTOR_SELECTED_AVATAR_PROPERTY] = g_param_spec_object ("selected-avatar", "selected-avatar", "selected-avatar", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-avatar-selector.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "thumbnail_grid", FALSE, ContactsAvatarSelector_private_offset + G_STRUCT_OFFSET (ContactsAvatarSelectorPrivate, thumbnail_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "camera_button", FALSE, ContactsAvatarSelector_private_offset + G_STRUCT_OFFSET (ContactsAvatarSelectorPrivate, camera_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_camera_button_clicked", G_CALLBACK(_contacts_avatar_selector_on_camera_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_file_clicked", G_CALLBACK(_contacts_avatar_selector_on_file_clicked_gtk_button_clicked));
}

static void
contacts_avatar_selector_instance_init (ContactsAvatarSelector * self,
                                        gpointer klass)
{
	self->priv = contacts_avatar_selector_get_instance_private (self);
	self->priv->portal = NULL;
	self->priv->_selected_avatar = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_avatar_selector_finalize (GObject * obj)
{
	ContactsAvatarSelector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelector);
	_g_object_unref0 (self->priv->portal);
	_g_object_unref0 (self->priv->_selected_avatar);
	G_OBJECT_CLASS (contacts_avatar_selector_parent_class)->finalize (obj);
}

/**
 * The AvatarSelector can be used to choose the avatar for a contact.
 * This can be done by either choosing a stock thumbnail, an image file
 * provided by the user, or by using a webcam.
 *
 * After a user has initially chosen an avatar, we provide a cropping tool.
 */
 G_GNUC_NO_INLINE static GType
contacts_avatar_selector_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsAvatarSelectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_avatar_selector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAvatarSelector), 0, (GInstanceInitFunc) contacts_avatar_selector_instance_init, NULL };
	GType contacts_avatar_selector_type_id;
	contacts_avatar_selector_type_id = g_type_register_static (gtk_dialog_get_type (), "ContactsAvatarSelector", &g_define_type_info, 0);
	ContactsAvatarSelector_private_offset = g_type_add_instance_private (contacts_avatar_selector_type_id, sizeof (ContactsAvatarSelectorPrivate));
	return contacts_avatar_selector_type_id;
}

GType
contacts_avatar_selector_get_type (void)
{
	static volatile gsize contacts_avatar_selector_type_id__once = 0;
	if (g_once_init_enter (&contacts_avatar_selector_type_id__once)) {
		GType contacts_avatar_selector_type_id;
		contacts_avatar_selector_type_id = contacts_avatar_selector_get_type_once ();
		g_once_init_leave (&contacts_avatar_selector_type_id__once, contacts_avatar_selector_type_id);
	}
	return contacts_avatar_selector_type_id__once;
}

static void
_vala_contacts_avatar_selector_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ContactsAvatarSelector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelector);
	switch (property_id) {
		case CONTACTS_AVATAR_SELECTOR_CONTACT_PROPERTY:
		g_value_set_object (value, contacts_avatar_selector_get_contact (self));
		break;
		case CONTACTS_AVATAR_SELECTOR_SELECTED_AVATAR_PROPERTY:
		g_value_take_object (value, contacts_avatar_selector_get_selected_avatar (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_avatar_selector_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	ContactsAvatarSelector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelector);
	switch (property_id) {
		case CONTACTS_AVATAR_SELECTOR_CONTACT_PROPERTY:
		contacts_avatar_selector_set_contact (self, g_value_get_object (value));
		break;
		case CONTACTS_AVATAR_SELECTOR_SELECTED_AVATAR_PROPERTY:
		contacts_avatar_selector_set_selected_avatar (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

