/* contacts-contact-pane.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-contact-pane.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <adwaita.h>
#include <glib-object.h>
#include "contacts.h"
#include "contactscore.h"
#include <gtk/gtk.h>
#include <folks/folks.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define PROFILE_SIZE 128
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;
typedef struct _ContactsContactPanePrivate ContactsContactPanePrivate;

#define CONTACTS_TYPE_CONTACT_SHEET (contacts_contact_sheet_get_type ())
#define CONTACTS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheet))
#define CONTACTS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))
#define CONTACTS_IS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_IS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_CONTACT_SHEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))

typedef struct _ContactsContactSheet ContactsContactSheet;
typedef struct _ContactsContactSheetClass ContactsContactSheetClass;

#define CONTACTS_TYPE_CONTACT_EDITOR (contacts_contact_editor_get_type ())
#define CONTACTS_CONTACT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditor))
#define CONTACTS_CONTACT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditorClass))
#define CONTACTS_IS_CONTACT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_EDITOR))
#define CONTACTS_IS_CONTACT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_EDITOR))
#define CONTACTS_CONTACT_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditorClass))

typedef struct _ContactsContactEditor ContactsContactEditor;
typedef struct _ContactsContactEditorClass ContactsContactEditorClass;

#define CONTACTS_TYPE_LINK_SUGGESTION_GRID (contacts_link_suggestion_grid_get_type ())
#define CONTACTS_LINK_SUGGESTION_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LINK_SUGGESTION_GRID, ContactsLinkSuggestionGrid))
#define CONTACTS_LINK_SUGGESTION_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LINK_SUGGESTION_GRID, ContactsLinkSuggestionGridClass))
#define CONTACTS_IS_LINK_SUGGESTION_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LINK_SUGGESTION_GRID))
#define CONTACTS_IS_LINK_SUGGESTION_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LINK_SUGGESTION_GRID))
#define CONTACTS_LINK_SUGGESTION_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LINK_SUGGESTION_GRID, ContactsLinkSuggestionGridClass))

typedef struct _ContactsLinkSuggestionGrid ContactsLinkSuggestionGrid;
typedef struct _ContactsLinkSuggestionGridClass ContactsLinkSuggestionGridClass;
enum  {
	CONTACTS_CONTACT_PANE_0_PROPERTY,
	CONTACTS_CONTACT_PANE_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_pane_properties[CONTACTS_CONTACT_PANE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_MAIN_WINDOW (contacts_main_window_get_type ())
#define CONTACTS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow))
#define CONTACTS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))
#define CONTACTS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))

typedef struct _ContactsMainWindow ContactsMainWindow;
typedef struct _ContactsMainWindowClass ContactsMainWindowClass;
typedef struct _Block18Data Block18Data;
typedef struct _Block19Data Block19Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ContactsContactPaneApplyChangesData ContactsContactPaneApplyChangesData;
enum  {
	CONTACTS_CONTACT_PANE_CONTACTS_LINKED_SIGNAL,
	CONTACTS_CONTACT_PANE_NUM_SIGNALS
};
static guint contacts_contact_pane_signals[CONTACTS_CONTACT_PANE_NUM_SIGNALS] = {0};

struct _ContactsContactPane {
	AdwBin parent_instance;
	ContactsContactPanePrivate * priv;
	gboolean on_edit_mode;
};

struct _ContactsContactPaneClass {
	AdwBinClass parent_class;
};

struct _ContactsContactPanePrivate {
	ContactsStore* store;
	ContactsContact* contact;
	GtkStack* stack;
	AdwClamp* contact_sheet_clamp;
	ContactsContactSheet* sheet;
	GtkBox* contact_editor_box;
	ContactsContactEditor* editor;
	ContactsLinkSuggestionGrid* suggestion_grid;
};

struct _Block18Data {
	int _ref_count_;
	ContactsContactPane* self;
	FolksIndividual* individual;
	FolksIndividual* other;
};

struct _Block19Data {
	int _ref_count_;
	ContactsContactPane* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _ContactsContactPaneApplyChangesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsContactPane* self;
	ContactsContact* contact;
	ContactsStore* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	Block19Data* _data19_;
	gulong signal_id;
	ContactsStore* _tmp5_;
	gulong _tmp6_;
	ContactsStore* _tmp7_;
	FolksIndividualAggregator* _tmp8_;
	FolksIndividualAggregator* _tmp9_;
	FolksPersonaStore* _tmp10_;
	FolksPersonaStore* _tmp11_;
	GError* err;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_;
};

static gint ContactsContactPane_private_offset;
static gpointer contacts_contact_pane_parent_class = NULL;

VALA_EXTERN GType contacts_contact_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactPane, g_object_unref)
VALA_EXTERN GType contacts_contact_sheet_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSheet, g_object_unref)
VALA_EXTERN GType contacts_contact_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactEditor, g_object_unref)
VALA_EXTERN GType contacts_link_suggestion_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsLinkSuggestionGrid, g_object_unref)
VALA_EXTERN GType contacts_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsMainWindow, g_object_unref)
VALA_EXTERN ContactsContactPane* contacts_contact_pane_new (ContactsMainWindow* main_window,
                                                ContactsStore* contacts_store);
VALA_EXTERN ContactsContactPane* contacts_contact_pane_construct (GType object_type,
                                                      ContactsMainWindow* main_window,
                                                      ContactsStore* contacts_store);
VALA_EXTERN void contacts_contact_pane_add_suggestion (ContactsContactPane* self,
                                           FolksIndividual* individual,
                                           FolksIndividual* other);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void contacts_contact_pane_remove_suggestion_grid (ContactsContactPane* self);
VALA_EXTERN ContactsLinkSuggestionGrid* contacts_link_suggestion_grid_new (FolksIndividual* individual);
VALA_EXTERN ContactsLinkSuggestionGrid* contacts_link_suggestion_grid_construct (GType object_type,
                                                                     FolksIndividual* individual);
static void __lambda27_ (Block18Data* _data18_);
static void ___lambda27__contacts_link_suggestion_grid_suggestion_accepted (ContactsLinkSuggestionGrid* _sender,
                                                                     gpointer self);
static void __lambda28_ (Block18Data* _data18_);
static void ___lambda28__contacts_link_suggestion_grid_suggestion_rejected (ContactsLinkSuggestionGrid* _sender,
                                                                     gpointer self);
VALA_EXTERN void contacts_contact_pane_show_contact (ContactsContactPane* self,
                                         FolksIndividual* individual);
static void contacts_contact_pane_remove_contact_sheet (ContactsContactPane* self);
static void contacts_contact_pane_show_contact_sheet (ContactsContactPane* self,
                                               ContactsContact* contact);
VALA_EXTERN ContactsContactSheet* contacts_contact_sheet_new (ContactsContact* contact);
VALA_EXTERN ContactsContactSheet* contacts_contact_sheet_construct (GType object_type,
                                                        ContactsContact* contact);
static void contacts_contact_pane_create_contact_editor (ContactsContactPane* self);
static void contacts_contact_pane_remove_contact_editor (ContactsContactPane* self);
VALA_EXTERN ContactsContactEditor* contacts_contact_editor_new (ContactsContact* contact);
VALA_EXTERN ContactsContactEditor* contacts_contact_editor_construct (GType object_type,
                                                          ContactsContact* contact);
VALA_EXTERN void contacts_contact_pane_stop_editing (ContactsContactPane* self,
                                         gboolean cancel);
static void contacts_contact_pane_apply_changes (ContactsContactPane* self,
                                          ContactsContact* contact,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void contacts_contact_pane_apply_changes_finish (ContactsContactPane* self,
                                                 GAsyncResult* _res_);
static void contacts_contact_pane_apply_changes_data_free (gpointer _data);
static gboolean contacts_contact_pane_apply_changes_co (ContactsContactPaneApplyChangesData* _data_);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static gboolean _contacts_contact_pane_apply_changes_co_gsource_func (gpointer self);
static void ___lambda29_ (Block19Data* _data19_);
static void ____lambda29__contacts_store_quiescent (ContactsStore* _sender,
                                             gpointer self);
static void contacts_contact_pane_apply_changes_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
VALA_EXTERN void contacts_contact_pane_edit_contact (ContactsContactPane* self);
VALA_EXTERN void contacts_contact_pane_new_contact (ContactsContactPane* self);
static void contacts_contact_pane_finalize (GObject * obj);
static GType contacts_contact_pane_get_type_once (void);

static inline gpointer
contacts_contact_pane_get_instance_private (ContactsContactPane* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactPane_private_offset);
}

ContactsContactPane*
contacts_contact_pane_construct (GType object_type,
                                 ContactsMainWindow* main_window,
                                 ContactsStore* contacts_store)
{
	ContactsContactPane * self = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (contacts_store != NULL, NULL);
	self = (ContactsContactPane*) g_object_new (object_type, NULL);
	self->priv->store = contacts_store;
	return self;
}

ContactsContactPane*
contacts_contact_pane_new (ContactsMainWindow* main_window,
                           ContactsStore* contacts_store)
{
	return contacts_contact_pane_construct (CONTACTS_TYPE_CONTACT_PANE, main_window, contacts_store);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		ContactsContactPane* self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->individual);
		_g_object_unref0 (_data18_->other);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
__lambda27_ (Block18Data* _data18_)
{
	ContactsContactPane* self;
	GeeLinkedList* to_link = NULL;
	GeeLinkedList* _tmp0_;
	ContactsLinkOperation* operation = NULL;
	ContactsStore* _tmp1_;
	ContactsLinkOperation* _tmp2_;
	self = _data18_->self;
	_tmp0_ = gee_linked_list_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	to_link = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) to_link, _data18_->individual);
	gee_abstract_collection_add ((GeeAbstractCollection*) to_link, _data18_->other);
	_tmp1_ = self->priv->store;
	_tmp2_ = contacts_link_operation_new (_tmp1_, to_link);
	operation = _tmp2_;
	g_signal_emit (self, contacts_contact_pane_signals[CONTACTS_CONTACT_PANE_CONTACTS_LINKED_SIGNAL], 0, operation);
	contacts_contact_pane_remove_suggestion_grid (self);
	_g_object_unref0 (operation);
	_g_object_unref0 (to_link);
}

static void
___lambda27__contacts_link_suggestion_grid_suggestion_accepted (ContactsLinkSuggestionGrid* _sender,
                                                                gpointer self)
{
	__lambda27_ (self);
}

static void
__lambda28_ (Block18Data* _data18_)
{
	ContactsContactPane* self;
	ContactsStore* _tmp0_;
	self = _data18_->self;
	_tmp0_ = self->priv->store;
	contacts_store_add_no_suggest_link (_tmp0_, _data18_->individual, _data18_->other);
	contacts_contact_pane_remove_suggestion_grid (self);
}

static void
___lambda28__contacts_link_suggestion_grid_suggestion_rejected (ContactsLinkSuggestionGrid* _sender,
                                                                gpointer self)
{
	__lambda28_ (self);
}

void
contacts_contact_pane_add_suggestion (ContactsContactPane* self,
                                      FolksIndividual* individual,
                                      FolksIndividual* other)
{
	Block18Data* _data18_;
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	GtkOverlay* parent_overlay = NULL;
	GtkWidget* _tmp2_;
	ContactsLinkSuggestionGrid* _tmp3_;
	ContactsLinkSuggestionGrid* _tmp4_;
	ContactsLinkSuggestionGrid* _tmp5_;
	ContactsLinkSuggestionGrid* _tmp6_;
	ContactsLinkSuggestionGrid* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	g_return_if_fail (other != NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (individual);
	_g_object_unref0 (_data18_->individual);
	_data18_->individual = _tmp0_;
	_tmp1_ = _g_object_ref0 (other);
	_g_object_unref0 (_data18_->other);
	_data18_->other = _tmp1_;
	_tmp2_ = gtk_widget_get_parent ((GtkWidget*) self);
	parent_overlay = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_overlay_get_type ()) ? ((GtkOverlay*) _tmp2_) : NULL;
	contacts_contact_pane_remove_suggestion_grid (self);
	_tmp3_ = contacts_link_suggestion_grid_new (_data18_->other);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->suggestion_grid);
	self->priv->suggestion_grid = _tmp3_;
	_tmp4_ = self->priv->suggestion_grid;
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_END);
	_tmp5_ = self->priv->suggestion_grid;
	gtk_overlay_add_overlay (parent_overlay, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->suggestion_grid;
	g_signal_connect_data (_tmp6_, "suggestion-accepted", (GCallback) ___lambda27__contacts_link_suggestion_grid_suggestion_accepted, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	_tmp7_ = self->priv->suggestion_grid;
	g_signal_connect_data (_tmp7_, "suggestion-rejected", (GCallback) ___lambda28__contacts_link_suggestion_grid_suggestion_rejected, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	block18_data_unref (_data18_);
	_data18_ = NULL;
}

void
contacts_contact_pane_show_contact (ContactsContactPane* self,
                                    FolksIndividual* individual)
{
	gboolean _tmp1_ = FALSE;
	ContactsContact* _tmp2_;
	ContactsContact* _tmp7_;
	g_return_if_fail (self != NULL);
	if (individual == NULL) {
		GtkStack* _tmp0_;
		_g_object_unref0 (self->priv->contact);
		self->priv->contact = NULL;
		contacts_contact_pane_remove_contact_sheet (self);
		_tmp0_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp0_, "none-selected-page");
		return;
	}
	_tmp2_ = self->priv->contact;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ContactsContact* _tmp3_;
		FolksIndividual* _tmp4_;
		FolksIndividual* _tmp5_;
		_tmp3_ = self->priv->contact;
		_tmp4_ = contacts_contact_get_individual (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ != individual;
	}
	if (_tmp1_) {
		ContactsContact* _tmp6_;
		_tmp6_ = contacts_contact_new_for_individual (individual);
		_g_object_unref0 (self->priv->contact);
		self->priv->contact = _tmp6_;
	}
	_tmp7_ = self->priv->contact;
	contacts_contact_pane_show_contact_sheet (self, _tmp7_);
}

static void
contacts_contact_pane_show_contact_sheet (ContactsContactPane* self,
                                          ContactsContact* contact)
{
	ContactsContactSheet* contacts_sheet = NULL;
	ContactsContactSheet* _tmp0_;
	ContactsContactSheet* _tmp1_;
	ContactsContactSheet* _tmp2_;
	AdwClamp* _tmp3_;
	ContactsContactSheet* _tmp4_;
	GtkStack* _tmp5_;
	FolksIndividual* _tmp6_;
	FolksIndividual* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (contact != NULL);
	contacts_contact_pane_remove_contact_sheet (self);
	_tmp0_ = contacts_contact_sheet_new (contact);
	g_object_ref_sink (_tmp0_);
	contacts_sheet = _tmp0_;
	_tmp1_ = contacts_sheet;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = contacts_sheet;
	self->priv->sheet = _tmp2_;
	_tmp3_ = self->priv->contact_sheet_clamp;
	_tmp4_ = self->priv->sheet;
	adw_clamp_set_child (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp5_, "contact-sheet-page");
	_tmp6_ = contacts_contact_get_individual (contact);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GeeMap* matches = NULL;
		ContactsStore* _tmp8_;
		FolksIndividualAggregator* _tmp9_;
		FolksIndividualAggregator* _tmp10_;
		FolksIndividual* _tmp11_;
		FolksIndividual* _tmp12_;
		GeeMap* _tmp13_;
		_tmp8_ = self->priv->store;
		_tmp9_ = contacts_store_get_aggregator (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = contacts_contact_get_individual (contact);
		_tmp12_ = _tmp11_;
		_tmp13_ = folks_individual_aggregator_get_potential_matches (_tmp10_, _tmp12_, FOLKS_MATCH_RESULT_HIGH);
		matches = _tmp13_;
		{
			GeeIterator* _i_it = NULL;
			GeeMap* _tmp14_;
			GeeSet* _tmp15_;
			GeeSet* _tmp16_;
			GeeSet* _tmp17_;
			GeeIterator* _tmp18_;
			GeeIterator* _tmp19_;
			_tmp14_ = matches;
			_tmp15_ = gee_map_get_keys (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_;
			_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
			_tmp19_ = _tmp18_;
			_g_object_unref0 (_tmp17_);
			_i_it = _tmp19_;
			while (TRUE) {
				GeeIterator* _tmp20_;
				FolksIndividual* i = NULL;
				GeeIterator* _tmp21_;
				gpointer _tmp22_;
				gboolean _tmp23_ = FALSE;
				FolksIndividual* _tmp24_;
				_tmp20_ = _i_it;
				if (!gee_iterator_next (_tmp20_)) {
					break;
				}
				_tmp21_ = _i_it;
				_tmp22_ = gee_iterator_get (_tmp21_);
				i = (FolksIndividual*) _tmp22_;
				_tmp24_ = i;
				if (_tmp24_ != NULL) {
					ContactsStore* _tmp25_;
					FolksIndividual* _tmp26_;
					FolksIndividual* _tmp27_;
					FolksIndividual* _tmp28_;
					_tmp25_ = self->priv->store;
					_tmp26_ = contacts_contact_get_individual (contact);
					_tmp27_ = _tmp26_;
					_tmp28_ = i;
					_tmp23_ = contacts_store_suggest_link_to (_tmp25_, _tmp27_, _tmp28_);
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					FolksIndividual* _tmp29_;
					FolksIndividual* _tmp30_;
					FolksIndividual* _tmp31_;
					_tmp29_ = contacts_contact_get_individual (contact);
					_tmp30_ = _tmp29_;
					_tmp31_ = i;
					contacts_contact_pane_add_suggestion (self, _tmp30_, _tmp31_);
					_g_object_unref0 (i);
					break;
				}
				_g_object_unref0 (i);
			}
			_g_object_unref0 (_i_it);
		}
		_g_object_unref0 (matches);
	}
	_g_object_unref0 (contacts_sheet);
}

static void
contacts_contact_pane_remove_contact_sheet (ContactsContactPane* self)
{
	ContactsContactSheet* _tmp0_;
	AdwClamp* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sheet;
	if (_tmp0_ == NULL) {
		return;
	}
	contacts_contact_pane_remove_suggestion_grid (self);
	_tmp1_ = self->priv->contact_sheet_clamp;
	adw_clamp_set_child (_tmp1_, NULL);
	self->priv->sheet = NULL;
}

static void
contacts_contact_pane_create_contact_editor (ContactsContactPane* self)
{
	ContactsContact* _tmp0_;
	ContactsContactEditor* contact_editor = NULL;
	ContactsContact* _tmp1_;
	ContactsContactEditor* _tmp2_;
	GtkBox* _tmp3_;
	ContactsContactEditor* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contact;
	g_return_if_fail (_tmp0_ != NULL);
	contacts_contact_pane_remove_contact_editor (self);
	_tmp1_ = self->priv->contact;
	_tmp2_ = contacts_contact_editor_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	contact_editor = _tmp2_;
	gtk_widget_set_hexpand ((GtkWidget*) contact_editor, TRUE);
	self->priv->editor = contact_editor;
	_tmp3_ = self->priv->contact_editor_box;
	_tmp4_ = self->priv->editor;
	gtk_box_append (_tmp3_, (GtkWidget*) _tmp4_);
	_g_object_unref0 (contact_editor);
}

static void
contacts_contact_pane_remove_contact_editor (ContactsContactPane* self)
{
	ContactsContactEditor* _tmp0_;
	GtkBox* _tmp1_;
	ContactsContactEditor* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->editor;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->contact_editor_box;
	_tmp2_ = self->priv->editor;
	gtk_box_remove (_tmp1_, (GtkWidget*) _tmp2_);
	self->priv->editor = NULL;
}

void
contacts_contact_pane_stop_editing (ContactsContactPane* self,
                                    gboolean cancel)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->on_edit_mode);
	self->on_edit_mode = FALSE;
	contacts_contact_pane_remove_contact_editor (self);
	if (cancel) {
		ContactsContact* _tmp0_;
		_tmp0_ = self->priv->contact;
		if (_tmp0_ != NULL) {
			GtkStack* _tmp1_;
			_tmp1_ = self->priv->stack;
			gtk_stack_set_visible_child_name (_tmp1_, "contact-sheet-page");
		} else {
			GtkStack* _tmp2_;
			_tmp2_ = self->priv->stack;
			gtk_stack_set_visible_child_name (_tmp2_, "none-selected-page");
		}
	} else {
		ContactsContact* _tmp3_;
		_tmp3_ = self->priv->contact;
		contacts_contact_pane_apply_changes (self, _tmp3_, NULL, NULL);
	}
}

static void
contacts_contact_pane_apply_changes_data_free (gpointer _data)
{
	ContactsContactPaneApplyChangesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->contact);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsContactPaneApplyChangesData, _data_);
}

static void
contacts_contact_pane_apply_changes (ContactsContactPane* self,
                                     ContactsContact* contact,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ContactsContactPaneApplyChangesData* _data_;
	ContactsContactPane* _tmp0_;
	ContactsContact* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_data_ = g_slice_new0 (ContactsContactPaneApplyChangesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_contact_pane_apply_changes_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (contact);
	_g_object_unref0 (_data_->contact);
	_data_->contact = _tmp1_;
	contacts_contact_pane_apply_changes_co (_data_);
}

static void
contacts_contact_pane_apply_changes_finish (ContactsContactPane* self,
                                            GAsyncResult* _res_)
{
	ContactsContactPaneApplyChangesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		ContactsContactPane* self;
		self = _data19_->self;
		(_data19_->callback_target_destroy_notify == NULL) ? NULL : (_data19_->callback_target_destroy_notify (_data19_->callback_target), NULL);
		_data19_->callback = NULL;
		_data19_->callback_target = NULL;
		_data19_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static gboolean
_contacts_contact_pane_apply_changes_co_gsource_func (gpointer self)
{
	gboolean result;
	result = contacts_contact_pane_apply_changes_co (self);
	return result;
}

static void
___lambda29_ (Block19Data* _data19_)
{
	ContactsContactPane* self;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	self = _data19_->self;
	_tmp0_ = _data19_->callback;
	_tmp0__target = _data19_->callback_target;
	_tmp0_ (_tmp0__target);
}

static void
____lambda29__contacts_store_quiescent (ContactsStore* _sender,
                                        gpointer self)
{
	___lambda29_ (self);
}

static void
contacts_contact_pane_apply_changes_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	ContactsContactPaneApplyChangesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_contact_pane_apply_changes_co (_data_);
}

static gboolean
contacts_contact_pane_apply_changes_co (ContactsContactPaneApplyChangesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	contacts_contact_pane_show_contact_sheet (_data_->self, _data_->contact);
	_data_->_tmp0_ = _data_->self->priv->store;
	_data_->_tmp1_ = contacts_store_get_aggregator (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = folks_individual_aggregator_get_is_quiescent (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (!_data_->_tmp4_) {
		_data_->_data19_ = g_slice_new0 (Block19Data);
		_data_->_data19_->_ref_count_ = 1;
		_data_->_data19_->self = g_object_ref (_data_->self);
		_data_->_data19_->callback = _contacts_contact_pane_apply_changes_co_gsource_func;
		_data_->_data19_->callback_target = _data_;
		_data_->_data19_->callback_target_destroy_notify = NULL;
		_data_->_tmp5_ = _data_->self->priv->store;
		_data_->_tmp6_ = g_signal_connect_data (_data_->_tmp5_, "quiescent", (GCallback) ____lambda29__contacts_store_quiescent, block19_data_ref (_data_->_data19_), (GClosureNotify) block19_data_unref, 0);
		_data_->signal_id = _data_->_tmp6_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		g_signal_handler_disconnect ((GObject*) _data_->self, _data_->signal_id);
		block19_data_unref (_data_->_data19_);
		_data_->_data19_ = NULL;
	}
	{
		_data_->_tmp7_ = _data_->self->priv->store;
		_data_->_tmp8_ = contacts_store_get_aggregator (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = folks_individual_aggregator_get_primary_store (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_state_ = 2;
		contacts_contact_apply_changes (_data_->contact, _data_->_tmp11_, contacts_contact_pane_apply_changes_ready, _data_);
		return FALSE;
		_state_2:
		contacts_contact_apply_changes_finish (_data_->contact, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->err;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning ("contacts-contact-pane.vala:181: Couldn't save changes: %s", _data_->_tmp13_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	contacts_contact_pane_show_contact_sheet (_data_->self, _data_->contact);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
contacts_contact_pane_edit_contact (ContactsContactPane* self)
{
	ContactsContact* _tmp0_;
	GtkStack* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contact;
	g_return_if_fail (_tmp0_ != NULL);
	if (self->on_edit_mode) {
		return;
	}
	self->on_edit_mode = TRUE;
	contacts_contact_pane_create_contact_editor (self);
	_tmp1_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp1_, "contact-editor-page");
}

void
contacts_contact_pane_new_contact (ContactsContactPane* self)
{
	ContactsContact* _tmp0_;
	GtkStack* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = contacts_contact_new_empty ();
	_g_object_unref0 (self->priv->contact);
	self->priv->contact = _tmp0_;
	if (self->on_edit_mode) {
		return;
	}
	self->on_edit_mode = TRUE;
	contacts_contact_pane_create_contact_editor (self);
	_tmp1_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp1_, "contact-editor-page");
}

static void
contacts_contact_pane_remove_suggestion_grid (ContactsContactPane* self)
{
	ContactsLinkSuggestionGrid* _tmp0_;
	GtkOverlay* parent_overlay = NULL;
	GtkWidget* _tmp1_;
	GtkOverlay* _tmp2_;
	ContactsLinkSuggestionGrid* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->suggestion_grid;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) self);
	parent_overlay = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_overlay_get_type ()) ? ((GtkOverlay*) _tmp1_) : NULL;
	_tmp2_ = parent_overlay;
	_tmp3_ = self->priv->suggestion_grid;
	gtk_overlay_remove_overlay (_tmp2_, (GtkWidget*) _tmp3_);
	_g_object_unref0 (self->priv->suggestion_grid);
	self->priv->suggestion_grid = NULL;
}

static void
contacts_contact_pane_class_init (ContactsContactPaneClass * klass,
                                  gpointer klass_data)
{
	contacts_contact_pane_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactPane_private_offset);
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_pane_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-contact-pane.ui");
	contacts_contact_pane_signals[CONTACTS_CONTACT_PANE_CONTACTS_LINKED_SIGNAL] = g_signal_new ("contacts-linked", CONTACTS_TYPE_CONTACT_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_LINK_OPERATION);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ContactsContactPane_private_offset + G_STRUCT_OFFSET (ContactsContactPanePrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_sheet_clamp", FALSE, ContactsContactPane_private_offset + G_STRUCT_OFFSET (ContactsContactPanePrivate, contact_sheet_clamp));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_editor_box", FALSE, ContactsContactPane_private_offset + G_STRUCT_OFFSET (ContactsContactPanePrivate, contact_editor_box));
}

static void
contacts_contact_pane_instance_init (ContactsContactPane * self,
                                     gpointer klass)
{
	self->priv = contacts_contact_pane_get_instance_private (self);
	self->priv->contact = NULL;
	self->priv->sheet = NULL;
	self->priv->editor = NULL;
	self->on_edit_mode = FALSE;
	self->priv->suggestion_grid = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_contact_pane_finalize (GObject * obj)
{
	ContactsContactPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane);
	_g_object_unref0 (self->priv->contact);
	_g_object_unref0 (self->priv->suggestion_grid);
	G_OBJECT_CLASS (contacts_contact_pane_parent_class)->finalize (obj);
}

/**
 * The ContactPage is the right pane. It consists of 3 possible pages:
 * a page if nothing is selected, a ContactSheet to view contact information,
 * and a ContactEditor to edit contact information.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_pane_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactPaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactPane), 0, (GInstanceInitFunc) contacts_contact_pane_instance_init, NULL };
	GType contacts_contact_pane_type_id;
	contacts_contact_pane_type_id = g_type_register_static (adw_bin_get_type (), "ContactsContactPane", &g_define_type_info, 0);
	ContactsContactPane_private_offset = g_type_add_instance_private (contacts_contact_pane_type_id, sizeof (ContactsContactPanePrivate));
	return contacts_contact_pane_type_id;
}

GType
contacts_contact_pane_get_type (void)
{
	static volatile gsize contacts_contact_pane_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_pane_type_id__once)) {
		GType contacts_contact_pane_type_id;
		contacts_contact_pane_type_id = contacts_contact_pane_get_type_once ();
		g_once_init_leave (&contacts_contact_pane_type_id__once, contacts_contact_pane_type_id);
	}
	return contacts_contact_pane_type_id__once;
}

