/* contacts-contact-sheet.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-contact-sheet.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "contactscore.h"
#include <glib.h>
#include "contacts.h"
#include <gio/gio.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <adwaita.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define PROFILE_SIZE 128
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_CONTACT_SHEET (contacts_contact_sheet_get_type ())
#define CONTACTS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheet))
#define CONTACTS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))
#define CONTACTS_IS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_IS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_CONTACT_SHEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))

typedef struct _ContactsContactSheet ContactsContactSheet;
typedef struct _ContactsContactSheetClass ContactsContactSheetClass;
typedef struct _ContactsContactSheetPrivate ContactsContactSheetPrivate;
enum  {
	CONTACTS_CONTACT_SHEET_0_PROPERTY,
	CONTACTS_CONTACT_SHEET_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_sheet_properties[CONTACTS_CONTACT_SHEET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

#define CONTACTS_TYPE_AVATAR (contacts_avatar_get_type ())
#define CONTACTS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatar))
#define CONTACTS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))
#define CONTACTS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR))
#define CONTACTS_IS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR))
#define CONTACTS_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))

typedef struct _ContactsAvatar ContactsAvatar;
typedef struct _ContactsAvatarClass ContactsAvatarClass;

#define CONTACTS_TYPE_CONTACT_SHEET_GROUP (contacts_contact_sheet_group_get_type ())
#define CONTACTS_CONTACT_SHEET_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET_GROUP, ContactsContactSheetGroup))
#define CONTACTS_CONTACT_SHEET_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET_GROUP, ContactsContactSheetGroupClass))
#define CONTACTS_IS_CONTACT_SHEET_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET_GROUP))
#define CONTACTS_IS_CONTACT_SHEET_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET_GROUP))
#define CONTACTS_CONTACT_SHEET_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET_GROUP, ContactsContactSheetGroupClass))

typedef struct _ContactsContactSheetGroup ContactsContactSheetGroup;
typedef struct _ContactsContactSheetGroupClass ContactsContactSheetGroupClass;

#define CONTACTS_TYPE_CONTACT_SHEET_ROW (contacts_contact_sheet_row_get_type ())
#define CONTACTS_CONTACT_SHEET_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET_ROW, ContactsContactSheetRow))
#define CONTACTS_CONTACT_SHEET_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET_ROW, ContactsContactSheetRowClass))
#define CONTACTS_IS_CONTACT_SHEET_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET_ROW))
#define CONTACTS_IS_CONTACT_SHEET_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET_ROW))
#define CONTACTS_CONTACT_SHEET_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET_ROW, ContactsContactSheetRowClass))

typedef struct _ContactsContactSheetRow ContactsContactSheetRow;
typedef struct _ContactsContactSheetRowClass ContactsContactSheetRowClass;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;
typedef struct _ContactsContactSheetGroupPrivate ContactsContactSheetGroupPrivate;
enum  {
	CONTACTS_CONTACT_SHEET_GROUP_0_PROPERTY,
	CONTACTS_CONTACT_SHEET_GROUP_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_sheet_group_properties[CONTACTS_CONTACT_SHEET_GROUP_NUM_PROPERTIES];
typedef struct _ContactsContactSheetRowPrivate ContactsContactSheetRowPrivate;
enum  {
	CONTACTS_CONTACT_SHEET_ROW_0_PROPERTY,
	CONTACTS_CONTACT_SHEET_ROW_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_sheet_row_properties[CONTACTS_CONTACT_SHEET_ROW_NUM_PROPERTIES];

struct _ContactsContactSheet {
	GtkWidget parent_instance;
	ContactsContactSheetPrivate * priv;
};

struct _ContactsContactSheetClass {
	GtkWidgetClass parent_class;
};

struct _Block20Data {
	int _ref_count_;
	ContactsContactSheet* self;
	ContactsEmailAddress* email;
};

struct _Block21Data {
	int _ref_count_;
	ContactsContactSheet* self;
	ContactsUrl* url;
	GtkButton* button;
};

struct _Block22Data {
	int _ref_count_;
	ContactsContactSheet* self;
	ContactsAddress* address;
};

struct _Block23Data {
	int _ref_count_;
	Block22Data * _data22_;
	GtkButton* button;
};

struct _ContactsContactSheetGroup {
	AdwPreferencesGroup parent_instance;
	ContactsContactSheetGroupPrivate * priv;
};

struct _ContactsContactSheetGroupClass {
	AdwPreferencesGroupClass parent_class;
};

struct _ContactsContactSheetRow {
	AdwActionRow parent_instance;
	ContactsContactSheetRowPrivate * priv;
};

struct _ContactsContactSheetRowClass {
	AdwActionRowClass parent_class;
};

static gpointer contacts_contact_sheet_parent_class = NULL;
static gpointer contacts_contact_sheet_group_parent_class = NULL;
static gpointer contacts_contact_sheet_row_parent_class = NULL;

VALA_EXTERN GType contacts_contact_sheet_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSheet, g_object_unref)
VALA_EXTERN ContactsContactSheet* contacts_contact_sheet_new (ContactsContact* contact);
VALA_EXTERN ContactsContactSheet* contacts_contact_sheet_construct (GType object_type,
                                                        ContactsContact* contact);
static GtkWidget* contacts_contact_sheet_create_header (ContactsContactSheet* self,
                                                 ContactsContact* contact);
static void contacts_contact_sheet_on_model_items_changed (ContactsContactSheet* self,
                                                    GListModel* model,
                                                    guint position,
                                                    guint removed,
                                                    guint added);
static void _contacts_contact_sheet_on_model_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                                guint position,
                                                                                guint removed,
                                                                                guint added,
                                                                                gpointer self);
static void contacts_contact_sheet_real_dispose (GObject* base);
static GtkLabel* contacts_contact_sheet_create_persona_store_label (ContactsContactSheet* self,
                                                             FolksPersona* p);
static GtkWidget* contacts_contact_sheet_create_widget_for_chunk (ContactsContactSheet* self,
                                                           ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_birthday (ContactsContactSheet* self,
                                                              ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_emails (ContactsContactSheet* self,
                                                            ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_im_addresses (ContactsContactSheet* self,
                                                                  ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_nickname (ContactsContactSheet* self,
                                                              ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_notes (ContactsContactSheet* self,
                                                           ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_phone_nrs (ContactsContactSheet* self,
                                                               ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_postal_addresses (ContactsContactSheet* self,
                                                                      ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_roles (ContactsContactSheet* self,
                                                           ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_urls (ContactsContactSheet* self,
                                                          ContactsChunk* chunk);
VALA_EXTERN GType contacts_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatar, g_object_unref)
VALA_EXTERN ContactsAvatar* contacts_avatar_new_for_contact (gint size,
                                                 ContactsContact* contact);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct_for_contact (GType object_type,
                                                       gint size,
                                                       ContactsContact* contact);
VALA_EXTERN GType contacts_contact_sheet_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSheetGroup, g_object_unref)
VALA_EXTERN ContactsContactSheetGroup* contacts_contact_sheet_group_new (void);
VALA_EXTERN ContactsContactSheetGroup* contacts_contact_sheet_group_construct (GType object_type);
VALA_EXTERN GType contacts_contact_sheet_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSheetRow, g_object_unref)
VALA_EXTERN ContactsContactSheetRow* contacts_contact_sheet_row_new (const gchar* property_name,
                                                         const gchar* title,
                                                         const gchar* subtitle);
VALA_EXTERN ContactsContactSheetRow* contacts_contact_sheet_row_construct (GType object_type,
                                                               const gchar* property_name,
                                                               const gchar* title,
                                                               const gchar* subtitle);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
VALA_EXTERN GtkButton* contacts_contact_sheet_row_add_button (ContactsContactSheetRow* self,
                                                  const gchar* icon);
static void _____lambda11_ (Block20Data* _data20_);
static void ______lambda11__gtk_button_clicked (GtkButton* _sender,
                                         gpointer self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static void _____lambda13_ (Block21Data* _data21_);
static void ______lambda13__gtk_button_clicked (GtkButton* _sender,
                                         gpointer self);
VALA_EXTERN ContactsContactSheetGroup* contacts_contact_sheet_group_new_single_row (ContactsContactSheetRow* row);
VALA_EXTERN ContactsContactSheetGroup* contacts_contact_sheet_group_construct_single_row (GType object_type,
                                                                              ContactsContactSheetRow* row);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void ______lambda12_ (Block23Data* _data23_);
static void _______lambda12__gtk_button_clicked (GtkButton* _sender,
                                          gpointer self);
static GObject * contacts_contact_sheet_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static GType contacts_contact_sheet_get_type_once (void);
static GObject * contacts_contact_sheet_group_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static GType contacts_contact_sheet_group_get_type_once (void);
static GObject * contacts_contact_sheet_row_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static GType contacts_contact_sheet_row_get_type_once (void);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_contacts_contact_sheet_on_model_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                           guint position,
                                                                           guint removed,
                                                                           guint added,
                                                                           gpointer self)
{
	contacts_contact_sheet_on_model_items_changed ((ContactsContactSheet*) self, _sender, position, removed, added);
}

ContactsContactSheet*
contacts_contact_sheet_construct (GType object_type,
                                  ContactsContact* contact)
{
	ContactsContactSheet * self = NULL;
	ContactsChunkFilter* filter = NULL;
	ContactsChunkFilter* _tmp0_;
	ContactsPersonaFilter* _tmp1_;
	ContactsPersonaFilter* _tmp2_;
	GtkFilterListModel* filtered = NULL;
	GListModel* _tmp3_;
	GtkFilter* _tmp4_;
	GtkFilterListModel* _tmp5_;
	GtkSortListModel* contact_model = NULL;
	GListModel* _tmp6_;
	ContactsChunkSorter* _tmp7_;
	GtkSortListModel* _tmp8_;
	GtkWidget* header = NULL;
	GtkWidget* _tmp9_;
	g_return_val_if_fail (contact != NULL, NULL);
	self = (ContactsContactSheet*) g_object_new (object_type, NULL);
	_tmp0_ = contacts_chunk_filter_new ();
	filter = _tmp0_;
	_tmp1_ = contacts_persona_filter_new ();
	_tmp2_ = _tmp1_;
	contacts_chunk_filter_set_persona_filter (filter, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = _g_object_ref0 ((GListModel*) contact);
	_tmp4_ = _g_object_ref0 ((GtkFilter*) filter);
	_tmp5_ = gtk_filter_list_model_new (_tmp3_, _tmp4_);
	filtered = _tmp5_;
	_tmp6_ = _g_object_ref0 ((GListModel*) filtered);
	_tmp7_ = contacts_chunk_sorter_new ();
	_tmp8_ = gtk_sort_list_model_new (_tmp6_, (GtkSorter*) _tmp7_);
	contact_model = _tmp8_;
	_tmp9_ = contacts_contact_sheet_create_header (self, contact);
	header = _tmp9_;
	gtk_widget_set_parent (header, (GtkWidget*) self);
	g_signal_connect_object ((GListModel*) contact_model, "items-changed", (GCallback) _contacts_contact_sheet_on_model_items_changed_g_list_model_items_changed, self, 0);
	contacts_contact_sheet_on_model_items_changed (self, (GListModel*) contact_model, (guint) 0, (guint) 0, g_list_model_get_n_items ((GListModel*) contact_model));
	_g_object_unref0 (header);
	_g_object_unref0 (contact_model);
	_g_object_unref0 (filtered);
	_g_object_unref0 (filter);
	return self;
}

ContactsContactSheet*
contacts_contact_sheet_new (ContactsContact* contact)
{
	return contacts_contact_sheet_construct (CONTACTS_TYPE_CONTACT_SHEET, contact);
}

static void
contacts_contact_sheet_real_dispose (GObject* base)
{
	ContactsContactSheet * self;
	GtkWidget* child = NULL;
	self = (ContactsContactSheet*) base;
	child = NULL;
	while (TRUE) {
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
		child = _tmp0_;
		_tmp1_ = child;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = child;
		gtk_widget_unparent (_tmp2_);
	}
	G_OBJECT_CLASS (contacts_contact_sheet_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
contacts_contact_sheet_on_model_items_changed (ContactsContactSheet* self,
                                               GListModel* model,
                                               guint position,
                                               guint removed,
                                               guint added)
{
	GtkWidget* child = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	guint current_position = 0U;
	GtkWidget* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	child = _tmp0_;
	_tmp1_ = child;
	g_return_if_fail (_tmp1_ != NULL);
	current_position = (guint) 0;
	while (TRUE) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		guint _tmp6_;
		if (!(current_position < position)) {
			break;
		}
		_tmp2_ = child;
		_tmp3_ = gtk_widget_get_next_sibling (_tmp2_);
		child = _tmp3_;
		_tmp4_ = child;
		g_return_if_fail (_tmp4_ != NULL);
		_tmp5_ = child;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_label_get_type ())) {
			continue;
		}
		_tmp6_ = current_position;
		current_position = _tmp6_ + 1;
	}
	while (TRUE) {
		GtkWidget* to_remove = NULL;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		guint _tmp11_;
		if (!(removed != ((guint) 0))) {
			break;
		}
		_tmp7_ = child;
		_tmp8_ = gtk_widget_get_next_sibling (_tmp7_);
		to_remove = _tmp8_;
		_tmp9_ = to_remove;
		g_return_if_fail (_tmp9_ != NULL);
		_tmp10_ = to_remove;
		gtk_widget_unparent (_tmp10_);
		_tmp11_ = removed;
		removed = _tmp11_ - 1;
	}
	_tmp12_ = child;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_label_get_type ())) {
		GtkWidget* _tmp13_;
		GtkWidget* _tmp14_;
		GtkWidget* _tmp15_;
		GtkWidget* _tmp16_;
		_tmp13_ = child;
		_tmp14_ = gtk_widget_get_prev_sibling (_tmp13_);
		child = _tmp14_;
		_tmp15_ = child;
		_tmp16_ = gtk_widget_get_next_sibling (_tmp15_);
		gtk_widget_unparent (_tmp16_);
	}
	{
		guint i = 0U;
		i = position;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				ContactsChunk* chunk = NULL;
				GObject* _tmp19_;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				GtkWidget* new_child = NULL;
				ContactsChunk* _tmp40_;
				GtkWidget* _tmp41_;
				GtkWidget* _tmp42_;
				if (!_tmp17_) {
					guint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(i < (position + added))) {
					break;
				}
				_tmp19_ = g_list_model_get_item (model, i);
				chunk = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, CONTACTS_TYPE_CHUNK, ContactsChunk);
				if (i > ((guint) 0)) {
					ContactsChunk* _tmp22_;
					FolksPersona* _tmp23_;
					FolksPersona* _tmp24_;
					_tmp22_ = chunk;
					_tmp23_ = contacts_chunk_get_persona (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp21_ = _tmp24_ != NULL;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					GtkWidget* _tmp25_;
					_tmp25_ = child;
					_tmp20_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, gtk_label_get_type ());
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					ContactsChunk* prev = NULL;
					GObject* _tmp26_;
					ContactsChunk* _tmp27_;
					FolksPersona* _tmp28_;
					FolksPersona* _tmp29_;
					ContactsChunk* _tmp30_;
					FolksPersona* _tmp31_;
					FolksPersona* _tmp32_;
					_tmp26_ = g_list_model_get_item (model, i - 1);
					prev = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, CONTACTS_TYPE_CHUNK, ContactsChunk);
					_tmp27_ = prev;
					_tmp28_ = contacts_chunk_get_persona (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = chunk;
					_tmp31_ = contacts_chunk_get_persona (_tmp30_);
					_tmp32_ = _tmp31_;
					if (_tmp29_ != _tmp32_) {
						GtkLabel* label = NULL;
						ContactsChunk* _tmp33_;
						FolksPersona* _tmp34_;
						FolksPersona* _tmp35_;
						GtkLabel* _tmp36_;
						GtkLabel* _tmp37_;
						GtkWidget* _tmp38_;
						GtkLabel* _tmp39_;
						_tmp33_ = chunk;
						_tmp34_ = contacts_chunk_get_persona (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = contacts_contact_sheet_create_persona_store_label (self, _tmp35_);
						label = _tmp36_;
						_tmp37_ = label;
						_tmp38_ = child;
						gtk_widget_insert_after ((GtkWidget*) _tmp37_, (GtkWidget*) self, _tmp38_);
						_tmp39_ = label;
						child = (GtkWidget*) _tmp39_;
						_g_object_unref0 (label);
					}
					_g_object_unref0 (prev);
				}
				_tmp40_ = chunk;
				_tmp41_ = contacts_contact_sheet_create_widget_for_chunk (self, _tmp40_);
				new_child = _tmp41_;
				_tmp42_ = new_child;
				if (_tmp42_ != NULL) {
					GtkWidget* _tmp43_;
					GtkWidget* _tmp44_;
					GtkWidget* _tmp45_;
					_tmp43_ = new_child;
					_tmp44_ = child;
					gtk_widget_insert_after (_tmp43_, (GtkWidget*) self, _tmp44_);
					_tmp45_ = new_child;
					child = _tmp45_;
				}
				_g_object_unref0 (new_child);
				_g_object_unref0 (chunk);
			}
		}
	}
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_chunk (ContactsContactSheet* self,
                                                ContactsChunk* chunk)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	static GQuark _tmp3_label4 = 0;
	static GQuark _tmp3_label5 = 0;
	static GQuark _tmp3_label6 = 0;
	static GQuark _tmp3_label7 = 0;
	static GQuark _tmp3_label8 = 0;
	static GQuark _tmp3_label9 = 0;
	static GQuark _tmp3_label10 = 0;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_tmp0_ = contacts_chunk_get_property_name (chunk);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if ((_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("avatar")))) || (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("full-name"))))) {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("birthday")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp5_;
				_tmp5_ = contacts_contact_sheet_create_widget_for_birthday (self, chunk);
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("email-addresses")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp6_;
				_tmp6_ = contacts_contact_sheet_create_widget_for_emails (self, chunk);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label4) ? _tmp3_label4 : (_tmp3_label4 = g_quark_from_static_string ("im-addresses")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp7_;
				_tmp7_ = contacts_contact_sheet_create_widget_for_im_addresses (self, chunk);
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label5) ? _tmp3_label5 : (_tmp3_label5 = g_quark_from_static_string ("nickname")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp8_;
				_tmp8_ = contacts_contact_sheet_create_widget_for_nickname (self, chunk);
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label6) ? _tmp3_label6 : (_tmp3_label6 = g_quark_from_static_string ("notes")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp9_;
				_tmp9_ = contacts_contact_sheet_create_widget_for_notes (self, chunk);
				result = _tmp9_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label7) ? _tmp3_label7 : (_tmp3_label7 = g_quark_from_static_string ("phone-numbers")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp10_;
				_tmp10_ = contacts_contact_sheet_create_widget_for_phone_nrs (self, chunk);
				result = _tmp10_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label8) ? _tmp3_label8 : (_tmp3_label8 = g_quark_from_static_string ("postal-addresses")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp11_;
				_tmp11_ = contacts_contact_sheet_create_widget_for_postal_addresses (self, chunk);
				result = _tmp11_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label9) ? _tmp3_label9 : (_tmp3_label9 = g_quark_from_static_string ("roles")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp12_;
				_tmp12_ = contacts_contact_sheet_create_widget_for_roles (self, chunk);
				result = _tmp12_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label10) ? _tmp3_label10 : (_tmp3_label10 = g_quark_from_static_string ("urls")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp13_;
				_tmp13_ = contacts_contact_sheet_create_widget_for_urls (self, chunk);
				result = _tmp13_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = contacts_chunk_get_property_name (chunk);
				_tmp15_ = _tmp14_;
				g_debug ("contacts-contact-sheet.vala:139: Unsupported property: %s", _tmp15_);
				result = NULL;
				return result;
			}
		}
	}
}

static GtkLabel*
contacts_contact_sheet_create_persona_store_label (ContactsContactSheet* self,
                                                   FolksPersona* p)
{
	GtkLabel* store_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	PangoAttrList* attrList = NULL;
	PangoAttrList* _tmp4_;
	PangoAttribute* _tmp5_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = contacts_utils_format_persona_store_name_for_contact (p);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	store_name = _tmp3_;
	_tmp4_ = pango_attr_list_new ();
	attrList = _tmp4_;
	_tmp5_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (attrList, _tmp5_);
	gtk_label_set_attributes (store_name, attrList);
	gtk_widget_set_halign ((GtkWidget*) store_name, GTK_ALIGN_START);
	gtk_label_set_ellipsize (store_name, PANGO_ELLIPSIZE_MIDDLE);
	result = store_name;
	_pango_attr_list_unref0 (attrList);
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_header (ContactsContactSheet* self,
                                      ContactsContact* contact)
{
	GtkBox* header = NULL;
	GtkBox* _tmp0_;
	ContactsAvatar* image_frame = NULL;
	ContactsAvatar* _tmp1_;
	GtkLabel* name_label = NULL;
	GtkLabel* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 18);
	g_object_ref_sink (_tmp0_);
	header = _tmp0_;
	gtk_widget_add_css_class ((GtkWidget*) header, "contacts-sheet-header");
	_tmp1_ = contacts_avatar_new_for_contact (PROFILE_SIZE, contact);
	g_object_ref_sink (_tmp1_);
	image_frame = _tmp1_;
	gtk_widget_set_vexpand ((GtkWidget*) image_frame, FALSE);
	gtk_widget_set_valign ((GtkWidget*) image_frame, GTK_ALIGN_START);
	gtk_box_append (header, (GtkWidget*) image_frame);
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp2_);
	name_label = _tmp2_;
	_tmp3_ = contacts_contact_get_display_name (contact);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_label_set_label (name_label, _tmp5_);
	_g_free0 (_tmp5_);
	gtk_widget_set_hexpand ((GtkWidget*) name_label, TRUE);
	gtk_label_set_xalign (name_label, 0.f);
	gtk_label_set_wrap (name_label, TRUE);
	gtk_label_set_wrap_mode (name_label, PANGO_WRAP_WORD_CHAR);
	gtk_label_set_lines (name_label, 4);
	gtk_label_set_width_chars (name_label, 10);
	gtk_label_set_selectable (name_label, TRUE);
	gtk_widget_set_can_focus ((GtkWidget*) name_label, FALSE);
	gtk_widget_add_css_class ((GtkWidget*) name_label, "title-1");
	gtk_box_append (header, (GtkWidget*) name_label);
	result = (GtkWidget*) header;
	_g_object_unref0 (name_label);
	_g_object_unref0 (image_frame);
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_roles (ContactsContactSheet* self,
                                                ContactsChunk* chunk)
{
	ContactsRolesChunk* roles_chunk = NULL;
	ContactsRolesChunk* _tmp0_;
	ContactsContactSheetGroup* group = NULL;
	ContactsContactSheetGroup* _tmp1_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	roles_chunk = G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_ROLES_CHUNK) ? ((ContactsRolesChunk*) chunk) : NULL;
	_tmp0_ = roles_chunk;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = contacts_contact_sheet_group_new ();
	g_object_ref_sink (_tmp1_);
	group = _tmp1_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ContactsRolesChunk* _tmp4_;
				ContactsOrgRole* role = NULL;
				ContactsRolesChunk* _tmp5_;
				GObject* _tmp6_;
				ContactsOrgRole* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				ContactsContactSheetRow* row = NULL;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				ContactsOrgRole* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				ContactsContactSheetRow* _tmp15_;
				ContactsContactSheetRow* _tmp16_;
				ContactsContactSheetGroup* _tmp17_;
				ContactsContactSheetRow* _tmp18_;
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = roles_chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp4_))) {
					break;
				}
				_tmp5_ = roles_chunk;
				_tmp6_ = g_list_model_get_item ((GListModel*) _tmp5_, i);
				role = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CONTACTS_TYPE_ORG_ROLE, ContactsOrgRole);
				_tmp7_ = role;
				_tmp8_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_) {
					_g_object_unref0 (role);
					continue;
				}
				_tmp10_ = contacts_chunk_get_property_name (chunk);
				_tmp11_ = _tmp10_;
				_tmp12_ = role;
				_tmp13_ = contacts_org_role_to_string (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = contacts_contact_sheet_row_new (_tmp11_, _tmp14_, NULL);
				g_object_ref_sink (_tmp15_);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				row = _tmp16_;
				_tmp17_ = group;
				_tmp18_ = row;
				adw_preferences_group_add ((AdwPreferencesGroup*) _tmp17_, (GtkWidget*) _tmp18_);
				_g_object_unref0 (row);
				_g_object_unref0 (role);
			}
		}
	}
	result = (GtkWidget*) group;
	return result;
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->email);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static void
_____lambda11_ (Block20Data* _data20_)
{
	ContactsContactSheet* self;
	GtkWindow* window = NULL;
	GtkRoot* _tmp0_;
	ContactsEmailAddress* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = _data20_->self;
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL;
	_tmp1_ = _data20_->email;
	_tmp2_ = contacts_email_address_get_mailto_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_show_uri (window, _tmp3_, (guint32) 0);
	_g_free0 (_tmp3_);
}

static void
______lambda11__gtk_button_clicked (GtkButton* _sender,
                                    gpointer self)
{
	_____lambda11_ (self);
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_emails (ContactsContactSheet* self,
                                                 ContactsChunk* chunk)
{
	ContactsEmailAddressesChunk* emails_chunk = NULL;
	ContactsEmailAddressesChunk* _tmp0_;
	ContactsContactSheetGroup* group = NULL;
	ContactsContactSheetGroup* _tmp1_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	emails_chunk = G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_EMAIL_ADDRESSES_CHUNK) ? ((ContactsEmailAddressesChunk*) chunk) : NULL;
	_tmp0_ = emails_chunk;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = contacts_contact_sheet_group_new ();
	g_object_ref_sink (_tmp1_);
	group = _tmp1_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				Block20Data* _data20_;
				ContactsEmailAddressesChunk* _tmp4_;
				ContactsEmailAddressesChunk* _tmp5_;
				GObject* _tmp6_;
				ContactsEmailAddress* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				ContactsContactSheetRow* row = NULL;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				ContactsEmailAddress* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				ContactsEmailAddress* _tmp15_;
				ContactsTypeDescriptor* _tmp16_;
				ContactsTypeDescriptor* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				ContactsContactSheetRow* _tmp20_;
				ContactsContactSheetRow* _tmp21_;
				GtkButton* button = NULL;
				ContactsContactSheetRow* _tmp22_;
				GtkButton* _tmp23_;
				GtkButton* _tmp24_;
				ContactsEmailAddress* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				GtkButton* _tmp30_;
				ContactsContactSheetGroup* _tmp31_;
				ContactsContactSheetRow* _tmp32_;
				_data20_ = g_slice_new0 (Block20Data);
				_data20_->_ref_count_ = 1;
				_data20_->self = g_object_ref (self);
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = emails_chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp4_))) {
					block20_data_unref (_data20_);
					_data20_ = NULL;
					break;
				}
				_tmp5_ = emails_chunk;
				_tmp6_ = g_list_model_get_item ((GListModel*) _tmp5_, i);
				_data20_->email = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CONTACTS_TYPE_EMAIL_ADDRESS, ContactsEmailAddress);
				_tmp7_ = _data20_->email;
				_tmp8_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_) {
					block20_data_unref (_data20_);
					_data20_ = NULL;
					continue;
				}
				_tmp10_ = contacts_chunk_get_property_name (chunk);
				_tmp11_ = _tmp10_;
				_tmp12_ = _data20_->email;
				_tmp13_ = contacts_email_address_get_raw_address (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = _data20_->email;
				_tmp16_ = contacts_email_address_get_email_address_type (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = contacts_typedescriptor_get_display_name (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = contacts_contact_sheet_row_new (_tmp11_, _tmp14_, _tmp19_);
				g_object_ref_sink (_tmp20_);
				_tmp21_ = _tmp20_;
				_g_object_unref0 (_tmp17_);
				row = _tmp21_;
				_tmp22_ = row;
				_tmp23_ = contacts_contact_sheet_row_add_button (_tmp22_, "mail-send-symbolic");
				button = _tmp23_;
				_tmp24_ = button;
				_tmp25_ = _data20_->email;
				_tmp26_ = contacts_email_address_get_raw_address (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strdup_printf ("Send an email to %s", _tmp27_);
				_tmp29_ = _tmp28_;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp24_, _ (_tmp29_));
				_g_free0 (_tmp29_);
				_tmp30_ = button;
				g_signal_connect_data (_tmp30_, "clicked", (GCallback) ______lambda11__gtk_button_clicked, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
				_tmp31_ = group;
				_tmp32_ = row;
				adw_preferences_group_add ((AdwPreferencesGroup*) _tmp31_, (GtkWidget*) _tmp32_);
				_g_object_unref0 (button);
				_g_object_unref0 (row);
				block20_data_unref (_data20_);
				_data20_ = NULL;
			}
		}
	}
	result = (GtkWidget*) group;
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_phone_nrs (ContactsContactSheet* self,
                                                    ContactsChunk* chunk)
{
	ContactsPhonesChunk* phones_chunk = NULL;
	ContactsPhonesChunk* _tmp0_;
	ContactsContactSheetGroup* group = NULL;
	ContactsContactSheetGroup* _tmp1_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	phones_chunk = G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_PHONES_CHUNK) ? ((ContactsPhonesChunk*) chunk) : NULL;
	_tmp0_ = phones_chunk;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = contacts_contact_sheet_group_new ();
	g_object_ref_sink (_tmp1_);
	group = _tmp1_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ContactsPhonesChunk* _tmp4_;
				ContactsPhone* phone = NULL;
				ContactsPhonesChunk* _tmp5_;
				GObject* _tmp6_;
				ContactsPhone* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				ContactsContactSheetRow* row = NULL;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				ContactsPhone* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				ContactsPhone* _tmp15_;
				ContactsTypeDescriptor* _tmp16_;
				ContactsTypeDescriptor* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				ContactsContactSheetRow* _tmp20_;
				ContactsContactSheetRow* _tmp21_;
				ContactsContactSheetGroup* _tmp22_;
				ContactsContactSheetRow* _tmp23_;
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = phones_chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp4_))) {
					break;
				}
				_tmp5_ = phones_chunk;
				_tmp6_ = g_list_model_get_item ((GListModel*) _tmp5_, i);
				phone = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CONTACTS_TYPE_PHONE, ContactsPhone);
				_tmp7_ = phone;
				_tmp8_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_) {
					_g_object_unref0 (phone);
					continue;
				}
				_tmp10_ = contacts_chunk_get_property_name (chunk);
				_tmp11_ = _tmp10_;
				_tmp12_ = phone;
				_tmp13_ = contacts_phone_get_raw_number (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = phone;
				_tmp16_ = contacts_phone_get_phone_type (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = contacts_typedescriptor_get_display_name (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = contacts_contact_sheet_row_new (_tmp11_, _tmp14_, _tmp19_);
				g_object_ref_sink (_tmp20_);
				_tmp21_ = _tmp20_;
				_g_object_unref0 (_tmp17_);
				row = _tmp21_;
				_tmp22_ = group;
				_tmp23_ = row;
				adw_preferences_group_add ((AdwPreferencesGroup*) _tmp22_, (GtkWidget*) _tmp23_);
				_g_object_unref0 (row);
				_g_object_unref0 (phone);
			}
		}
	}
	result = (GtkWidget*) group;
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_im_addresses (ContactsContactSheet* self,
                                                       ContactsChunk* chunk)
{
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	result = NULL;
	return result;
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data21_->self;
		_g_object_unref0 (_data21_->button);
		_g_object_unref0 (_data21_->url);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static void
_____lambda13_ (Block21Data* _data21_)
{
	ContactsContactSheet* self;
	GtkWindow* window = NULL;
	GtkButton* _tmp0_;
	GtkRoot* _tmp1_;
	ContactsUrl* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self = _data21_->self;
	_tmp0_ = _data21_->button;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) _tmp0_);
	window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL;
	_tmp2_ = _data21_->url;
	_tmp3_ = contacts_url_get_absolute_url (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_show_uri (window, _tmp4_, (guint32) GDK_CURRENT_TIME);
	_g_free0 (_tmp4_);
}

static void
______lambda13__gtk_button_clicked (GtkButton* _sender,
                                    gpointer self)
{
	_____lambda13_ (self);
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_urls (ContactsContactSheet* self,
                                               ContactsChunk* chunk)
{
	ContactsUrlsChunk* urls_chunk = NULL;
	ContactsUrlsChunk* _tmp0_;
	ContactsContactSheetGroup* group = NULL;
	ContactsContactSheetGroup* _tmp1_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	urls_chunk = G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_URLS_CHUNK) ? ((ContactsUrlsChunk*) chunk) : NULL;
	_tmp0_ = urls_chunk;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = contacts_contact_sheet_group_new ();
	g_object_ref_sink (_tmp1_);
	group = _tmp1_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				Block21Data* _data21_;
				ContactsUrlsChunk* _tmp4_;
				ContactsUrlsChunk* _tmp5_;
				GObject* _tmp6_;
				ContactsUrl* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				ContactsContactSheetRow* row = NULL;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				ContactsUrl* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				ContactsContactSheetRow* _tmp15_;
				ContactsContactSheetRow* _tmp16_;
				GtkButton* _tmp17_;
				GtkButton* _tmp18_;
				GtkButton* _tmp19_;
				ContactsContactSheetGroup* _tmp20_;
				ContactsContactSheetRow* _tmp21_;
				_data21_ = g_slice_new0 (Block21Data);
				_data21_->_ref_count_ = 1;
				_data21_->self = g_object_ref (self);
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = urls_chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp4_))) {
					block21_data_unref (_data21_);
					_data21_ = NULL;
					break;
				}
				_tmp5_ = urls_chunk;
				_tmp6_ = g_list_model_get_item ((GListModel*) _tmp5_, i);
				_data21_->url = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CONTACTS_TYPE_URL, ContactsUrl);
				_tmp7_ = _data21_->url;
				_tmp8_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_) {
					block21_data_unref (_data21_);
					_data21_ = NULL;
					continue;
				}
				_tmp10_ = contacts_chunk_get_property_name (chunk);
				_tmp11_ = _tmp10_;
				_tmp12_ = _data21_->url;
				_tmp13_ = contacts_url_get_raw_url (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = contacts_contact_sheet_row_new (_tmp11_, _tmp14_, NULL);
				g_object_ref_sink (_tmp15_);
				row = _tmp15_;
				_tmp16_ = row;
				_tmp17_ = contacts_contact_sheet_row_add_button (_tmp16_, "external-link-symbolic");
				_data21_->button = _tmp17_;
				_tmp18_ = _data21_->button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp18_, _ ("Visit website"));
				_tmp19_ = _data21_->button;
				g_signal_connect_data (_tmp19_, "clicked", (GCallback) ______lambda13__gtk_button_clicked, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
				_tmp20_ = group;
				_tmp21_ = row;
				adw_preferences_group_add ((AdwPreferencesGroup*) _tmp20_, (GtkWidget*) _tmp21_);
				_g_object_unref0 (row);
				block21_data_unref (_data21_);
				_data21_ = NULL;
			}
		}
	}
	result = (GtkWidget*) group;
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_nickname (ContactsContactSheet* self,
                                                   ContactsChunk* chunk)
{
	ContactsNicknameChunk* nickname_chunk = NULL;
	gboolean _tmp0_ = FALSE;
	ContactsNicknameChunk* _tmp1_;
	ContactsContactSheetRow* row = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ContactsNicknameChunk* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ContactsContactSheetRow* _tmp10_;
	ContactsContactSheetGroup* _tmp11_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	nickname_chunk = G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_NICKNAME_CHUNK) ? ((ContactsNicknameChunk*) chunk) : NULL;
	_tmp1_ = nickname_chunk;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		ContactsNicknameChunk* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = nickname_chunk;
		_tmp3_ = contacts_nickname_chunk_get_nickname (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	}
	g_return_if_fail (_tmp0_);
	_tmp5_ = contacts_chunk_get_property_name (chunk);
	_tmp6_ = _tmp5_;
	_tmp7_ = nickname_chunk;
	_tmp8_ = contacts_nickname_chunk_get_nickname (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = contacts_contact_sheet_row_new (_tmp6_, _tmp9_, NULL);
	g_object_ref_sink (_tmp10_);
	row = _tmp10_;
	_tmp11_ = contacts_contact_sheet_group_new_single_row (row);
	g_object_ref_sink (_tmp11_);
	result = (GtkWidget*) _tmp11_;
	_g_object_unref0 (row);
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_birthday (ContactsContactSheet* self,
                                                   ContactsChunk* chunk)
{
	ContactsBirthdayChunk* birthday_chunk = NULL;
	gboolean _tmp0_ = FALSE;
	ContactsBirthdayChunk* _tmp1_;
	gchar* birthday_str = NULL;
	ContactsBirthdayChunk* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* subtitle = NULL;
	gint bd_m = 0;
	gint bd_d = 0;
	gint now_m = 0;
	gint now_d = 0;
	ContactsBirthdayChunk* _tmp12_;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	GDateTime* _tmp16_;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	GDateTime* _tmp19_;
	GDateTime* _tmp20_;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gboolean _tmp23_ = FALSE;
	ContactsContactSheetRow* row = NULL;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ContactsContactSheetRow* _tmp29_;
	ContactsContactSheetGroup* _tmp30_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	birthday_chunk = G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_BIRTHDAY_CHUNK) ? ((ContactsBirthdayChunk*) chunk) : NULL;
	_tmp1_ = birthday_chunk;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		ContactsBirthdayChunk* _tmp2_;
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		_tmp2_ = birthday_chunk;
		_tmp3_ = contacts_birthday_chunk_get_birthday (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	}
	g_return_if_fail (_tmp0_);
	_tmp5_ = birthday_chunk;
	_tmp6_ = contacts_birthday_chunk_get_birthday (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_date_time_to_local (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_date_time_format (_tmp9_, "%x");
	_tmp11_ = _tmp10_;
	_g_date_time_unref0 (_tmp9_);
	birthday_str = _tmp11_;
	subtitle = NULL;
	_tmp12_ = birthday_chunk;
	_tmp13_ = contacts_birthday_chunk_get_birthday (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_date_time_to_local (_tmp14_);
	_tmp16_ = _tmp15_;
	g_date_time_get_ymd (_tmp16_, NULL, &_tmp17_, &_tmp18_);
	bd_m = _tmp17_;
	bd_d = _tmp18_;
	_g_date_time_unref0 (_tmp16_);
	_tmp19_ = g_date_time_new_now_local ();
	_tmp20_ = _tmp19_;
	g_date_time_get_ymd (_tmp20_, NULL, &_tmp21_, &_tmp22_);
	now_m = _tmp21_;
	now_d = _tmp22_;
	_g_date_time_unref0 (_tmp20_);
	if (bd_m == now_m) {
		_tmp23_ = bd_d == now_d;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		gchar* _tmp24_;
		_tmp24_ = g_strdup (_ ("Their birthday is today! 🎉"));
		_g_free0 (subtitle);
		subtitle = _tmp24_;
	}
	_tmp25_ = contacts_chunk_get_property_name (chunk);
	_tmp26_ = _tmp25_;
	_tmp27_ = birthday_str;
	_tmp28_ = subtitle;
	_tmp29_ = contacts_contact_sheet_row_new (_tmp26_, _tmp27_, _tmp28_);
	g_object_ref_sink (_tmp29_);
	row = _tmp29_;
	_tmp30_ = contacts_contact_sheet_group_new_single_row (row);
	g_object_ref_sink (_tmp30_);
	result = (GtkWidget*) _tmp30_;
	_g_object_unref0 (row);
	_g_free0 (subtitle);
	_g_free0 (birthday_str);
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_notes (ContactsContactSheet* self,
                                                ContactsChunk* chunk)
{
	ContactsNotesChunk* notes_chunk = NULL;
	ContactsNotesChunk* _tmp0_;
	ContactsContactSheetGroup* group = NULL;
	ContactsContactSheetGroup* _tmp1_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	notes_chunk = G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_NOTES_CHUNK) ? ((ContactsNotesChunk*) chunk) : NULL;
	_tmp0_ = notes_chunk;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = contacts_contact_sheet_group_new ();
	g_object_ref_sink (_tmp1_);
	group = _tmp1_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ContactsNotesChunk* _tmp4_;
				ContactsNote* note = NULL;
				ContactsNotesChunk* _tmp5_;
				GObject* _tmp6_;
				ContactsNote* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				ContactsContactSheetRow* row = NULL;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				ContactsNote* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				ContactsContactSheetRow* _tmp15_;
				ContactsContactSheetGroup* _tmp16_;
				ContactsContactSheetRow* _tmp17_;
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = notes_chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp4_))) {
					break;
				}
				_tmp5_ = notes_chunk;
				_tmp6_ = g_list_model_get_item ((GListModel*) _tmp5_, i);
				note = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CONTACTS_TYPE_NOTE, ContactsNote);
				_tmp7_ = note;
				_tmp8_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_) {
					_g_object_unref0 (note);
					continue;
				}
				_tmp10_ = contacts_chunk_get_property_name (chunk);
				_tmp11_ = _tmp10_;
				_tmp12_ = note;
				_tmp13_ = contacts_note_get_text (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = contacts_contact_sheet_row_new (_tmp11_, _tmp14_, NULL);
				g_object_ref_sink (_tmp15_);
				row = _tmp15_;
				_tmp16_ = group;
				_tmp17_ = row;
				adw_preferences_group_add ((AdwPreferencesGroup*) _tmp16_, (GtkWidget*) _tmp17_);
				_g_object_unref0 (row);
				_g_object_unref0 (note);
			}
		}
	}
	result = (GtkWidget*) group;
	return result;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->address);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data23_->_data22_->self;
		_g_object_unref0 (_data23_->button);
		block22_data_unref (_data23_->_data22_);
		_data23_->_data22_ = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}

static void
______lambda12_ (Block23Data* _data23_)
{
	Block22Data* _data22_;
	ContactsContactSheet* self;
	GtkWindow* window = NULL;
	GtkButton* _tmp0_;
	GtkRoot* _tmp1_;
	gchar* uri = NULL;
	ContactsAddress* _tmp2_;
	gchar* _tmp3_;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = _data23_->button;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) _tmp0_);
	window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL;
	_tmp2_ = _data22_->address;
	_tmp3_ = contacts_address_to_maps_uri (_tmp2_);
	uri = _tmp3_;
	gtk_show_uri (window, uri, (guint32) GDK_CURRENT_TIME);
	_g_free0 (uri);
}

static void
_______lambda12__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self)
{
	______lambda12_ (self);
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_postal_addresses (ContactsContactSheet* self,
                                                           ContactsChunk* chunk)
{
	ContactsAddressesChunk* addresses_chunk = NULL;
	ContactsAddressesChunk* _tmp0_;
	GAppInfo* appinfo = NULL;
	GAppInfo* _tmp1_;
	gboolean map_uris_supported = FALSE;
	GAppInfo* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ContactsContactSheetGroup* group = NULL;
	ContactsContactSheetGroup* _tmp5_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	addresses_chunk = G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_ADDRESSES_CHUNK) ? ((ContactsAddressesChunk*) chunk) : NULL;
	_tmp0_ = addresses_chunk;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = g_app_info_get_default_for_uri_scheme ("maps");
	appinfo = _tmp1_;
	_tmp2_ = appinfo;
	map_uris_supported = _tmp2_ != NULL;
	_tmp3_ = bool_to_string (map_uris_supported);
	_tmp4_ = _tmp3_;
	g_debug ("contacts-contact-sheet.vala:357: Opening 'maps:' URIs supported: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = contacts_contact_sheet_group_new ();
	g_object_ref_sink (_tmp5_);
	group = _tmp5_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				Block22Data* _data22_;
				ContactsAddressesChunk* _tmp8_;
				ContactsAddressesChunk* _tmp9_;
				GObject* _tmp10_;
				ContactsAddress* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				ContactsContactSheetRow* row = NULL;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				ContactsAddress* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				ContactsAddress* _tmp19_;
				ContactsTypeDescriptor* _tmp20_;
				ContactsTypeDescriptor* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				ContactsContactSheetRow* _tmp24_;
				ContactsContactSheetRow* _tmp25_;
				ContactsContactSheetGroup* _tmp30_;
				ContactsContactSheetRow* _tmp31_;
				_data22_ = g_slice_new0 (Block22Data);
				_data22_->_ref_count_ = 1;
				_data22_->self = g_object_ref (self);
				if (!_tmp6_) {
					guint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = addresses_chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp8_))) {
					block22_data_unref (_data22_);
					_data22_ = NULL;
					break;
				}
				_tmp9_ = addresses_chunk;
				_tmp10_ = g_list_model_get_item ((GListModel*) _tmp9_, i);
				_data22_->address = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, CONTACTS_TYPE_ADDRESS, ContactsAddress);
				_tmp11_ = _data22_->address;
				_tmp12_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_) {
					block22_data_unref (_data22_);
					_data22_ = NULL;
					continue;
				}
				_tmp14_ = contacts_chunk_get_property_name (chunk);
				_tmp15_ = _tmp14_;
				_tmp16_ = _data22_->address;
				_tmp17_ = contacts_address_to_string (_tmp16_, "\n");
				_tmp18_ = _tmp17_;
				_tmp19_ = _data22_->address;
				_tmp20_ = contacts_address_get_address_type (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = contacts_typedescriptor_get_display_name (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = contacts_contact_sheet_row_new (_tmp15_, _tmp18_, _tmp23_);
				g_object_ref_sink (_tmp24_);
				_tmp25_ = _tmp24_;
				_g_object_unref0 (_tmp21_);
				_g_free0 (_tmp18_);
				row = _tmp25_;
				if (map_uris_supported) {
					Block23Data* _data23_;
					ContactsContactSheetRow* _tmp26_;
					GtkButton* _tmp27_;
					GtkButton* _tmp28_;
					GtkButton* _tmp29_;
					_data23_ = g_slice_new0 (Block23Data);
					_data23_->_ref_count_ = 1;
					_data23_->_data22_ = block22_data_ref (_data22_);
					_tmp26_ = row;
					_tmp27_ = contacts_contact_sheet_row_add_button (_tmp26_, "map-symbolic");
					_data23_->button = _tmp27_;
					_tmp28_ = _data23_->button;
					gtk_widget_set_tooltip_text ((GtkWidget*) _tmp28_, _ ("Show on the map"));
					_tmp29_ = _data23_->button;
					g_signal_connect_data (_tmp29_, "clicked", (GCallback) _______lambda12__gtk_button_clicked, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
					block23_data_unref (_data23_);
					_data23_ = NULL;
				}
				_tmp30_ = group;
				_tmp31_ = row;
				adw_preferences_group_add ((AdwPreferencesGroup*) _tmp30_, (GtkWidget*) _tmp31_);
				_g_object_unref0 (row);
				block22_data_unref (_data22_);
				_data22_ = NULL;
			}
		}
	}
	result = (GtkWidget*) group;
	_g_object_unref0 (appinfo);
	return result;
}

static GObject *
contacts_contact_sheet_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactSheet * self;
	GtkBoxLayout* box_layout = NULL;
	GtkBoxLayout* _tmp0_;
	GtkBoxLayout* _tmp1_;
	GtkLayoutManager* _tmp2_;
	parent_class = G_OBJECT_CLASS (contacts_contact_sheet_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheet);
	_tmp0_ = (GtkBoxLayout*) gtk_box_layout_new (GTK_ORIENTATION_VERTICAL);
	box_layout = _tmp0_;
	_tmp1_ = box_layout;
	_tmp2_ = _g_object_ref0 ((GtkLayoutManager*) _tmp1_);
	gtk_widget_set_layout_manager ((GtkWidget*) self, _tmp2_);
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-sheet");
	_g_object_unref0 (box_layout);
	return obj;
}

static void
contacts_contact_sheet_class_init (ContactsContactSheetClass * klass,
                                   gpointer klass_data)
{
	contacts_contact_sheet_parent_class = g_type_class_peek_parent (klass);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) contacts_contact_sheet_real_dispose;
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_sheet_constructor;
}

static void
contacts_contact_sheet_instance_init (ContactsContactSheet * self,
                                      gpointer klass)
{
}

/**
 * The contact sheet displays the actual information of a contact.
 *
 * (Note: to edit a contact, use the {@link ContactEditor} instead.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_sheet_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactSheetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_sheet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactSheet), 0, (GInstanceInitFunc) contacts_contact_sheet_instance_init, NULL };
	GType contacts_contact_sheet_type_id;
	contacts_contact_sheet_type_id = g_type_register_static (gtk_widget_get_type (), "ContactsContactSheet", &g_define_type_info, 0);
	return contacts_contact_sheet_type_id;
}

GType
contacts_contact_sheet_get_type (void)
{
	static volatile gsize contacts_contact_sheet_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_sheet_type_id__once)) {
		GType contacts_contact_sheet_type_id;
		contacts_contact_sheet_type_id = contacts_contact_sheet_get_type_once ();
		g_once_init_leave (&contacts_contact_sheet_type_id__once, contacts_contact_sheet_type_id);
	}
	return contacts_contact_sheet_type_id__once;
}

ContactsContactSheetGroup*
contacts_contact_sheet_group_construct_single_row (GType object_type,
                                                   ContactsContactSheetRow* row)
{
	ContactsContactSheetGroup * self = NULL;
	g_return_val_if_fail (row != NULL, NULL);
	self = (ContactsContactSheetGroup*) g_object_new (object_type, NULL);
	adw_preferences_group_add ((AdwPreferencesGroup*) self, (GtkWidget*) row);
	return self;
}

ContactsContactSheetGroup*
contacts_contact_sheet_group_new_single_row (ContactsContactSheetRow* row)
{
	return contacts_contact_sheet_group_construct_single_row (CONTACTS_TYPE_CONTACT_SHEET_GROUP, row);
}

ContactsContactSheetGroup*
contacts_contact_sheet_group_construct (GType object_type)
{
	ContactsContactSheetGroup * self = NULL;
	self = (ContactsContactSheetGroup*) g_object_new (object_type, NULL);
	return self;
}

ContactsContactSheetGroup*
contacts_contact_sheet_group_new (void)
{
	return contacts_contact_sheet_group_construct (CONTACTS_TYPE_CONTACT_SHEET_GROUP);
}

static GObject *
contacts_contact_sheet_group_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactSheetGroup * self;
	parent_class = G_OBJECT_CLASS (contacts_contact_sheet_group_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_SHEET_GROUP, ContactsContactSheetGroup);
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-sheet-property");
	return obj;
}

static void
contacts_contact_sheet_group_class_init (ContactsContactSheetGroupClass * klass,
                                         gpointer klass_data)
{
	contacts_contact_sheet_group_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_sheet_group_constructor;
}

static void
contacts_contact_sheet_group_instance_init (ContactsContactSheetGroup * self,
                                            gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
contacts_contact_sheet_group_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactSheetGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_sheet_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactSheetGroup), 0, (GInstanceInitFunc) contacts_contact_sheet_group_instance_init, NULL };
	GType contacts_contact_sheet_group_type_id;
	contacts_contact_sheet_group_type_id = g_type_register_static (adw_preferences_group_get_type (), "ContactsContactSheetGroup", &g_define_type_info, 0);
	return contacts_contact_sheet_group_type_id;
}

GType
contacts_contact_sheet_group_get_type (void)
{
	static volatile gsize contacts_contact_sheet_group_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_sheet_group_type_id__once)) {
		GType contacts_contact_sheet_group_type_id;
		contacts_contact_sheet_group_type_id = contacts_contact_sheet_group_get_type_once ();
		g_once_init_leave (&contacts_contact_sheet_group_type_id__once, contacts_contact_sheet_group_type_id);
	}
	return contacts_contact_sheet_group_type_id__once;
}

ContactsContactSheetRow*
contacts_contact_sheet_row_construct (GType object_type,
                                      const gchar* property_name,
                                      const gchar* title,
                                      const gchar* subtitle)
{
	ContactsContactSheetRow * self = NULL;
	const gchar* icon_name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (property_name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (ContactsContactSheetRow*) g_object_new (object_type, NULL);
	_tmp0_ = contacts_utils_get_icon_name_for_property (property_name);
	icon_name = _tmp0_;
	_tmp1_ = icon_name;
	if (_tmp1_ != NULL) {
		GtkImage* icon = NULL;
		const gchar* _tmp2_;
		GtkImage* _tmp3_;
		GtkImage* _tmp4_;
		GtkImage* _tmp5_;
		const gchar* _tmp6_;
		GtkImage* _tmp7_;
		_tmp2_ = icon_name;
		_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp2_);
		g_object_ref_sink (_tmp3_);
		icon = _tmp3_;
		_tmp4_ = icon;
		gtk_widget_add_css_class ((GtkWidget*) _tmp4_, "contacts-property-icon");
		_tmp5_ = icon;
		_tmp6_ = contacts_utils_get_display_name_for_property (property_name);
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _tmp6_);
		_tmp7_ = icon;
		adw_action_row_add_prefix ((AdwActionRow*) self, (GtkWidget*) _tmp7_);
		_g_object_unref0 (icon);
	}
	_tmp8_ = g_markup_escape_text (title, (gssize) -1);
	_tmp9_ = _tmp8_;
	adw_preferences_row_set_title ((AdwPreferencesRow*) self, _tmp9_);
	_g_free0 (_tmp9_);
	if (subtitle != NULL) {
		adw_action_row_set_subtitle ((AdwActionRow*) self, subtitle);
	}
	return self;
}

ContactsContactSheetRow*
contacts_contact_sheet_row_new (const gchar* property_name,
                                const gchar* title,
                                const gchar* subtitle)
{
	return contacts_contact_sheet_row_construct (CONTACTS_TYPE_CONTACT_SHEET_ROW, property_name, title, subtitle);
}

GtkButton*
contacts_contact_sheet_row_add_button (ContactsContactSheetRow* self,
                                       const gchar* icon)
{
	GtkButton* button = NULL;
	GtkButton* _tmp0_;
	GtkButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new_from_icon_name (icon);
	g_object_ref_sink (_tmp0_);
	button = _tmp0_;
	gtk_widget_set_valign ((GtkWidget*) button, GTK_ALIGN_CENTER);
	gtk_widget_add_css_class ((GtkWidget*) button, "flat");
	adw_action_row_add_suffix ((AdwActionRow*) self, (GtkWidget*) button);
	result = button;
	return result;
}

static GObject *
contacts_contact_sheet_row_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactSheetRow * self;
	parent_class = G_OBJECT_CLASS (contacts_contact_sheet_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_SHEET_ROW, ContactsContactSheetRow);
	adw_preferences_row_set_title_selectable ((AdwPreferencesRow*) self, TRUE);
	return obj;
}

static void
contacts_contact_sheet_row_class_init (ContactsContactSheetRowClass * klass,
                                       gpointer klass_data)
{
	contacts_contact_sheet_row_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_sheet_row_constructor;
}

static void
contacts_contact_sheet_row_instance_init (ContactsContactSheetRow * self,
                                          gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
contacts_contact_sheet_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactSheetRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_sheet_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactSheetRow), 0, (GInstanceInitFunc) contacts_contact_sheet_row_instance_init, NULL };
	GType contacts_contact_sheet_row_type_id;
	contacts_contact_sheet_row_type_id = g_type_register_static (adw_action_row_get_type (), "ContactsContactSheetRow", &g_define_type_info, 0);
	return contacts_contact_sheet_row_type_id;
}

GType
contacts_contact_sheet_row_get_type (void)
{
	static volatile gsize contacts_contact_sheet_row_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_sheet_row_type_id__once)) {
		GType contacts_contact_sheet_row_type_id;
		contacts_contact_sheet_row_type_id = contacts_contact_sheet_row_get_type_once ();
		g_once_init_leave (&contacts_contact_sheet_row_type_id__once, contacts_contact_sheet_row_type_id);
	}
	return contacts_contact_sheet_row_type_id__once;
}

