/* contacts-main-window.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-main-window.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include "contacts.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <folks/folks.h>
#include <gee.h>
#include <config.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_MAIN_WINDOW (contacts_main_window_get_type ())
#define CONTACTS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow))
#define CONTACTS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))
#define CONTACTS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))

typedef struct _ContactsMainWindow ContactsMainWindow;
typedef struct _ContactsMainWindowClass ContactsMainWindowClass;
typedef struct _ContactsMainWindowPrivate ContactsMainWindowPrivate;

#define CONTACTS_TYPE_CONTACT_LIST (contacts_contact_list_get_type ())
#define CONTACTS_CONTACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_LIST, ContactsContactList))
#define CONTACTS_CONTACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_LIST, ContactsContactListClass))
#define CONTACTS_IS_CONTACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_LIST))
#define CONTACTS_IS_CONTACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_LIST))
#define CONTACTS_CONTACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_LIST, ContactsContactListClass))

typedef struct _ContactsContactList ContactsContactList;
typedef struct _ContactsContactListClass ContactsContactListClass;

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;
typedef enum  {
	CONTACTS_UI_STATE_NORMAL,
	CONTACTS_UI_STATE_SHOWING,
	CONTACTS_UI_STATE_SELECTING,
	CONTACTS_UI_STATE_UPDATING,
	CONTACTS_UI_STATE_CREATING
} ContactsUiState;

#define CONTACTS_TYPE_UI_STATE (contacts_ui_state_get_type ())

#define CONTACTS_TYPE_SETTINGS (contacts_settings_get_type ())
#define CONTACTS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettings))
#define CONTACTS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))
#define CONTACTS_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))

typedef struct _ContactsSettings ContactsSettings;
typedef struct _ContactsSettingsClass ContactsSettingsClass;
enum  {
	CONTACTS_MAIN_WINDOW_0_PROPERTY,
	CONTACTS_MAIN_WINDOW_STATE_PROPERTY,
	CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY,
	CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY,
	CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY,
	CONTACTS_MAIN_WINDOW_STORE_PROPERTY,
	CONTACTS_MAIN_WINDOW_OPERATIONS_PROPERTY,
	CONTACTS_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* contacts_main_window_properties[CONTACTS_MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _gtk_bitset_unref0(var) ((var == NULL) ? NULL : (var = (gtk_bitset_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block24Data Block24Data;
typedef struct _Block25Data Block25Data;
typedef struct _ContactsContactPanePrivate ContactsContactPanePrivate;
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;
typedef struct _Block28Data Block28Data;

struct _ContactsMainWindow {
	AdwApplicationWindow parent_instance;
	ContactsMainWindowPrivate * priv;
	GtkSearchEntry* filter_entry;
};

struct _ContactsMainWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _ContactsMainWindowPrivate {
	AdwLeaflet* content_box;
	GtkRevealer* back_revealer;
	GtkStack* list_pane_stack;
	GtkOverlay* contact_pane_container;
	GtkBox* list_pane_page;
	GtkWidget* list_pane;
	AdwBin* contacts_list_container;
	ContactsContactList* contacts_list;
	GtkBox* contact_pane_page;
	ContactsContactPane* contact_pane;
	AdwHeaderBar* left_header;
	AdwHeaderBar* right_header;
	AdwToastOverlay* toast_overlay;
	GtkButton* select_cancel_button;
	GtkMenuButton* hamburger_menu_button;
	GtkBox* contact_sheet_buttons;
	GtkToggleButton* favorite_button;
	gboolean ignore_favorite_button_toggled;
	GtkButton* add_button;
	GtkButton* cancel_button;
	GtkButton* done_button;
	GtkButton* selection_button;
	GtkActionBar* actions_bar;
	ContactsUiState _state;
	gint _window_width;
	gint _window_height;
	ContactsSettings* _settings;
	ContactsStore* _store;
	ContactsOperationList* _operations;
	GtkMultiSelection* marked_contacts;
};

struct _Block24Data {
	int _ref_count_;
	ContactsMainWindow* self;
	const gchar* uuid;
};

struct _Block25Data {
	int _ref_count_;
	ContactsMainWindow* self;
	const gchar* uuid;
};

struct _ContactsContactPane {
	AdwBin parent_instance;
	ContactsContactPanePrivate * priv;
	gboolean on_edit_mode;
};

struct _ContactsContactPaneClass {
	AdwBinClass parent_class;
};

struct _Block26Data {
	int _ref_count_;
	ContactsMainWindow* self;
	GtkBitset* selection;
};

struct _Block27Data {
	int _ref_count_;
	ContactsMainWindow* self;
	GtkBitset* selection;
	GtkFileChooserNative* chooser;
};

struct _Block28Data {
	int _ref_count_;
	Block27Data * _data27_;
	GOutputStream* filestream;
};

static gint ContactsMainWindow_private_offset;
static gpointer contacts_main_window_parent_class = NULL;

VALA_EXTERN GType contacts_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsMainWindow, g_object_unref)
VALA_EXTERN GType contacts_contact_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactList, g_object_unref)
VALA_EXTERN GType contacts_contact_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactPane, g_object_unref)
VALA_EXTERN GType contacts_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType contacts_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsSettings, g_object_unref)
VALA_EXTERN void contacts_main_window_new_contact (ContactsMainWindow* self,
                                       GSimpleAction* action,
                                       GVariant* parameter);
static void _contacts_main_window_new_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void contacts_main_window_edit_contact (ContactsMainWindow* self,
                                        GSimpleAction* action,
                                        GVariant* parameter);
static void _contacts_main_window_edit_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void contacts_main_window_stop_editing_contact (ContactsMainWindow* self,
                                                GSimpleAction* action,
                                                GVariant* parameter);
static void _contacts_main_window_stop_editing_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void contacts_main_window_link_marked_contacts (ContactsMainWindow* self,
                                                GSimpleAction* action,
                                                GVariant* parameter);
static void _contacts_main_window_link_marked_contacts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void contacts_main_window_delete_marked_contacts (ContactsMainWindow* self,
                                                  GSimpleAction* action,
                                                  GVariant* parameter);
static void _contacts_main_window_delete_marked_contacts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void contacts_main_window_export_marked_contacts (ContactsMainWindow* self,
                                                  GSimpleAction* action,
                                                  GVariant* parameter);
static void _contacts_main_window_export_marked_contacts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void contacts_main_window_unlink_contact (ContactsMainWindow* self,
                                          GSimpleAction* action,
                                          GVariant* parameter);
static void _contacts_main_window_unlink_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void contacts_main_window_delete_contact (ContactsMainWindow* self,
                                          GSimpleAction* action,
                                          GVariant* parameter);
static void _contacts_main_window_delete_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void contacts_main_window_sort_on_changed (ContactsMainWindow* self,
                                           GSimpleAction* action,
                                           GVariant* new_state);
static void _contacts_main_window_sort_on_changed_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                 GVariant* value,
                                                                                 gpointer self);
static void contacts_main_window_undo_operation_action (ContactsMainWindow* self,
                                                 GSimpleAction* action,
                                                 GVariant* parameter);
static void _contacts_main_window_undo_operation_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self);
static void contacts_main_window_cancel_operation_action (ContactsMainWindow* self,
                                                   GSimpleAction* action,
                                                   GVariant* parameter);
static void _contacts_main_window_cancel_operation_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                     GVariant* parameter,
                                                                                     gpointer self);
VALA_EXTERN GType contacts_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsApp, g_object_unref)
VALA_EXTERN ContactsMainWindow* contacts_main_window_new (ContactsSettings* settings,
                                              ContactsOperationList* operations,
                                              ContactsApp* app,
                                              ContactsStore* contacts_store);
VALA_EXTERN ContactsMainWindow* contacts_main_window_construct (GType object_type,
                                                    ContactsSettings* settings,
                                                    ContactsOperationList* operations,
                                                    ContactsApp* app,
                                                    ContactsStore* contacts_store);
VALA_EXTERN ContactsSettings* contacts_main_window_get_settings (ContactsMainWindow* self);
VALA_EXTERN gboolean contacts_settings_get_sort_on_surname (ContactsSettings* self);
static void contacts_main_window_restore_window_state (ContactsMainWindow* self);
VALA_EXTERN gint contacts_settings_get_window_width (ContactsSettings* self);
VALA_EXTERN gint contacts_settings_get_window_height (ContactsSettings* self);
VALA_EXTERN gboolean contacts_settings_get_window_maximized (ContactsSettings* self);
VALA_EXTERN gboolean contacts_settings_get_window_fullscreen (ContactsSettings* self);
static void contacts_main_window_create_list_pane (ContactsMainWindow* self);
VALA_EXTERN ContactsStore* contacts_main_window_get_store (ContactsMainWindow* self);
VALA_EXTERN ContactsContactList* contacts_contact_list_new (ContactsStore* store,
                                                GtkMultiSelection* marked_contacts);
VALA_EXTERN ContactsContactList* contacts_contact_list_construct (GType object_type,
                                                      ContactsStore* store,
                                                      GtkMultiSelection* marked_contacts);
static void contacts_main_window_create_contact_pane (ContactsMainWindow* self);
VALA_EXTERN ContactsContactPane* contacts_contact_pane_new (ContactsMainWindow* main_window,
                                                ContactsStore* contacts_store);
VALA_EXTERN ContactsContactPane* contacts_contact_pane_construct (GType object_type,
                                                      ContactsMainWindow* main_window,
                                                      ContactsStore* contacts_store);
static void contacts_main_window_contact_pane_contacts_linked_cb (ContactsMainWindow* self,
                                                           ContactsLinkOperation* operation);
static void _contacts_main_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked (ContactsContactPane* _sender,
                                                                                                  ContactsLinkOperation* operation,
                                                                                                  gpointer self);
VALA_EXTERN void contacts_main_window_show_contact_list (ContactsMainWindow* self);
static void contacts_main_window_on_marked_contacts_changed (ContactsMainWindow* self,
                                                      GtkSelectionModel* marked,
                                                      guint position,
                                                      guint n_changed);
VALA_EXTERN ContactsUiState contacts_main_window_get_state (ContactsMainWindow* self);
static void contacts_main_window_on_ui_state_changed (ContactsMainWindow* self,
                                               GObject* obj,
                                               GParamSpec* pspec);
VALA_EXTERN gboolean contacts_ui_state_editing (ContactsUiState self);
static void contacts_main_window_on_back_clicked (ContactsMainWindow* self);
static void contacts_main_window_show_list_pane (ContactsMainWindow* self);
static void _contacts_main_window_on_back_clicked_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
VALA_EXTERN void contacts_main_window_set_state (ContactsMainWindow* self,
                                     ContactsUiState value);
VALA_EXTERN void contacts_contact_pane_edit_contact (ContactsContactPane* self);
static void contacts_main_window_on_favorite_button_toggled (ContactsMainWindow* self,
                                                      GtkToggleButton* button);
static void _contacts_main_window_on_favorite_button_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                 gpointer self);
static void contacts_main_window_on_selection_button_clicked (ContactsMainWindow* self);
static void _contacts_main_window_on_selection_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self);
VALA_EXTERN ContactsOperationList* contacts_main_window_get_operations (ContactsMainWindow* self);
static void __lambda35_ (ContactsMainWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda35__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static AdwToast* contacts_main_window_add_toast_for_operation (ContactsMainWindow* self,
                                                        ContactsOperation* operation,
                                                        const gchar* action_name,
                                                        const gchar* action_label);
VALA_EXTERN void contacts_contact_list_set_contacts_visible (ContactsContactList* self,
                                                 GtkBitset* selection,
                                                 gboolean visible);
VALA_EXTERN void contacts_contact_pane_show_contact (ContactsContactPane* self,
                                         FolksIndividual* individual);
static void contacts_main_window_delete_contacts (ContactsMainWindow* self,
                                           GtkBitset* selection);
VALA_EXTERN void contacts_settings_set_sort_on_surname (ContactsSettings* self,
                                            gboolean value);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void __lambda36_ (Block24Data* _data24_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda36__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void __lambda37_ (Block25Data* _data25_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda37__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void contacts_main_window_show_contact_pane (ContactsMainWindow* self);
VALA_EXTERN void contacts_contact_pane_stop_editing (ContactsContactPane* self,
                                         gboolean cancel);
VALA_EXTERN void contacts_contact_list_scroll_to_selected (ContactsContactList* self);
VALA_EXTERN void contacts_contact_pane_new_contact (ContactsContactPane* self);
static void contacts_main_window_on_cancel_visible (ContactsMainWindow* self);
static void contacts_main_window_update_header (ContactsMainWindow* self);
static void _contacts_main_window_on_cancel_visible_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void contacts_main_window_on_folded (ContactsMainWindow* self);
static void contacts_main_window_on_visible_child (ContactsMainWindow* self);
static void _contacts_main_window_on_folded_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _contacts_main_window_on_visible_child_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
VALA_EXTERN void contacts_main_window_show_search (ContactsMainWindow* self,
                                       const gchar* query);
static void contacts_main_window_connect_button_signals (ContactsMainWindow* self);
static void __lambda39_ (ContactsMainWindow* self);
static void ___lambda39__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gboolean contacts_main_window_real_close_request (GtkWindow* base);
VALA_EXTERN void contacts_settings_set_window_width (ContactsSettings* self,
                                         gint value);
VALA_EXTERN void contacts_settings_set_window_height (ContactsSettings* self,
                                          gint value);
VALA_EXTERN void contacts_settings_set_window_maximized (ContactsSettings* self,
                                             gboolean value);
VALA_EXTERN void contacts_settings_set_window_fullscreen (ContactsSettings* self,
                                              gboolean value);
static void contacts_main_window_on_selection_changed (ContactsMainWindow* self,
                                                GObject* object,
                                                GParamSpec* pspec);
static GeeLinkedList* contacts_main_window_bitset_to_individuals (ContactsMainWindow* self,
                                                           GListModel* model,
                                                           GtkBitset* bitset);
static void __lambda30_ (ContactsMainWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda30__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static void __lambda31_ (Block26Data* _data26_,
                  GCancellable* c);
static void ___lambda31__g_cancellable_cancelled (GCancellable* _sender,
                                           gpointer self);
static void __lambda32_ (ContactsMainWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda32__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __lambda38_ (ContactsMainWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda38__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static GVariant* _variant_new1 (const gchar* value);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static void __lambda33_ (Block27Data* _data27_,
                  gint response);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static void __lambda34_ (Block28Data* _data28_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda34__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ___lambda33__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void contacts_main_window_filter_entry_changed (ContactsMainWindow* self,
                                                GtkEditable* editable);
static void _contacts_main_window_filter_entry_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                 gpointer self);
VALA_EXTERN gint contacts_main_window_get_window_width (ContactsMainWindow* self);
VALA_EXTERN void contacts_main_window_set_window_width (ContactsMainWindow* self,
                                            gint value);
VALA_EXTERN gint contacts_main_window_get_window_height (ContactsMainWindow* self);
VALA_EXTERN void contacts_main_window_set_window_height (ContactsMainWindow* self,
                                             gint value);
VALA_EXTERN void contacts_main_window_set_settings (ContactsMainWindow* self,
                                        ContactsSettings* value);
VALA_EXTERN void contacts_main_window_set_store (ContactsMainWindow* self,
                                     ContactsStore* value);
VALA_EXTERN void contacts_main_window_set_operations (ContactsMainWindow* self,
                                          ContactsOperationList* value);
static GObject * contacts_main_window_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _contacts_main_window_on_selection_changed_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void _contacts_main_window_on_marked_contacts_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                                             guint position,
                                                                                             guint n_items,
                                                                                             gpointer self);
static void _contacts_main_window_on_ui_state_changed_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void contacts_main_window_finalize (GObject * obj);
static GType contacts_main_window_get_type_once (void);
static void _vala_contacts_main_window_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_contacts_main_window_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static const GActionEntry CONTACTS_MAIN_WINDOW_ACTION_ENTRIES[11] = {{"new-contact", _contacts_main_window_new_contact_gsimple_action_activate_callback}, {"edit-contact", _contacts_main_window_edit_contact_gsimple_action_activate_callback}, {"stop-editing-contact", _contacts_main_window_stop_editing_contact_gsimple_action_activate_callback, "b"}, {"link-marked-contacts", _contacts_main_window_link_marked_contacts_gsimple_action_activate_callback}, {"delete-marked-contacts", _contacts_main_window_delete_marked_contacts_gsimple_action_activate_callback}, {"export-marked-contacts", _contacts_main_window_export_marked_contacts_gsimple_action_activate_callback}, {"unlink-contact", _contacts_main_window_unlink_contact_gsimple_action_activate_callback}, {"delete-contact", _contacts_main_window_delete_contact_gsimple_action_activate_callback}, {"sort-on", NULL, "s", "'surname'", _contacts_main_window_sort_on_changed_gsimple_action_change_state_callback}, {"undo-operation", _contacts_main_window_undo_operation_action_gsimple_action_activate_callback, "s"}, {"cancel-operation", _contacts_main_window_cancel_operation_action_gsimple_action_activate_callback, "s"}};

static inline gpointer
contacts_main_window_get_instance_private (ContactsMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsMainWindow_private_offset);
}

static void
_contacts_main_window_new_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	contacts_main_window_new_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_edit_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	contacts_main_window_edit_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_stop_editing_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	contacts_main_window_stop_editing_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_link_marked_contacts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	contacts_main_window_link_marked_contacts ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_delete_marked_contacts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	contacts_main_window_delete_marked_contacts ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_export_marked_contacts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	contacts_main_window_export_marked_contacts ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_unlink_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	contacts_main_window_unlink_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_delete_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	contacts_main_window_delete_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_sort_on_changed_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                            GVariant* value,
                                                                            gpointer self)
{
	contacts_main_window_sort_on_changed ((ContactsMainWindow*) self, action, value);
}

static void
_contacts_main_window_undo_operation_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self)
{
	contacts_main_window_undo_operation_action ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_cancel_operation_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self)
{
	contacts_main_window_cancel_operation_action ((ContactsMainWindow*) self, action, parameter);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ContactsMainWindow*
contacts_main_window_construct (GType object_type,
                                ContactsSettings* settings,
                                ContactsOperationList* operations,
                                ContactsApp* app,
                                ContactsStore* contacts_store)
{
	ContactsMainWindow * self = NULL;
	const gchar* _tmp0_ = NULL;
	ContactsSettings* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* sort_key = NULL;
	GSimpleAction* sort_action = NULL;
	GAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (operations != NULL, NULL);
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (contacts_store != NULL, NULL);
	self = (ContactsMainWindow*) g_object_new (object_type, "application", app, "operations", operations, "settings", settings, "store", contacts_store, NULL);
	_tmp1_ = self->priv->_settings;
	_tmp2_ = contacts_settings_get_sort_on_surname (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = "surname";
	} else {
		_tmp0_ = "firstname";
	}
	sort_key = _tmp0_;
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "sort-on");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_simple_action_get_type (), GSimpleAction));
	sort_action = _tmp5_;
	_tmp6_ = g_variant_new_string (sort_key);
	g_variant_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	g_simple_action_set_state (sort_action, _tmp7_);
	_g_variant_unref0 (_tmp7_);
	_g_object_unref0 (sort_action);
	return self;
}

ContactsMainWindow*
contacts_main_window_new (ContactsSettings* settings,
                          ContactsOperationList* operations,
                          ContactsApp* app,
                          ContactsStore* contacts_store)
{
	return contacts_main_window_construct (CONTACTS_TYPE_MAIN_WINDOW, settings, operations, app, contacts_store);
}

static void
contacts_main_window_restore_window_state (ContactsMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	ContactsSettings* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ContactsSettings* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ContactsSettings* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_settings;
	_tmp2_ = contacts_settings_get_window_width (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		ContactsSettings* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->_settings;
		_tmp5_ = contacts_settings_get_window_height (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ContactsSettings* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		ContactsSettings* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp7_ = self->priv->_settings;
		_tmp8_ = contacts_settings_get_window_width (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_settings;
		_tmp11_ = contacts_settings_get_window_height (_tmp10_);
		_tmp12_ = _tmp11_;
		gtk_window_set_default_size ((GtkWindow*) self, _tmp9_, _tmp12_);
	}
	_tmp13_ = self->priv->_settings;
	_tmp14_ = contacts_settings_get_window_maximized (_tmp13_);
	_tmp15_ = _tmp14_;
	g_object_set ((GtkWindow*) self, "maximized", _tmp15_, NULL);
	_tmp16_ = self->priv->_settings;
	_tmp17_ = contacts_settings_get_window_fullscreen (_tmp16_);
	_tmp18_ = _tmp17_;
	g_object_set ((GtkWindow*) self, "fullscreened", _tmp18_, NULL);
}

static void
contacts_main_window_create_list_pane (ContactsMainWindow* self)
{
	ContactsContactList* contactslist = NULL;
	ContactsStore* _tmp0_;
	GtkMultiSelection* _tmp1_;
	ContactsContactList* _tmp2_;
	AdwBin* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = self->priv->marked_contacts;
	_tmp2_ = contacts_contact_list_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	contactslist = _tmp2_;
	g_object_bind_property_with_closures ((GObject*) self, "state", (GObject*) contactslist, "state", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	self->priv->contacts_list = contactslist;
	_tmp3_ = self->priv->contacts_list_container;
	adw_bin_set_child (_tmp3_, (GtkWidget*) contactslist);
	_g_object_unref0 (contactslist);
}

static void
_contacts_main_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked (ContactsContactPane* _sender,
                                                                                             ContactsLinkOperation* operation,
                                                                                             gpointer self)
{
	contacts_main_window_contact_pane_contacts_linked_cb ((ContactsMainWindow*) self, operation);
}

static void
contacts_main_window_create_contact_pane (ContactsMainWindow* self)
{
	ContactsStore* _tmp0_;
	ContactsContactPane* _tmp1_;
	ContactsContactPane* _tmp2_;
	ContactsContactPane* _tmp3_;
	ContactsContactPane* _tmp4_;
	GtkOverlay* _tmp5_;
	ContactsContactPane* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_contact_pane_new (self, _tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->contact_pane);
	self->priv->contact_pane = _tmp1_;
	_tmp2_ = self->priv->contact_pane;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->contact_pane;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = self->priv->contact_pane;
	g_signal_connect_object (_tmp4_, "contacts-linked", (GCallback) _contacts_main_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked, self, 0);
	_tmp5_ = self->priv->contact_pane_container;
	_tmp6_ = self->priv->contact_pane;
	gtk_overlay_set_child (_tmp5_, (GtkWidget*) _tmp6_);
}

/**
   * This shows the contact list on the left. This needs to be called
   * explicitly when contacts are loaded, as the original setup will
   * only show a loading spinner.
   */
void
contacts_main_window_show_contact_list (ContactsMainWindow* self)
{
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_pane_stack;
	_tmp1_ = self->priv->list_pane;
	gtk_stack_set_visible_child (_tmp0_, _tmp1_);
}

static void
contacts_main_window_on_marked_contacts_changed (ContactsMainWindow* self,
                                                 GtkSelectionModel* marked,
                                                 guint position,
                                                 guint n_changed)
{
	guint64 n_selected = 0ULL;
	GtkBitset* _tmp0_;
	GtkBitset* _tmp1_;
	guint64 _tmp2_;
	GAction* action = NULL;
	GAction* _tmp3_;
	GAction* _tmp4_;
	GAction* _tmp5_;
	GAction* _tmp6_;
	GAction* _tmp7_;
	GAction* _tmp8_;
	gchar* left_title = NULL;
	gchar* _tmp9_;
	ContactsUiState _tmp10_;
	AdwHeaderBar* _tmp12_;
	const gchar* _tmp13_;
	AdwWindowTitle* _tmp14_;
	AdwWindowTitle* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (marked != NULL);
	_tmp0_ = gtk_selection_model_get_selection (marked);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_bitset_get_size (_tmp1_);
	_gtk_bitset_unref0 (_tmp1_);
	n_selected = _tmp2_;
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) self, "delete-marked-contacts");
	action = _tmp3_;
	_tmp4_ = action;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_simple_action_get_type (), GSimpleAction), n_selected > ((guint64) 0));
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "export-marked-contacts");
	action = _tmp5_;
	_tmp6_ = action;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_simple_action_get_type (), GSimpleAction), n_selected > ((guint64) 0));
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) self, "link-marked-contacts");
	action = _tmp7_;
	_tmp8_ = action;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_simple_action_get_type (), GSimpleAction), n_selected > ((guint64) 1));
	_tmp9_ = g_strdup (_ ("Contacts"));
	left_title = _tmp9_;
	_tmp10_ = self->priv->_state;
	if (_tmp10_ == CONTACTS_UI_STATE_SELECTING) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup_printf (ngettext ("%llu Selected", "%llu Selected", (gulong) n_selected), n_selected);
		_g_free0 (left_title);
		left_title = _tmp11_;
	}
	_tmp12_ = self->priv->left_header;
	_tmp13_ = left_title;
	_tmp14_ = (AdwWindowTitle*) adw_window_title_new (_tmp13_, "");
	g_object_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	adw_header_bar_set_title_widget (_tmp12_, (GtkWidget*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_g_free0 (left_title);
}

static void
contacts_main_window_on_ui_state_changed (ContactsMainWindow* self,
                                          GObject* obj,
                                          GParamSpec* pspec)
{
	gboolean _tmp0_ = FALSE;
	ContactsUiState _tmp1_;
	GtkButton* _tmp3_;
	GtkMenuButton* _tmp4_;
	GtkBox* _tmp5_;
	ContactsUiState _tmp6_;
	GtkButton* _tmp7_;
	ContactsUiState _tmp8_;
	gboolean _tmp9_ = FALSE;
	ContactsUiState _tmp10_;
	GtkButton* _tmp12_;
	ContactsUiState _tmp13_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	AdwHeaderBar* _tmp19_;
	ContactsUiState _tmp20_;
	AdwHeaderBar* _tmp21_;
	ContactsUiState _tmp22_;
	ContactsUiState _tmp23_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	ContactsUiState _tmp30_;
	AdwLeaflet* _tmp33_;
	GtkSearchEntry* _tmp34_;
	ContactsContactList* _tmp35_;
	ContactsUiState _tmp36_;
	GtkActionBar* _tmp37_;
	ContactsUiState _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ == CONTACTS_UI_STATE_NORMAL) {
		_tmp0_ = TRUE;
	} else {
		ContactsUiState _tmp2_;
		_tmp2_ = self->priv->_state;
		_tmp0_ = _tmp2_ == CONTACTS_UI_STATE_SHOWING;
	}
	_tmp3_ = self->priv->add_button;
	_tmp4_ = self->priv->hamburger_menu_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, _tmp0_);
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, _tmp0_);
	_tmp5_ = self->priv->contact_sheet_buttons;
	_tmp6_ = self->priv->_state;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, _tmp6_ == CONTACTS_UI_STATE_SHOWING);
	_tmp7_ = self->priv->select_cancel_button;
	_tmp8_ = self->priv->_state;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ == CONTACTS_UI_STATE_SELECTING);
	_tmp10_ = self->priv->_state;
	if (_tmp10_ == CONTACTS_UI_STATE_SELECTING) {
		_tmp9_ = TRUE;
	} else {
		ContactsUiState _tmp11_;
		_tmp11_ = self->priv->_state;
		_tmp9_ = contacts_ui_state_editing (_tmp11_);
	}
	_tmp12_ = self->priv->selection_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp12_, !_tmp9_);
	_tmp13_ = self->priv->_state;
	if (_tmp13_ != CONTACTS_UI_STATE_SELECTING) {
		AdwHeaderBar* _tmp14_;
		AdwWindowTitle* _tmp15_;
		AdwWindowTitle* _tmp16_;
		_tmp14_ = self->priv->left_header;
		_tmp15_ = (AdwWindowTitle*) adw_window_title_new (_ ("Contacts"), "");
		g_object_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		adw_header_bar_set_title_widget (_tmp14_, (GtkWidget*) _tmp16_);
		_g_object_unref0 (_tmp16_);
	}
	_tmp17_ = self->priv->cancel_button;
	_tmp18_ = self->priv->done_button;
	_tmp19_ = self->priv->right_header;
	_tmp20_ = self->priv->_state;
	adw_header_bar_set_show_end_title_buttons (_tmp19_, contacts_ui_state_editing (_tmp20_));
	gtk_widget_set_visible ((GtkWidget*) _tmp18_, contacts_ui_state_editing (_tmp20_));
	gtk_widget_set_visible ((GtkWidget*) _tmp17_, contacts_ui_state_editing (_tmp20_));
	_tmp21_ = self->priv->right_header;
	_tmp22_ = self->priv->_state;
	adw_header_bar_set_show_end_title_buttons (_tmp21_, !contacts_ui_state_editing (_tmp22_));
	_tmp23_ = self->priv->_state;
	if (contacts_ui_state_editing (_tmp23_)) {
		const gchar* _tmp24_ = NULL;
		ContactsUiState _tmp25_;
		GtkButton* _tmp26_;
		GtkButton* _tmp27_;
		_tmp25_ = self->priv->_state;
		if (_tmp25_ == CONTACTS_UI_STATE_CREATING) {
			_tmp24_ = _ ("_Add");
		} else {
			_tmp24_ = _ ("Done");
		}
		_tmp26_ = self->priv->done_button;
		gtk_button_set_label (_tmp26_, _tmp24_);
		_tmp27_ = self->priv->done_button;
		gtk_widget_set_focus_on_click ((GtkWidget*) _tmp27_, TRUE);
	}
	_tmp30_ = self->priv->_state;
	if (_tmp30_ == CONTACTS_UI_STATE_NORMAL) {
		_tmp29_ = TRUE;
	} else {
		ContactsUiState _tmp31_;
		_tmp31_ = self->priv->_state;
		_tmp29_ = _tmp31_ == CONTACTS_UI_STATE_SHOWING;
	}
	if (_tmp29_) {
		_tmp28_ = TRUE;
	} else {
		ContactsUiState _tmp32_;
		_tmp32_ = self->priv->_state;
		_tmp28_ = _tmp32_ == CONTACTS_UI_STATE_SELECTING;
	}
	_tmp33_ = self->priv->content_box;
	adw_leaflet_set_can_navigate_back (_tmp33_, _tmp28_);
	_tmp34_ = self->filter_entry;
	_tmp35_ = self->priv->contacts_list;
	_tmp36_ = self->priv->_state;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp35_, !contacts_ui_state_editing (_tmp36_));
	gtk_widget_set_sensitive ((GtkWidget*) _tmp34_, !contacts_ui_state_editing (_tmp36_));
	_tmp37_ = self->priv->actions_bar;
	_tmp38_ = self->priv->_state;
	gtk_action_bar_set_revealed (_tmp37_, _tmp38_ == CONTACTS_UI_STATE_SELECTING);
}

static void
contacts_main_window_on_back_clicked (ContactsMainWindow* self)
{
	g_return_if_fail (self != NULL);
	contacts_main_window_show_list_pane (self);
}

static void
_contacts_main_window_on_back_clicked_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
	contacts_main_window_on_back_clicked ((ContactsMainWindow*) self);
}

static void
contacts_main_window_edit_contact (ContactsMainWindow* self,
                                   GSimpleAction* action,
                                   GVariant* parameter)
{
	FolksIndividual* selected = NULL;
	ContactsStore* _tmp0_;
	FolksIndividual* _tmp1_;
	gchar* title = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	AdwHeaderBar* _tmp5_;
	AdwWindowTitle* _tmp6_;
	AdwWindowTitle* _tmp7_;
	ContactsContactPane* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_store_get_selected_contact (_tmp0_);
	selected = _tmp1_;
	g_return_if_fail (selected != NULL);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_UPDATING);
	_tmp2_ = folks_individual_get_display_name (selected);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (_ ("Editing %s"), _tmp3_);
	title = _tmp4_;
	_tmp5_ = self->priv->right_header;
	_tmp6_ = (AdwWindowTitle*) adw_window_title_new (title, "");
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	adw_header_bar_set_title_widget (_tmp5_, (GtkWidget*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = self->priv->contact_pane;
	contacts_contact_pane_edit_contact (_tmp8_);
	_g_free0 (title);
}

static void
contacts_main_window_on_favorite_button_toggled (ContactsMainWindow* self,
                                                 GtkToggleButton* button)
{
	FolksIndividual* selected = NULL;
	ContactsStore* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	FolksIndividual* _tmp3_;
	FolksIndividual* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (self->priv->ignore_favorite_button_toggled) {
		return;
	}
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_store_get_selected_contact (_tmp0_);
	selected = _tmp1_;
	_tmp2_ = selected;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = selected;
	_tmp4_ = selected;
	_tmp5_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp4_);
	_tmp6_ = _tmp5_;
	folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) _tmp3_, !_tmp6_);
}

static void
_contacts_main_window_on_favorite_button_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                            gpointer self)
{
	contacts_main_window_on_favorite_button_toggled ((ContactsMainWindow*) self, _sender);
}

static void
contacts_main_window_on_selection_button_clicked (ContactsMainWindow* self)
{
	gchar* left_title = NULL;
	gchar* _tmp0_;
	AdwHeaderBar* _tmp1_;
	AdwWindowTitle* _tmp2_;
	AdwWindowTitle* _tmp3_;
	g_return_if_fail (self != NULL);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_SELECTING);
	_tmp0_ = g_strdup_printf (ngettext ("%d Selected", "%d Selected", (gulong) 0), 0);
	left_title = _tmp0_;
	_tmp1_ = self->priv->left_header;
	_tmp2_ = (AdwWindowTitle*) adw_window_title_new (left_title, "");
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	adw_header_bar_set_title_widget (_tmp1_, (GtkWidget*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_free0 (left_title);
}

static void
_contacts_main_window_on_selection_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self)
{
	contacts_main_window_on_selection_button_clicked ((ContactsMainWindow*) self);
}

static void
__lambda35_ (ContactsMainWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_execute_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:287: Error unlinking individuals: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda35__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda35_ ((ContactsMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_main_window_unlink_contact (ContactsMainWindow* self,
                                     GSimpleAction* action,
                                     GVariant* parameter)
{
	FolksIndividual* selected = NULL;
	ContactsStore* _tmp0_;
	FolksIndividual* _tmp1_;
	ContactsStore* _tmp2_;
	GtkSingleSelection* _tmp3_;
	GtkSingleSelection* _tmp4_;
	ContactsStore* _tmp5_;
	GtkSingleSelection* _tmp6_;
	GtkSingleSelection* _tmp7_;
	ContactsUnlinkOperation* operation = NULL;
	ContactsStore* _tmp8_;
	ContactsUnlinkOperation* _tmp9_;
	ContactsOperationList* _tmp10_;
	AdwToast* _tmp11_;
	AdwToast* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_store_get_selected_contact (_tmp0_);
	selected = _tmp1_;
	g_return_if_fail (selected != NULL);
	_tmp2_ = self->priv->_store;
	_tmp3_ = contacts_store_get_selection (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_store;
	_tmp6_ = contacts_store_get_selection (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_selection_model_unselect_item ((GtkSelectionModel*) _tmp4_, gtk_single_selection_get_selected (_tmp7_));
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	_tmp8_ = self->priv->_store;
	_tmp9_ = contacts_unlink_operation_new (_tmp8_, selected);
	operation = _tmp9_;
	_tmp10_ = self->priv->_operations;
	contacts_operation_list_execute (_tmp10_, (ContactsOperation*) operation, NULL, ___lambda35__gasync_ready_callback, g_object_ref (self));
	_tmp11_ = contacts_main_window_add_toast_for_operation (self, (ContactsOperation*) operation, "win.undo-operation", _ ("_Undo"));
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp12_);
	_g_object_unref0 (operation);
}

static void
contacts_main_window_delete_contact (ContactsMainWindow* self,
                                     GSimpleAction* action,
                                     GVariant* parameter)
{
	GtkBitset* selection = NULL;
	ContactsStore* _tmp0_;
	GtkSingleSelection* _tmp1_;
	GtkSingleSelection* _tmp2_;
	GtkBitset* _tmp3_;
	GtkBitset* _tmp4_;
	GtkBitset* _tmp5_;
	GtkBitset* _tmp6_;
	GtkBitset* _tmp7_;
	ContactsContactList* _tmp8_;
	GtkBitset* _tmp9_;
	ContactsContactPane* _tmp10_;
	GtkBitset* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_store_get_selection (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_selection_model_get_selection ((GtkSelectionModel*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_bitset_copy (_tmp4_);
	_tmp6_ = _tmp5_;
	_gtk_bitset_unref0 (_tmp4_);
	selection = _tmp6_;
	_tmp7_ = selection;
	if (gtk_bitset_is_empty (_tmp7_)) {
		_gtk_bitset_unref0 (selection);
		return;
	}
	_tmp8_ = self->priv->contacts_list;
	_tmp9_ = selection;
	contacts_contact_list_set_contacts_visible (_tmp8_, _tmp9_, FALSE);
	_tmp10_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp10_, NULL);
	_tmp11_ = selection;
	contacts_main_window_delete_contacts (self, _tmp11_);
	_gtk_bitset_unref0 (selection);
}

static void
contacts_main_window_sort_on_changed (ContactsMainWindow* self,
                                      GSimpleAction* action,
                                      GVariant* new_state)
{
	const gchar* sort_key = NULL;
	const gchar* _tmp0_;
	ContactsSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (new_state, NULL);
	sort_key = _tmp0_;
	_tmp1_ = self->priv->_settings;
	contacts_settings_set_sort_on_surname (_tmp1_, g_strcmp0 (sort_key, "surname") == 0);
	g_simple_action_set_state (action, new_state);
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		ContactsMainWindow* self;
		self = _data24_->self;
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static void
__lambda36_ (Block24Data* _data24_,
             GObject* obj,
             GAsyncResult* res)
{
	ContactsMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data24_->self;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_undo_operation_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:316: Couldn't undo operation '%s': %s", _data24_->uuid, _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda36__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda36_ (self, source_object, res);
	block24_data_unref (self);
}

static void
contacts_main_window_undo_operation_action (ContactsMainWindow* self,
                                            GSimpleAction* action,
                                            GVariant* parameter)
{
	Block24Data* _data24_;
	const gchar* _tmp0_;
	ContactsOperationList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = g_variant_get_string (parameter, NULL);
	_data24_->uuid = _tmp0_;
	_tmp1_ = self->priv->_operations;
	contacts_operation_list_undo_operation (_tmp1_, _data24_->uuid, ___lambda36__gasync_ready_callback, block24_data_ref (_data24_));
	block24_data_unref (_data24_);
	_data24_ = NULL;
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		ContactsMainWindow* self;
		self = _data25_->self;
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static void
__lambda37_ (Block25Data* _data25_,
             GObject* obj,
             GAsyncResult* res)
{
	ContactsMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data25_->self;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_cancel_operation_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:327: Couldn't cancel operation '%s': %s", _data25_->uuid, _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda37__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda37_ (self, source_object, res);
	block25_data_unref (self);
}

static void
contacts_main_window_cancel_operation_action (ContactsMainWindow* self,
                                              GSimpleAction* action,
                                              GVariant* parameter)
{
	Block25Data* _data25_;
	const gchar* _tmp0_;
	ContactsOperationList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = g_variant_get_string (parameter, NULL);
	_data25_->uuid = _tmp0_;
	_tmp1_ = self->priv->_operations;
	contacts_operation_list_cancel_operation (_tmp1_, _data25_->uuid, ___lambda37__gasync_ready_callback, block25_data_ref (_data25_));
	block25_data_unref (_data25_);
	_data25_ = NULL;
}

static void
contacts_main_window_stop_editing_contact (ContactsMainWindow* self,
                                           GSimpleAction* action,
                                           GVariant* parameter)
{
	gboolean cancel = FALSE;
	ContactsUiState _tmp0_;
	ContactsContactPane* _tmp1_;
	ContactsContactList* _tmp2_;
	AdwHeaderBar* _tmp3_;
	AdwWindowTitle* _tmp4_;
	AdwWindowTitle* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	cancel = g_variant_get_boolean (parameter);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == CONTACTS_UI_STATE_CREATING) {
		if (cancel) {
			contacts_main_window_show_list_pane (self);
		}
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	} else {
		contacts_main_window_show_contact_pane (self);
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_SHOWING);
	}
	_tmp1_ = self->priv->contact_pane;
	contacts_contact_pane_stop_editing (_tmp1_, cancel);
	_tmp2_ = self->priv->contacts_list;
	contacts_contact_list_scroll_to_selected (_tmp2_);
	_tmp3_ = self->priv->right_header;
	_tmp4_ = (AdwWindowTitle*) adw_window_title_new ("", "");
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	adw_header_bar_set_title_widget (_tmp3_, (GtkWidget*) _tmp5_);
	_g_object_unref0 (_tmp5_);
}

void
contacts_main_window_new_contact (ContactsMainWindow* self,
                                  GSimpleAction* action,
                                  GVariant* parameter)
{
	gboolean _tmp0_ = FALSE;
	ContactsUiState _tmp1_;
	ContactsStore* _tmp3_;
	GtkSingleSelection* _tmp4_;
	GtkSingleSelection* _tmp5_;
	ContactsStore* _tmp6_;
	GtkSingleSelection* _tmp7_;
	GtkSingleSelection* _tmp8_;
	AdwHeaderBar* _tmp9_;
	AdwWindowTitle* _tmp10_;
	AdwWindowTitle* _tmp11_;
	ContactsContactPane* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ == CONTACTS_UI_STATE_UPDATING) {
		_tmp0_ = TRUE;
	} else {
		ContactsUiState _tmp2_;
		_tmp2_ = self->priv->_state;
		_tmp0_ = _tmp2_ == CONTACTS_UI_STATE_CREATING;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->_store;
	_tmp4_ = contacts_store_get_selection (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_store;
	_tmp7_ = contacts_store_get_selection (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_selection_model_unselect_item ((GtkSelectionModel*) _tmp5_, gtk_single_selection_get_selected (_tmp8_));
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_CREATING);
	_tmp9_ = self->priv->right_header;
	_tmp10_ = (AdwWindowTitle*) adw_window_title_new (_ ("New Contact"), "");
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	adw_header_bar_set_title_widget (_tmp9_, (GtkWidget*) _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = self->priv->contact_pane;
	contacts_contact_pane_new_contact (_tmp12_);
	contacts_main_window_show_contact_pane (self);
}

static void
contacts_main_window_on_cancel_visible (ContactsMainWindow* self)
{
	g_return_if_fail (self != NULL);
	contacts_main_window_update_header (self);
}

static void
_contacts_main_window_on_cancel_visible_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	contacts_main_window_on_cancel_visible ((ContactsMainWindow*) self);
}

static void
contacts_main_window_on_folded (ContactsMainWindow* self)
{
	g_return_if_fail (self != NULL);
	contacts_main_window_update_header (self);
	contacts_main_window_on_visible_child (self);
}

static void
_contacts_main_window_on_folded_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	contacts_main_window_on_folded ((ContactsMainWindow*) self);
}

static void
contacts_main_window_on_visible_child (ContactsMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	AdwLeaflet* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->content_box;
	_tmp3_ = adw_leaflet_get_folded (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		AdwLeaflet* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->content_box;
		_tmp6_ = adw_leaflet_get_child_transition_running (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		AdwLeaflet* _tmp8_;
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		GtkBox* _tmp11_;
		_tmp8_ = self->priv->content_box;
		_tmp9_ = adw_leaflet_get_visible_child (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->list_pane_page;
		_tmp0_ = _tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ContactsStore* _tmp12_;
		GtkSingleSelection* _tmp13_;
		GtkSingleSelection* _tmp14_;
		ContactsStore* _tmp15_;
		GtkSingleSelection* _tmp16_;
		GtkSingleSelection* _tmp17_;
		_tmp12_ = self->priv->_store;
		_tmp13_ = contacts_store_get_selection (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = self->priv->_store;
		_tmp16_ = contacts_store_get_selection (_tmp15_);
		_tmp17_ = _tmp16_;
		gtk_selection_model_unselect_item ((GtkSelectionModel*) _tmp14_, gtk_single_selection_get_selected (_tmp17_));
	}
}

static void
_contacts_main_window_on_visible_child_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	contacts_main_window_on_visible_child ((ContactsMainWindow*) self);
}

static void
contacts_main_window_update_header (ContactsMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	AdwLeaflet* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkRevealer* _tmp12_;
	GtkRevealer* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->content_box;
	_tmp3_ = adw_leaflet_get_folded (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkButton* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->cancel_button;
		_tmp6_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		AdwLeaflet* _tmp8_;
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		GtkBox* _tmp11_;
		_tmp8_ = self->priv->content_box;
		_tmp9_ = adw_leaflet_get_visible_child (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->contact_pane_page;
		_tmp0_ = _tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp12_ = self->priv->back_revealer;
	_tmp13_ = self->priv->back_revealer;
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, _tmp0_);
	gtk_revealer_set_reveal_child (_tmp12_, _tmp0_);
}

static void
contacts_main_window_show_list_pane (ContactsMainWindow* self)
{
	AdwLeaflet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	adw_leaflet_navigate (_tmp0_, ADW_NAVIGATION_DIRECTION_BACK);
	contacts_main_window_update_header (self);
}

static void
contacts_main_window_show_contact_pane (ContactsMainWindow* self)
{
	AdwLeaflet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	adw_leaflet_navigate (_tmp0_, ADW_NAVIGATION_DIRECTION_FORWARD);
	contacts_main_window_update_header (self);
}

void
contacts_main_window_show_search (ContactsMainWindow* self,
                                  const gchar* query)
{
	GtkSearchEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_tmp0_ = self->filter_entry;
	gtk_editable_set_text ((GtkEditable*) _tmp0_, query);
}

static void
__lambda39_ (ContactsMainWindow* self)
{
	GtkMultiSelection* _tmp0_;
	ContactsStore* _tmp1_;
	GtkSingleSelection* _tmp2_;
	GtkSingleSelection* _tmp3_;
	_tmp0_ = self->priv->marked_contacts;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp0_);
	_tmp1_ = self->priv->_store;
	_tmp2_ = contacts_store_get_selection (_tmp1_);
	_tmp3_ = _tmp2_;
	if (gtk_single_selection_get_selected (_tmp3_) != GTK_INVALID_LIST_POSITION) {
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_SHOWING);
	} else {
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	}
}

static void
___lambda39__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda39_ ((ContactsMainWindow*) self);
}

static void
contacts_main_window_connect_button_signals (ContactsMainWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->select_cancel_button;
	g_signal_connect_object (_tmp0_, "clicked", (GCallback) ___lambda39__gtk_button_clicked, self, 0);
}

static gboolean
contacts_main_window_real_close_request (GtkWindow* base)
{
	ContactsMainWindow * self;
	ContactsContactPane* _tmp0_;
	ContactsSettings* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ContactsSettings* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ContactsSettings* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	ContactsSettings* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean result;
	self = (ContactsMainWindow*) base;
	_tmp0_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp0_, NULL);
	_tmp1_ = self->priv->_settings;
	g_object_get ((GtkWindow*) self, "default-width", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	contacts_settings_set_window_width (_tmp1_, _tmp3_);
	_tmp4_ = self->priv->_settings;
	g_object_get ((GtkWindow*) self, "default-height", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	contacts_settings_set_window_height (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->_settings;
	g_object_get ((GtkWindow*) self, "maximized", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	contacts_settings_set_window_maximized (_tmp7_, _tmp9_);
	_tmp10_ = self->priv->_settings;
	g_object_get ((GtkWindow*) self, "fullscreened", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	contacts_settings_set_window_fullscreen (_tmp10_, _tmp12_);
	result = GTK_WINDOW_CLASS (contacts_main_window_parent_class)->close_request ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_window_get_type (), AdwApplicationWindow));
	return result;
}

static void
contacts_main_window_on_selection_changed (ContactsMainWindow* self,
                                           GObject* object,
                                           GParamSpec* pspec)
{
	FolksIndividual* selected = NULL;
	ContactsStore* _tmp0_;
	FolksIndividual* _tmp1_;
	GAction* unlink_action = NULL;
	GAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	FolksIndividual* _tmp4_;
	GAction* _tmp10_;
	ContactsUiState _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_store_get_selected_contact (_tmp0_);
	selected = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "unlink-contact");
	unlink_action = _tmp2_;
	_tmp4_ = selected;
	if (_tmp4_ != NULL) {
		FolksIndividual* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp5_ = selected;
		_tmp6_ = folks_individual_get_personas (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = _tmp9_ > 1;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp10_ = unlink_action;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_simple_action_get_type (), GSimpleAction), _tmp3_);
	_tmp11_ = self->priv->_state;
	if (_tmp11_ != CONTACTS_UI_STATE_SELECTING) {
		ContactsContactPane* _tmp12_;
		ContactsContactPane* _tmp15_;
		FolksIndividual* _tmp16_;
		FolksIndividual* _tmp17_;
		AdwHeaderBar* _tmp18_;
		AdwWindowTitle* _tmp19_;
		AdwWindowTitle* _tmp20_;
		FolksIndividual* _tmp21_;
		_tmp12_ = self->priv->contact_pane;
		if (_tmp12_->on_edit_mode) {
			GVariant* _tmp13_;
			GVariant* _tmp14_;
			_tmp13_ = g_variant_new_boolean (FALSE);
			g_variant_ref_sink (_tmp13_);
			_tmp14_ = _tmp13_;
			g_action_group_activate_action ((GActionGroup*) self, "stop-editing-contact", _tmp14_);
			_g_variant_unref0 (_tmp14_);
		}
		_tmp15_ = self->priv->contact_pane;
		_tmp16_ = selected;
		contacts_contact_pane_show_contact (_tmp15_, _tmp16_);
		_tmp17_ = selected;
		if (_tmp17_ != NULL) {
			contacts_main_window_show_contact_pane (self);
		}
		_tmp18_ = self->priv->right_header;
		_tmp19_ = (AdwWindowTitle*) adw_window_title_new ("", "");
		g_object_ref_sink (_tmp19_);
		_tmp20_ = _tmp19_;
		adw_header_bar_set_title_widget (_tmp18_, (GtkWidget*) _tmp20_);
		_g_object_unref0 (_tmp20_);
		_tmp21_ = selected;
		if (_tmp21_ != NULL) {
			GtkToggleButton* _tmp22_;
			FolksIndividual* _tmp23_;
			gboolean _tmp24_;
			gboolean _tmp25_;
			FolksIndividual* _tmp26_;
			gboolean _tmp27_;
			gboolean _tmp28_;
			self->priv->ignore_favorite_button_toggled = TRUE;
			_tmp22_ = self->priv->favorite_button;
			_tmp23_ = selected;
			_tmp24_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp23_);
			_tmp25_ = _tmp24_;
			gtk_toggle_button_set_active (_tmp22_, _tmp25_);
			self->priv->ignore_favorite_button_toggled = FALSE;
			_tmp26_ = selected;
			_tmp27_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp26_);
			_tmp28_ = _tmp27_;
			if (_tmp28_) {
				GtkToggleButton* _tmp29_;
				_tmp29_ = self->priv->favorite_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp29_, _ ("Unmark as favorite"));
			} else {
				GtkToggleButton* _tmp30_;
				_tmp30_ = self->priv->favorite_button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp30_, _ ("Mark as favorite"));
			}
		}
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_SHOWING);
	}
}

static void
__lambda30_ (ContactsMainWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_execute_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:483: Error linking individuals: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda30__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda30_ ((ContactsMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_main_window_link_marked_contacts (ContactsMainWindow* self,
                                           GSimpleAction* action,
                                           GVariant* parameter)
{
	GtkBitset* selection = NULL;
	GtkMultiSelection* _tmp0_;
	GtkBitset* _tmp1_;
	GtkBitset* _tmp2_;
	GtkBitset* _tmp3_;
	GtkBitset* _tmp4_;
	ContactsStore* _tmp5_;
	GtkSingleSelection* _tmp6_;
	GtkSingleSelection* _tmp7_;
	ContactsStore* _tmp8_;
	GtkSingleSelection* _tmp9_;
	GtkSingleSelection* _tmp10_;
	GtkMultiSelection* _tmp11_;
	ContactsContactList* _tmp12_;
	ContactsContactPane* _tmp13_;
	GeeLinkedList* list = NULL;
	GtkMultiSelection* _tmp14_;
	GeeLinkedList* _tmp15_;
	ContactsLinkOperation* operation = NULL;
	ContactsStore* _tmp16_;
	ContactsLinkOperation* _tmp17_;
	ContactsOperationList* _tmp18_;
	AdwToast* _tmp19_;
	AdwToast* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->marked_contacts;
	_tmp1_ = gtk_selection_model_get_selection ((GtkSelectionModel*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_bitset_copy (_tmp2_);
	_tmp4_ = _tmp3_;
	_gtk_bitset_unref0 (_tmp2_);
	selection = _tmp4_;
	_tmp5_ = self->priv->_store;
	_tmp6_ = contacts_store_get_selection (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->_store;
	_tmp9_ = contacts_store_get_selection (_tmp8_);
	_tmp10_ = _tmp9_;
	gtk_selection_model_unselect_item ((GtkSelectionModel*) _tmp7_, gtk_single_selection_get_selected (_tmp10_));
	_tmp11_ = self->priv->marked_contacts;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp11_);
	_tmp12_ = self->priv->contacts_list;
	contacts_contact_list_set_contacts_visible (_tmp12_, selection, FALSE);
	_tmp13_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp13_, NULL);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	contacts_main_window_show_list_pane (self);
	_tmp14_ = self->priv->marked_contacts;
	_tmp15_ = contacts_main_window_bitset_to_individuals (self, (GListModel*) _tmp14_, selection);
	list = _tmp15_;
	_tmp16_ = self->priv->_store;
	_tmp17_ = contacts_link_operation_new (_tmp16_, list);
	operation = _tmp17_;
	_tmp18_ = self->priv->_operations;
	contacts_operation_list_execute (_tmp18_, (ContactsOperation*) operation, NULL, ___lambda30__gasync_ready_callback, g_object_ref (self));
	_tmp19_ = contacts_main_window_add_toast_for_operation (self, (ContactsOperation*) operation, "win.undo-operation", _ ("_Undo"));
	_tmp20_ = _tmp19_;
	_g_object_unref0 (_tmp20_);
	_g_object_unref0 (operation);
	_g_object_unref0 (list);
	_gtk_bitset_unref0 (selection);
}

static void
contacts_main_window_delete_marked_contacts (ContactsMainWindow* self,
                                             GSimpleAction* action,
                                             GVariant* parameter)
{
	GtkBitset* selection = NULL;
	GtkMultiSelection* _tmp0_;
	GtkBitset* _tmp1_;
	GtkBitset* _tmp2_;
	GtkBitset* _tmp3_;
	GtkBitset* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->marked_contacts;
	_tmp1_ = gtk_selection_model_get_selection ((GtkSelectionModel*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_bitset_copy (_tmp2_);
	_tmp4_ = _tmp3_;
	_gtk_bitset_unref0 (_tmp2_);
	selection = _tmp4_;
	contacts_main_window_delete_contacts (self, selection);
	_gtk_bitset_unref0 (selection);
}

static gpointer
_gtk_bitset_ref0 (gpointer self)
{
	return self ? gtk_bitset_ref (self) : NULL;
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		ContactsMainWindow* self;
		self = _data26_->self;
		_gtk_bitset_unref0 (_data26_->selection);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static void
__lambda31_ (Block26Data* _data26_,
             GCancellable* c)
{
	ContactsMainWindow* self;
	ContactsContactList* _tmp0_;
	self = _data26_->self;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->contacts_list;
	contacts_contact_list_set_contacts_visible (_tmp0_, _data26_->selection, TRUE);
}

static void
___lambda31__g_cancellable_cancelled (GCancellable* _sender,
                                      gpointer self)
{
	__lambda31_ (self, _sender);
}

static void
__lambda32_ (ContactsMainWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_execute_with_timeout_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:521: Error removing individuals: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda32__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda32_ ((ContactsMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_main_window_delete_contacts (ContactsMainWindow* self,
                                      GtkBitset* selection)
{
	Block26Data* _data26_;
	GtkBitset* _tmp0_;
	ContactsStore* _tmp1_;
	GtkSingleSelection* _tmp2_;
	GtkSingleSelection* _tmp3_;
	ContactsStore* _tmp4_;
	GtkSingleSelection* _tmp5_;
	GtkSingleSelection* _tmp6_;
	GtkMultiSelection* _tmp7_;
	ContactsContactList* _tmp8_;
	ContactsContactPane* _tmp9_;
	GeeLinkedList* individuals = NULL;
	ContactsStore* _tmp10_;
	GtkFilterListModel* _tmp11_;
	GtkFilterListModel* _tmp12_;
	GeeLinkedList* _tmp13_;
	ContactsDeleteOperation* op = NULL;
	ContactsDeleteOperation* _tmp14_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp15_;
	AdwToast* toast = NULL;
	AdwToast* _tmp16_;
	ContactsOperationList* _tmp17_;
	guint _tmp18_;
	guint _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	_tmp0_ = _gtk_bitset_ref0 (selection);
	_gtk_bitset_unref0 (_data26_->selection);
	_data26_->selection = _tmp0_;
	_tmp1_ = self->priv->_store;
	_tmp2_ = contacts_store_get_selection (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_store;
	_tmp5_ = contacts_store_get_selection (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_selection_model_unselect_item ((GtkSelectionModel*) _tmp3_, gtk_single_selection_get_selected (_tmp6_));
	_tmp7_ = self->priv->marked_contacts;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp7_);
	_tmp8_ = self->priv->contacts_list;
	contacts_contact_list_set_contacts_visible (_tmp8_, _data26_->selection, FALSE);
	_tmp9_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp9_, NULL);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	contacts_main_window_show_list_pane (self);
	_tmp10_ = self->priv->_store;
	_tmp11_ = contacts_store_get_filter_model (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = contacts_main_window_bitset_to_individuals (self, (GListModel*) _tmp12_, _data26_->selection);
	individuals = _tmp13_;
	_tmp14_ = contacts_delete_operation_new ((GeeList*) individuals);
	op = _tmp14_;
	_tmp15_ = g_cancellable_new ();
	cancellable = _tmp15_;
	g_signal_connect_data (cancellable, "cancelled", (GCallback) ___lambda31__g_cancellable_cancelled, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
	_tmp16_ = contacts_main_window_add_toast_for_operation (self, (ContactsOperation*) op, "win.cancel-operation", _ ("_Cancel"));
	toast = _tmp16_;
	_tmp17_ = self->priv->_operations;
	_tmp18_ = adw_toast_get_timeout (toast);
	_tmp19_ = _tmp18_;
	contacts_operation_list_execute_with_timeout (_tmp17_, (ContactsOperation*) op, _tmp19_, cancellable, ___lambda32__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (toast);
	_g_object_unref0 (cancellable);
	_g_object_unref0 (op);
	_g_object_unref0 (individuals);
	block26_data_unref (_data26_);
	_data26_ = NULL;
}

static void
__lambda38_ (ContactsMainWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_execute_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:533: Error linking individuals: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda38__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda38_ ((ContactsMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_main_window_contact_pane_contacts_linked_cb (ContactsMainWindow* self,
                                                      ContactsLinkOperation* operation)
{
	AdwToast* _tmp0_;
	AdwToast* _tmp1_;
	ContactsOperationList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	_tmp0_ = contacts_main_window_add_toast_for_operation (self, (ContactsOperation*) operation, "win.undo-operation", _ ("_Undo"));
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_operations;
	contacts_operation_list_execute (_tmp2_, (ContactsOperation*) operation, NULL, ___lambda38__gasync_ready_callback, g_object_ref (self));
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static AdwToast*
contacts_main_window_add_toast_for_operation (ContactsMainWindow* self,
                                              ContactsOperation* operation,
                                              const gchar* action_name,
                                              const gchar* action_label)
{
	AdwToast* toast = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	AdwToast* _tmp3_;
	AdwToast* _tmp4_;
	AdwToastOverlay* _tmp11_;
	AdwToast* _tmp12_;
	AdwToast* _tmp13_;
	AdwToast* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (operation != NULL, NULL);
	_tmp0_ = contacts_operation_get_description (operation);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = adw_toast_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	toast = _tmp4_;
	if (action_name != NULL) {
		AdwToast* _tmp5_;
		AdwToast* _tmp6_;
		AdwToast* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GVariant* _tmp10_;
		_tmp5_ = toast;
		adw_toast_set_button_label (_tmp5_, action_label);
		_tmp6_ = toast;
		adw_toast_set_action_name (_tmp6_, action_name);
		_tmp7_ = toast;
		_tmp8_ = contacts_operation_get_uuid (operation);
		_tmp9_ = _tmp8_;
		_tmp10_ = _variant_new1 (_tmp9_);
		g_object_set (_tmp7_, "action-target", _tmp10_, NULL);
		_g_variant_unref0 (_tmp10_);
	}
	_tmp11_ = self->priv->toast_overlay;
	_tmp12_ = toast;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	adw_toast_overlay_add_toast (_tmp11_, _tmp13_);
	result = toast;
	return result;
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		ContactsMainWindow* self;
		self = _data27_->self;
		_g_object_unref0 (_data27_->chooser);
		_gtk_bitset_unref0 (_data27_->selection);
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		ContactsMainWindow* self;
		self = _data28_->_data27_->self;
		_g_object_unref0 (_data28_->filestream);
		block27_data_unref (_data28_->_data27_);
		_data28_->_data27_ = NULL;
		g_slice_free (Block28Data, _data28_);
	}
}

static void
__lambda34_ (Block28Data* _data28_,
             GObject* obj,
             GAsyncResult* res)
{
	Block27Data* _data27_;
	ContactsMainWindow* self;
	GError* _inner_error0_ = NULL;
	_data27_ = _data28_->_data27_;
	self = _data27_->self;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		GOutputStream* _tmp1_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_execute_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = _data28_->filestream;
		g_output_stream_close (_tmp1_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("contacts-main-window.vala:592: ERROR: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda34__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda34_ (self, source_object, res);
	block28_data_unref (self);
}

static void
__lambda33_ (Block27Data* _data27_,
             gint response)
{
	ContactsMainWindow* self;
	Block28Data* _data28_;
	GeeLinkedList* individuals = NULL;
	ContactsStore* _tmp0_;
	GtkFilterListModel* _tmp1_;
	GtkFilterListModel* _tmp2_;
	GeeLinkedList* _tmp3_;
	ContactsIoVCardExportOperation* op = NULL;
	GeeLinkedList* _tmp12_;
	GOutputStream* _tmp13_;
	ContactsIoVCardExportOperation* _tmp14_;
	ContactsOperationList* _tmp15_;
	ContactsIoVCardExportOperation* _tmp16_;
	ContactsIoVCardExportOperation* _tmp17_;
	AdwToast* _tmp18_;
	AdwToast* _tmp19_;
	GError* _inner_error0_ = NULL;
	self = _data27_->self;
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->_data27_ = block27_data_ref (_data27_);
	if (response != ((gint) GTK_RESPONSE_ACCEPT)) {
		gtk_native_dialog_destroy ((GtkNativeDialog*) _data27_->chooser);
		block28_data_unref (_data28_);
		_data28_ = NULL;
		return;
	}
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_store_get_filter_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = contacts_main_window_bitset_to_individuals (self, (GListModel*) _tmp2_, _data27_->selection);
	individuals = _tmp3_;
	_data28_->filestream = NULL;
	{
		GFileOutputStream* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFileOutputStream* _tmp7_;
		GFileOutputStream* _tmp8_;
		GFileOutputStream* _tmp9_;
		_tmp5_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data27_->chooser);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_replace (_tmp6_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_tmp4_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (_data28_->filestream);
		_data28_->filestream = (GOutputStream*) _tmp9_;
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = err;
		_tmp11_ = _tmp10_->message;
		g_warning ("contacts-main-window.vala:582: Couldn't create file: %s", _tmp11_);
		_g_error_free0 (err);
		_g_object_unref0 (individuals);
		block28_data_unref (_data28_);
		_data28_ = NULL;
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (individuals);
		block28_data_unref (_data28_);
		_data28_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp12_ = individuals;
	_tmp13_ = _data28_->filestream;
	_tmp14_ = contacts_io_vcard_export_operation_new ((GeeList*) _tmp12_, _tmp13_);
	op = _tmp14_;
	_tmp15_ = self->priv->_operations;
	_tmp16_ = op;
	contacts_operation_list_execute (_tmp15_, (ContactsOperation*) _tmp16_, NULL, ___lambda34__gasync_ready_callback, block28_data_ref (_data28_));
	gtk_native_dialog_destroy ((GtkNativeDialog*) _data27_->chooser);
	_tmp17_ = op;
	_tmp18_ = contacts_main_window_add_toast_for_operation (self, (ContactsOperation*) _tmp17_, NULL, NULL);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp19_);
	_g_object_unref0 (op);
	_g_object_unref0 (individuals);
	block28_data_unref (_data28_);
	_data28_ = NULL;
}

static void
___lambda33__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	__lambda33_ (self, response_id);
}

static void
contacts_main_window_export_marked_contacts (ContactsMainWindow* self,
                                             GSimpleAction* action,
                                             GVariant* parameter)
{
	Block27Data* _data27_;
	GtkMultiSelection* _tmp0_;
	GtkBitset* _tmp1_;
	GtkBitset* _tmp2_;
	GtkBitset* _tmp3_;
	GtkBitset* _tmp4_;
	ContactsStore* _tmp5_;
	GtkSingleSelection* _tmp6_;
	GtkSingleSelection* _tmp7_;
	ContactsStore* _tmp8_;
	GtkSingleSelection* _tmp9_;
	GtkSingleSelection* _tmp10_;
	GtkMultiSelection* _tmp11_;
	GtkFileChooserNative* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->self = g_object_ref (self);
	_tmp0_ = self->priv->marked_contacts;
	_tmp1_ = gtk_selection_model_get_selection ((GtkSelectionModel*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_bitset_copy (_tmp2_);
	_tmp4_ = _tmp3_;
	_gtk_bitset_unref0 (_tmp2_);
	_data27_->selection = _tmp4_;
	_tmp5_ = self->priv->_store;
	_tmp6_ = contacts_store_get_selection (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->_store;
	_tmp9_ = contacts_store_get_selection (_tmp8_);
	_tmp10_ = _tmp9_;
	gtk_selection_model_unselect_item ((GtkSelectionModel*) _tmp7_, gtk_single_selection_get_selected (_tmp10_));
	_tmp11_ = self->priv->marked_contacts;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp11_);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	_tmp12_ = gtk_file_chooser_native_new (_ ("Export to file"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Export"), _ ("_Cancel"));
	_data27_->chooser = _tmp12_;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _data27_->chooser, _ ("contacts.vcf"));
	gtk_native_dialog_set_modal ((GtkNativeDialog*) _data27_->chooser, TRUE);
	g_signal_connect_data ((GtkNativeDialog*) _data27_->chooser, "response", (GCallback) ___lambda33__gtk_native_dialog_response, block27_data_ref (_data27_), (GClosureNotify) block27_data_unref, 0);
	gtk_native_dialog_show ((GtkNativeDialog*) _data27_->chooser);
	block27_data_unref (_data27_);
	_data27_ = NULL;
}

static GeeLinkedList*
contacts_main_window_bitset_to_individuals (ContactsMainWindow* self,
                                            GListModel* model,
                                            GtkBitset* bitset)
{
	GeeLinkedList* list = NULL;
	GeeLinkedList* _tmp0_;
	GtkBitsetIter iter = {0};
	guint index = 0U;
	guint _tmp1_ = 0U;
	gboolean _tmp2_;
	GeeLinkedList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (bitset != NULL, NULL);
	_tmp0_ = gee_linked_list_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	memset (&iter, 0, sizeof (GtkBitsetIter));
	_tmp2_ = gtk_bitset_iter_init_first (&iter, bitset, &_tmp1_);
	index = _tmp1_;
	if (!_tmp2_) {
		result = list;
		return result;
	}
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			GeeLinkedList* _tmp6_;
			GObject* _tmp7_;
			FolksIndividual* _tmp8_;
			if (!_tmp3_) {
				guint _tmp4_ = 0U;
				gboolean _tmp5_;
				_tmp5_ = gtk_bitset_iter_next (&iter, &_tmp4_);
				index = _tmp4_;
				if (!_tmp5_) {
					break;
				}
			}
			_tmp3_ = FALSE;
			_tmp6_ = list;
			_tmp7_ = g_list_model_get_item (model, index);
			_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp8_);
			_g_object_unref0 (_tmp8_);
		}
	}
	result = list;
	return result;
}

static void
contacts_main_window_filter_entry_changed (ContactsMainWindow* self,
                                           GtkEditable* editable)
{
	FolksSimpleQuery* query = NULL;
	ContactsStore* _tmp0_;
	ContactsQueryFilter* _tmp1_;
	ContactsQueryFilter* _tmp2_;
	FolksQuery* _tmp3_;
	FolksQuery* _tmp4_;
	GtkSearchEntry* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_store_get_filter (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = contacts_query_filter_get_query (_tmp2_);
	_tmp4_ = _tmp3_;
	query = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, FOLKS_TYPE_SIMPLE_QUERY) ? ((FolksSimpleQuery*) _tmp4_) : NULL;
	_tmp5_ = self->filter_entry;
	_tmp6_ = gtk_editable_get_text ((GtkEditable*) _tmp5_);
	_tmp7_ = _tmp6_;
	folks_simple_query_set_query_string (query, _tmp7_);
}

static void
_contacts_main_window_filter_entry_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                            gpointer self)
{
	contacts_main_window_filter_entry_changed ((ContactsMainWindow*) self, _sender);
}

ContactsUiState
contacts_main_window_get_state (ContactsMainWindow* self)
{
	ContactsUiState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
contacts_main_window_set_state (ContactsMainWindow* self,
                                ContactsUiState value)
{
	ContactsUiState old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_STATE_PROPERTY]);
	}
}

gint
contacts_main_window_get_window_width (ContactsMainWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_window_width;
	return result;
}

void
contacts_main_window_set_window_width (ContactsMainWindow* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_window_width (self);
	if (old_value != value) {
		self->priv->_window_width = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY]);
	}
}

gint
contacts_main_window_get_window_height (ContactsMainWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_window_height;
	return result;
}

void
contacts_main_window_set_window_height (ContactsMainWindow* self,
                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_window_height (self);
	if (old_value != value) {
		self->priv->_window_height = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY]);
	}
}

ContactsSettings*
contacts_main_window_get_settings (ContactsMainWindow* self)
{
	ContactsSettings* result;
	ContactsSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
contacts_main_window_set_settings (ContactsMainWindow* self,
                                   ContactsSettings* value)
{
	ContactsSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_settings (self);
	if (old_value != value) {
		ContactsSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY]);
	}
}

ContactsStore*
contacts_main_window_get_store (ContactsMainWindow* self)
{
	ContactsStore* result;
	ContactsStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}

void
contacts_main_window_set_store (ContactsMainWindow* self,
                                ContactsStore* value)
{
	ContactsStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_store (self);
	if (old_value != value) {
		ContactsStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_store);
		self->priv->_store = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_STORE_PROPERTY]);
	}
}

ContactsOperationList*
contacts_main_window_get_operations (ContactsMainWindow* self)
{
	ContactsOperationList* result;
	ContactsOperationList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operations;
	result = _tmp0_;
	return result;
}

void
contacts_main_window_set_operations (ContactsMainWindow* self,
                                     ContactsOperationList* value)
{
	ContactsOperationList* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_operations (self);
	if (old_value != value) {
		ContactsOperationList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_operations);
		self->priv->_operations = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_OPERATIONS_PROPERTY]);
	}
}

static void
_contacts_main_window_on_selection_changed_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	contacts_main_window_on_selection_changed ((ContactsMainWindow*) self, _sender, pspec);
}

static void
_contacts_main_window_on_marked_contacts_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                                        guint position,
                                                                                        guint n_items,
                                                                                        gpointer self)
{
	contacts_main_window_on_marked_contacts_changed ((ContactsMainWindow*) self, _sender, position, n_items);
}

static void
_contacts_main_window_on_ui_state_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	contacts_main_window_on_ui_state_changed ((ContactsMainWindow*) self, _sender, pspec);
}

static GObject *
contacts_main_window_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsMainWindow * self;
	ContactsStore* _tmp0_;
	GtkSingleSelection* _tmp1_;
	GtkSingleSelection* _tmp2_;
	ContactsStore* _tmp3_;
	GtkFilterListModel* _tmp4_;
	GtkFilterListModel* _tmp5_;
	GListModel* _tmp6_;
	GtkMultiSelection* _tmp7_;
	GtkMultiSelection* _tmp8_;
	GtkMultiSelection* _tmp9_;
	GtkSearchEntry* _tmp10_;
	parent_class = G_OBJECT_CLASS (contacts_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow);
	g_action_map_add_action_entries ((GActionMap*) self, CONTACTS_MAIN_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (CONTACTS_MAIN_WINDOW_ACTION_ENTRIES), self);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_store_get_selection (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::selected-item", (GCallback) _contacts_main_window_on_selection_changed_g_object_notify, self, 0);
	_tmp3_ = self->priv->_store;
	_tmp4_ = contacts_store_get_filter_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 ((GListModel*) _tmp5_);
	_tmp7_ = gtk_multi_selection_new (_tmp6_);
	_g_object_unref0 (self->priv->marked_contacts);
	self->priv->marked_contacts = _tmp7_;
	_tmp8_ = self->priv->marked_contacts;
	g_signal_connect_object ((GtkSelectionModel*) _tmp8_, "selection-changed", (GCallback) _contacts_main_window_on_marked_contacts_changed_gtk_selection_model_selection_changed, self, 0);
	_tmp9_ = self->priv->marked_contacts;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp9_);
	_tmp10_ = self->filter_entry;
	gtk_search_entry_set_key_capture_widget (_tmp10_, (GtkWidget*) self);
	g_signal_connect_object ((GObject*) self, "notify::state", (GCallback) _contacts_main_window_on_ui_state_changed_g_object_notify, self, 0);
	contacts_main_window_create_list_pane (self);
	contacts_main_window_create_contact_pane (self);
	contacts_main_window_connect_button_signals (self);
	contacts_main_window_restore_window_state (self);
	if (g_strcmp0 (PROFILE, "development") == 0) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
	}
	return obj;
}

static void
contacts_main_window_class_init (ContactsMainWindowClass * klass,
                                 gpointer klass_data)
{
	contacts_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsMainWindow_private_offset);
	((GtkWindowClass *) klass)->close_request = (gboolean (*) (GtkWindow*)) contacts_main_window_real_close_request;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_main_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_STATE_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", CONTACTS_TYPE_UI_STATE, CONTACTS_UI_STATE_NORMAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY] = g_param_spec_int ("window-width", "window-width", "window-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY] = g_param_spec_int ("window-height", "window-height", "window-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", CONTACTS_TYPE_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_STORE_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_STORE_PROPERTY] = g_param_spec_object ("store", "store", "store", CONTACTS_TYPE_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_OPERATIONS_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_OPERATIONS_PROPERTY] = g_param_spec_object ("operations", "operations", "operations", CONTACTS_TYPE_OPERATION_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-main-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_box", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, content_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_revealer", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, back_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_pane_stack", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, list_pane_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_pane_container", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, contact_pane_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_pane_page", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, list_pane_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_pane", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, list_pane));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "filter_entry", FALSE, G_STRUCT_OFFSET (ContactsMainWindow, filter_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contacts_list_container", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, contacts_list_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_pane_page", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, contact_pane_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "left_header", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, left_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "right_header", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, right_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toast_overlay", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, toast_overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "select_cancel_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, select_cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hamburger_menu_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, hamburger_menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_sheet_buttons", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, contact_sheet_buttons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "favorite_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, favorite_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, add_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "done_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, done_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "selection_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, selection_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "actions_bar", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, actions_bar));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_back_clicked", G_CALLBACK(_contacts_main_window_on_back_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_favorite_button_toggled", G_CALLBACK(_contacts_main_window_on_favorite_button_toggled_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_selection_button_clicked", G_CALLBACK(_contacts_main_window_on_selection_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_cancel_visible", G_CALLBACK(_contacts_main_window_on_cancel_visible_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_folded", G_CALLBACK(_contacts_main_window_on_folded_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_visible_child", G_CALLBACK(_contacts_main_window_on_visible_child_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "filter_entry_changed", G_CALLBACK(_contacts_main_window_filter_entry_changed_gtk_search_entry_search_changed));
}

static void
contacts_main_window_instance_init (ContactsMainWindow * self,
                                    gpointer klass)
{
	self->priv = contacts_main_window_get_instance_private (self);
	self->priv->_state = CONTACTS_UI_STATE_NORMAL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_main_window_finalize (GObject * obj)
{
	ContactsMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow);
	_g_object_unref0 (self->priv->contact_pane);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_store);
	_g_object_unref0 (self->priv->_operations);
	_g_object_unref0 (self->priv->marked_contacts);
	G_OBJECT_CLASS (contacts_main_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsMainWindow), 0, (GInstanceInitFunc) contacts_main_window_instance_init, NULL };
	GType contacts_main_window_type_id;
	contacts_main_window_type_id = g_type_register_static (adw_application_window_get_type (), "ContactsMainWindow", &g_define_type_info, 0);
	ContactsMainWindow_private_offset = g_type_add_instance_private (contacts_main_window_type_id, sizeof (ContactsMainWindowPrivate));
	return contacts_main_window_type_id;
}

GType
contacts_main_window_get_type (void)
{
	static volatile gsize contacts_main_window_type_id__once = 0;
	if (g_once_init_enter (&contacts_main_window_type_id__once)) {
		GType contacts_main_window_type_id;
		contacts_main_window_type_id = contacts_main_window_get_type_once ();
		g_once_init_leave (&contacts_main_window_type_id__once, contacts_main_window_type_id);
	}
	return contacts_main_window_type_id__once;
}

static void
_vala_contacts_main_window_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	ContactsMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow);
	switch (property_id) {
		case CONTACTS_MAIN_WINDOW_STATE_PROPERTY:
		g_value_set_enum (value, contacts_main_window_get_state (self));
		break;
		case CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY:
		g_value_set_int (value, contacts_main_window_get_window_width (self));
		break;
		case CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY:
		g_value_set_int (value, contacts_main_window_get_window_height (self));
		break;
		case CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY:
		g_value_set_object (value, contacts_main_window_get_settings (self));
		break;
		case CONTACTS_MAIN_WINDOW_STORE_PROPERTY:
		g_value_set_object (value, contacts_main_window_get_store (self));
		break;
		case CONTACTS_MAIN_WINDOW_OPERATIONS_PROPERTY:
		g_value_set_object (value, contacts_main_window_get_operations (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_main_window_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	ContactsMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow);
	switch (property_id) {
		case CONTACTS_MAIN_WINDOW_STATE_PROPERTY:
		contacts_main_window_set_state (self, g_value_get_enum (value));
		break;
		case CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY:
		contacts_main_window_set_window_width (self, g_value_get_int (value));
		break;
		case CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY:
		contacts_main_window_set_window_height (self, g_value_get_int (value));
		break;
		case CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY:
		contacts_main_window_set_settings (self, g_value_get_object (value));
		break;
		case CONTACTS_MAIN_WINDOW_STORE_PROPERTY:
		contacts_main_window_set_store (self, g_value_get_object (value));
		break;
		case CONTACTS_MAIN_WINDOW_OPERATIONS_PROPERTY:
		contacts_main_window_set_operations (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

