/* contacts-io-vcard-parser.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-io-vcard-parser.vala, do not modify */

/*
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libebook-contacts/libebook-contacts.h>
#include <folks/folks.h>
#include <gee.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_IO_TYPE_PARSER (contacts_io_parser_get_type ())
#define CONTACTS_IO_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_IO_TYPE_PARSER, ContactsIoParser))
#define CONTACTS_IO_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_IO_TYPE_PARSER, ContactsIoParserClass))
#define CONTACTS_IO_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_IO_TYPE_PARSER))
#define CONTACTS_IO_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_IO_TYPE_PARSER))
#define CONTACTS_IO_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_IO_TYPE_PARSER, ContactsIoParserClass))

typedef struct _ContactsIoParser ContactsIoParser;
typedef struct _ContactsIoParserClass ContactsIoParserClass;
typedef struct _ContactsIoParserPrivate ContactsIoParserPrivate;

#define CONTACTS_IO_TYPE_VCARD_PARSER (contacts_io_vcard_parser_get_type ())
#define CONTACTS_IO_VCARD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_IO_TYPE_VCARD_PARSER, ContactsIoVCardParser))
#define CONTACTS_IO_VCARD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_IO_TYPE_VCARD_PARSER, ContactsIoVCardParserClass))
#define CONTACTS_IO_IS_VCARD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_IO_TYPE_VCARD_PARSER))
#define CONTACTS_IO_IS_VCARD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_IO_TYPE_VCARD_PARSER))
#define CONTACTS_IO_VCARD_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_IO_TYPE_VCARD_PARSER, ContactsIoVCardParserClass))

typedef struct _ContactsIoVCardParser ContactsIoVCardParser;
typedef struct _ContactsIoVCardParserClass ContactsIoVCardParserClass;
typedef struct _ContactsIoVCardParserPrivate ContactsIoVCardParserPrivate;
enum  {
	CONTACTS_IO_VCARD_PARSER_0_PROPERTY,
	CONTACTS_IO_VCARD_PARSER_NUM_PROPERTIES
};
static GParamSpec* contacts_io_vcard_parser_properties[CONTACTS_IO_VCARD_PARSER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define __vala_EContactDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactDate_free (var), NULL)))

struct _ContactsIoParser {
	GObject parent_instance;
	ContactsIoParserPrivate * priv;
};

struct _ContactsIoParserClass {
	GObjectClass parent_class;
	GHashTable** (*parse) (ContactsIoParser* self, GInputStream* input, gint* result_length1, GError** error);
};

struct _ContactsIoVCardParser {
	ContactsIoParser parent_instance;
	ContactsIoVCardParserPrivate * priv;
};

struct _ContactsIoVCardParserClass {
	ContactsIoParserClass parent_class;
};

static gpointer contacts_io_vcard_parser_parent_class = NULL;

VALA_EXTERN GType contacts_io_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsIoParser, g_object_unref)
VALA_EXTERN GType contacts_io_vcard_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsIoVCardParser, g_object_unref)
VALA_EXTERN GHashTable** contacts_io_parser_parse (ContactsIoParser* self,
                                       GInputStream* input,
                                       gint* result_length1,
                                       GError** error);
VALA_EXTERN ContactsIoVCardParser* contacts_io_vcard_parser_new (void);
VALA_EXTERN ContactsIoVCardParser* contacts_io_vcard_parser_construct (GType object_type);
VALA_EXTERN ContactsIoParser* contacts_io_parser_construct (GType object_type);
static GHashTable** contacts_io_vcard_parser_real_parse (ContactsIoParser* base,
                                                  GInputStream* input,
                                                  gint* result_length1,
                                                  GError** error);
static void _g_hash_table_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static void contacts_io_vcard_parser_handle_fn (ContactsIoVCardParser* self,
                                         GHashTable* details,
                                         EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_n (ContactsIoVCardParser* self,
                                        GHashTable* details,
                                        EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_nickname (ContactsIoVCardParser* self,
                                               GHashTable* details,
                                               EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_bday (ContactsIoVCardParser* self,
                                           GHashTable* details,
                                           EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_adr (ContactsIoVCardParser* self,
                                          GHashTable* details,
                                          EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_tel (ContactsIoVCardParser* self,
                                          GHashTable* details,
                                          EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_email (ContactsIoVCardParser* self,
                                            GHashTable* details,
                                            EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_note (ContactsIoVCardParser* self,
                                           GHashTable* details,
                                           EVCardAttribute* attr);
static void contacts_io_vcard_parser_handle_url (ContactsIoVCardParser* self,
                                          GHashTable* details,
                                          EVCardAttribute* attr);
static GValue* _g_value_dup (GValue* self);
static void _vala_EContactDate_free (EContactDate* self);
static void contacts_io_vcard_parser_add_params (ContactsIoVCardParser* self,
                                          FolksAbstractFieldDetails* details,
                                          EVCardAttribute* attr);
static gboolean contacts_io_vcard_parser_insert_field_details (ContactsIoVCardParser* self,
                                                        GType t_type,
                                                        GBoxedCopyFunc t_dup_func,
                                                        GDestroyNotify t_destroy_func,
                                                        GHashTable* details,
                                                        FolksPersonaDetail key,
                                                        gconstpointer field_details,
                                                        GeeHashDataFunc hash_func,
                                                        gpointer hash_func_target,
                                                        GDestroyNotify hash_func_target_destroy_notify,
                                                        GeeEqualDataFunc equal_func,
                                                        gpointer equal_func_target,
                                                        GDestroyNotify equal_func_target_destroy_notify);
static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v,
                                                                    gpointer self);
static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a,
                                                                         gconstpointer b,
                                                                         gpointer self);
static GType contacts_io_vcard_parser_get_type_once (void);

ContactsIoVCardParser*
contacts_io_vcard_parser_construct (GType object_type)
{
	ContactsIoVCardParser * self = NULL;
	self = (ContactsIoVCardParser*) contacts_io_parser_construct (object_type);
	return self;
}

ContactsIoVCardParser*
contacts_io_vcard_parser_new (void)
{
	return contacts_io_vcard_parser_construct (CONTACTS_IO_TYPE_VCARD_PARSER);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_g_hash_table_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
__vala_GValue_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static GHashTable**
contacts_io_vcard_parser_real_parse (ContactsIoParser* base,
                                     GInputStream* input,
                                     gint* result_length1,
                                     GError** error)
{
	ContactsIoVCardParser * self;
	GMemoryOutputStream* memory_stream = NULL;
	GMemoryOutputStream* _tmp0_;
	GMemoryOutputStream* _tmp1_;
	GMemoryOutputStream* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_ = 0;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GMemoryOutputStream* _tmp6_;
	gchar* input_str = NULL;
	GMemoryOutputStream* _tmp7_;
	guint8* _tmp8_;
	gchar* _tmp9_;
	GPtrArray* _result_ = NULL;
	GPtrArray* _tmp10_;
	gint begin_index = 0;
	const gchar* _tmp11_;
	GPtrArray* _tmp55_;
	gsize _tmp56_ = 0;
	gpointer* _tmp57_;
	GHashTable** _tmp58_;
	gint _tmp58__length1;
	GError* _inner_error0_ = NULL;
	GHashTable** result;
	self = (ContactsIoVCardParser*) base;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = (GMemoryOutputStream*) g_memory_output_stream_new_resizable ();
	memory_stream = _tmp0_;
	_tmp1_ = memory_stream;
	g_output_stream_splice ((GOutputStream*) _tmp1_, input, 0, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (memory_stream);
		return NULL;
	}
	_tmp2_ = memory_stream;
	_tmp3_ = string_get_data ("\0", &_tmp4_);
	_tmp3__length1 = _tmp4_;
	_tmp5_ = _tmp3_;
	_tmp5__length1 = _tmp3__length1;
	g_output_stream_write ((GOutputStream*) _tmp2_, _tmp5_, (gsize) _tmp5__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (memory_stream);
		return NULL;
	}
	_tmp6_ = memory_stream;
	g_output_stream_close ((GOutputStream*) _tmp6_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (memory_stream);
		return NULL;
	}
	_tmp7_ = memory_stream;
	_tmp8_ = g_memory_output_stream_get_data (_tmp7_);
	_tmp9_ = g_strdup ((const gchar*) _tmp8_);
	input_str = _tmp9_;
	_tmp10_ = g_ptr_array_new_full ((guint) 0, _g_hash_table_unref0_);
	_result_ = _tmp10_;
	_tmp11_ = input_str;
	begin_index = string_index_of (_tmp11_, "BEGIN:VCARD", 0);
	while (TRUE) {
		gint end_vcard_index = 0;
		const gchar* _tmp12_;
		gint end_index = 0;
		gint _tmp13_;
		gint _tmp14_;
		gchar* vcard_str = NULL;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		EVCard* vcard = NULL;
		const gchar* _tmp17_;
		EVCard* _tmp18_;
		GList* vcard_attrs = NULL;
		EVCard* _tmp19_;
		GList* _tmp20_;
		GList* _tmp21_;
		GHashTable* details = NULL;
		GHashFunc _tmp22_;
		GEqualFunc _tmp23_;
		GHashTable* _tmp24_;
		GList* _tmp25_;
		GPtrArray* _tmp51_;
		GHashTable* _tmp52_;
		GHashTable* _tmp53_;
		const gchar* _tmp54_;
		if (!(begin_index != -1)) {
			break;
		}
		_tmp12_ = input_str;
		end_vcard_index = string_index_of (_tmp12_, "END:VCARD", begin_index + 1);
		_tmp13_ = strlen ("END:VCARD");
		_tmp14_ = _tmp13_;
		end_index = end_vcard_index + _tmp14_;
		_tmp15_ = input_str;
		_tmp16_ = string_slice (_tmp15_, (glong) begin_index, (glong) end_index);
		vcard_str = _tmp16_;
		_tmp17_ = vcard_str;
		_tmp18_ = e_vcard_new_from_string (_tmp17_);
		vcard = _tmp18_;
		_tmp19_ = vcard;
		_tmp20_ = e_vcard_get_attributes (_tmp19_);
		vcard_attrs = _tmp20_;
		_tmp21_ = vcard_attrs;
		g_debug ("contacts-io-vcard-parser.vala:52: Got %u attributes in this vcard", g_list_length (_tmp21_));
		_tmp22_ = g_str_hash;
		_tmp23_ = g_str_equal;
		_tmp24_ = g_hash_table_new_full (_tmp22_, _tmp23_, _g_free0_, __vala_GValue_free0_);
		details = _tmp24_;
		_tmp25_ = vcard_attrs;
		{
			GList* attr_collection = NULL;
			GList* attr_it = NULL;
			attr_collection = _tmp25_;
			for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
				EVCardAttribute* attr = NULL;
				attr = (EVCardAttribute*) attr_it->data;
				{
					EVCardAttribute* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					GQuark _tmp30_ = 0U;
					static GQuark _tmp29_label0 = 0;
					static GQuark _tmp29_label1 = 0;
					static GQuark _tmp29_label2 = 0;
					static GQuark _tmp29_label3 = 0;
					static GQuark _tmp29_label4 = 0;
					static GQuark _tmp29_label5 = 0;
					static GQuark _tmp29_label6 = 0;
					static GQuark _tmp29_label7 = 0;
					static GQuark _tmp29_label8 = 0;
					_tmp26_ = attr;
					_tmp27_ = e_vcard_attribute_get_name (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp30_ = (NULL == _tmp28_) ? 0 : g_quark_from_string (_tmp28_);
					if (_tmp30_ == ((0 != _tmp29_label0) ? _tmp29_label0 : (_tmp29_label0 = g_quark_from_static_string (EVC_FN)))) {
						switch (0) {
							default:
							{
								GHashTable* _tmp31_;
								EVCardAttribute* _tmp32_;
								_tmp31_ = details;
								_tmp32_ = attr;
								contacts_io_vcard_parser_handle_fn (self, _tmp31_, _tmp32_);
								break;
							}
						}
					} else if (_tmp30_ == ((0 != _tmp29_label1) ? _tmp29_label1 : (_tmp29_label1 = g_quark_from_static_string (EVC_N)))) {
						switch (0) {
							default:
							{
								GHashTable* _tmp33_;
								EVCardAttribute* _tmp34_;
								_tmp33_ = details;
								_tmp34_ = attr;
								contacts_io_vcard_parser_handle_n (self, _tmp33_, _tmp34_);
								break;
							}
						}
					} else if (_tmp30_ == ((0 != _tmp29_label2) ? _tmp29_label2 : (_tmp29_label2 = g_quark_from_static_string (EVC_NICKNAME)))) {
						switch (0) {
							default:
							{
								GHashTable* _tmp35_;
								EVCardAttribute* _tmp36_;
								_tmp35_ = details;
								_tmp36_ = attr;
								contacts_io_vcard_parser_handle_nickname (self, _tmp35_, _tmp36_);
								break;
							}
						}
					} else if (_tmp30_ == ((0 != _tmp29_label3) ? _tmp29_label3 : (_tmp29_label3 = g_quark_from_static_string (EVC_BDAY)))) {
						switch (0) {
							default:
							{
								GHashTable* _tmp37_;
								EVCardAttribute* _tmp38_;
								_tmp37_ = details;
								_tmp38_ = attr;
								contacts_io_vcard_parser_handle_bday (self, _tmp37_, _tmp38_);
								break;
							}
						}
					} else if (_tmp30_ == ((0 != _tmp29_label4) ? _tmp29_label4 : (_tmp29_label4 = g_quark_from_static_string (EVC_ADR)))) {
						switch (0) {
							default:
							{
								GHashTable* _tmp39_;
								EVCardAttribute* _tmp40_;
								_tmp39_ = details;
								_tmp40_ = attr;
								contacts_io_vcard_parser_handle_adr (self, _tmp39_, _tmp40_);
								break;
							}
						}
					} else if (_tmp30_ == ((0 != _tmp29_label5) ? _tmp29_label5 : (_tmp29_label5 = g_quark_from_static_string (EVC_TEL)))) {
						switch (0) {
							default:
							{
								GHashTable* _tmp41_;
								EVCardAttribute* _tmp42_;
								_tmp41_ = details;
								_tmp42_ = attr;
								contacts_io_vcard_parser_handle_tel (self, _tmp41_, _tmp42_);
								break;
							}
						}
					} else if (_tmp30_ == ((0 != _tmp29_label6) ? _tmp29_label6 : (_tmp29_label6 = g_quark_from_static_string (EVC_EMAIL)))) {
						switch (0) {
							default:
							{
								GHashTable* _tmp43_;
								EVCardAttribute* _tmp44_;
								_tmp43_ = details;
								_tmp44_ = attr;
								contacts_io_vcard_parser_handle_email (self, _tmp43_, _tmp44_);
								break;
							}
						}
					} else if (_tmp30_ == ((0 != _tmp29_label7) ? _tmp29_label7 : (_tmp29_label7 = g_quark_from_static_string (EVC_NOTE)))) {
						switch (0) {
							default:
							{
								GHashTable* _tmp45_;
								EVCardAttribute* _tmp46_;
								_tmp45_ = details;
								_tmp46_ = attr;
								contacts_io_vcard_parser_handle_note (self, _tmp45_, _tmp46_);
								break;
							}
						}
					} else if (_tmp30_ == ((0 != _tmp29_label8) ? _tmp29_label8 : (_tmp29_label8 = g_quark_from_static_string (EVC_URL)))) {
						switch (0) {
							default:
							{
								GHashTable* _tmp47_;
								EVCardAttribute* _tmp48_;
								_tmp47_ = details;
								_tmp48_ = attr;
								contacts_io_vcard_parser_handle_url (self, _tmp47_, _tmp48_);
								break;
							}
						}
					} else {
						switch (0) {
							default:
							{
								EVCardAttribute* _tmp49_;
								const gchar* _tmp50_;
								_tmp49_ = attr;
								_tmp50_ = e_vcard_attribute_get_name (_tmp49_);
								g_debug ("contacts-io-vcard-parser.vala:95: Unknown property name '%s'", _tmp50_);
								break;
							}
						}
					}
				}
			}
		}
		_tmp51_ = _result_;
		_tmp52_ = details;
		_tmp53_ = _g_hash_table_ref0 (_tmp52_);
		g_ptr_array_add (_tmp51_, _tmp53_);
		_tmp54_ = input_str;
		begin_index = string_index_of (_tmp54_, "BEGIN:VCARD", end_index);
		_g_hash_table_unref0 (details);
		_g_object_unref0 (vcard);
		_g_free0 (vcard_str);
	}
	_tmp55_ = _result_;
	_tmp57_ = g_ptr_array_steal (_tmp55_, &_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp58__length1 = _tmp56_;
	if (result_length1) {
		*result_length1 = _tmp58__length1;
	}
	result = _tmp58_;
	_g_ptr_array_unref0 (_result_);
	_g_free0 (input_str);
	_g_object_unref0 (memory_stream);
	return result;
}

static GValue*
_g_value_dup (GValue* self)
{
	return g_boxed_copy (G_TYPE_VALUE, self);
}

static gpointer
__g_value_dup0 (gpointer self)
{
	return self ? _g_value_dup (self) : NULL;
}

static void
contacts_io_vcard_parser_handle_fn (ContactsIoVCardParser* self,
                                    GHashTable* details,
                                    EVCardAttribute* attr)
{
	gchar* full_name = NULL;
	gchar* _tmp0_;
	GValue* fn_v = NULL;
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	GValue* _tmp3_;
	GValue* _tmp4_;
	GValue* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GValue* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	full_name = _tmp0_;
	g_debug ("contacts-io-vcard-parser.vala:112: Got FN '%s'", full_name);
	g_value_init (&_tmp1_, G_TYPE_STRING);
	_tmp2_ = _tmp1_;
	_tmp3_ = __g_value_dup0 (&_tmp2_);
	_tmp4_ = _tmp3_;
	G_IS_VALUE (&_tmp2_) ? (g_value_unset (&_tmp2_), NULL) : NULL;
	fn_v = _tmp4_;
	_tmp5_ = fn_v;
	g_value_set_string (_tmp5_, full_name);
	_tmp6_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = fn_v;
	fn_v = NULL;
	g_hash_table_insert (details, _tmp7_, _tmp8_);
	__vala_GValue_free0 (fn_v);
	_g_free0 (full_name);
}

static void
contacts_io_vcard_parser_handle_n (ContactsIoVCardParser* self,
                                   GHashTable* details,
                                   EVCardAttribute* attr)
{
	GList* values = NULL;
	GList* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	const gchar* family_name = NULL;
	const gchar* _tmp4_ = NULL;
	GList* _tmp5_;
	gconstpointer _tmp6_;
	const gchar* given_name = NULL;
	const gchar* _tmp7_ = NULL;
	GList* _tmp8_;
	gconstpointer _tmp9_;
	const gchar* additional_names = NULL;
	const gchar* _tmp10_ = NULL;
	GList* _tmp11_;
	gconstpointer _tmp12_;
	const gchar* prefixes = NULL;
	const gchar* _tmp13_ = NULL;
	GList* _tmp14_;
	gconstpointer _tmp15_;
	const gchar* suffixes = NULL;
	FolksStructuredName* structured_name = NULL;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	FolksStructuredName* _tmp20_;
	GValue* n_v = NULL;
	GValue _tmp21_ = {0};
	GValue _tmp22_;
	GValue* _tmp23_;
	GValue* _tmp24_;
	GValue* _tmp25_;
	FolksStructuredName* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	GValue* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_values (attr);
	values = _tmp0_;
	_tmp2_ = values;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
	_tmp1_ = (const gchar*) _tmp3_;
	if (_tmp1_ == NULL) {
		_tmp1_ = "";
	}
	family_name = _tmp1_;
	_tmp5_ = values;
	_tmp6_ = g_list_nth_data (_tmp5_, (guint) 1);
	_tmp4_ = (const gchar*) _tmp6_;
	if (_tmp4_ == NULL) {
		_tmp4_ = "";
	}
	given_name = _tmp4_;
	_tmp8_ = values;
	_tmp9_ = g_list_nth_data (_tmp8_, (guint) 2);
	_tmp7_ = (const gchar*) _tmp9_;
	if (_tmp7_ == NULL) {
		_tmp7_ = "";
	}
	additional_names = _tmp7_;
	_tmp11_ = values;
	_tmp12_ = g_list_nth_data (_tmp11_, (guint) 3);
	_tmp10_ = (const gchar*) _tmp12_;
	if (_tmp10_ == NULL) {
		_tmp10_ = "";
	}
	prefixes = _tmp10_;
	_tmp14_ = values;
	_tmp15_ = g_list_nth_data (_tmp14_, (guint) 4);
	_tmp13_ = (const gchar*) _tmp15_;
	if (_tmp13_ == NULL) {
		_tmp13_ = "";
	}
	suffixes = _tmp13_;
	_tmp16_ = family_name;
	_tmp17_ = given_name;
	_tmp18_ = additional_names;
	_tmp19_ = prefixes;
	_tmp20_ = folks_structured_name_new (_tmp16_, _tmp17_, _tmp18_, _tmp19_, suffixes);
	structured_name = _tmp20_;
	g_value_init (&_tmp21_, FOLKS_TYPE_STRUCTURED_NAME);
	_tmp22_ = _tmp21_;
	_tmp23_ = __g_value_dup0 (&_tmp22_);
	_tmp24_ = _tmp23_;
	G_IS_VALUE (&_tmp22_) ? (g_value_unset (&_tmp22_), NULL) : NULL;
	n_v = _tmp24_;
	_tmp25_ = n_v;
	_tmp26_ = structured_name;
	structured_name = NULL;
	g_value_take_object (_tmp25_, (GObject*) _tmp26_);
	_tmp27_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_STRUCTURED_NAME);
	_tmp28_ = g_strdup (_tmp27_);
	_tmp29_ = n_v;
	n_v = NULL;
	g_hash_table_insert (details, _tmp28_, _tmp29_);
	__vala_GValue_free0 (n_v);
	_g_object_unref0 (structured_name);
}

static void
contacts_io_vcard_parser_handle_nickname (ContactsIoVCardParser* self,
                                          GHashTable* details,
                                          EVCardAttribute* attr)
{
	gchar* nickname = NULL;
	gchar* _tmp0_;
	GValue* nick_v = NULL;
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	GValue* _tmp3_;
	GValue* _tmp4_;
	GValue* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GValue* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	nickname = _tmp0_;
	g_debug ("contacts-io-vcard-parser.vala:147: Got nickname '%s'", nickname);
	g_value_init (&_tmp1_, G_TYPE_STRING);
	_tmp2_ = _tmp1_;
	_tmp3_ = __g_value_dup0 (&_tmp2_);
	_tmp4_ = _tmp3_;
	G_IS_VALUE (&_tmp2_) ? (g_value_unset (&_tmp2_), NULL) : NULL;
	nick_v = _tmp4_;
	_tmp5_ = nick_v;
	g_value_set_string (_tmp5_, nickname);
	_tmp6_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_NICKNAME);
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = nick_v;
	nick_v = NULL;
	g_hash_table_insert (details, _tmp7_, _tmp8_);
	__vala_GValue_free0 (nick_v);
	_g_free0 (nickname);
}

static void
_vala_EContactDate_free (EContactDate* self)
{
	g_boxed_free (e_contact_date_get_type (), self);
}

static void
contacts_io_vcard_parser_handle_bday (ContactsIoVCardParser* self,
                                      GHashTable* details,
                                      EVCardAttribute* attr)
{
	gchar* bday = NULL;
	gchar* _tmp0_;
	EContactDate* e_date = NULL;
	EContactDate* _tmp1_;
	GDateTime* datetime = NULL;
	GDateTime* _tmp2_;
	GValue* bday_val = NULL;
	GValue _tmp3_ = {0};
	GValue _tmp4_;
	GValue* _tmp5_;
	GValue* _tmp6_;
	GValue* _tmp7_;
	GDateTime* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GValue* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	bday = _tmp0_;
	_tmp1_ = e_contact_date_from_string (bday);
	e_date = _tmp1_;
	_tmp2_ = g_date_time_new_utc ((gint) e_date->year, (gint) e_date->month, (gint) e_date->day, 0, 0, 0.0);
	datetime = _tmp2_;
	g_value_init (&_tmp3_, G_TYPE_DATE_TIME);
	_tmp4_ = _tmp3_;
	_tmp5_ = __g_value_dup0 (&_tmp4_);
	_tmp6_ = _tmp5_;
	G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
	bday_val = _tmp6_;
	_tmp7_ = bday_val;
	_tmp8_ = datetime;
	datetime = NULL;
	g_value_take_boxed (_tmp7_, _tmp8_);
	_tmp9_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_BIRTHDAY);
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = bday_val;
	bday_val = NULL;
	g_hash_table_insert (details, _tmp10_, _tmp11_);
	__vala_GValue_free0 (bday_val);
	_g_date_time_unref0 (datetime);
	__vala_EContactDate_free0 (e_date);
	_g_free0 (bday);
}

static guint
_folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v,
                                                              gpointer self)
{
	guint result;
	result = folks_abstract_field_details_hash_static ((FolksAbstractFieldDetails*) v);
	return result;
}

static gboolean
_folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a,
                                                                gconstpointer b,
                                                                gpointer self)
{
	gboolean result;
	result = folks_abstract_field_details_equal_static ((FolksAbstractFieldDetails*) a, (FolksAbstractFieldDetails*) b);
	return result;
}

static void
contacts_io_vcard_parser_handle_email (ContactsIoVCardParser* self,
                                       GHashTable* details,
                                       EVCardAttribute* attr)
{
	gchar* email = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	FolksEmailFieldDetails* email_fd = NULL;
	const gchar* _tmp4_;
	FolksEmailFieldDetails* _tmp5_;
	FolksEmailFieldDetails* _tmp6_;
	FolksEmailFieldDetails* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	email = _tmp0_;
	_tmp2_ = email;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = email;
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	if (_tmp1_) {
		_g_free0 (email);
		return;
	}
	_tmp4_ = email;
	_tmp5_ = folks_email_field_details_new (_tmp4_, NULL);
	email_fd = _tmp5_;
	_tmp6_ = email_fd;
	contacts_io_vcard_parser_add_params (self, (FolksAbstractFieldDetails*) _tmp6_, attr);
	_tmp7_ = email_fd;
	contacts_io_vcard_parser_insert_field_details (self, FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, details, FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES, _tmp7_, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (email_fd);
	_g_free0 (email);
}

static void
contacts_io_vcard_parser_handle_tel (ContactsIoVCardParser* self,
                                     GHashTable* details,
                                     EVCardAttribute* attr)
{
	gchar* phone_nr = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	FolksPhoneFieldDetails* phone_fd = NULL;
	const gchar* _tmp4_;
	FolksPhoneFieldDetails* _tmp5_;
	FolksPhoneFieldDetails* _tmp6_;
	FolksPhoneFieldDetails* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	phone_nr = _tmp0_;
	_tmp2_ = phone_nr;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = phone_nr;
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	if (_tmp1_) {
		_g_free0 (phone_nr);
		return;
	}
	_tmp4_ = phone_nr;
	_tmp5_ = folks_phone_field_details_new (_tmp4_, NULL);
	phone_fd = _tmp5_;
	_tmp6_ = phone_fd;
	contacts_io_vcard_parser_add_params (self, (FolksAbstractFieldDetails*) _tmp6_, attr);
	_tmp7_ = phone_fd;
	contacts_io_vcard_parser_insert_field_details (self, FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, details, FOLKS_PERSONA_DETAIL_PHONE_NUMBERS, _tmp7_, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (phone_fd);
	_g_free0 (phone_nr);
}

static void
contacts_io_vcard_parser_handle_adr (ContactsIoVCardParser* self,
                                     GHashTable* details,
                                     EVCardAttribute* attr)
{
	GList* values = NULL;
	GList* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	const gchar* po_box = NULL;
	const gchar* _tmp4_ = NULL;
	GList* _tmp5_;
	gconstpointer _tmp6_;
	const gchar* extension = NULL;
	const gchar* _tmp7_ = NULL;
	GList* _tmp8_;
	gconstpointer _tmp9_;
	const gchar* street = NULL;
	const gchar* _tmp10_ = NULL;
	GList* _tmp11_;
	gconstpointer _tmp12_;
	const gchar* locality = NULL;
	const gchar* _tmp13_ = NULL;
	GList* _tmp14_;
	gconstpointer _tmp15_;
	const gchar* region = NULL;
	const gchar* _tmp16_ = NULL;
	GList* _tmp17_;
	gconstpointer _tmp18_;
	const gchar* postal_code = NULL;
	const gchar* _tmp19_ = NULL;
	GList* _tmp20_;
	gconstpointer _tmp21_;
	const gchar* country = NULL;
	FolksPostalAddress* addr = NULL;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	FolksPostalAddress* _tmp28_;
	FolksPostalAddressFieldDetails* addr_fd = NULL;
	FolksPostalAddress* _tmp29_;
	FolksPostalAddress* _tmp30_;
	FolksPostalAddressFieldDetails* _tmp31_;
	FolksPostalAddressFieldDetails* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_values (attr);
	values = _tmp0_;
	_tmp2_ = values;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
	_tmp1_ = (const gchar*) _tmp3_;
	if (_tmp1_ == NULL) {
		_tmp1_ = "";
	}
	po_box = _tmp1_;
	_tmp5_ = values;
	_tmp6_ = g_list_nth_data (_tmp5_, (guint) 1);
	_tmp4_ = (const gchar*) _tmp6_;
	if (_tmp4_ == NULL) {
		_tmp4_ = "";
	}
	extension = _tmp4_;
	_tmp8_ = values;
	_tmp9_ = g_list_nth_data (_tmp8_, (guint) 2);
	_tmp7_ = (const gchar*) _tmp9_;
	if (_tmp7_ == NULL) {
		_tmp7_ = "";
	}
	street = _tmp7_;
	_tmp11_ = values;
	_tmp12_ = g_list_nth_data (_tmp11_, (guint) 3);
	_tmp10_ = (const gchar*) _tmp12_;
	if (_tmp10_ == NULL) {
		_tmp10_ = "";
	}
	locality = _tmp10_;
	_tmp14_ = values;
	_tmp15_ = g_list_nth_data (_tmp14_, (guint) 4);
	_tmp13_ = (const gchar*) _tmp15_;
	if (_tmp13_ == NULL) {
		_tmp13_ = "";
	}
	region = _tmp13_;
	_tmp17_ = values;
	_tmp18_ = g_list_nth_data (_tmp17_, (guint) 5);
	_tmp16_ = (const gchar*) _tmp18_;
	if (_tmp16_ == NULL) {
		_tmp16_ = "";
	}
	postal_code = _tmp16_;
	_tmp20_ = values;
	_tmp21_ = g_list_nth_data (_tmp20_, (guint) 6);
	_tmp19_ = (const gchar*) _tmp21_;
	if (_tmp19_ == NULL) {
		_tmp19_ = "";
	}
	country = _tmp19_;
	_tmp22_ = po_box;
	_tmp23_ = extension;
	_tmp24_ = street;
	_tmp25_ = locality;
	_tmp26_ = region;
	_tmp27_ = postal_code;
	_tmp28_ = folks_postal_address_new (_tmp22_, _tmp23_, _tmp24_, _tmp25_, _tmp26_, _tmp27_, country, "", NULL);
	addr = _tmp28_;
	_tmp29_ = addr;
	addr = NULL;
	_tmp30_ = _tmp29_;
	_tmp31_ = folks_postal_address_field_details_new (_tmp30_, NULL);
	_tmp32_ = _tmp31_;
	_g_object_unref0 (_tmp30_);
	addr_fd = _tmp32_;
	contacts_io_vcard_parser_add_params (self, (FolksAbstractFieldDetails*) addr_fd, attr);
	contacts_io_vcard_parser_insert_field_details (self, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, details, FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES, addr_fd, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (addr_fd);
	_g_object_unref0 (addr);
}

static void
contacts_io_vcard_parser_handle_url (ContactsIoVCardParser* self,
                                     GHashTable* details,
                                     EVCardAttribute* attr)
{
	gchar* url = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	FolksUrlFieldDetails* url_fd = NULL;
	const gchar* _tmp4_;
	FolksUrlFieldDetails* _tmp5_;
	FolksUrlFieldDetails* _tmp6_;
	FolksUrlFieldDetails* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	url = _tmp0_;
	_tmp2_ = url;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = url;
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	if (_tmp1_) {
		_g_free0 (url);
		return;
	}
	_tmp4_ = url;
	_tmp5_ = folks_url_field_details_new (_tmp4_, NULL);
	url_fd = _tmp5_;
	_tmp6_ = url_fd;
	contacts_io_vcard_parser_add_params (self, (FolksAbstractFieldDetails*) _tmp6_, attr);
	_tmp7_ = url_fd;
	contacts_io_vcard_parser_insert_field_details (self, FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, details, FOLKS_PERSONA_DETAIL_URLS, _tmp7_, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (url_fd);
	_g_free0 (url);
}

static void
contacts_io_vcard_parser_handle_note (ContactsIoVCardParser* self,
                                      GHashTable* details,
                                      EVCardAttribute* attr)
{
	gchar* note = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	FolksNoteFieldDetails* note_fd = NULL;
	const gchar* _tmp4_;
	FolksNoteFieldDetails* _tmp5_;
	FolksNoteFieldDetails* _tmp6_;
	FolksNoteFieldDetails* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_value (attr);
	note = _tmp0_;
	_tmp2_ = note;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = note;
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	if (_tmp1_) {
		_g_free0 (note);
		return;
	}
	_tmp4_ = note;
	_tmp5_ = folks_note_field_details_new (_tmp4_, NULL, NULL);
	note_fd = _tmp5_;
	_tmp6_ = note_fd;
	contacts_io_vcard_parser_add_params (self, (FolksAbstractFieldDetails*) _tmp6_, attr);
	_tmp7_ = note_fd;
	contacts_io_vcard_parser_insert_field_details (self, FOLKS_TYPE_NOTE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, details, FOLKS_PERSONA_DETAIL_NOTES, _tmp7_, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (note_fd);
	_g_free0 (note);
}

static gboolean
contacts_io_vcard_parser_insert_field_details (ContactsIoVCardParser* self,
                                               GType t_type,
                                               GBoxedCopyFunc t_dup_func,
                                               GDestroyNotify t_destroy_func,
                                               GHashTable* details,
                                               FolksPersonaDetail key,
                                               gconstpointer field_details,
                                               GeeHashDataFunc hash_func,
                                               gpointer hash_func_target,
                                               GDestroyNotify hash_func_target_destroy_notify,
                                               GeeEqualDataFunc equal_func,
                                               gpointer equal_func_target,
                                               GDestroyNotify equal_func_target_destroy_notify)
{
	GValue* old_val = NULL;
	const gchar* _tmp0_;
	gconstpointer _tmp1_;
	GValue* _tmp2_;
	GeeHashSet* values = NULL;
	GeeHashDataFunc _tmp5_;
	gpointer _tmp5__target;
	GDestroyNotify _tmp5__target_destroy_notify;
	GeeEqualDataFunc _tmp6_;
	gpointer _tmp6__target;
	GDestroyNotify _tmp6__target_destroy_notify;
	GeeHashSet* _tmp7_;
	GValue* new_val = NULL;
	GValue _tmp8_ = {0};
	GValue _tmp9_;
	GValue* _tmp10_;
	GValue* _tmp11_;
	GValue* _tmp12_;
	GeeHashSet* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GValue* _tmp16_;
	GeeHashSet* _tmp17_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (details != NULL, FALSE);
	_tmp0_ = folks_persona_store_detail_key (key);
	_tmp1_ = g_hash_table_lookup (details, _tmp0_);
	old_val = (GValue*) _tmp1_;
	_tmp2_ = old_val;
	if (((gpointer) _tmp2_) != NULL) {
		GeeHashSet* values = NULL;
		GValue* _tmp3_;
		GeeHashSet* _tmp4_;
		_tmp3_ = old_val;
		values = g_value_get_object (_tmp3_);
		_tmp4_ = values;
		result = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, field_details);
		(hash_func_target_destroy_notify == NULL) ? NULL : (hash_func_target_destroy_notify (hash_func_target), NULL);
		hash_func = NULL;
		hash_func_target = NULL;
		hash_func_target_destroy_notify = NULL;
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		return result;
	}
	_tmp5_ = hash_func;
	_tmp5__target = hash_func_target;
	_tmp5__target_destroy_notify = hash_func_target_destroy_notify;
	hash_func = NULL;
	hash_func_target = NULL;
	hash_func_target_destroy_notify = NULL;
	_tmp6_ = equal_func;
	_tmp6__target = equal_func_target;
	_tmp6__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp7_ = gee_hash_set_new (t_type, (GBoxedCopyFunc) t_dup_func, (GDestroyNotify) t_destroy_func, _tmp5_, _tmp5__target, _tmp5__target_destroy_notify, _tmp6_, _tmp6__target, _tmp6__target_destroy_notify);
	values = _tmp7_;
	g_value_init (&_tmp8_, GEE_TYPE_SET);
	_tmp9_ = _tmp8_;
	_tmp10_ = __g_value_dup0 (&_tmp9_);
	_tmp11_ = _tmp10_;
	G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
	new_val = _tmp11_;
	_tmp12_ = new_val;
	_tmp13_ = values;
	g_value_set_object (_tmp12_, (GObject*) _tmp13_);
	_tmp14_ = folks_persona_store_detail_key (key);
	_tmp15_ = g_strdup (_tmp14_);
	_tmp16_ = new_val;
	new_val = NULL;
	g_hash_table_insert (details, _tmp15_, _tmp16_);
	_tmp17_ = values;
	result = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, field_details);
	__vala_GValue_free0 (new_val);
	_g_object_unref0 (values);
	(hash_func_target_destroy_notify == NULL) ? NULL : (hash_func_target_destroy_notify (hash_func_target), NULL);
	hash_func = NULL;
	hash_func_target = NULL;
	hash_func_target_destroy_notify = NULL;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return result;
}

static void
contacts_io_vcard_parser_add_params (ContactsIoVCardParser* self,
                                     FolksAbstractFieldDetails* details,
                                     EVCardAttribute* attr)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = e_vcard_attribute_get_params (attr);
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp0_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			EVCardAttributeParam* param = NULL;
			param = (EVCardAttributeParam*) param_it->data;
			{
				gchar* param_name = NULL;
				EVCardAttributeParam* _tmp1_;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				EVCardAttributeParam* _tmp4_;
				GList* _tmp5_;
				_tmp1_ = param;
				_tmp2_ = e_vcard_attribute_param_get_name (_tmp1_);
				_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
				param_name = _tmp3_;
				_tmp4_ = param;
				_tmp5_ = e_vcard_attribute_param_get_values (_tmp4_);
				{
					GList* param_value_collection = NULL;
					GList* param_value_it = NULL;
					param_value_collection = _tmp5_;
					for (param_value_it = param_value_collection; param_value_it != NULL; param_value_it = param_value_it->next) {
						const gchar* param_value = NULL;
						param_value = (const gchar*) param_value_it->data;
						{
							const gchar* _tmp6_;
							_tmp6_ = param_name;
							if (g_strcmp0 (_tmp6_, FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE) == 0) {
								const gchar* _tmp7_;
								const gchar* _tmp8_;
								gchar* _tmp9_;
								gchar* _tmp10_;
								_tmp7_ = param_name;
								_tmp8_ = param_value;
								_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
								_tmp10_ = _tmp9_;
								folks_abstract_field_details_add_parameter (details, _tmp7_, _tmp10_);
								_g_free0 (_tmp10_);
							} else {
								const gchar* _tmp11_;
								const gchar* _tmp12_;
								_tmp11_ = param_name;
								_tmp12_ = param_value;
								folks_abstract_field_details_add_parameter (details, _tmp11_, _tmp12_);
							}
						}
					}
				}
				_g_free0 (param_name);
			}
		}
	}
}

static void
contacts_io_vcard_parser_class_init (ContactsIoVCardParserClass * klass,
                                     gpointer klass_data)
{
	contacts_io_vcard_parser_parent_class = g_type_class_peek_parent (klass);
	((ContactsIoParserClass *) klass)->parse = (GHashTable** (*) (ContactsIoParser*, GInputStream*, gint*, GError**)) contacts_io_vcard_parser_real_parse;
}

static void
contacts_io_vcard_parser_instance_init (ContactsIoVCardParser * self,
                                        gpointer klass)
{
}

/**
 * A {@link Contacts.Io.Parser} that specifically deals with parsing VCard
 */
 G_GNUC_NO_INLINE static GType
contacts_io_vcard_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsIoVCardParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_io_vcard_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsIoVCardParser), 0, (GInstanceInitFunc) contacts_io_vcard_parser_instance_init, NULL };
	GType contacts_io_vcard_parser_type_id;
	contacts_io_vcard_parser_type_id = g_type_register_static (CONTACTS_IO_TYPE_PARSER, "ContactsIoVCardParser", &g_define_type_info, 0);
	return contacts_io_vcard_parser_type_id;
}

GType
contacts_io_vcard_parser_get_type (void)
{
	static volatile gsize contacts_io_vcard_parser_type_id__once = 0;
	if (g_once_init_enter (&contacts_io_vcard_parser_type_id__once)) {
		GType contacts_io_vcard_parser_type_id;
		contacts_io_vcard_parser_type_id = contacts_io_vcard_parser_get_type_once ();
		g_once_init_leave (&contacts_io_vcard_parser_type_id__once, contacts_io_vcard_parser_type_id);
	}
	return contacts_io_vcard_parser_type_id__once;
}

