/* contacts-io-export-operation.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-io-export-operation.vala, do not modify */

/*
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "contacts.h"
#include <gee.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <glib.h>

enum  {
	CONTACTS_IO_EXPORT_OPERATION_0_PROPERTY,
	CONTACTS_IO_EXPORT_OPERATION_INDIVIDUALS_PROPERTY,
	CONTACTS_IO_EXPORT_OPERATION_OUTPUT_PROPERTY,
	CONTACTS_IO_EXPORT_OPERATION_REVERSABLE_PROPERTY,
	CONTACTS_IO_EXPORT_OPERATION_NUM_PROPERTIES
};
static GParamSpec* contacts_io_export_operation_properties[CONTACTS_IO_EXPORT_OPERATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsIoExportOperationUndoData ContactsIoExportOperationUndoData;

struct _ContactsIoExportOperationPrivate {
	GeeList* _individuals;
	GOutputStream* _output;
};

struct _ContactsIoExportOperationUndoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsIoExportOperation* self;
};

static gint ContactsIoExportOperation_private_offset;
static gpointer contacts_io_export_operation_parent_class = NULL;

static void contacts_io_export_operation_real__undo_data_free (gpointer _data);
static void contacts_io_export_operation_real__undo (ContactsOperation* base,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean contacts_io_export_operation_real__undo_co (ContactsIoExportOperationUndoData* _data_);
static void contacts_io_export_operation_finalize (GObject * obj);
static GType contacts_io_export_operation_get_type_once (void);
static void _vala_contacts_io_export_operation_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_contacts_io_export_operation_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
contacts_io_export_operation_get_instance_private (ContactsIoExportOperation* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsIoExportOperation_private_offset);
}

static void
contacts_io_export_operation_real__undo_data_free (gpointer _data)
{
	ContactsIoExportOperationUndoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsIoExportOperationUndoData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
contacts_io_export_operation_real__undo (ContactsOperation* base,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	ContactsIoExportOperation * self;
	ContactsIoExportOperationUndoData* _data_;
	ContactsIoExportOperation* _tmp0_;
	self = (ContactsIoExportOperation*) base;
	_data_ = g_slice_new0 (ContactsIoExportOperationUndoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_io_export_operation_real__undo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_io_export_operation_real__undo_co (_data_);
}

static void
_contacts_io_export_operation_undo_finish (ContactsOperation* base,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	ContactsIoExportOperationUndoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
contacts_io_export_operation_real__undo_co (ContactsIoExportOperationUndoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ContactsIoExportOperation*
contacts_io_export_operation_construct (GType object_type)
{
	ContactsIoExportOperation * self = NULL;
	self = (ContactsIoExportOperation*) contacts_operation_construct (object_type);
	return self;
}

GeeList*
contacts_io_export_operation_get_individuals (ContactsIoExportOperation* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_individuals;
	result = _tmp0_;
	return result;
}

void
contacts_io_export_operation_set_individuals (ContactsIoExportOperation* self,
                                              GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_io_export_operation_get_individuals (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_individuals);
		self->priv->_individuals = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_io_export_operation_properties[CONTACTS_IO_EXPORT_OPERATION_INDIVIDUALS_PROPERTY]);
	}
}

GOutputStream*
contacts_io_export_operation_get_output (ContactsIoExportOperation* self)
{
	GOutputStream* result;
	GOutputStream* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_output;
	result = _tmp0_;
	return result;
}

void
contacts_io_export_operation_set_output (ContactsIoExportOperation* self,
                                         GOutputStream* value)
{
	GOutputStream* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_io_export_operation_get_output (self);
	if (old_value != value) {
		GOutputStream* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_output);
		self->priv->_output = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_io_export_operation_properties[CONTACTS_IO_EXPORT_OPERATION_OUTPUT_PROPERTY]);
	}
}

static gboolean
contacts_io_export_operation_real_get_reversable (ContactsOperation* base)
{
	gboolean result;
	ContactsIoExportOperation* self;
	self = (ContactsIoExportOperation*) base;
	result = FALSE;
	return result;
}

static void
contacts_io_export_operation_class_init (ContactsIoExportOperationClass * klass,
                                         gpointer klass_data)
{
	contacts_io_export_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsIoExportOperation_private_offset);
	((ContactsOperationClass *) klass)->_undo = (void (*) (ContactsOperation*, GAsyncReadyCallback, gpointer)) contacts_io_export_operation_real__undo;
	((ContactsOperationClass *) klass)->_undo_finish = (void (*) (ContactsOperation*, GAsyncResult*, GError**)) _contacts_io_export_operation_undo_finish;
	CONTACTS_OPERATION_CLASS (klass)->get_reversable = contacts_io_export_operation_real_get_reversable;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_io_export_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_io_export_operation_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_io_export_operation_finalize;
	/** The list of individuals that will be exported */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IO_EXPORT_OPERATION_INDIVIDUALS_PROPERTY, contacts_io_export_operation_properties[CONTACTS_IO_EXPORT_OPERATION_INDIVIDUALS_PROPERTY] = g_param_spec_object ("individuals", "individuals", "individuals", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The generic output stream to export the individuals to.
	   *
	   * If you want to export to:
	   * - a file, use the result of {@link GLib.File.create}
	   * - a string, create a {@link GLib.MemoryOutputStream} and append a '\0'
	   *   terminator at the end
	   * - ...
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IO_EXPORT_OPERATION_OUTPUT_PROPERTY, contacts_io_export_operation_properties[CONTACTS_IO_EXPORT_OPERATION_OUTPUT_PROPERTY] = g_param_spec_object ("output", "output", "output", g_output_stream_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IO_EXPORT_OPERATION_REVERSABLE_PROPERTY, contacts_io_export_operation_properties[CONTACTS_IO_EXPORT_OPERATION_REVERSABLE_PROPERTY] = g_param_spec_boolean ("reversable", "reversable", "reversable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_io_export_operation_instance_init (ContactsIoExportOperation * self,
                                            gpointer klass)
{
	self->priv = contacts_io_export_operation_get_instance_private (self);
}

static void
contacts_io_export_operation_finalize (GObject * obj)
{
	ContactsIoExportOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_IO_TYPE_EXPORT_OPERATION, ContactsIoExportOperation);
	_g_object_unref0 (self->priv->_individuals);
	_g_object_unref0 (self->priv->_output);
	G_OBJECT_CLASS (contacts_io_export_operation_parent_class)->finalize (obj);
}

/**
 * An Io.ExportOperation is an object that can deal with exporting one or more
 * contacts ({@link Folks.Individual}s) into a serialized format (VCard is the
 * most common example, but there exist also CSV based formats and others).
 *
 * Note that unlike a Io.Importer, we can skip the whole {@link GLib.HashTable}
 * dance, since we aren't dealing with untrusted data anymore.
 */
 G_GNUC_NO_INLINE static GType
contacts_io_export_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsIoExportOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_io_export_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsIoExportOperation), 0, (GInstanceInitFunc) contacts_io_export_operation_instance_init, NULL };
	GType contacts_io_export_operation_type_id;
	contacts_io_export_operation_type_id = g_type_register_static (CONTACTS_TYPE_OPERATION, "ContactsIoExportOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ContactsIoExportOperation_private_offset = g_type_add_instance_private (contacts_io_export_operation_type_id, sizeof (ContactsIoExportOperationPrivate));
	return contacts_io_export_operation_type_id;
}

GType
contacts_io_export_operation_get_type (void)
{
	static volatile gsize contacts_io_export_operation_type_id__once = 0;
	if (g_once_init_enter (&contacts_io_export_operation_type_id__once)) {
		GType contacts_io_export_operation_type_id;
		contacts_io_export_operation_type_id = contacts_io_export_operation_get_type_once ();
		g_once_init_leave (&contacts_io_export_operation_type_id__once, contacts_io_export_operation_type_id);
	}
	return contacts_io_export_operation_type_id__once;
}

static void
_vala_contacts_io_export_operation_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	ContactsIoExportOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_IO_TYPE_EXPORT_OPERATION, ContactsIoExportOperation);
	switch (property_id) {
		case CONTACTS_IO_EXPORT_OPERATION_INDIVIDUALS_PROPERTY:
		g_value_set_object (value, contacts_io_export_operation_get_individuals (self));
		break;
		case CONTACTS_IO_EXPORT_OPERATION_OUTPUT_PROPERTY:
		g_value_set_object (value, contacts_io_export_operation_get_output (self));
		break;
		case CONTACTS_IO_EXPORT_OPERATION_REVERSABLE_PROPERTY:
		g_value_set_boolean (value, contacts_operation_get_reversable ((ContactsOperation*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_io_export_operation_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	ContactsIoExportOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_IO_TYPE_EXPORT_OPERATION, ContactsIoExportOperation);
	switch (property_id) {
		case CONTACTS_IO_EXPORT_OPERATION_INDIVIDUALS_PROPERTY:
		contacts_io_export_operation_set_individuals (self, g_value_get_object (value));
		break;
		case CONTACTS_IO_EXPORT_OPERATION_OUTPUT_PROPERTY:
		contacts_io_export_operation_set_output (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

