/* contacts-io.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-io.vala, do not modify */

/*
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "contacts.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>

#define CONTACTS_IO_FULL_NAME_TYPE "s"
#define CONTACTS_IO_STRUCTURED_NAME_TYPE "(sssss)"
#define CONTACTS_IO_NICKNAME_TYPE "s"
#define CONTACTS_IO_BIRTHDAY_TYPE "(iii)"
#define CONTACTS_IO_ADDRESS_TYPE "(sssssssv)"
#define CONTACTS_IO_ADDRESSES_TYPE "a" CONTACTS_IO_ADDRESS_TYPE
#define CONTACTS_IO_AFD_STRING_TYPE "(sv)"
#define CONTACTS_IO_PARAMS_TYPE "a(ss)"

#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef FolksAbstractFieldDetails* (*ContactsIoCreateAbstractFieldStrFunc) (const gchar* value, gpointer user_data);

VALA_EXTERN gboolean contacts_io_serialize_full_name (GVariantDict* dict,
                                          const gchar* prop,
                                          GValue* val);
VALA_EXTERN gboolean contacts_io_serialize_structured_name (GVariantDict* dict,
                                                const gchar* prop,
                                                GValue* val);
VALA_EXTERN gboolean contacts_io_serialize_nickname (GVariantDict* dict,
                                         const gchar* prop,
                                         GValue* val);
VALA_EXTERN gboolean contacts_io_serialize_birthday (GVariantDict* dict,
                                         const gchar* prop,
                                         GValue* val);
VALA_EXTERN gboolean contacts_io_serialize_addresses (GVariantDict* dict,
                                          const gchar* prop,
                                          GValue* val);
VALA_EXTERN gboolean contacts_io_serialize_phone_nrs (GVariantDict* dict,
                                          const gchar* prop,
                                          GValue* val);
VALA_EXTERN gboolean contacts_io_serialize_emails (GVariantDict* dict,
                                       const gchar* prop,
                                       GValue* val);
VALA_EXTERN gboolean contacts_io_serialize_notes (GVariantDict* dict,
                                      const gchar* prop,
                                      GValue* val);
VALA_EXTERN gboolean contacts_io_serialize_urls (GVariantDict* dict,
                                     const gchar* prop,
                                     GValue* val);
static void _g_hash_table_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
VALA_EXTERN gboolean contacts_io_deserialize_full_name (GHashTable* details,
                                            const gchar* prop,
                                            GVariant* variant);
VALA_EXTERN gboolean contacts_io_deserialize_structured_name (GHashTable* details,
                                                  const gchar* prop,
                                                  GVariant* variant);
VALA_EXTERN gboolean contacts_io_deserialize_nickname (GHashTable* details,
                                           const gchar* prop,
                                           GVariant* variant);
VALA_EXTERN gboolean contacts_io_deserialize_birthday (GHashTable* details,
                                           const gchar* prop,
                                           GVariant* variant);
VALA_EXTERN gboolean contacts_io_deserialize_addresses (GHashTable* details,
                                            const gchar* prop,
                                            GVariant* variant);
VALA_EXTERN gboolean contacts_io_deserialize_phone_nrs (GHashTable* details,
                                            const gchar* prop,
                                            GVariant* variant);
VALA_EXTERN gboolean contacts_io_deserialize_emails (GHashTable* details,
                                         const gchar* prop,
                                         GVariant* variant);
VALA_EXTERN gboolean contacts_io_deserialize_notes (GHashTable* details,
                                        const gchar* prop,
                                        GVariant* variant);
VALA_EXTERN gboolean contacts_io_deserialize_urls (GHashTable* details,
                                       const gchar* prop,
                                       GVariant* variant);
VALA_EXTERN GVariant* contacts_io_serialize_parameters (FolksAbstractFieldDetails* details);
VALA_EXTERN void contacts_io_deserialize_parameters (GVariant* parameters,
                                         FolksAbstractFieldDetails* details);
VALA_EXTERN gboolean contacts_io_serialize_afd_strings (GVariantDict* dict,
                                            const gchar* prop,
                                            GValue* val);
VALA_EXTERN gboolean contacts_io_deserialize_afd_str (GHashTable* details,
                                          const gchar* prop,
                                          GVariant* variant,
                                          ContactsIoCreateAbstractFieldStrFunc create_afd_func,
                                          gpointer create_afd_func_target);
static FolksAbstractFieldDetails* __lambda16_ (const gchar* str);
static FolksAbstractFieldDetails* ___lambda16__contacts_io_create_abstract_field_str_func (const gchar* value,
                                                                                    gpointer self);
static FolksAbstractFieldDetails* __lambda17_ (const gchar* str);
static FolksAbstractFieldDetails* ___lambda17__contacts_io_create_abstract_field_str_func (const gchar* value,
                                                                                    gpointer self);
static FolksAbstractFieldDetails* __lambda18_ (const gchar* str);
static FolksAbstractFieldDetails* ___lambda18__contacts_io_create_abstract_field_str_func (const gchar* value,
                                                                                    gpointer self);
static FolksAbstractFieldDetails* __lambda19_ (const gchar* str);
static FolksAbstractFieldDetails* ___lambda19__contacts_io_create_abstract_field_str_func (const gchar* value,
                                                                                    gpointer self);

/**
   * Serializes a list of {@link GLib.HashTable}s as returned by a
   * {@link Contacts.Io.Parser} into a {@link GLib.Variant} so it can be sent
   * from one process to another.
   */
GVariant*
contacts_io_serialize_to_gvariant (GHashTable** details_list,
                                   gint details_list_length1)
{
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp8_;
	GVariant* _tmp9_;
	GVariant* result;
	_tmp0_ = g_variant_type_new ("aa{sv}");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	builder = _tmp3_;
	{
		GHashTable** details_collection = NULL;
		gint details_collection_length1 = 0;
		gint _details_collection_size_ = 0;
		gint details_it = 0;
		details_collection = details_list;
		details_collection_length1 = details_list_length1;
		for (details_it = 0; details_it < details_collection_length1; details_it = details_it + 1) {
			GHashTable* details = NULL;
			details = details_collection[details_it];
			{
				GVariantBuilder* _tmp4_;
				GHashTable* _tmp5_;
				GVariant* _tmp6_;
				GVariant* _tmp7_;
				_tmp4_ = builder;
				_tmp5_ = details;
				_tmp6_ = contacts_io_serialize_to_gvariant_single (_tmp5_);
				_tmp7_ = _tmp6_;
				g_variant_builder_add_value (_tmp4_, _tmp7_);
				_g_variant_unref0 (_tmp7_);
			}
		}
	}
	_tmp8_ = builder;
	_tmp9_ = g_variant_builder_end (_tmp8_);
	g_variant_ref_sink (_tmp9_);
	result = _tmp9_;
	_g_variant_builder_unref0 (builder);
	return result;
}

/**
   * Serializes a single {@link GLib.HashTable} into a {@link GLib.Variant}.
   */
GVariant*
contacts_io_serialize_to_gvariant_single (GHashTable* details)
{
	GVariantDict* dict = NULL;
	GVariantDict* _tmp0_;
	GHashTableIter iter = {0};
	const gchar* prop = NULL;
	GValue* val = NULL;
	GVariantDict* _tmp50_;
	GVariant* _tmp51_;
	GVariant* result;
	g_return_val_if_fail (details != NULL, NULL);
	_tmp0_ = g_variant_dict_new (NULL);
	dict = _tmp0_;
	g_hash_table_iter_init (&iter, details);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		prop = _tmp1_;
		val = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = prop;
		_tmp5_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
		if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
			GVariantDict* _tmp6_;
			const gchar* _tmp7_;
			GValue* _tmp8_;
			_tmp6_ = dict;
			_tmp7_ = prop;
			_tmp8_ = val;
			contacts_io_serialize_full_name (_tmp6_, _tmp7_, _tmp8_);
		} else {
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = prop;
			_tmp10_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_STRUCTURED_NAME);
			if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
				GVariantDict* _tmp11_;
				const gchar* _tmp12_;
				GValue* _tmp13_;
				_tmp11_ = dict;
				_tmp12_ = prop;
				_tmp13_ = val;
				contacts_io_serialize_structured_name (_tmp11_, _tmp12_, _tmp13_);
			} else {
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = prop;
				_tmp15_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_NICKNAME);
				if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
					GVariantDict* _tmp16_;
					const gchar* _tmp17_;
					GValue* _tmp18_;
					_tmp16_ = dict;
					_tmp17_ = prop;
					_tmp18_ = val;
					contacts_io_serialize_nickname (_tmp16_, _tmp17_, _tmp18_);
				} else {
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					_tmp19_ = prop;
					_tmp20_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_BIRTHDAY);
					if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
						GVariantDict* _tmp21_;
						const gchar* _tmp22_;
						GValue* _tmp23_;
						_tmp21_ = dict;
						_tmp22_ = prop;
						_tmp23_ = val;
						contacts_io_serialize_birthday (_tmp21_, _tmp22_, _tmp23_);
					} else {
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						_tmp24_ = prop;
						_tmp25_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES);
						if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
							GVariantDict* _tmp26_;
							const gchar* _tmp27_;
							GValue* _tmp28_;
							_tmp26_ = dict;
							_tmp27_ = prop;
							_tmp28_ = val;
							contacts_io_serialize_addresses (_tmp26_, _tmp27_, _tmp28_);
						} else {
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							_tmp29_ = prop;
							_tmp30_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_PHONE_NUMBERS);
							if (g_strcmp0 (_tmp29_, _tmp30_) == 0) {
								GVariantDict* _tmp31_;
								const gchar* _tmp32_;
								GValue* _tmp33_;
								_tmp31_ = dict;
								_tmp32_ = prop;
								_tmp33_ = val;
								contacts_io_serialize_phone_nrs (_tmp31_, _tmp32_, _tmp33_);
							} else {
								const gchar* _tmp34_;
								const gchar* _tmp35_;
								_tmp34_ = prop;
								_tmp35_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES);
								if (g_strcmp0 (_tmp34_, _tmp35_) == 0) {
									GVariantDict* _tmp36_;
									const gchar* _tmp37_;
									GValue* _tmp38_;
									_tmp36_ = dict;
									_tmp37_ = prop;
									_tmp38_ = val;
									contacts_io_serialize_emails (_tmp36_, _tmp37_, _tmp38_);
								} else {
									const gchar* _tmp39_;
									const gchar* _tmp40_;
									_tmp39_ = prop;
									_tmp40_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_NOTES);
									if (g_strcmp0 (_tmp39_, _tmp40_) == 0) {
										GVariantDict* _tmp41_;
										const gchar* _tmp42_;
										GValue* _tmp43_;
										_tmp41_ = dict;
										_tmp42_ = prop;
										_tmp43_ = val;
										contacts_io_serialize_notes (_tmp41_, _tmp42_, _tmp43_);
									} else {
										const gchar* _tmp44_;
										const gchar* _tmp45_;
										_tmp44_ = prop;
										_tmp45_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_URLS);
										if (g_strcmp0 (_tmp44_, _tmp45_) == 0) {
											GVariantDict* _tmp46_;
											const gchar* _tmp47_;
											GValue* _tmp48_;
											_tmp46_ = dict;
											_tmp47_ = prop;
											_tmp48_ = val;
											contacts_io_serialize_urls (_tmp46_, _tmp47_, _tmp48_);
										} else {
											const gchar* _tmp49_;
											_tmp49_ = prop;
											g_warning ("contacts-io.vala:72: Couldn't serialize unknown property '%s'", _tmp49_);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp50_ = dict;
	_tmp51_ = g_variant_dict_end (_tmp50_);
	g_variant_ref_sink (_tmp51_);
	result = _tmp51_;
	_g_variant_dict_unref0 (dict);
	return result;
}

/**
   * Deserializes the {@link GLib.Variant} back into a {@link GLib.HashTable}.
   */
static void
_g_hash_table_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}

GHashTable**
contacts_io_deserialize_gvariant (GVariant* variant,
                                  gint* result_length1)
{
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	GPtrArray* _result_ = NULL;
	GPtrArray* _tmp3_;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp4_;
	GVariant* element = NULL;
	GPtrArray* _tmp11_;
	gsize _tmp12_ = 0;
	gpointer* _tmp13_;
	GHashTable** _tmp14_;
	gint _tmp14__length1;
	GHashTable** result;
	g_return_val_if_fail (variant != NULL, NULL);
	_tmp0_ = g_variant_get_type (variant);
	_tmp1_ = g_variant_type_new ("aa{sv}");
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (g_variant_type_equal (_tmp0_, _tmp2_), NULL);
	_g_variant_type_free0 (_tmp2_);
	_tmp3_ = g_ptr_array_new_full ((guint) 0, _g_hash_table_unref0_);
	_result_ = _tmp3_;
	_tmp4_ = g_variant_iter_new (variant);
	iter = _tmp4_;
	while (TRUE) {
		GVariantIter* _tmp5_;
		GVariant* _tmp6_ = NULL;
		gboolean _tmp7_;
		GPtrArray* _tmp8_;
		GVariant* _tmp9_;
		GHashTable* _tmp10_;
		_tmp5_ = iter;
		_tmp7_ = g_variant_iter_next (_tmp5_, "@a{sv}", &_tmp6_, NULL);
		_g_variant_unref0 (element);
		element = _tmp6_;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = _result_;
		_tmp9_ = element;
		_tmp10_ = contacts_io_deserialize_gvariant_single (_tmp9_);
		g_ptr_array_add (_tmp8_, _tmp10_);
	}
	_tmp11_ = _result_;
	_tmp13_ = g_ptr_array_steal (_tmp11_, &_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _tmp12_;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	_g_variant_unref0 (element);
	_g_variant_iter_free0 (iter);
	_g_ptr_array_unref0 (_result_);
	return result;
}

/**
   * Deserializes the {@link GLib.Variant} back into a {@link GLib.HashTable}.
   */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
__vala_GValue_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}

GHashTable*
contacts_io_deserialize_gvariant_single (GVariant* variant)
{
	const GVariantType* _tmp0_;
	const GVariantType* _tmp1_;
	GHashTable* details = NULL;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp5_;
	gchar* prop = NULL;
	GVariant* val = NULL;
	GHashTable* result;
	g_return_val_if_fail (variant != NULL, NULL);
	_tmp0_ = g_variant_get_type (variant);
	_tmp1_ = G_VARIANT_TYPE_VARDICT;
	g_return_val_if_fail (g_variant_type_equal (_tmp0_, _tmp1_), NULL);
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, __vala_GValue_free0_);
	details = _tmp4_;
	_tmp5_ = g_variant_iter_new (variant);
	iter = _tmp5_;
	while (TRUE) {
		GVariantIter* _tmp6_;
		gchar* _tmp7_ = NULL;
		GVariant* _tmp8_ = NULL;
		gboolean _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp6_ = iter;
		_tmp9_ = g_variant_iter_next (_tmp6_, "{sv}", &_tmp7_, &_tmp8_, NULL);
		_g_free0 (prop);
		prop = _tmp7_;
		_g_variant_unref0 (val);
		val = _tmp8_;
		if (!_tmp9_) {
			break;
		}
		_tmp10_ = prop;
		_tmp11_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
		if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
			GHashTable* _tmp12_;
			const gchar* _tmp13_;
			GVariant* _tmp14_;
			_tmp12_ = details;
			_tmp13_ = prop;
			_tmp14_ = val;
			contacts_io_deserialize_full_name (_tmp12_, _tmp13_, _tmp14_);
		} else {
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = prop;
			_tmp16_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_STRUCTURED_NAME);
			if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
				GHashTable* _tmp17_;
				const gchar* _tmp18_;
				GVariant* _tmp19_;
				_tmp17_ = details;
				_tmp18_ = prop;
				_tmp19_ = val;
				contacts_io_deserialize_structured_name (_tmp17_, _tmp18_, _tmp19_);
			} else {
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				_tmp20_ = prop;
				_tmp21_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_NICKNAME);
				if (g_strcmp0 (_tmp20_, _tmp21_) == 0) {
					GHashTable* _tmp22_;
					const gchar* _tmp23_;
					GVariant* _tmp24_;
					_tmp22_ = details;
					_tmp23_ = prop;
					_tmp24_ = val;
					contacts_io_deserialize_nickname (_tmp22_, _tmp23_, _tmp24_);
				} else {
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					_tmp25_ = prop;
					_tmp26_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_BIRTHDAY);
					if (g_strcmp0 (_tmp25_, _tmp26_) == 0) {
						GHashTable* _tmp27_;
						const gchar* _tmp28_;
						GVariant* _tmp29_;
						_tmp27_ = details;
						_tmp28_ = prop;
						_tmp29_ = val;
						contacts_io_deserialize_birthday (_tmp27_, _tmp28_, _tmp29_);
					} else {
						const gchar* _tmp30_;
						const gchar* _tmp31_;
						_tmp30_ = prop;
						_tmp31_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES);
						if (g_strcmp0 (_tmp30_, _tmp31_) == 0) {
							GHashTable* _tmp32_;
							const gchar* _tmp33_;
							GVariant* _tmp34_;
							_tmp32_ = details;
							_tmp33_ = prop;
							_tmp34_ = val;
							contacts_io_deserialize_addresses (_tmp32_, _tmp33_, _tmp34_);
						} else {
							const gchar* _tmp35_;
							const gchar* _tmp36_;
							_tmp35_ = prop;
							_tmp36_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_PHONE_NUMBERS);
							if (g_strcmp0 (_tmp35_, _tmp36_) == 0) {
								GHashTable* _tmp37_;
								const gchar* _tmp38_;
								GVariant* _tmp39_;
								_tmp37_ = details;
								_tmp38_ = prop;
								_tmp39_ = val;
								contacts_io_deserialize_phone_nrs (_tmp37_, _tmp38_, _tmp39_);
							} else {
								const gchar* _tmp40_;
								const gchar* _tmp41_;
								_tmp40_ = prop;
								_tmp41_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES);
								if (g_strcmp0 (_tmp40_, _tmp41_) == 0) {
									GHashTable* _tmp42_;
									const gchar* _tmp43_;
									GVariant* _tmp44_;
									_tmp42_ = details;
									_tmp43_ = prop;
									_tmp44_ = val;
									contacts_io_deserialize_emails (_tmp42_, _tmp43_, _tmp44_);
								} else {
									const gchar* _tmp45_;
									const gchar* _tmp46_;
									_tmp45_ = prop;
									_tmp46_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_NOTES);
									if (g_strcmp0 (_tmp45_, _tmp46_) == 0) {
										GHashTable* _tmp47_;
										const gchar* _tmp48_;
										GVariant* _tmp49_;
										_tmp47_ = details;
										_tmp48_ = prop;
										_tmp49_ = val;
										contacts_io_deserialize_notes (_tmp47_, _tmp48_, _tmp49_);
									} else {
										const gchar* _tmp50_;
										const gchar* _tmp51_;
										_tmp50_ = prop;
										_tmp51_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_URLS);
										if (g_strcmp0 (_tmp50_, _tmp51_) == 0) {
											GHashTable* _tmp52_;
											const gchar* _tmp53_;
											GVariant* _tmp54_;
											_tmp52_ = details;
											_tmp53_ = prop;
											_tmp54_ = val;
											contacts_io_deserialize_urls (_tmp52_, _tmp53_, _tmp54_);
										} else {
											const gchar* _tmp55_;
											_tmp55_ = prop;
											g_warning ("contacts-io.vala:128: Couldn't serialize unknown property '%s'", _tmp55_);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = details;
	_g_variant_unref0 (val);
	_g_free0 (prop);
	_g_variant_iter_free0 (iter);
	return result;
}

gboolean
contacts_io_serialize_full_name (GVariantDict* dict,
                                 const gchar* prop,
                                 GValue* val)
{
	const gchar* full_name = NULL;
	gboolean result;
	g_return_val_if_fail (dict != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (G_VALUE_TYPE (val) == G_TYPE_STRING, FALSE);
	full_name = g_value_get_string (val);
	g_return_val_if_fail (full_name != NULL, FALSE);
	g_variant_dict_insert (dict, prop, CONTACTS_IO_FULL_NAME_TYPE, full_name, NULL);
	result = TRUE;
	return result;
}

gboolean
contacts_io_deserialize_full_name (GHashTable* details,
                                   const gchar* prop,
                                   GVariant* variant)
{
	const GVariantType* _tmp0_;
	const GVariantType* _tmp1_;
	const gchar* full_name = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GValue* _tmp4_ = NULL;
	gboolean result;
	g_return_val_if_fail (details != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_type (variant);
	_tmp1_ = G_VARIANT_TYPE_STRING;
	g_return_val_if_fail (g_variant_type_equal (_tmp0_, _tmp1_), FALSE);
	_tmp2_ = g_variant_get_string (variant, NULL);
	full_name = _tmp2_;
	g_return_val_if_fail (full_name != NULL, FALSE);
	_tmp3_ = g_strdup (prop);
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_STRING);
	g_value_set_string (_tmp4_, full_name);
	g_hash_table_insert (details, _tmp3_, _tmp4_);
	result = TRUE;
	return result;
}

gboolean
contacts_io_serialize_structured_name (GVariantDict* dict,
                                       const gchar* prop,
                                       GValue* val)
{
	FolksStructuredName* name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gboolean result;
	g_return_val_if_fail (dict != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (G_VALUE_TYPE (val) == FOLKS_TYPE_STRUCTURED_NAME, FALSE);
	name = g_value_get_object (val);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = folks_structured_name_get_family_name (name);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_structured_name_get_given_name (name);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_structured_name_get_additional_names (name);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_structured_name_get_prefixes (name);
	_tmp7_ = _tmp6_;
	_tmp8_ = folks_structured_name_get_suffixes (name);
	_tmp9_ = _tmp8_;
	g_variant_dict_insert (dict, prop, CONTACTS_IO_STRUCTURED_NAME_TYPE, _tmp1_, _tmp3_, _tmp5_, _tmp7_, _tmp9_, NULL);
	result = TRUE;
	return result;
}

gboolean
contacts_io_deserialize_structured_name (GHashTable* details,
                                         const gchar* prop,
                                         GVariant* variant)
{
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	gchar* family_name = NULL;
	gchar* given_name = NULL;
	gchar* additional_names = NULL;
	gchar* prefixes = NULL;
	gchar* suffixes = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	FolksStructuredName* structured_name = NULL;
	FolksStructuredName* _tmp8_;
	gchar* _tmp9_;
	GValue* _tmp10_ = NULL;
	gboolean result;
	g_return_val_if_fail (details != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_type (variant);
	_tmp1_ = g_variant_type_new (CONTACTS_IO_STRUCTURED_NAME_TYPE);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (g_variant_type_equal (_tmp0_, _tmp2_), FALSE);
	_g_variant_type_free0 (_tmp2_);
	g_variant_get (variant, CONTACTS_IO_STRUCTURED_NAME_TYPE, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, NULL);
	_g_free0 (family_name);
	family_name = _tmp3_;
	_g_free0 (given_name);
	given_name = _tmp4_;
	_g_free0 (additional_names);
	additional_names = _tmp5_;
	_g_free0 (prefixes);
	prefixes = _tmp6_;
	_g_free0 (suffixes);
	suffixes = _tmp7_;
	_tmp8_ = folks_structured_name_new (family_name, given_name, additional_names, prefixes, suffixes);
	structured_name = _tmp8_;
	_tmp9_ = g_strdup (prop);
	_tmp10_ = g_new0 (GValue, 1);
	g_value_init (_tmp10_, FOLKS_TYPE_STRUCTURED_NAME);
	g_value_set_object (_tmp10_, structured_name);
	g_hash_table_insert (details, _tmp9_, _tmp10_);
	result = TRUE;
	_g_object_unref0 (structured_name);
	_g_free0 (suffixes);
	_g_free0 (prefixes);
	_g_free0 (additional_names);
	_g_free0 (given_name);
	_g_free0 (family_name);
	return result;
}

gboolean
contacts_io_serialize_nickname (GVariantDict* dict,
                                const gchar* prop,
                                GValue* val)
{
	const gchar* nickname = NULL;
	gboolean result;
	g_return_val_if_fail (dict != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (G_VALUE_TYPE (val) == G_TYPE_STRING, FALSE);
	nickname = g_value_get_string (val);
	g_return_val_if_fail (nickname != NULL, FALSE);
	g_variant_dict_insert (dict, prop, CONTACTS_IO_NICKNAME_TYPE, nickname, NULL);
	result = TRUE;
	return result;
}

gboolean
contacts_io_deserialize_nickname (GHashTable* details,
                                  const gchar* prop,
                                  GVariant* variant)
{
	const GVariantType* _tmp0_;
	const GVariantType* _tmp1_;
	const gchar* nickname = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GValue* _tmp4_ = NULL;
	gboolean result;
	g_return_val_if_fail (details != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_type (variant);
	_tmp1_ = G_VARIANT_TYPE_STRING;
	g_return_val_if_fail (g_variant_type_equal (_tmp0_, _tmp1_), FALSE);
	_tmp2_ = g_variant_get_string (variant, NULL);
	nickname = _tmp2_;
	g_return_val_if_fail (nickname != NULL, FALSE);
	_tmp3_ = g_strdup (prop);
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_STRING);
	g_value_set_string (_tmp4_, nickname);
	g_hash_table_insert (details, _tmp3_, _tmp4_);
	result = TRUE;
	return result;
}

gboolean
contacts_io_serialize_birthday (GVariantDict* dict,
                                const gchar* prop,
                                GValue* val)
{
	GDateTime* bd = NULL;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean result;
	g_return_val_if_fail (dict != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (G_VALUE_TYPE (val) == G_TYPE_DATE_TIME, FALSE);
	bd = g_value_get_boxed (val);
	g_return_val_if_fail (bd != NULL, FALSE);
	g_date_time_get_ymd (bd, &_tmp0_, &_tmp1_, &_tmp2_);
	year = _tmp0_;
	month = _tmp1_;
	day = _tmp2_;
	g_variant_dict_insert (dict, prop, CONTACTS_IO_BIRTHDAY_TYPE, year, month, day, NULL);
	result = TRUE;
	return result;
}

gboolean
contacts_io_deserialize_birthday (GHashTable* details,
                                  const gchar* prop,
                                  GVariant* variant)
{
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GDateTime* bd = NULL;
	GDateTime* _tmp6_;
	gchar* _tmp7_;
	GValue* _tmp8_ = NULL;
	gboolean result;
	g_return_val_if_fail (details != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_type (variant);
	_tmp1_ = g_variant_type_new (CONTACTS_IO_BIRTHDAY_TYPE);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (g_variant_type_equal (_tmp0_, _tmp2_), FALSE);
	_g_variant_type_free0 (_tmp2_);
	g_variant_get (variant, CONTACTS_IO_BIRTHDAY_TYPE, &_tmp3_, &_tmp4_, &_tmp5_, NULL);
	year = _tmp3_;
	month = _tmp4_;
	day = _tmp5_;
	_tmp6_ = g_date_time_new_utc (year, month, day, 0, 0, 0.0);
	bd = _tmp6_;
	_tmp7_ = g_strdup (prop);
	_tmp8_ = g_new0 (GValue, 1);
	g_value_init (_tmp8_, G_TYPE_DATE_TIME);
	g_value_set_boxed (_tmp8_, bd);
	g_hash_table_insert (details, _tmp7_, _tmp8_);
	result = TRUE;
	_g_date_time_unref0 (bd);
	return result;
}

gboolean
contacts_io_serialize_addresses (GVariantDict* dict,
                                 const gchar* prop,
                                 GValue* val)
{
	GeeSet* afds = NULL;
	GeeSet* _tmp0_;
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp36_;
	GVariant* _tmp37_;
	GVariant* _tmp38_;
	gboolean result;
	g_return_val_if_fail (dict != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (G_VALUE_TYPE (val) == GEE_TYPE_SET, FALSE);
	afds = g_value_get_object (val);
	_tmp0_ = afds;
	g_return_val_if_fail (_tmp0_ != NULL, FALSE);
	_tmp1_ = G_VARIANT_TYPE_ARRAY;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	builder = _tmp2_;
	{
		GeeIterator* _afd_it = NULL;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp3_ = afds;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_afd_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			FolksPostalAddressFieldDetails* afd = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			FolksPostalAddress* addr = NULL;
			FolksPostalAddressFieldDetails* _tmp8_;
			gconstpointer _tmp9_;
			gconstpointer _tmp10_;
			GVariantBuilder* _tmp11_;
			FolksPostalAddress* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			FolksPostalAddress* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			FolksPostalAddress* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			FolksPostalAddress* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			FolksPostalAddress* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			FolksPostalAddress* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			FolksPostalAddress* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			FolksPostalAddressFieldDetails* _tmp33_;
			GVariant* _tmp34_;
			GVariant* _tmp35_;
			_tmp5_ = _afd_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _afd_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			afd = (FolksPostalAddressFieldDetails*) _tmp7_;
			_tmp8_ = afd;
			_tmp9_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp8_);
			_tmp10_ = _tmp9_;
			addr = (FolksPostalAddress*) _tmp10_;
			_tmp11_ = builder;
			_tmp12_ = addr;
			_tmp13_ = folks_postal_address_get_po_box (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = addr;
			_tmp16_ = folks_postal_address_get_extension (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = addr;
			_tmp19_ = folks_postal_address_get_street (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = addr;
			_tmp22_ = folks_postal_address_get_locality (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = addr;
			_tmp25_ = folks_postal_address_get_region (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = addr;
			_tmp28_ = folks_postal_address_get_postal_code (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = addr;
			_tmp31_ = folks_postal_address_get_country (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = afd;
			_tmp34_ = contacts_io_serialize_parameters ((FolksAbstractFieldDetails*) _tmp33_);
			_tmp35_ = _tmp34_;
			g_variant_builder_add (_tmp11_, CONTACTS_IO_ADDRESS_TYPE, _tmp14_, _tmp17_, _tmp20_, _tmp23_, _tmp26_, _tmp29_, _tmp32_, _tmp35_, NULL);
			_g_variant_unref0 (_tmp35_);
			_g_object_unref0 (afd);
		}
		_g_object_unref0 (_afd_it);
	}
	_tmp36_ = builder;
	_tmp37_ = g_variant_builder_end (_tmp36_);
	g_variant_ref_sink (_tmp37_);
	_tmp38_ = _tmp37_;
	g_variant_dict_insert_value (dict, prop, _tmp38_);
	_g_variant_unref0 (_tmp38_);
	result = TRUE;
	_g_variant_builder_unref0 (builder);
	return result;
}

gboolean
contacts_io_deserialize_addresses (GHashTable* details,
                                   const gchar* prop,
                                   GVariant* variant)
{
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	GeeHashSet* afds = NULL;
	GeeHashSet* _tmp3_;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp4_;
	gchar* po_box = NULL;
	gchar* extension = NULL;
	gchar* street = NULL;
	gchar* locality = NULL;
	gchar* region = NULL;
	gchar* postal_code = NULL;
	gchar* country = NULL;
	GVariant* parameters = NULL;
	gchar* _tmp42_;
	GeeHashSet* _tmp43_;
	GValue* _tmp44_ = NULL;
	gboolean result;
	g_return_val_if_fail (details != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_type (variant);
	_tmp1_ = g_variant_type_new ("a" CONTACTS_IO_ADDRESS_TYPE);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (g_variant_type_equal (_tmp0_, _tmp2_), FALSE);
	_g_variant_type_free0 (_tmp2_);
	_tmp3_ = gee_hash_set_new (FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	afds = _tmp3_;
	_tmp4_ = g_variant_iter_new (variant);
	iter = _tmp4_;
	while (TRUE) {
		GVariantIter* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GVariant* _tmp13_ = NULL;
		gboolean _tmp14_;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		const gchar* _tmp21_;
		FolksPostalAddress* addr = NULL;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		FolksPostalAddress* _tmp35_;
		FolksPostalAddressFieldDetails* afd = NULL;
		FolksPostalAddress* _tmp36_;
		FolksPostalAddressFieldDetails* _tmp37_;
		GVariant* _tmp38_;
		FolksPostalAddressFieldDetails* _tmp39_;
		GeeHashSet* _tmp40_;
		FolksPostalAddressFieldDetails* _tmp41_;
		_tmp5_ = iter;
		_tmp14_ = g_variant_iter_next (_tmp5_, CONTACTS_IO_ADDRESS_TYPE, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, NULL);
		_g_free0 (po_box);
		po_box = _tmp6_;
		_g_free0 (extension);
		extension = _tmp7_;
		_g_free0 (street);
		street = _tmp8_;
		_g_free0 (locality);
		locality = _tmp9_;
		_g_free0 (region);
		region = _tmp10_;
		_g_free0 (postal_code);
		postal_code = _tmp11_;
		_g_free0 (country);
		country = _tmp12_;
		_g_variant_unref0 (parameters);
		parameters = _tmp13_;
		if (!_tmp14_) {
			break;
		}
		_tmp21_ = po_box;
		if (g_strcmp0 (_tmp21_, "") == 0) {
			const gchar* _tmp22_;
			_tmp22_ = extension;
			_tmp20_ = g_strcmp0 (_tmp22_, "") == 0;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			const gchar* _tmp23_;
			_tmp23_ = street;
			_tmp19_ = g_strcmp0 (_tmp23_, "") == 0;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			const gchar* _tmp24_;
			_tmp24_ = locality;
			_tmp18_ = g_strcmp0 (_tmp24_, "") == 0;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			const gchar* _tmp25_;
			_tmp25_ = region;
			_tmp17_ = g_strcmp0 (_tmp25_, "") == 0;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			const gchar* _tmp26_;
			_tmp26_ = postal_code;
			_tmp16_ = g_strcmp0 (_tmp26_, "") == 0;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			const gchar* _tmp27_;
			_tmp27_ = country;
			_tmp15_ = g_strcmp0 (_tmp27_, "") == 0;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			g_warning ("contacts-io.vala:311: Got empty postal address");
			continue;
		}
		_tmp28_ = po_box;
		_tmp29_ = extension;
		_tmp30_ = street;
		_tmp31_ = locality;
		_tmp32_ = region;
		_tmp33_ = postal_code;
		_tmp34_ = country;
		_tmp35_ = folks_postal_address_new (_tmp28_, _tmp29_, _tmp30_, _tmp31_, _tmp32_, _tmp33_, _tmp34_, "", NULL);
		addr = _tmp35_;
		_tmp36_ = addr;
		_tmp37_ = folks_postal_address_field_details_new (_tmp36_, NULL);
		afd = _tmp37_;
		_tmp38_ = parameters;
		_tmp39_ = afd;
		contacts_io_deserialize_parameters (_tmp38_, (FolksAbstractFieldDetails*) _tmp39_);
		_tmp40_ = afds;
		_tmp41_ = afd;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, _tmp41_);
		_g_object_unref0 (afd);
		_g_object_unref0 (addr);
	}
	_tmp42_ = g_strdup (prop);
	_tmp43_ = afds;
	_tmp44_ = g_new0 (GValue, 1);
	g_value_init (_tmp44_, GEE_TYPE_HASH_SET);
	g_value_set_object (_tmp44_, _tmp43_);
	g_hash_table_insert (details, _tmp42_, _tmp44_);
	result = TRUE;
	_g_variant_unref0 (parameters);
	_g_free0 (country);
	_g_free0 (postal_code);
	_g_free0 (region);
	_g_free0 (locality);
	_g_free0 (street);
	_g_free0 (extension);
	_g_free0 (po_box);
	_g_variant_iter_free0 (iter);
	_g_object_unref0 (afds);
	return result;
}

gboolean
contacts_io_serialize_phone_nrs (GVariantDict* dict,
                                 const gchar* prop,
                                 GValue* val)
{
	gboolean result;
	g_return_val_if_fail (dict != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	result = contacts_io_serialize_afd_strings (dict, prop, val);
	return result;
}

static FolksAbstractFieldDetails*
__lambda16_ (const gchar* str)
{
	FolksPhoneFieldDetails* _tmp0_;
	FolksAbstractFieldDetails* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = folks_phone_field_details_new (str, NULL);
	result = (FolksAbstractFieldDetails*) _tmp0_;
	return result;
}

static FolksAbstractFieldDetails*
___lambda16__contacts_io_create_abstract_field_str_func (const gchar* value,
                                                         gpointer self)
{
	FolksAbstractFieldDetails* result;
	result = __lambda16_ (value);
	return result;
}

gboolean
contacts_io_deserialize_phone_nrs (GHashTable* details,
                                   const gchar* prop,
                                   GVariant* variant)
{
	gboolean result;
	g_return_val_if_fail (details != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	result = contacts_io_deserialize_afd_str (details, prop, variant, ___lambda16__contacts_io_create_abstract_field_str_func, NULL);
	return result;
}

gboolean
contacts_io_serialize_emails (GVariantDict* dict,
                              const gchar* prop,
                              GValue* val)
{
	gboolean result;
	g_return_val_if_fail (dict != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	result = contacts_io_serialize_afd_strings (dict, prop, val);
	return result;
}

static FolksAbstractFieldDetails*
__lambda17_ (const gchar* str)
{
	FolksEmailFieldDetails* _tmp0_;
	FolksAbstractFieldDetails* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = folks_email_field_details_new (str, NULL);
	result = (FolksAbstractFieldDetails*) _tmp0_;
	return result;
}

static FolksAbstractFieldDetails*
___lambda17__contacts_io_create_abstract_field_str_func (const gchar* value,
                                                         gpointer self)
{
	FolksAbstractFieldDetails* result;
	result = __lambda17_ (value);
	return result;
}

gboolean
contacts_io_deserialize_emails (GHashTable* details,
                                const gchar* prop,
                                GVariant* variant)
{
	gboolean result;
	g_return_val_if_fail (details != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	result = contacts_io_deserialize_afd_str (details, prop, variant, ___lambda17__contacts_io_create_abstract_field_str_func, NULL);
	return result;
}

gboolean
contacts_io_serialize_notes (GVariantDict* dict,
                             const gchar* prop,
                             GValue* val)
{
	gboolean result;
	g_return_val_if_fail (dict != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	result = contacts_io_serialize_afd_strings (dict, prop, val);
	return result;
}

static FolksAbstractFieldDetails*
__lambda18_ (const gchar* str)
{
	FolksNoteFieldDetails* _tmp0_;
	FolksAbstractFieldDetails* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = folks_note_field_details_new (str, NULL, NULL);
	result = (FolksAbstractFieldDetails*) _tmp0_;
	return result;
}

static FolksAbstractFieldDetails*
___lambda18__contacts_io_create_abstract_field_str_func (const gchar* value,
                                                         gpointer self)
{
	FolksAbstractFieldDetails* result;
	result = __lambda18_ (value);
	return result;
}

gboolean
contacts_io_deserialize_notes (GHashTable* details,
                               const gchar* prop,
                               GVariant* variant)
{
	gboolean result;
	g_return_val_if_fail (details != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	result = contacts_io_deserialize_afd_str (details, prop, variant, ___lambda18__contacts_io_create_abstract_field_str_func, NULL);
	return result;
}

gboolean
contacts_io_serialize_urls (GVariantDict* dict,
                            const gchar* prop,
                            GValue* val)
{
	gboolean result;
	g_return_val_if_fail (dict != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	result = contacts_io_serialize_afd_strings (dict, prop, val);
	return result;
}

static FolksAbstractFieldDetails*
__lambda19_ (const gchar* str)
{
	FolksUrlFieldDetails* _tmp0_;
	FolksAbstractFieldDetails* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = folks_url_field_details_new (str, NULL);
	result = (FolksAbstractFieldDetails*) _tmp0_;
	return result;
}

static FolksAbstractFieldDetails*
___lambda19__contacts_io_create_abstract_field_str_func (const gchar* value,
                                                         gpointer self)
{
	FolksAbstractFieldDetails* result;
	result = __lambda19_ (value);
	return result;
}

gboolean
contacts_io_deserialize_urls (GHashTable* details,
                              const gchar* prop,
                              GVariant* variant)
{
	gboolean result;
	g_return_val_if_fail (details != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	result = contacts_io_deserialize_afd_str (details, prop, variant, ___lambda19__contacts_io_create_abstract_field_str_func, NULL);
	return result;
}

gboolean
contacts_io_serialize_afd_strings (GVariantDict* dict,
                                   const gchar* prop,
                                   GValue* val)
{
	GeeSet* afds = NULL;
	GeeSet* _tmp0_;
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	gboolean result;
	g_return_val_if_fail (dict != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (G_VALUE_TYPE (val) == GEE_TYPE_SET, FALSE);
	afds = g_value_get_object (val);
	_tmp0_ = afds;
	g_return_val_if_fail (_tmp0_ != NULL, FALSE);
	_tmp1_ = G_VARIANT_TYPE_ARRAY;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	builder = _tmp2_;
	{
		GeeIterator* _afd_it = NULL;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp3_ = afds;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_afd_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			FolksAbstractFieldDetails* afd = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GVariantBuilder* _tmp8_;
			FolksAbstractFieldDetails* _tmp9_;
			gconstpointer _tmp10_;
			gconstpointer _tmp11_;
			FolksAbstractFieldDetails* _tmp12_;
			GVariant* _tmp13_;
			GVariant* _tmp14_;
			_tmp5_ = _afd_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _afd_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			afd = (FolksAbstractFieldDetails*) _tmp7_;
			_tmp8_ = builder;
			_tmp9_ = afd;
			_tmp10_ = folks_abstract_field_details_get_value (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = afd;
			_tmp13_ = contacts_io_serialize_parameters (_tmp12_);
			_tmp14_ = _tmp13_;
			g_variant_builder_add (_tmp8_, CONTACTS_IO_AFD_STRING_TYPE, (const gchar*) _tmp11_, _tmp14_, NULL);
			_g_variant_unref0 (_tmp14_);
			_g_object_unref0 (afd);
		}
		_g_object_unref0 (_afd_it);
	}
	_tmp15_ = builder;
	_tmp16_ = g_variant_builder_end (_tmp15_);
	g_variant_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	g_variant_dict_insert_value (dict, prop, _tmp17_);
	_g_variant_unref0 (_tmp17_);
	result = TRUE;
	_g_variant_builder_unref0 (builder);
	return result;
}

gboolean
contacts_io_deserialize_afd_str (GHashTable* details,
                                 const gchar* prop,
                                 GVariant* variant,
                                 ContactsIoCreateAbstractFieldStrFunc create_afd_func,
                                 gpointer create_afd_func_target)
{
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	GeeHashSet* afds = NULL;
	GeeHashSet* _tmp3_;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp4_;
	gchar* str = NULL;
	GVariant* parameters = NULL;
	gchar* _tmp15_;
	GeeHashSet* _tmp16_;
	GValue* _tmp17_ = NULL;
	gboolean result;
	g_return_val_if_fail (details != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_type (variant);
	_tmp1_ = g_variant_type_new ("a" CONTACTS_IO_AFD_STRING_TYPE);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (g_variant_type_equal (_tmp0_, _tmp2_), FALSE);
	_g_variant_type_free0 (_tmp2_);
	_tmp3_ = gee_hash_set_new (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	afds = _tmp3_;
	_tmp4_ = g_variant_iter_new (variant);
	iter = _tmp4_;
	while (TRUE) {
		GVariantIter* _tmp5_;
		gchar* _tmp6_ = NULL;
		GVariant* _tmp7_ = NULL;
		gboolean _tmp8_;
		FolksAbstractFieldDetails* afd = NULL;
		const gchar* _tmp9_;
		FolksAbstractFieldDetails* _tmp10_;
		GVariant* _tmp11_;
		FolksAbstractFieldDetails* _tmp12_;
		GeeHashSet* _tmp13_;
		FolksAbstractFieldDetails* _tmp14_;
		_tmp5_ = iter;
		_tmp8_ = g_variant_iter_next (_tmp5_, CONTACTS_IO_AFD_STRING_TYPE, &_tmp6_, &_tmp7_, NULL);
		_g_free0 (str);
		str = _tmp6_;
		_g_variant_unref0 (parameters);
		parameters = _tmp7_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = str;
		_tmp10_ = create_afd_func (_tmp9_, create_afd_func_target);
		afd = _tmp10_;
		_tmp11_ = parameters;
		_tmp12_ = afd;
		contacts_io_deserialize_parameters (_tmp11_, _tmp12_);
		_tmp13_ = afds;
		_tmp14_ = afd;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
		_g_object_unref0 (afd);
	}
	_tmp15_ = g_strdup (prop);
	_tmp16_ = afds;
	_tmp17_ = g_new0 (GValue, 1);
	g_value_init (_tmp17_, GEE_TYPE_HASH_SET);
	g_value_set_object (_tmp17_, _tmp16_);
	g_hash_table_insert (details, _tmp15_, _tmp17_);
	result = TRUE;
	_g_variant_unref0 (parameters);
	_g_free0 (str);
	_g_variant_iter_free0 (iter);
	_g_object_unref0 (afds);
	return result;
}

GVariant*
contacts_io_serialize_parameters (FolksAbstractFieldDetails* details)
{
	gboolean _tmp0_ = FALSE;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp8_;
	GVariantBuilder* _tmp9_;
	GeeMapIterator* iter = NULL;
	GeeMultiMap* _tmp10_;
	GeeMultiMap* _tmp11_;
	GeeMapIterator* _tmp12_;
	GVariantBuilder* _tmp21_;
	GVariant* _tmp22_;
	GVariant* result;
	g_return_val_if_fail (details != NULL, NULL);
	_tmp1_ = folks_abstract_field_details_get_parameters (details);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GeeMultiMap* _tmp3_;
		GeeMultiMap* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = folks_abstract_field_details_get_parameters (details);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_multi_map_get_size (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == 0;
	}
	if (_tmp0_) {
		GVariant* _tmp7_;
		_tmp7_ = g_variant_new (CONTACTS_IO_PARAMS_TYPE, NULL, NULL);
		g_variant_ref_sink (_tmp7_);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = G_VARIANT_TYPE_ARRAY;
	_tmp9_ = g_variant_builder_new (_tmp8_);
	builder = _tmp9_;
	_tmp10_ = folks_abstract_field_details_get_parameters (details);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_multi_map_map_iterator (_tmp11_);
	iter = _tmp12_;
	while (TRUE) {
		GeeMapIterator* _tmp13_;
		gchar* param_name = NULL;
		GeeMapIterator* _tmp14_;
		gpointer _tmp15_;
		gchar* param_value = NULL;
		GeeMapIterator* _tmp16_;
		gpointer _tmp17_;
		GVariantBuilder* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp13_ = iter;
		if (!gee_map_iterator_next (_tmp13_)) {
			break;
		}
		_tmp14_ = iter;
		_tmp15_ = gee_map_iterator_get_key (_tmp14_);
		param_name = (gchar*) _tmp15_;
		_tmp16_ = iter;
		_tmp17_ = gee_map_iterator_get_value (_tmp16_);
		param_value = (gchar*) _tmp17_;
		_tmp18_ = builder;
		_tmp19_ = param_name;
		_tmp20_ = param_value;
		g_variant_builder_add (_tmp18_, "(ss)", _tmp19_, _tmp20_, NULL);
		_g_free0 (param_value);
		_g_free0 (param_name);
	}
	_tmp21_ = builder;
	_tmp22_ = g_variant_builder_end (_tmp21_);
	g_variant_ref_sink (_tmp22_);
	result = _tmp22_;
	_g_object_unref0 (iter);
	_g_variant_builder_unref0 (builder);
	return result;
}

void
contacts_io_deserialize_parameters (GVariant* parameters,
                                    FolksAbstractFieldDetails* details)
{
	const GVariantType* _tmp0_;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp1_;
	gchar* param_name = NULL;
	gchar* param_value = NULL;
	g_return_if_fail (parameters != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = g_variant_get_type (parameters);
	g_return_if_fail (g_variant_type_is_array (_tmp0_));
	_tmp1_ = g_variant_iter_new (parameters);
	iter = _tmp1_;
	while (TRUE) {
		GVariantIter* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = iter;
		_tmp5_ = g_variant_iter_next (_tmp2_, "(ss)", &_tmp3_, &_tmp4_, NULL);
		_g_free0 (param_name);
		param_name = _tmp3_;
		_g_free0 (param_value);
		param_value = _tmp4_;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = param_name;
		if (g_strcmp0 (_tmp6_, FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE) == 0) {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp7_ = param_name;
			_tmp8_ = param_value;
			_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
			_tmp10_ = _tmp9_;
			folks_abstract_field_details_add_parameter (details, _tmp7_, _tmp10_);
			_g_free0 (_tmp10_);
		} else {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp11_ = param_name;
			_tmp12_ = param_value;
			folks_abstract_field_details_add_parameter (details, _tmp11_, _tmp12_);
		}
	}
	_g_free0 (param_value);
	_g_free0 (param_name);
	_g_variant_iter_free0 (iter);
}

