/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JDialog;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.swing.SwingUtils;

public class ViwableDialog {
    private JDialog jd = null;
    List<Runnable> operations = new ArrayList<Runnable>();
    private final List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();

    private JDialog createJDialog() {
        this.jd = new JDialog();
        this.jd.setName("ViwableDialog");
        SwingUtils.info(this.jd);
        this.jd.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        for (Runnable operation : this.operations) {
            operation.run();
        }
        this.operations = null;
        return this.jd;
    }

    public void setMinimumSize(final Dimension minimumSize) {
        this.operations.add(new Runnable(){

            @Override
            public void run() {
                ViwableDialog.this.jd.setMinimumSize(minimumSize);
            }
        });
    }

    public void pack() {
        this.operations.add(new Runnable(){

            @Override
            public void run() {
                ViwableDialog.this.jd.pack();
            }
        });
    }

    public void setLocationRelativeTo(final Component c) {
        this.operations.add(new Runnable(){

            @Override
            public void run() {
                ViwableDialog.this.jd.setLocationRelativeTo(c);
            }
        });
    }

    public void show() {
        SwingUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (ViwableDialog.this.jd == null) {
                    ViwableDialog.this.jd = ViwableDialog.this.createJDialog();
                }
                ViwableDialog.this.jd.setVisible(true);
            }
        });
    }

    public void dispose() {
        if (this.jd != null) {
            this.notifySelectionMade();
            this.jd.dispose();
            this.jd = null;
        }
    }

    private void notifySelectionMade() {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(null);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void add(final SecurityDialogPanel panel, final String constraints) {
        this.operations.add(new Runnable(){

            @Override
            public void run() {
                ViwableDialog.this.jd.add((Component)panel, constraints);
            }
        });
    }

    public void setModalityType(final Dialog.ModalityType modalityType) {
        this.operations.add(new Runnable(){

            @Override
            public void run() {
                ViwableDialog.this.jd.setModalityType(modalityType);
            }
        });
    }

    public void setTitle(final String title) {
        this.operations.add(new Runnable(){

            @Override
            public void run() {
                ViwableDialog.this.jd.setTitle(title);
            }
        });
    }

    public void setDefaultCloseOperation(final int op) {
        this.operations.add(new Runnable(){

            @Override
            public void run() {
                ViwableDialog.this.jd.setDefaultCloseOperation(op);
            }
        });
    }

    private static void centerDialog(JDialog dialog) {
        ScreenFinder.centerWindowsToCurrentScreen(dialog);
    }

    public void centerDialog() {
        this.operations.add(new Runnable(){

            @Override
            public void run() {
                ViwableDialog.centerDialog(ViwableDialog.this.jd);
            }
        });
    }

    public void setResizable(boolean b) {
        if (this.jd != null) {
            this.jd.setResizable(b);
        }
    }

    public void addWindowListener(final WindowAdapter adapter) {
        this.operations.add(new Runnable(){

            @Override
            public void run() {
                ViwableDialog.this.jd.addWindowListener(adapter);
            }
        });
    }

    public void addWindowFocusListener(final WindowAdapter adapter) {
        this.operations.add(new Runnable(){

            @Override
            public void run() {
                ViwableDialog.this.jd.addWindowFocusListener(adapter);
            }
        });
    }
}

