/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.linux.mips64el;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum Errno implements Constant
{
    EPERM(1L),
    ENOENT(2L),
    ESRCH(3L),
    EINTR(4L),
    EIO(5L),
    ENXIO(6L),
    E2BIG(7L),
    ENOEXEC(8L),
    EBADF(9L),
    ECHILD(10L),
    EDEADLK(45L),
    ENOMEM(12L),
    EACCES(13L),
    EFAULT(14L),
    ENOTBLK(15L),
    EBUSY(16L),
    EEXIST(17L),
    EXDEV(18L),
    ENODEV(19L),
    ENOTDIR(20L),
    EISDIR(21L),
    EINVAL(22L),
    ENFILE(23L),
    EMFILE(24L),
    ENOTTY(25L),
    ETXTBSY(26L),
    EFBIG(27L),
    ENOSPC(28L),
    ESPIPE(29L),
    EROFS(30L),
    EMLINK(31L),
    EPIPE(32L),
    EDOM(33L),
    ERANGE(34L),
    EWOULDBLOCK(11L),
    EAGAIN(11L),
    EINPROGRESS(150L),
    EALREADY(149L),
    ENOTSOCK(95L),
    EDESTADDRREQ(96L),
    EMSGSIZE(97L),
    EPROTOTYPE(98L),
    ENOPROTOOPT(99L),
    EPROTONOSUPPORT(120L),
    ESOCKTNOSUPPORT(121L),
    EOPNOTSUPP(122L),
    EPFNOSUPPORT(123L),
    EAFNOSUPPORT(124L),
    EADDRINUSE(125L),
    EADDRNOTAVAIL(126L),
    ENETDOWN(127L),
    ENETUNREACH(128L),
    ENETRESET(129L),
    ECONNABORTED(130L),
    ECONNRESET(131L),
    ENOBUFS(132L),
    EISCONN(133L),
    ENOTCONN(134L),
    ESHUTDOWN(143L),
    ETOOMANYREFS(144L),
    ETIMEDOUT(145L),
    ECONNREFUSED(146L),
    ELOOP(90L),
    ENAMETOOLONG(78L),
    EHOSTDOWN(147L),
    EHOSTUNREACH(148L),
    ENOTEMPTY(93L),
    EUSERS(94L),
    EDQUOT(1133L),
    ESTALE(151L),
    EREMOTE(66L),
    ENOLCK(46L),
    ENOSYS(89L),
    EOVERFLOW(79L),
    EIDRM(36L),
    ENOMSG(35L),
    EILSEQ(88L),
    EBADMSG(77L),
    EMULTIHOP(74L),
    ENODATA(61L),
    ENOLINK(67L),
    ENOSR(63L),
    ENOSTR(60L),
    EPROTO(71L),
    ETIME(62L),
    ECHRNG(37L),
    EL2NSYNC(38L),
    EL3HLT(39L),
    EL3RST(40L),
    ELNRNG(41L),
    EUNATCH(42L),
    ENOCSI(43L),
    EL2HLT(44L),
    EBADE(50L),
    EBADR(51L),
    EXFULL(52L),
    ENOANO(53L),
    EBADRQC(54L),
    EBADSLT(55L),
    EDEADLOCK(56L),
    EBFONT(59L),
    ENONET(64L),
    ENOPKG(65L),
    EADV(68L),
    ESRMNT(69L),
    ECOMM(70L),
    EDOTDOT(73L),
    ENOTUNIQ(80L),
    EBADFD(81L),
    EREMCHG(82L),
    ELIBACC(83L),
    ELIBBAD(84L),
    ELIBSCN(85L),
    ELIBMAX(86L),
    ELIBEXEC(87L),
    ERESTART(91L),
    ESTRPIPE(92L),
    EUCLEAN(135L),
    ENOTNAM(137L),
    ENAVAIL(138L),
    EISNAM(139L),
    EREMOTEIO(140L),
    ECANCELED(158L),
    EKEYEXPIRED(162L),
    EKEYREJECTED(164L),
    EKEYREVOKED(163L),
    EMEDIUMTYPE(160L),
    ENOKEY(161L),
    ENOMEDIUM(159L),
    ENOTRECOVERABLE(166L),
    EOWNERDEAD(165L),
    ERFKILL(167L),
    ENOTSUP(122L),
    EHWPOISON(168L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 1133L;

    private Errno(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map2 = new EnumMap<Errno, String>(Errno.class);
            map2.put(EPERM, "Operation not permitted");
            map2.put(ENOENT, "No such file or directory");
            map2.put(ESRCH, "No such process");
            map2.put(EINTR, "Interrupted system call");
            map2.put(EIO, "Input/output error");
            map2.put(ENXIO, "No such device or address");
            map2.put(E2BIG, "Argument list too long");
            map2.put(ENOEXEC, "Exec format error");
            map2.put(EBADF, "Bad file descriptor");
            map2.put(ECHILD, "No child processes");
            map2.put(EDEADLK, "Resource deadlock avoided");
            map2.put(ENOMEM, "Cannot allocate memory");
            map2.put(EACCES, "Permission denied");
            map2.put(EFAULT, "Bad address");
            map2.put(ENOTBLK, "Block device required");
            map2.put(EBUSY, "Device or resource busy");
            map2.put(EEXIST, "File exists");
            map2.put(EXDEV, "Invalid cross-device link");
            map2.put(ENODEV, "No such device");
            map2.put(ENOTDIR, "Not a directory");
            map2.put(EISDIR, "Is a directory");
            map2.put(EINVAL, "Invalid argument");
            map2.put(ENFILE, "Too many open files in system");
            map2.put(EMFILE, "Too many open files");
            map2.put(ENOTTY, "Inappropriate ioctl for device");
            map2.put(ETXTBSY, "Text file busy");
            map2.put(EFBIG, "File too large");
            map2.put(ENOSPC, "No space left on device");
            map2.put(ESPIPE, "Illegal seek");
            map2.put(EROFS, "Read-only file system");
            map2.put(EMLINK, "Too many links");
            map2.put(EPIPE, "Broken pipe");
            map2.put(EDOM, "Numerical argument out of domain");
            map2.put(ERANGE, "Numerical result out of range");
            map2.put(EWOULDBLOCK, "Resource temporarily unavailable");
            map2.put(EAGAIN, "Resource temporarily unavailable");
            map2.put(EINPROGRESS, "Operation now in progress");
            map2.put(EALREADY, "Operation already in progress");
            map2.put(ENOTSOCK, "Socket operation on non-socket");
            map2.put(EDESTADDRREQ, "Destination address required");
            map2.put(EMSGSIZE, "Message too long");
            map2.put(EPROTOTYPE, "Protocol wrong type for socket");
            map2.put(ENOPROTOOPT, "Protocol not available");
            map2.put(EPROTONOSUPPORT, "Protocol not supported");
            map2.put(ESOCKTNOSUPPORT, "Socket type not supported");
            map2.put(EOPNOTSUPP, "Operation not supported");
            map2.put(EPFNOSUPPORT, "Protocol family not supported");
            map2.put(EAFNOSUPPORT, "Address family not supported by protocol");
            map2.put(EADDRINUSE, "Address already in use");
            map2.put(EADDRNOTAVAIL, "Cannot assign requested address");
            map2.put(ENETDOWN, "Network is down");
            map2.put(ENETUNREACH, "Network is unreachable");
            map2.put(ENETRESET, "Network dropped connection on reset");
            map2.put(ECONNABORTED, "Software caused connection abort");
            map2.put(ECONNRESET, "Connection reset by peer");
            map2.put(ENOBUFS, "No buffer space available");
            map2.put(EISCONN, "Transport endpoint is already connected");
            map2.put(ENOTCONN, "Transport endpoint is not connected");
            map2.put(ESHUTDOWN, "Cannot send after transport endpoint shutdown");
            map2.put(ETOOMANYREFS, "Too many references: cannot splice");
            map2.put(ETIMEDOUT, "Connection timed out");
            map2.put(ECONNREFUSED, "Connection refused");
            map2.put(ELOOP, "Too many levels of symbolic links");
            map2.put(ENAMETOOLONG, "File name too long");
            map2.put(EHOSTDOWN, "Host is down");
            map2.put(EHOSTUNREACH, "No route to host");
            map2.put(ENOTEMPTY, "Directory not empty");
            map2.put(EUSERS, "Too many users");
            map2.put(EDQUOT, "Disk quota exceeded");
            map2.put(ESTALE, "Stale file handle");
            map2.put(EREMOTE, "Object is remote");
            map2.put(ENOLCK, "No locks available");
            map2.put(ENOSYS, "Function not implemented");
            map2.put(EOVERFLOW, "Value too large for defined data type");
            map2.put(EIDRM, "Identifier removed");
            map2.put(ENOMSG, "No message of desired type");
            map2.put(EILSEQ, "Invalid or incomplete multibyte or wide character");
            map2.put(EBADMSG, "Bad message");
            map2.put(EMULTIHOP, "Multihop attempted");
            map2.put(ENODATA, "No data available");
            map2.put(ENOLINK, "Link has been severed");
            map2.put(ENOSR, "Out of streams resources");
            map2.put(ENOSTR, "Device not a stream");
            map2.put(EPROTO, "Protocol error");
            map2.put(ETIME, "Timer expired");
            map2.put(ECHRNG, "Channel number out of range");
            map2.put(EL2NSYNC, "Level 2 not synchronized");
            map2.put(EL3HLT, "Level 3 halted");
            map2.put(EL3RST, "Level 3 reset");
            map2.put(ELNRNG, "Link number out of range");
            map2.put(EUNATCH, "Protocol driver not attached");
            map2.put(ENOCSI, "No CSI structure available");
            map2.put(EL2HLT, "Level 2 halted");
            map2.put(EBADE, "Invalid exchange");
            map2.put(EBADR, "Invalid request descriptor");
            map2.put(EXFULL, "Exchange full");
            map2.put(ENOANO, "No anode");
            map2.put(EBADRQC, "Invalid request code");
            map2.put(EBADSLT, "Invalid slot");
            map2.put(EDEADLOCK, "File locking deadlock error");
            map2.put(EBFONT, "Bad font file format");
            map2.put(ENONET, "Machine is not on the network");
            map2.put(ENOPKG, "Package not installed");
            map2.put(EADV, "Advertise error");
            map2.put(ESRMNT, "Srmount error");
            map2.put(ECOMM, "Communication error on send");
            map2.put(EDOTDOT, "RFS specific error");
            map2.put(ENOTUNIQ, "Name not unique on network");
            map2.put(EBADFD, "File descriptor in bad state");
            map2.put(EREMCHG, "Remote address changed");
            map2.put(ELIBACC, "Can not access a needed shared library");
            map2.put(ELIBBAD, "Accessing a corrupted shared library");
            map2.put(ELIBSCN, ".lib section in a.out corrupted");
            map2.put(ELIBMAX, "Attempting to link in too many shared libraries");
            map2.put(ELIBEXEC, "Cannot exec a shared library directly");
            map2.put(ERESTART, "Interrupted system call should be restarted");
            map2.put(ESTRPIPE, "Streams pipe error");
            map2.put(EUCLEAN, "Structure needs cleaning");
            map2.put(ENOTNAM, "Not a XENIX named type file");
            map2.put(ENAVAIL, "No XENIX semaphores available");
            map2.put(EISNAM, "Is a named type file");
            map2.put(EREMOTEIO, "Remote I/O error");
            map2.put(ECANCELED, "Operation canceled");
            map2.put(EKEYEXPIRED, "Key has expired");
            map2.put(EKEYREJECTED, "Key was rejected by service");
            map2.put(EKEYREVOKED, "Key has been revoked");
            map2.put(EMEDIUMTYPE, "Wrong medium type");
            map2.put(ENOKEY, "Required key not available");
            map2.put(ENOMEDIUM, "No medium found");
            map2.put(ENOTRECOVERABLE, "State not recoverable");
            map2.put(EOWNERDEAD, "Owner died");
            map2.put(ERFKILL, "Operation not possible due to RF-kill");
            map2.put(ENOTSUP, "Operation not supported");
            map2.put(EHWPOISON, "Memory page has hardware error");
            return map2;
        }
    }
}

