/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.index.engine.EngineException;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.RemoteSegmentStoreDirectory;

public final class RemoteStoreRefreshListener
implements ReferenceManager.RefreshListener {
    static final Set<String> EXCLUDE_FILES = Set.of("write.lock");
    static final int LAST_N_METADATA_FILES_TO_KEEP = 10;
    private final IndexShard indexShard;
    private final Directory storeDirectory;
    private final RemoteSegmentStoreDirectory remoteDirectory;
    private final Map<String, String> localSegmentChecksumMap;
    private long primaryTerm;
    private static final Logger logger = LogManager.getLogger(RemoteStoreRefreshListener.class);

    public RemoteStoreRefreshListener(IndexShard indexShard) {
        this.indexShard = indexShard;
        this.storeDirectory = indexShard.store().directory();
        this.remoteDirectory = (RemoteSegmentStoreDirectory)((FilterDirectory)((FilterDirectory)indexShard.remoteStore().directory()).getDelegate()).getDelegate();
        this.primaryTerm = indexShard.getOperationPrimaryTerm();
        this.localSegmentChecksumMap = new HashMap<String, String>();
        if (indexShard.shardRouting.primary()) {
            try {
                this.remoteDirectory.init();
            }
            catch (IOException e) {
                logger.error("Exception while initialising RemoteSegmentStoreDirectory", (Throwable)e);
            }
        }
    }

    public void beforeRefresh() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRefresh(boolean didRefresh) {
        RemoteStoreRefreshListener remoteStoreRefreshListener = this;
        synchronized (remoteStoreRefreshListener) {
            block19: {
                try {
                    if (!this.indexShard.shardRouting.primary()) break block19;
                    if (this.primaryTerm != this.indexShard.getOperationPrimaryTerm()) {
                        this.primaryTerm = this.indexShard.getOperationPrimaryTerm();
                        this.remoteDirectory.init();
                    }
                    try {
                        String lastCommittedLocalSegmentFileName = SegmentInfos.getLastCommitSegmentsFileName((Directory)this.storeDirectory);
                        if (!this.remoteDirectory.containsFile(lastCommittedLocalSegmentFileName, this.getChecksumOfLocalFile(lastCommittedLocalSegmentFileName))) {
                            this.deleteStaleCommits();
                        }
                        try (GatedCloseable<SegmentInfos> segmentInfosGatedCloseable = this.indexShard.getSegmentInfosSnapshot();){
                            SegmentInfos segmentInfos = segmentInfosGatedCloseable.get();
                            Collection refreshedLocalFiles = segmentInfos.files(true);
                            List segmentInfosFiles = refreshedLocalFiles.stream().filter(file -> file.startsWith("segments")).collect(Collectors.toList());
                            Optional<String> latestSegmentInfos = segmentInfosFiles.stream().max(Comparator.comparingLong(IndexFileNames::parseGeneration));
                            if (latestSegmentInfos.isPresent()) {
                                refreshedLocalFiles.addAll(SegmentInfos.readCommit((Directory)this.storeDirectory, (String)latestSegmentInfos.get()).files(true));
                                segmentInfosFiles.stream().filter(file -> !file.equals(latestSegmentInfos.get())).forEach(refreshedLocalFiles::remove);
                                boolean uploadStatus = this.uploadNewSegments(refreshedLocalFiles);
                                if (uploadStatus) {
                                    this.remoteDirectory.uploadMetadata(refreshedLocalFiles, this.storeDirectory, this.indexShard.getOperationPrimaryTerm(), segmentInfos.getGeneration());
                                    this.localSegmentChecksumMap.keySet().stream().filter(file -> !refreshedLocalFiles.contains(file)).collect(Collectors.toSet()).forEach(this.localSegmentChecksumMap::remove);
                                }
                            }
                        }
                        catch (EngineException e) {
                            logger.warn("Exception while reading SegmentInfosSnapshot", (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        logger.warn("Exception while uploading new segments to the remote segment store", (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    logger.error("Exception in RemoteStoreRefreshListener.afterRefresh()", t);
                }
            }
        }
    }

    boolean uploadNewSegments(Collection<String> localFiles) throws IOException {
        AtomicBoolean uploadSuccess = new AtomicBoolean(true);
        localFiles.stream().filter(file -> !EXCLUDE_FILES.contains(file)).filter(file -> {
            try {
                return !this.remoteDirectory.containsFile((String)file, this.getChecksumOfLocalFile((String)file));
            }
            catch (IOException e) {
                logger.info("Exception while reading checksum of local segment file: {}, ignoring the exception and re-uploading the file", file);
                return true;
            }
        }).forEach(file -> {
            try {
                this.remoteDirectory.copyFrom(this.storeDirectory, (String)file, (String)file, IOContext.DEFAULT);
            }
            catch (IOException e) {
                uploadSuccess.set(false);
                logger.warn(() -> new ParameterizedMessage("Exception while uploading file {} to the remote segment store", file), (Throwable)e);
            }
        });
        return uploadSuccess.get();
    }

    private String getChecksumOfLocalFile(String file) throws IOException {
        if (!this.localSegmentChecksumMap.containsKey(file)) {
            try (IndexInput indexInput = this.storeDirectory.openInput(file, IOContext.DEFAULT);){
                String checksum = Long.toString(CodecUtil.retrieveChecksum((IndexInput)indexInput));
                this.localSegmentChecksumMap.put(file, checksum);
            }
        }
        return this.localSegmentChecksumMap.get(file);
    }

    private void deleteStaleCommits() {
        try {
            this.remoteDirectory.deleteStaleSegments(10);
        }
        catch (IOException e) {
            logger.info("Exception while deleting stale commits from remote segment store, will retry delete post next commit", (Throwable)e);
        }
    }
}

