/* contacts-addresses-chunk.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-addresses-chunk.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "contactscore.h"
#include <gio/gio.h>
#include <glib.h>
#include <folks/folks.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

enum  {
	CONTACTS_ADDRESSES_CHUNK_0_PROPERTY,
	CONTACTS_ADDRESSES_CHUNK_PROPERTY_NAME_PROPERTY,
	CONTACTS_ADDRESSES_CHUNK_NUM_PROPERTIES
};
static GParamSpec* contacts_addresses_chunk_properties[CONTACTS_ADDRESSES_CHUNK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsAddressesChunkSaveToPersonaData ContactsAddressesChunkSaveToPersonaData;
enum  {
	CONTACTS_ADDRESS_0_PROPERTY,
	CONTACTS_ADDRESS_ADDRESS_PROPERTY,
	CONTACTS_ADDRESS_IS_EMPTY_PROPERTY,
	CONTACTS_ADDRESS_ICON_NAME_PROPERTY,
	CONTACTS_ADDRESS_NUM_PROPERTIES
};
static GParamSpec* contacts_address_properties[CONTACTS_ADDRESS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsAddressesChunkSaveToPersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsAddressesChunk* self;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	GeeSet* afds;
	GeeSet* _tmp2_;
	FolksPersona* _tmp3_;
	FolksPersona* _tmp4_;
	GError* _inner_error0_;
};

struct _ContactsAddressPrivate {
	FolksPostalAddress* _address;
};

static gpointer contacts_addresses_chunk_parent_class = NULL;
static gint ContactsAddress_private_offset;
static gpointer contacts_address_parent_class = NULL;

static ContactsBinChunkChild* contacts_addresses_chunk_real_create_empty_child (ContactsBinChunk* base);
static void contacts_addresses_chunk_real_save_to_persona_data_free (gpointer _data);
static void contacts_addresses_chunk_real_save_to_persona (ContactsChunk* base,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean contacts_addresses_chunk_real_save_to_persona_co (ContactsAddressesChunkSaveToPersonaData* _data_);
static void contacts_addresses_chunk_save_to_persona_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static GObject * contacts_addresses_chunk_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static GType contacts_addresses_chunk_get_type_once (void);
static void _vala_contacts_addresses_chunk_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static FolksAbstractFieldDetails* contacts_address_real_create_afd (ContactsBinChunkChild* base);
static void contacts_address_finalize (GObject * obj);
static GType contacts_address_get_type_once (void);
static void _vala_contacts_address_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_contacts_address_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static ContactsBinChunkChild*
contacts_addresses_chunk_real_create_empty_child (ContactsBinChunk* base)
{
	ContactsAddressesChunk * self;
	ContactsAddress* _tmp0_;
	ContactsBinChunkChild* result;
	self = (ContactsAddressesChunk*) base;
	_tmp0_ = contacts_address_new ();
	result = (ContactsBinChunkChild*) _tmp0_;
	return result;
}

static void
contacts_addresses_chunk_real_save_to_persona_data_free (gpointer _data)
{
	ContactsAddressesChunkSaveToPersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAddressesChunkSaveToPersonaData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
contacts_addresses_chunk_real_save_to_persona (ContactsChunk* base,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	ContactsAddressesChunk * self;
	ContactsAddressesChunkSaveToPersonaData* _data_;
	ContactsAddressesChunk* _tmp0_;
	self = (ContactsAddressesChunk*) base;
	_data_ = g_slice_new0 (ContactsAddressesChunkSaveToPersonaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_addresses_chunk_real_save_to_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_addresses_chunk_real_save_to_persona_co (_data_);
}

static void
contacts_addresses_chunk_save_to_persona_finish (ContactsChunk* base,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	ContactsAddressesChunkSaveToPersonaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
contacts_addresses_chunk_save_to_persona_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	ContactsAddressesChunkSaveToPersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_addresses_chunk_real_save_to_persona_co (_data_);
}

static gboolean
contacts_addresses_chunk_real_save_to_persona_co (ContactsAddressesChunkSaveToPersonaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = contacts_chunk_get_persona ((ContactsChunk*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS), "this.persona is PostalAddressDetails", FALSE);
	_data_->_tmp2_ = contacts_bin_chunk_get_abstract_field_details ((ContactsBinChunk*) _data_->self);
	_data_->afds = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEE_TYPE_SET, GeeSet);
	_data_->_tmp3_ = contacts_chunk_get_persona ((ContactsChunk*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	folks_postal_address_details_change_postal_addresses (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, FolksPostalAddressDetails), _data_->afds, contacts_addresses_chunk_save_to_persona_ready, _data_);
	return FALSE;
	_state_1:
	folks_postal_address_details_change_postal_addresses_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, FolksPostalAddressDetails), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->afds);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->afds);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ContactsAddressesChunk*
contacts_addresses_chunk_construct (GType object_type)
{
	ContactsAddressesChunk * self = NULL;
	self = (ContactsAddressesChunk*) contacts_bin_chunk_construct (object_type);
	return self;
}

ContactsAddressesChunk*
contacts_addresses_chunk_new (void)
{
	return contacts_addresses_chunk_construct (CONTACTS_TYPE_ADDRESSES_CHUNK);
}

static const gchar*
contacts_addresses_chunk_real_get_property_name (ContactsChunk* base)
{
	const gchar* result;
	ContactsAddressesChunk* self;
	self = (ContactsAddressesChunk*) base;
	result = "postal-addresses";
	return result;
}

static GObject *
contacts_addresses_chunk_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsAddressesChunk * self;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	parent_class = G_OBJECT_CLASS (contacts_addresses_chunk_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_ADDRESSES_CHUNK, ContactsAddressesChunk);
	_tmp0_ = contacts_chunk_get_persona ((ContactsChunk*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		FolksPersona* _tmp2_;
		FolksPersona* _tmp3_;
		FolksPostalAddressDetails* postal_address_details = NULL;
		FolksPersona* _tmp4_;
		FolksPersona* _tmp5_;
		_tmp2_ = contacts_chunk_get_persona ((ContactsChunk*) self);
		_tmp3_ = _tmp2_;
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS));
		_tmp4_ = contacts_chunk_get_persona ((ContactsChunk*) self);
		_tmp5_ = _tmp4_;
		postal_address_details = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, FolksPostalAddressDetails);
		{
			GeeIterator* _address_field_it = NULL;
			FolksPostalAddressDetails* _tmp6_;
			GeeSet* _tmp7_;
			GeeSet* _tmp8_;
			GeeIterator* _tmp9_;
			_tmp6_ = postal_address_details;
			_tmp7_ = folks_postal_address_details_get_postal_addresses (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
			_address_field_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				FolksPostalAddressFieldDetails* address_field = NULL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				ContactsAddress* address = NULL;
				FolksPostalAddressFieldDetails* _tmp13_;
				ContactsAddress* _tmp14_;
				ContactsAddress* _tmp15_;
				_tmp10_ = _address_field_it;
				if (!gee_iterator_next (_tmp10_)) {
					break;
				}
				_tmp11_ = _address_field_it;
				_tmp12_ = gee_iterator_get (_tmp11_);
				address_field = (FolksPostalAddressFieldDetails*) _tmp12_;
				_tmp13_ = address_field;
				_tmp14_ = contacts_address_new_from_field_details (_tmp13_);
				address = _tmp14_;
				_tmp15_ = address;
				contacts_bin_chunk_add_child ((ContactsBinChunk*) self, (ContactsBinChunkChild*) _tmp15_);
				_g_object_unref0 (address);
				_g_object_unref0 (address_field);
			}
			_g_object_unref0 (_address_field_it);
		}
	}
	contacts_bin_chunk_emptiness_check ((ContactsBinChunk*) self);
	return obj;
}

static void
contacts_addresses_chunk_class_init (ContactsAddressesChunkClass * klass,
                                     gpointer klass_data)
{
	contacts_addresses_chunk_parent_class = g_type_class_peek_parent (klass);
	((ContactsBinChunkClass *) klass)->create_empty_child = (ContactsBinChunkChild* (*) (ContactsBinChunk*)) contacts_addresses_chunk_real_create_empty_child;
	((ContactsChunkClass *) klass)->save_to_persona = (void (*) (ContactsChunk*, GAsyncReadyCallback, gpointer)) contacts_addresses_chunk_real_save_to_persona;
	((ContactsChunkClass *) klass)->save_to_persona_finish = (void (*) (ContactsChunk*, GAsyncResult*, GError**)) contacts_addresses_chunk_save_to_persona_finish;
	CONTACTS_CHUNK_CLASS (klass)->get_property_name = contacts_addresses_chunk_real_get_property_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_addresses_chunk_get_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_addresses_chunk_constructor;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_ADDRESSES_CHUNK_PROPERTY_NAME_PROPERTY, contacts_addresses_chunk_properties[CONTACTS_ADDRESSES_CHUNK_PROPERTY_NAME_PROPERTY] = g_param_spec_string ("property-name", "property-name", "property-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_addresses_chunk_instance_init (ContactsAddressesChunk * self,
                                        gpointer klass)
{
}

/**
 * A {@link Chunk} that represents the postal addresses of a contact (similar
 * to {@link Folks.PostalAddressDetails}}. Each element is a {@link Address}.
 */
 G_GNUC_NO_INLINE static GType
contacts_addresses_chunk_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsAddressesChunkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_addresses_chunk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAddressesChunk), 0, (GInstanceInitFunc) contacts_addresses_chunk_instance_init, NULL };
	GType contacts_addresses_chunk_type_id;
	contacts_addresses_chunk_type_id = g_type_register_static (CONTACTS_TYPE_BIN_CHUNK, "ContactsAddressesChunk", &g_define_type_info, 0);
	return contacts_addresses_chunk_type_id;
}

GType
contacts_addresses_chunk_get_type (void)
{
	static volatile gsize contacts_addresses_chunk_type_id__once = 0;
	if (g_once_init_enter (&contacts_addresses_chunk_type_id__once)) {
		GType contacts_addresses_chunk_type_id;
		contacts_addresses_chunk_type_id = contacts_addresses_chunk_get_type_once ();
		g_once_init_leave (&contacts_addresses_chunk_type_id__once, contacts_addresses_chunk_type_id);
	}
	return contacts_addresses_chunk_type_id__once;
}

static void
_vala_contacts_addresses_chunk_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ContactsAddressesChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_ADDRESSES_CHUNK, ContactsAddressesChunk);
	switch (property_id) {
		case CONTACTS_ADDRESSES_CHUNK_PROPERTY_NAME_PROPERTY:
		g_value_set_string (value, contacts_chunk_get_property_name ((ContactsChunk*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_address_get_instance_private (ContactsAddress* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsAddress_private_offset);
}

ContactsAddress*
contacts_address_construct (GType object_type)
{
	ContactsAddress * self = NULL;
	GeeHashMultiMap* _tmp0_;
	GeeHashMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	self = (ContactsAddress*) contacts_bin_chunk_child_construct (object_type);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	contacts_bin_chunk_child_set_parameters ((ContactsBinChunkChild*) self, (GeeMultiMap*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = contacts_bin_chunk_child_get_parameters ((ContactsBinChunkChild*) self);
	_tmp3_ = _tmp2_;
	gee_multi_map_set (_tmp3_, "type", "HOME");
	return self;
}

ContactsAddress*
contacts_address_new (void)
{
	return contacts_address_construct (CONTACTS_TYPE_ADDRESS);
}

ContactsAddress*
contacts_address_construct_from_field_details (GType object_type,
                                               FolksPostalAddressFieldDetails* address_field)
{
	ContactsAddress * self = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	g_return_val_if_fail (address_field != NULL, NULL);
	self = (ContactsAddress*) contacts_bin_chunk_child_construct (object_type);
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) address_field);
	_tmp1_ = _tmp0_;
	contacts_address_set_address (self, (FolksPostalAddress*) _tmp1_);
	_tmp2_ = folks_abstract_field_details_get_parameters ((FolksAbstractFieldDetails*) address_field);
	_tmp3_ = _tmp2_;
	contacts_bin_chunk_child_set_parameters ((ContactsBinChunkChild*) self, _tmp3_);
	return self;
}

ContactsAddress*
contacts_address_new_from_field_details (FolksPostalAddressFieldDetails* address_field)
{
	return contacts_address_construct_from_field_details (CONTACTS_TYPE_ADDRESS, address_field);
}

/**
   * Returns the TypeDescriptor that describes the type of this address
   * (for example home, work, ...)
   */
ContactsTypeDescriptor*
contacts_address_get_address_type (ContactsAddress* self)
{
	ContactsTypeSet* _tmp0_;
	ContactsTypeSet* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	ContactsTypeDescriptor* _tmp4_;
	ContactsTypeDescriptor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_typeset_get_general ();
	_tmp1_ = _tmp0_;
	_tmp2_ = contacts_bin_chunk_child_get_parameters ((ContactsBinChunkChild*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_typeset_lookup_by_parameters (_tmp1_, _tmp3_, NULL);
	result = _tmp4_;
	return result;
}

/**
   * Returns the address as a single string, with the several parts of
   * the address joined together with @parts_separator.
   */
static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
contacts_address_to_string (ContactsAddress* self,
                            const gchar* parts_separator)
{
	gchar** lines = NULL;
	gchar** _tmp0_;
	gint lines_length1;
	gint _lines_size_;
	FolksPostalAddress* _tmp1_;
	FolksPostalAddress* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	FolksPostalAddress* _tmp10_;
	FolksPostalAddress* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	FolksPostalAddress* _tmp19_;
	FolksPostalAddress* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	FolksPostalAddress* _tmp28_;
	FolksPostalAddress* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	FolksPostalAddress* _tmp37_;
	FolksPostalAddress* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	FolksPostalAddress* _tmp46_;
	FolksPostalAddress* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	FolksPostalAddress* _tmp55_;
	FolksPostalAddress* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	FolksPostalAddress* _tmp64_;
	FolksPostalAddress* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	gchar** _tmp73_;
	gint _tmp73__length1;
	gchar* _tmp74_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parts_separator != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	lines = _tmp0_;
	lines_length1 = 0;
	_lines_size_ = lines_length1;
	_tmp1_ = contacts_address_get_address (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_postal_address_get_street (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "") != 0) {
		FolksPostalAddress* _tmp5_;
		FolksPostalAddress* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = contacts_address_get_address (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = folks_postal_address_get_street (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		_vala_array_add1 (&lines, &lines_length1, &_lines_size_, _tmp9_);
	}
	_tmp10_ = contacts_address_get_address (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = folks_postal_address_get_extension (_tmp11_);
	_tmp13_ = _tmp12_;
	if (g_strcmp0 (_tmp13_, "") != 0) {
		FolksPostalAddress* _tmp14_;
		FolksPostalAddress* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp14_ = contacts_address_get_address (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = folks_postal_address_get_extension (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup (_tmp17_);
		_vala_array_add2 (&lines, &lines_length1, &_lines_size_, _tmp18_);
	}
	_tmp19_ = contacts_address_get_address (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = folks_postal_address_get_locality (_tmp20_);
	_tmp22_ = _tmp21_;
	if (g_strcmp0 (_tmp22_, "") != 0) {
		FolksPostalAddress* _tmp23_;
		FolksPostalAddress* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp23_ = contacts_address_get_address (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = folks_postal_address_get_locality (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strdup (_tmp26_);
		_vala_array_add3 (&lines, &lines_length1, &_lines_size_, _tmp27_);
	}
	_tmp28_ = contacts_address_get_address (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = folks_postal_address_get_region (_tmp29_);
	_tmp31_ = _tmp30_;
	if (g_strcmp0 (_tmp31_, "") != 0) {
		FolksPostalAddress* _tmp32_;
		FolksPostalAddress* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp32_ = contacts_address_get_address (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = folks_postal_address_get_region (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup (_tmp35_);
		_vala_array_add4 (&lines, &lines_length1, &_lines_size_, _tmp36_);
	}
	_tmp37_ = contacts_address_get_address (self);
	_tmp38_ = _tmp37_;
	_tmp39_ = folks_postal_address_get_postal_code (_tmp38_);
	_tmp40_ = _tmp39_;
	if (g_strcmp0 (_tmp40_, "") != 0) {
		FolksPostalAddress* _tmp41_;
		FolksPostalAddress* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp41_ = contacts_address_get_address (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = folks_postal_address_get_postal_code (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strdup (_tmp44_);
		_vala_array_add5 (&lines, &lines_length1, &_lines_size_, _tmp45_);
	}
	_tmp46_ = contacts_address_get_address (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = folks_postal_address_get_po_box (_tmp47_);
	_tmp49_ = _tmp48_;
	if (g_strcmp0 (_tmp49_, "") != 0) {
		FolksPostalAddress* _tmp50_;
		FolksPostalAddress* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp50_ = contacts_address_get_address (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = folks_postal_address_get_po_box (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strdup (_tmp53_);
		_vala_array_add6 (&lines, &lines_length1, &_lines_size_, _tmp54_);
	}
	_tmp55_ = contacts_address_get_address (self);
	_tmp56_ = _tmp55_;
	_tmp57_ = folks_postal_address_get_country (_tmp56_);
	_tmp58_ = _tmp57_;
	if (g_strcmp0 (_tmp58_, "") != 0) {
		FolksPostalAddress* _tmp59_;
		FolksPostalAddress* _tmp60_;
		const gchar* _tmp61_;
		const gchar* _tmp62_;
		gchar* _tmp63_;
		_tmp59_ = contacts_address_get_address (self);
		_tmp60_ = _tmp59_;
		_tmp61_ = folks_postal_address_get_country (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = g_strdup (_tmp62_);
		_vala_array_add7 (&lines, &lines_length1, &_lines_size_, _tmp63_);
	}
	_tmp64_ = contacts_address_get_address (self);
	_tmp65_ = _tmp64_;
	_tmp66_ = folks_postal_address_get_address_format (_tmp65_);
	_tmp67_ = _tmp66_;
	if (g_strcmp0 (_tmp67_, "") != 0) {
		FolksPostalAddress* _tmp68_;
		FolksPostalAddress* _tmp69_;
		const gchar* _tmp70_;
		const gchar* _tmp71_;
		gchar* _tmp72_;
		_tmp68_ = contacts_address_get_address (self);
		_tmp69_ = _tmp68_;
		_tmp70_ = folks_postal_address_get_address_format (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_strdup (_tmp71_);
		_vala_array_add8 (&lines, &lines_length1, &_lines_size_, _tmp72_);
	}
	_tmp73_ = lines;
	_tmp73__length1 = lines_length1;
	_tmp74_ = _vala_g_strjoinv (parts_separator, _tmp73_, (gint) _tmp73__length1);
	result = _tmp74_;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
   * Returns the address as a "maps:q=..." URI, which can then be used
   * by supported apps to open up the specified location.
   */
gchar*
contacts_address_to_maps_uri (ContactsAddress* self)
{
	gchar* address_parts = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_address_to_string (self, " ");
	address_parts = _tmp0_;
	_tmp1_ = g_uri_escape_string (address_parts, NULL, TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("maps:q=%s", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	_g_free0 (address_parts);
	return result;
}

static FolksAbstractFieldDetails*
contacts_address_real_create_afd (ContactsBinChunkChild* base)
{
	ContactsAddress * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	FolksPostalAddress* _tmp2_;
	FolksPostalAddress* _tmp3_;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* _tmp5_;
	FolksPostalAddressFieldDetails* _tmp6_;
	FolksAbstractFieldDetails* result;
	self = (ContactsAddress*) base;
	_tmp0_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = contacts_address_get_address (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_bin_chunk_child_get_parameters ((ContactsBinChunkChild*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_postal_address_field_details_new (_tmp3_, _tmp5_);
	result = (FolksAbstractFieldDetails*) _tmp6_;
	return result;
}

FolksPostalAddress*
contacts_address_get_address (ContactsAddress* self)
{
	FolksPostalAddress* result;
	FolksPostalAddress* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_address;
	result = _tmp0_;
	return result;
}

void
contacts_address_set_address (ContactsAddress* self,
                              FolksPostalAddress* value)
{
	FolksPostalAddress* _tmp0_;
	gboolean was_empty = FALSE;
	FolksPostalAddress* _tmp1_;
	FolksPostalAddress* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_address;
	if (folks_postal_address_equal (_tmp0_, value)) {
		return;
	}
	_tmp1_ = self->priv->_address;
	was_empty = folks_postal_address_is_empty (_tmp1_);
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_address);
	self->priv->_address = _tmp2_;
	g_object_notify ((GObject*) self, "address");
	if (was_empty != folks_postal_address_is_empty (value)) {
		g_object_notify ((GObject*) self, "is-empty");
	}
	g_object_notify_by_pspec ((GObject *) self, contacts_address_properties[CONTACTS_ADDRESS_ADDRESS_PROPERTY]);
}

static gboolean
contacts_address_real_get_is_empty (ContactsBinChunkChild* base)
{
	gboolean result;
	ContactsAddress* self;
	FolksPostalAddress* _tmp0_;
	FolksPostalAddress* _tmp1_;
	self = (ContactsAddress*) base;
	_tmp0_ = contacts_address_get_address (self);
	_tmp1_ = _tmp0_;
	result = folks_postal_address_is_empty (_tmp1_);
	return result;
}

static const gchar*
contacts_address_real_get_icon_name (ContactsBinChunkChild* base)
{
	const gchar* result;
	ContactsAddress* self;
	self = (ContactsAddress*) base;
	result = "mark-location-symbolic";
	return result;
}

static void
contacts_address_class_init (ContactsAddressClass * klass,
                             gpointer klass_data)
{
	contacts_address_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsAddress_private_offset);
	((ContactsBinChunkChildClass *) klass)->create_afd = (FolksAbstractFieldDetails* (*) (ContactsBinChunkChild*)) contacts_address_real_create_afd;
	CONTACTS_BIN_CHUNK_CHILD_CLASS (klass)->get_is_empty = contacts_address_real_get_is_empty;
	CONTACTS_BIN_CHUNK_CHILD_CLASS (klass)->get_icon_name = contacts_address_real_get_icon_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_address_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_address_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_address_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_ADDRESS_ADDRESS_PROPERTY, contacts_address_properties[CONTACTS_ADDRESS_ADDRESS_PROPERTY] = g_param_spec_object ("address", "address", "address", FOLKS_TYPE_POSTAL_ADDRESS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_ADDRESS_IS_EMPTY_PROPERTY, contacts_address_properties[CONTACTS_ADDRESS_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_ADDRESS_ICON_NAME_PROPERTY, contacts_address_properties[CONTACTS_ADDRESS_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_address_instance_init (ContactsAddress * self,
                                gpointer klass)
{
	FolksPostalAddress* _tmp0_;
	self->priv = contacts_address_get_instance_private (self);
	_tmp0_ = folks_postal_address_new ("", "", "", "", "", "", "", "", "");
	self->priv->_address = _tmp0_;
}

static void
contacts_address_finalize (GObject * obj)
{
	ContactsAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_ADDRESS, ContactsAddress);
	_g_object_unref0 (self->priv->_address);
	G_OBJECT_CLASS (contacts_address_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_address_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsAddressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_address_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAddress), 0, (GInstanceInitFunc) contacts_address_instance_init, NULL };
	GType contacts_address_type_id;
	contacts_address_type_id = g_type_register_static (CONTACTS_TYPE_BIN_CHUNK_CHILD, "ContactsAddress", &g_define_type_info, 0);
	ContactsAddress_private_offset = g_type_add_instance_private (contacts_address_type_id, sizeof (ContactsAddressPrivate));
	return contacts_address_type_id;
}

GType
contacts_address_get_type (void)
{
	static volatile gsize contacts_address_type_id__once = 0;
	if (g_once_init_enter (&contacts_address_type_id__once)) {
		GType contacts_address_type_id;
		contacts_address_type_id = contacts_address_get_type_once ();
		g_once_init_leave (&contacts_address_type_id__once, contacts_address_type_id);
	}
	return contacts_address_type_id__once;
}

static void
_vala_contacts_address_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	ContactsAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_ADDRESS, ContactsAddress);
	switch (property_id) {
		case CONTACTS_ADDRESS_ADDRESS_PROPERTY:
		g_value_set_object (value, contacts_address_get_address (self));
		break;
		case CONTACTS_ADDRESS_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) self));
		break;
		case CONTACTS_ADDRESS_ICON_NAME_PROPERTY:
		g_value_set_string (value, contacts_bin_chunk_child_get_icon_name ((ContactsBinChunkChild*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_address_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	ContactsAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_ADDRESS, ContactsAddress);
	switch (property_id) {
		case CONTACTS_ADDRESS_ADDRESS_PROPERTY:
		contacts_address_set_address (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

