/* contacts-contact-editor.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-contact-editor.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 * Copyright (C) 2019 Purism SPC
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "contactscore.h"
#include <glib.h>
#include <folks/folks.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include "contacts.h"
#include <pango/pango.h>
#include <gee.h>
#include <float.h>
#include <math.h>

#define PROFILE_SIZE 128
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_CONTACT_EDITOR (contacts_contact_editor_get_type ())
#define CONTACTS_CONTACT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditor))
#define CONTACTS_CONTACT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditorClass))
#define CONTACTS_IS_CONTACT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_EDITOR))
#define CONTACTS_IS_CONTACT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_EDITOR))
#define CONTACTS_CONTACT_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditorClass))

typedef struct _ContactsContactEditor ContactsContactEditor;
typedef struct _ContactsContactEditorClass ContactsContactEditorClass;
typedef struct _ContactsContactEditorPrivate ContactsContactEditorPrivate;

#define CONTACTS_TYPE_AVATAR (contacts_avatar_get_type ())
#define CONTACTS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatar))
#define CONTACTS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))
#define CONTACTS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR))
#define CONTACTS_IS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR))
#define CONTACTS_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))

typedef struct _ContactsAvatar ContactsAvatar;
typedef struct _ContactsAvatarClass ContactsAvatarClass;
enum  {
	CONTACTS_CONTACT_EDITOR_0_PROPERTY,
	CONTACTS_CONTACT_EDITOR_CONTACT_PROPERTY,
	CONTACTS_CONTACT_EDITOR_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_editor_properties[CONTACTS_CONTACT_EDITOR_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_PERSONA_EDITOR (contacts_persona_editor_get_type ())
#define CONTACTS_PERSONA_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_PERSONA_EDITOR, ContactsPersonaEditor))
#define CONTACTS_PERSONA_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_PERSONA_EDITOR, ContactsPersonaEditorClass))
#define CONTACTS_IS_PERSONA_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_PERSONA_EDITOR))
#define CONTACTS_IS_PERSONA_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_PERSONA_EDITOR))
#define CONTACTS_PERSONA_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_PERSONA_EDITOR, ContactsPersonaEditorClass))

typedef struct _ContactsPersonaEditor ContactsPersonaEditor;
typedef struct _ContactsPersonaEditorClass ContactsPersonaEditorClass;

#define CONTACTS_TYPE_AVATAR_SELECTOR (contacts_avatar_selector_get_type ())
#define CONTACTS_AVATAR_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelector))
#define CONTACTS_AVATAR_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelectorClass))
#define CONTACTS_IS_AVATAR_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR_SELECTOR))
#define CONTACTS_IS_AVATAR_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR_SELECTOR))
#define CONTACTS_AVATAR_SELECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelectorClass))

typedef struct _ContactsAvatarSelector ContactsAvatarSelector;
typedef struct _ContactsAvatarSelectorClass ContactsAvatarSelectorClass;
typedef struct _Block11Data Block11Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef struct _ContactsPersonaEditorPrivate ContactsPersonaEditorPrivate;
enum  {
	CONTACTS_PERSONA_EDITOR_0_PROPERTY,
	CONTACTS_PERSONA_EDITOR_CONTACT_PROPERTY,
	CONTACTS_PERSONA_EDITOR_PERSONA_PROPERTY,
	CONTACTS_PERSONA_EDITOR_NUM_PROPERTIES
};
static GParamSpec* contacts_persona_editor_properties[CONTACTS_PERSONA_EDITOR_NUM_PROPERTIES];
typedef struct _Block12Data Block12Data;

#define CONTACTS_TYPE_CONTACT_EDITOR_GROUP (contacts_contact_editor_group_get_type ())
#define CONTACTS_CONTACT_EDITOR_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_EDITOR_GROUP, ContactsContactEditorGroup))
#define CONTACTS_CONTACT_EDITOR_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_EDITOR_GROUP, ContactsContactEditorGroupClass))
#define CONTACTS_IS_CONTACT_EDITOR_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_EDITOR_GROUP))
#define CONTACTS_IS_CONTACT_EDITOR_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_EDITOR_GROUP))
#define CONTACTS_CONTACT_EDITOR_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_EDITOR_GROUP, ContactsContactEditorGroupClass))

typedef struct _ContactsContactEditorGroup ContactsContactEditorGroup;
typedef struct _ContactsContactEditorGroupClass ContactsContactEditorGroupClass;

#define CONTACTS_TYPE_CONTACT_EDITOR_PROPERTY (contacts_contact_editor_property_get_type ())
#define CONTACTS_CONTACT_EDITOR_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_EDITOR_PROPERTY, ContactsContactEditorProperty))
#define CONTACTS_CONTACT_EDITOR_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_EDITOR_PROPERTY, ContactsContactEditorPropertyClass))
#define CONTACTS_IS_CONTACT_EDITOR_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_EDITOR_PROPERTY))
#define CONTACTS_IS_CONTACT_EDITOR_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_EDITOR_PROPERTY))
#define CONTACTS_CONTACT_EDITOR_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_EDITOR_PROPERTY, ContactsContactEditorPropertyClass))

typedef struct _ContactsContactEditorProperty ContactsContactEditorProperty;
typedef struct _ContactsContactEditorPropertyClass ContactsContactEditorPropertyClass;
typedef ContactsContactEditorProperty* (*ContactsContactEditorGroupCreateWidgetFunc) (ContactsBinChunkChild* chunk_child, gpointer user_data);
typedef struct _Block13Data Block13Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define CONTACTS_TYPE_BIRTHDAY_EDITOR (contacts_birthday_editor_get_type ())
#define CONTACTS_BIRTHDAY_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditor))
#define CONTACTS_BIRTHDAY_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditorClass))
#define CONTACTS_IS_BIRTHDAY_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_BIRTHDAY_EDITOR))
#define CONTACTS_IS_BIRTHDAY_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_BIRTHDAY_EDITOR))
#define CONTACTS_BIRTHDAY_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditorClass))

typedef struct _ContactsBirthdayEditor ContactsBirthdayEditor;
typedef struct _ContactsBirthdayEditorClass ContactsBirthdayEditorClass;
typedef struct _Block14Data Block14Data;

#define CONTACTS_TYPE_ADDRESS_EDITOR (contacts_address_editor_get_type ())
#define CONTACTS_ADDRESS_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_ADDRESS_EDITOR, ContactsAddressEditor))
#define CONTACTS_ADDRESS_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_ADDRESS_EDITOR, ContactsAddressEditorClass))
#define CONTACTS_IS_ADDRESS_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_ADDRESS_EDITOR))
#define CONTACTS_IS_ADDRESS_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_ADDRESS_EDITOR))
#define CONTACTS_ADDRESS_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_ADDRESS_EDITOR, ContactsAddressEditorClass))

typedef struct _ContactsAddressEditor ContactsAddressEditor;
typedef struct _ContactsAddressEditorClass ContactsAddressEditorClass;
typedef struct _ContactsContactEditorGroupPrivate ContactsContactEditorGroupPrivate;
enum  {
	CONTACTS_CONTACT_EDITOR_GROUP_0_PROPERTY,
	CONTACTS_CONTACT_EDITOR_GROUP_CONTACT_PROPERTY,
	CONTACTS_CONTACT_EDITOR_GROUP_PERSONA_PROPERTY,
	CONTACTS_CONTACT_EDITOR_GROUP_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_editor_group_properties[CONTACTS_CONTACT_EDITOR_GROUP_NUM_PROPERTIES];
typedef struct _ContactsContactEditorPropertyPrivate ContactsContactEditorPropertyPrivate;
enum  {
	CONTACTS_CONTACT_EDITOR_PROPERTY_0_PROPERTY,
	CONTACTS_CONTACT_EDITOR_PROPERTY_REVEAL_PROPERTY,
	CONTACTS_CONTACT_EDITOR_PROPERTY_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_editor_property_properties[CONTACTS_CONTACT_EDITOR_PROPERTY_NUM_PROPERTIES];

#define CONTACTS_TYPE_TYPECOMBO_ROW (contacts_typecombo_row_get_type ())
#define CONTACTS_TYPECOMBO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_TYPECOMBO_ROW, ContactsTypeComboRow))
#define CONTACTS_TYPECOMBO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_TYPECOMBO_ROW, ContactsTypeComboRowClass))
#define CONTACTS_IS_TYPECOMBO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_TYPECOMBO_ROW))
#define CONTACTS_IS_TYPECOMBO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_TYPECOMBO_ROW))
#define CONTACTS_TYPECOMBO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_TYPECOMBO_ROW, ContactsTypeComboRowClass))

typedef struct _ContactsTypeComboRow ContactsTypeComboRow;
typedef struct _ContactsTypeComboRowClass ContactsTypeComboRowClass;
typedef struct _Block15Data Block15Data;
typedef struct _ContactsBirthdayEditorPrivate ContactsBirthdayEditorPrivate;
enum  {
	CONTACTS_BIRTHDAY_EDITOR_0_PROPERTY,
	CONTACTS_BIRTHDAY_EDITOR_IS_SET_PROPERTY,
	CONTACTS_BIRTHDAY_EDITOR_NUM_PROPERTIES
};
static GParamSpec* contacts_birthday_editor_properties[CONTACTS_BIRTHDAY_EDITOR_NUM_PROPERTIES];
enum  {
	CONTACTS_BIRTHDAY_EDITOR_CHANGED_SIGNAL,
	CONTACTS_BIRTHDAY_EDITOR_NUM_SIGNALS
};
static guint contacts_birthday_editor_signals[CONTACTS_BIRTHDAY_EDITOR_NUM_SIGNALS] = {0};
typedef struct _ContactsAddressEditorPrivate ContactsAddressEditorPrivate;
enum  {
	CONTACTS_ADDRESS_EDITOR_0_PROPERTY,
	CONTACTS_ADDRESS_EDITOR_NUM_PROPERTIES
};
static GParamSpec* contacts_address_editor_properties[CONTACTS_ADDRESS_EDITOR_NUM_PROPERTIES];
enum  {
	CONTACTS_ADDRESS_EDITOR_CHANGED_SIGNAL,
	CONTACTS_ADDRESS_EDITOR_NUM_SIGNALS
};
static guint contacts_address_editor_signals[CONTACTS_ADDRESS_EDITOR_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsContactEditor {
	GtkWidget parent_instance;
	ContactsContactEditorPrivate * priv;
};

struct _ContactsContactEditorClass {
	GtkWidgetClass parent_class;
};

struct _ContactsContactEditorPrivate {
	ContactsContact* _contact;
	GPtrArray* personas;
	GtkEntry* name_entry;
	ContactsAvatar* avatar;
};

struct _Block11Data {
	int _ref_count_;
	ContactsContactEditor* self;
	ContactsAvatarSelector* avatar_selector;
};

struct _ContactsPersonaEditor {
	GtkWidget parent_instance;
	ContactsPersonaEditorPrivate * priv;
};

struct _ContactsPersonaEditorClass {
	GtkWidgetClass parent_class;
};

struct _ContactsPersonaEditorPrivate {
	ContactsContact* _contact;
	FolksPersona* _persona;
	GListModel* model;
};

struct _Block12Data {
	int _ref_count_;
	ContactsPersonaEditor* self;
	ContactsChunkPropertyFilter* filter;
};

struct _Block13Data {
	int _ref_count_;
	ContactsPersonaEditor* self;
	ContactsBirthdayChunk* bd_chunk;
	GtkButton* button;
};

struct _Block14Data {
	int _ref_count_;
	Block13Data * _data13_;
	ContactsBirthdayEditor* dialog;
};

struct _ContactsContactEditorGroup {
	GtkWidget parent_instance;
	ContactsContactEditorGroupPrivate * priv;
};

struct _ContactsContactEditorGroupClass {
	GtkWidgetClass parent_class;
};

struct _ContactsContactEditorGroupPrivate {
	ContactsContact* _contact;
	FolksPersona* _persona;
	ContactsContactEditorGroupCreateWidgetFunc create_widget_func;
	gpointer create_widget_func_target;
};

struct _ContactsContactEditorProperty {
	GtkWidget parent_instance;
	ContactsContactEditorPropertyPrivate * priv;
};

struct _ContactsContactEditorPropertyClass {
	GtkWidgetClass parent_class;
};

struct _ContactsContactEditorPropertyPrivate {
	AdwPreferencesGroup* group;
	gboolean _reveal;
};

struct _Block15Data {
	int _ref_count_;
	ContactsContactEditorProperty* self;
	ContactsTypeComboRow* row;
	ContactsBinChunkChild* chunk_child;
};

struct _ContactsBirthdayEditor {
	GtkDialog parent_instance;
	ContactsBirthdayEditorPrivate * priv;
};

struct _ContactsBirthdayEditorClass {
	GtkDialogClass parent_class;
};

struct _ContactsBirthdayEditorPrivate {
	GtkSpinButton* day_spin;
	GtkComboBoxText* month_combo;
	GtkSpinButton* year_spin;
	gboolean _is_set;
};

struct _ContactsAddressEditor {
	GtkWidget parent_instance;
	ContactsAddressEditorPrivate * priv;
};

struct _ContactsAddressEditorClass {
	GtkWidgetClass parent_class;
};

static gint ContactsContactEditor_private_offset;
static gpointer contacts_contact_editor_parent_class = NULL;
static gint ContactsPersonaEditor_private_offset;
static gpointer contacts_persona_editor_parent_class = NULL;
static gint ContactsContactEditorGroup_private_offset;
static gpointer contacts_contact_editor_group_parent_class = NULL;
static gint ContactsContactEditorProperty_private_offset;
static gpointer contacts_contact_editor_property_parent_class = NULL;
static gint ContactsBirthdayEditor_private_offset;
static gpointer contacts_birthday_editor_parent_class = NULL;
static gpointer contacts_address_editor_parent_class = NULL;
static gchar** contacts_address_editor_postal_element_names;
static gint contacts_address_editor_postal_element_names_length1;
static gchar** contacts_address_editor_postal_element_names = NULL;
static gint contacts_address_editor_postal_element_names_length1 = 0;
static gint _contacts_address_editor_postal_element_names_size_ = 0;

VALA_EXTERN GType contacts_contact_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactEditor, g_object_unref)
VALA_EXTERN GType contacts_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatar, g_object_unref)
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN ContactsContactEditor* contacts_contact_editor_new (ContactsContact* contact);
VALA_EXTERN ContactsContactEditor* contacts_contact_editor_construct (GType object_type,
                                                          ContactsContact* contact);
static GtkWidget* contacts_contact_editor_create_widget_for_avatar (ContactsContactEditor* self,
                                                             ContactsContact* contact);
static GtkWidget* contacts_contact_editor_create_name_entry (ContactsContactEditor* self,
                                                      ContactsContact* contact);
static void contacts_contact_editor_on_contact_items_changed (ContactsContactEditor* self,
                                                       GListModel* model,
                                                       guint position,
                                                       guint removed,
                                                       guint added);
static void _contacts_contact_editor_on_contact_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                                   guint position,
                                                                                   guint removed,
                                                                                   guint added,
                                                                                   gpointer self);
static void contacts_contact_editor_real_dispose (GObject* base);
static GtkLabel* contacts_contact_editor_create_persona_store_label (ContactsContactEditor* self,
                                                              FolksPersona* p);
VALA_EXTERN GType contacts_persona_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsPersonaEditor, g_object_unref)
VALA_EXTERN ContactsPersonaEditor* contacts_persona_editor_new (ContactsContact* contact,
                                                    FolksPersona* persona);
VALA_EXTERN ContactsPersonaEditor* contacts_persona_editor_construct (GType object_type,
                                                          ContactsContact* contact,
                                                          FolksPersona* persona);
VALA_EXTERN ContactsAvatar* contacts_avatar_new_for_contact (gint size,
                                                 ContactsContact* contact);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct_for_contact (GType object_type,
                                                       gint size,
                                                       ContactsContact* contact);
static void contacts_contact_editor_on_avatar_button_clicked (ContactsContactEditor* self,
                                                       GtkButton* avatar_button);
static void _contacts_contact_editor_on_avatar_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self);
VALA_EXTERN GType contacts_avatar_selector_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatarSelector, g_object_unref)
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
VALA_EXTERN ContactsContact* contacts_contact_editor_get_contact (ContactsContactEditor* self);
VALA_EXTERN ContactsAvatarSelector* contacts_avatar_selector_new (ContactsContact* contact,
                                                      GtkWindow* window);
VALA_EXTERN ContactsAvatarSelector* contacts_avatar_selector_construct (GType object_type,
                                                            ContactsContact* contact,
                                                            GtkWindow* window);
static void __lambda16_ (Block11Data* _data11_,
                  gint response);
VALA_EXTERN void contacts_avatar_selector_set_avatar_on_contact (ContactsAvatarSelector* self,
                                                     GError** error);
static void ___lambda16__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
VALA_EXTERN void contacts_contact_editor_set_contact (ContactsContactEditor* self,
                                          ContactsContact* value);
static GObject * contacts_contact_editor_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void contacts_contact_editor_finalize (GObject * obj);
static GType contacts_contact_editor_get_type_once (void);
static void _vala_contacts_contact_editor_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_contacts_contact_editor_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void contacts_persona_editor_real_dispose (GObject* base);
static void contacts_persona_editor_ensure_chunks (ContactsPersonaEditor* self,
                                            ContactsContact* contact);
VALA_EXTERN FolksPersona* contacts_persona_editor_get_persona (ContactsPersonaEditor* self);
static void contacts_persona_editor_add_show_more_button (ContactsPersonaEditor* self,
                                                   ContactsChunkPropertyFilter* filter);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda17_ (Block12Data* _data12_,
                  GtkButton* button);
static void ___lambda17__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void contacts_persona_editor_on_model_items_changed (ContactsPersonaEditor* self,
                                                     GListModel* model,
                                                     guint position,
                                                     guint removed,
                                                     guint added);
static GtkWidget* contacts_persona_editor_create_widget_for_chunk (ContactsPersonaEditor* self,
                                                            ContactsChunk* chunk);
static GtkWidget* contacts_persona_editor_create_widget_for_birthday (ContactsPersonaEditor* self,
                                                               ContactsChunk* chunk);
static GtkWidget* contacts_persona_editor_create_widget_for_emails (ContactsPersonaEditor* self,
                                                             ContactsChunk* chunk);
static GtkWidget* contacts_persona_editor_create_widget_for_nickname (ContactsPersonaEditor* self,
                                                               ContactsChunk* chunk);
static GtkWidget* contacts_persona_editor_create_widget_for_notes (ContactsPersonaEditor* self,
                                                            ContactsChunk* chunk);
static GtkWidget* contacts_persona_editor_create_widget_for_phones (ContactsPersonaEditor* self,
                                                             ContactsChunk* chunk);
static GtkWidget* contacts_persona_editor_create_widget_for_addresses (ContactsPersonaEditor* self,
                                                                ContactsChunk* chunk);
static GtkWidget* contacts_persona_editor_create_widget_for_roles (ContactsPersonaEditor* self,
                                                            ContactsChunk* chunk);
static GtkWidget* contacts_persona_editor_create_widget_for_urls (ContactsPersonaEditor* self,
                                                           ContactsChunk* chunk);
VALA_EXTERN GType contacts_contact_editor_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactEditorGroup, g_object_unref)
VALA_EXTERN ContactsContact* contacts_persona_editor_get_contact (ContactsPersonaEditor* self);
VALA_EXTERN GType contacts_contact_editor_property_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactEditorProperty, g_object_unref)
static ContactsContactEditorProperty* contacts_persona_editor_create_email_widget (ContactsPersonaEditor* self,
                                                                            ContactsBinChunkChild* chunk_child);
static ContactsContactEditorProperty* _contacts_persona_editor_create_email_widget_contacts_contact_editor_group_create_widget_func (ContactsBinChunkChild* chunk_child,
                                                                                                                              gpointer self);
VALA_EXTERN ContactsContactEditorGroup* contacts_contact_editor_group_new (ContactsContact* contact,
                                                               FolksPersona* persona,
                                                               ContactsBinChunk* chunk,
                                                               ContactsContactEditorGroupCreateWidgetFunc func,
                                                               gpointer func_target);
VALA_EXTERN ContactsContactEditorGroup* contacts_contact_editor_group_construct (GType object_type,
                                                                     ContactsContact* contact,
                                                                     FolksPersona* persona,
                                                                     ContactsBinChunk* chunk,
                                                                     ContactsContactEditorGroupCreateWidgetFunc func,
                                                                     gpointer func_target);
VALA_EXTERN ContactsContactEditorProperty* contacts_contact_editor_property_new (GtkWidget* widget);
VALA_EXTERN ContactsContactEditorProperty* contacts_contact_editor_property_construct (GType object_type,
                                                                           GtkWidget* widget);
VALA_EXTERN void contacts_contact_editor_property_add_type_combo (ContactsContactEditorProperty* self,
                                                      ContactsBinChunkChild* chunk_child,
                                                      ContactsTypeSet* combo_type);
static ContactsContactEditorProperty* contacts_persona_editor_create_phone_widget (ContactsPersonaEditor* self,
                                                                            ContactsBinChunkChild* chunk_child);
static ContactsContactEditorProperty* _contacts_persona_editor_create_phone_widget_contacts_contact_editor_group_create_widget_func (ContactsBinChunkChild* chunk_child,
                                                                                                                              gpointer self);
static ContactsContactEditorProperty* contacts_persona_editor_create_url_widget (ContactsPersonaEditor* self,
                                                                          ContactsBinChunkChild* chunk_child);
static ContactsContactEditorProperty* _contacts_persona_editor_create_url_widget_contacts_contact_editor_group_create_widget_func (ContactsBinChunkChild* chunk_child,
                                                                                                                            gpointer self);
static ContactsContactEditorProperty* contacts_persona_editor_create_note_widget (ContactsPersonaEditor* self,
                                                                           ContactsBinChunkChild* chunk_child);
static ContactsContactEditorProperty* _contacts_persona_editor_create_note_widget_contacts_contact_editor_group_create_widget_func (ContactsBinChunkChild* chunk_child,
                                                                                                                             gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void __lambda18_ (Block13Data* _data13_);
VALA_EXTERN GType contacts_birthday_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsBirthdayEditor, g_object_unref)
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
VALA_EXTERN ContactsBirthdayEditor* contacts_birthday_editor_new (GtkWindow* window,
                                                      GDateTime* birthday);
VALA_EXTERN ContactsBirthdayEditor* contacts_birthday_editor_construct (GType object_type,
                                                            GtkWindow* window,
                                                            GDateTime* birthday);
static void __lambda22_ (Block14Data* _data14_);
VALA_EXTERN gboolean contacts_birthday_editor_get_is_set (ContactsBirthdayEditor* self);
VALA_EXTERN GDateTime* contacts_birthday_editor_get_birthday (ContactsBirthdayEditor* self);
static void ___lambda22__contacts_birthday_editor_changed (ContactsBirthdayEditor* _sender,
                                                    gpointer self);
static void ___lambda18__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static ContactsContactEditorProperty* contacts_persona_editor_create_address_widget (ContactsPersonaEditor* self,
                                                                              ContactsBinChunkChild* chunk_child);
static ContactsContactEditorProperty* _contacts_persona_editor_create_address_widget_contacts_contact_editor_group_create_widget_func (ContactsBinChunkChild* chunk_child,
                                                                                                                                gpointer self);
VALA_EXTERN GType contacts_address_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAddressEditor, g_object_unref)
VALA_EXTERN ContactsAddressEditor* contacts_address_editor_new (ContactsAddress* address);
VALA_EXTERN ContactsAddressEditor* contacts_address_editor_construct (GType object_type,
                                                          ContactsAddress* address);
static ContactsContactEditorProperty* contacts_persona_editor_create_role_widget (ContactsPersonaEditor* self,
                                                                           ContactsBinChunkChild* chunk_child);
static ContactsContactEditorProperty* _contacts_persona_editor_create_role_widget_contacts_contact_editor_group_create_widget_func (ContactsBinChunkChild* chunk_child,
                                                                                                                             gpointer self);
VALA_EXTERN void contacts_contact_editor_property_add (ContactsContactEditorProperty* self,
                                           GtkWidget* widget);
VALA_EXTERN void contacts_persona_editor_set_contact (ContactsPersonaEditor* self,
                                          ContactsContact* value);
VALA_EXTERN void contacts_persona_editor_set_persona (ContactsPersonaEditor* self,
                                          FolksPersona* value);
static GObject * contacts_persona_editor_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static gboolean _contacts_persona_editor___lambda24_ (ContactsPersonaEditor* self,
                                               GObject* item);
static gboolean __contacts_persona_editor___lambda24__gtk_custom_filter_func (GObject* item,
                                                                       gpointer self);
static void _contacts_persona_editor_on_model_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                                 guint position,
                                                                                 guint removed,
                                                                                 guint added,
                                                                                 gpointer self);
static void contacts_persona_editor_finalize (GObject * obj);
static GType contacts_persona_editor_get_type_once (void);
static void _vala_contacts_persona_editor_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_contacts_persona_editor_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void contacts_contact_editor_group_on_bin_chunk_items_changed (ContactsContactEditorGroup* self,
                                                               GListModel* model,
                                                               guint position,
                                                               guint removed,
                                                               guint added);
static void _contacts_contact_editor_group_on_bin_chunk_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                                           guint position,
                                                                                           guint removed,
                                                                                           guint added,
                                                                                           gpointer self);
static void contacts_contact_editor_group_real_dispose (GObject* base);
VALA_EXTERN void contacts_contact_editor_property_set_reveal (ContactsContactEditorProperty* self,
                                                  gboolean value);
VALA_EXTERN ContactsContact* contacts_contact_editor_group_get_contact (ContactsContactEditorGroup* self);
VALA_EXTERN void contacts_contact_editor_group_set_contact (ContactsContactEditorGroup* self,
                                                ContactsContact* value);
VALA_EXTERN FolksPersona* contacts_contact_editor_group_get_persona (ContactsContactEditorGroup* self);
VALA_EXTERN void contacts_contact_editor_group_set_persona (ContactsContactEditorGroup* self,
                                                FolksPersona* value);
static GObject * contacts_contact_editor_group_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void contacts_contact_editor_group_finalize (GObject * obj);
static GType contacts_contact_editor_group_get_type_once (void);
static void _vala_contacts_contact_editor_group_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_contacts_contact_editor_group_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static void contacts_contact_editor_property_real_dispose (GObject* base);
VALA_EXTERN GType contacts_typecombo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsTypeComboRow, g_object_unref)
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
VALA_EXTERN ContactsTypeComboRow* contacts_typecombo_row_new (ContactsTypeSet* type_set);
VALA_EXTERN ContactsTypeComboRow* contacts_typecombo_row_construct (GType object_type,
                                                        ContactsTypeSet* type_set);
VALA_EXTERN void contacts_typecombo_row_set_selected_from_parameters (ContactsTypeComboRow* self,
                                                          GeeMultiMap* parameters);
static void __lambda23_ (Block15Data* _data15_,
                  GObject* obj,
                  GParamSpec* pspec);
VALA_EXTERN ContactsTypeDescriptor* contacts_typecombo_row_get_selected_descriptor (ContactsTypeComboRow* self);
static void ___lambda23__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN gboolean contacts_contact_editor_property_get_reveal (ContactsContactEditorProperty* self);
static void contacts_contact_editor_property_finalize (GObject * obj);
static GType contacts_contact_editor_property_get_type_once (void);
static void _vala_contacts_contact_editor_property_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_contacts_contact_editor_property_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static void contacts_birthday_editor_update_date (ContactsBirthdayEditor* self);
static void __lambda19_ (ContactsBirthdayEditor* self);
static void ___lambda19__gtk_combo_box_changed (GtkComboBox* _sender,
                                         gpointer self);
static void __lambda20_ (ContactsBirthdayEditor* self);
static void ___lambda20__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                 gpointer self);
static gboolean _vala_int_array_contains (gint * stack,
                                   gssize stack_length,
                                   const gint needle);
VALA_EXTERN void contacts_birthday_editor_set_is_set (ContactsBirthdayEditor* self,
                                          gboolean value);
static GObject * contacts_birthday_editor_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _contacts_birthday_editor___lambda21_ (ContactsBirthdayEditor* self,
                                            gint id);
static void __contacts_birthday_editor___lambda21__gtk_dialog_response (GtkDialog* _sender,
                                                                 gint response_id,
                                                                 gpointer self);
static void contacts_birthday_editor_finalize (GObject * obj);
static GType contacts_birthday_editor_get_type_once (void);
static void _vala_contacts_birthday_editor_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_contacts_birthday_editor_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void contacts_address_editor_real_dispose (GObject* base);
static GObject * contacts_address_editor_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void contacts_address_editor_finalize (GObject * obj);
static GType contacts_address_editor_get_type_once (void);

const gchar* CONTACTS_PERSONA_EDITOR_IMPORTANT_PROPERTIES[3] = {"email-addresses", "phone-numbers", NULL};
const gchar* CONTACTS_PERSONA_EDITOR_SUPPORTED_PROPERTIES[9] = {"birthday", "email-addresses", "nickname", "notes", "phone-numbers", "postal-addresses", "roles", "urls", NULL};
static const gchar* CONTACTS_ADDRESS_EDITOR_postal_element_props[7] = {"street", "extension", "locality", "region", "postal_code", "po_box", "country"};

static inline gpointer
contacts_contact_editor_get_instance_private (ContactsContactEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactEditor_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_contacts_contact_editor_on_contact_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                              guint position,
                                                                              guint removed,
                                                                              guint added,
                                                                              gpointer self)
{
	contacts_contact_editor_on_contact_items_changed ((ContactsContactEditor*) self, _sender, position, removed, added);
}

ContactsContactEditor*
contacts_contact_editor_construct (GType object_type,
                                   ContactsContact* contact)
{
	ContactsContactEditor * self = NULL;
	GtkBox* header = NULL;
	GtkBox* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	g_return_val_if_fail (contact != NULL, NULL);
	self = (ContactsContactEditor*) g_object_new (object_type, "contact", contact, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	header = _tmp0_;
	_tmp1_ = contacts_contact_editor_create_widget_for_avatar (self, contact);
	_tmp2_ = _tmp1_;
	gtk_box_append (header, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = contacts_contact_editor_create_name_entry (self, contact);
	_tmp4_ = _tmp3_;
	gtk_box_append (header, _tmp4_);
	_g_object_unref0 (_tmp4_);
	gtk_widget_set_parent ((GtkWidget*) header, (GtkWidget*) self);
	g_signal_connect_object ((GListModel*) contact, "items-changed", (GCallback) _contacts_contact_editor_on_contact_items_changed_g_list_model_items_changed, self, 0);
	contacts_contact_editor_on_contact_items_changed (self, (GListModel*) contact, (guint) 0, (guint) 0, g_list_model_get_n_items ((GListModel*) contact));
	_g_object_unref0 (header);
	return self;
}

ContactsContactEditor*
contacts_contact_editor_new (ContactsContact* contact)
{
	return contacts_contact_editor_construct (CONTACTS_TYPE_CONTACT_EDITOR, contact);
}

static void
contacts_contact_editor_real_dispose (GObject* base)
{
	ContactsContactEditor * self;
	GtkWidget* child = NULL;
	self = (ContactsContactEditor*) base;
	child = NULL;
	while (TRUE) {
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
		child = _tmp0_;
		_tmp1_ = child;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = child;
		gtk_widget_unparent (_tmp2_);
	}
	G_OBJECT_CLASS (contacts_contact_editor_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
contacts_contact_editor_on_contact_items_changed (ContactsContactEditor* self,
                                                  GListModel* model,
                                                  guint position,
                                                  guint removed,
                                                  guint added)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	{
		guint i = 0U;
		i = position;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ContactsChunk* chunk = NULL;
				GObject* _tmp2_;
				GPtrArray* _tmp3_;
				ContactsChunk* _tmp4_;
				FolksPersona* _tmp5_;
				FolksPersona* _tmp6_;
				GPtrArray* _tmp7_;
				ContactsChunk* _tmp8_;
				FolksPersona* _tmp9_;
				FolksPersona* _tmp10_;
				FolksPersona* _tmp11_;
				gboolean _tmp12_ = FALSE;
				ContactsChunk* _tmp13_;
				FolksPersona* _tmp14_;
				FolksPersona* _tmp15_;
				ContactsPersonaEditor* persona_editor = NULL;
				ContactsChunk* _tmp24_;
				FolksPersona* _tmp25_;
				FolksPersona* _tmp26_;
				ContactsPersonaEditor* _tmp27_;
				ContactsPersonaEditor* _tmp28_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < (position + added))) {
					break;
				}
				_tmp2_ = g_list_model_get_item (model, i);
				chunk = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CONTACTS_TYPE_CHUNK, ContactsChunk);
				_tmp3_ = self->priv->personas;
				_tmp4_ = chunk;
				_tmp5_ = contacts_chunk_get_persona (_tmp4_);
				_tmp6_ = _tmp5_;
				if (g_ptr_array_find (_tmp3_, _tmp6_, NULL)) {
					_g_object_unref0 (chunk);
					continue;
				}
				_tmp7_ = self->priv->personas;
				_tmp8_ = chunk;
				_tmp9_ = contacts_chunk_get_persona (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				g_ptr_array_add (_tmp7_, _tmp11_);
				_tmp13_ = chunk;
				_tmp14_ = contacts_chunk_get_persona (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ != NULL) {
					GPtrArray* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp16_ = self->priv->personas;
					_tmp17_ = vala_g_ptr_array_get_length (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_ > 1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					GtkLabel* persona_store_header = NULL;
					ContactsChunk* _tmp19_;
					FolksPersona* _tmp20_;
					FolksPersona* _tmp21_;
					GtkLabel* _tmp22_;
					GtkLabel* _tmp23_;
					_tmp19_ = chunk;
					_tmp20_ = contacts_chunk_get_persona (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = contacts_contact_editor_create_persona_store_label (self, _tmp21_);
					persona_store_header = _tmp22_;
					_tmp23_ = persona_store_header;
					gtk_widget_set_parent ((GtkWidget*) _tmp23_, (GtkWidget*) self);
					_g_object_unref0 (persona_store_header);
				}
				_tmp24_ = chunk;
				_tmp25_ = contacts_chunk_get_persona (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = contacts_persona_editor_new (G_TYPE_CHECK_INSTANCE_CAST (model, CONTACTS_TYPE_CONTACT, ContactsContact), _tmp26_);
				g_object_ref_sink (_tmp27_);
				persona_editor = _tmp27_;
				_tmp28_ = persona_editor;
				gtk_widget_set_parent ((GtkWidget*) _tmp28_, (GtkWidget*) self);
				_g_object_unref0 (persona_editor);
				_g_object_unref0 (chunk);
			}
		}
	}
}

static void
_contacts_contact_editor_on_avatar_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self)
{
	contacts_contact_editor_on_avatar_button_clicked ((ContactsContactEditor*) self, _sender);
}

static GtkWidget*
contacts_contact_editor_create_widget_for_avatar (ContactsContactEditor* self,
                                                  ContactsContact* contact)
{
	ContactsAvatar* avatar = NULL;
	ContactsAvatar* _tmp0_;
	GtkButton* button = NULL;
	GtkButton* _tmp1_;
	ContactsAvatar* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contacts_avatar_new_for_contact (PROFILE_SIZE, contact);
	g_object_ref_sink (_tmp0_);
	avatar = _tmp0_;
	self->priv->avatar = avatar;
	_tmp1_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp1_);
	button = _tmp1_;
	gtk_widget_set_tooltip_text ((GtkWidget*) button, _ ("Change avatar"));
	_tmp2_ = self->priv->avatar;
	gtk_button_set_child (button, (GtkWidget*) _tmp2_);
	g_signal_connect_object (button, "clicked", (GCallback) _contacts_contact_editor_on_avatar_button_clicked_gtk_button_clicked, self, 0);
	result = (GtkWidget*) button;
	_g_object_unref0 (avatar);
	return result;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		ContactsContactEditor* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->avatar_selector);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda16_ (Block11Data* _data11_,
             gint response)
{
	ContactsContactEditor* self;
	GError* _inner_error0_ = NULL;
	self = _data11_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		{
			contacts_avatar_selector_set_avatar_on_contact (_data11_->avatar_selector, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp0_;
			const gchar* _tmp1_;
			AdwMessageDialog* dialog = NULL;
			GtkRoot* _tmp2_;
			AdwMessageDialog* _tmp3_;
			AdwMessageDialog* _tmp4_;
			AdwMessageDialog* _tmp5_;
			AdwMessageDialog* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp0_ = e;
			_tmp1_ = _tmp0_->message;
			g_warning ("contacts-contact-editor.vala:112: Failed to set avatar: %s", _tmp1_);
			_tmp2_ = gtk_widget_get_root ((GtkWidget*) self);
			_tmp3_ = (AdwMessageDialog*) adw_message_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL, NULL, _ ("Failed to set avatar."));
			g_object_ref_sink (_tmp3_);
			dialog = _tmp3_;
			_tmp4_ = dialog;
			adw_message_dialog_add_response (_tmp4_, "close", _ ("_Close"));
			_tmp5_ = dialog;
			adw_message_dialog_set_default_response (_tmp5_, "close");
			_tmp6_ = dialog;
			gtk_widget_show ((GtkWidget*) _tmp6_);
			_g_object_unref0 (dialog);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	gtk_window_destroy ((GtkWindow*) _data11_->avatar_selector);
}

static void
___lambda16__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda16_ (self, response_id);
}

static void
contacts_contact_editor_on_avatar_button_clicked (ContactsContactEditor* self,
                                                  GtkButton* avatar_button)
{
	Block11Data* _data11_;
	ContactsContact* _tmp0_;
	GtkRoot* _tmp1_;
	ContactsAvatarSelector* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (avatar_button != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp2_ = contacts_avatar_selector_new (_tmp0_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL);
	g_object_ref_sink (_tmp2_);
	_data11_->avatar_selector = _tmp2_;
	g_signal_connect_data ((GtkDialog*) _data11_->avatar_selector, "response", (GCallback) ___lambda16__gtk_dialog_response, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data11_->avatar_selector);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static GtkWidget*
contacts_contact_editor_create_name_entry (ContactsContactEditor* self,
                                           ContactsContact* contact)
{
	GtkEntry* entry = NULL;
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	ContactsFullNameChunk* fn_chunk = NULL;
	ContactsChunk* _tmp6_;
	ContactsFullNameChunk* _tmp7_;
	ContactsFullNameChunk* _tmp8_;
	ContactsFullNameChunk* _tmp9_;
	GtkEntry* _tmp10_;
	GtkEntry* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp0_);
	entry = _tmp0_;
	_tmp1_ = entry;
	self->priv->name_entry = _tmp1_;
	_tmp2_ = self->priv->name_entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->name_entry;
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	_tmp4_ = self->priv->name_entry;
	gtk_entry_set_input_purpose (_tmp4_, GTK_INPUT_PURPOSE_NAME);
	_tmp5_ = self->priv->name_entry;
	gtk_entry_set_placeholder_text (_tmp5_, _ ("Add name"));
	_tmp6_ = contacts_contact_get_most_relevant_chunk (contact, "full-name", TRUE);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CONTACTS_TYPE_FULL_NAME_CHUNK, ContactsFullNameChunk));
	fn_chunk = _tmp7_;
	_tmp8_ = fn_chunk;
	if (_tmp8_ == NULL) {
		g_warning ("contacts-contact-editor.vala:137: Contact doesn't have a 'full-name' c" \
"hunk");
		result = NULL;
		_g_object_unref0 (fn_chunk);
		_g_object_unref0 (entry);
		return result;
	}
	_tmp9_ = fn_chunk;
	_tmp10_ = self->priv->name_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp9_, "full-name", (GObject*) _tmp10_, "text", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp11_ = self->priv->name_entry;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	result = _tmp12_;
	_g_object_unref0 (fn_chunk);
	_g_object_unref0 (entry);
	return result;
}

static GtkLabel*
contacts_contact_editor_create_persona_store_label (ContactsContactEditor* self,
                                                    FolksPersona* p)
{
	GtkLabel* store_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	PangoAttrList* attrList = NULL;
	PangoAttrList* _tmp4_;
	PangoAttribute* _tmp5_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = contacts_utils_format_persona_store_name_for_contact (p);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	store_name = _tmp3_;
	_tmp4_ = pango_attr_list_new ();
	attrList = _tmp4_;
	_tmp5_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (attrList, _tmp5_);
	gtk_label_set_attributes (store_name, attrList);
	gtk_widget_set_halign ((GtkWidget*) store_name, GTK_ALIGN_START);
	gtk_label_set_ellipsize (store_name, PANGO_ELLIPSIZE_MIDDLE);
	result = store_name;
	_pango_attr_list_unref0 (attrList);
	return result;
}

ContactsContact*
contacts_contact_editor_get_contact (ContactsContactEditor* self)
{
	ContactsContact* result;
	ContactsContact* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_contact;
	result = _tmp0_;
	return result;
}

void
contacts_contact_editor_set_contact (ContactsContactEditor* self,
                                     ContactsContact* value)
{
	ContactsContact* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_editor_get_contact (self);
	if (old_value != value) {
		self->priv->_contact = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_editor_properties[CONTACTS_CONTACT_EDITOR_CONTACT_PROPERTY]);
	}
}

static GObject *
contacts_contact_editor_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactEditor * self;
	GtkBoxLayout* box_layout = NULL;
	GtkBoxLayout* _tmp0_;
	GtkBoxLayout* _tmp1_;
	GtkBoxLayout* _tmp2_;
	GtkLayoutManager* _tmp3_;
	parent_class = G_OBJECT_CLASS (contacts_contact_editor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditor);
	_tmp0_ = (GtkBoxLayout*) gtk_box_layout_new (GTK_ORIENTATION_VERTICAL);
	box_layout = _tmp0_;
	_tmp1_ = box_layout;
	gtk_box_layout_set_spacing (_tmp1_, 12);
	_tmp2_ = box_layout;
	_tmp3_ = _g_object_ref0 ((GtkLayoutManager*) _tmp2_);
	gtk_widget_set_layout_manager ((GtkWidget*) self, _tmp3_);
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-contact-editor");
	_g_object_unref0 (box_layout);
	return obj;
}

static void
contacts_contact_editor_class_init (ContactsContactEditorClass * klass,
                                    gpointer klass_data)
{
	contacts_contact_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactEditor_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) contacts_contact_editor_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_editor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_contact_editor_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_editor_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_editor_finalize;
	/** The contact we're editing */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_EDITOR_CONTACT_PROPERTY, contacts_contact_editor_properties[CONTACTS_CONTACT_EDITOR_CONTACT_PROPERTY] = g_param_spec_object ("contact", "contact", "contact", CONTACTS_TYPE_CONTACT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
contacts_contact_editor_instance_init (ContactsContactEditor * self,
                                       gpointer klass)
{
	GPtrArray* _tmp0_;
	self->priv = contacts_contact_editor_get_instance_private (self);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->personas = _tmp0_;
}

static void
contacts_contact_editor_finalize (GObject * obj)
{
	ContactsContactEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditor);
	_g_ptr_array_unref0 (self->priv->personas);
	G_OBJECT_CLASS (contacts_contact_editor_parent_class)->finalize (obj);
}

/**
 * A widget that allows the user to edit a given {@link Contact}.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactEditor), 0, (GInstanceInitFunc) contacts_contact_editor_instance_init, NULL };
	GType contacts_contact_editor_type_id;
	contacts_contact_editor_type_id = g_type_register_static (gtk_widget_get_type (), "ContactsContactEditor", &g_define_type_info, 0);
	ContactsContactEditor_private_offset = g_type_add_instance_private (contacts_contact_editor_type_id, sizeof (ContactsContactEditorPrivate));
	return contacts_contact_editor_type_id;
}

GType
contacts_contact_editor_get_type (void)
{
	static volatile gsize contacts_contact_editor_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_editor_type_id__once)) {
		GType contacts_contact_editor_type_id;
		contacts_contact_editor_type_id = contacts_contact_editor_get_type_once ();
		g_once_init_leave (&contacts_contact_editor_type_id__once, contacts_contact_editor_type_id);
	}
	return contacts_contact_editor_type_id__once;
}

static void
_vala_contacts_contact_editor_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ContactsContactEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditor);
	switch (property_id) {
		case CONTACTS_CONTACT_EDITOR_CONTACT_PROPERTY:
		g_value_set_object (value, contacts_contact_editor_get_contact (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_contact_editor_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	ContactsContactEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditor);
	switch (property_id) {
		case CONTACTS_CONTACT_EDITOR_CONTACT_PROPERTY:
		contacts_contact_editor_set_contact (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_persona_editor_get_instance_private (ContactsPersonaEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsPersonaEditor_private_offset);
}

ContactsPersonaEditor*
contacts_persona_editor_construct (GType object_type,
                                   ContactsContact* contact,
                                   FolksPersona* persona)
{
	ContactsPersonaEditor * self = NULL;
	g_return_val_if_fail (contact != NULL, NULL);
	self = (ContactsPersonaEditor*) g_object_new (object_type, "contact", contact, "persona", persona, NULL);
	return self;
}

ContactsPersonaEditor*
contacts_persona_editor_new (ContactsContact* contact,
                             FolksPersona* persona)
{
	return contacts_persona_editor_construct (CONTACTS_TYPE_PERSONA_EDITOR, contact, persona);
}

static void
contacts_persona_editor_real_dispose (GObject* base)
{
	ContactsPersonaEditor * self;
	GtkWidget* child = NULL;
	self = (ContactsPersonaEditor*) base;
	child = NULL;
	while (TRUE) {
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
		child = _tmp0_;
		_tmp1_ = child;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = child;
		gtk_widget_unparent (_tmp2_);
	}
	G_OBJECT_CLASS (contacts_persona_editor_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
contacts_persona_editor_ensure_chunks (ContactsPersonaEditor* self,
                                       ContactsContact* contact)
{
	const gchar** writeable_props = NULL;
	gint writeable_props_length1;
	gint _writeable_props_size_;
	FolksPersona* _tmp0_;
	const gchar** _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	writeable_props = CONTACTS_PERSONA_EDITOR_SUPPORTED_PROPERTIES;
	writeable_props_length1 = G_N_ELEMENTS (CONTACTS_PERSONA_EDITOR_SUPPORTED_PROPERTIES);
	_writeable_props_size_ = writeable_props_length1;
	_tmp0_ = self->priv->_persona;
	if (_tmp0_ != NULL) {
		FolksPersona* _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_ = 0;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp1_ = self->priv->_persona;
		_tmp2_ = folks_persona_get_writeable_properties (_tmp1_, &_tmp3_);
		_tmp2__length1 = _tmp3_;
		_tmp4_ = _tmp2_;
		_tmp4__length1 = _tmp2__length1;
		writeable_props = _tmp4_;
		writeable_props_length1 = _tmp4__length1;
		_writeable_props_size_ = writeable_props_length1;
	}
	_tmp5_ = writeable_props;
	_tmp5__length1 = writeable_props_length1;
	{
		const gchar** prop_collection = NULL;
		gint prop_collection_length1 = 0;
		gint _prop_collection_size_ = 0;
		gint prop_it = 0;
		prop_collection = _tmp5_;
		prop_collection_length1 = _tmp5__length1;
		for (prop_it = 0; prop_it < prop_collection_length1; prop_it = prop_it + 1) {
			const gchar* prop = NULL;
			prop = prop_collection[prop_it];
			{
				const gchar* _tmp6_;
				ContactsChunk* _tmp7_;
				_tmp6_ = prop;
				_tmp7_ = contacts_contact_get_most_relevant_chunk (contact, _tmp6_, TRUE);
				if (_tmp7_ == NULL) {
					const gchar* _tmp8_;
					FolksPersona* _tmp9_;
					_tmp8_ = prop;
					_tmp9_ = self->priv->_persona;
					contacts_contact_create_chunk (contact, _tmp8_, _tmp9_);
				}
			}
		}
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		ContactsPersonaEditor* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->filter);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
__lambda17_ (Block12Data* _data12_,
             GtkButton* button)
{
	ContactsPersonaEditor* self;
	GtkStringList* _tmp0_;
	GtkStringList* _tmp1_;
	GtkStringList* _tmp2_;
	GtkStringList* _tmp3_;
	self = _data12_->self;
	g_return_if_fail (button != NULL);
	gtk_widget_unparent ((GtkWidget*) button);
	_tmp0_ = contacts_chunk_property_filter_get_allowed_properties (_data12_->filter);
	_tmp1_ = _tmp0_;
	_tmp2_ = contacts_chunk_property_filter_get_allowed_properties (_data12_->filter);
	_tmp3_ = _tmp2_;
	gtk_string_list_splice (_tmp1_, (guint) 0, g_list_model_get_n_items ((GListModel*) _tmp3_), CONTACTS_PERSONA_EDITOR_SUPPORTED_PROPERTIES);
}

static void
___lambda17__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda17_ (self, _sender);
}

static void
contacts_persona_editor_add_show_more_button (ContactsPersonaEditor* self,
                                              ContactsChunkPropertyFilter* filter)
{
	Block12Data* _data12_;
	ContactsChunkPropertyFilter* _tmp0_;
	GtkButton* show_more_button = NULL;
	GtkButton* _tmp1_;
	AdwButtonContent* show_more_content = NULL;
	AdwButtonContent* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filter != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (filter);
	_g_object_unref0 (_data12_->filter);
	_data12_->filter = _tmp0_;
	_tmp1_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp1_);
	show_more_button = _tmp1_;
	_tmp2_ = (AdwButtonContent*) adw_button_content_new ();
	g_object_ref_sink (_tmp2_);
	show_more_content = _tmp2_;
	adw_button_content_set_icon_name (show_more_content, "view-more-symbolic");
	adw_button_content_set_label (show_more_content, _ ("Show More"));
	gtk_button_set_child (show_more_button, (GtkWidget*) show_more_content);
	gtk_widget_set_halign ((GtkWidget*) show_more_button, GTK_ALIGN_CENTER);
	gtk_widget_add_css_class ((GtkWidget*) show_more_button, "flat");
	g_signal_connect_data (show_more_button, "clicked", (GCallback) ___lambda17__gtk_button_clicked, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	gtk_widget_set_parent ((GtkWidget*) show_more_button, (GtkWidget*) self);
	_g_object_unref0 (show_more_content);
	_g_object_unref0 (show_more_button);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

static void
contacts_persona_editor_on_model_items_changed (ContactsPersonaEditor* self,
                                                GListModel* model,
                                                guint position,
                                                guint removed,
                                                guint added)
{
	GtkWidget* child = NULL;
	GtkWidget* _tmp0_;
	guint current_position = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	child = _tmp0_;
	current_position = (guint) 0;
	while (TRUE) {
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		guint _tmp4_;
		if (!(current_position < position)) {
			break;
		}
		_tmp1_ = child;
		_tmp2_ = gtk_widget_get_next_sibling (_tmp1_);
		child = _tmp2_;
		_tmp3_ = child;
		g_return_if_fail (_tmp3_ != NULL);
		_tmp4_ = current_position;
		current_position = _tmp4_ + 1;
	}
	while (TRUE) {
		GtkWidget* to_remove = NULL;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		guint _tmp9_;
		if (!(removed > ((guint) 0))) {
			break;
		}
		_tmp5_ = child;
		to_remove = _tmp5_;
		_tmp6_ = to_remove;
		_tmp7_ = gtk_widget_get_next_sibling (_tmp6_);
		child = _tmp7_;
		_tmp8_ = to_remove;
		gtk_widget_unparent (_tmp8_);
		_tmp9_ = removed;
		removed = _tmp9_ - 1;
	}
	{
		guint i = 0U;
		i = position;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				ContactsChunk* chunk = NULL;
				GObject* _tmp12_;
				GtkWidget* new_child = NULL;
				ContactsChunk* _tmp13_;
				GtkWidget* _tmp14_;
				GtkWidget* _tmp15_;
				if (!_tmp10_) {
					guint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				if (!(i < (position + added))) {
					break;
				}
				_tmp12_ = g_list_model_get_item (model, i);
				chunk = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, CONTACTS_TYPE_CHUNK, ContactsChunk);
				_tmp13_ = chunk;
				_tmp14_ = contacts_persona_editor_create_widget_for_chunk (self, _tmp13_);
				new_child = _tmp14_;
				_tmp15_ = new_child;
				if (_tmp15_ != NULL) {
					GtkWidget* _tmp16_;
					GtkWidget* _tmp17_;
					_tmp16_ = new_child;
					_tmp17_ = child;
					gtk_widget_insert_before (_tmp16_, (GtkWidget*) self, _tmp17_);
				}
				_g_object_unref0 (new_child);
				_g_object_unref0 (chunk);
			}
		}
	}
}

static GtkWidget*
contacts_persona_editor_create_widget_for_chunk (ContactsPersonaEditor* self,
                                                 ContactsChunk* chunk)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	static GQuark _tmp3_label4 = 0;
	static GQuark _tmp3_label5 = 0;
	static GQuark _tmp3_label6 = 0;
	static GQuark _tmp3_label7 = 0;
	static GQuark _tmp3_label8 = 0;
	static GQuark _tmp3_label9 = 0;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_tmp0_ = contacts_chunk_get_property_name (chunk);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if ((_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("avatar")))) || (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("full-name"))))) {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("birthday")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp5_;
				_tmp5_ = contacts_persona_editor_create_widget_for_birthday (self, chunk);
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("email-addresses")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp6_;
				_tmp6_ = contacts_persona_editor_create_widget_for_emails (self, chunk);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label4) ? _tmp3_label4 : (_tmp3_label4 = g_quark_from_static_string ("nickname")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp7_;
				_tmp7_ = contacts_persona_editor_create_widget_for_nickname (self, chunk);
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label5) ? _tmp3_label5 : (_tmp3_label5 = g_quark_from_static_string ("notes")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp8_;
				_tmp8_ = contacts_persona_editor_create_widget_for_notes (self, chunk);
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label6) ? _tmp3_label6 : (_tmp3_label6 = g_quark_from_static_string ("phone-numbers")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp9_;
				_tmp9_ = contacts_persona_editor_create_widget_for_phones (self, chunk);
				result = _tmp9_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label7) ? _tmp3_label7 : (_tmp3_label7 = g_quark_from_static_string ("postal-addresses")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp10_;
				_tmp10_ = contacts_persona_editor_create_widget_for_addresses (self, chunk);
				result = _tmp10_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label8) ? _tmp3_label8 : (_tmp3_label8 = g_quark_from_static_string ("roles")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp11_;
				_tmp11_ = contacts_persona_editor_create_widget_for_roles (self, chunk);
				result = _tmp11_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label9) ? _tmp3_label9 : (_tmp3_label9 = g_quark_from_static_string ("urls")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp12_;
				_tmp12_ = contacts_persona_editor_create_widget_for_urls (self, chunk);
				result = _tmp12_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = contacts_chunk_get_property_name (chunk);
				_tmp14_ = _tmp13_;
				g_debug ("contacts-contact-editor.vala:325: Unsupported property: %s", _tmp14_);
				result = NULL;
				return result;
			}
		}
	}
}

static ContactsContactEditorProperty*
_contacts_persona_editor_create_email_widget_contacts_contact_editor_group_create_widget_func (ContactsBinChunkChild* chunk_child,
                                                                                               gpointer self)
{
	ContactsContactEditorProperty* result;
	result = contacts_persona_editor_create_email_widget ((ContactsPersonaEditor*) self, chunk_child);
	return result;
}

static GtkWidget*
contacts_persona_editor_create_widget_for_emails (ContactsPersonaEditor* self,
                                                  ContactsChunk* chunk)
{
	ContactsEmailAddressesChunk* emails_chunk = NULL;
	ContactsContactEditorGroup* group = NULL;
	ContactsContact* _tmp0_;
	FolksPersona* _tmp1_;
	ContactsContactEditorGroup* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_EMAIL_ADDRESSES_CHUNK), "chunk is EmailAddressesChunk", NULL);
	emails_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_EMAIL_ADDRESSES_CHUNK, ContactsEmailAddressesChunk);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = self->priv->_persona;
	_tmp2_ = contacts_contact_editor_group_new (_tmp0_, _tmp1_, (ContactsBinChunk*) emails_chunk, _contacts_persona_editor_create_email_widget_contacts_contact_editor_group_create_widget_func, self);
	g_object_ref_sink (_tmp2_);
	group = _tmp2_;
	result = (GtkWidget*) group;
	return result;
}

static ContactsContactEditorProperty*
contacts_persona_editor_create_email_widget (ContactsPersonaEditor* self,
                                             ContactsBinChunkChild* chunk_child)
{
	AdwEntryRow* row = NULL;
	AdwEntryRow* _tmp0_;
	GtkImage* icon = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkImage* _tmp3_;
	ContactsContactEditorProperty* widget = NULL;
	ContactsContactEditorProperty* _tmp4_;
	ContactsTypeSet* _tmp5_;
	ContactsTypeSet* _tmp6_;
	ContactsContactEditorProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk_child != NULL, NULL);
	_tmp0_ = (AdwEntryRow*) adw_entry_row_new ();
	g_object_ref_sink (_tmp0_);
	row = _tmp0_;
	_tmp1_ = contacts_bin_chunk_child_get_icon_name (chunk_child);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp2_);
	g_object_ref_sink (_tmp3_);
	icon = _tmp3_;
	g_object_bind_property_with_closures ((GObject*) chunk_child, "icon-name", (GObject*) icon, "icon-name", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	adw_entry_row_add_prefix (row, (GtkWidget*) icon);
	adw_preferences_row_set_title ((AdwPreferencesRow*) row, _ ("Add email"));
	adw_entry_row_set_input_purpose (row, GTK_INPUT_PURPOSE_EMAIL);
	g_object_bind_property_with_closures ((GObject*) chunk_child, "raw-address", (GObject*) row, "text", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = contacts_contact_editor_property_new ((GtkWidget*) row);
	g_object_ref_sink (_tmp4_);
	widget = _tmp4_;
	_tmp5_ = contacts_typeset_get_email ();
	_tmp6_ = _tmp5_;
	contacts_contact_editor_property_add_type_combo (widget, chunk_child, _tmp6_);
	result = widget;
	_g_object_unref0 (icon);
	_g_object_unref0 (row);
	return result;
}

static ContactsContactEditorProperty*
_contacts_persona_editor_create_phone_widget_contacts_contact_editor_group_create_widget_func (ContactsBinChunkChild* chunk_child,
                                                                                               gpointer self)
{
	ContactsContactEditorProperty* result;
	result = contacts_persona_editor_create_phone_widget ((ContactsPersonaEditor*) self, chunk_child);
	return result;
}

static GtkWidget*
contacts_persona_editor_create_widget_for_phones (ContactsPersonaEditor* self,
                                                  ContactsChunk* chunk)
{
	ContactsPhonesChunk* phones_chunk = NULL;
	ContactsContactEditorGroup* group = NULL;
	ContactsContact* _tmp0_;
	FolksPersona* _tmp1_;
	ContactsContactEditorGroup* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_PHONES_CHUNK), "chunk is PhonesChunk", NULL);
	phones_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_PHONES_CHUNK, ContactsPhonesChunk);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = self->priv->_persona;
	_tmp2_ = contacts_contact_editor_group_new (_tmp0_, _tmp1_, (ContactsBinChunk*) phones_chunk, _contacts_persona_editor_create_phone_widget_contacts_contact_editor_group_create_widget_func, self);
	g_object_ref_sink (_tmp2_);
	group = _tmp2_;
	result = (GtkWidget*) group;
	return result;
}

static ContactsContactEditorProperty*
contacts_persona_editor_create_phone_widget (ContactsPersonaEditor* self,
                                             ContactsBinChunkChild* chunk_child)
{
	AdwEntryRow* row = NULL;
	AdwEntryRow* _tmp0_;
	GtkImage* icon = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkImage* _tmp3_;
	ContactsContactEditorProperty* widget = NULL;
	ContactsContactEditorProperty* _tmp4_;
	ContactsTypeSet* _tmp5_;
	ContactsTypeSet* _tmp6_;
	ContactsContactEditorProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk_child != NULL, NULL);
	_tmp0_ = (AdwEntryRow*) adw_entry_row_new ();
	g_object_ref_sink (_tmp0_);
	row = _tmp0_;
	_tmp1_ = contacts_bin_chunk_child_get_icon_name (chunk_child);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp2_);
	g_object_ref_sink (_tmp3_);
	icon = _tmp3_;
	g_object_bind_property_with_closures ((GObject*) chunk_child, "icon-name", (GObject*) icon, "icon-name", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	adw_entry_row_add_prefix (row, (GtkWidget*) icon);
	adw_preferences_row_set_title ((AdwPreferencesRow*) row, _ ("Add phone number"));
	adw_entry_row_set_input_purpose (row, GTK_INPUT_PURPOSE_PHONE);
	g_object_bind_property_with_closures ((GObject*) chunk_child, "raw-number", (GObject*) row, "text", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = contacts_contact_editor_property_new ((GtkWidget*) row);
	g_object_ref_sink (_tmp4_);
	widget = _tmp4_;
	_tmp5_ = contacts_typeset_get_phone ();
	_tmp6_ = _tmp5_;
	contacts_contact_editor_property_add_type_combo (widget, chunk_child, _tmp6_);
	result = widget;
	_g_object_unref0 (icon);
	_g_object_unref0 (row);
	return result;
}

static ContactsContactEditorProperty*
_contacts_persona_editor_create_url_widget_contacts_contact_editor_group_create_widget_func (ContactsBinChunkChild* chunk_child,
                                                                                             gpointer self)
{
	ContactsContactEditorProperty* result;
	result = contacts_persona_editor_create_url_widget ((ContactsPersonaEditor*) self, chunk_child);
	return result;
}

static GtkWidget*
contacts_persona_editor_create_widget_for_urls (ContactsPersonaEditor* self,
                                                ContactsChunk* chunk)
{
	ContactsUrlsChunk* urls_chunk = NULL;
	ContactsContactEditorGroup* group = NULL;
	ContactsContact* _tmp0_;
	FolksPersona* _tmp1_;
	ContactsContactEditorGroup* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_URLS_CHUNK), "chunk is UrlsChunk", NULL);
	urls_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_URLS_CHUNK, ContactsUrlsChunk);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = self->priv->_persona;
	_tmp2_ = contacts_contact_editor_group_new (_tmp0_, _tmp1_, (ContactsBinChunk*) urls_chunk, _contacts_persona_editor_create_url_widget_contacts_contact_editor_group_create_widget_func, self);
	g_object_ref_sink (_tmp2_);
	group = _tmp2_;
	result = (GtkWidget*) group;
	return result;
}

static ContactsContactEditorProperty*
contacts_persona_editor_create_url_widget (ContactsPersonaEditor* self,
                                           ContactsBinChunkChild* chunk_child)
{
	AdwEntryRow* row = NULL;
	AdwEntryRow* _tmp0_;
	GtkImage* icon = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkImage* _tmp3_;
	ContactsContactEditorProperty* _tmp4_;
	ContactsContactEditorProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk_child != NULL, NULL);
	_tmp0_ = (AdwEntryRow*) adw_entry_row_new ();
	g_object_ref_sink (_tmp0_);
	row = _tmp0_;
	_tmp1_ = contacts_bin_chunk_child_get_icon_name (chunk_child);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp2_);
	g_object_ref_sink (_tmp3_);
	icon = _tmp3_;
	g_object_bind_property_with_closures ((GObject*) chunk_child, "icon-name", (GObject*) icon, "icon-name", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	adw_entry_row_add_prefix (row, (GtkWidget*) icon);
	adw_preferences_row_set_title ((AdwPreferencesRow*) row, _ ("Website"));
	adw_entry_row_set_input_purpose (row, GTK_INPUT_PURPOSE_URL);
	g_object_bind_property_with_closures ((GObject*) chunk_child, "raw-url", (GObject*) row, "text", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = contacts_contact_editor_property_new ((GtkWidget*) row);
	g_object_ref_sink (_tmp4_);
	result = _tmp4_;
	_g_object_unref0 (icon);
	_g_object_unref0 (row);
	return result;
}

static GtkWidget*
contacts_persona_editor_create_widget_for_nickname (ContactsPersonaEditor* self,
                                                    ContactsChunk* chunk)
{
	AdwEntryRow* row = NULL;
	AdwEntryRow* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	ContactsContactEditorProperty* _tmp3_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_NICKNAME_CHUNK), "chunk is NicknameChunk", NULL);
	_tmp0_ = (AdwEntryRow*) adw_entry_row_new ();
	g_object_ref_sink (_tmp0_);
	row = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("avatar-default-symbolic");
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	adw_entry_row_add_prefix (row, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	adw_preferences_row_set_title ((AdwPreferencesRow*) row, _ ("Nickname"));
	adw_entry_row_set_input_purpose (row, GTK_INPUT_PURPOSE_NAME);
	g_object_bind_property_with_closures ((GObject*) chunk, "nickname", (GObject*) row, "text", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp3_ = contacts_contact_editor_property_new ((GtkWidget*) row);
	g_object_ref_sink (_tmp3_);
	result = (GtkWidget*) _tmp3_;
	_g_object_unref0 (row);
	return result;
}

static ContactsContactEditorProperty*
_contacts_persona_editor_create_note_widget_contacts_contact_editor_group_create_widget_func (ContactsBinChunkChild* chunk_child,
                                                                                              gpointer self)
{
	ContactsContactEditorProperty* result;
	result = contacts_persona_editor_create_note_widget ((ContactsPersonaEditor*) self, chunk_child);
	return result;
}

static GtkWidget*
contacts_persona_editor_create_widget_for_notes (ContactsPersonaEditor* self,
                                                 ContactsChunk* chunk)
{
	ContactsNotesChunk* notes_chunk = NULL;
	ContactsContactEditorGroup* group = NULL;
	ContactsContact* _tmp0_;
	FolksPersona* _tmp1_;
	ContactsContactEditorGroup* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_NOTES_CHUNK), "chunk is NotesChunk", NULL);
	notes_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_NOTES_CHUNK, ContactsNotesChunk);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = self->priv->_persona;
	_tmp2_ = contacts_contact_editor_group_new (_tmp0_, _tmp1_, (ContactsBinChunk*) notes_chunk, _contacts_persona_editor_create_note_widget_contacts_contact_editor_group_create_widget_func, self);
	g_object_ref_sink (_tmp2_);
	group = _tmp2_;
	result = (GtkWidget*) group;
	return result;
}

static ContactsContactEditorProperty*
contacts_persona_editor_create_note_widget (ContactsPersonaEditor* self,
                                            ContactsBinChunkChild* chunk_child)
{
	AdwPreferencesRow* row = NULL;
	AdwPreferencesRow* _tmp0_;
	GtkBox* header = NULL;
	GtkBox* _tmp1_;
	GtkBox* prefixes = NULL;
	GtkBox* _tmp2_;
	GtkImage* icon = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkImage* _tmp5_;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp6_;
	GtkTextView* textview = NULL;
	GtkTextView* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	ContactsContactEditorProperty* _tmp10_;
	ContactsContactEditorProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk_child != NULL, NULL);
	_tmp0_ = (AdwPreferencesRow*) adw_preferences_row_new ();
	g_object_ref_sink (_tmp0_);
	row = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	header = _tmp1_;
	gtk_widget_add_css_class ((GtkWidget*) header, "header");
	gtk_list_box_row_set_child ((GtkListBoxRow*) row, (GtkWidget*) header);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp2_);
	prefixes = _tmp2_;
	gtk_widget_add_css_class ((GtkWidget*) prefixes, "prefixes");
	_tmp3_ = contacts_bin_chunk_child_get_icon_name (chunk_child);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp4_);
	g_object_ref_sink (_tmp5_);
	icon = _tmp5_;
	g_object_bind_property_with_closures ((GObject*) chunk_child, "icon-name", (GObject*) icon, "icon-name", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	gtk_box_append (prefixes, (GtkWidget*) icon);
	gtk_box_append (header, (GtkWidget*) prefixes);
	_tmp6_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp6_);
	sw = _tmp6_;
	gtk_widget_set_focusable ((GtkWidget*) sw, FALSE);
	gtk_scrolled_window_set_has_frame (sw, FALSE);
	gtk_widget_set_size_request ((GtkWidget*) sw, -1, 100);
	_tmp7_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp7_);
	textview = _tmp7_;
	_tmp8_ = gtk_text_view_get_buffer (textview);
	_tmp9_ = _tmp8_;
	g_object_bind_property_with_closures ((GObject*) chunk_child, "text", (GObject*) _tmp9_, "text", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	gtk_widget_set_hexpand ((GtkWidget*) textview, TRUE);
	gtk_scrolled_window_set_child (sw, (GtkWidget*) textview);
	gtk_box_append (header, (GtkWidget*) sw);
	_tmp10_ = contacts_contact_editor_property_new ((GtkWidget*) row);
	g_object_ref_sink (_tmp10_);
	result = _tmp10_;
	_g_object_unref0 (textview);
	_g_object_unref0 (sw);
	_g_object_unref0 (icon);
	_g_object_unref0 (prefixes);
	_g_object_unref0 (header);
	_g_object_unref0 (row);
	return result;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		ContactsPersonaEditor* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->button);
		_g_object_unref0 (_data13_->bd_chunk);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		ContactsPersonaEditor* self;
		self = _data14_->_data13_->self;
		_g_object_unref0 (_data14_->dialog);
		block13_data_unref (_data14_->_data13_);
		_data14_->_data13_ = NULL;
		g_slice_free (Block14Data, _data14_);
	}
}

static void
__lambda22_ (Block14Data* _data14_)
{
	Block13Data* _data13_;
	ContactsPersonaEditor* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	_data13_ = _data14_->_data13_;
	self = _data13_->self;
	_tmp0_ = contacts_birthday_editor_get_is_set (_data14_->dialog);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ContactsBirthdayChunk* _tmp2_;
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		GtkButton* _tmp5_;
		ContactsBirthdayChunk* _tmp6_;
		GDateTime* _tmp7_;
		GDateTime* _tmp8_;
		GDateTime* _tmp9_;
		GDateTime* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp2_ = _data13_->bd_chunk;
		_tmp3_ = contacts_birthday_editor_get_birthday (_data14_->dialog);
		_tmp4_ = _tmp3_;
		contacts_birthday_chunk_set_birthday (_tmp2_, _tmp4_);
		_g_date_time_unref0 (_tmp4_);
		_tmp5_ = _data13_->button;
		_tmp6_ = _data13_->bd_chunk;
		_tmp7_ = contacts_birthday_chunk_get_birthday (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_date_time_to_local (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_date_time_format (_tmp10_, "%x");
		_tmp12_ = _tmp11_;
		gtk_button_set_label (_tmp5_, _tmp12_);
		_g_free0 (_tmp12_);
		_g_date_time_unref0 (_tmp10_);
	}
}

static void
___lambda22__contacts_birthday_editor_changed (ContactsBirthdayEditor* _sender,
                                               gpointer self)
{
	__lambda22_ (self);
}

static void
__lambda18_ (Block13Data* _data13_)
{
	ContactsPersonaEditor* self;
	Block14Data* _data14_;
	GtkWindow* parent_window = NULL;
	GtkRoot* _tmp0_;
	ContactsBirthdayChunk* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	ContactsBirthdayEditor* _tmp4_;
	self = _data13_->self;
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->_data13_ = block13_data_ref (_data13_);
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	parent_window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL;
	_tmp1_ = _data13_->bd_chunk;
	_tmp2_ = contacts_birthday_chunk_get_birthday (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_birthday_editor_new (parent_window, _tmp3_);
	g_object_ref_sink (_tmp4_);
	_data14_->dialog = _tmp4_;
	g_signal_connect_data (_data14_->dialog, "changed", (GCallback) ___lambda22__contacts_birthday_editor_changed, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data14_->dialog);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}

static void
___lambda18__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda18_ (self);
}

static GtkWidget*
contacts_persona_editor_create_widget_for_birthday (ContactsPersonaEditor* self,
                                                    ContactsChunk* chunk)
{
	Block13Data* _data13_;
	ContactsBirthdayChunk* _tmp0_;
	AdwActionRow* row = NULL;
	AdwActionRow* _tmp1_;
	AdwActionRow* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	AdwActionRow* _tmp5_;
	ContactsBirthdayChunk* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	AdwActionRow* _tmp20_;
	GtkButton* _tmp21_;
	AdwActionRow* _tmp22_;
	GtkButton* _tmp23_;
	AdwActionRow* _tmp24_;
	ContactsContactEditorProperty* _tmp25_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_BIRTHDAY_CHUNK), "chunk is BirthdayChunk", NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_BIRTHDAY_CHUNK, ContactsBirthdayChunk));
	_data13_->bd_chunk = _tmp0_;
	_tmp1_ = (AdwActionRow*) adw_action_row_new ();
	g_object_ref_sink (_tmp1_);
	row = _tmp1_;
	_tmp2_ = row;
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name ("birthday-symbolic");
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	adw_action_row_add_prefix (_tmp2_, (GtkWidget*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = row;
	adw_preferences_row_set_title ((AdwPreferencesRow*) _tmp5_, _ ("Birthday"));
	_tmp6_ = _data13_->bd_chunk;
	_tmp7_ = contacts_birthday_chunk_get_birthday (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NULL) {
		GtkButton* _tmp9_;
		_tmp9_ = (GtkButton*) gtk_button_new_with_label (_ ("Set Birthday"));
		g_object_ref_sink (_tmp9_);
		_g_object_unref0 (_data13_->button);
		_data13_->button = _tmp9_;
	} else {
		ContactsBirthdayChunk* _tmp10_;
		GDateTime* _tmp11_;
		GDateTime* _tmp12_;
		GDateTime* _tmp13_;
		GDateTime* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GtkButton* _tmp17_;
		_tmp10_ = _data13_->bd_chunk;
		_tmp11_ = contacts_birthday_chunk_get_birthday (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_date_time_to_local (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_date_time_format (_tmp14_, "%x");
		_tmp16_ = _tmp15_;
		_tmp17_ = (GtkButton*) gtk_button_new_with_label (_tmp16_);
		g_object_ref_sink (_tmp17_);
		_g_object_unref0 (_data13_->button);
		_data13_->button = _tmp17_;
		_g_free0 (_tmp16_);
		_g_date_time_unref0 (_tmp14_);
	}
	_tmp18_ = _data13_->button;
	gtk_widget_set_valign ((GtkWidget*) _tmp18_, GTK_ALIGN_CENTER);
	_tmp19_ = _data13_->button;
	g_signal_connect_data (_tmp19_, "clicked", (GCallback) ___lambda18__gtk_button_clicked, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_tmp20_ = row;
	_tmp21_ = _data13_->button;
	adw_action_row_add_suffix (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = row;
	_tmp23_ = _data13_->button;
	adw_action_row_set_activatable_widget (_tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = row;
	_tmp25_ = contacts_contact_editor_property_new ((GtkWidget*) _tmp24_);
	g_object_ref_sink (_tmp25_);
	result = (GtkWidget*) _tmp25_;
	_g_object_unref0 (row);
	block13_data_unref (_data13_);
	_data13_ = NULL;
	return result;
}

static ContactsContactEditorProperty*
_contacts_persona_editor_create_address_widget_contacts_contact_editor_group_create_widget_func (ContactsBinChunkChild* chunk_child,
                                                                                                 gpointer self)
{
	ContactsContactEditorProperty* result;
	result = contacts_persona_editor_create_address_widget ((ContactsPersonaEditor*) self, chunk_child);
	return result;
}

static GtkWidget*
contacts_persona_editor_create_widget_for_addresses (ContactsPersonaEditor* self,
                                                     ContactsChunk* chunk)
{
	ContactsAddressesChunk* addresses_chunk = NULL;
	ContactsContactEditorGroup* group = NULL;
	ContactsContact* _tmp0_;
	FolksPersona* _tmp1_;
	ContactsContactEditorGroup* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_ADDRESSES_CHUNK), "chunk is AddressesChunk", NULL);
	addresses_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_ADDRESSES_CHUNK, ContactsAddressesChunk);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = self->priv->_persona;
	_tmp2_ = contacts_contact_editor_group_new (_tmp0_, _tmp1_, (ContactsBinChunk*) addresses_chunk, _contacts_persona_editor_create_address_widget_contacts_contact_editor_group_create_widget_func, self);
	g_object_ref_sink (_tmp2_);
	group = _tmp2_;
	result = (GtkWidget*) group;
	return result;
}

static ContactsContactEditorProperty*
contacts_persona_editor_create_address_widget (ContactsPersonaEditor* self,
                                               ContactsBinChunkChild* chunk_child)
{
	ContactsAddress* address_chunk = NULL;
	AdwPreferencesRow* row = NULL;
	AdwPreferencesRow* _tmp0_;
	GtkBox* header = NULL;
	GtkBox* _tmp1_;
	GtkBox* prefixes = NULL;
	GtkBox* _tmp2_;
	GtkImage* icon = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkImage* _tmp5_;
	ContactsAddressEditor* editor = NULL;
	ContactsAddressEditor* _tmp6_;
	ContactsContactEditorProperty* widget = NULL;
	ContactsContactEditorProperty* _tmp7_;
	ContactsTypeSet* _tmp8_;
	ContactsTypeSet* _tmp9_;
	ContactsContactEditorProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk_child != NULL, NULL);
	address_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk_child, CONTACTS_TYPE_ADDRESS, ContactsAddress);
	_tmp0_ = (AdwPreferencesRow*) adw_preferences_row_new ();
	g_object_ref_sink (_tmp0_);
	row = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	header = _tmp1_;
	gtk_widget_add_css_class ((GtkWidget*) header, "header");
	gtk_list_box_row_set_child ((GtkListBoxRow*) row, (GtkWidget*) header);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp2_);
	prefixes = _tmp2_;
	gtk_widget_add_css_class ((GtkWidget*) prefixes, "prefixes");
	_tmp3_ = contacts_bin_chunk_child_get_icon_name (chunk_child);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp4_);
	g_object_ref_sink (_tmp5_);
	icon = _tmp5_;
	g_object_bind_property_with_closures ((GObject*) chunk_child, "icon-name", (GObject*) icon, "icon-name", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	gtk_box_append (prefixes, (GtkWidget*) icon);
	gtk_box_append (header, (GtkWidget*) prefixes);
	_tmp6_ = contacts_address_editor_new (address_chunk);
	g_object_ref_sink (_tmp6_);
	editor = _tmp6_;
	gtk_widget_set_hexpand ((GtkWidget*) editor, TRUE);
	gtk_box_append (header, (GtkWidget*) editor);
	_tmp7_ = contacts_contact_editor_property_new ((GtkWidget*) row);
	g_object_ref_sink (_tmp7_);
	widget = _tmp7_;
	_tmp8_ = contacts_typeset_get_general ();
	_tmp9_ = _tmp8_;
	contacts_contact_editor_property_add_type_combo (widget, chunk_child, _tmp9_);
	result = widget;
	_g_object_unref0 (editor);
	_g_object_unref0 (icon);
	_g_object_unref0 (prefixes);
	_g_object_unref0 (header);
	_g_object_unref0 (row);
	return result;
}

static ContactsContactEditorProperty*
_contacts_persona_editor_create_role_widget_contacts_contact_editor_group_create_widget_func (ContactsBinChunkChild* chunk_child,
                                                                                              gpointer self)
{
	ContactsContactEditorProperty* result;
	result = contacts_persona_editor_create_role_widget ((ContactsPersonaEditor*) self, chunk_child);
	return result;
}

static GtkWidget*
contacts_persona_editor_create_widget_for_roles (ContactsPersonaEditor* self,
                                                 ContactsChunk* chunk)
{
	ContactsRolesChunk* roles_chunk = NULL;
	ContactsContactEditorGroup* group = NULL;
	ContactsContact* _tmp0_;
	FolksPersona* _tmp1_;
	ContactsContactEditorGroup* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_ROLES_CHUNK), "chunk is RolesChunk", NULL);
	roles_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_ROLES_CHUNK, ContactsRolesChunk);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = self->priv->_persona;
	_tmp2_ = contacts_contact_editor_group_new (_tmp0_, _tmp1_, (ContactsBinChunk*) roles_chunk, _contacts_persona_editor_create_role_widget_contacts_contact_editor_group_create_widget_func, self);
	g_object_ref_sink (_tmp2_);
	group = _tmp2_;
	result = (GtkWidget*) group;
	return result;
}

static ContactsContactEditorProperty*
contacts_persona_editor_create_role_widget (ContactsPersonaEditor* self,
                                            ContactsBinChunkChild* chunk_child)
{
	ContactsOrgRole* role_chunk = NULL;
	AdwEntryRow* org_row = NULL;
	AdwEntryRow* _tmp0_;
	GtkImage* icon = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkImage* _tmp3_;
	FolksRole* _tmp4_;
	FolksRole* _tmp5_;
	ContactsContactEditorProperty* widget = NULL;
	ContactsContactEditorProperty* _tmp6_;
	AdwEntryRow* role_row = NULL;
	AdwEntryRow* _tmp7_;
	FolksRole* _tmp8_;
	FolksRole* _tmp9_;
	ContactsContactEditorProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk_child != NULL, NULL);
	role_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk_child, CONTACTS_TYPE_ORG_ROLE, ContactsOrgRole);
	_tmp0_ = (AdwEntryRow*) adw_entry_row_new ();
	g_object_ref_sink (_tmp0_);
	org_row = _tmp0_;
	_tmp1_ = contacts_bin_chunk_child_get_icon_name (chunk_child);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp2_);
	g_object_ref_sink (_tmp3_);
	icon = _tmp3_;
	g_object_bind_property_with_closures ((GObject*) chunk_child, "icon-name", (GObject*) icon, "icon-name", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	adw_entry_row_add_prefix (org_row, (GtkWidget*) icon);
	adw_preferences_row_set_title ((AdwPreferencesRow*) org_row, _ ("Organisation"));
	_tmp4_ = contacts_org_role_get_role (role_chunk);
	_tmp5_ = _tmp4_;
	g_object_bind_property_with_closures ((GObject*) _tmp5_, "organisation-name", (GObject*) org_row, "text", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp6_ = contacts_contact_editor_property_new ((GtkWidget*) org_row);
	g_object_ref_sink (_tmp6_);
	widget = _tmp6_;
	_tmp7_ = (AdwEntryRow*) adw_entry_row_new ();
	g_object_ref_sink (_tmp7_);
	role_row = _tmp7_;
	adw_preferences_row_set_title ((AdwPreferencesRow*) role_row, _ ("Role"));
	_tmp8_ = contacts_org_role_get_role (role_chunk);
	_tmp9_ = _tmp8_;
	g_object_bind_property_with_closures ((GObject*) _tmp9_, "title", (GObject*) role_row, "text", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	contacts_contact_editor_property_add (widget, (GtkWidget*) role_row);
	result = widget;
	_g_object_unref0 (role_row);
	_g_object_unref0 (icon);
	_g_object_unref0 (org_row);
	return result;
}

ContactsContact*
contacts_persona_editor_get_contact (ContactsPersonaEditor* self)
{
	ContactsContact* result;
	ContactsContact* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_contact;
	result = _tmp0_;
	return result;
}

void
contacts_persona_editor_set_contact (ContactsPersonaEditor* self,
                                     ContactsContact* value)
{
	ContactsContact* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_persona_editor_get_contact (self);
	if (old_value != value) {
		self->priv->_contact = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_persona_editor_properties[CONTACTS_PERSONA_EDITOR_CONTACT_PROPERTY]);
	}
}

FolksPersona*
contacts_persona_editor_get_persona (ContactsPersonaEditor* self)
{
	FolksPersona* result;
	FolksPersona* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_persona;
	result = _tmp0_;
	return result;
}

void
contacts_persona_editor_set_persona (ContactsPersonaEditor* self,
                                     FolksPersona* value)
{
	FolksPersona* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_persona_editor_get_persona (self);
	if (old_value != value) {
		self->priv->_persona = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_persona_editor_properties[CONTACTS_PERSONA_EDITOR_PERSONA_PROPERTY]);
	}
}

static gboolean
_contacts_persona_editor___lambda24_ (ContactsPersonaEditor* self,
                                      GObject* item)
{
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	gboolean result;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = contacts_chunk_get_persona (G_TYPE_CHECK_INSTANCE_CAST (item, CONTACTS_TYPE_CHUNK, ContactsChunk));
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_persona;
	result = _tmp1_ == _tmp2_;
	return result;
}

static gboolean
__contacts_persona_editor___lambda24__gtk_custom_filter_func (GObject* item,
                                                              gpointer self)
{
	gboolean result;
	result = _contacts_persona_editor___lambda24_ ((ContactsPersonaEditor*) self, item);
	return result;
}

static void
_contacts_persona_editor_on_model_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                            guint position,
                                                                            guint removed,
                                                                            guint added,
                                                                            gpointer self)
{
	contacts_persona_editor_on_model_items_changed ((ContactsPersonaEditor*) self, _sender, position, removed, added);
}

static GObject *
contacts_persona_editor_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsPersonaEditor * self;
	GtkBoxLayout* box_layout = NULL;
	GtkBoxLayout* _tmp0_;
	GtkBoxLayout* _tmp1_;
	GtkBoxLayout* _tmp2_;
	GtkLayoutManager* _tmp3_;
	ContactsContact* _tmp4_;
	GtkCustomFilter* persona_filter = NULL;
	GtkCustomFilter* _tmp5_;
	GtkFilterListModel* persona_model = NULL;
	ContactsContact* _tmp6_;
	GListModel* _tmp7_;
	GtkCustomFilter* _tmp8_;
	GtkFilterListModel* _tmp9_;
	GtkFilterListModel* _tmp10_;
	GtkAnyFilter* filter = NULL;
	GtkAnyFilter* _tmp11_;
	ContactsChunkPropertyFilter* prop_filter = NULL;
	ContactsChunkPropertyFilter* _tmp12_;
	GtkAnyFilter* _tmp13_;
	ContactsChunkPropertyFilter* _tmp14_;
	GtkFilter* _tmp15_;
	GtkEveryFilter* non_empty_filter = NULL;
	GtkEveryFilter* _tmp16_;
	GtkEveryFilter* _tmp17_;
	ContactsChunkEmptyFilter* _tmp18_;
	GtkEveryFilter* _tmp19_;
	ContactsChunkPropertyFilter* _tmp20_;
	GtkAnyFilter* _tmp21_;
	GtkEveryFilter* _tmp22_;
	GtkFilter* _tmp23_;
	GtkFilterListModel* filtered = NULL;
	GtkFilterListModel* _tmp24_;
	GListModel* _tmp25_;
	GtkAnyFilter* _tmp26_;
	GtkFilter* _tmp27_;
	GtkFilterListModel* _tmp28_;
	GtkFilterListModel* _tmp29_;
	GListModel* _tmp30_;
	ContactsChunkSorter* _tmp31_;
	GtkSortListModel* _tmp32_;
	GListModel* _tmp33_;
	GListModel* _tmp34_;
	GListModel* _tmp35_;
	ContactsChunkPropertyFilter* _tmp36_;
	parent_class = G_OBJECT_CLASS (contacts_persona_editor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_PERSONA_EDITOR, ContactsPersonaEditor);
	_tmp0_ = (GtkBoxLayout*) gtk_box_layout_new (GTK_ORIENTATION_VERTICAL);
	box_layout = _tmp0_;
	_tmp1_ = box_layout;
	gtk_box_layout_set_spacing (_tmp1_, 6);
	_tmp2_ = box_layout;
	_tmp3_ = _g_object_ref0 ((GtkLayoutManager*) _tmp2_);
	gtk_widget_set_layout_manager ((GtkWidget*) self, _tmp3_);
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-persona-editor");
	_tmp4_ = self->priv->_contact;
	contacts_persona_editor_ensure_chunks (self, _tmp4_);
	_tmp5_ = gtk_custom_filter_new (__contacts_persona_editor___lambda24__gtk_custom_filter_func, g_object_ref (self), g_object_unref);
	persona_filter = _tmp5_;
	_tmp6_ = self->priv->_contact;
	_tmp7_ = _g_object_ref0 ((GListModel*) _tmp6_);
	_tmp8_ = persona_filter;
	persona_filter = NULL;
	_tmp9_ = gtk_filter_list_model_new (_tmp7_, (GtkFilter*) _tmp8_);
	persona_model = _tmp9_;
	_tmp10_ = persona_model;
	g_return_if_fail (g_list_model_get_n_items ((GListModel*) _tmp10_) > ((guint) 0));
	_tmp11_ = gtk_any_filter_new ();
	filter = _tmp11_;
	_tmp12_ = contacts_chunk_property_filter_new (CONTACTS_PERSONA_EDITOR_IMPORTANT_PROPERTIES, G_N_ELEMENTS (CONTACTS_PERSONA_EDITOR_IMPORTANT_PROPERTIES));
	prop_filter = _tmp12_;
	_tmp13_ = filter;
	_tmp14_ = prop_filter;
	_tmp15_ = _g_object_ref0 ((GtkFilter*) _tmp14_);
	gtk_multi_filter_append ((GtkMultiFilter*) _tmp13_, _tmp15_);
	_tmp16_ = gtk_every_filter_new ();
	non_empty_filter = _tmp16_;
	_tmp17_ = non_empty_filter;
	_tmp18_ = contacts_chunk_empty_filter_new ();
	gtk_multi_filter_append ((GtkMultiFilter*) _tmp17_, (GtkFilter*) _tmp18_);
	_tmp19_ = non_empty_filter;
	_tmp20_ = contacts_chunk_property_filter_new (CONTACTS_PERSONA_EDITOR_SUPPORTED_PROPERTIES, G_N_ELEMENTS (CONTACTS_PERSONA_EDITOR_SUPPORTED_PROPERTIES));
	gtk_multi_filter_append ((GtkMultiFilter*) _tmp19_, (GtkFilter*) _tmp20_);
	_tmp21_ = filter;
	_tmp22_ = non_empty_filter;
	_tmp23_ = _g_object_ref0 ((GtkFilter*) _tmp22_);
	gtk_multi_filter_append ((GtkMultiFilter*) _tmp21_, _tmp23_);
	_tmp24_ = persona_model;
	_tmp25_ = _g_object_ref0 ((GListModel*) _tmp24_);
	_tmp26_ = filter;
	_tmp27_ = _g_object_ref0 ((GtkFilter*) _tmp26_);
	_tmp28_ = gtk_filter_list_model_new (_tmp25_, _tmp27_);
	filtered = _tmp28_;
	_tmp29_ = filtered;
	_tmp30_ = _g_object_ref0 ((GListModel*) _tmp29_);
	_tmp31_ = contacts_chunk_sorter_new ();
	_tmp32_ = gtk_sort_list_model_new (_tmp30_, (GtkSorter*) _tmp31_);
	_g_object_unref0 (self->priv->model);
	self->priv->model = (GListModel*) _tmp32_;
	_tmp33_ = self->priv->model;
	g_signal_connect_object (_tmp33_, "items-changed", (GCallback) _contacts_persona_editor_on_model_items_changed_g_list_model_items_changed, self, 0);
	_tmp34_ = self->priv->model;
	_tmp35_ = self->priv->model;
	contacts_persona_editor_on_model_items_changed (self, _tmp34_, (guint) 0, (guint) 0, g_list_model_get_n_items (_tmp35_));
	_tmp36_ = prop_filter;
	contacts_persona_editor_add_show_more_button (self, _tmp36_);
	_g_object_unref0 (filtered);
	_g_object_unref0 (non_empty_filter);
	_g_object_unref0 (prop_filter);
	_g_object_unref0 (filter);
	_g_object_unref0 (persona_model);
	_g_object_unref0 (persona_filter);
	_g_object_unref0 (box_layout);
	return obj;
}

static void
contacts_persona_editor_class_init (ContactsPersonaEditorClass * klass,
                                    gpointer klass_data)
{
	contacts_persona_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsPersonaEditor_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) contacts_persona_editor_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_persona_editor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_persona_editor_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_persona_editor_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_persona_editor_finalize;
	/** The contact we're editing a (possibly non-existent) persona of */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_PERSONA_EDITOR_CONTACT_PROPERTY, contacts_persona_editor_properties[CONTACTS_PERSONA_EDITOR_CONTACT_PROPERTY] = g_param_spec_object ("contact", "contact", "contact", CONTACTS_TYPE_CONTACT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/** The specific persona of the contact we're editing */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_PERSONA_EDITOR_PERSONA_PROPERTY, contacts_persona_editor_properties[CONTACTS_PERSONA_EDITOR_PERSONA_PROPERTY] = g_param_spec_object ("persona", "persona", "persona", FOLKS_TYPE_PERSONA, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
contacts_persona_editor_instance_init (ContactsPersonaEditor * self,
                                       gpointer klass)
{
	self->priv = contacts_persona_editor_get_instance_private (self);
}

static void
contacts_persona_editor_finalize (GObject * obj)
{
	ContactsPersonaEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_PERSONA_EDITOR, ContactsPersonaEditor);
	_g_object_unref0 (self->priv->model);
	G_OBJECT_CLASS (contacts_persona_editor_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_persona_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsPersonaEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_persona_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsPersonaEditor), 0, (GInstanceInitFunc) contacts_persona_editor_instance_init, NULL };
	GType contacts_persona_editor_type_id;
	contacts_persona_editor_type_id = g_type_register_static (gtk_widget_get_type (), "ContactsPersonaEditor", &g_define_type_info, 0);
	ContactsPersonaEditor_private_offset = g_type_add_instance_private (contacts_persona_editor_type_id, sizeof (ContactsPersonaEditorPrivate));
	return contacts_persona_editor_type_id;
}

GType
contacts_persona_editor_get_type (void)
{
	static volatile gsize contacts_persona_editor_type_id__once = 0;
	if (g_once_init_enter (&contacts_persona_editor_type_id__once)) {
		GType contacts_persona_editor_type_id;
		contacts_persona_editor_type_id = contacts_persona_editor_get_type_once ();
		g_once_init_leave (&contacts_persona_editor_type_id__once, contacts_persona_editor_type_id);
	}
	return contacts_persona_editor_type_id__once;
}

static void
_vala_contacts_persona_editor_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ContactsPersonaEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_PERSONA_EDITOR, ContactsPersonaEditor);
	switch (property_id) {
		case CONTACTS_PERSONA_EDITOR_CONTACT_PROPERTY:
		g_value_set_object (value, contacts_persona_editor_get_contact (self));
		break;
		case CONTACTS_PERSONA_EDITOR_PERSONA_PROPERTY:
		g_value_set_object (value, contacts_persona_editor_get_persona (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_persona_editor_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	ContactsPersonaEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_PERSONA_EDITOR, ContactsPersonaEditor);
	switch (property_id) {
		case CONTACTS_PERSONA_EDITOR_CONTACT_PROPERTY:
		contacts_persona_editor_set_contact (self, g_value_get_object (value));
		break;
		case CONTACTS_PERSONA_EDITOR_PERSONA_PROPERTY:
		contacts_persona_editor_set_persona (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_contact_editor_group_get_instance_private (ContactsContactEditorGroup* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactEditorGroup_private_offset);
}

static void
_contacts_contact_editor_group_on_bin_chunk_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                                      guint position,
                                                                                      guint removed,
                                                                                      guint added,
                                                                                      gpointer self)
{
	contacts_contact_editor_group_on_bin_chunk_items_changed ((ContactsContactEditorGroup*) self, _sender, position, removed, added);
}

ContactsContactEditorGroup*
contacts_contact_editor_group_construct (GType object_type,
                                         ContactsContact* contact,
                                         FolksPersona* persona,
                                         ContactsBinChunk* chunk,
                                         ContactsContactEditorGroupCreateWidgetFunc func,
                                         gpointer func_target)
{
	ContactsContactEditorGroup * self = NULL;
	g_return_val_if_fail (contact != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	self = (ContactsContactEditorGroup*) g_object_new (object_type, "contact", contact, "persona", persona, NULL);
	self->priv->create_widget_func = func;
	self->priv->create_widget_func_target = func_target;
	g_signal_connect_object ((GListModel*) chunk, "items-changed", (GCallback) _contacts_contact_editor_group_on_bin_chunk_items_changed_g_list_model_items_changed, self, 0);
	contacts_contact_editor_group_on_bin_chunk_items_changed (self, (GListModel*) chunk, (guint) 0, (guint) 0, g_list_model_get_n_items ((GListModel*) chunk));
	return self;
}

ContactsContactEditorGroup*
contacts_contact_editor_group_new (ContactsContact* contact,
                                   FolksPersona* persona,
                                   ContactsBinChunk* chunk,
                                   ContactsContactEditorGroupCreateWidgetFunc func,
                                   gpointer func_target)
{
	return contacts_contact_editor_group_construct (CONTACTS_TYPE_CONTACT_EDITOR_GROUP, contact, persona, chunk, func, func_target);
}

static void
contacts_contact_editor_group_real_dispose (GObject* base)
{
	ContactsContactEditorGroup * self;
	GtkWidget* child = NULL;
	self = (ContactsContactEditorGroup*) base;
	child = NULL;
	while (TRUE) {
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
		child = _tmp0_;
		_tmp1_ = child;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = child;
		gtk_widget_unparent (_tmp2_);
	}
	G_OBJECT_CLASS (contacts_contact_editor_group_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
contacts_contact_editor_group_on_bin_chunk_items_changed (ContactsContactEditorGroup* self,
                                                          GListModel* model,
                                                          guint position,
                                                          guint removed,
                                                          guint added)
{
	GtkWidget* child = NULL;
	GtkWidget* _tmp0_;
	guint current_position = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	child = _tmp0_;
	current_position = (guint) 0;
	while (TRUE) {
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		guint _tmp3_;
		if (!(current_position < position)) {
			break;
		}
		_tmp1_ = child;
		_tmp2_ = gtk_widget_get_next_sibling (_tmp1_);
		child = _tmp2_;
		_tmp3_ = current_position;
		current_position = _tmp3_ + 1;
	}
	while (TRUE) {
		GtkWidget* to_remove = NULL;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		guint _tmp8_;
		if (!(removed > ((guint) 0))) {
			break;
		}
		_tmp4_ = child;
		to_remove = _tmp4_;
		_tmp5_ = to_remove;
		_tmp6_ = gtk_widget_get_next_sibling (_tmp5_);
		child = _tmp6_;
		_tmp7_ = to_remove;
		gtk_widget_unparent (_tmp7_);
		_tmp8_ = removed;
		removed = _tmp8_ - 1;
	}
	{
		guint i = 0U;
		i = position;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				ContactsBinChunkChild* chunk_child = NULL;
				GObject* _tmp11_;
				ContactsContactEditorProperty* new_child = NULL;
				ContactsContactEditorGroupCreateWidgetFunc _tmp12_;
				gpointer _tmp12__target;
				ContactsBinChunkChild* _tmp13_;
				ContactsContactEditorProperty* _tmp14_;
				ContactsContactEditorProperty* _tmp15_;
				if (!_tmp9_) {
					guint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < (position + added))) {
					break;
				}
				_tmp11_ = g_list_model_get_item (model, i);
				chunk_child = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, CONTACTS_TYPE_BIN_CHUNK_CHILD, ContactsBinChunkChild);
				_tmp12_ = self->priv->create_widget_func;
				_tmp12__target = self->priv->create_widget_func_target;
				_tmp13_ = chunk_child;
				_tmp14_ = _tmp12_ (_tmp13_, _tmp12__target);
				new_child = _tmp14_;
				_tmp15_ = new_child;
				if (_tmp15_ != NULL) {
					ContactsContactEditorProperty* _tmp16_;
					ContactsContactEditorProperty* _tmp17_;
					GtkWidget* _tmp18_;
					ContactsContactEditorProperty* _tmp19_;
					_tmp16_ = new_child;
					contacts_contact_editor_property_set_reveal (_tmp16_, FALSE);
					_tmp17_ = new_child;
					_tmp18_ = child;
					gtk_widget_insert_before ((GtkWidget*) _tmp17_, (GtkWidget*) self, _tmp18_);
					_tmp19_ = new_child;
					contacts_contact_editor_property_set_reveal (_tmp19_, TRUE);
				}
				_g_object_unref0 (new_child);
				_g_object_unref0 (chunk_child);
			}
		}
	}
}

ContactsContact*
contacts_contact_editor_group_get_contact (ContactsContactEditorGroup* self)
{
	ContactsContact* result;
	ContactsContact* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_contact;
	result = _tmp0_;
	return result;
}

void
contacts_contact_editor_group_set_contact (ContactsContactEditorGroup* self,
                                           ContactsContact* value)
{
	ContactsContact* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_editor_group_get_contact (self);
	if (old_value != value) {
		self->priv->_contact = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_editor_group_properties[CONTACTS_CONTACT_EDITOR_GROUP_CONTACT_PROPERTY]);
	}
}

FolksPersona*
contacts_contact_editor_group_get_persona (ContactsContactEditorGroup* self)
{
	FolksPersona* result;
	FolksPersona* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_persona;
	result = _tmp0_;
	return result;
}

void
contacts_contact_editor_group_set_persona (ContactsContactEditorGroup* self,
                                           FolksPersona* value)
{
	FolksPersona* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_editor_group_get_persona (self);
	if (old_value != value) {
		self->priv->_persona = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_editor_group_properties[CONTACTS_CONTACT_EDITOR_GROUP_PERSONA_PROPERTY]);
	}
}

static GObject *
contacts_contact_editor_group_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactEditorGroup * self;
	GtkBoxLayout* box_layout = NULL;
	GtkBoxLayout* _tmp0_;
	GtkBoxLayout* _tmp1_;
	GtkBoxLayout* _tmp2_;
	GtkLayoutManager* _tmp3_;
	parent_class = G_OBJECT_CLASS (contacts_contact_editor_group_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_EDITOR_GROUP, ContactsContactEditorGroup);
	_tmp0_ = (GtkBoxLayout*) gtk_box_layout_new (GTK_ORIENTATION_VERTICAL);
	box_layout = _tmp0_;
	_tmp1_ = box_layout;
	gtk_box_layout_set_spacing (_tmp1_, 6);
	_tmp2_ = box_layout;
	_tmp3_ = _g_object_ref0 ((GtkLayoutManager*) _tmp2_);
	gtk_widget_set_layout_manager ((GtkWidget*) self, _tmp3_);
	gtk_widget_add_css_class ((GtkWidget*) self, "contact-editor-group");
	_g_object_unref0 (box_layout);
	return obj;
}

static void
contacts_contact_editor_group_class_init (ContactsContactEditorGroupClass * klass,
                                          gpointer klass_data)
{
	contacts_contact_editor_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactEditorGroup_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) contacts_contact_editor_group_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_editor_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_contact_editor_group_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_editor_group_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_editor_group_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_EDITOR_GROUP_CONTACT_PROPERTY, contacts_contact_editor_group_properties[CONTACTS_CONTACT_EDITOR_GROUP_CONTACT_PROPERTY] = g_param_spec_object ("contact", "contact", "contact", CONTACTS_TYPE_CONTACT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_EDITOR_GROUP_PERSONA_PROPERTY, contacts_contact_editor_group_properties[CONTACTS_CONTACT_EDITOR_GROUP_PERSONA_PROPERTY] = g_param_spec_object ("persona", "persona", "persona", FOLKS_TYPE_PERSONA, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
contacts_contact_editor_group_instance_init (ContactsContactEditorGroup * self,
                                             gpointer klass)
{
	self->priv = contacts_contact_editor_group_get_instance_private (self);
}

static void
contacts_contact_editor_group_finalize (GObject * obj)
{
	ContactsContactEditorGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_EDITOR_GROUP, ContactsContactEditorGroup);
	G_OBJECT_CLASS (contacts_contact_editor_group_parent_class)->finalize (obj);
}

/** A widget for {@link BinChunk}s, allowing to create a widget for each */
 G_GNUC_NO_INLINE static GType
contacts_contact_editor_group_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactEditorGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_editor_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactEditorGroup), 0, (GInstanceInitFunc) contacts_contact_editor_group_instance_init, NULL };
	GType contacts_contact_editor_group_type_id;
	contacts_contact_editor_group_type_id = g_type_register_static (gtk_widget_get_type (), "ContactsContactEditorGroup", &g_define_type_info, 0);
	ContactsContactEditorGroup_private_offset = g_type_add_instance_private (contacts_contact_editor_group_type_id, sizeof (ContactsContactEditorGroupPrivate));
	return contacts_contact_editor_group_type_id;
}

GType
contacts_contact_editor_group_get_type (void)
{
	static volatile gsize contacts_contact_editor_group_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_editor_group_type_id__once)) {
		GType contacts_contact_editor_group_type_id;
		contacts_contact_editor_group_type_id = contacts_contact_editor_group_get_type_once ();
		g_once_init_leave (&contacts_contact_editor_group_type_id__once, contacts_contact_editor_group_type_id);
	}
	return contacts_contact_editor_group_type_id__once;
}

static void
_vala_contacts_contact_editor_group_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	ContactsContactEditorGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_EDITOR_GROUP, ContactsContactEditorGroup);
	switch (property_id) {
		case CONTACTS_CONTACT_EDITOR_GROUP_CONTACT_PROPERTY:
		g_value_set_object (value, contacts_contact_editor_group_get_contact (self));
		break;
		case CONTACTS_CONTACT_EDITOR_GROUP_PERSONA_PROPERTY:
		g_value_set_object (value, contacts_contact_editor_group_get_persona (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_contact_editor_group_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	ContactsContactEditorGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_EDITOR_GROUP, ContactsContactEditorGroup);
	switch (property_id) {
		case CONTACTS_CONTACT_EDITOR_GROUP_CONTACT_PROPERTY:
		contacts_contact_editor_group_set_contact (self, g_value_get_object (value));
		break;
		case CONTACTS_CONTACT_EDITOR_GROUP_PERSONA_PROPERTY:
		contacts_contact_editor_group_set_persona (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_contact_editor_property_get_instance_private (ContactsContactEditorProperty* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactEditorProperty_private_offset);
}

ContactsContactEditorProperty*
contacts_contact_editor_property_construct (GType object_type,
                                            GtkWidget* widget)
{
	ContactsContactEditorProperty * self = NULL;
	GtkRevealer* revealer = NULL;
	GtkRevealer* _tmp0_;
	AdwPreferencesGroup* prefs_group = NULL;
	AdwPreferencesGroup* _tmp1_;
	AdwPreferencesGroup* _tmp2_;
	g_return_val_if_fail (widget != NULL, NULL);
	self = (ContactsContactEditorProperty*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp0_);
	revealer = _tmp0_;
	gtk_widget_set_parent ((GtkWidget*) revealer, (GtkWidget*) self);
	_tmp1_ = (AdwPreferencesGroup*) adw_preferences_group_new ();
	g_object_ref_sink (_tmp1_);
	prefs_group = _tmp1_;
	gtk_widget_add_css_class ((GtkWidget*) prefs_group, "contacts-editor-property");
	self->priv->group = prefs_group;
	gtk_revealer_set_child (revealer, (GtkWidget*) prefs_group);
	g_object_bind_property_with_closures ((GObject*) self, "reveal", (GObject*) revealer, "reveal-child", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp2_ = self->priv->group;
	adw_preferences_group_add (_tmp2_, widget);
	_g_object_unref0 (prefs_group);
	_g_object_unref0 (revealer);
	return self;
}

ContactsContactEditorProperty*
contacts_contact_editor_property_new (GtkWidget* widget)
{
	return contacts_contact_editor_property_construct (CONTACTS_TYPE_CONTACT_EDITOR_PROPERTY, widget);
}

static void
contacts_contact_editor_property_real_dispose (GObject* base)
{
	ContactsContactEditorProperty * self;
	GtkWidget* _tmp0_;
	self = (ContactsContactEditorProperty*) base;
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	gtk_widget_unparent (_tmp0_);
	G_OBJECT_CLASS (contacts_contact_editor_property_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		ContactsContactEditorProperty* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->row);
		_g_object_unref0 (_data15_->chunk_child);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
__lambda23_ (Block15Data* _data15_,
             GObject* obj,
             GParamSpec* pspec)
{
	ContactsContactEditorProperty* self;
	ContactsTypeDescriptor* descr = NULL;
	ContactsTypeDescriptor* _tmp0_;
	ContactsTypeDescriptor* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* _tmp5_;
	self = _data15_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = contacts_typecombo_row_get_selected_descriptor (_data15_->row);
	_tmp1_ = _tmp0_;
	descr = _tmp1_;
	_tmp2_ = contacts_bin_chunk_child_get_parameters (_data15_->chunk_child);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_typedescriptor_adapt_parameters (descr, _tmp3_);
	_tmp5_ = _tmp4_;
	contacts_bin_chunk_child_set_parameters (_data15_->chunk_child, _tmp5_);
	_g_object_unref0 (_tmp5_);
}

static void
___lambda23__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda23_ (self, _sender, pspec);
}

void
contacts_contact_editor_property_add_type_combo (ContactsContactEditorProperty* self,
                                                 ContactsBinChunkChild* chunk_child,
                                                 ContactsTypeSet* combo_type)
{
	Block15Data* _data15_;
	ContactsBinChunkChild* _tmp0_;
	ContactsTypeComboRow* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (chunk_child != NULL);
	g_return_if_fail (combo_type != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (chunk_child);
	_g_object_unref0 (_data15_->chunk_child);
	_data15_->chunk_child = _tmp0_;
	_tmp1_ = contacts_typecombo_row_new (combo_type);
	g_object_ref_sink (_tmp1_);
	_data15_->row = _tmp1_;
	adw_preferences_row_set_title ((AdwPreferencesRow*) _data15_->row, _ ("Label"));
	_tmp2_ = contacts_bin_chunk_child_get_parameters (_data15_->chunk_child);
	_tmp3_ = _tmp2_;
	contacts_typecombo_row_set_selected_from_parameters (_data15_->row, _tmp3_);
	contacts_contact_editor_property_add (self, (GtkWidget*) _data15_->row);
	g_signal_connect_data ((GObject*) _data15_->row, "notify::selected-item", (GCallback) ___lambda23__g_object_notify, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

void
contacts_contact_editor_property_add (ContactsContactEditorProperty* self,
                                      GtkWidget* widget)
{
	AdwPreferencesGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->group;
	adw_preferences_group_add (_tmp0_, widget);
}

gboolean
contacts_contact_editor_property_get_reveal (ContactsContactEditorProperty* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_reveal;
	return result;
}

void
contacts_contact_editor_property_set_reveal (ContactsContactEditorProperty* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_editor_property_get_reveal (self);
	if (old_value != value) {
		self->priv->_reveal = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_editor_property_properties[CONTACTS_CONTACT_EDITOR_PROPERTY_REVEAL_PROPERTY]);
	}
}

static void
contacts_contact_editor_property_class_init (ContactsContactEditorPropertyClass * klass,
                                             gpointer klass_data)
{
	contacts_contact_editor_property_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactEditorProperty_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) contacts_contact_editor_property_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_editor_property_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_contact_editor_property_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_editor_property_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_EDITOR_PROPERTY_REVEAL_PROPERTY, contacts_contact_editor_property_properties[CONTACTS_CONTACT_EDITOR_PROPERTY_REVEAL_PROPERTY] = g_param_spec_boolean ("reveal", "reveal", "reveal", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_layout_manager_type (GTK_WIDGET_CLASS (klass), gtk_bin_layout_get_type ());
}

static void
contacts_contact_editor_property_instance_init (ContactsContactEditorProperty * self,
                                                gpointer klass)
{
	self->priv = contacts_contact_editor_property_get_instance_private (self);
	self->priv->_reveal = TRUE;
}

static void
contacts_contact_editor_property_finalize (GObject * obj)
{
	ContactsContactEditorProperty * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_EDITOR_PROPERTY, ContactsContactEditorProperty);
	G_OBJECT_CLASS (contacts_contact_editor_property_parent_class)->finalize (obj);
}

/**
 * Widget wrapper to show a single property of a contact (for example an email
 * address, a birthday, ...). It can show itself using a GtkRevealer animation.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_editor_property_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactEditorPropertyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_editor_property_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactEditorProperty), 0, (GInstanceInitFunc) contacts_contact_editor_property_instance_init, NULL };
	GType contacts_contact_editor_property_type_id;
	contacts_contact_editor_property_type_id = g_type_register_static (gtk_widget_get_type (), "ContactsContactEditorProperty", &g_define_type_info, 0);
	ContactsContactEditorProperty_private_offset = g_type_add_instance_private (contacts_contact_editor_property_type_id, sizeof (ContactsContactEditorPropertyPrivate));
	return contacts_contact_editor_property_type_id;
}

GType
contacts_contact_editor_property_get_type (void)
{
	static volatile gsize contacts_contact_editor_property_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_editor_property_type_id__once)) {
		GType contacts_contact_editor_property_type_id;
		contacts_contact_editor_property_type_id = contacts_contact_editor_property_get_type_once ();
		g_once_init_leave (&contacts_contact_editor_property_type_id__once, contacts_contact_editor_property_type_id);
	}
	return contacts_contact_editor_property_type_id__once;
}

static void
_vala_contacts_contact_editor_property_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	ContactsContactEditorProperty * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_EDITOR_PROPERTY, ContactsContactEditorProperty);
	switch (property_id) {
		case CONTACTS_CONTACT_EDITOR_PROPERTY_REVEAL_PROPERTY:
		g_value_set_boolean (value, contacts_contact_editor_property_get_reveal (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_contact_editor_property_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	ContactsContactEditorProperty * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_EDITOR_PROPERTY, ContactsContactEditorProperty);
	switch (property_id) {
		case CONTACTS_CONTACT_EDITOR_PROPERTY_REVEAL_PROPERTY:
		contacts_contact_editor_property_set_reveal (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_birthday_editor_get_instance_private (ContactsBirthdayEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsBirthdayEditor_private_offset);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
__lambda19_ (ContactsBirthdayEditor* self)
{
	contacts_birthday_editor_update_date (self);
}

static void
___lambda19__gtk_combo_box_changed (GtkComboBox* _sender,
                                    gpointer self)
{
	__lambda19_ ((ContactsBirthdayEditor*) self);
}

static void
__lambda20_ (ContactsBirthdayEditor* self)
{
	contacts_birthday_editor_update_date (self);
}

static void
___lambda20__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                            gpointer self)
{
	__lambda20_ ((ContactsBirthdayEditor*) self);
}

ContactsBirthdayEditor*
contacts_birthday_editor_construct (GType object_type,
                                    GtkWindow* window,
                                    GDateTime* birthday)
{
	ContactsBirthdayEditor * self = NULL;
	GDateTime* _tmp0_ = NULL;
	GDateTime* bday_local = NULL;
	GDateTime* _tmp3_;
	GtkSpinButton* _tmp4_;
	GtkComboBoxText* _tmp5_;
	GtkSpinButton* _tmp6_;
	GtkComboBoxText* _tmp7_;
	GtkSpinButton* _tmp8_;
	g_return_val_if_fail (window != NULL, NULL);
	self = (ContactsBirthdayEditor*) g_object_new (object_type, "transient-for", window, "use-header-bar", 1, "modal", TRUE, NULL);
	if (birthday != NULL) {
		GDateTime* _tmp1_;
		_tmp1_ = g_date_time_to_local (birthday);
		_g_date_time_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		GDateTime* _tmp2_;
		_tmp2_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _g_date_time_ref0 (_tmp0_);
	bday_local = _tmp3_;
	_tmp4_ = self->priv->day_spin;
	gtk_spin_button_set_value (_tmp4_, (gdouble) g_date_time_get_day_of_month (bday_local));
	_tmp5_ = self->priv->month_combo;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp5_, g_date_time_get_month (bday_local) - 1);
	_tmp6_ = self->priv->year_spin;
	gtk_spin_button_set_value (_tmp6_, (gdouble) g_date_time_get_year (bday_local));
	contacts_birthday_editor_update_date (self);
	_tmp7_ = self->priv->month_combo;
	g_signal_connect_object ((GtkComboBox*) _tmp7_, "changed", (GCallback) ___lambda19__gtk_combo_box_changed, self, 0);
	_tmp8_ = self->priv->year_spin;
	g_signal_connect_object (_tmp8_, "value-changed", (GCallback) ___lambda20__gtk_spin_button_value_changed, self, 0);
	_g_date_time_unref0 (bday_local);
	_g_date_time_unref0 (_tmp0_);
	return self;
}

ContactsBirthdayEditor*
contacts_birthday_editor_new (GtkWindow* window,
                              GDateTime* birthday)
{
	return contacts_birthday_editor_construct (CONTACTS_TYPE_BIRTHDAY_EDITOR, window, birthday);
}

/** Returns the selected birthday (in UTC timezone) */
GDateTime*
contacts_birthday_editor_get_birthday (ContactsBirthdayEditor* self)
{
	GtkSpinButton* _tmp0_;
	GtkComboBoxText* _tmp1_;
	GtkSpinButton* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->year_spin;
	_tmp1_ = self->priv->month_combo;
	_tmp2_ = self->priv->day_spin;
	_tmp3_ = g_date_time_new_local (gtk_spin_button_get_value_as_int (_tmp0_), gtk_combo_box_get_active ((GtkComboBox*) _tmp1_) + 1, gtk_spin_button_get_value_as_int (_tmp2_), 0, 0, (gdouble) 0);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_date_time_to_utc (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_date_time_unref0 (_tmp4_);
	result = _tmp6_;
	return result;
}

static gboolean
_vala_int_array_contains (gint * stack,
                          gssize stack_length,
                          const gint needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
contacts_birthday_editor_update_date (ContactsBirthdayEditor* self)
{
	static const gint month_of_31[4] = {3, 5, 8, 10};
	GtkComboBoxText* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->month_combo;
	if (_vala_int_array_contains (month_of_31, G_N_ELEMENTS (month_of_31), gtk_combo_box_get_active ((GtkComboBox*) _tmp0_))) {
		GtkSpinButton* _tmp1_;
		_tmp1_ = self->priv->day_spin;
		gtk_spin_button_set_range (_tmp1_, (gdouble) 1, (gdouble) 30);
	} else {
		GtkComboBoxText* _tmp2_;
		_tmp2_ = self->priv->month_combo;
		if (gtk_combo_box_get_active ((GtkComboBox*) _tmp2_) == 1) {
			gboolean _tmp3_ = FALSE;
			GtkSpinButton* _tmp4_;
			_tmp4_ = self->priv->year_spin;
			if ((gtk_spin_button_get_value_as_int (_tmp4_) % 400) == 0) {
				_tmp3_ = TRUE;
			} else {
				gboolean _tmp5_ = FALSE;
				GtkSpinButton* _tmp6_;
				_tmp6_ = self->priv->year_spin;
				if ((gtk_spin_button_get_value_as_int (_tmp6_) % 4) == 0) {
					GtkSpinButton* _tmp7_;
					_tmp7_ = self->priv->year_spin;
					_tmp5_ = (gtk_spin_button_get_value_as_int (_tmp7_) % 100) != 0;
				} else {
					_tmp5_ = FALSE;
				}
				_tmp3_ = _tmp5_;
			}
			if (_tmp3_) {
				GtkSpinButton* _tmp8_;
				_tmp8_ = self->priv->day_spin;
				gtk_spin_button_set_range (_tmp8_, (gdouble) 1, (gdouble) 29);
			} else {
				GtkSpinButton* _tmp9_;
				_tmp9_ = self->priv->day_spin;
				gtk_spin_button_set_range (_tmp9_, (gdouble) 1, (gdouble) 28);
			}
		} else {
			GtkSpinButton* _tmp10_;
			_tmp10_ = self->priv->day_spin;
			gtk_spin_button_set_range (_tmp10_, (gdouble) 1, (gdouble) 31);
		}
	}
}

gboolean
contacts_birthday_editor_get_is_set (ContactsBirthdayEditor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_set;
	return result;
}

void
contacts_birthday_editor_set_is_set (ContactsBirthdayEditor* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_birthday_editor_get_is_set (self);
	if (old_value != value) {
		self->priv->_is_set = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_birthday_editor_properties[CONTACTS_BIRTHDAY_EDITOR_IS_SET_PROPERTY]);
	}
}

static void
_contacts_birthday_editor___lambda21_ (ContactsBirthdayEditor* self,
                                       gint id)
{
	switch (id) {
		case GTK_RESPONSE_OK:
		{
			contacts_birthday_editor_set_is_set (self, TRUE);
			g_signal_emit (self, contacts_birthday_editor_signals[CONTACTS_BIRTHDAY_EDITOR_CHANGED_SIGNAL], 0);
			break;
		}
		case GTK_RESPONSE_CANCEL:
		{
			break;
		}
		default:
		break;
	}
	gtk_window_destroy ((GtkWindow*) self);
}

static void
__contacts_birthday_editor___lambda21__gtk_dialog_response (GtkDialog* _sender,
                                                            gint response_id,
                                                            gpointer self)
{
	_contacts_birthday_editor___lambda21_ ((ContactsBirthdayEditor*) self, response_id);
}

static GObject *
contacts_birthday_editor_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsBirthdayEditor * self;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkBox* _tmp4_;
	GtkGrid* _tmp5_;
	GtkSpinButton* d_spin = NULL;
	GtkSpinButton* _tmp6_;
	GtkSpinButton* _tmp7_;
	GtkSpinButton* _tmp8_;
	GtkSpinButton* _tmp9_;
	GtkComboBoxText* m_combo = NULL;
	GtkComboBoxText* _tmp10_;
	GDateTime* january = NULL;
	GDateTime* _tmp11_;
	GtkComboBoxText* _tmp20_;
	GtkComboBoxText* _tmp21_;
	GtkSpinButton* y_spin = NULL;
	GtkSpinButton* _tmp22_;
	GtkSpinButton* _tmp23_;
	GtkSpinButton* _tmp24_;
	GtkSpinButton* _tmp25_;
	GtkLabel* day = NULL;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkGrid* _tmp28_;
	GtkLabel* _tmp29_;
	GtkGrid* _tmp30_;
	GtkSpinButton* _tmp31_;
	GtkLabel* month = NULL;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkGrid* _tmp34_;
	GtkLabel* _tmp35_;
	GtkGrid* _tmp36_;
	GtkComboBoxText* _tmp37_;
	GtkLabel* year = NULL;
	GtkLabel* _tmp38_;
	GtkLabel* _tmp39_;
	GtkGrid* _tmp40_;
	GtkLabel* _tmp41_;
	GtkGrid* _tmp42_;
	GtkSpinButton* _tmp43_;
	GtkWidget* ok_button = NULL;
	GtkWidget* _tmp44_;
	GtkWidget* _tmp45_;
	GtkWidget* _tmp46_;
	parent_class = G_OBJECT_CLASS (contacts_birthday_editor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditor);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	_tmp1_ = grid;
	gtk_grid_set_column_spacing (_tmp1_, 12);
	_tmp2_ = grid;
	gtk_grid_set_row_spacing (_tmp2_, 12);
	_tmp3_ = grid;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, "contacts-editor-birthday");
	_tmp4_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp5_ = grid;
	gtk_box_append (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkSpinButton*) gtk_spin_button_new_with_range (1.0, 31.0, 1.0);
	g_object_ref_sink (_tmp6_);
	d_spin = _tmp6_;
	_tmp7_ = d_spin;
	gtk_spin_button_set_digits (_tmp7_, (guint) 0);
	_tmp8_ = d_spin;
	gtk_spin_button_set_numeric (_tmp8_, TRUE);
	_tmp9_ = d_spin;
	self->priv->day_spin = _tmp9_;
	_tmp10_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp10_);
	m_combo = _tmp10_;
	_tmp11_ = g_date_time_new_local (1, 1, 1, 1, 1, (gdouble) 1);
	january = _tmp11_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				GDateTime* month = NULL;
				GDateTime* _tmp14_;
				GDateTime* _tmp15_;
				GtkComboBoxText* _tmp16_;
				GDateTime* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(i < 12)) {
					break;
				}
				_tmp14_ = january;
				_tmp15_ = g_date_time_add_months (_tmp14_, i);
				month = _tmp15_;
				_tmp16_ = m_combo;
				_tmp17_ = month;
				_tmp18_ = g_date_time_format (_tmp17_, "%B");
				_tmp19_ = _tmp18_;
				gtk_combo_box_text_append_text (_tmp16_, _tmp19_);
				_g_free0 (_tmp19_);
				_g_date_time_unref0 (month);
			}
		}
	}
	_tmp20_ = m_combo;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp20_, TRUE);
	_tmp21_ = m_combo;
	self->priv->month_combo = _tmp21_;
	_tmp22_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1800, (gdouble) 3000, (gdouble) 1);
	g_object_ref_sink (_tmp22_);
	y_spin = _tmp22_;
	_tmp23_ = y_spin;
	gtk_spin_button_set_digits (_tmp23_, (guint) 0);
	_tmp24_ = y_spin;
	gtk_spin_button_set_numeric (_tmp24_, TRUE);
	_tmp25_ = y_spin;
	self->priv->year_spin = _tmp25_;
	_tmp26_ = (GtkLabel*) gtk_label_new (_ ("Day"));
	g_object_ref_sink (_tmp26_);
	day = _tmp26_;
	_tmp27_ = day;
	gtk_widget_set_halign ((GtkWidget*) _tmp27_, GTK_ALIGN_END);
	_tmp28_ = grid;
	_tmp29_ = day;
	gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 0, 0, 1, 1);
	_tmp30_ = grid;
	_tmp31_ = self->priv->day_spin;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 1, 0, 1, 1);
	_tmp32_ = (GtkLabel*) gtk_label_new (_ ("Month"));
	g_object_ref_sink (_tmp32_);
	month = _tmp32_;
	_tmp33_ = month;
	gtk_widget_set_halign ((GtkWidget*) _tmp33_, GTK_ALIGN_END);
	_tmp34_ = grid;
	_tmp35_ = month;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 0, 1, 1, 1);
	_tmp36_ = grid;
	_tmp37_ = self->priv->month_combo;
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 1, 1, 1, 1);
	_tmp38_ = (GtkLabel*) gtk_label_new (_ ("Year"));
	g_object_ref_sink (_tmp38_);
	year = _tmp38_;
	_tmp39_ = year;
	gtk_widget_set_halign ((GtkWidget*) _tmp39_, GTK_ALIGN_END);
	_tmp40_ = grid;
	_tmp41_ = year;
	gtk_grid_attach (_tmp40_, (GtkWidget*) _tmp41_, 0, 2, 1, 1);
	_tmp42_ = grid;
	_tmp43_ = self->priv->year_spin;
	gtk_grid_attach (_tmp42_, (GtkWidget*) _tmp43_, 1, 2, 1, 1);
	gtk_window_set_title ((GtkWindow*) self, _ ("Change Birthday"));
	gtk_dialog_add_buttons ((GtkDialog*) self, _ ("Set"), GTK_RESPONSE_OK, _ ("Cancel"), GTK_RESPONSE_CANCEL, NULL, NULL);
	_tmp44_ = gtk_dialog_get_widget_for_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
	_tmp45_ = _g_object_ref0 (_tmp44_);
	ok_button = _tmp45_;
	_tmp46_ = ok_button;
	gtk_widget_add_css_class (_tmp46_, "suggested-action");
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __contacts_birthday_editor___lambda21__gtk_dialog_response, self, 0);
	_g_object_unref0 (ok_button);
	_g_object_unref0 (year);
	_g_object_unref0 (month);
	_g_object_unref0 (day);
	_g_object_unref0 (y_spin);
	_g_date_time_unref0 (january);
	_g_object_unref0 (m_combo);
	_g_object_unref0 (d_spin);
	_g_object_unref0 (grid);
	return obj;
}

static void
contacts_birthday_editor_class_init (ContactsBirthdayEditorClass * klass,
                                     gpointer klass_data)
{
	contacts_birthday_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsBirthdayEditor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_birthday_editor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_birthday_editor_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_birthday_editor_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_birthday_editor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIRTHDAY_EDITOR_IS_SET_PROPERTY, contacts_birthday_editor_properties[CONTACTS_BIRTHDAY_EDITOR_IS_SET_PROPERTY] = g_param_spec_boolean ("is-set", "is-set", "is-set", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	contacts_birthday_editor_signals[CONTACTS_BIRTHDAY_EDITOR_CHANGED_SIGNAL] = g_signal_new ("changed", CONTACTS_TYPE_BIRTHDAY_EDITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
contacts_birthday_editor_instance_init (ContactsBirthdayEditor * self,
                                        gpointer klass)
{
	self->priv = contacts_birthday_editor_get_instance_private (self);
	self->priv->_is_set = FALSE;
}

static void
contacts_birthday_editor_finalize (GObject * obj)
{
	ContactsBirthdayEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditor);
	G_OBJECT_CLASS (contacts_birthday_editor_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_birthday_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsBirthdayEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_birthday_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsBirthdayEditor), 0, (GInstanceInitFunc) contacts_birthday_editor_instance_init, NULL };
	GType contacts_birthday_editor_type_id;
	contacts_birthday_editor_type_id = g_type_register_static (gtk_dialog_get_type (), "ContactsBirthdayEditor", &g_define_type_info, 0);
	ContactsBirthdayEditor_private_offset = g_type_add_instance_private (contacts_birthday_editor_type_id, sizeof (ContactsBirthdayEditorPrivate));
	return contacts_birthday_editor_type_id;
}

GType
contacts_birthday_editor_get_type (void)
{
	static volatile gsize contacts_birthday_editor_type_id__once = 0;
	if (g_once_init_enter (&contacts_birthday_editor_type_id__once)) {
		GType contacts_birthday_editor_type_id;
		contacts_birthday_editor_type_id = contacts_birthday_editor_get_type_once ();
		g_once_init_leave (&contacts_birthday_editor_type_id__once, contacts_birthday_editor_type_id);
	}
	return contacts_birthday_editor_type_id__once;
}

static void
_vala_contacts_birthday_editor_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ContactsBirthdayEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditor);
	switch (property_id) {
		case CONTACTS_BIRTHDAY_EDITOR_IS_SET_PROPERTY:
		g_value_set_boolean (value, contacts_birthday_editor_get_is_set (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_birthday_editor_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	ContactsBirthdayEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditor);
	switch (property_id) {
		case CONTACTS_BIRTHDAY_EDITOR_IS_SET_PROPERTY:
		contacts_birthday_editor_set_is_set (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

ContactsAddressEditor*
contacts_address_editor_construct (GType object_type,
                                   ContactsAddress* address)
{
	ContactsAddressEditor * self = NULL;
	g_return_val_if_fail (address != NULL, NULL);
	self = (ContactsAddressEditor*) g_object_new (object_type, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkEntry* entry = NULL;
				GtkEntry* _tmp2_;
				GtkEntry* _tmp3_;
				GtkEntry* _tmp4_;
				gchar** _tmp5_;
				gint _tmp5__length1;
				const gchar* _tmp6_;
				GtkEntry* _tmp7_;
				const gchar* prop_name = NULL;
				const gchar* _tmp8_;
				FolksPostalAddress* _tmp9_;
				FolksPostalAddress* _tmp10_;
				const gchar* _tmp11_;
				GtkEntry* _tmp12_;
				GtkEntry* _tmp13_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < G_N_ELEMENTS (CONTACTS_ADDRESS_EDITOR_postal_element_props))) {
					break;
				}
				_tmp2_ = (GtkEntry*) gtk_entry_new ();
				g_object_ref_sink (_tmp2_);
				entry = _tmp2_;
				_tmp3_ = entry;
				gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
				_tmp4_ = entry;
				_tmp5_ = contacts_address_editor_postal_element_names;
				_tmp5__length1 = contacts_address_editor_postal_element_names_length1;
				_tmp6_ = _tmp5_[i];
				gtk_entry_set_placeholder_text (_tmp4_, _tmp6_);
				_tmp7_ = entry;
				gtk_widget_add_css_class ((GtkWidget*) _tmp7_, "flat");
				_tmp8_ = CONTACTS_ADDRESS_EDITOR_postal_element_props[i];
				prop_name = _tmp8_;
				_tmp9_ = contacts_address_get_address (address);
				_tmp10_ = _tmp9_;
				_tmp11_ = prop_name;
				_tmp12_ = entry;
				g_object_bind_property_with_closures ((GObject*) _tmp10_, _tmp11_, (GObject*) _tmp12_, "text", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
				_tmp13_ = entry;
				gtk_widget_set_parent ((GtkWidget*) _tmp13_, (GtkWidget*) self);
				_g_object_unref0 (entry);
			}
		}
	}
	return self;
}

ContactsAddressEditor*
contacts_address_editor_new (ContactsAddress* address)
{
	return contacts_address_editor_construct (CONTACTS_TYPE_ADDRESS_EDITOR, address);
}

static void
contacts_address_editor_real_dispose (GObject* base)
{
	ContactsAddressEditor * self;
	GtkWidget* child = NULL;
	self = (ContactsAddressEditor*) base;
	child = NULL;
	while (TRUE) {
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
		child = _tmp0_;
		_tmp1_ = child;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = child;
		gtk_widget_unparent (_tmp2_);
	}
	G_OBJECT_CLASS (contacts_address_editor_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static GObject *
contacts_address_editor_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsAddressEditor * self;
	GtkBoxLayout* box_layout = NULL;
	GtkBoxLayout* _tmp0_;
	GtkBoxLayout* _tmp1_;
	GtkLayoutManager* _tmp2_;
	parent_class = G_OBJECT_CLASS (contacts_address_editor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_ADDRESS_EDITOR, ContactsAddressEditor);
	_tmp0_ = (GtkBoxLayout*) gtk_box_layout_new (GTK_ORIENTATION_VERTICAL);
	box_layout = _tmp0_;
	_tmp1_ = box_layout;
	_tmp2_ = _g_object_ref0 ((GtkLayoutManager*) _tmp1_);
	gtk_widget_set_layout_manager ((GtkWidget*) self, _tmp2_);
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-editor-address");
	_g_object_unref0 (box_layout);
	return obj;
}

static void
contacts_address_editor_class_init (ContactsAddressEditorClass * klass,
                                    gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	contacts_address_editor_parent_class = g_type_class_peek_parent (klass);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) contacts_address_editor_real_dispose;
	G_OBJECT_CLASS (klass)->constructor = contacts_address_editor_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_address_editor_finalize;
	contacts_address_editor_signals[CONTACTS_ADDRESS_EDITOR_CHANGED_SIGNAL] = g_signal_new ("changed", CONTACTS_TYPE_ADDRESS_EDITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_strdup (_ ("Street"));
	_tmp1_ = g_strdup (_ ("Extension"));
	_tmp2_ = g_strdup (_ ("City"));
	_tmp3_ = g_strdup (_ ("State/Province"));
	_tmp4_ = g_strdup (_ ("Zip/Postal Code"));
	_tmp5_ = g_strdup (_ ("PO box"));
	_tmp6_ = g_strdup (_ ("Country"));
	_tmp7_ = g_new0 (gchar*, 7 + 1);
	_tmp7_[0] = _tmp0_;
	_tmp7_[1] = _tmp1_;
	_tmp7_[2] = _tmp2_;
	_tmp7_[3] = _tmp3_;
	_tmp7_[4] = _tmp4_;
	_tmp7_[5] = _tmp5_;
	_tmp7_[6] = _tmp6_;
	contacts_address_editor_postal_element_names = _tmp7_;
	contacts_address_editor_postal_element_names_length1 = 7;
}

static void
contacts_address_editor_instance_init (ContactsAddressEditor * self,
                                       gpointer klass)
{
}

static void
contacts_address_editor_finalize (GObject * obj)
{
	ContactsAddressEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_ADDRESS_EDITOR, ContactsAddressEditor);
	G_OBJECT_CLASS (contacts_address_editor_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_address_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsAddressEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_address_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAddressEditor), 0, (GInstanceInitFunc) contacts_address_editor_instance_init, NULL };
	GType contacts_address_editor_type_id;
	contacts_address_editor_type_id = g_type_register_static (gtk_widget_get_type (), "ContactsAddressEditor", &g_define_type_info, 0);
	return contacts_address_editor_type_id;
}

GType
contacts_address_editor_get_type (void)
{
	static volatile gsize contacts_address_editor_type_id__once = 0;
	if (g_once_init_enter (&contacts_address_editor_type_id__once)) {
		GType contacts_address_editor_type_id;
		contacts_address_editor_type_id = contacts_address_editor_get_type_once ();
		g_once_init_leave (&contacts_address_editor_type_id__once, contacts_address_editor_type_id);
	}
	return contacts_address_editor_type_id__once;
}

