/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.javascript;

import java.util.ArrayList;
import java.util.Collection;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleInstancePropertyProvider;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectPropertyProvider;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptNodes;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptType;
import org.graalvm.visualvm.heapviewer.utils.HeapOperations;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;

final class JavaScriptObjectProperties {
    JavaScriptObjectProperties() {
    }

    public static class ReferencesProvider
    extends TruffleObjectPropertyProvider.References<JavaScriptObject, JavaScriptType, JavaScriptHeapFragment, JavaScriptLanguage> {
        public ReferencesProvider() {
            super(Bundle.JavaScriptObjectProperties_References(), JavaScriptLanguage.instance(), false);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("javascript_") && !viewID.endsWith("_fields");
        }

        @Override
        public boolean supportsNode(HeapViewerNode node, Heap heap, String viewID) {
            return node instanceof JavaScriptNodes.JavaScriptNode && !(node instanceof JavaScriptNodes.JavaScriptObjectFieldNode) && !(node instanceof JavaScriptNodes.JavaScriptObjectArrayItemNode);
        }

        @Override
        protected HeapViewerNode createObjectReferenceNode(JavaScriptObject object, String type, FieldValue field) {
            return new JavaScriptNodes.JavaScriptObjectReferenceNode(object, type, field);
        }

        @Override
        protected Collection<FieldValue> getPropertyItems(JavaScriptObject object, Heap heap) throws InterruptedException {
            HeapOperations.initializeReferences((Heap)heap);
            return object.getReferences();
        }
    }

    public static class ArrayItemsProvider
    extends TruffleInstancePropertyProvider.ArrayItems<JavaScriptObject, JavaScriptType, JavaScriptHeapFragment, JavaScriptLanguage> {
        public ArrayItemsProvider() {
            super(Bundle.JavaScriptObjectProperties_Items(), JavaScriptLanguage.instance(), false);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("javascript_");
        }

        @Override
        protected HeapViewerNode createObjectArrayItemNode(JavaScriptObject object, String type, ArrayItemValue item) {
            return new JavaScriptNodes.JavaScriptObjectArrayItemNode(object, type, item);
        }
    }

    public static class FieldsProvider
    extends TruffleObjectPropertyProvider.Fields<JavaScriptObject, JavaScriptType, JavaScriptHeapFragment, JavaScriptLanguage> {
        public FieldsProvider() {
            super(Bundle.JavaScriptObjectProperties_Properties(), JavaScriptLanguage.instance(), true);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("javascript_") && !viewID.endsWith("_references");
        }

        @Override
        public boolean supportsNode(HeapViewerNode node, Heap heap, String viewID) {
            return node instanceof JavaScriptNodes.JavaScriptNode && !(node instanceof JavaScriptNodes.JavaScriptObjectReferenceNode);
        }

        @Override
        protected HeapViewerNode createObjectFieldNode(JavaScriptObject object, String type, FieldValue field) {
            return new JavaScriptNodes.JavaScriptObjectFieldNode(object, type, field);
        }

        @Override
        protected Collection<FieldValue> getPropertyItems(JavaScriptObject object, Heap heap) {
            ArrayList<FieldValue> fields = new ArrayList<FieldValue>();
            fields.addAll(object.getFieldValues());
            fields.addAll(object.getStaticFieldValues());
            return fields;
        }

        @Override
        protected boolean includeInstance(Instance instance) {
            String className = instance.getJavaClass().getName();
            return className.startsWith("java.lang.") || className.startsWith("java.math.") || className.startsWith("com.oracle.truffle.js.runtime.objects.") || className.startsWith("com.oracle.truffle.api.object.DynamicObject[]") || className.startsWith("com.oracle.truffle.api.strings.");
        }
    }
}

