/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvm;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.core.model.AbstractModelProvider;
import org.graalvm.visualvm.jvm.JVMImpl;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.graalvm.visualvm.tools.jmx.JvmMXBeans;
import org.graalvm.visualvm.tools.jmx.JvmMXBeansFactory;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModelFactory;

class JvmProvider
extends AbstractModelProvider<Jvm, Application> {
    JvmProvider() {
    }

    public Jvm createModelFor(Application app) {
        JvmstatModel jvmstat = JvmstatModelFactory.getJvmstatFor((Application)app);
        JVMImpl jvm = null;
        if (jvmstat != null) {
            jvm = new JVMImpl(app, jvmstat);
        } else {
            JvmMXBeans jmx;
            JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)app);
            if (jmxModel != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED && (jmx = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel)) != null && jmx.getRuntimeMXBean() != null) {
                jvm = new JVMImpl(app);
            }
        }
        return jvm;
    }
}

