/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.contracts.description;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.FirLegacyRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import org.jetbrains.kotlin.fir.contracts.description.ConeBinaryLogicExpression;
import org.jetbrains.kotlin.fir.contracts.description.ConeCallsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeConditionalEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeConstantReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractDescriptionElement;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractDescriptionVisitor;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsInstancePredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsNullPredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeLogicalNot;
import org.jetbrains.kotlin.fir.contracts.description.ConeReturnsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeValueParameterReference;
import org.jetbrains.kotlin.fir.contracts.impl.FirEmptyContractDescription;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.renderer.FirPrinter;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.fir.renderer.FirRendererComponents;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u000e\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 J\u0015\u0010\u001c\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u0015\u0010\u001c\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b#J\u0015\u0010\u001c\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b#J\u000e\u0010\u001c\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)J\u001a\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u0002002\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u0002032\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u0002062\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u0002092\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020<2\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020?2\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020B2\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020E2\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\f\u0010F\u001a\u00020\u001b*\u00020\u0016H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00060\u0010R\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractRenderer;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionVisitor;", "", "", "()V", "components", "Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "getComponents$tree", "()Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "setComponents$tree", "(Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;)V", "printer", "Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "getPrinter", "()Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "visitor", "Lorg/jetbrains/kotlin/fir/renderer/FirRenderer$Visitor;", "Lorg/jetbrains/kotlin/fir/renderer/FirRenderer;", "getVisitor", "()Lorg/jetbrains/kotlin/fir/renderer/FirRenderer$Visitor;", "inBracketsIfNecessary", "parent", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "child", "block", "Lkotlin/Function0;", "needsBrackets", "", "render", "contractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "effectDeclaration", "Lorg/jetbrains/kotlin/fir/contracts/FirEffectDeclaration;", "legacyRawContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirLegacyRawContractDescription;", "render$tree", "rawContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirRawContractDescription;", "resolvedContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "visitCallsEffectDeclaration", "callsEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeCallsEffectDeclaration;", "data", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConditionalEffectDeclaration;", "visitConstantDescriptor", "constantReference", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConstantReference;", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsNullPredicate;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeLogicalNot;", "visitReturnsEffectDeclaration", "returnsEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeReturnsEffectDeclaration;", "visitValueParameterReference", "valueParameterReference", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeValueParameterReference;", "isAtom", "tree"})
public final class ConeContractRenderer
extends ConeContractDescriptionVisitor {
    public FirRendererComponents components;

    @NotNull
    public final FirRendererComponents getComponents$tree() {
        FirRendererComponents firRendererComponents = this.components;
        if (firRendererComponents != null) {
            return firRendererComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException("components");
        return null;
    }

    public final void setComponents$tree(@NotNull FirRendererComponents firRendererComponents) {
        Intrinsics.checkNotNullParameter(firRendererComponents, "<set-?>");
        this.components = firRendererComponents;
    }

    private final FirPrinter getPrinter() {
        return this.getComponents$tree().getPrinter();
    }

    private final FirRenderer.Visitor getVisitor() {
        return this.getComponents$tree().getVisitor();
    }

    public final void render(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirElement firElement = declaration instanceof FirContractDescriptionOwner ? (FirContractDescriptionOwner)((Object)declaration) : null;
        if (firElement == null || (firElement = firElement.getContractDescription()) == null) {
            return;
        }
        FirElement contractDescription = firElement;
        this.render((FirContractDescription)contractDescription);
    }

    public final void render(@NotNull FirContractDescription contractDescription) {
        FirContractDescription firContractDescription;
        Intrinsics.checkNotNullParameter(contractDescription, "contractDescription");
        this.getPrinter().pushIndent$tree();
        if (!(contractDescription instanceof FirEmptyContractDescription)) {
            this.getPrinter().newLine();
            String prefix = contractDescription instanceof FirResolvedContractDescription ? "R|" : "";
            Object[] objectArray = new Object[]{'[' + prefix + "Contract description]"};
            this.getPrinter().print(objectArray);
        }
        if ((firContractDescription = contractDescription) instanceof FirLegacyRawContractDescription) {
            this.render$tree((FirLegacyRawContractDescription)contractDescription);
        } else if (firContractDescription instanceof FirRawContractDescription) {
            this.render$tree((FirRawContractDescription)contractDescription);
        } else if (firContractDescription instanceof FirResolvedContractDescription) {
            this.getPrinter().println(new Object[0]);
            this.render$tree((FirResolvedContractDescription)contractDescription);
        }
        this.getPrinter().popIndent$tree();
    }

    public final void render(@NotNull FirEffectDeclaration effectDeclaration) {
        Intrinsics.checkNotNullParameter(effectDeclaration, "effectDeclaration");
        this.getPrinter().newLine();
        Object[] objectArray = new Object[]{"[Effect declaration] <"};
        this.getPrinter().println(objectArray);
        effectDeclaration.getEffect().accept(this, null);
        this.getPrinter().println(new Object[0]);
        objectArray = new Object[]{">"};
        this.getPrinter().println(objectArray);
    }

    public final void render$tree(@NotNull FirLegacyRawContractDescription legacyRawContractDescription) {
        Intrinsics.checkNotNullParameter(legacyRawContractDescription, "legacyRawContractDescription");
        this.getPrinter().renderInBraces("<", ">", new Function0<Unit>(legacyRawContractDescription, this){
            final /* synthetic */ FirLegacyRawContractDescription $legacyRawContractDescription;
            final /* synthetic */ ConeContractRenderer this$0;
            {
                this.$legacyRawContractDescription = $legacyRawContractDescription;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$legacyRawContractDescription.getContractCall().accept(ConeContractRenderer.access$getVisitor(this.this$0));
                ConeContractRenderer.access$getPrinter(this.this$0).newLine();
            }
        });
    }

    public final void render$tree(@NotNull FirRawContractDescription rawContractDescription) {
        Intrinsics.checkNotNullParameter(rawContractDescription, "rawContractDescription");
        this.getPrinter().renderInBraces("<", ">", new Function0<Unit>(this, rawContractDescription){
            final /* synthetic */ ConeContractRenderer this$0;
            final /* synthetic */ FirRawContractDescription $rawContractDescription;
            {
                this.this$0 = $receiver;
                this.$rawContractDescription = $rawContractDescription;
                super(0);
            }

            public final void invoke() {
                ConeContractRenderer.access$getPrinter(this.this$0).renderSeparatedWithNewlines$tree(this.$rawContractDescription.getRawEffects(), ConeContractRenderer.access$getVisitor(this.this$0));
                ConeContractRenderer.access$getPrinter(this.this$0).newLine();
            }
        });
    }

    public final void render$tree(@NotNull FirResolvedContractDescription resolvedContractDescription) {
        Intrinsics.checkNotNullParameter(resolvedContractDescription, "resolvedContractDescription");
        Object[] objectArray = new Object[]{" <"};
        this.getPrinter().println(objectArray);
        this.getPrinter().pushIndent$tree();
        Iterable $this$forEach$iv = resolvedContractDescription.getEffects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirEffectDeclaration declaration = (FirEffectDeclaration)element$iv;
            boolean bl = false;
            declaration.getEffect().accept(this, null);
            this.getPrinter().println(new Object[0]);
        }
        this.getPrinter().popIndent$tree();
        objectArray = new Object[]{">"};
        this.getPrinter().println(objectArray);
    }

    public void visitConditionalEffectDeclaration(@NotNull ConeConditionalEffectDeclaration conditionalEffect, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(conditionalEffect, "conditionalEffect");
        conditionalEffect.getEffect().accept(this, data);
        Object[] objectArray = new Object[]{" -> "};
        this.getPrinter().print(objectArray);
        conditionalEffect.getCondition().accept(this, data);
    }

    public void visitReturnsEffectDeclaration(@NotNull ConeReturnsEffectDeclaration returnsEffect, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(returnsEffect, "returnsEffect");
        Object[] objectArray = new Object[]{"Returns("};
        this.getPrinter().print(objectArray);
        returnsEffect.getValue().accept(this, data);
        objectArray = new Object[]{")"};
        this.getPrinter().print(objectArray);
    }

    public void visitCallsEffectDeclaration(@NotNull ConeCallsEffectDeclaration callsEffect, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(callsEffect, "callsEffect");
        Object[] objectArray = new Object[]{"CallsInPlace("};
        this.getPrinter().print(objectArray);
        callsEffect.getValueParameterReference().accept(this, data);
        objectArray = new Object[]{", " + (Object)((Object)callsEffect.getKind()) + ')'};
        this.getPrinter().print(objectArray);
    }

    public void visitLogicalBinaryOperationContractExpression(@NotNull ConeBinaryLogicExpression binaryLogicExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(binaryLogicExpression, "binaryLogicExpression");
        this.inBracketsIfNecessary(binaryLogicExpression, binaryLogicExpression.getLeft(), new Function0<Unit>(binaryLogicExpression, this, data){
            final /* synthetic */ ConeBinaryLogicExpression $binaryLogicExpression;
            final /* synthetic */ ConeContractRenderer this$0;
            final /* synthetic */ Void $data;
            {
                this.$binaryLogicExpression = $binaryLogicExpression;
                this.this$0 = $receiver;
                this.$data = $data;
                super(0);
            }

            public final void invoke() {
                this.$binaryLogicExpression.getLeft().accept(this.this$0, this.$data);
            }
        });
        Object[] objectArray = new Object[]{' ' + binaryLogicExpression.getKind().getToken() + ' '};
        this.getPrinter().print(objectArray);
        this.inBracketsIfNecessary(binaryLogicExpression, binaryLogicExpression.getRight(), new Function0<Unit>(binaryLogicExpression, this, data){
            final /* synthetic */ ConeBinaryLogicExpression $binaryLogicExpression;
            final /* synthetic */ ConeContractRenderer this$0;
            final /* synthetic */ Void $data;
            {
                this.$binaryLogicExpression = $binaryLogicExpression;
                this.this$0 = $receiver;
                this.$data = $data;
                super(0);
            }

            public final void invoke() {
                this.$binaryLogicExpression.getRight().accept(this.this$0, this.$data);
            }
        });
    }

    public void visitLogicalNot(@NotNull ConeLogicalNot logicalNot, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(logicalNot, "logicalNot");
        this.inBracketsIfNecessary(logicalNot, logicalNot.getArg(), new Function0<Unit>(this){
            final /* synthetic */ ConeContractRenderer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Object[] objectArray = new Object[]{"!"};
                ConeContractRenderer.access$getPrinter(this.this$0).print(objectArray);
            }
        });
        logicalNot.getArg().accept(this, data);
    }

    public void visitIsInstancePredicate(@NotNull ConeIsInstancePredicate isInstancePredicate, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(isInstancePredicate, "isInstancePredicate");
        isInstancePredicate.getArg().accept(this, data);
        Object[] objectArray = new Object[]{' ' + (isInstancePredicate.isNegated() ? "!" : "") + "is " + ConeTypeUtilsKt.renderForDebugging(isInstancePredicate.getType())};
        this.getPrinter().print(objectArray);
    }

    public void visitIsNullPredicate(@NotNull ConeIsNullPredicate isNullPredicate, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(isNullPredicate, "isNullPredicate");
        isNullPredicate.getArg().accept(this, data);
        Object[] objectArray = new Object[]{' ' + (isNullPredicate.isNegated() ? "!=" : "==") + " null"};
        this.getPrinter().print(objectArray);
    }

    public void visitConstantDescriptor(@NotNull ConeConstantReference constantReference, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(constantReference, "constantReference");
        Object[] objectArray = new Object[]{constantReference.getName()};
        this.getPrinter().print(objectArray);
    }

    public void visitValueParameterReference(@NotNull ConeValueParameterReference valueParameterReference, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(valueParameterReference, "valueParameterReference");
        Object[] objectArray = new Object[]{valueParameterReference.getName()};
        this.getPrinter().print(objectArray);
    }

    private final void inBracketsIfNecessary(ConeContractDescriptionElement parent2, ConeContractDescriptionElement child, Function0<Unit> block) {
        if (this.needsBrackets(parent2, child)) {
            Object[] objectArray = new Object[]{"("};
            this.getPrinter().print(objectArray);
            block.invoke();
            objectArray = new Object[]{")"};
            this.getPrinter().print(objectArray);
        } else {
            block.invoke();
        }
    }

    private final boolean isAtom(ConeContractDescriptionElement $this$isAtom) {
        return $this$isAtom instanceof ConeValueParameterReference || $this$isAtom instanceof ConeConstantReference || $this$isAtom instanceof ConeIsNullPredicate || $this$isAtom instanceof ConeIsInstancePredicate;
    }

    private final boolean needsBrackets(ConeContractDescriptionElement parent2, ConeContractDescriptionElement child) {
        if (this.isAtom(child)) {
            return false;
        }
        if (parent2 instanceof ConeLogicalNot) {
            return true;
        }
        return parent2.getClass() != child.getClass();
    }

    public static final /* synthetic */ FirRenderer.Visitor access$getVisitor(ConeContractRenderer $this) {
        return $this.getVisitor();
    }

    public static final /* synthetic */ FirPrinter access$getPrinter(ConeContractRenderer $this) {
        return $this.getPrinter();
    }
}

