/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializerKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirJvmConstDeserializer;", "Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "binaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;)V", "loadConstant", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "propertyProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "fir-deserialization"})
public final class FirJvmConstDeserializer
extends FirConstDeserializer {
    @NotNull
    private final KotlinJvmBinaryClass binaryClass;

    public FirJvmConstDeserializer(@NotNull FirSession session2, @NotNull KotlinJvmBinaryClass binaryClass) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(binaryClass, "binaryClass");
        super(session2);
        this.binaryClass = binaryClass;
    }

    @Override
    @Nullable
    public FirExpression loadConstant(@NotNull ProtoBuf.Property propertyProto, @NotNull CallableId callableId, @NotNull NameResolver nameResolver2) {
        Intrinsics.checkNotNullParameter(propertyProto, "propertyProto");
        Intrinsics.checkNotNullParameter(callableId, "callableId");
        Intrinsics.checkNotNullParameter(nameResolver2, "nameResolver");
        if (!Flags.HAS_CONSTANT.get(propertyProto.getFlags()).booleanValue()) {
            return null;
        }
        FirExpression firExpression2 = this.getConstantCache().get(callableId);
        if (firExpression2 != null) {
            FirExpression it = firExpression2;
            boolean bl = false;
            return it;
        }
        this.binaryClass.visitMembers(new KotlinJvmBinaryClass.MemberVisitor(nameResolver2, this, callableId){
            final /* synthetic */ NameResolver $nameResolver;
            final /* synthetic */ FirJvmConstDeserializer this$0;
            final /* synthetic */ CallableId $callableId;
            {
                this.$nameResolver = $nameResolver;
                this.this$0 = $receiver;
                this.$callableId = $callableId;
            }

            @Nullable
            public KotlinJvmBinaryClass.MethodAnnotationVisitor visitMethod(@NotNull Name name, @NotNull String desc) {
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(desc, "desc");
                return null;
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationVisitor visitField(@NotNull Name name, @NotNull String desc, @Nullable Object initializer2) {
                block1: {
                    FirExpression constant;
                    Intrinsics.checkNotNullParameter(name, "name");
                    Intrinsics.checkNotNullParameter(desc, "desc");
                    if (initializer2 == null) break block1;
                    FirExpression firExpression2 = constant = FirConstDeserializerKt.buildFirConstant(null, initializer2, desc, this.$nameResolver);
                    if (firExpression2 != null) {
                        FirExpression firExpression3 = firExpression2;
                        FirJvmConstDeserializer firJvmConstDeserializer = this.this$0;
                        CallableId callableId = this.$callableId;
                        FirExpression it = firExpression3;
                        boolean bl = false;
                        firJvmConstDeserializer.getConstantCache().put(FirConstDeserializerKt.replaceName(callableId, name), it);
                    }
                }
                return null;
            }
        }, null);
        return this.getConstantCache().get(callableId);
    }
}

