import { Index } from './IndexType';
import { PackageFileRepository } from './PackageFileRepository';
import { VersionSpec } from './VersionSpec';
/** The relevant bits of a parsed package.json file. */
export interface PackageFile {
    dependencies?: Index<VersionSpec>;
    devDependencies?: Index<VersionSpec>;
    engines?: Index<VersionSpec>;
    name?: string;
    packageManager?: string;
    optionalDependencies?: Index<VersionSpec>;
    peerDependencies?: Index<VersionSpec>;
    repository?: string | PackageFileRepository;
    scripts?: Index<string>;
    workspaces?: string[] | {
        packages: string[];
    };
}
