/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.configs;

import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;

public class FieldDataCacheRcaConfig {
    public static final String CONFIG_NAME = "field-data-cache-rca-config";
    private Double fieldDataCacheSizeThreshold;
    private Integer fieldDataCollectorTimePeriodInSec;
    public static final double DEFAULT_FIELD_DATA_CACHE_SIZE_THRESHOLD = 0.8;
    public static final int DEFAULT_FIELD_DATA_COLLECTOR_TIME_PERIOD_IN_SEC = 300;

    public FieldDataCacheRcaConfig(RcaConf rcaConf) {
        this.fieldDataCacheSizeThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "field-data-cache-size-threshold", 0.8, s -> s > 0.0, Double.class);
        this.fieldDataCollectorTimePeriodInSec = rcaConf.readRcaConfig(CONFIG_NAME, "field-data-collector-time-period-in-sec", 300, s -> s > 0, Integer.class);
    }

    public double getFieldDataCacheSizeThreshold() {
        return this.fieldDataCacheSizeThreshold;
    }

    public int getFieldDataCollectorTimePeriodInSec() {
        return this.fieldDataCollectorTimePeriodInSec;
    }

    public static class RCA_CONF_KEY_CONSTANTS {
        public static final String FIELD_DATA_CACHE_SIZE_THRESHOLD = "field-data-cache-size-threshold";
        public static final String FIELD_DATA_COLLECTOR_TIME_PERIOD_IN_SEC = "field-data-collector-time-period-in-sec";
    }
}

