/* contacts-contact-list.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-contact-list.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "contacts.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <gdk/gdk.h>

#define CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_LIST_AVATAR_SIZE 48
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_CONTACT_LIST (contacts_contact_list_get_type ())
#define CONTACTS_CONTACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_LIST, ContactsContactList))
#define CONTACTS_CONTACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_LIST, ContactsContactListClass))
#define CONTACTS_IS_CONTACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_LIST))
#define CONTACTS_IS_CONTACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_LIST))
#define CONTACTS_CONTACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_LIST, ContactsContactListClass))

typedef struct _ContactsContactList ContactsContactList;
typedef struct _ContactsContactListClass ContactsContactListClass;
typedef struct _ContactsContactListPrivate ContactsContactListPrivate;
typedef enum  {
	CONTACTS_UI_STATE_NORMAL,
	CONTACTS_UI_STATE_SHOWING,
	CONTACTS_UI_STATE_SELECTING,
	CONTACTS_UI_STATE_UPDATING,
	CONTACTS_UI_STATE_CREATING
} ContactsUiState;

#define CONTACTS_TYPE_UI_STATE (contacts_ui_state_get_type ())
enum  {
	CONTACTS_CONTACT_LIST_0_PROPERTY,
	CONTACTS_CONTACT_LIST_STORE_PROPERTY,
	CONTACTS_CONTACT_LIST_MARKED_CONTACTS_PROPERTY,
	CONTACTS_CONTACT_LIST_STATE_PROPERTY,
	CONTACTS_CONTACT_LIST_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_list_properties[CONTACTS_CONTACT_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW (contacts_contact_list_contact_data_row_get_type ())
#define CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow))
#define CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRowClass))
#define CONTACTS_CONTACT_LIST_IS_CONTACT_DATA_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW))
#define CONTACTS_CONTACT_LIST_IS_CONTACT_DATA_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW))
#define CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRowClass))

typedef struct _ContactsContactListContactDataRow ContactsContactListContactDataRow;
typedef struct _ContactsContactListContactDataRowClass ContactsContactListContactDataRowClass;
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;
typedef struct _ContactsContactListContactDataRowPrivate ContactsContactListContactDataRowPrivate;

#define CONTACTS_TYPE_AVATAR (contacts_avatar_get_type ())
#define CONTACTS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatar))
#define CONTACTS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))
#define CONTACTS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR))
#define CONTACTS_IS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR))
#define CONTACTS_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))

typedef struct _ContactsAvatar ContactsAvatar;
typedef struct _ContactsAvatarClass ContactsAvatarClass;
enum  {
	CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_0_PROPERTY,
	CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_INDIVIDUAL_PROPERTY,
	CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_SELECTION_MODE_PROPERTY,
	CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_MARKED_PROPERTY,
	CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_list_contact_data_row_properties[CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_NUM_PROPERTIES];

struct _ContactsContactList {
	AdwBin parent_instance;
	ContactsContactListPrivate * priv;
};

struct _ContactsContactListClass {
	AdwBinClass parent_class;
};

struct _ContactsContactListPrivate {
	ContactsStore* _store;
	GtkMultiSelection* _marked_contacts;
	ContactsUiState _state;
	GtkListBox* listbox;
};

struct _Block16Data {
	int _ref_count_;
	ContactsContactList* self;
	ContactsContactListContactDataRow* row;
};

struct _Block17Data {
	int _ref_count_;
	ContactsContactList* self;
	GtkListBoxRow* row;
};

struct _ContactsContactListContactDataRow {
	GtkListBoxRow parent_instance;
	ContactsContactListContactDataRowPrivate * priv;
	GtkCheckButton* selector_button;
};

struct _ContactsContactListContactDataRowClass {
	GtkListBoxRowClass parent_class;
};

struct _ContactsContactListContactDataRowPrivate {
	FolksIndividual* _individual;
	GtkLabel* name_label;
	ContactsAvatar* avatar;
	GtkSelectionModel* marked_contacts;
};

static gint ContactsContactList_private_offset;
static gpointer contacts_contact_list_parent_class = NULL;
static gint ContactsContactListContactDataRow_private_offset;
static gpointer contacts_contact_list_contact_data_row_parent_class = NULL;

VALA_EXTERN GType contacts_contact_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactList, g_object_unref)
VALA_EXTERN GType contacts_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ContactsContactList* contacts_contact_list_new (ContactsStore* store,
                                                GtkMultiSelection* marked_contacts);
VALA_EXTERN ContactsContactList* contacts_contact_list_construct (GType object_type,
                                                      ContactsStore* store,
                                                      GtkMultiSelection* marked_contacts);
static GtkWidget* contacts_contact_list_create_row_for_item (ContactsContactList* self,
                                                      GObject* item);
static GType contacts_contact_list_contact_data_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactListContactDataRow, g_object_unref)
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
VALA_EXTERN GtkMultiSelection* contacts_contact_list_get_marked_contacts (ContactsContactList* self);
static ContactsContactListContactDataRow* contacts_contact_list_contact_data_row_new (FolksIndividual* individual,
                                                                               GtkSelectionModel* marked_contacts);
static ContactsContactListContactDataRow* contacts_contact_list_contact_data_row_construct (GType object_type,
                                                                                     FolksIndividual* individual,
                                                                                     GtkSelectionModel* marked_contacts);
static void __lambda8_ (Block16Data* _data16_,
                 GObject* obj,
                 GParamSpec* pspec);
VALA_EXTERN ContactsUiState contacts_contact_list_get_state (ContactsContactList* self);
static void contacts_contact_list_contact_data_row_set_selection_mode (ContactsContactListContactDataRow* self,
                                                                gboolean value);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void contacts_contact_list_on_marked_contacts_changed (ContactsContactList* self,
                                                       GtkSelectionModel* marked_contacts,
                                                       guint position,
                                                       guint n_changed);
static void contacts_contact_list_contact_data_row_set_marked (ContactsContactListContactDataRow* self,
                                                        gboolean value);
static void contacts_contact_list_update_header (ContactsContactList* self,
                                          GtkListBoxRow* row,
                                          GtkListBoxRow* before);
static FolksIndividual* contacts_contact_list_contact_data_row_get_individual (ContactsContactListContactDataRow* self);
static GtkLabel* contacts_contact_list_create_header_label (ContactsContactList* self,
                                                     const gchar* text);
static void contacts_contact_list_on_row_activated (ContactsContactList* self,
                                             GtkListBox* listbox,
                                             GtkListBoxRow* row);
static gboolean contacts_contact_list_contact_data_row_get_marked (ContactsContactListContactDataRow* self);
static void contacts_contact_list_on_row_selected (ContactsContactList* self,
                                            GtkListBox* listbox,
                                            GtkListBoxRow* row);
VALA_EXTERN ContactsStore* contacts_contact_list_get_store (ContactsContactList* self);
VALA_EXTERN void contacts_contact_list_scroll_to_selected (ContactsContactList* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static gboolean __lambda9_ (Block17Data* _data17_);
static gboolean ___lambda9__gsource_func (gpointer self);
VALA_EXTERN void contacts_contact_list_set_contacts_visible (ContactsContactList* self,
                                                 GtkBitset* selection,
                                                 gboolean visible);
static void contacts_contact_list_on_right_click (ContactsContactList* self,
                                           GtkGestureClick* gesture,
                                           gint n_press,
                                           gdouble x,
                                           gdouble y);
VALA_EXTERN void contacts_contact_list_set_state (ContactsContactList* self,
                                      ContactsUiState value);
static void contacts_contact_list_on_long_press (ContactsContactList* self,
                                          GtkGestureLongPress* gesture,
                                          gdouble x,
                                          gdouble y);
static void contacts_contact_list_set_store (ContactsContactList* self,
                                      ContactsStore* value);
static void contacts_contact_list_set_marked_contacts (ContactsContactList* self,
                                                GtkMultiSelection* value);
VALA_EXTERN GType contacts_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatar, g_object_unref)
VALA_EXTERN void contacts_avatar_set_individual (ContactsAvatar* self,
                                     FolksIndividual* value);
static void contacts_contact_list_contact_data_row_on_contact_changed (ContactsContactListContactDataRow* self,
                                                                GObject* obj,
                                                                GParamSpec* pspec);
static void _contacts_contact_list_contact_data_row_on_contact_changed_g_object_notify (GObject* _sender,
                                                                                 GParamSpec* pspec,
                                                                                 gpointer self);
static void contacts_contact_list_contact_data_row_set_individual (ContactsContactListContactDataRow* self,
                                                            FolksIndividual* value);
static gboolean contacts_contact_list_contact_data_row_get_selection_mode (ContactsContactListContactDataRow* self);
static GObject * contacts_contact_list_contact_data_row_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties);
VALA_EXTERN ContactsAvatar* contacts_avatar_new (gint size,
                                     FolksIndividual* individual);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct (GType object_type,
                                           gint size,
                                           FolksIndividual* individual);
static void contacts_contact_list_contact_data_row_finalize (GObject * obj);
static GType contacts_contact_list_contact_data_row_get_type_once (void);
static void _vala_contacts_contact_list_contact_data_row_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_contacts_contact_list_contact_data_row_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static GObject * contacts_contact_list_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _contacts_contact_list_on_marked_contacts_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                                              guint position,
                                                                                              guint n_items,
                                                                                              gpointer self);
static GtkWidget* _contacts_contact_list_create_row_for_item_gtk_list_box_create_widget_func (GObject* item,
                                                                                       gpointer self);
static void _contacts_contact_list_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                           GtkListBoxRow* before,
                                                                           gpointer self);
static void _contacts_contact_list_on_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                       GtkListBoxRow* row,
                                                                       gpointer self);
static void _contacts_contact_list_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                         GtkListBoxRow* row,
                                                                         gpointer self);
static void _contacts_contact_list_on_right_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                      gint n_press,
                                                                      gdouble x,
                                                                      gdouble y,
                                                                      gpointer self);
static void _contacts_contact_list_on_long_press_gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                                          gdouble x,
                                                                          gdouble y,
                                                                          gpointer self);
static void _contacts_contact_list___lambda10_ (ContactsContactList* self);
static void __contacts_contact_list___lambda10__gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                                guint position,
                                                                                guint n_items,
                                                                                gpointer self);
static void contacts_contact_list_finalize (GObject * obj);
static GType contacts_contact_list_get_type_once (void);
static void _vala_contacts_contact_list_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_contacts_contact_list_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
contacts_contact_list_get_instance_private (ContactsContactList* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactList_private_offset);
}

ContactsContactList*
contacts_contact_list_construct (GType object_type,
                                 ContactsStore* store,
                                 GtkMultiSelection* marked_contacts)
{
	ContactsContactList * self = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (marked_contacts != NULL, NULL);
	self = (ContactsContactList*) g_object_new (object_type, "store", store, "marked-contacts", marked_contacts, NULL);
	return self;
}

ContactsContactList*
contacts_contact_list_new (ContactsStore* store,
                           GtkMultiSelection* marked_contacts)
{
	return contacts_contact_list_construct (CONTACTS_TYPE_CONTACT_LIST, store, marked_contacts);
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		ContactsContactList* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->row);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
__lambda8_ (Block16Data* _data16_,
            GObject* obj,
            GParamSpec* pspec)
{
	ContactsContactList* self;
	ContactsUiState _tmp0_;
	self = _data16_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_state;
	contacts_contact_list_contact_data_row_set_selection_mode (_data16_->row, _tmp0_ == CONTACTS_UI_STATE_SELECTING);
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ (self, _sender, pspec);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
contacts_contact_list_create_row_for_item (ContactsContactList* self,
                                           GObject* item)
{
	Block16Data* _data16_;
	FolksIndividual* individual = NULL;
	GtkMultiSelection* _tmp0_;
	ContactsContactListContactDataRow* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	individual = G_TYPE_CHECK_INSTANCE_CAST (item, FOLKS_TYPE_INDIVIDUAL, FolksIndividual);
	_tmp0_ = self->priv->_marked_contacts;
	_tmp1_ = contacts_contact_list_contact_data_row_new (individual, (GtkSelectionModel*) _tmp0_);
	g_object_ref_sink (_tmp1_);
	_data16_->row = _tmp1_;
	g_signal_connect_data ((GObject*) self, "notify::state", (GCallback) ___lambda8__g_object_notify, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _data16_->row);
	result = _tmp2_;
	block16_data_unref (_data16_);
	_data16_ = NULL;
	return result;
}

static void
contacts_contact_list_on_marked_contacts_changed (ContactsContactList* self,
                                                  GtkSelectionModel* marked_contacts,
                                                  guint position,
                                                  guint n_changed)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (marked_contacts != NULL);
	{
		guint i = 0U;
		i = position;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ContactsContactListContactDataRow* row = NULL;
				GtkListBox* _tmp2_;
				GtkListBoxRow* _tmp3_;
				ContactsContactListContactDataRow* _tmp4_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < (position + n_changed))) {
					break;
				}
				_tmp2_ = self->priv->listbox;
				_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, (gint) i);
				row = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
				_tmp4_ = row;
				contacts_contact_list_contact_data_row_set_marked (_tmp4_, gtk_selection_model_is_selected (marked_contacts, i));
			}
		}
	}
}

static void
contacts_contact_list_update_header (ContactsContactList* self,
                                     GtkListBoxRow* row,
                                     GtkListBoxRow* before)
{
	FolksIndividual* current = NULL;
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* previous = NULL;
	FolksIndividual* _tmp9_;
	FolksIndividual* _tmp10_;
	gboolean _tmp11_ = FALSE;
	FolksIndividual* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = contacts_contact_list_contact_data_row_get_individual (G_TYPE_CHECK_INSTANCE_CAST (row, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow));
	_tmp1_ = _tmp0_;
	current = _tmp1_;
	if (before == NULL) {
		FolksIndividual* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = current;
		_tmp3_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			GtkLabel* _tmp5_;
			GtkLabel* _tmp6_;
			_tmp5_ = contacts_contact_list_create_header_label (self, _ ("Favorites"));
			_tmp6_ = _tmp5_;
			gtk_list_box_row_set_header (row, (GtkWidget*) _tmp6_);
			_g_object_unref0 (_tmp6_);
		} else {
			GtkLabel* _tmp7_;
			GtkLabel* _tmp8_;
			_tmp7_ = contacts_contact_list_create_header_label (self, _ ("All Contacts"));
			_tmp8_ = _tmp7_;
			gtk_list_box_row_set_header (row, (GtkWidget*) _tmp8_);
			_g_object_unref0 (_tmp8_);
		}
		return;
	}
	_tmp9_ = contacts_contact_list_contact_data_row_get_individual (G_TYPE_CHECK_INSTANCE_CAST (before, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow));
	_tmp10_ = _tmp9_;
	previous = _tmp10_;
	_tmp12_ = current;
	_tmp13_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (!_tmp14_) {
		FolksIndividual* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp15_ = previous;
		_tmp16_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp11_ = _tmp17_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GtkLabel* _tmp18_;
		GtkLabel* _tmp19_;
		_tmp18_ = contacts_contact_list_create_header_label (self, _ ("All Contacts"));
		_tmp19_ = _tmp18_;
		gtk_list_box_row_set_header (row, (GtkWidget*) _tmp19_);
		_g_object_unref0 (_tmp19_);
	} else {
		gtk_list_box_row_set_header (row, NULL);
	}
}

static GtkLabel*
contacts_contact_list_create_header_label (ContactsContactList* self,
                                           const gchar* text)
{
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (text);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_widget_set_margin_start ((GtkWidget*) label, 6);
	gtk_widget_set_margin_end ((GtkWidget*) label, 3);
	gtk_widget_set_margin_top ((GtkWidget*) label, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) label, 3);
	gtk_widget_add_css_class ((GtkWidget*) label, "heading");
	gtk_widget_add_css_class ((GtkWidget*) label, "dim-label");
	result = label;
	return result;
}

static void
contacts_contact_list_on_row_activated (ContactsContactList* self,
                                        GtkListBox* listbox,
                                        GtkListBoxRow* row)
{
	ContactsUiState _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (listbox != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == CONTACTS_UI_STATE_SELECTING) {
		ContactsContactListContactDataRow* c_row = NULL;
		ContactsContactListContactDataRow* _tmp1_;
		ContactsContactListContactDataRow* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		c_row = G_TYPE_CHECK_INSTANCE_CAST (row, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
		_tmp1_ = c_row;
		_tmp2_ = c_row;
		_tmp3_ = contacts_contact_list_contact_data_row_get_marked (_tmp2_);
		_tmp4_ = _tmp3_;
		contacts_contact_list_contact_data_row_set_marked (_tmp1_, !_tmp4_);
	}
}

static void
contacts_contact_list_on_row_selected (ContactsContactList* self,
                                       GtkListBox* listbox,
                                       GtkListBoxRow* row)
{
	ContactsUiState _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (listbox != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ != CONTACTS_UI_STATE_SELECTING) {
		if (row == NULL) {
			ContactsStore* _tmp1_;
			GtkSingleSelection* _tmp2_;
			GtkSingleSelection* _tmp3_;
			ContactsStore* _tmp4_;
			GtkSingleSelection* _tmp5_;
			GtkSingleSelection* _tmp6_;
			_tmp1_ = self->priv->_store;
			_tmp2_ = contacts_store_get_selection (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = self->priv->_store;
			_tmp5_ = contacts_store_get_selection (_tmp4_);
			_tmp6_ = _tmp5_;
			gtk_selection_model_unselect_item ((GtkSelectionModel*) _tmp3_, gtk_single_selection_get_selected (_tmp6_));
		} else {
			ContactsStore* _tmp7_;
			GtkSingleSelection* _tmp8_;
			GtkSingleSelection* _tmp9_;
			_tmp7_ = self->priv->_store;
			_tmp8_ = contacts_store_get_selection (_tmp7_);
			_tmp9_ = _tmp8_;
			gtk_selection_model_select_item ((GtkSelectionModel*) _tmp9_, (guint) gtk_list_box_row_get_index (row), TRUE);
		}
	}
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		ContactsContactList* self;
		self = _data17_->self;
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static gboolean
__lambda9_ (Block17Data* _data17_)
{
	ContactsContactList* self;
	GtkListBoxRow* _tmp0_;
	gboolean result;
	self = _data17_->self;
	_tmp0_ = _data17_->row;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda9_ (self);
	return result;
}

void
contacts_contact_list_scroll_to_selected (ContactsContactList* self)
{
	Block17Data* _data17_;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_if_fail (self != NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_data17_->row = _tmp1_;
	_tmp2_ = _data17_->row;
	if (_tmp2_ == NULL) {
		block17_data_unref (_data17_);
		_data17_ = NULL;
		return;
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda9__gsource_func, block17_data_ref (_data17_), block17_data_unref);
	block17_data_unref (_data17_);
	_data17_ = NULL;
}

void
contacts_contact_list_set_contacts_visible (ContactsContactList* self,
                                            GtkBitset* selection,
                                            gboolean visible)
{
	GtkBitsetIter iter = {0};
	guint index = 0U;
	guint _tmp0_ = 0U;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	memset (&iter, 0, sizeof (GtkBitsetIter));
	_tmp1_ = gtk_bitset_iter_init_first (&iter, selection, &_tmp0_);
	index = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			GtkListBox* _tmp5_;
			GtkListBoxRow* _tmp6_;
			if (!_tmp2_) {
				guint _tmp3_ = 0U;
				gboolean _tmp4_;
				_tmp4_ = gtk_bitset_iter_next (&iter, &_tmp3_);
				index = _tmp3_;
				if (!_tmp4_) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp5_ = self->priv->listbox;
			_tmp6_ = gtk_list_box_get_row_at_index (_tmp5_, (gint) index);
			gtk_widget_set_visible ((GtkWidget*) _tmp6_, visible);
		}
	}
}

static void
contacts_contact_list_on_right_click (ContactsContactList* self,
                                      GtkGestureClick* gesture,
                                      gint n_press,
                                      gdouble x,
                                      gdouble y)
{
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	contacts_contact_list_set_state (self, CONTACTS_UI_STATE_SELECTING);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_row_at_y (_tmp0_, (gint) round (y));
	row = _tmp1_;
	_tmp2_ = row;
	if (_tmp2_ != NULL) {
		GtkListBoxRow* _tmp3_;
		_tmp3_ = row;
		g_signal_emit_by_name (_tmp3_, "activate");
	}
}

static void
contacts_contact_list_on_long_press (ContactsContactList* self,
                                     GtkGestureLongPress* gesture,
                                     gdouble x,
                                     gdouble y)
{
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	contacts_contact_list_set_state (self, CONTACTS_UI_STATE_SELECTING);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_row_at_y (_tmp0_, (gint) round (y));
	row = _tmp1_;
	_tmp2_ = row;
	if (_tmp2_ != NULL) {
		GtkListBoxRow* _tmp3_;
		_tmp3_ = row;
		g_signal_emit_by_name (_tmp3_, "activate");
	}
}

ContactsStore*
contacts_contact_list_get_store (ContactsContactList* self)
{
	ContactsStore* result;
	ContactsStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}

static void
contacts_contact_list_set_store (ContactsContactList* self,
                                 ContactsStore* value)
{
	ContactsStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_list_get_store (self);
	if (old_value != value) {
		ContactsStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_store);
		self->priv->_store = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_STORE_PROPERTY]);
	}
}

GtkMultiSelection*
contacts_contact_list_get_marked_contacts (ContactsContactList* self)
{
	GtkMultiSelection* result;
	GtkMultiSelection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_marked_contacts;
	result = _tmp0_;
	return result;
}

static void
contacts_contact_list_set_marked_contacts (ContactsContactList* self,
                                           GtkMultiSelection* value)
{
	GtkMultiSelection* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_list_get_marked_contacts (self);
	if (old_value != value) {
		GtkMultiSelection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_marked_contacts);
		self->priv->_marked_contacts = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_MARKED_CONTACTS_PROPERTY]);
	}
}

ContactsUiState
contacts_contact_list_get_state (ContactsContactList* self)
{
	ContactsUiState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
contacts_contact_list_set_state (ContactsContactList* self,
                                 ContactsUiState value)
{
	ContactsUiState old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_list_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_STATE_PROPERTY]);
	}
}

static inline gpointer
contacts_contact_list_contact_data_row_get_instance_private (ContactsContactListContactDataRow* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactListContactDataRow_private_offset);
}

static void
_contacts_contact_list_contact_data_row_on_contact_changed_g_object_notify (GObject* _sender,
                                                                            GParamSpec* pspec,
                                                                            gpointer self)
{
	contacts_contact_list_contact_data_row_on_contact_changed ((ContactsContactListContactDataRow*) self, _sender, pspec);
}

static ContactsContactListContactDataRow*
contacts_contact_list_contact_data_row_construct (GType object_type,
                                                  FolksIndividual* individual,
                                                  GtkSelectionModel* marked_contacts)
{
	ContactsContactListContactDataRow * self = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ContactsAvatar* _tmp3_;
	g_return_val_if_fail (individual != NULL, NULL);
	g_return_val_if_fail (marked_contacts != NULL, NULL);
	self = (ContactsContactListContactDataRow*) g_object_new (object_type, "individual", individual, NULL);
	self->priv->marked_contacts = marked_contacts;
	_tmp0_ = self->priv->name_label;
	_tmp1_ = folks_individual_get_display_name (individual);
	_tmp2_ = _tmp1_;
	gtk_label_set_text (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->avatar;
	contacts_avatar_set_individual (_tmp3_, individual);
	g_signal_connect_object ((GObject*) individual, "notify", (GCallback) _contacts_contact_list_contact_data_row_on_contact_changed_g_object_notify, self, 0);
	return self;
}

static ContactsContactListContactDataRow*
contacts_contact_list_contact_data_row_new (FolksIndividual* individual,
                                            GtkSelectionModel* marked_contacts)
{
	return contacts_contact_list_contact_data_row_construct (CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, individual, marked_contacts);
}

static void
contacts_contact_list_contact_data_row_on_contact_changed (ContactsContactListContactDataRow* self,
                                                           GObject* obj,
                                                           GParamSpec* pspec)
{
	GtkLabel* _tmp0_;
	FolksIndividual* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = self->priv->_individual;
	_tmp2_ = folks_individual_get_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_text (_tmp0_, _tmp3_);
	gtk_list_box_row_changed ((GtkListBoxRow*) self);
}

static FolksIndividual*
contacts_contact_list_contact_data_row_get_individual (ContactsContactListContactDataRow* self)
{
	FolksIndividual* result;
	FolksIndividual* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_individual;
	result = _tmp0_;
	return result;
}

static void
contacts_contact_list_contact_data_row_set_individual (ContactsContactListContactDataRow* self,
                                                       FolksIndividual* value)
{
	FolksIndividual* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_list_contact_data_row_get_individual (self);
	if (old_value != value) {
		FolksIndividual* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_individual);
		self->priv->_individual = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_contact_data_row_properties[CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_INDIVIDUAL_PROPERTY]);
	}
}

static gboolean
contacts_contact_list_contact_data_row_get_selection_mode (ContactsContactListContactDataRow* self)
{
	gboolean result;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->selector_button;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
contacts_contact_list_contact_data_row_set_selection_mode (ContactsContactListContactDataRow* self,
                                                           gboolean value)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->selector_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_contact_data_row_properties[CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_SELECTION_MODE_PROPERTY]);
}

static gboolean
contacts_contact_list_contact_data_row_get_marked (ContactsContactListContactDataRow* self)
{
	gboolean result;
	GtkSelectionModel* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->marked_contacts;
	result = gtk_selection_model_is_selected (_tmp0_, (guint) gtk_list_box_row_get_index ((GtkListBoxRow*) self));
	return result;
}

static void
contacts_contact_list_contact_data_row_set_marked (ContactsContactListContactDataRow* self,
                                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		GtkSelectionModel* _tmp0_;
		_tmp0_ = self->priv->marked_contacts;
		gtk_selection_model_select_item (_tmp0_, (guint) gtk_list_box_row_get_index ((GtkListBoxRow*) self), FALSE);
	} else {
		GtkSelectionModel* _tmp1_;
		_tmp1_ = self->priv->marked_contacts;
		gtk_selection_model_unselect_item (_tmp1_, (guint) gtk_list_box_row_get_index ((GtkListBoxRow*) self));
	}
	g_object_notify ((GObject*) self, "marked");
	g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_contact_data_row_properties[CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_MARKED_PROPERTY]);
}

static GObject *
contacts_contact_list_contact_data_row_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactListContactDataRow * self;
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	ContactsAvatar* avatar = NULL;
	ContactsAvatar* _tmp3_;
	GtkBox* _tmp4_;
	ContactsAvatar* _tmp5_;
	ContactsAvatar* _tmp6_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkBox* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkCheckButton* selector_button = NULL;
	GtkCheckButton* _tmp15_;
	GtkCheckButton* _tmp16_;
	GtkCheckButton* _tmp17_;
	GtkCheckButton* _tmp18_;
	GtkCheckButton* _tmp19_;
	GtkCheckButton* _tmp20_;
	GtkCheckButton* _tmp21_;
	GtkCheckButton* _tmp22_;
	GtkBox* _tmp23_;
	GtkCheckButton* _tmp24_;
	GtkCheckButton* _tmp25_;
	GtkBox* _tmp26_;
	parent_class = G_OBJECT_CLASS (contacts_contact_list_contact_data_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
	gtk_widget_add_css_class ((GtkWidget*) self, "contact-data-row");
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = box;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp1_, 6);
	_tmp2_ = box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp2_, 6);
	_tmp3_ = contacts_avatar_new (CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_LIST_AVATAR_SIZE, NULL);
	g_object_ref_sink (_tmp3_);
	avatar = _tmp3_;
	_tmp4_ = box;
	_tmp5_ = avatar;
	gtk_box_append (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = avatar;
	self->priv->avatar = _tmp6_;
	_tmp7_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp7_);
	label = _tmp7_;
	_tmp8_ = label;
	gtk_label_set_ellipsize (_tmp8_, PANGO_ELLIPSIZE_END);
	_tmp9_ = label;
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_CENTER);
	_tmp10_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_START);
	_tmp11_ = label;
	gtk_label_set_xalign (_tmp11_, (gfloat) 0);
	_tmp12_ = box;
	_tmp13_ = label;
	gtk_box_append (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = label;
	self->priv->name_label = _tmp14_;
	_tmp15_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp15_);
	selector_button = _tmp15_;
	_tmp16_ = selector_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp16_, FALSE);
	_tmp17_ = selector_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
	_tmp18_ = selector_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_END);
	_tmp19_ = selector_button;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp19_, TRUE);
	_tmp20_ = selector_button;
	g_object_bind_property_with_closures ((GObject*) self, "marked", (GObject*) _tmp20_, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp21_ = selector_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp21_, "selection-mode");
	_tmp22_ = selector_button;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp22_, 12);
	_tmp23_ = box;
	_tmp24_ = selector_button;
	gtk_box_append (_tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = selector_button;
	self->selector_button = _tmp25_;
	_tmp26_ = box;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp26_);
	_g_object_unref0 (selector_button);
	_g_object_unref0 (label);
	_g_object_unref0 (avatar);
	_g_object_unref0 (box);
	return obj;
}

static void
contacts_contact_list_contact_data_row_class_init (ContactsContactListContactDataRowClass * klass,
                                                   gpointer klass_data)
{
	contacts_contact_list_contact_data_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactListContactDataRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_list_contact_data_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_contact_list_contact_data_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_list_contact_data_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_list_contact_data_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_INDIVIDUAL_PROPERTY, contacts_contact_list_contact_data_row_properties[CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_INDIVIDUAL_PROPERTY] = g_param_spec_object ("individual", "individual", "individual", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_SELECTION_MODE_PROPERTY, contacts_contact_list_contact_data_row_properties[CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_SELECTION_MODE_PROPERTY] = g_param_spec_boolean ("selection-mode", "selection-mode", "selection-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_MARKED_PROPERTY, contacts_contact_list_contact_data_row_properties[CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_MARKED_PROPERTY] = g_param_spec_boolean ("marked", "marked", "marked", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
contacts_contact_list_contact_data_row_instance_init (ContactsContactListContactDataRow * self,
                                                      gpointer klass)
{
	self->priv = contacts_contact_list_contact_data_row_get_instance_private (self);
}

static void
contacts_contact_list_contact_data_row_finalize (GObject * obj)
{
	ContactsContactListContactDataRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
	_g_object_unref0 (self->priv->_individual);
	G_OBJECT_CLASS (contacts_contact_list_contact_data_row_parent_class)->finalize (obj);
}

/**
   * A widget that shows a small summary for a contact.
   */
 G_GNUC_NO_INLINE static GType
contacts_contact_list_contact_data_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactListContactDataRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_list_contact_data_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactListContactDataRow), 0, (GInstanceInitFunc) contacts_contact_list_contact_data_row_instance_init, NULL };
	GType contacts_contact_list_contact_data_row_type_id;
	contacts_contact_list_contact_data_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "ContactsContactListContactDataRow", &g_define_type_info, 0);
	ContactsContactListContactDataRow_private_offset = g_type_add_instance_private (contacts_contact_list_contact_data_row_type_id, sizeof (ContactsContactListContactDataRowPrivate));
	return contacts_contact_list_contact_data_row_type_id;
}

static GType
contacts_contact_list_contact_data_row_get_type (void)
{
	static volatile gsize contacts_contact_list_contact_data_row_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_list_contact_data_row_type_id__once)) {
		GType contacts_contact_list_contact_data_row_type_id;
		contacts_contact_list_contact_data_row_type_id = contacts_contact_list_contact_data_row_get_type_once ();
		g_once_init_leave (&contacts_contact_list_contact_data_row_type_id__once, contacts_contact_list_contact_data_row_type_id);
	}
	return contacts_contact_list_contact_data_row_type_id__once;
}

static void
_vala_contacts_contact_list_contact_data_row_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	ContactsContactListContactDataRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
	switch (property_id) {
		case CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_INDIVIDUAL_PROPERTY:
		g_value_set_object (value, contacts_contact_list_contact_data_row_get_individual (self));
		break;
		case CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_SELECTION_MODE_PROPERTY:
		g_value_set_boolean (value, contacts_contact_list_contact_data_row_get_selection_mode (self));
		break;
		case CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_MARKED_PROPERTY:
		g_value_set_boolean (value, contacts_contact_list_contact_data_row_get_marked (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_contact_list_contact_data_row_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	ContactsContactListContactDataRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
	switch (property_id) {
		case CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_INDIVIDUAL_PROPERTY:
		contacts_contact_list_contact_data_row_set_individual (self, g_value_get_object (value));
		break;
		case CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_SELECTION_MODE_PROPERTY:
		contacts_contact_list_contact_data_row_set_selection_mode (self, g_value_get_boolean (value));
		break;
		case CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_MARKED_PROPERTY:
		contacts_contact_list_contact_data_row_set_marked (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_contacts_contact_list_on_marked_contacts_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                                         guint position,
                                                                                         guint n_items,
                                                                                         gpointer self)
{
	contacts_contact_list_on_marked_contacts_changed ((ContactsContactList*) self, _sender, position, n_items);
}

static GtkWidget*
_contacts_contact_list_create_row_for_item_gtk_list_box_create_widget_func (GObject* item,
                                                                            gpointer self)
{
	GtkWidget* result;
	result = contacts_contact_list_create_row_for_item ((ContactsContactList*) self, item);
	return result;
}

static void
_contacts_contact_list_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                      GtkListBoxRow* before,
                                                                      gpointer self)
{
	contacts_contact_list_update_header ((ContactsContactList*) self, row, before);
}

static void
_contacts_contact_list_on_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                  GtkListBoxRow* row,
                                                                  gpointer self)
{
	contacts_contact_list_on_row_selected ((ContactsContactList*) self, _sender, row);
}

static void
_contacts_contact_list_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                    GtkListBoxRow* row,
                                                                    gpointer self)
{
	contacts_contact_list_on_row_activated ((ContactsContactList*) self, _sender, row);
}

static void
_contacts_contact_list_on_right_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                 gint n_press,
                                                                 gdouble x,
                                                                 gdouble y,
                                                                 gpointer self)
{
	contacts_contact_list_on_right_click ((ContactsContactList*) self, _sender, n_press, x, y);
}

static void
_contacts_contact_list_on_long_press_gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                                     gdouble x,
                                                                     gdouble y,
                                                                     gpointer self)
{
	contacts_contact_list_on_long_press ((ContactsContactList*) self, _sender, x, y);
}

static void
_contacts_contact_list___lambda10_ (ContactsContactList* self)
{
	guint selected = 0U;
	ContactsStore* _tmp0_;
	GtkSingleSelection* _tmp1_;
	GtkSingleSelection* _tmp2_;
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_store_get_selection (_tmp0_);
	_tmp2_ = _tmp1_;
	selected = gtk_single_selection_get_selected (_tmp2_);
	if (selected == GTK_INVALID_LIST_POSITION) {
		GtkListBox* _tmp3_;
		_tmp3_ = self->priv->listbox;
		gtk_list_box_unselect_all (_tmp3_);
	} else {
		GtkListBox* _tmp4_;
		GtkListBox* _tmp5_;
		GtkListBoxRow* _tmp6_;
		_tmp4_ = self->priv->listbox;
		_tmp5_ = self->priv->listbox;
		_tmp6_ = gtk_list_box_get_row_at_index (_tmp5_, (gint) selected);
		gtk_list_box_select_row (_tmp4_, _tmp6_);
	}
}

static void
__contacts_contact_list___lambda10__gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                           guint position,
                                                                           guint n_items,
                                                                           gpointer self)
{
	_contacts_contact_list___lambda10_ ((ContactsContactList*) self);
}

static GObject *
contacts_contact_list_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactList * self;
	GtkMultiSelection* _tmp0_;
	GtkListBox* list_box = NULL;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	ContactsStore* _tmp4_;
	GtkFilterListModel* _tmp5_;
	GtkFilterListModel* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	GtkListBox* _tmp11_;
	GtkGestureClick* secondary_click_gesture = NULL;
	GtkGestureClick* _tmp12_;
	GtkGestureClick* _tmp13_;
	GtkGestureClick* _tmp14_;
	GtkListBox* _tmp15_;
	GtkGestureClick* _tmp16_;
	GtkEventController* _tmp17_;
	GtkGestureLongPress* long_press_gesture = NULL;
	GtkGestureLongPress* _tmp18_;
	GtkGestureLongPress* _tmp19_;
	GtkListBox* _tmp20_;
	GtkGestureLongPress* _tmp21_;
	GtkEventController* _tmp22_;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	GtkScrolledWindow* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	GtkViewport* viewport = NULL;
	GtkScrolledWindow* _tmp27_;
	GtkAdjustment* _tmp28_;
	GtkAdjustment* _tmp29_;
	GtkScrolledWindow* _tmp30_;
	GtkAdjustment* _tmp31_;
	GtkAdjustment* _tmp32_;
	GtkViewport* _tmp33_;
	GtkViewport* _tmp34_;
	GtkViewport* _tmp35_;
	GtkListBox* _tmp36_;
	GtkScrolledWindow* _tmp37_;
	GtkViewport* _tmp38_;
	ContactsStore* _tmp39_;
	GtkSingleSelection* _tmp40_;
	GtkSingleSelection* _tmp41_;
	parent_class = G_OBJECT_CLASS (contacts_contact_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_LIST, ContactsContactList);
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-contact-list");
	_tmp0_ = self->priv->_marked_contacts;
	g_signal_connect_object ((GtkSelectionModel*) _tmp0_, "selection-changed", (GCallback) _contacts_contact_list_on_marked_contacts_changed_gtk_selection_model_selection_changed, self, 0);
	_tmp1_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp1_);
	list_box = _tmp1_;
	_tmp2_ = list_box;
	self->priv->listbox = _tmp2_;
	_tmp3_ = self->priv->listbox;
	_tmp4_ = self->priv->_store;
	_tmp5_ = contacts_store_get_filter_model (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_list_box_bind_model (_tmp3_, (GListModel*) _tmp6_, _contacts_contact_list_create_row_for_item_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp7_ = self->priv->listbox;
	gtk_list_box_set_selection_mode (_tmp7_, GTK_SELECTION_SINGLE);
	_tmp8_ = self->priv->listbox;
	gtk_list_box_set_header_func (_tmp8_, _contacts_contact_list_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp9_ = self->priv->listbox;
	gtk_widget_add_css_class ((GtkWidget*) _tmp9_, "navigation-sidebar");
	_tmp10_ = self->priv->listbox;
	g_signal_connect_object (_tmp10_, "row-selected", (GCallback) _contacts_contact_list_on_row_selected_gtk_list_box_row_selected, self, 0);
	_tmp11_ = self->priv->listbox;
	g_signal_connect_object (_tmp11_, "row-activated", (GCallback) _contacts_contact_list_on_row_activated_gtk_list_box_row_activated, self, 0);
	_tmp12_ = (GtkGestureClick*) gtk_gesture_click_new ();
	secondary_click_gesture = _tmp12_;
	_tmp13_ = secondary_click_gesture;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp13_, (guint) GDK_BUTTON_SECONDARY);
	_tmp14_ = secondary_click_gesture;
	g_signal_connect_object (_tmp14_, "pressed", (GCallback) _contacts_contact_list_on_right_click_gtk_gesture_click_pressed, self, 0);
	_tmp15_ = self->priv->listbox;
	_tmp16_ = secondary_click_gesture;
	_tmp17_ = _g_object_ref0 ((GtkEventController*) _tmp16_);
	gtk_widget_add_controller ((GtkWidget*) _tmp15_, _tmp17_);
	_tmp18_ = (GtkGestureLongPress*) gtk_gesture_long_press_new ();
	long_press_gesture = _tmp18_;
	_tmp19_ = long_press_gesture;
	g_signal_connect_object (_tmp19_, "pressed", (GCallback) _contacts_contact_list_on_long_press_gtk_gesture_long_press_pressed, self, 0);
	_tmp20_ = self->priv->listbox;
	_tmp21_ = long_press_gesture;
	_tmp22_ = _g_object_ref0 ((GtkEventController*) _tmp21_);
	gtk_widget_add_controller ((GtkWidget*) _tmp20_, _tmp22_);
	_tmp23_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp23_);
	sw = _tmp23_;
	_tmp24_ = sw;
	g_object_set (_tmp24_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp25_ = sw;
	gtk_widget_add_css_class ((GtkWidget*) _tmp25_, "contact-list-scrolled-window");
	_tmp26_ = sw;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp26_);
	_tmp27_ = sw;
	_tmp28_ = gtk_scrolled_window_get_hadjustment (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = sw;
	_tmp31_ = gtk_scrolled_window_get_vadjustment (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = (GtkViewport*) gtk_viewport_new (_tmp29_, _tmp32_);
	g_object_ref_sink (_tmp33_);
	viewport = _tmp33_;
	_tmp34_ = viewport;
	gtk_viewport_set_scroll_to_focus (_tmp34_, TRUE);
	_tmp35_ = viewport;
	_tmp36_ = self->priv->listbox;
	gtk_viewport_set_child (_tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = sw;
	_tmp38_ = viewport;
	gtk_scrolled_window_set_child (_tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = self->priv->_store;
	_tmp40_ = contacts_store_get_selection (_tmp39_);
	_tmp41_ = _tmp40_;
	g_signal_connect_object ((GtkSelectionModel*) _tmp41_, "selection-changed", (GCallback) __contacts_contact_list___lambda10__gtk_selection_model_selection_changed, self, 0);
	_g_object_unref0 (viewport);
	_g_object_unref0 (sw);
	_g_object_unref0 (long_press_gesture);
	_g_object_unref0 (secondary_click_gesture);
	_g_object_unref0 (list_box);
	return obj;
}

static void
contacts_contact_list_class_init (ContactsContactListClass * klass,
                                  gpointer klass_data)
{
	contacts_contact_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactList_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_contact_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_STORE_PROPERTY, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_STORE_PROPERTY] = g_param_spec_object ("store", "store", "store", CONTACTS_TYPE_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_MARKED_CONTACTS_PROPERTY, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_MARKED_CONTACTS_PROPERTY] = g_param_spec_object ("marked-contacts", "marked-contacts", "marked-contacts", gtk_multi_selection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_STATE_PROPERTY, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", CONTACTS_TYPE_UI_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
contacts_contact_list_instance_init (ContactsContactList * self,
                                     gpointer klass)
{
	self->priv = contacts_contact_list_get_instance_private (self);
}

static void
contacts_contact_list_finalize (GObject * obj)
{
	ContactsContactList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_LIST, ContactsContactList);
	_g_object_unref0 (self->priv->_store);
	_g_object_unref0 (self->priv->_marked_contacts);
	G_OBJECT_CLASS (contacts_contact_list_parent_class)->finalize (obj);
}

/**
 * The ContactList is the widget that diplays the list of contacts
 * ({@link Individual}s) that the user sees on the left. It is contained by the
 * {@link ListPane}, which also provides other functionality, such as an action
 * bar.
 *
 * On top of the list models, we have a {@link Gtk.SelectionModel} which keeps
 * track of the contacts that were selected.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactList), 0, (GInstanceInitFunc) contacts_contact_list_instance_init, NULL };
	GType contacts_contact_list_type_id;
	contacts_contact_list_type_id = g_type_register_static (adw_bin_get_type (), "ContactsContactList", &g_define_type_info, 0);
	ContactsContactList_private_offset = g_type_add_instance_private (contacts_contact_list_type_id, sizeof (ContactsContactListPrivate));
	return contacts_contact_list_type_id;
}

GType
contacts_contact_list_get_type (void)
{
	static volatile gsize contacts_contact_list_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_list_type_id__once)) {
		GType contacts_contact_list_type_id;
		contacts_contact_list_type_id = contacts_contact_list_get_type_once ();
		g_once_init_leave (&contacts_contact_list_type_id__once, contacts_contact_list_type_id);
	}
	return contacts_contact_list_type_id__once;
}

static void
_vala_contacts_contact_list_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ContactsContactList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_LIST, ContactsContactList);
	switch (property_id) {
		case CONTACTS_CONTACT_LIST_STORE_PROPERTY:
		g_value_set_object (value, contacts_contact_list_get_store (self));
		break;
		case CONTACTS_CONTACT_LIST_MARKED_CONTACTS_PROPERTY:
		g_value_set_object (value, contacts_contact_list_get_marked_contacts (self));
		break;
		case CONTACTS_CONTACT_LIST_STATE_PROPERTY:
		g_value_set_enum (value, contacts_contact_list_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_contact_list_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ContactsContactList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_LIST, ContactsContactList);
	switch (property_id) {
		case CONTACTS_CONTACT_LIST_STORE_PROPERTY:
		contacts_contact_list_set_store (self, g_value_get_object (value));
		break;
		case CONTACTS_CONTACT_LIST_MARKED_CONTACTS_PROPERTY:
		contacts_contact_list_set_marked_contacts (self, g_value_get_object (value));
		break;
		case CONTACTS_CONTACT_LIST_STATE_PROPERTY:
		contacts_contact_list_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

