/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import java.nio.charset.Charset;
import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class NioDetailsProvider
extends DetailsProvider.Basic {
    private static final String UNIXPATH_MASK = "sun.nio.fs.UnixPath";
    private static final String WINDOWSPATH_MASK = "sun.nio.fs.WindowsPath";
    private long lastHeapId;
    private Charset lastJnuEncoding;

    public NioDetailsProvider() {
        super(UNIXPATH_MASK, WINDOWSPATH_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        switch (className) {
            case "sun.nio.fs.UnixPath": {
                String path = DetailsUtils.getInstanceFieldString(instance, "stringValue");
                if (path != null) {
                    return path;
                }
                Charset encoding = this.getJnuEncoding(instance.getJavaClass().getHeap());
                List<String> pathItems = DetailsUtils.getPrimitiveArrayFieldValues(instance, "path");
                byte[] pathArr = DetailsUtils.getByteArray(pathItems);
                if (pathArr == null) break;
                return new String(pathArr, encoding);
            }
            case "sun.nio.fs.WindowsPath": {
                return DetailsUtils.getInstanceFieldString(instance, "path");
            }
        }
        return null;
    }

    private Charset getJnuEncoding(Heap heap) {
        if (this.lastHeapId != (long)System.identityHashCode(heap)) {
            String encoding = heap.getSystemProperties().getProperty("sun.jnu.encoding", "UTF-8");
            this.lastJnuEncoding = Charset.forName(encoding);
            this.lastHeapId = System.identityHashCode(heap);
        }
        return this.lastJnuEncoding;
    }
}

