/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.anim.AbstractAnimation;
import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.dom.AnimationTargetListener;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.anim.timing.TimegraphListener;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.util.DoublyIndexedTable;
import org.w3c.dom.Document;

public abstract class AnimationEngine {
    public static final short ANIM_TYPE_XML = 0;
    public static final short ANIM_TYPE_CSS = 1;
    public static final short ANIM_TYPE_OTHER = 2;
    protected Document document;
    protected TimedDocumentRoot timedDocumentRoot;
    protected long pauseTime;
    protected HashMap targets = new HashMap();
    protected HashMap animations = new HashMap();
    protected Listener targetListener = new Listener();
    protected static final Map.Entry[] MAP_ENTRY_ARRAY = new Map.Entry[0];

    public AnimationEngine(Document document) {
        this.document = document;
        this.timedDocumentRoot = this.createDocumentRoot();
    }

    public void dispose() {
        for (Map.Entry entry : this.targets.entrySet()) {
            Object object;
            String string;
            AnimationTarget animationTarget = (AnimationTarget)entry.getKey();
            TargetInfo targetInfo = (TargetInfo)entry.getValue();
            for (DoublyIndexedTable.Entry entry2 : targetInfo.xmlAnimations) {
                string = (String)entry2.getKey1();
                object = (String)entry2.getKey2();
                Sandwich sandwich = (Sandwich)entry2.getValue();
                if (!sandwich.listenerRegistered) continue;
                animationTarget.removeTargetListener(string, (String)object, false, this.targetListener);
            }
            for (Map.Entry entry3 : targetInfo.cssAnimations.entrySet()) {
                string = (String)entry3.getKey();
                object = (Sandwich)entry3.getValue();
                if (!((Sandwich)object).listenerRegistered) continue;
                animationTarget.removeTargetListener(null, string, true, this.targetListener);
            }
        }
    }

    public void pause() {
        if (this.pauseTime == 0L) {
            this.pauseTime = System.currentTimeMillis();
        }
    }

    public void unpause() {
        if (this.pauseTime != 0L) {
            Calendar calendar = this.timedDocumentRoot.getDocumentBeginTime();
            int n = (int)(System.currentTimeMillis() - this.pauseTime);
            calendar.add(14, n);
            this.pauseTime = 0L;
        }
    }

    public boolean isPaused() {
        return this.pauseTime != 0L;
    }

    public float getCurrentTime() {
        return this.timedDocumentRoot.getCurrentTime();
    }

    public float setCurrentTime(float f) {
        boolean bl = this.pauseTime != 0L;
        this.unpause();
        Calendar calendar = this.timedDocumentRoot.getDocumentBeginTime();
        float f2 = this.timedDocumentRoot.convertEpochTime(System.currentTimeMillis());
        calendar.add(14, (int)((f2 - f) * 1000.0f));
        if (bl) {
            this.pause();
        }
        return this.tick(f, true);
    }

    public void addAnimation(AnimationTarget animationTarget, short s, String string, String string2, AbstractAnimation abstractAnimation) {
        this.timedDocumentRoot.addChild(abstractAnimation.getTimedElement());
        AnimationInfo animationInfo = this.getAnimationInfo(abstractAnimation);
        animationInfo.type = s;
        animationInfo.attributeNamespaceURI = string;
        animationInfo.attributeLocalName = string2;
        animationInfo.target = animationTarget;
        this.animations.put(abstractAnimation, animationInfo);
        Sandwich sandwich = this.getSandwich(animationTarget, s, string, string2);
        if (sandwich.animation == null) {
            abstractAnimation.lowerAnimation = null;
            abstractAnimation.higherAnimation = null;
        } else {
            sandwich.animation.higherAnimation = abstractAnimation;
            abstractAnimation.lowerAnimation = sandwich.animation;
            abstractAnimation.higherAnimation = null;
        }
        sandwich.animation = abstractAnimation;
        if (abstractAnimation.lowerAnimation == null) {
            sandwich.lowestAnimation = abstractAnimation;
        }
    }

    public void removeAnimation(AbstractAnimation abstractAnimation) {
        this.timedDocumentRoot.removeChild(abstractAnimation.getTimedElement());
        AbstractAnimation abstractAnimation2 = abstractAnimation.higherAnimation;
        if (abstractAnimation2 != null) {
            abstractAnimation2.markDirty();
        }
        this.moveToBottom(abstractAnimation);
        if (abstractAnimation.higherAnimation != null) {
            abstractAnimation.higherAnimation.lowerAnimation = null;
        }
        AnimationInfo animationInfo = this.getAnimationInfo(abstractAnimation);
        Sandwich sandwich = this.getSandwich(animationInfo.target, animationInfo.type, animationInfo.attributeNamespaceURI, animationInfo.attributeLocalName);
        if (sandwich.animation == abstractAnimation) {
            sandwich.animation = null;
            sandwich.lowestAnimation = null;
            sandwich.shouldUpdate = true;
        }
    }

    protected Sandwich getSandwich(AnimationTarget animationTarget, short s, String string, String string2) {
        Sandwich sandwich;
        TargetInfo targetInfo = this.getTargetInfo(animationTarget);
        if (s == 0) {
            sandwich = (Sandwich)targetInfo.xmlAnimations.get((Object)string, (Object)string2);
            if (sandwich == null) {
                sandwich = new Sandwich();
                targetInfo.xmlAnimations.put((Object)string, (Object)string2, (Object)sandwich);
            }
        } else if (s == 1) {
            sandwich = (Sandwich)targetInfo.cssAnimations.get(string2);
            if (sandwich == null) {
                sandwich = new Sandwich();
                targetInfo.cssAnimations.put(string2, sandwich);
            }
        } else {
            sandwich = (Sandwich)targetInfo.otherAnimations.get(string2);
            if (sandwich == null) {
                sandwich = new Sandwich();
                targetInfo.otherAnimations.put(string2, sandwich);
            }
        }
        return sandwich;
    }

    protected TargetInfo getTargetInfo(AnimationTarget animationTarget) {
        TargetInfo targetInfo = (TargetInfo)this.targets.get(animationTarget);
        if (targetInfo == null) {
            targetInfo = new TargetInfo();
            this.targets.put(animationTarget, targetInfo);
        }
        return targetInfo;
    }

    protected AnimationInfo getAnimationInfo(AbstractAnimation abstractAnimation) {
        AnimationInfo animationInfo = (AnimationInfo)this.animations.get(abstractAnimation);
        if (animationInfo == null) {
            animationInfo = new AnimationInfo();
            this.animations.put(abstractAnimation, animationInfo);
        }
        return animationInfo;
    }

    protected float tick(float f, boolean bl) {
        float f2 = this.timedDocumentRoot.seekTo(f, bl);
        Map.Entry[] entryArray = this.targets.entrySet().toArray(MAP_ENTRY_ARRAY);
        for (int i = 0; i < entryArray.length; ++i) {
            Object object;
            Object object2;
            String string;
            Map.Entry entry = entryArray[i];
            AnimationTarget animationTarget = (AnimationTarget)entry.getKey();
            TargetInfo targetInfo = (TargetInfo)entry.getValue();
            for (DoublyIndexedTable.Entry entry2 : targetInfo.xmlAnimations) {
                string = (String)entry2.getKey1();
                object2 = (String)entry2.getKey2();
                object = (Sandwich)entry2.getValue();
                if (!((Sandwich)object).shouldUpdate && (((Sandwich)object).animation == null || !((Sandwich)object).animation.isDirty)) continue;
                AnimatableValue animatableValue = null;
                boolean bl2 = false;
                AbstractAnimation abstractAnimation = ((Sandwich)object).animation;
                if (abstractAnimation != null) {
                    animatableValue = abstractAnimation.getComposedValue();
                    bl2 = ((Sandwich)object).lowestAnimation.usesUnderlyingValue();
                    abstractAnimation.isDirty = false;
                }
                if (bl2 && !((Sandwich)object).listenerRegistered) {
                    animationTarget.addTargetListener(string, (String)object2, false, this.targetListener);
                    ((Sandwich)object).listenerRegistered = true;
                } else if (!bl2 && ((Sandwich)object).listenerRegistered) {
                    animationTarget.removeTargetListener(string, (String)object2, false, this.targetListener);
                    ((Sandwich)object).listenerRegistered = false;
                }
                animationTarget.updateAttributeValue(string, (String)object2, animatableValue);
                ((Sandwich)object).shouldUpdate = false;
            }
            for (Map.Entry entry3 : targetInfo.cssAnimations.entrySet()) {
                string = (String)entry3.getKey();
                object2 = (Sandwich)entry3.getValue();
                if (!((Sandwich)object2).shouldUpdate && (((Sandwich)object2).animation == null || !((Sandwich)object2).animation.isDirty)) continue;
                object = null;
                boolean bl3 = false;
                AbstractAnimation abstractAnimation = ((Sandwich)object2).animation;
                if (abstractAnimation != null) {
                    object = abstractAnimation.getComposedValue();
                    bl3 = ((Sandwich)object2).lowestAnimation.usesUnderlyingValue();
                    abstractAnimation.isDirty = false;
                }
                if (bl3 && !((Sandwich)object2).listenerRegistered) {
                    animationTarget.addTargetListener(null, string, true, this.targetListener);
                    ((Sandwich)object2).listenerRegistered = true;
                } else if (!bl3 && ((Sandwich)object2).listenerRegistered) {
                    animationTarget.removeTargetListener(null, string, true, this.targetListener);
                    ((Sandwich)object2).listenerRegistered = false;
                }
                if (bl3) {
                    animationTarget.updatePropertyValue(string, null);
                }
                if (!bl3 || object != null) {
                    animationTarget.updatePropertyValue(string, (AnimatableValue)object);
                }
                ((Sandwich)object2).shouldUpdate = false;
            }
            for (Map.Entry entry4 : targetInfo.otherAnimations.entrySet()) {
                string = (String)entry4.getKey();
                object2 = (Sandwich)entry4.getValue();
                if (!((Sandwich)object2).shouldUpdate && (((Sandwich)object2).animation == null || !((Sandwich)object2).animation.isDirty)) continue;
                object = null;
                AbstractAnimation abstractAnimation = ((Sandwich)object2).animation;
                if (abstractAnimation != null) {
                    object = ((Sandwich)object2).animation.getComposedValue();
                    abstractAnimation.isDirty = false;
                }
                animationTarget.updateOtherValue(string, (AnimatableValue)object);
                ((Sandwich)object2).shouldUpdate = false;
            }
        }
        return f2;
    }

    public void toActive(AbstractAnimation abstractAnimation, float f) {
        this.moveToTop(abstractAnimation);
        abstractAnimation.isActive = true;
        abstractAnimation.beginTime = f;
        abstractAnimation.isFrozen = false;
        this.pushDown(abstractAnimation);
        abstractAnimation.markDirty();
    }

    protected void pushDown(AbstractAnimation abstractAnimation) {
        Object object;
        Object object2;
        TimedElement timedElement = abstractAnimation.getTimedElement();
        Object object3 = null;
        boolean bl = false;
        while (abstractAnimation.lowerAnimation != null && (abstractAnimation.lowerAnimation.isActive || abstractAnimation.lowerAnimation.isFrozen) && (abstractAnimation.lowerAnimation.beginTime > abstractAnimation.beginTime || abstractAnimation.lowerAnimation.beginTime == abstractAnimation.beginTime && timedElement.isBefore(abstractAnimation.lowerAnimation.getTimedElement()))) {
            object2 = abstractAnimation.higherAnimation;
            object = abstractAnimation.lowerAnimation;
            AbstractAnimation abstractAnimation2 = ((AbstractAnimation)object).lowerAnimation;
            if (object2 != null) {
                ((AbstractAnimation)object2).lowerAnimation = object;
            }
            if (abstractAnimation2 != null) {
                abstractAnimation2.higherAnimation = abstractAnimation;
            }
            ((AbstractAnimation)object).lowerAnimation = abstractAnimation;
            ((AbstractAnimation)object).higherAnimation = object2;
            abstractAnimation.lowerAnimation = abstractAnimation2;
            abstractAnimation.higherAnimation = object;
            if (bl) continue;
            object3 = object;
            bl = true;
        }
        if (bl) {
            object2 = this.getAnimationInfo(abstractAnimation);
            object = this.getSandwich(((AnimationInfo)object2).target, ((AnimationInfo)object2).type, ((AnimationInfo)object2).attributeNamespaceURI, ((AnimationInfo)object2).attributeLocalName);
            if (((Sandwich)object).animation == abstractAnimation) {
                ((Sandwich)object).animation = object3;
            }
            if (abstractAnimation.lowerAnimation == null) {
                ((Sandwich)object).lowestAnimation = abstractAnimation;
            }
        }
    }

    public void toInactive(AbstractAnimation abstractAnimation, boolean bl) {
        abstractAnimation.isActive = false;
        abstractAnimation.isFrozen = bl;
        abstractAnimation.markDirty();
        if (!bl) {
            abstractAnimation.value = null;
            abstractAnimation.beginTime = Float.NEGATIVE_INFINITY;
            this.moveToBottom(abstractAnimation);
        }
    }

    public void removeFill(AbstractAnimation abstractAnimation) {
        abstractAnimation.isActive = false;
        abstractAnimation.isFrozen = false;
        abstractAnimation.value = null;
        abstractAnimation.markDirty();
        this.moveToBottom(abstractAnimation);
    }

    protected void moveToTop(AbstractAnimation abstractAnimation) {
        AnimationInfo animationInfo = this.getAnimationInfo(abstractAnimation);
        Sandwich sandwich = this.getSandwich(animationInfo.target, animationInfo.type, animationInfo.attributeNamespaceURI, animationInfo.attributeLocalName);
        sandwich.shouldUpdate = true;
        if (abstractAnimation.higherAnimation == null) {
            return;
        }
        if (abstractAnimation.lowerAnimation == null) {
            sandwich.lowestAnimation = abstractAnimation.higherAnimation;
        } else {
            abstractAnimation.lowerAnimation.higherAnimation = abstractAnimation.higherAnimation;
        }
        abstractAnimation.higherAnimation.lowerAnimation = abstractAnimation.lowerAnimation;
        if (sandwich.animation != null) {
            sandwich.animation.higherAnimation = abstractAnimation;
        }
        abstractAnimation.lowerAnimation = sandwich.animation;
        abstractAnimation.higherAnimation = null;
        sandwich.animation = abstractAnimation;
    }

    protected void moveToBottom(AbstractAnimation abstractAnimation) {
        if (abstractAnimation.lowerAnimation == null) {
            return;
        }
        AnimationInfo animationInfo = this.getAnimationInfo(abstractAnimation);
        Sandwich sandwich = this.getSandwich(animationInfo.target, animationInfo.type, animationInfo.attributeNamespaceURI, animationInfo.attributeLocalName);
        AbstractAnimation abstractAnimation2 = abstractAnimation.lowerAnimation;
        abstractAnimation2.markDirty();
        abstractAnimation.lowerAnimation.higherAnimation = abstractAnimation.higherAnimation;
        if (abstractAnimation.higherAnimation != null) {
            abstractAnimation.higherAnimation.lowerAnimation = abstractAnimation.lowerAnimation;
        } else {
            sandwich.animation = abstractAnimation2;
            sandwich.shouldUpdate = true;
        }
        sandwich.lowestAnimation.lowerAnimation = abstractAnimation;
        abstractAnimation.higherAnimation = sandwich.lowestAnimation;
        abstractAnimation.lowerAnimation = null;
        sandwich.lowestAnimation = abstractAnimation;
        if (sandwich.animation.isDirty) {
            sandwich.shouldUpdate = true;
        }
    }

    public void addTimegraphListener(TimegraphListener timegraphListener) {
        this.timedDocumentRoot.addTimegraphListener(timegraphListener);
    }

    public void removeTimegraphListener(TimegraphListener timegraphListener) {
        this.timedDocumentRoot.removeTimegraphListener(timegraphListener);
    }

    public void sampledAt(AbstractAnimation abstractAnimation, float f, float f2, int n) {
        abstractAnimation.sampledAt(f, f2, n);
    }

    public void sampledLastValue(AbstractAnimation abstractAnimation, int n) {
        abstractAnimation.sampledLastValue(n);
    }

    protected abstract TimedDocumentRoot createDocumentRoot();

    protected static class AnimationInfo {
        public AnimationTarget target;
        public short type;
        public String attributeNamespaceURI;
        public String attributeLocalName;

        protected AnimationInfo() {
        }
    }

    protected static class Sandwich {
        public AbstractAnimation animation;
        public AbstractAnimation lowestAnimation;
        public boolean shouldUpdate;
        public boolean listenerRegistered;

        protected Sandwich() {
        }
    }

    protected static class TargetInfo {
        public DoublyIndexedTable xmlAnimations = new DoublyIndexedTable();
        public HashMap cssAnimations = new HashMap();
        public HashMap otherAnimations = new HashMap();

        protected TargetInfo() {
        }
    }

    protected class Listener
    implements AnimationTargetListener {
        protected Listener() {
        }

        @Override
        public void baseValueChanged(AnimationTarget animationTarget, String string, String string2, boolean bl) {
            short s = bl ? (short)1 : 0;
            Sandwich sandwich = AnimationEngine.this.getSandwich(animationTarget, s, string, string2);
            sandwich.shouldUpdate = true;
            AbstractAnimation abstractAnimation = sandwich.animation;
            while (abstractAnimation.lowerAnimation != null) {
                abstractAnimation = abstractAnimation.lowerAnimation;
            }
            abstractAnimation.markDirty();
        }
    }
}

