/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.AnimatableGenericSVGBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.ComponentTransferFunction;
import org.apache.batik.ext.awt.image.ConcreteComponentTransferFunction;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.ComponentTransferRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGFeComponentTransferElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feComponentTransfer";
    }

    @Override
    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        Node node;
        Filter filter2 = SVGFeComponentTransferElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        ComponentTransferFunction componentTransferFunction = null;
        ComponentTransferFunction componentTransferFunction2 = null;
        ComponentTransferFunction componentTransferFunction3 = null;
        ComponentTransferFunction componentTransferFunction4 = null;
        for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element3;
            Bridge bridge;
            if (node.getNodeType() != 1 || (bridge = bridgeContext.getBridge(element3 = (Element)node)) == null || !(bridge instanceof SVGFeFuncElementBridge)) continue;
            SVGFeFuncElementBridge sVGFeFuncElementBridge = (SVGFeFuncElementBridge)bridge;
            ComponentTransferFunction componentTransferFunction5 = sVGFeFuncElementBridge.createComponentTransferFunction(element, element3);
            if (sVGFeFuncElementBridge instanceof SVGFeFuncRElementBridge) {
                componentTransferFunction = componentTransferFunction5;
                continue;
            }
            if (sVGFeFuncElementBridge instanceof SVGFeFuncGElementBridge) {
                componentTransferFunction2 = componentTransferFunction5;
                continue;
            }
            if (sVGFeFuncElementBridge instanceof SVGFeFuncBElementBridge) {
                componentTransferFunction3 = componentTransferFunction5;
                continue;
            }
            if (!(sVGFeFuncElementBridge instanceof SVGFeFuncAElementBridge)) continue;
            componentTransferFunction4 = componentTransferFunction5;
        }
        node = new ComponentTransferRable8Bit(filter2, componentTransferFunction4, componentTransferFunction, componentTransferFunction2, componentTransferFunction3);
        SVGFeComponentTransferElementBridge.handleColorInterpolationFilters((Filter)node, element);
        node = new PadRable8Bit((Filter)node, rectangle2D3, PadMode.ZERO_PAD);
        SVGFeComponentTransferElementBridge.updateFilterMap(element, (Filter)node, map);
        return node;
    }

    protected static abstract class SVGFeFuncElementBridge
    extends AnimatableGenericSVGBridge {
        protected SVGFeFuncElementBridge() {
        }

        public ComponentTransferFunction createComponentTransferFunction(Element element, Element element2) {
            int n = SVGFeFuncElementBridge.convertType(element2, this.ctx);
            switch (n) {
                case 2: {
                    float[] fArray = SVGFeFuncElementBridge.convertTableValues(element2, this.ctx);
                    if (fArray == null) {
                        return ConcreteComponentTransferFunction.getIdentityTransfer();
                    }
                    return ConcreteComponentTransferFunction.getDiscreteTransfer((float[])fArray);
                }
                case 0: {
                    return ConcreteComponentTransferFunction.getIdentityTransfer();
                }
                case 4: {
                    float f = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "amplitude", 1.0f, this.ctx);
                    float f2 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "exponent", 1.0f, this.ctx);
                    float f3 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "offset", 0.0f, this.ctx);
                    return ConcreteComponentTransferFunction.getGammaTransfer((float)f, (float)f2, (float)f3);
                }
                case 3: {
                    float f = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "slope", 1.0f, this.ctx);
                    float f4 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "intercept", 0.0f, this.ctx);
                    return ConcreteComponentTransferFunction.getLinearTransfer((float)f, (float)f4);
                }
                case 1: {
                    float[] fArray = SVGFeFuncElementBridge.convertTableValues(element2, this.ctx);
                    if (fArray == null) {
                        return ConcreteComponentTransferFunction.getIdentityTransfer();
                    }
                    return ConcreteComponentTransferFunction.getTableTransfer((float[])fArray);
                }
            }
            throw new Error("invalid convertType:" + n);
        }

        protected static float[] convertTableValues(Element element, BridgeContext bridgeContext) {
            String string = element.getAttributeNS(null, "tableValues");
            if (string.length() == 0) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            float[] fArray = new float[stringTokenizer.countTokens()];
            try {
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    fArray[n] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
                    ++n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"tableValues", string});
            }
            return fArray;
        }

        protected static int convertType(Element element, BridgeContext bridgeContext) {
            String string = element.getAttributeNS(null, "type");
            if (string.length() == 0) {
                throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"type"});
            }
            if ("discrete".equals(string)) {
                return 2;
            }
            if ("identity".equals(string)) {
                return 0;
            }
            if ("gamma".equals(string)) {
                return 4;
            }
            if ("linear".equals(string)) {
                return 3;
            }
            if ("table".equals(string)) {
                return 1;
            }
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"type", string});
        }
    }

    public static class SVGFeFuncBElementBridge
    extends SVGFeFuncElementBridge {
        @Override
        public String getLocalName() {
            return "feFuncB";
        }
    }

    public static class SVGFeFuncGElementBridge
    extends SVGFeFuncElementBridge {
        @Override
        public String getLocalName() {
            return "feFuncG";
        }
    }

    public static class SVGFeFuncRElementBridge
    extends SVGFeFuncElementBridge {
        @Override
        public String getLocalName() {
            return "feFuncR";
        }
    }

    public static class SVGFeFuncAElementBridge
    extends SVGFeFuncElementBridge {
        @Override
        public String getLocalName() {
            return "feFuncA";
        }
    }
}

