/* rdp-connection.c generated by valac 0.56.3, the Vala compiler
 * generated from rdp-connection.vala, do not modify */

/* rdp-connection.vala
 *
 * Copyright (C) Red Hat, Inc
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Felipe Borges <felipeborges@gnome.org>
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include "gtk-frdp.h"
#include <gio/gio.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONNECTIONS_TYPE_CONNECTION (connections_connection_get_type ())
#define CONNECTIONS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnection))
#define CONNECTIONS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnectionClass))
#define CONNECTIONS_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_CONNECTION))
#define CONNECTIONS_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_CONNECTION))
#define CONNECTIONS_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnectionClass))

typedef struct _ConnectionsConnection ConnectionsConnection;
typedef struct _ConnectionsConnectionClass ConnectionsConnectionClass;
typedef struct _ConnectionsConnectionPrivate ConnectionsConnectionPrivate;

#define CONNECTIONS_TYPE_RDP_CONNECTION (connections_rdp_connection_get_type ())
#define CONNECTIONS_RDP_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_RDP_CONNECTION, ConnectionsRdpConnection))
#define CONNECTIONS_RDP_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_RDP_CONNECTION, ConnectionsRdpConnectionClass))
#define CONNECTIONS_IS_RDP_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_RDP_CONNECTION))
#define CONNECTIONS_IS_RDP_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_RDP_CONNECTION))
#define CONNECTIONS_RDP_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_RDP_CONNECTION, ConnectionsRdpConnectionClass))

typedef struct _ConnectionsRdpConnection ConnectionsRdpConnection;
typedef struct _ConnectionsRdpConnectionClass ConnectionsRdpConnectionClass;
typedef struct _ConnectionsRdpConnectionPrivate ConnectionsRdpConnectionPrivate;

#define CONNECTIONS_TYPE_FRDP_DISPLAY (connections_frdp_display_get_type ())
#define CONNECTIONS_FRDP_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_FRDP_DISPLAY, ConnectionsFrdpDisplay))
#define CONNECTIONS_FRDP_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_FRDP_DISPLAY, ConnectionsFrdpDisplayClass))
#define CONNECTIONS_IS_FRDP_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_FRDP_DISPLAY))
#define CONNECTIONS_IS_FRDP_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_FRDP_DISPLAY))
#define CONNECTIONS_FRDP_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_FRDP_DISPLAY, ConnectionsFrdpDisplayClass))

typedef struct _ConnectionsFrdpDisplay ConnectionsFrdpDisplay;
typedef struct _ConnectionsFrdpDisplayClass ConnectionsFrdpDisplayClass;
enum  {
	CONNECTIONS_RDP_CONNECTION_0_PROPERTY,
	CONNECTIONS_RDP_CONNECTION_WIDGET_PROPERTY,
	CONNECTIONS_RDP_CONNECTION_THUMBNAIL_PROPERTY,
	CONNECTIONS_RDP_CONNECTION_SCALING_PROPERTY,
	CONNECTIONS_RDP_CONNECTION_PORT_PROPERTY,
	CONNECTIONS_RDP_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* connections_rdp_connection_properties[CONNECTIONS_RDP_CONNECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _ConnectionsFrdpDisplayPrivate ConnectionsFrdpDisplayPrivate;
enum  {
	CONNECTIONS_FRDP_DISPLAY_0_PROPERTY,
	CONNECTIONS_FRDP_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* connections_frdp_display_properties[CONNECTIONS_FRDP_DISPLAY_NUM_PROPERTIES];

struct _ConnectionsConnection {
	GObject parent_instance;
	ConnectionsConnectionPrivate * priv;
	gchar* uuid;
	gboolean connected;
	gboolean need_password;
	gboolean need_username;
};

struct _ConnectionsConnectionClass {
	GObjectClass parent_class;
	void (*send_keys) (ConnectionsConnection* self, guint* keys, gint keys_length1);
	void (*connect_it) (ConnectionsConnection* self);
	void (*disconnect_it) (ConnectionsConnection* self);
	void (*dispose_display) (ConnectionsConnection* self);
	GtkWidget* (*get_widget) (ConnectionsConnection* self);
	void (*set_widget) (ConnectionsConnection* self, GtkWidget* value);
	gboolean (*get_scaling) (ConnectionsConnection* self);
	void (*set_scaling) (ConnectionsConnection* self, gboolean value);
	gint (*get_port) (ConnectionsConnection* self);
	void (*set_port) (ConnectionsConnection* self, gint value);
	GdkPixbuf* (*get_thumbnail) (ConnectionsConnection* self);
	void (*set_thumbnail) (ConnectionsConnection* self, GdkPixbuf* value);
};

struct _ConnectionsRdpConnection {
	ConnectionsConnection parent_instance;
	ConnectionsRdpConnectionPrivate * priv;
};

struct _ConnectionsRdpConnectionClass {
	ConnectionsConnectionClass parent_class;
};

struct _ConnectionsRdpConnectionPrivate {
	ConnectionsFrdpDisplay* display;
	gint _port;
};

struct _ConnectionsFrdpDisplay {
	FrdpDisplay parent_instance;
	ConnectionsFrdpDisplayPrivate * priv;
};

struct _ConnectionsFrdpDisplayClass {
	FrdpDisplayClass parent_class;
};

static gint ConnectionsRdpConnection_private_offset;
static gpointer connections_rdp_connection_parent_class = NULL;
static gpointer connections_frdp_display_parent_class = NULL;

VALA_EXTERN GType connections_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsConnection, g_object_unref)
VALA_EXTERN GType connections_rdp_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsRdpConnection, g_object_unref)
VALA_EXTERN GType connections_frdp_display_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsFrdpDisplay, g_object_unref)
VALA_EXTERN void connections_connection_connect_it (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_disconnect_it (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_dispose_display (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_send_keys (ConnectionsConnection* self,
                                       guint* keys,
                                       gint keys_length1);
VALA_EXTERN GtkWidget* connections_connection_get_widget (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_widget (ConnectionsConnection* self,
                                        GtkWidget* value);
VALA_EXTERN GdkPixbuf* connections_connection_get_thumbnail (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_thumbnail (ConnectionsConnection* self,
                                           GdkPixbuf* value);
VALA_EXTERN gboolean connections_connection_get_scaling (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_scaling (ConnectionsConnection* self,
                                         gboolean value);
VALA_EXTERN gint connections_connection_get_port (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_port (ConnectionsConnection* self,
                                      gint value);
VALA_EXTERN ConnectionsRdpConnection* connections_rdp_connection_new (const gchar* uuid);
VALA_EXTERN ConnectionsRdpConnection* connections_rdp_connection_construct (GType object_type,
                                                                const gchar* uuid);
VALA_EXTERN ConnectionsConnection* connections_connection_construct (GType object_type);
VALA_EXTERN ConnectionsRdpConnection* connections_rdp_connection_new_from_uri (const gchar* uri);
VALA_EXTERN ConnectionsRdpConnection* connections_rdp_connection_construct_from_uri (GType object_type,
                                                                         const gchar* uri);
VALA_EXTERN void connections_connection_set_uri (ConnectionsConnection* self,
                                     const gchar* value);
static void connections_rdp_connection_real_connect_it (ConnectionsConnection* base);
VALA_EXTERN const gchar* connections_connection_get_username (ConnectionsConnection* self);
VALA_EXTERN const gchar* connections_connection_get_password (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_handle_auth (ConnectionsConnection* self);
VALA_EXTERN const gchar* connections_connection_get_host (ConnectionsConnection* self);
static void connections_rdp_connection_real_disconnect_it (ConnectionsConnection* base);
static void connections_rdp_connection_real_dispose_display (ConnectionsConnection* base);
static void connections_rdp_connection_real_send_keys (ConnectionsConnection* base,
                                                guint* keyvals,
                                                gint keyvals_length1);
static void connections_rdp_connection_on_rdp_auth_credential_cb (ConnectionsRdpConnection* self);
static void connections_rdp_connection_on_rdp_connection_error_cb (ConnectionsRdpConnection* self,
                                                            const gchar* reason);
VALA_EXTERN void connections_connection_delete_auth_credentials (ConnectionsConnection* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN void connections_connection_delete_auth_credentials_finish (ConnectionsConnection* self,
                                                            GAsyncResult* _res_);
VALA_EXTERN void connections_connection_set_password (ConnectionsConnection* self,
                                          const gchar* value);
VALA_EXTERN void connections_connection_set_username (ConnectionsConnection* self,
                                          const gchar* value);
VALA_EXTERN void connections_connection_on_connection_error_cb (ConnectionsConnection* self,
                                                    const gchar* reason);
static void connections_rdp_connection_on_rdp_connection_connected_cb (ConnectionsRdpConnection* self);
static GObject * connections_rdp_connection_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
VALA_EXTERN ConnectionsFrdpDisplay* connections_frdp_display_new (void);
VALA_EXTERN ConnectionsFrdpDisplay* connections_frdp_display_construct (GType object_type);
static void _connections_rdp_connection_on_rdp_connection_error_cb_frdp_display_rdp_error (FrdpDisplay* _sender,
                                                                                    const gchar* object,
                                                                                    gpointer self);
static void _connections_rdp_connection_on_rdp_connection_connected_cb_frdp_display_rdp_connected (FrdpDisplay* _sender,
                                                                                            gpointer self);
VALA_EXTERN void connections_connection_auth_failed (ConnectionsConnection* self,
                                         const gchar* reason);
static void _connections_connection_auth_failed_frdp_display_rdp_auth_failure (FrdpDisplay* _sender,
                                                                        const gchar* object,
                                                                        gpointer self);
static void connections_rdp_connection_finalize (GObject * obj);
static GType connections_rdp_connection_get_type_once (void);
static void _vala_connections_rdp_connection_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_connections_rdp_connection_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static gboolean connections_frdp_display_real_authenticate (FrdpDisplay* base,
                                                     gchar** username,
                                                     gchar** password,
                                                     gchar** domain);
static GType connections_frdp_display_get_type_once (void);

static inline gpointer
connections_rdp_connection_get_instance_private (ConnectionsRdpConnection* self)
{
	return G_STRUCT_MEMBER_P (self, ConnectionsRdpConnection_private_offset);
}

ConnectionsRdpConnection*
connections_rdp_connection_construct (GType object_type,
                                      const gchar* uuid)
{
	ConnectionsRdpConnection * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (ConnectionsRdpConnection*) connections_connection_construct (object_type);
	_tmp0_ = g_strdup (uuid);
	_g_free0 (((ConnectionsConnection*) self)->uuid);
	((ConnectionsConnection*) self)->uuid = _tmp0_;
	return self;
}

ConnectionsRdpConnection*
connections_rdp_connection_new (const gchar* uuid)
{
	return connections_rdp_connection_construct (CONNECTIONS_TYPE_RDP_CONNECTION, uuid);
}

ConnectionsRdpConnection*
connections_rdp_connection_construct_from_uri (GType object_type,
                                               const gchar* uri)
{
	ConnectionsRdpConnection * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (ConnectionsRdpConnection*) connections_connection_construct (object_type);
	_tmp0_ = g_uuid_string_random ();
	_g_free0 (((ConnectionsConnection*) self)->uuid);
	((ConnectionsConnection*) self)->uuid = _tmp0_;
	connections_connection_set_uri ((ConnectionsConnection*) self, uri);
	return self;
}

ConnectionsRdpConnection*
connections_rdp_connection_new_from_uri (const gchar* uri)
{
	return connections_rdp_connection_construct_from_uri (CONNECTIONS_TYPE_RDP_CONNECTION, uri);
}

static void
connections_rdp_connection_real_connect_it (ConnectionsConnection* base)
{
	ConnectionsRdpConnection * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ConnectionsFrdpDisplay* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	self = (ConnectionsRdpConnection*) base;
	if (((ConnectionsConnection*) self)->connected) {
		g_signal_emit_by_name ((ConnectionsConnection*) self, "show");
		return;
	}
	_tmp1_ = connections_connection_get_username ((ConnectionsConnection*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = connections_connection_get_password ((ConnectionsConnection*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		connections_connection_handle_auth ((ConnectionsConnection*) self);
		return;
	}
	_tmp5_ = self->priv->display;
	_tmp6_ = connections_connection_get_host ((ConnectionsConnection*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = connections_connection_get_port ((ConnectionsConnection*) self);
	_tmp9_ = _tmp8_;
	frdp_display_open_host ((FrdpDisplay*) _tmp5_, _tmp7_, (guint) _tmp9_);
}

static void
connections_rdp_connection_real_disconnect_it (ConnectionsConnection* base)
{
	ConnectionsRdpConnection * self;
	self = (ConnectionsRdpConnection*) base;
	if (((ConnectionsConnection*) self)->connected) {
		ConnectionsFrdpDisplay* _tmp0_;
		_tmp0_ = self->priv->display;
		frdp_display_close ((FrdpDisplay*) _tmp0_);
	}
	((ConnectionsConnection*) self)->connected = FALSE;
}

static void
connections_rdp_connection_real_dispose_display (ConnectionsConnection* base)
{
	ConnectionsRdpConnection * self;
	self = (ConnectionsRdpConnection*) base;
}

static void
connections_rdp_connection_real_send_keys (ConnectionsConnection* base,
                                           guint* keyvals,
                                           gint keyvals_length1)
{
	ConnectionsRdpConnection * self;
	self = (ConnectionsRdpConnection*) base;
}

static void
connections_rdp_connection_on_rdp_auth_credential_cb (ConnectionsRdpConnection* self)
{
	g_return_if_fail (self != NULL);
	((ConnectionsConnection*) self)->need_password = TRUE;
	((ConnectionsConnection*) self)->need_username = ((ConnectionsConnection*) self)->need_password;
	connections_connection_handle_auth ((ConnectionsConnection*) self);
}

static void
connections_rdp_connection_on_rdp_connection_error_cb (ConnectionsRdpConnection* self,
                                                       const gchar* reason)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (reason != NULL);
	connections_connection_disconnect_it ((ConnectionsConnection*) self);
	connections_connection_delete_auth_credentials ((ConnectionsConnection*) self, NULL, NULL);
	connections_connection_set_password ((ConnectionsConnection*) self, NULL);
	connections_connection_set_username ((ConnectionsConnection*) self, NULL);
	connections_connection_on_connection_error_cb ((ConnectionsConnection*) self, reason);
}

static void
connections_rdp_connection_on_rdp_connection_connected_cb (ConnectionsRdpConnection* self)
{
	ConnectionsFrdpDisplay* _tmp0_;
	g_return_if_fail (self != NULL);
	((ConnectionsConnection*) self)->connected = TRUE;
	connections_connection_set_scaling ((ConnectionsConnection*) self, TRUE);
	_tmp0_ = self->priv->display;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	g_signal_emit_by_name ((ConnectionsConnection*) self, "show");
}

static GtkWidget*
connections_rdp_connection_real_get_widget (ConnectionsConnection* base)
{
	GtkWidget* result;
	ConnectionsRdpConnection* self;
	ConnectionsFrdpDisplay* _tmp0_;
	self = (ConnectionsRdpConnection*) base;
	_tmp0_ = self->priv->display;
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp0_) : NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
connections_rdp_connection_real_set_widget (ConnectionsConnection* base,
                                            GtkWidget* value)
{
	ConnectionsRdpConnection* self;
	ConnectionsFrdpDisplay* _tmp0_;
	self = (ConnectionsRdpConnection*) base;
	_tmp0_ = _g_object_ref0 (CONNECTIONS_IS_FRDP_DISPLAY (value) ? ((ConnectionsFrdpDisplay*) value) : NULL);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, connections_rdp_connection_properties[CONNECTIONS_RDP_CONNECTION_WIDGET_PROPERTY]);
}

static GdkPixbuf*
connections_rdp_connection_real_get_thumbnail (ConnectionsConnection* base)
{
	GdkPixbuf* result;
	ConnectionsRdpConnection* self;
	GtkAllocation alloc = {0};
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkAllocation _tmp2_ = {0};
	cairo_surface_t* surface = NULL;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_t* context = NULL;
	cairo_t* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GtkAllocation _tmp10_;
	GtkAllocation _tmp11_;
	GdkPixbuf* _tmp12_;
	self = (ConnectionsRdpConnection*) base;
	_tmp0_ = connections_connection_get_widget ((ConnectionsConnection*) self);
	_tmp1_ = _tmp0_;
	gtk_widget_get_allocation (_tmp1_, &_tmp2_);
	alloc = _tmp2_;
	_tmp3_ = alloc;
	_tmp4_ = alloc;
	_tmp5_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp3_.width, _tmp4_.height);
	surface = _tmp5_;
	_tmp6_ = cairo_create (surface);
	context = _tmp6_;
	_tmp7_ = connections_connection_get_widget ((ConnectionsConnection*) self);
	_tmp8_ = _tmp7_;
	g_signal_emit_by_name (_tmp8_, "draw", context, &_tmp9_);
	_tmp10_ = alloc;
	_tmp11_ = alloc;
	_tmp12_ = gdk_pixbuf_get_from_surface (surface, 0, 0, _tmp10_.width, _tmp11_.height);
	result = _tmp12_;
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
	return result;
}

static void
connections_rdp_connection_real_set_thumbnail (ConnectionsConnection* base,
                                               GdkPixbuf* value)
{
	ConnectionsRdpConnection* self;
	self = (ConnectionsRdpConnection*) base;
	return;
}

static gboolean
connections_rdp_connection_real_get_scaling (ConnectionsConnection* base)
{
	gboolean result;
	ConnectionsRdpConnection* self;
	ConnectionsFrdpDisplay* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (ConnectionsRdpConnection*) base;
	if (!((ConnectionsConnection*) self)->connected) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->display;
	g_object_get ((FrdpDisplay*) _tmp0_, "scaling", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
connections_rdp_connection_real_set_scaling (ConnectionsConnection* base,
                                             gboolean value)
{
	ConnectionsRdpConnection* self;
	ConnectionsFrdpDisplay* _tmp0_;
	self = (ConnectionsRdpConnection*) base;
	_tmp0_ = self->priv->display;
	frdp_display_set_scaling ((FrdpDisplay*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, connections_rdp_connection_properties[CONNECTIONS_RDP_CONNECTION_SCALING_PROPERTY]);
}

static gint
connections_rdp_connection_real_get_port (ConnectionsConnection* base)
{
	gint result;
	ConnectionsRdpConnection* self;
	self = (ConnectionsRdpConnection*) base;
	result = self->priv->_port;
	return result;
}

static void
connections_rdp_connection_real_set_port (ConnectionsConnection* base,
                                          gint value)
{
	ConnectionsRdpConnection* self;
	gint old_value;
	self = (ConnectionsRdpConnection*) base;
	old_value = connections_rdp_connection_real_get_port (base);
	if (old_value != value) {
		self->priv->_port = value;
		g_object_notify_by_pspec ((GObject *) self, connections_rdp_connection_properties[CONNECTIONS_RDP_CONNECTION_PORT_PROPERTY]);
	}
}

static void
_connections_rdp_connection_on_rdp_connection_error_cb_frdp_display_rdp_error (FrdpDisplay* _sender,
                                                                               const gchar* object,
                                                                               gpointer self)
{
	connections_rdp_connection_on_rdp_connection_error_cb ((ConnectionsRdpConnection*) self, object);
}

static void
_connections_rdp_connection_on_rdp_connection_connected_cb_frdp_display_rdp_connected (FrdpDisplay* _sender,
                                                                                       gpointer self)
{
	connections_rdp_connection_on_rdp_connection_connected_cb ((ConnectionsRdpConnection*) self);
}

static void
_connections_connection_auth_failed_frdp_display_rdp_auth_failure (FrdpDisplay* _sender,
                                                                   const gchar* object,
                                                                   gpointer self)
{
	connections_connection_auth_failed ((ConnectionsConnection*) self, object);
}

static GObject *
connections_rdp_connection_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ConnectionsRdpConnection * self;
	ConnectionsFrdpDisplay* _tmp0_;
	ConnectionsFrdpDisplay* _tmp1_;
	ConnectionsFrdpDisplay* _tmp2_;
	ConnectionsFrdpDisplay* _tmp3_;
	ConnectionsFrdpDisplay* _tmp4_;
	ConnectionsFrdpDisplay* _tmp5_;
	ConnectionsFrdpDisplay* _tmp6_;
	ConnectionsFrdpDisplay* _tmp7_;
	parent_class = G_OBJECT_CLASS (connections_rdp_connection_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_RDP_CONNECTION, ConnectionsRdpConnection);
	_tmp0_ = connections_frdp_display_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp0_;
	_tmp1_ = self->priv->display;
	_tmp2_ = self->priv->display;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp3_ = self->priv->display;
	g_object_bind_property_with_closures ((GObject*) _tmp3_, "username", (GObject*) self, "username", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = self->priv->display;
	g_object_bind_property_with_closures ((GObject*) _tmp4_, "password", (GObject*) self, "password", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = self->priv->display;
	g_signal_connect_object ((FrdpDisplay*) _tmp5_, "rdp-error", (GCallback) _connections_rdp_connection_on_rdp_connection_error_cb_frdp_display_rdp_error, self, 0);
	_tmp6_ = self->priv->display;
	g_signal_connect_object ((FrdpDisplay*) _tmp6_, "rdp-connected", (GCallback) _connections_rdp_connection_on_rdp_connection_connected_cb_frdp_display_rdp_connected, self, 0);
	_tmp7_ = self->priv->display;
	g_signal_connect_object ((FrdpDisplay*) _tmp7_, "rdp-auth-failure", (GCallback) _connections_connection_auth_failed_frdp_display_rdp_auth_failure, (ConnectionsConnection*) self, 0);
	((ConnectionsConnection*) self)->need_password = TRUE;
	((ConnectionsConnection*) self)->need_username = ((ConnectionsConnection*) self)->need_password;
	return obj;
}

static void
connections_rdp_connection_class_init (ConnectionsRdpConnectionClass * klass,
                                       gpointer klass_data)
{
	connections_rdp_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConnectionsRdpConnection_private_offset);
	((ConnectionsConnectionClass *) klass)->connect_it = (void (*) (ConnectionsConnection*)) connections_rdp_connection_real_connect_it;
	((ConnectionsConnectionClass *) klass)->disconnect_it = (void (*) (ConnectionsConnection*)) connections_rdp_connection_real_disconnect_it;
	((ConnectionsConnectionClass *) klass)->dispose_display = (void (*) (ConnectionsConnection*)) connections_rdp_connection_real_dispose_display;
	((ConnectionsConnectionClass *) klass)->send_keys = (void (*) (ConnectionsConnection*, guint*, gint)) connections_rdp_connection_real_send_keys;
	CONNECTIONS_CONNECTION_CLASS (klass)->get_widget = connections_rdp_connection_real_get_widget;
	CONNECTIONS_CONNECTION_CLASS (klass)->set_widget = connections_rdp_connection_real_set_widget;
	CONNECTIONS_CONNECTION_CLASS (klass)->get_thumbnail = connections_rdp_connection_real_get_thumbnail;
	CONNECTIONS_CONNECTION_CLASS (klass)->set_thumbnail = connections_rdp_connection_real_set_thumbnail;
	CONNECTIONS_CONNECTION_CLASS (klass)->get_scaling = connections_rdp_connection_real_get_scaling;
	CONNECTIONS_CONNECTION_CLASS (klass)->set_scaling = connections_rdp_connection_real_set_scaling;
	CONNECTIONS_CONNECTION_CLASS (klass)->get_port = connections_rdp_connection_real_get_port;
	CONNECTIONS_CONNECTION_CLASS (klass)->set_port = connections_rdp_connection_real_set_port;
	G_OBJECT_CLASS (klass)->get_property = _vala_connections_rdp_connection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_connections_rdp_connection_set_property;
	G_OBJECT_CLASS (klass)->constructor = connections_rdp_connection_constructor;
	G_OBJECT_CLASS (klass)->finalize = connections_rdp_connection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_RDP_CONNECTION_WIDGET_PROPERTY, connections_rdp_connection_properties[CONNECTIONS_RDP_CONNECTION_WIDGET_PROPERTY] = g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_RDP_CONNECTION_THUMBNAIL_PROPERTY, connections_rdp_connection_properties[CONNECTIONS_RDP_CONNECTION_THUMBNAIL_PROPERTY] = g_param_spec_object ("thumbnail", "thumbnail", "thumbnail", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_RDP_CONNECTION_SCALING_PROPERTY, connections_rdp_connection_properties[CONNECTIONS_RDP_CONNECTION_SCALING_PROPERTY] = g_param_spec_boolean ("scaling", "scaling", "scaling", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_RDP_CONNECTION_PORT_PROPERTY, connections_rdp_connection_properties[CONNECTIONS_RDP_CONNECTION_PORT_PROPERTY] = g_param_spec_int ("port", "port", "port", G_MININT, G_MAXINT, 3389, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
connections_rdp_connection_instance_init (ConnectionsRdpConnection * self,
                                          gpointer klass)
{
	self->priv = connections_rdp_connection_get_instance_private (self);
	self->priv->_port = 3389;
}

static void
connections_rdp_connection_finalize (GObject * obj)
{
	ConnectionsRdpConnection * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_RDP_CONNECTION, ConnectionsRdpConnection);
	_tmp0_ = connections_connection_get_widget ((ConnectionsConnection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_widget_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("rdp-connection.vala:92: Closing connection with %s", _tmp3_);
	connections_connection_disconnect_it ((ConnectionsConnection*) self);
	_g_object_unref0 (self->priv->display);
	G_OBJECT_CLASS (connections_rdp_connection_parent_class)->finalize (obj);
}

static GType
connections_rdp_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConnectionsRdpConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) connections_rdp_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConnectionsRdpConnection), 0, (GInstanceInitFunc) connections_rdp_connection_instance_init, NULL };
	GType connections_rdp_connection_type_id;
	connections_rdp_connection_type_id = g_type_register_static (CONNECTIONS_TYPE_CONNECTION, "ConnectionsRdpConnection", &g_define_type_info, 0);
	ConnectionsRdpConnection_private_offset = g_type_add_instance_private (connections_rdp_connection_type_id, sizeof (ConnectionsRdpConnectionPrivate));
	return connections_rdp_connection_type_id;
}

GType
connections_rdp_connection_get_type (void)
{
	static volatile gsize connections_rdp_connection_type_id__once = 0;
	if (g_once_init_enter (&connections_rdp_connection_type_id__once)) {
		GType connections_rdp_connection_type_id;
		connections_rdp_connection_type_id = connections_rdp_connection_get_type_once ();
		g_once_init_leave (&connections_rdp_connection_type_id__once, connections_rdp_connection_type_id);
	}
	return connections_rdp_connection_type_id__once;
}

static void
_vala_connections_rdp_connection_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	ConnectionsRdpConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONNECTIONS_TYPE_RDP_CONNECTION, ConnectionsRdpConnection);
	switch (property_id) {
		case CONNECTIONS_RDP_CONNECTION_WIDGET_PROPERTY:
		g_value_set_object (value, connections_connection_get_widget ((ConnectionsConnection*) self));
		break;
		case CONNECTIONS_RDP_CONNECTION_THUMBNAIL_PROPERTY:
		g_value_take_object (value, connections_connection_get_thumbnail ((ConnectionsConnection*) self));
		break;
		case CONNECTIONS_RDP_CONNECTION_SCALING_PROPERTY:
		g_value_set_boolean (value, connections_connection_get_scaling ((ConnectionsConnection*) self));
		break;
		case CONNECTIONS_RDP_CONNECTION_PORT_PROPERTY:
		g_value_set_int (value, connections_connection_get_port ((ConnectionsConnection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_connections_rdp_connection_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	ConnectionsRdpConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONNECTIONS_TYPE_RDP_CONNECTION, ConnectionsRdpConnection);
	switch (property_id) {
		case CONNECTIONS_RDP_CONNECTION_WIDGET_PROPERTY:
		connections_connection_set_widget ((ConnectionsConnection*) self, g_value_get_object (value));
		break;
		case CONNECTIONS_RDP_CONNECTION_THUMBNAIL_PROPERTY:
		connections_connection_set_thumbnail ((ConnectionsConnection*) self, g_value_get_object (value));
		break;
		case CONNECTIONS_RDP_CONNECTION_SCALING_PROPERTY:
		connections_connection_set_scaling ((ConnectionsConnection*) self, g_value_get_boolean (value));
		break;
		case CONNECTIONS_RDP_CONNECTION_PORT_PROPERTY:
		connections_connection_set_port ((ConnectionsConnection*) self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gboolean
connections_frdp_display_real_authenticate (FrdpDisplay* base,
                                            gchar** username,
                                            gchar** password,
                                            gchar** domain)
{
	ConnectionsFrdpDisplay * self;
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	gchar* _vala_domain = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean result;
	self = (ConnectionsFrdpDisplay*) base;
	g_object_get ((FrdpDisplay*) self, "username", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_g_free0 (_vala_username);
	_vala_username = _tmp1_;
	g_object_get ((FrdpDisplay*) self, "password", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_vala_password);
	_vala_password = _tmp3_;
	_g_free0 (_vala_domain);
	_vala_domain = NULL;
	result = TRUE;
	if (username) {
		*username = _vala_username;
	} else {
		_g_free0 (_vala_username);
	}
	if (password) {
		*password = _vala_password;
	} else {
		_g_free0 (_vala_password);
	}
	if (domain) {
		*domain = _vala_domain;
	} else {
		_g_free0 (_vala_domain);
	}
	return result;
}

ConnectionsFrdpDisplay*
connections_frdp_display_construct (GType object_type)
{
	ConnectionsFrdpDisplay * self = NULL;
	self = (ConnectionsFrdpDisplay*) g_object_new (object_type, NULL);
	return self;
}

ConnectionsFrdpDisplay*
connections_frdp_display_new (void)
{
	return connections_frdp_display_construct (CONNECTIONS_TYPE_FRDP_DISPLAY);
}

static void
connections_frdp_display_class_init (ConnectionsFrdpDisplayClass * klass,
                                     gpointer klass_data)
{
	connections_frdp_display_parent_class = g_type_class_peek_parent (klass);
	((FrdpDisplayClass *) klass)->authenticate = (gboolean (*) (FrdpDisplay*, gchar**, gchar**, gchar**)) connections_frdp_display_real_authenticate;
}

static void
connections_frdp_display_instance_init (ConnectionsFrdpDisplay * self,
                                        gpointer klass)
{
}

static GType
connections_frdp_display_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConnectionsFrdpDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) connections_frdp_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConnectionsFrdpDisplay), 0, (GInstanceInitFunc) connections_frdp_display_instance_init, NULL };
	GType connections_frdp_display_type_id;
	connections_frdp_display_type_id = g_type_register_static (frdp_display_get_type (), "ConnectionsFrdpDisplay", &g_define_type_info, 0);
	return connections_frdp_display_type_id;
}

GType
connections_frdp_display_get_type (void)
{
	static volatile gsize connections_frdp_display_type_id__once = 0;
	if (g_once_init_enter (&connections_frdp_display_type_id__once)) {
		GType connections_frdp_display_type_id;
		connections_frdp_display_type_id = connections_frdp_display_get_type_once ();
		g_once_init_leave (&connections_frdp_display_type_id__once, connections_frdp_display_type_id);
	}
	return connections_frdp_display_type_id__once;
}

