/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandStereotype
extends SingleLineCommand2<ClassDiagram> {
    public CommandStereotype() {
        super(CommandStereotype.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandStereotype.class.getName(), RegexLeaf.start(), new RegexLeaf("NAME", "([%pLN_.]+|[%g][^%g]+[%g])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.*\\>\\>)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String name = arg.get("NAME", 0);
        Ident ident = diagram.buildLeafIdent(name);
        Ident code = diagram.V1972() ? ident : diagram.buildCode(name);
        String stereotype = arg.get("STEREO", 0);
        ILeaf entity = diagram.getOrCreateLeaf(ident, code, null, null);
        entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        return CommandExecutionResult.ok();
    }
}

