/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.atom;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class Bullet
extends AbstractAtom
implements Atom {
    private final FontConfiguration fontConfiguration;
    private final int order;

    public Bullet(FontConfiguration fontConfiguration, int order) {
        this.fontConfiguration = fontConfiguration;
        this.order = order;
    }

    @Override
    public void drawU(UGraphic ug) {
        HColor color = this.fontConfiguration.getColor();
        ug = ug.apply(color).apply(color.bg()).apply(new UStroke(0.0));
        if (this.order == 0) {
            ug = ug.apply(UTranslate.dx(3.0));
            ug.draw(new UEllipse(5.0, 5.0));
        } else {
            ug = ug.apply(UTranslate.dx(1 + 8 * this.order));
            ug.draw(new URectangle(3.5, 3.5));
        }
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        if (this.order == 0) {
            return new XDimension2D(12.0, 5.0);
        }
        return new XDimension2D(8 + 8 * this.order, 3.0);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        if (this.order == 0) {
            return -5.0;
        }
        return -7.0;
    }
}

