/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.ebnf.CharIterator;

class CharIteratorImpl
implements CharIterator {
    private final BlocLines data;
    private int line = 0;
    private int pos = 0;

    public CharIteratorImpl(BlocLines input) {
        this.data = input;
    }

    @Override
    public char peek(int ahead) {
        if (this.line == -1) {
            return '\u0000';
        }
        String currentLine = this.getCurrentLine();
        if (this.pos + ahead >= currentLine.length()) {
            return '\u0000';
        }
        return currentLine.charAt(this.pos + ahead);
    }

    private String getCurrentLine() {
        return this.data.getAt(this.line).getTrimmed().getString();
    }

    @Override
    public void next() {
        if (this.line == -1) {
            throw new IllegalStateException();
        }
        ++this.pos;
        if (this.pos >= this.getCurrentLine().length()) {
            ++this.line;
            this.pos = 0;
        }
        while (this.line < this.data.size() && this.getCurrentLine().length() == 0) {
            ++this.line;
        }
        if (this.line >= this.data.size()) {
            this.line = -1;
        }
    }
}

