/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.ebnf.CornerCurved;
import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.ebnf.ETileAlternation;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ETileZeroOrMore
extends ETile {
    private final double deltax;
    private final double deltay = 20.0;
    private final ETile orig;
    private final boolean specialForAlternate;

    public ETileZeroOrMore(ETile orig) {
        this.orig = orig;
        this.specialForAlternate = orig instanceof ETileAlternation;
        double d = this.deltax = this.specialForAlternate ? 0.0 : 20.0;
        if (this.specialForAlternate) {
            ((ETileAlternation)orig).setInZeroOrMore(true);
        }
    }

    @Override
    public double getH1(StringBounder stringBounder) {
        return 10.0;
    }

    @Override
    public double getH2(StringBounder stringBounder) {
        return 10.0 + this.orig.getH1(stringBounder) + this.orig.getH2(stringBounder);
    }

    @Override
    public double getWidth(StringBounder stringBounder) {
        return this.orig.getWidth(stringBounder) + 2.0 * this.deltax;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D fullDim = this.calculateDimension(stringBounder);
        double linePos = this.getH1(stringBounder);
        this.drawHline(ug, linePos, 0.0, fullDim.getWidth());
        double corner = 12.0;
        if (this.specialForAlternate) {
            CornerCurved.createNE_arrow(12.0).drawU(ug.apply(new UTranslate(12.0, linePos)));
            CornerCurved.createNW(12.0).drawU(ug.apply(new UTranslate(12.0, linePos)));
            double posB = fullDim.getWidth() - 12.0;
            CornerCurved.createNW_arrow(12.0).drawU(ug.apply(new UTranslate(posB, linePos)));
            CornerCurved.createNE(12.0).drawU(ug.apply(new UTranslate(posB, linePos)));
        } else {
            CornerCurved.createNE_arrow(12.0).drawU(ug.apply(new UTranslate(this.deltax - 12.0, linePos)));
            CornerCurved.createNW(12.0).drawU(ug.apply(new UTranslate(this.deltax - 12.0, linePos)));
            this.drawVline(ug, this.deltax - 12.0, linePos + 12.0, 20.0 + this.orig.getH1(stringBounder) - 12.0);
            CornerCurved.createSW(12.0).drawU(ug.apply(new UTranslate(this.deltax - 12.0, 20.0 + this.orig.getH1(stringBounder))));
            double posB = fullDim.getWidth() - this.deltax + 12.0;
            CornerCurved.createSE(12.0).drawU(ug.apply(new UTranslate(posB, 20.0 + this.orig.getH1(stringBounder))));
            this.drawVline(ug, posB, linePos + 12.0, 20.0 + this.orig.getH1(stringBounder) - 12.0);
            CornerCurved.createNW_arrow(12.0).drawU(ug.apply(new UTranslate(posB, linePos)));
            CornerCurved.createNE(12.0).drawU(ug.apply(new UTranslate(posB, linePos)));
        }
        this.orig.drawU(ug.apply(new UTranslate(this.deltax, 20.0)));
    }

    @Override
    public void push(ETile tile) {
        throw new UnsupportedOperationException();
    }
}

