/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.logo;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColors;

class TurtleGraphicsPane {
    private final double width;
    private final double height;
    private double x;
    private double y;
    private double turtleDirection = 90.0;
    private boolean penIsDown = true;
    private boolean showTurtle = true;
    private HColor penColor = HColors.BLACK;
    private List<Rectangle2D.Double> lines = new ArrayList<Rectangle2D.Double>();
    private List<HColor> colors = new ArrayList<HColor>();
    private String message;

    public TurtleGraphicsPane(int width, int height) {
        this.width = width;
        this.height = height;
        this.clearScreen();
    }

    public void clearScreen() {
        this.x = this.width / 2.0;
        this.y = -this.height / 2.0;
        this.turtleDirection = 90.0;
        this.lines.clear();
        this.colors.clear();
    }

    private double dtor(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    private void drawTurtle(UGraphic ug) {
        if (!this.showTurtle) {
            return;
        }
        UPolygon poly = new UPolygon();
        double size = 2.0;
        double deltax = 4.5 * size;
        poly.addPoint(0.0 * size - deltax, 0.0);
        poly.addPoint(0.0 * size - deltax, -2.0 * size);
        poly.addPoint(1.0 * size - deltax, -2.0 * size);
        poly.addPoint(1.0 * size - deltax, -4.0 * size);
        poly.addPoint(2.0 * size - deltax, -4.0 * size);
        poly.addPoint(2.0 * size - deltax, -6.0 * size);
        poly.addPoint(3.0 * size - deltax, -6.0 * size);
        poly.addPoint(3.0 * size - deltax, -8.0 * size);
        poly.addPoint(4.0 * size - deltax, -8.0 * size);
        poly.addPoint(4.0 * size - deltax, -9.0 * size);
        poly.addPoint(5.0 * size - deltax, -9.0 * size);
        poly.addPoint(5.0 * size - deltax, -8.0 * size);
        poly.addPoint(6.0 * size - deltax, -8.0 * size);
        poly.addPoint(6.0 * size - deltax, -6.0 * size);
        poly.addPoint(7.0 * size - deltax, -6.0 * size);
        poly.addPoint(7.0 * size - deltax, -4.0 * size);
        poly.addPoint(8.0 * size - deltax, -4.0 * size);
        poly.addPoint(8.0 * size - deltax, -2.0 * size);
        poly.addPoint(9.0 * size - deltax, -2.0 * size);
        poly.addPoint(9.0 * size - deltax, 0.0);
        poly.addPoint(0.0 * size - deltax, 0.0);
        double angle = -this.dtor(this.turtleDirection - 90.0);
        poly.rotate(angle);
        HColorSet htmlColorSet = HColorSet.instance();
        HColor turtleColor1 = htmlColorSet.getColorOrWhite("OliveDrab");
        HColor turtleColor2 = htmlColorSet.getColorOrWhite("MediumSpringGreen");
        ug.apply(turtleColor1).apply(turtleColor2.bg()).apply(new UTranslate(this.x, -this.y)).draw(poly);
    }

    public void showTurtle() {
        this.showTurtle = true;
    }

    public void hideTurtle() {
        this.showTurtle = false;
    }

    public void setPenColor(HColor newPenColor) {
        this.penColor = newPenColor;
    }

    void addLine(double x1, double y1, double x2, double y2) {
        this.lines.add(new Rectangle2D.Double(x1, y1, x2, y2));
        this.colors.add(this.penColor);
    }

    public void forward(double distance) {
        double angle = this.dtor(this.turtleDirection);
        double newX = this.x + distance * Math.cos(angle);
        double newY = this.y + distance * Math.sin(angle);
        if (this.penIsDown) {
            this.addLine(this.x, this.y, newX, newY);
            this.x = newX;
            this.y = newY;
        } else {
            this.x = newX;
            this.y = newY;
        }
    }

    public void back(double distance) {
        this.forward(-distance);
    }

    public void left(double turnAngle) {
        this.turtleDirection += turnAngle;
        while (this.turtleDirection > 360.0) {
            this.turtleDirection -= 360.0;
        }
        while (this.turtleDirection < 0.0) {
            this.turtleDirection += 360.0;
        }
    }

    public void right(double turnAngle) {
        this.left(-turnAngle);
    }

    public void penUp() {
        this.penIsDown = false;
    }

    public void penDown() {
        this.penIsDown = true;
    }

    public void paint(UGraphic ug) {
        int n = this.lines.size();
        for (int i = 0; i < n; ++i) {
            HColor color = this.colors.get(i);
            Rectangle2D.Double r = this.lines.get(i);
            ULine line = new ULine(r.width - r.x, -r.height + r.y);
            ug.apply(color).apply(new UTranslate(r.x, -r.y)).draw(line);
        }
        this.drawTurtle(ug);
        if (this.message != null) {
            FontConfiguration font = FontConfiguration.blackBlueTrue(new UFont("", 0, 14));
            TextBlock text = Display.create(this.message).create(font, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            XDimension2D dim = text.calculateDimension(ug.getStringBounder());
            double textHeight = dim.getHeight();
            text.drawU(ug.apply(UTranslate.dy(this.height - textHeight)));
        }
    }

    public void message(String messageText) {
        this.message = messageText;
    }
}

