/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class Reference
extends AbstractEvent
implements Event {
    private final List<Participant> participants;
    private final Url url;
    private final HColor backColorGeneral;
    private final HColor backColorElement;
    private final Display strings;
    private final Style style;
    private final Style styleHeader;

    public StyleSignatureBasic getDefaultStyleDefinition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.reference);
    }

    private StyleSignatureBasic getHeaderStyleDefinition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.referenceHeader);
    }

    public Style[] getUsedStyles() {
        return new Style[]{this.style, this.styleHeader == null ? this.styleHeader : this.styleHeader.eventuallyOverride(PName.BackGroundColor, this.backColorElement)};
    }

    public Reference(List<Participant> participants, Url url, Display strings, HColor backColorGeneral, HColor backColorElement, StyleBuilder styleBuilder) {
        this.participants = Reference.uniq(participants);
        this.url = url;
        this.strings = strings;
        this.backColorGeneral = backColorGeneral;
        this.backColorElement = backColorElement;
        this.style = this.getDefaultStyleDefinition().getMergedStyle(styleBuilder);
        this.styleHeader = this.getHeaderStyleDefinition().getMergedStyle(styleBuilder);
    }

    private static List<Participant> uniq(List<Participant> all) {
        ArrayList<Participant> result = new ArrayList<Participant>();
        for (Participant p : all) {
            if (result.contains(p)) continue;
            result.add(p);
        }
        return Collections.unmodifiableList(result);
    }

    public List<Participant> getParticipant() {
        return this.participants;
    }

    public Display getStrings() {
        return this.strings;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return this.participants.contains(someone);
    }

    @Override
    public final Url getUrl() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        return this.url != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Participant> it = this.participants.iterator();
        while (it.hasNext()) {
            sb.append(it.next().getCode());
            if (!it.hasNext()) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public final HColor getBackColorGeneral() {
        return this.backColorGeneral;
    }

    public final HColor getBackColorElement() {
        return this.backColorElement;
    }
}

