/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandActivate
extends SingleLineCommand2<SequenceDiagram> {
    public CommandActivate() {
        super(CommandActivate.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandActivate.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "(activate|deactivate|destroy|create)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("WHO", "([%pLN_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("BACK", "(#\\w+)?"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("LINE", "(#\\w+)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String line;
        HColor lineColor;
        String back;
        HColor backColor;
        LifeEventType type = LifeEventType.valueOf(StringUtils.goUpperCase(arg.get("TYPE", 0)));
        Participant p = diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("WHO", 0)));
        String error = diagram.activate(p, type, backColor = (back = arg.get("BACK", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(back), lineColor = (line = arg.get("LINE", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(line));
        if (error == null) {
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error(error);
    }
}

