/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ComponentRoseDivider
extends AbstractTextualComponent {
    private final HColor borderColor;
    private final HColor background;
    private final boolean empty;
    private final double shadow;
    private final UStroke stroke;
    private final double roundCorner;

    public ComponentRoseDivider(Style style, Display stringsToDisplay, ISkinSimple spriteContainer) {
        super(style, LineBreakStrategy.NONE, 4, 4, 4, spriteContainer, stringsToDisplay, false);
        this.background = style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
        this.borderColor = style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
        this.stroke = style.getStroke();
        this.roundCorner = style.value(PName.RoundCorner).asInt();
        this.shadow = style.value(PName.Shadowing).asDouble();
        this.empty = stringsToDisplay.get(0).length() == 0;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        ug = ug.apply(this.background.bg());
        if (this.empty) {
            this.drawSep(ug.apply(UTranslate.dy(dimensionToUse.getHeight() / 2.0)), dimensionToUse.getWidth());
        } else {
            TextBlock textBlock = this.getTextBlock();
            StringBounder stringBounder = ug.getStringBounder();
            double textWidth = this.getTextWidth(stringBounder);
            double textHeight = this.getTextHeight(stringBounder);
            double deltaX = 6.0;
            double xpos = (dimensionToUse.getWidth() - textWidth - 6.0) / 2.0;
            double ypos = (dimensionToUse.getHeight() - textHeight) / 2.0;
            this.drawSep(ug.apply(UTranslate.dy(dimensionToUse.getHeight() / 2.0)), dimensionToUse.getWidth());
            ug = ug.apply(this.borderColor);
            ug = ug.apply(this.stroke);
            URectangle rect = new URectangle(textWidth + 6.0, textHeight).rounded(this.roundCorner);
            rect.setDeltaShadow(this.shadow);
            ug.apply(new UTranslate(xpos, ypos)).draw(rect);
            textBlock.drawU(ug.apply(new UTranslate(xpos + 6.0, ypos + (double)this.getMarginY())));
        }
    }

    private void drawSep(UGraphic ug, double width) {
        ug = ug.apply(this.background);
        this.drawRectLong(ug.apply(UTranslate.dy(-1.0)), width);
        this.drawDoubleLine(ug, width);
    }

    private void drawRectLong(UGraphic ug, double width) {
        URectangle rectLong = new URectangle(width, 3.0).rounded(this.roundCorner);
        rectLong.setDeltaShadow(this.shadow);
        ug = ug.apply(new UStroke());
        ug.draw(rectLong);
    }

    private void drawDoubleLine(UGraphic ug, double width) {
        ug = ug.apply(new UStroke(this.stroke.getThickness() / 2.0)).apply(this.borderColor);
        ULine line = ULine.hline(width);
        ug.apply(UTranslate.dy(-1.0)).draw(line);
        ug.apply(UTranslate.dy(2.0)).draw(line);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 20.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 30.0;
    }
}

