/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class EntityImageCircleEnd
extends AbstractEntityImage {
    private static final int SIZE = 20;

    public StyleSignatureBasic getDefaultStyleDefinitionCircle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.circle, SName.end);
    }

    public EntityImageCircleEnd(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(20.0, 20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(20.0, 20.0);
        Style style = this.getDefaultStyleDefinitionCircle().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        HColor color = this.getEntity().getColors().getColor(ColorType.BACK);
        if (color == null) {
            color = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        double shadowing = style.value(PName.Shadowing).asDouble();
        circle.setDeltaShadow(shadowing);
        ug.apply(HColors.none().bg()).apply(color).draw(circle);
        double delta = 4.0;
        UEllipse circleSmall = new UEllipse(12.0, 12.0);
        ug.apply(color.bg()).apply(HColors.none()).apply(new UTranslate(4.5, 4.5)).draw(circleSmall);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

