/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.AbstractPlacementStrategy;

public class PlacementStrategyX1Y2Y3
extends AbstractPlacementStrategy {
    public PlacementStrategyX1Y2Y3(StringBounder stringBounder) {
        super(stringBounder);
    }

    @Override
    public Map<TextBlock, XPoint2D> getPositions(double width, double height) {
        XDimension2D first = this.getDimensions().values().iterator().next();
        double maxWidthButFirst = this.getMaxWidth(this.butFirst());
        double sumHeightButFirst = this.getSumHeight(this.butFirst());
        double space = (width - first.getWidth() - maxWidthButFirst) / 3.0;
        LinkedHashMap<TextBlock, XPoint2D> result = new LinkedHashMap<TextBlock, XPoint2D>();
        Iterator<Map.Entry<TextBlock, XDimension2D>> it = this.getDimensions().entrySet().iterator();
        Map.Entry<TextBlock, XDimension2D> ent = it.next();
        double y = (height - ent.getValue().getHeight()) / 2.0;
        result.put(ent.getKey(), new XPoint2D(space, y));
        y = (height - sumHeightButFirst) / 2.0;
        while (it.hasNext()) {
            Map.Entry<TextBlock, XDimension2D> ent2 = it.next();
            TextBlock textBlock = ent2.getKey();
            XDimension2D dim = this.getDimensions().get(textBlock);
            double x = 2.0 * space + first.getWidth() + (maxWidthButFirst - dim.getWidth()) / 2.0;
            result.put(textBlock, new XPoint2D(x, y));
            y += ent2.getValue().getHeight();
        }
        return result;
    }

    private Iterator<XDimension2D> butFirst() {
        Iterator<XDimension2D> iterator = this.getDimensions().values().iterator();
        iterator.next();
        return iterator;
    }
}

