/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.awt.geom.XRectangle2D;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.PlacementStrategy;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ULayoutGroup {
    private final PlacementStrategy placementStrategy;

    public ULayoutGroup(PlacementStrategy placementStrategy) {
        this.placementStrategy = placementStrategy;
    }

    public void drawU(UGraphic ug, double width, double height) {
        for (Map.Entry<TextBlock, XPoint2D> ent : this.placementStrategy.getPositions(width, height).entrySet()) {
            TextBlock block = ent.getKey();
            XPoint2D pos = ent.getValue();
            block.drawU(ug.apply(new UTranslate(pos)));
        }
    }

    public void add(TextBlock block) {
        this.placementStrategy.add(block);
    }

    public XRectangle2D getInnerPosition(String member, double width, double height, StringBounder stringBounder) {
        Set<Map.Entry<TextBlock, XPoint2D>> all = this.placementStrategy.getPositions(width, height).entrySet();
        XRectangle2D result = this.tryOne(all, member, stringBounder, InnerStrategy.STRICT);
        if (result == null) {
            result = this.tryOne(all, member, stringBounder, InnerStrategy.LAZZY);
        }
        return result;
    }

    private XRectangle2D tryOne(Set<Map.Entry<TextBlock, XPoint2D>> all, String member, StringBounder stringBounder, InnerStrategy mode) {
        for (Map.Entry<TextBlock, XPoint2D> ent : all) {
            TextBlock block = ent.getKey();
            XRectangle2D result = block.getInnerPosition(member, stringBounder, mode);
            if (result == null) continue;
            UTranslate translate = new UTranslate(ent.getValue());
            return translate.apply(result);
        }
        return null;
    }
}

