/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.ConnectionInfoBuilder;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.schema.ConnectionInfo;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.utility.JavaSqlTypes;
import schemacrawler.utility.TypeMap;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.string.StringFormat;

final class RetrieverConnection {
    private static final Logger LOGGER = Logger.getLogger(RetrieverConnection.class.getName());
    private final DatabaseConnectionSource dataSource;
    private final JavaSqlTypes javaSqlTypes;
    private final SchemaRetrievalOptions schemaRetrievalOptions;
    private final TableTypes tableTypes;
    private final ConnectionInfo connectionInfo;

    RetrieverConnection(DatabaseConnectionSource dataSource, SchemaRetrievalOptions schemaRetrievalOptions) throws SQLException {
        this.dataSource = Objects.requireNonNull(dataSource, "Database connection source not provided");
        try (Connection connection = (Connection)dataSource.get();){
            this.schemaRetrievalOptions = Objects.requireNonNull(schemaRetrievalOptions, "No database specific overrides provided");
            this.connectionInfo = ConnectionInfoBuilder.builder(connection).build();
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Making a database connection to:%n%s", new Object[]{this.connectionInfo}));
            this.tableTypes = TableTypes.from(connection);
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Supported table types are <%s>", new Object[]{this.tableTypes}));
        }
        this.javaSqlTypes = new JavaSqlTypes();
    }

    public MetadataRetrievalStrategy get(SchemaInfoMetadataRetrievalStrategy schemaInfoMetadataRetrievalStrategy) {
        return this.schemaRetrievalOptions.get(schemaInfoMetadataRetrievalStrategy);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    Connection getConnection() {
        return (Connection)this.dataSource.get();
    }

    EnumDataTypeHelper getEnumDataTypeHelper() {
        return this.schemaRetrievalOptions.getEnumDataTypeHelper();
    }

    InformationSchemaViews getInformationSchemaViews() {
        return this.schemaRetrievalOptions.getInformationSchemaViews();
    }

    JavaSqlTypes getJavaSqlTypes() {
        return this.javaSqlTypes;
    }

    TableTypes getTableTypes() {
        return this.tableTypes;
    }

    TypeMap getTypeMap() {
        return this.schemaRetrievalOptions.getTypeMap();
    }

    boolean isSupportsCatalogs() {
        return this.schemaRetrievalOptions.isSupportsCatalogs();
    }

    boolean isSupportsSchemas() {
        return this.schemaRetrievalOptions.isSupportsSchemas();
    }
}

