/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.lint.options;

import schemacrawler.tools.command.lint.options.LintOptions;
import schemacrawler.tools.lint.LintDispatch;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.text.options.BaseTextOptions;
import schemacrawler.tools.text.options.BaseTextOptionsBuilder;
import us.fatehi.utility.Utility;

public final class LintOptionsBuilder
extends BaseTextOptionsBuilder<LintOptionsBuilder, LintOptions> {
    private static final String CLI_LINTER_CONFIGS = "linter-configs";
    private static final String CLI_LINT_DISPATCH = "lint-dispatch";
    private static final String CLI_RUN_ALL_LINTERS = "run-all-linters";
    private static final String SCHEMACRAWLER_LINT_PREFIX = "schemacrawler.lint.";
    private static final String LINTER_CONFIGS = "schemacrawler.lint.linter-configs";
    private static final String LINT_DISPATCH = "schemacrawler.lint.lint-dispatch";
    private static final String RUN_ALL_LINTERS = "schemacrawler.lint.run-all-linters";
    LintDispatch lintDispatch = LintDispatch.none;
    String linterConfigs = "";
    boolean runAllLinters = true;
    Config config = new Config();

    public static LintOptionsBuilder builder() {
        return new LintOptionsBuilder();
    }

    public static LintOptionsBuilder builder(LintOptions options) {
        return new LintOptionsBuilder().fromOptions(options);
    }

    private LintOptionsBuilder() {
    }

    public LintOptionsBuilder fromConfig(Config config) {
        if (config == null) {
            return this;
        }
        super.fromConfig(config);
        String linterConfigsKey = config.containsKey(CLI_LINTER_CONFIGS) ? CLI_LINTER_CONFIGS : LINTER_CONFIGS;
        this.linterConfigs = config.getStringValue(linterConfigsKey, "");
        String lintDispatchKey = config.containsKey(CLI_LINT_DISPATCH) ? CLI_LINT_DISPATCH : LINT_DISPATCH;
        this.lintDispatch = (LintDispatch)config.getEnumValue(lintDispatchKey, (Enum)LintDispatch.none);
        String runAllLintersKey = config.containsKey(CLI_RUN_ALL_LINTERS) ? CLI_RUN_ALL_LINTERS : RUN_ALL_LINTERS;
        this.runAllLinters = config.getBooleanValue(runAllLintersKey, true);
        this.config.merge(config);
        return this;
    }

    public LintOptionsBuilder fromOptions(LintOptions options) {
        if (options == null) {
            return this;
        }
        super.fromOptions((BaseTextOptions)options);
        this.linterConfigs = options.getLinterConfigs();
        this.lintDispatch = options.getLintDispatch();
        this.runAllLinters = options.isRunAllLinters();
        return this;
    }

    public LintOptionsBuilder runAllLinters(boolean runAllLinters) {
        this.runAllLinters = runAllLinters;
        return this;
    }

    public Config toConfig() {
        Config config = super.toConfig();
        config.put(LINTER_CONFIGS, (Object)this.linterConfigs);
        config.put(LINT_DISPATCH, (Object)this.lintDispatch);
        config.put(RUN_ALL_LINTERS, (Object)this.runAllLinters);
        return config;
    }

    public LintOptions toOptions() {
        return new LintOptions(this);
    }

    public LintOptionsBuilder withLintDispatch(LintDispatch lintDispatch) {
        this.lintDispatch = lintDispatch == null ? LintDispatch.none : lintDispatch;
        return this;
    }

    public LintOptionsBuilder withLinterConfigs(String linterConfigs) {
        this.linterConfigs = Utility.trimToEmpty((String)linterConfigs);
        return this;
    }

    public LintOptionsBuilder withProperty(String name, String value) {
        if (!Utility.isBlank((CharSequence)name)) {
            this.config.put(name, (Object)value);
        }
        return this;
    }
}

