/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class PlsqlIndexTableAccessor
extends Accessor {
    static final int MAXLENGTH = -1;
    PlsqlIbtBindInfo ibtBindInfo;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    PlsqlIndexTableAccessor(OracleStatement stmt, PlsqlIbtBindInfo ibtBindInfo_, short form) throws SQLException {
        super(Representation.PLSQL_INDEX_TABLE, stmt, -1, true);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$4, null, stmt, ibtBindInfo_, form);
            }
            this.init(stmt, 998, 998, form, true);
            this.ibtBindInfo = ibtBindInfo_;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$0, this, n2, n3, string);
            }
            this.unimpl("initForDataAccess");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    PlsqlIbtBindInfo plsqlIndexTableBindInfo() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$1, this, new Object[0]);
            }
            PlsqlIbtBindInfo plsqlIbtBindInfo = this.ibtBindInfo;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$1, this, plsqlIbtBindInfo);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$1, this, null);
            }
            return plsqlIbtBindInfo;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Object[] getPlsqlIndexTable(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            Object[] result;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$2, this, n2);
            }
            int actualElements = 0;
            if (!this.isNull((int)currentRow)) {
                this.rowData.setPosition(this.getOffset((int)currentRow));
                actualElements = this.rowData.getInt();
            }
            switch (this.ibtBindInfo.element_internal_type) {
                case 9: {
                    result = new String[actualElements];
                    for (int i2 = 0; i2 < actualElements; ++i2) {
                        int len = this.rowData.getShort();
                        result[i2] = len == 0 ? null : this.rowData.getString(len, this.statement.connection.conversion.getCharacterSet((short)1));
                    }
                    break;
                }
                case 6: {
                    result = new BigDecimal[actualElements];
                    for (int i3 = 0; i3 < actualElements; ++i3) {
                        int len = this.rowData.getShort();
                        result[i3] = len == 0 ? null : oracle.sql.NUMBER.toBigDecimal(this.rowData.getBytes(len));
                    }
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$2, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (!$assertionsDisabled && this.rowData.getPosition() != this.getOffset((int)currentRow) + (long)this.getLength((int)currentRow)) {
                AssertionError assertionError = new AssertionError((Object)("rowData.position(): " + this.rowData.getPosition() + " getOffset(" + (int)currentRow + "): " + this.getOffset((int)currentRow) + " getLength(" + (int)currentRow + "): " + this.getLength((int)currentRow)));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$2, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            Object[] objectArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$2, this, objectArray);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$2, this, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$3, this, n2);
            }
            Datum[] result = null;
            int actualElements = 0;
            if (!this.isNull((int)currentRow)) {
                this.rowData.setPosition(this.getOffset((int)currentRow));
                actualElements = this.rowData.getInt();
            }
            switch (this.ibtBindInfo.element_internal_type) {
                case 9: {
                    result = new CHAR[actualElements];
                    CharacterSet charset = this.statement.connection.conversion.getDriverCharSetObj();
                    for (int i2 = 0; i2 < actualElements; ++i2) {
                        int len = this.rowData.getShort();
                        result[i2] = len == 0 ? null : new CHAR(this.rowData.getBytes(len), charset);
                    }
                    break;
                }
                case 6: {
                    result = new NUMBER[actualElements];
                    for (int i3 = 0; i3 < actualElements; ++i3) {
                        int len = this.rowData.getShort();
                        result[i3] = len == 0 ? null : new NUMBER(this.rowData.getBytes(len));
                    }
                    break;
                }
                case 12: {
                    result = new DATE[actualElements];
                    for (int i4 = 0; i4 < actualElements; ++i4) {
                        int len = this.rowData.getShort();
                        result[i4] = len == 0 ? null : new DATE(this.rowData.getBytes(len));
                    }
                    break;
                }
                case 180: {
                    result = new TIMESTAMP[actualElements];
                    for (int i5 = 0; i5 < actualElements; ++i5) {
                        int len = this.rowData.getShort();
                        result[i5] = len == 0 ? null : new TIMESTAMP(this.rowData.getBytes(len));
                    }
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$3, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (!this.isNull((int)currentRow)) if (!$assertionsDisabled && this.rowData.getPosition() != this.getOffset((int)currentRow) + (long)this.getLength((int)currentRow)) {
                AssertionError assertionError = new AssertionError((Object)("rowData.position(): " + this.rowData.getPosition() + " getOffset(" + (int)currentRow + "): " + this.getOffset((int)currentRow) + " getLength(" + (int)currentRow + "): " + this.getLength((int)currentRow)));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$3, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            Datum[] datumArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$3, this, datumArray);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$3, this, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, PlsqlIndexTableAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$4 = PlsqlIndexTableAccessor.class.getDeclaredConstructor(OracleStatement.class, PlsqlIbtBindInfo.class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = PlsqlIndexTableAccessor.class.getDeclaredMethod("getOraclePlsqlIndexTable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = PlsqlIndexTableAccessor.class.getDeclaredMethod("getPlsqlIndexTable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = PlsqlIndexTableAccessor.class.getDeclaredMethod("plsqlIndexTableBindInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = PlsqlIndexTableAccessor.class.getDeclaredMethod("initForDataAccess", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

