/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.GenerationException;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.QueryOveryCollectionConnectionHelper;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.qoc.QocJdtResultSetMetaDataForJavaTypeImpl;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.PDQTypes;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MetaDataInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatabaseProcessor {
    private ClassInfo classInfo_;
    private Connection connection_;
    private StaticProfileConstants.DBInfo dbInfo_ = StaticProfileConstants.DBInfo.dummyDBInfo_;
    private ArtifactOptionsSet artifactOptionsSet_;
    private boolean supportsSelectFromInsert_;
    private boolean supportsSelectFromUpdateDelete_;
    private boolean supportsSelectFromMerge_;
    private boolean supportsGetGeneratedKeys_ = false;
    private static HashMap<ClassLoader, HashMap<String, ClassLoader>> driverClassLoaderMap__ = new HashMap();

    public DatabaseProcessor(ClassInfo classInfo, ArtifactOptionsSet artifactOptionsSet, Connection connection) {
        this.classInfo_ = classInfo;
        this.artifactOptionsSet_ = artifactOptionsSet;
        this.connection_ = this.classInfo_.isGenerateForQOC() ? this.getConnectionForQoc() : (connection == null ? DatabaseProcessor.getConnection(artifactOptionsSet, this.getClass().getClassLoader()) : connection);
        this.classInfo_.getOriginInfo().setDatabaseConnectionInfo(this.connection_);
        this.setDatabaseMetaData();
    }

    public void processInfo() {
        this.classInfo_.setGenerateStaticArtifacts(this.dbInfo_.databaseType_.isDB2());
        this.getInformationForStaticArtifacts(this.connection_);
        List<MethodInfo> list = this.classInfo_.getListOfMethods();
        for (MethodInfo methodInfo : list) {
            this.processMethod(methodInfo);
        }
    }

    private Connection getConnectionForQoc() {
        try {
            return QueryOveryCollectionConnectionHelper.getConnection("com.ibm.db2.cmx.runtime.internal.qoc.QocJDTTableMapping");
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_GENERATOR_CONNECTION_QOC", new Object[0]), sQLException, 10162, null, null);
        }
    }

    private void processMethod(MethodInfo methodInfo) {
        String string = methodInfo.getProcessedSql();
        SqlStatementType sqlStatementType = methodInfo.getSqlStatementType();
        if (methodInfo.hasAutoGeneratedKeys()) {
            if (this.dbInfo_.databaseType_.isDB2()) {
                if (sqlStatementType.equals((Object)SqlStatementType.INSERT) && !this.supportsSelectFromInsert_ || (sqlStatementType.equals((Object)SqlStatementType.DELETE) || sqlStatementType.equals((Object)SqlStatementType.UPDATE)) && !this.supportsSelectFromUpdateDelete_ || sqlStatementType.equals((Object)SqlStatementType.MERGE) && !this.supportsSelectFromMerge_) {
                    methodInfo.setHasAutoGeneratedKeys(false);
                }
            } else if (sqlStatementType.equals((Object)SqlStatementType.INSERT)) {
                methodInfo.setHasAutoGeneratedKeys(this.supportsGetGeneratedKeys_);
            } else {
                methodInfo.setHasAutoGeneratedKeys(false);
            }
        }
        if (this.classInfo_.isGenerateForQOC()) {
            this.setMethodInfoOnQocJdtResultSetMetaData(methodInfo);
        }
        ToolsLogger.getLogger().log(Level.FINER, "preparing statement to retrieve metadata: " + string);
        PreparedStatement preparedStatement = this.getPreparedStatement(string, this.connection_, methodInfo);
        this.processResultSetMetadata(methodInfo, preparedStatement);
        this.processParameterMetadata(methodInfo, preparedStatement);
        this.closePreparedStatement(preparedStatement);
        ToolsLogger.getLogger().log(Level.FINER, "retrieved metadata");
    }

    private void closePreparedStatement(PreparedStatement preparedStatement) {
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void setMethodInfoOnQocJdtResultSetMetaData(MethodInfo methodInfo) {
        QocJdtResultSetMetaDataForJavaTypeImpl.methodInfo_ = methodInfo;
    }

    private void addDB2ResultSetMetaData(ResultSetMetaData resultSetMetaData, MethodInfo methodInfo, PreparedStatement preparedStatement) {
        block8: {
            try {
                Method method = preparedStatement.getClass().getMethod("getResultSetColumnMetaData", new Class[0]);
                Object object = method.invoke((Object)preparedStatement, new Object[0]);
                Field field = null;
                field = object.getClass().getDeclaredField("sqlCcsids");
                int[] nArray = (int[])field.get(object);
                methodInfo.getResultMetaDataInfo().setSqlCcsid(nArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (this.classInfo_.isGenerateStaticArtifacts()) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_GET_COLMETA", new Object[0]), invocationTargetException, 10163, null, methodInfo);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (this.classInfo_.isGenerateStaticArtifacts()) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_GET_COLMETA", new Object[0]), illegalAccessException, 10164, null, methodInfo);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (this.classInfo_.isGenerateStaticArtifacts()) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_GET_COLMETA", new Object[0]), noSuchFieldException, 10165, null, methodInfo);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!this.classInfo_.isGenerateStaticArtifacts()) break block8;
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_GET_COLMETA", new Object[0]), noSuchMethodException, 10166, null, methodInfo);
            }
        }
    }

    private void processResultSetMetadata(MethodInfo methodInfo, PreparedStatement preparedStatement) {
        try {
            Object object;
            ResultSetMetaData resultSetMetaData = null;
            try {
                resultSetMetaData = preparedStatement.getMetaData();
            }
            catch (SQLException sQLException) {
                object = preparedStatement.getConnection();
                if (object.getMetaData().getDriverName().toLowerCase().contains("oracle")) {
                    ExceptionFactory.createGenerationExceptionForToolsOnly("ERR_NO_METADATA", sQLException, 10677, null, methodInfo);
                }
                throw sQLException;
            }
            if (resultSetMetaData != null && resultSetMetaData.getColumnCount() > 0) {
                try {
                    int n2 = resultSetMetaData.getColumnCount();
                    object = new MetaDataInfo(n2);
                    for (int i10 = 0; i10 < n2; ++i10) {
                        ((MetaDataInfo)object).getFieldNames()[i10] = resultSetMetaData.getColumnLabel(i10 + 1).toLowerCase();
                        ((MetaDataInfo)object).getSqlPrecision()[i10] = resultSetMetaData.getPrecision(i10 + 1);
                        ((MetaDataInfo)object).getSqlTypeForStorageInImplOrXml()[i10] = resultSetMetaData.getColumnType(i10 + 1);
                        ((MetaDataInfo)object).getSqlScale()[i10] = resultSetMetaData.getScale(i10 + 1);
                        ((MetaDataInfo)object).getParameterTypeName()[i10] = resultSetMetaData.getColumnTypeName(i10 + 1);
                        String string = resultSetMetaData.getTableName(i10 + 1);
                        if (null == string) continue;
                        ((MetaDataInfo)object).getTableNames()[i10] = string.toLowerCase();
                    }
                    this.setUniqueTypes((MetaDataInfo)object);
                    methodInfo.setResultMetaDataInfo((MetaDataInfo)object);
                    if (this.classInfo_.isGenerateStaticArtifacts()) {
                        this.addDB2ResultSetMetaData(resultSetMetaData, methodInfo, preparedStatement);
                    }
                    ToolsLogger.getLogger().log(Level.FINEST, methodInfo.getProcessedSql() + "\n" + DatabaseProcessor.formatResultSetMetaData(methodInfo, resultSetMetaData));
                }
                catch (SQLException sQLException) {
                    ExceptionFactory.createGenerationExceptionForToolsOnly("ERR_NO_METADATA", sQLException, 10676, null, methodInfo);
                }
            }
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_GET_COLMETA", new Object[0]), sQLException, 10167, null, methodInfo);
        }
    }

    private static String formatResultSetMetaData(MethodInfo methodInfo, ResultSetMetaData resultSetMetaData) {
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append("ColumnNumber\tColumnName\tColumnLabel\tTableName\tCatalogName\tSchemaName\tColumnType\t");
        stringBuilder.append("ColumnTypeName\tColumnClassName\tColumnDisplaySize\tPrecision\tScale\tNullable\tAutoIncrement\tCaseSensitive\t");
        stringBuilder.append("Currency\tWritable\tDefinitelyWritable\tReadOnly\tSearchable\tSigned\n");
        try {
            int n2;
            int n3 = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n3 + 1];
            for (n2 = 1; n2 <= n3; ++n2) {
                stringArray[n2] = resultSetMetaData.getColumnName(n2);
            }
            for (n2 = 1; n2 <= n3; ++n2) {
                stringBuilder.append(n2);
                for (int i10 = 1; i10 <= n3; ++i10) {
                    if (i10 == n2 || !stringArray[n2].equals(stringArray[i10])) continue;
                    stringBuilder.append(" ");
                    stringBuilder.append(i10);
                }
                stringBuilder.append('\t');
                stringBuilder.append(stringArray[n2]);
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.getColumnLabel(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.getTableName(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.getCatalogName(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.getSchemaName(n2));
                stringBuilder.append('\t');
                stringBuilder.append(DatabaseProcessor.getSqlTypeString(resultSetMetaData.getColumnType(n2)));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.getColumnTypeName(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.getColumnClassName(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.getColumnDisplaySize(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.getPrecision(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.getScale(n2));
                stringBuilder.append('\t');
                stringBuilder.append(DatabaseProcessor.getNullableString(resultSetMetaData.isNullable(n2)));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.isAutoIncrement(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.isCaseSensitive(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.isCurrency(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.isWritable(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.isDefinitelyWritable(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.isReadOnly(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.isSearchable(n2));
                stringBuilder.append('\t');
                stringBuilder.append(resultSetMetaData.isSigned(n2));
                stringBuilder.append('\n');
            }
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_GET_COLMETA", new Object[0]), sQLException, 11109, null, methodInfo);
        }
        return DatabaseProcessor.normalizeString(stringBuilder, '\t');
    }

    private static String getSqlTypeString(int n2) {
        String string;
        switch (n2) {
            case 2003: {
                string = "Array";
                break;
            }
            case -5: {
                string = "BigInt";
                break;
            }
            case -2: {
                string = "Binary";
                break;
            }
            case -7: {
                string = "Bit";
                break;
            }
            case 2004: {
                string = "Blob";
                break;
            }
            case 16: {
                string = "Boolean";
                break;
            }
            case 1: {
                string = "Char";
                break;
            }
            case 2005: {
                string = "Clob";
                break;
            }
            case 70: {
                string = "DataLink";
                break;
            }
            case 91: {
                string = "Date";
                break;
            }
            case 3: {
                string = "Decimal";
                break;
            }
            case 2001: {
                string = "Distinct";
                break;
            }
            case 8: {
                string = "Double";
                break;
            }
            case 6: {
                string = "Float";
                break;
            }
            case 4: {
                string = "Integer";
                break;
            }
            case 2000: {
                string = "Java Object";
                break;
            }
            case -4: {
                string = "LongVarBinary";
                break;
            }
            case -1: {
                string = "LongVarChar";
                break;
            }
            case 0: {
                string = "Null";
                break;
            }
            case 2: {
                string = "Numeric";
                break;
            }
            case 1111: {
                string = "Other";
                break;
            }
            case 7: {
                string = "Real";
                break;
            }
            case 2006: {
                string = "Ref";
                break;
            }
            case 5: {
                string = "SmallInt";
                break;
            }
            case 2002: {
                string = "Struct";
                break;
            }
            case 92: {
                string = "Time";
                break;
            }
            case 93: {
                string = "TimeStamp";
                break;
            }
            case -100010: {
                string = "TimestampWithTimeZone";
                break;
            }
            case -6: {
                string = "TinyInt";
                break;
            }
            case -3: {
                string = "VarBinary";
                break;
            }
            case 12: {
                string = "VarChar";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    private static String getNullableString(int n2) {
        String string;
        switch (n2) {
            case 0: {
                string = "No Nulls";
                break;
            }
            case 1: {
                string = "Nullable";
                break;
            }
            case 2: {
                string = "?Nullable";
                break;
            }
            default: {
                string = "??????";
            }
        }
        return string;
    }

    public static String normalizeString(StringBuilder stringBuilder, char c10) {
        char c11;
        int n2;
        int n3;
        int n4;
        int[] nArray = new int[1000];
        char[] cArray = new char[1000];
        int n5 = 0;
        int n6 = 0;
        int n7 = nArray.length;
        for (n4 = 0; n4 < n7; ++n4) {
            nArray[n4] = 0;
        }
        n7 = cArray.length;
        n4 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            cArray[n3] = 32;
        }
        n3 = stringBuilder.length();
        for (n2 = 0; n2 < n3; ++n2) {
            c11 = stringBuilder.charAt(n2);
            if (c11 == '\f') {
                n4 = n4 != 0 ? 0 : 1;
                continue;
            }
            if (n4 != 0) continue;
            if (c11 == c10) {
                if (n6 > nArray[n5]) {
                    nArray[n5] = n6;
                }
                ++n5;
                n6 = 0;
                continue;
            }
            if (c11 == '\n') {
                if (n6 > nArray[n5]) {
                    nArray[n5] = n6;
                }
                n5 = 0;
                n6 = 0;
                continue;
            }
            ++n6;
        }
        if (n5 != 0) {
            stringBuilder.append('\n');
            if (n6 > nArray[n5]) {
                nArray[n5] = n6;
            }
        }
        n5 = 0;
        n6 = 0;
        n4 = 0;
        for (n2 = 0; n2 < stringBuilder.length(); ++n2) {
            int n8;
            c11 = stringBuilder.charAt(n2);
            if (c11 == '\f') {
                n4 = n4 != 0 ? 0 : 1;
                stringBuilder.setCharAt(n2, ' ');
                continue;
            }
            if (n4 != 0) continue;
            if (c11 == c10) {
                if (n6 < nArray[n5]) {
                    n8 = nArray[n5] - n6;
                    stringBuilder.insert(n2, cArray, 0, n8);
                    n2 += n8;
                }
                stringBuilder.setCharAt(n2, ' ');
                ++n5;
                n6 = 0;
                continue;
            }
            if (c11 == '\n') {
                if (n6 < nArray[n5]) {
                    n8 = nArray[n5] - n6;
                    stringBuilder.insert(n2, cArray, 0, n8);
                    n2 += n8;
                }
                n5 = 0;
                n6 = 0;
                continue;
            }
            ++n6;
        }
        String string = stringBuilder.toString();
        stringBuilder.setLength(0);
        return string;
    }

    private void processParameterMetadata(MethodInfo methodInfo, PreparedStatement preparedStatement) {
        try {
            Object object;
            ParameterMetaData parameterMetaData = null;
            try {
                parameterMetaData = preparedStatement.getParameterMetaData();
            }
            catch (SQLException sQLException) {
                object = preparedStatement.getConnection();
                if (object.getMetaData().getDriverName().toLowerCase().contains("oracle")) {
                    ExceptionFactory.createGenerationExceptionForToolsOnly("ERR_NO_METADATA", sQLException, 10675, null, methodInfo);
                }
                throw sQLException;
            }
            if (parameterMetaData != null && parameterMetaData.getParameterCount() > 0) {
                try {
                    int n2 = parameterMetaData.getParameterCount();
                    object = new MetaDataInfo(n2);
                    for (int i10 = 0; i10 < n2; ++i10) {
                        ((MetaDataInfo)object).getSqlPrecision()[i10] = parameterMetaData.getPrecision(i10 + 1);
                        ((MetaDataInfo)object).getSqlScale()[i10] = parameterMetaData.getScale(i10 + 1);
                        ((MetaDataInfo)object).getSqlTypeForStorageInImplOrXml()[i10] = parameterMetaData.getParameterType(i10 + 1);
                        ((MetaDataInfo)object).getSqlParmMode()[i10] = parameterMetaData.getParameterMode(i10 + 1);
                        ((MetaDataInfo)object).getParameterTypeName()[i10] = parameterMetaData.getParameterTypeName(i10 + 1);
                    }
                    this.setUniqueTypes((MetaDataInfo)object);
                    methodInfo.setParameterMetaDataInfo((MetaDataInfo)object);
                }
                catch (SQLException sQLException) {
                    int n3 = methodInfo.getParameterInfoArray().getSqlParameterInfo().size();
                    if (n3 > 0 && methodInfo.getParameterHandlerFromParameter() == null) {
                        ExceptionFactory.createGenerationExceptionForToolsOnly("ERR_NO_METADATA", sQLException, 10674, null, methodInfo);
                        MetaDataInfo metaDataInfo = new MetaDataInfo(methodInfo.getParameterInfoArray().getSqlParameterInfo().size());
                        this.fillMissingParameterMetaData(metaDataInfo, preparedStatement, methodInfo);
                        methodInfo.setParameterMetaDataInfo(metaDataInfo);
                    }
                }
            } else {
                int n4 = methodInfo.getParameterInfoArray().getSqlParameterInfo().size();
                if (n4 > 0 && methodInfo.getParameterHandlerFromParameter() == null) {
                    object = new MetaDataInfo(n4);
                    this.fillMissingParameterMetaData((MetaDataInfo)object, preparedStatement, methodInfo);
                    methodInfo.setParameterMetaDataInfo((MetaDataInfo)object);
                }
            }
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_GET_COLMETA", new Object[0]), sQLException, 10168, null, methodInfo);
        }
    }

    protected void fillMissingParameterMetaData(MetaDataInfo metaDataInfo, PreparedStatement preparedStatement, MethodInfo methodInfo) throws SQLException {
        String string = methodInfo.getProcessedSql();
        EscapeLexer escapeLexer = new EscapeLexer(string);
        SqlStatementType sqlStatementType = escapeLexer.parseSqlAndGetSqlType();
        if (sqlStatementType == SqlStatementType.CALL && StaticProfileConstants.DatabaseType.Oracle == this.dbInfo_.databaseType_) {
            escapeLexer = new EscapeLexer(string);
            Integer[] integerArray = escapeLexer.parseSqlAndGetStoredProcParamIndexes();
            String[] stringArray = new String[3];
            this.getStoredProcName(string, stringArray);
            this.lookupOracleStoredProcMetadata(this.connection_, stringArray, integerArray, metaDataInfo, methodInfo);
        }
    }

    private void getStoredProcName(String string, String[] stringArray) {
        String string2 = string;
        int n2 = string.toLowerCase().indexOf("call");
        if (n2 == -1 || string.length() < 5) {
            throw new IllegalStateException("CALL statement expected.");
        }
        string = string.substring(n2 + "call".length());
        Pattern pattern = Pattern.compile("\\s*([^\\.]+?)\\s*\\(.*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            stringArray[2] = matcher.group(1);
        } else {
            Pattern pattern2 = Pattern.compile("\\s*([^\\.]+?)\\.([^\\.]+?)\\s*\\(.*");
            matcher = pattern2.matcher(string);
            if (matcher.matches()) {
                stringArray[1] = matcher.group(1);
                stringArray[2] = matcher.group(2);
            } else {
                Pattern pattern3 = Pattern.compile("\\s*([^\\.]+?)\\.([^\\.]+?)\\.([^\\.]+?)\\s*\\(.*");
                matcher = pattern3.matcher(string);
                if (matcher.matches()) {
                    stringArray[0] = matcher.group(1);
                    stringArray[1] = matcher.group(2);
                    stringArray[2] = matcher.group(3);
                } else {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_GET_PROC_NAME", string2), null, 10666, null, null);
                }
            }
        }
    }

    private boolean isQuoted(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("\"") && string.endsWith("\"");
    }

    private String unQuote(String string) {
        if (string == null) {
            return null;
        }
        return string.substring(1, string.length() - 1);
    }

    private String toUpperCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase();
    }

    private void lookupOracleStoredProcMetadata(Connection connection, String[] stringArray, Integer[] integerArray, MetaDataInfo metaDataInfo, MethodInfo methodInfo) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (string2 == null) {
            string2 = "";
        }
        String string3 = stringArray[2];
        string = this.isQuoted(string) ? this.unQuote(string) : this.toUpperCase(string);
        string2 = this.isQuoted(string2) ? this.unQuote(string2) : this.toUpperCase(string2);
        string3 = this.isQuoted(string3) ? this.unQuote(string3) : this.toUpperCase(string3);
        ArrayList<Map<String, Object>> arrayList = "Oracle".equals(connection.getMetaData().getDriverName()) ? this.getProcedureParamsForDataDirect(string, string2, string3, methodInfo, databaseMetaData) : this.getProcedureParamsForOracle(string, string2, string3, methodInfo, databaseMetaData);
        if (arrayList.size() > 0) {
            this.setMetadataUsingProcedureParams(integerArray, metaDataInfo, methodInfo, arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Map<String, Object>> getProcedureParamsForOracle(String string, String string2, String string3, MethodInfo methodInfo, DatabaseMetaData databaseMetaData) throws SQLException {
        Object object;
        if (string == null && string2.length() > 0 && string3 != null) {
            object = databaseMetaData.getProcedures(string2, "", string3);
            if (object.next()) {
                object.close();
                string = string2;
                string2 = "";
            } else {
                object.close();
                object = databaseMetaData.getProcedures(null, string2, string3);
                if (!object.next()) {
                    object.close();
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PROC_NOT_FOUND", string3), null, 10667, null, null);
                }
                object.close();
            }
        }
        object = new ArrayList();
        ResultSet resultSet = databaseMetaData.getProcedureColumns(string, string2, string3, "%");
        try {
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("PRECISION", resultSet.getInt("PRECISION"));
                hashMap.put("SCALE", resultSet.getShort("SCALE"));
                hashMap.put("DATA_TYPE", resultSet.getInt("DATA_TYPE"));
                hashMap.put("COLUMN_TYPE", resultSet.getShort("COLUMN_TYPE"));
                hashMap.put("TYPE_NAME", resultSet.getString("TYPE_NAME"));
                hashMap.put("OVERLOAD", resultSet.getObject("OVERLOAD"));
                if (hashMap.get("OVERLOAD") != null) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PROC_OVERLOAD_ORACLE", string3), null, 10668, null, null);
                }
                ((ArrayList)object).add(hashMap);
            }
        }
        finally {
            resultSet.close();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Map<String, Object>> getProcedureParamsForDataDirect(String string, String string2, String string3, MethodInfo methodInfo, DatabaseMetaData databaseMetaData) throws SQLException {
        Object object;
        if (string == null && string2.length() > 0 && string3 != null) {
            object = databaseMetaData.getProcedures(null, databaseMetaData.getUserName(), string2 + "." + string3);
            if (object.next()) {
                object.close();
                string3 = string2 + "." + string3;
                string2 = databaseMetaData.getUserName();
            } else {
                object.close();
                object = databaseMetaData.getProcedures(null, string2, string3);
                if (!object.next()) {
                    object.close();
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PROC_NOT_FOUND", string3), null, 10671, null, null);
                }
                object.close();
            }
        }
        if (string2 == null || string2.length() == 0) {
            string2 = databaseMetaData.getUserName();
        }
        object = new ArrayList();
        ResultSet resultSet = databaseMetaData.getProcedureColumns(string, string2, string3, "%");
        try {
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("PROCEDURE_NAME", resultSet.getString("PROCEDURE_NAME"));
                hashMap.put("PRECISION", resultSet.getInt("PRECISION"));
                hashMap.put("SCALE", resultSet.getShort("SCALE"));
                hashMap.put("DATA_TYPE", resultSet.getInt("DATA_TYPE"));
                hashMap.put("COLUMN_TYPE", resultSet.getShort("COLUMN_TYPE"));
                hashMap.put("TYPE_NAME", resultSet.getString("TYPE_NAME"));
                hashMap.put("SPECIFIC_NAME", resultSet.getString("SPECIFIC_NAME"));
                String string4 = (String)hashMap.get("SPECIFIC_NAME");
                if (string4.endsWith(";")) {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                if (!string4.equals(hashMap.get("PROCEDURE_NAME"))) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PROC_OVERLOAD_ORACLE", string3), null, 10672, null, null);
                }
                ((ArrayList)object).add(hashMap);
            }
        }
        finally {
            resultSet.close();
        }
        return object;
    }

    private void setMetadataUsingProcedureParams(Integer[] integerArray, MetaDataInfo metaDataInfo, MethodInfo methodInfo, ArrayList<Map<String, Object>> arrayList) {
        int n2;
        int n3 = 0;
        int n4 = -1;
        for (n2 = 0; n2 < integerArray.length; ++n2) {
            if (integerArray[n2] == null) continue;
            ++n3;
            if (n4 >= integerArray[n2]) continue;
            n4 = integerArray[n2];
        }
        if (arrayList.size() < n3 || arrayList.size() < n4) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_SP_PARAM_COUNT", n3, arrayList.size()), null, 10673, null, null);
        }
        n2 = integerArray.length;
        for (int i10 = 0; i10 < n2; ++i10) {
            String string;
            Integer n5 = integerArray[i10];
            if (n5 == null) {
                metaDataInfo.getSqlParmMode()[i10] = 1;
                continue;
            }
            Map<String, Object> map = arrayList.get(n5 - 1);
            if (map.get("PRECISION") != null) {
                metaDataInfo.getSqlPrecision()[i10] = (Integer)map.get("PRECISION");
            }
            if (map.get("SCALE") != null) {
                metaDataInfo.getSqlScale()[i10] = ((Short)map.get("SCALE")).shortValue();
            }
            if (map.get("DATA_TYPE") != null) {
                metaDataInfo.getSqlTypeForStorageInImplOrXml()[i10] = (Integer)map.get("DATA_TYPE");
            }
            if (map.get("COLUMN_TYPE") != null) {
                metaDataInfo.getSqlParmMode()[i10] = ((Short)map.get("COLUMN_TYPE")).shortValue();
            }
            if (map.get("TYPE_NAME") == null) continue;
            metaDataInfo.getParameterTypeName()[i10] = string = (String)map.get("TYPE_NAME");
            if ("REF CURSOR".equals(string)) {
                metaDataInfo.getSqlTypeForStorageInImplOrXml()[i10] = 3874837;
                continue;
            }
            if (metaDataInfo.getSqlTypeForStorageInImplOrXml()[i10] != 1111) continue;
            if ("BINARY_DOUBLE".equals(string)) {
                metaDataInfo.getSqlTypeForStorageInImplOrXml()[i10] = 3874838;
                continue;
            }
            if ("CLOB".equals(string)) {
                metaDataInfo.getSqlTypeForStorageInImplOrXml()[i10] = 2005;
                continue;
            }
            if ("BLOB".equals(string)) {
                metaDataInfo.getSqlTypeForStorageInImplOrXml()[i10] = 2004;
                continue;
            }
            if ("FLOAT".equals(string)) {
                metaDataInfo.getSqlTypeForStorageInImplOrXml()[i10] = 6;
                continue;
            }
            if (!"BFILE".equals(string)) continue;
            metaDataInfo.getSqlTypeForStorageInImplOrXml()[i10] = 3874839;
        }
        this.setUniqueTypes(metaDataInfo);
        methodInfo.setParameterMetaDataInfo(metaDataInfo);
    }

    public static Connection getConnection(ArtifactOptionsSet artifactOptionsSet, ClassLoader classLoader) {
        Connection connection = null;
        long l10 = System.currentTimeMillis();
        String string = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.USERNAME);
        String string2 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.PASSWORD);
        String string3 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.DRIVER_NAME);
        String string4 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.URL);
        Driver driver = null;
        if (!(null != string && 1 <= string.length() && null != string2 && 1 <= string2.length() && null != string3 && 1 <= string3.length() && null != string4 && 1 <= string4.length() || string4 != null && (string4.contains("kerberosServerPrincipal") || string4.contains("securityMechanism")))) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_JDBC_PROP", new Object[0]), null, 10169, null, null);
        }
        try {
            driver = (Driver)Class.forName(string3, true, DatabaseProcessor.getClassLoaderForDriver(artifactOptionsSet, classLoader)).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_LD_JDBC_CL", string3), classNotFoundException, 10170, null, null);
        }
        catch (InstantiationException instantiationException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INST_JDBC", string3), instantiationException, 10171, null, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_CONST_JDBC", string3), illegalAccessException, 10172, null, null);
        }
        Properties properties = new Properties();
        if (string != null && string.length() > 0) {
            properties.put("user", string);
        }
        if (string2 != null && string2.length() > 0) {
            properties.put("password", string2);
        }
        if (string4 != null && !string4.contains("retrieveMessagesFromServerOnGetMessage")) {
            properties.put("retrieveMessagesFromServerOnGetMessage", "true");
        }
        if (string4 != null && !string4.contains("monitorEnabled")) {
            properties.put("monitorEnabled", "2");
        }
        try {
            connection = driver.connect(string4, properties);
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_JDBC_CONN", string4, string), sQLException, 10173, null, null);
        }
        if (null == connection) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_URL_FAILS_FOR_DRIVER", string4, string3), null, 10482, null, null);
        }
        long l11 = System.currentTimeMillis();
        ToolsLogger.getLogger().log(Level.FINEST, "time to create connection " + (l11 - l10));
        return connection;
    }

    private PreparedStatement getPreparedStatement(String string, Connection connection, MethodInfo methodInfo) {
        try {
            List<String> list = null;
            if (methodInfo.hasAutoGeneratedKeys() && (methodInfo.getSqlStatementType() == SqlStatementType.UPDATE || methodInfo.getSqlStatementType() == SqlStatementType.INSERT)) {
                list = methodInfo.getInputBeanInfo().get(0).getAutoGeneratedKeys();
            }
            if (list != null && list.size() > 0) {
                return connection.prepareStatement(string, list.toArray(new String[list.size()]));
            }
            return connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PSTMT", new Object[0]), sQLException, 10175, null, methodInfo);
        }
    }

    private static ClassLoader getClassLoaderForDriver(ArtifactOptionsSet artifactOptionsSet, ClassLoader classLoader) throws GenerationException {
        ClassLoader classLoader2 = null;
        String string = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.USER_CLASSPATH);
        if (string != null) {
            HashMap<String, ClassLoader> hashMap = driverClassLoaderMap__.get(classLoader);
            if (hashMap != null) {
                classLoader2 = hashMap.get(string);
            }
            if (classLoader2 == null) {
                if (hashMap == null) {
                    hashMap = new HashMap();
                    driverClassLoaderMap__.put(classLoader, hashMap);
                }
                ArrayList<URL> arrayList = new ArrayList<URL>();
                URL uRL = null;
                String string2 = "";
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        uRL = new File(string2).toURL();
                        arrayList.add(uRL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INV_CLPATH", string2), malformedURLException, 10176, null, null);
                }
                URL[] uRLArray = arrayList.toArray(new URL[arrayList.size()]);
                classLoader2 = new URLClassLoader(uRLArray, classLoader);
                hashMap.put(string, classLoader2);
            }
        } else {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_CLASSPATH", new Object[0]), null, 10177, null, null);
        }
        return classLoader2;
    }

    private void getInformationForStaticArtifacts(Connection connection) {
        this.classInfo_.setCollectionName(this.artifactOptionsSet_.getOptionOrArtifactSingleValue(PossibleArgs.COLLECTION));
        String string = this.artifactOptionsSet_.getOptionOrArtifactSingleValue(PossibleArgs.ROOT_PKG_NAME);
        this.classInfo_.setForceSingleBindIsolation(this.artifactOptionsSet_.getOptionValueBoolean(PossibleArgs.FORCE_SINGLE_BIND_ISOLATION));
        if (string == null) {
            PossibleArgs.PredefinedOptionValues predefinedOptionValues = this.artifactOptionsSet_.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.ROOT_PKG_PATTERN);
            if (predefinedOptionValues == null || predefinedOptionValues == PossibleArgs.PredefinedOptionValues.INTERFACE) {
                int n2 = 127;
                if (StaticProfileConstants.DatabaseType.DB2forLUW == this.dbInfo_.databaseType_ && !StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this.dbInfo_, 9, 5, Character.valueOf('0')) || StaticProfileConstants.DatabaseType.DB2forZOS == this.dbInfo_.databaseType_ && !StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this.dbInfo_, 8, 1, Character.valueOf('5'))) {
                    n2 = 7;
                }
                if ((string = this.classInfo_.getTypeName()).length() > n2) {
                    string = string.substring(0, n2);
                }
            } else {
                String string2 = this.classInfo_.getPackageName();
                if (string2 == null || string2.length() == 0) {
                    string = this.classInfo_.getTypeName();
                } else {
                    String string3 = this.artifactOptionsSet_.getOptionOrArtifactSingleValue(PossibleArgs.ROOT_PKG_EXCLUSION);
                    String string4 = string2;
                    if (string3 != null && string4.startsWith(string3 = string3.trim()) && (string4 = string4.substring(string3.length())).startsWith(".")) {
                        string4 = string4.substring(1);
                    }
                    string4 = string4.replace('.', '_');
                    if (predefinedOptionValues == PossibleArgs.PredefinedOptionValues.JAVAPKG_INTERFACE) {
                        string = string4 + "_" + this.classInfo_.getTypeName();
                    } else if (predefinedOptionValues == PossibleArgs.PredefinedOptionValues.INTERFACE_JAVAPKG) {
                        string = this.classInfo_.getTypeName() + "_" + string4;
                    }
                }
            }
        }
        this.classInfo_.setRootPkgName(string);
        long l10 = System.currentTimeMillis();
        this.classInfo_.setTimeStamp(l10);
        this.classInfo_.setPackageVersion(this.artifactOptionsSet_.getOptionOrArtifactSingleValue(PossibleArgs.PACKAGE_VERSION), l10);
    }

    public void setUniqueTypes(MetaDataInfo metaDataInfo) {
        int[] nArray = metaDataInfo.getSqlTypeForStorageInImplOrXml();
        String[] stringArray = metaDataInfo.getParameterTypeName();
        block13: for (int i10 = 0; i10 < nArray.length; ++i10) {
            switch (nArray[i10]) {
                case 1111: {
                    if ("XML".equalsIgnoreCase(stringArray[i10])) {
                        nArray[i10] = 2009;
                        this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                        continue block13;
                    }
                    if ("ROWID".equalsIgnoreCase(stringArray[i10])) {
                        nArray[i10] = -8;
                        this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                        continue block13;
                    }
                    if ("DECFLOAT".equalsIgnoreCase(stringArray[i10])) {
                        nArray[i10] = -100001;
                        this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                        continue block13;
                    }
                    if ("CURSOR".equalsIgnoreCase(stringArray[i10])) {
                        nArray[i10] = -100008;
                        this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                        continue block13;
                    }
                    if ("ROW".equalsIgnoreCase(stringArray[i10])) {
                        nArray[i10] = -100009;
                        this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                        continue block13;
                    }
                    if (!"TIMESTAMP WITH TIME ZONE".equalsIgnoreCase(stringArray[i10])) continue block13;
                    nArray[i10] = -100010;
                    this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                    continue block13;
                }
                case 1: {
                    if (!"GRAPHIC".equalsIgnoreCase(stringArray[i10])) continue block13;
                    nArray[i10] = 503;
                    this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                    continue block13;
                }
                case 2005: {
                    if (!"DBCLOB".equalsIgnoreCase(stringArray[i10])) continue block13;
                    nArray[i10] = 502;
                    this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                    continue block13;
                }
                case 12: {
                    if (!"VARGRAPHIC".equalsIgnoreCase(stringArray[i10])) continue block13;
                    nArray[i10] = 504;
                    this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                    continue block13;
                }
                case -1: {
                    if (!"LONG VARGRAPHIC".equalsIgnoreCase(stringArray[i10])) continue block13;
                    nArray[i10] = 505;
                    this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                    continue block13;
                }
                case -2: {
                    if (!"CHAR FOR BIT DATA".equalsIgnoreCase(stringArray[i10])) continue block13;
                    nArray[i10] = -4524532;
                    this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                    continue block13;
                }
                case -3: {
                    if (!"VARCHAR FOR BIT DATA".equalsIgnoreCase(stringArray[i10])) continue block13;
                    nArray[i10] = -4484493;
                    this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                    continue block13;
                }
                case -4: {
                    if (!"LONG VARCHAR FOR BIT DATA".equalsIgnoreCase(stringArray[i10])) continue block13;
                    nArray[i10] = -4564574;
                    this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                    continue block13;
                }
                case 2009: {
                    this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                    continue block13;
                }
                case -8: {
                    this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                    continue block13;
                }
                case 93: {
                    if (metaDataInfo.getSqlScale()[i10] <= 9) continue block13;
                    stringArray[i10] = "TIMESTAMP WITH TIME ZONE";
                    nArray[i10] = -100010;
                    this.classInfo_.addImportDeclaration(PDQTypes.class.getName());
                }
            }
        }
    }

    public void setDatabaseMetaData() {
        try {
            DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
            this.dbInfo_ = new StaticProfileConstants.DBInfo(databaseMetaData);
            this.supportsGetGeneratedKeys_ = databaseMetaData.supportsGetGeneratedKeys();
            if (this.dbInfo_.databaseType_.isDB2()) {
                this.supportsSelectFromInsert_ = StaticProfileConstants.DatabaseType.DB2forZOS == this.dbInfo_.databaseType_ && StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this.dbInfo_, 8, 1, Character.valueOf('0')) || StaticProfileConstants.DatabaseType.DB2forLUW == this.dbInfo_.databaseType_ && StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this.dbInfo_, 8, 1, Character.valueOf('4')) || StaticProfileConstants.DatabaseType.DB2forIBMi == this.dbInfo_.databaseType_ && StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this.dbInfo_, 6, 1, Character.valueOf('0'));
                this.supportsSelectFromUpdateDelete_ = StaticProfileConstants.DatabaseType.DB2forZOS == this.dbInfo_.databaseType_ && StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this.dbInfo_, 9, 1, Character.valueOf('5')) || StaticProfileConstants.DatabaseType.DB2forLUW == this.dbInfo_.databaseType_ && StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this.dbInfo_, 8, 1, Character.valueOf('4'));
                this.supportsSelectFromMerge_ = StaticProfileConstants.DatabaseType.DB2forZOS == this.dbInfo_.databaseType_ && StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(this.dbInfo_, 9, 1, Character.valueOf('5'));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

